/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.xml.ResultHandlerFactory;
import org.apache.camel.builder.xml.XsltBuilder;
import org.apache.camel.component.xslt.XsltComponent;
import org.apache.camel.component.xslt.XsltHelper;
import org.apache.camel.component.xslt.XsltOutput;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

@ManagedResource(description="Managed XsltEndpoint")
@UriEndpoint(firstVersion="1.3.0", scheme="xslt", title="XSLT", syntax="xslt:resourceUri", producerOnly=true, label="core,transformation")
public class XsltEndpoint
extends ProcessorEndpoint {
    public static final String SAXON_TRANSFORMER_FACTORY_CLASS_NAME = "net.sf.saxon.TransformerFactoryImpl";
    private static final Logger LOG = LoggerFactory.getLogger(XsltEndpoint.class);
    private volatile boolean cacheCleared;
    private volatile XsltBuilder xslt;
    private Map<String, Object> parameters;
    @UriPath
    @Metadata(required="true")
    private String resourceUri;
    @UriParam(defaultValue="true")
    private boolean contentCache = true;
    @UriParam(label="advanced")
    @Deprecated
    private XmlConverter converter;
    @UriParam(label="advanced")
    private String transformerFactoryClass;
    @UriParam(label="advanced")
    private TransformerFactory transformerFactory;
    @UriParam
    private boolean saxon;
    @UriParam(label="advanced")
    private Object saxonConfiguration;
    @Metadata(label="advanced")
    private Map<String, Object> saxonConfigurationProperties = new HashMap<String, Object>();
    @UriParam(label="advanced", javaType="java.lang.String")
    private List<Object> saxonExtensionFunctions;
    @UriParam(label="advanced")
    private ResultHandlerFactory resultHandlerFactory;
    @UriParam(defaultValue="true")
    private boolean failOnNullBody = true;
    @UriParam(defaultValue="string")
    private XsltOutput output = XsltOutput.string;
    @UriParam(defaultValue="0")
    private int transformerCacheSize;
    @UriParam(label="advanced")
    private ErrorListener errorListener;
    @UriParam(label="advanced")
    private URIResolver uriResolver;
    @UriParam(defaultValue="true", displayName="Allow StAX")
    private boolean allowStAX = true;
    @UriParam
    private boolean deleteOutputFile;
    @UriParam(label="advanced")
    private EntityResolver entityResolver;

    @Deprecated
    public XsltEndpoint(String endpointUri, Component component, XsltBuilder xslt, String resourceUri, boolean cacheStylesheet) throws Exception {
        super(endpointUri, component, (Processor)xslt);
        this.xslt = xslt;
        this.resourceUri = resourceUri;
        this.contentCache = cacheStylesheet;
    }

    public XsltEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    @ManagedOperation(description="Clears the cached XSLT stylesheet, forcing to re-load the stylesheet on next request")
    public void clearCachedStylesheet() {
        this.cacheCleared = true;
    }

    @ManagedAttribute(description="Whether the XSLT stylesheet is cached")
    public boolean isCacheStylesheet() {
        return this.contentCache;
    }

    public XsltEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.resourceUri, newResourceUri);
        LOG.trace("Getting endpoint with URI: {}", (Object)newUri);
        return this.getCamelContext().getEndpoint(newUri, XsltEndpoint.class);
    }

    @Override
    protected void onExchange(Exchange exchange) throws Exception {
        if (!this.contentCache || this.cacheCleared) {
            this.loadResource(this.resourceUri);
        }
        super.onExchange(exchange);
    }

    public boolean isCacheCleared() {
        return this.cacheCleared;
    }

    public void setCacheCleared(boolean cacheCleared) {
        this.cacheCleared = cacheCleared;
    }

    public XsltBuilder getXslt() {
        return this.xslt;
    }

    public void setXslt(XsltBuilder xslt) {
        this.xslt = xslt;
    }

    @ManagedAttribute(description="Path to the template")
    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }

    @Deprecated
    public XmlConverter getConverter() {
        return this.converter;
    }

    @Deprecated
    public void setConverter(XmlConverter converter) {
        this.converter = converter;
    }

    public String getTransformerFactoryClass() {
        return this.transformerFactoryClass;
    }

    public void setTransformerFactoryClass(String transformerFactoryClass) {
        this.transformerFactoryClass = transformerFactoryClass;
    }

    public TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    @ManagedAttribute(description="Whether to use Saxon as the transformerFactoryClass")
    public boolean isSaxon() {
        return this.saxon;
    }

    public void setSaxon(boolean saxon) {
        this.saxon = saxon;
    }

    public List<Object> getSaxonExtensionFunctions() {
        return this.saxonExtensionFunctions;
    }

    public void setSaxonExtensionFunctions(List<Object> extensionFunctions) {
        this.saxonExtensionFunctions = extensionFunctions;
    }

    public void setSaxonExtensionFunctions(String extensionFunctions) {
        this.saxonExtensionFunctions = EndpointHelper.resolveReferenceListParameter(this.getCamelContext(), extensionFunctions, Object.class);
    }

    public Object getSaxonConfiguration() {
        return this.saxonConfiguration;
    }

    public void setSaxonConfiguration(Object saxonConfiguration) {
        this.saxonConfiguration = saxonConfiguration;
    }

    public Map<String, Object> getSaxonConfigurationProperties() {
        return this.saxonConfigurationProperties;
    }

    public void setSaxonConfigurationProperties(Map<String, Object> configurationProperties) {
        this.saxonConfigurationProperties = configurationProperties;
    }

    public ResultHandlerFactory getResultHandlerFactory() {
        return this.resultHandlerFactory;
    }

    public void setResultHandlerFactory(ResultHandlerFactory resultHandlerFactory) {
        this.resultHandlerFactory = resultHandlerFactory;
    }

    @ManagedAttribute(description="Whether or not to throw an exception if the input body is null")
    public boolean isFailOnNullBody() {
        return this.failOnNullBody;
    }

    public void setFailOnNullBody(boolean failOnNullBody) {
        this.failOnNullBody = failOnNullBody;
    }

    @ManagedAttribute(description="What kind of option to use.")
    public XsltOutput getOutput() {
        return this.output;
    }

    public void setOutput(XsltOutput output) {
        this.output = output;
    }

    public int getTransformerCacheSize() {
        return this.transformerCacheSize;
    }

    public void setTransformerCacheSize(int transformerCacheSize) {
        this.transformerCacheSize = transformerCacheSize;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    @ManagedAttribute(description="Cache for the resource content (the stylesheet file) when it is loaded.")
    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    @ManagedAttribute(description="Whether to allow using StAX as the javax.xml.transform.Source")
    public boolean isAllowStAX() {
        return this.allowStAX;
    }

    public void setAllowStAX(boolean allowStAX) {
        this.allowStAX = allowStAX;
    }

    public boolean isDeleteOutputFile() {
        return this.deleteOutputFile;
    }

    public void setDeleteOutputFile(boolean deleteOutputFile) {
        this.deleteOutputFile = deleteOutputFile;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    protected void loadResource(String resourceUri) throws TransformerException, IOException {
        LOG.trace("{} loading schema resource: {}", (Object)this, (Object)resourceUri);
        Source source = this.xslt.getUriResolver().resolve(resourceUri, null);
        if (source == null) {
            throw new IOException("Cannot load schema resource " + resourceUri);
        }
        this.xslt.setTransformerSource(source);
        this.cacheCleared = false;
    }

    @Override
    protected void doStart() throws Exception {
        TransformerFactory factory;
        super.doStart();
        CamelContext ctx = this.getCamelContext();
        ClassResolver resolver = ctx.getClassResolver();
        Injector injector = ctx.getInjector();
        LOG.debug("{} using schema resource: {}", (Object)this, (Object)this.resourceUri);
        this.xslt = injector.newInstance(XsltBuilder.class);
        if (this.converter != null) {
            this.xslt.setConverter(this.converter);
        }
        boolean useSaxon = false;
        if (this.transformerFactoryClass == null && (this.saxon || this.saxonExtensionFunctions != null)) {
            useSaxon = true;
            this.transformerFactoryClass = SAXON_TRANSFORMER_FACTORY_CLASS_NAME;
        }
        if ((factory = this.transformerFactory) == null && this.transformerFactoryClass != null) {
            Class<TransformerFactory> factoryClass = resolver.resolveMandatoryClass(this.transformerFactoryClass, TransformerFactory.class, XsltComponent.class.getClassLoader());
            LOG.debug("Using TransformerFactoryClass {}", factoryClass);
            factory = injector.newInstance(factoryClass);
            if (useSaxon) {
                XsltHelper.registerSaxonConfiguration(ctx, factoryClass, factory, this.saxonConfiguration);
                XsltHelper.registerSaxonConfigurationProperties(ctx, factoryClass, factory, this.saxonConfigurationProperties);
                XsltHelper.registerSaxonExtensionFunctions(ctx, factoryClass, factory, this.saxonExtensionFunctions);
            }
        }
        if (factory != null) {
            LOG.debug("Using TransformerFactory {}", (Object)factory);
            this.xslt.getConverter().setTransformerFactory(factory);
        }
        if (this.resultHandlerFactory != null) {
            this.xslt.setResultHandlerFactory(this.resultHandlerFactory);
        }
        if (this.errorListener != null) {
            this.xslt.errorListener(this.errorListener);
        }
        this.xslt.setFailOnNullBody(this.failOnNullBody);
        this.xslt.transformerCacheSize(this.transformerCacheSize);
        this.xslt.setUriResolver(this.uriResolver);
        this.xslt.setEntityResolver(this.entityResolver);
        this.xslt.setAllowStAX(this.allowStAX);
        this.xslt.setDeleteOutputFile(this.deleteOutputFile);
        this.configureOutput(this.xslt, this.output.name());
        if (this.parameters != null) {
            HashMap<String, Object> copy = new HashMap<String, Object>(this.parameters);
            this.xslt.setParameters(copy);
        }
        this.loadResource(this.resourceUri);
        this.setProcessor(this.xslt);
    }

    protected void configureOutput(XsltBuilder xslt, String output) throws Exception {
        if (ObjectHelper.isEmpty(output)) {
            return;
        }
        if ("string".equalsIgnoreCase(output)) {
            xslt.outputString();
        } else if ("bytes".equalsIgnoreCase(output)) {
            xslt.outputBytes();
        } else if ("DOM".equalsIgnoreCase(output)) {
            xslt.outputDOM();
        } else if ("file".equalsIgnoreCase(output)) {
            xslt.outputFile();
        } else {
            throw new IllegalArgumentException("Unknown output type: " + output);
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService(this.xslt);
    }
}

