(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.Popper={}))})(this,function(exports){"use strict";function getWindow(node){if(node==null){return window}if(node.toString()!=="[object Window]"){var ownerDocument=node.ownerDocument;return ownerDocument?ownerDocument.defaultView||window:window}return node}function isElement(node){var OwnElement=getWindow(node).Element;return node instanceof OwnElement||node instanceof Element}function isHTMLElement(node){var OwnElement=getWindow(node).HTMLElement;return node instanceof OwnElement||node instanceof HTMLElement}function isShadowRoot(node){if(typeof ShadowRoot==="undefined"){return false}var OwnElement=getWindow(node).ShadowRoot;return node instanceof OwnElement||node instanceof ShadowRoot}var max=Math.max;var min=Math.min;var round=Math.round;function getUAString(){var uaData=navigator.userAgentData;if(uaData!=null&&uaData.brands&&Array.isArray(uaData.brands)){return uaData.brands.map(function(item){return item.brand+"/"+item.version}).join(" ")}return navigator.userAgent}function isLayoutViewport(){return!/^((?!chrome|android).)*safari/i.test(getUAString())}function getBoundingClientRect(element,includeScale,isFixedStrategy){if(includeScale===void 0){includeScale=false}if(isFixedStrategy===void 0){isFixedStrategy=false}var clientRect=element.getBoundingClientRect();var scaleX=1;var scaleY=1;if(includeScale&&isHTMLElement(element)){scaleX=element.offsetWidth>0?round(clientRect.width)/element.offsetWidth||1:1;scaleY=element.offsetHeight>0?round(clientRect.height)/element.offsetHeight||1:1}var _ref=isElement(element)?getWindow(element):window,visualViewport=_ref.visualViewport;var addVisualOffsets=!isLayoutViewport()&&isFixedStrategy;var x=(clientRect.left+(addVisualOffsets&&visualViewport?visualViewport.offsetLeft:0))/scaleX;var y=(clientRect.top+(addVisualOffsets&&visualViewport?visualViewport.offsetTop:0))/scaleY;var width=clientRect.width/scaleX;var height=clientRect.height/scaleY;return{width:width,height:height,top:y,right:x+width,bottom:y+height,left:x,x:x,y:y}}function getWindowScroll(node){var win=getWindow(node);var scrollLeft=win.pageXOffset;var scrollTop=win.pageYOffset;return{scrollLeft:scrollLeft,scrollTop:scrollTop}}function getHTMLElementScroll(element){return{scrollLeft:element.scrollLeft,scrollTop:element.scrollTop}}function getNodeScroll(node){if(node===getWindow(node)||!isHTMLElement(node)){return getWindowScroll(node)}else{return getHTMLElementScroll(node)}}function getNodeName(element){return element?(element.nodeName||"").toLowerCase():null}function getDocumentElement(element){return((isElement(element)?element.ownerDocument:element.document)||window.document).documentElement}function getWindowScrollBarX(element){return getBoundingClientRect(getDocumentElement(element)).left+getWindowScroll(element).scrollLeft}function getComputedStyle(element){return getWindow(element).getComputedStyle(element)}function isScrollParent(element){var _getComputedStyle=getComputedStyle(element),overflow=_getComputedStyle.overflow,overflowX=_getComputedStyle.overflowX,overflowY=_getComputedStyle.overflowY;return/auto|scroll|overlay|hidden/.test(overflow+overflowY+overflowX)}function isElementScaled(element){var rect=element.getBoundingClientRect();var scaleX=round(rect.width)/element.offsetWidth||1;var scaleY=round(rect.height)/element.offsetHeight||1;return scaleX!==1||scaleY!==1}function getCompositeRect(elementOrVirtualElement,offsetParent,isFixed){if(isFixed===void 0){isFixed=false}var isOffsetParentAnElement=isHTMLElement(offsetParent);var offsetParentIsScaled=isHTMLElement(offsetParent)&&isElementScaled(offsetParent);var documentElement=getDocumentElement(offsetParent);var rect=getBoundingClientRect(elementOrVirtualElement,offsetParentIsScaled,isFixed);var scroll={scrollLeft:0,scrollTop:0};var offsets={x:0,y:0};if(isOffsetParentAnElement||!isOffsetParentAnElement&&!isFixed){if(getNodeName(offsetParent)!=="body"||isScrollParent(documentElement)){scroll=getNodeScroll(offsetParent)}if(isHTMLElement(offsetParent)){offsets=getBoundingClientRect(offsetParent,true);offsets.x+=offsetParent.clientLeft;offsets.y+=offsetParent.clientTop}else if(documentElement){offsets.x=getWindowScrollBarX(documentElement)}}return{x:rect.left+scroll.scrollLeft-offsets.x,y:rect.top+scroll.scrollTop-offsets.y,width:rect.width,height:rect.height}}function getLayoutRect(element){var clientRect=getBoundingClientRect(element);var width=element.offsetWidth;var height=element.offsetHeight;if(Math.abs(clientRect.width-width)<=1){width=clientRect.width}if(Math.abs(clientRect.height-height)<=1){height=clientRect.height}return{x:element.offsetLeft,y:element.offsetTop,width:width,height:height}}function getParentNode(element){if(getNodeName(element)==="html"){return element}return element.assignedSlot||element.parentNode||(isShadowRoot(element)?element.host:null)||getDocumentElement(element)}function getScrollParent(node){if(["html","body","#document"].indexOf(getNodeName(node))>=0){return node.ownerDocument.body}if(isHTMLElement(node)&&isScrollParent(node)){return node}return getScrollParent(getParentNode(node))}function listScrollParents(element,list){var _element$ownerDocumen;if(list===void 0){list=[]}var scrollParent=getScrollParent(element);var isBody=scrollParent===((_element$ownerDocumen=element.ownerDocument)==null?void 0:_element$ownerDocumen.body);var win=getWindow(scrollParent);var target=isBody?[win].concat(win.visualViewport||[],isScrollParent(scrollParent)?scrollParent:[]):scrollParent;var updatedList=list.concat(target);return isBody?updatedList:updatedList.concat(listScrollParents(getParentNode(target)))}function isTableElement(element){return["table","td","th"].indexOf(getNodeName(element))>=0}function getTrueOffsetParent(element){if(!isHTMLElement(element)||getComputedStyle(element).position==="fixed"){return null}return element.offsetParent}function getContainingBlock(element){var isFirefox=/firefox/i.test(getUAString());var isIE=/Trident/i.test(getUAString());if(isIE&&isHTMLElement(element)){var elementCss=getComputedStyle(element);if(elementCss.position==="fixed"){return null}}var currentNode=getParentNode(element);if(isShadowRoot(currentNode)){currentNode=currentNode.host}while(isHTMLElement(currentNode)&&["html","body"].indexOf(getNodeName(currentNode))<0){var css=getComputedStyle(currentNode);if(css.transform!=="none"||css.perspective!=="none"||css.contain==="paint"||["transform","perspective"].indexOf(css.willChange)!==-1||isFirefox&&css.willChange==="filter"||isFirefox&&css.filter&&css.filter!=="none"){return currentNode}else{currentNode=currentNode.parentNode}}return null}function getOffsetParent(element){var window=getWindow(element);var offsetParent=getTrueOffsetParent(element);while(offsetParent&&isTableElement(offsetParent)&&getComputedStyle(offsetParent).position==="static"){offsetParent=getTrueOffsetParent(offsetParent)}if(offsetParent&&(getNodeName(offsetParent)==="html"||getNodeName(offsetParent)==="body"&&getComputedStyle(offsetParent).position==="static")){return window}return offsetParent||getContainingBlock(element)||window}var top="top";var bottom="bottom";var right="right";var left="left";var auto="auto";var basePlacements=[top,bottom,right,left];var start="start";var end="end";var clippingParents="clippingParents";var viewport="viewport";var popper="popper";var reference="reference";var variationPlacements=basePlacements.reduce(function(acc,placement){return acc.concat([placement+"-"+start,placement+"-"+end])},[]);var placements=[].concat(basePlacements,[auto]).reduce(function(acc,placement){return acc.concat([placement,placement+"-"+start,placement+"-"+end])},[]);var beforeRead="beforeRead";var read="read";var afterRead="afterRead";var beforeMain="beforeMain";var main="main";var afterMain="afterMain";var beforeWrite="beforeWrite";var write="write";var afterWrite="afterWrite";var modifierPhases=[beforeRead,read,afterRead,beforeMain,main,afterMain,beforeWrite,write,afterWrite];function order(modifiers){var map=new Map;var visited=new Set;var result=[];modifiers.forEach(function(modifier){map.set(modifier.name,modifier)});function sort(modifier){visited.add(modifier.name);var requires=[].concat(modifier.requires||[],modifier.requiresIfExists||[]);requires.forEach(function(dep){if(!visited.has(dep)){var depModifier=map.get(dep);if(depModifier){sort(depModifier)}}});result.push(modifier)}modifiers.forEach(function(modifier){if(!visited.has(modifier.name)){sort(modifier)}});return result}function orderModifiers(modifiers){var orderedModifiers=order(modifiers);return modifierPhases.reduce(function(acc,phase){return acc.concat(orderedModifiers.filter(function(modifier){return modifier.phase===phase}))},[])}function debounce(fn){var pending;return function(){if(!pending){pending=new Promise(function(resolve){Promise.resolve().then(function(){pending=undefined;resolve(fn())})})}return pending}}function mergeByName(modifiers){var merged=modifiers.reduce(function(merged,current){var existing=merged[current.name];merged[current.name]=existing?Object.assign({},existing,current,{options:Object.assign({},existing.options,current.options),data:Object.assign({},existing.data,current.data)}):current;return merged},{});return Object.keys(merged).map(function(key){return merged[key]})}function getViewportRect(element,strategy){var win=getWindow(element);var html=getDocumentElement(element);var visualViewport=win.visualViewport;var width=html.clientWidth;var height=html.clientHeight;var x=0;var y=0;if(visualViewport){width=visualViewport.width;height=visualViewport.height;var layoutViewport=isLayoutViewport();if(layoutViewport||!layoutViewport&&strategy==="fixed"){x=visualViewport.offsetLeft;y=visualViewport.offsetTop}}return{width:width,height:height,x:x+getWindowScrollBarX(element),y:y}}function getDocumentRect(element){var _element$ownerDocumen;var html=getDocumentElement(element);var winScroll=getWindowScroll(element);var body=(_element$ownerDocumen=element.ownerDocument)==null?void 0:_element$ownerDocumen.body;var width=max(html.scrollWidth,html.clientWidth,body?body.scrollWidth:0,body?body.clientWidth:0);var height=max(html.scrollHeight,html.clientHeight,body?body.scrollHeight:0,body?body.clientHeight:0);var x=-winScroll.scrollLeft+getWindowScrollBarX(element);var y=-winScroll.scrollTop;if(getComputedStyle(body||html).direction==="rtl"){x+=max(html.clientWidth,body?body.clientWidth:0)-width}return{width:width,height:height,x:x,y:y}}function contains(parent,child){var rootNode=child.getRootNode&&child.getRootNode();if(parent.contains(child)){return true}else if(rootNode&&isShadowRoot(rootNode)){var next=child;do{if(next&&parent.isSameNode(next)){return true}next=next.parentNode||next.host}while(next)}return false}function rectToClientRect(rect){return Object.assign({},rect,{left:rect.x,top:rect.y,right:rect.x+rect.width,bottom:rect.y+rect.height})}function getInnerBoundingClientRect(element,strategy){var rect=getBoundingClientRect(element,false,strategy==="fixed");rect.top=rect.top+element.clientTop;rect.left=rect.left+element.clientLeft;rect.bottom=rect.top+element.clientHeight;rect.right=rect.left+element.clientWidth;rect.width=element.clientWidth;rect.height=element.clientHeight;rect.x=rect.left;rect.y=rect.top;return rect}function getClientRectFromMixedType(element,clippingParent,strategy){return clippingParent===viewport?rectToClientRect(getViewportRect(element,strategy)):isElement(clippingParent)?getInnerBoundingClientRect(clippingParent,strategy):rectToClientRect(getDocumentRect(getDocumentElement(element)))}function getClippingParents(element){var clippingParents=listScrollParents(getParentNode(element));var canEscapeClipping=["absolute","fixed"].indexOf(getComputedStyle(element).position)>=0;var clipperElement=canEscapeClipping&&isHTMLElement(element)?getOffsetParent(element):element;if(!isElement(clipperElement)){return[]}return clippingParents.filter(function(clippingParent){return isElement(clippingParent)&&contains(clippingParent,clipperElement)&&getNodeName(clippingParent)!=="body"})}function getClippingRect(element,boundary,rootBoundary,strategy){var mainClippingParents=boundary==="clippingParents"?getClippingParents(element):[].concat(boundary);var clippingParents=[].concat(mainClippingParents,[rootBoundary]);var firstClippingParent=clippingParents[0];var clippingRect=clippingParents.reduce(function(accRect,clippingParent){var rect=getClientRectFromMixedType(element,clippingParent,strategy);accRect.top=max(rect.top,accRect.top);accRect.right=min(rect.right,accRect.right);accRect.bottom=min(rect.bottom,accRect.bottom);accRect.left=max(rect.left,accRect.left);return accRect},getClientRectFromMixedType(element,firstClippingParent,strategy));clippingRect.width=clippingRect.right-clippingRect.left;clippingRect.height=clippingRect.bottom-clippingRect.top;clippingRect.x=clippingRect.left;clippingRect.y=clippingRect.top;return clippingRect}function getBasePlacement(placement){return placement.split("-")[0]}function getVariation(placement){return placement.split("-")[1]}function getMainAxisFromPlacement(placement){return["top","bottom"].indexOf(placement)>=0?"x":"y"}function computeOffsets(_ref){var reference=_ref.reference,element=_ref.element,placement=_ref.placement;var basePlacement=placement?getBasePlacement(placement):null;var variation=placement?getVariation(placement):null;var commonX=reference.x+reference.width/2-element.width/2;var commonY=reference.y+reference.height/2-element.height/2;var offsets;switch(basePlacement){case top:offsets={x:commonX,y:reference.y-element.height};break;case bottom:offsets={x:commonX,y:reference.y+reference.height};break;case right:offsets={x:reference.x+reference.width,y:commonY};break;case left:offsets={x:reference.x-element.width,y:commonY};break;default:offsets={x:reference.x,y:reference.y}}var mainAxis=basePlacement?getMainAxisFromPlacement(basePlacement):null;if(mainAxis!=null){var len=mainAxis==="y"?"height":"width";switch(variation){case start:offsets[mainAxis]=offsets[mainAxis]-(reference[len]/2-element[len]/2);break;case end:offsets[mainAxis]=offsets[mainAxis]+(reference[len]/2-element[len]/2);break}}return offsets}function getFreshSideObject(){return{top:0,right:0,bottom:0,left:0}}function mergePaddingObject(paddingObject){return Object.assign({},getFreshSideObject(),paddingObject)}function expandToHashMap(value,keys){return keys.reduce(function(hashMap,key){hashMap[key]=value;return hashMap},{})}function detectOverflow(state,options){if(options===void 0){options={}}var _options=options,_options$placement=_options.placement,placement=_options$placement===void 0?state.placement:_options$placement,_options$strategy=_options.strategy,strategy=_options$strategy===void 0?state.strategy:_options$strategy,_options$boundary=_options.boundary,boundary=_options$boundary===void 0?clippingParents:_options$boundary,_options$rootBoundary=_options.rootBoundary,rootBoundary=_options$rootBoundary===void 0?viewport:_options$rootBoundary,_options$elementConte=_options.elementContext,elementContext=_options$elementConte===void 0?popper:_options$elementConte,_options$altBoundary=_options.altBoundary,altBoundary=_options$altBoundary===void 0?false:_options$altBoundary,_options$padding=_options.padding,padding=_options$padding===void 0?0:_options$padding;var paddingObject=mergePaddingObject(typeof padding!=="number"?padding:expandToHashMap(padding,basePlacements));var altContext=elementContext===popper?reference:popper;var popperRect=state.rects.popper;var element=state.elements[altBoundary?altContext:elementContext];var clippingClientRect=getClippingRect(isElement(element)?element:element.contextElement||getDocumentElement(state.elements.popper),boundary,rootBoundary,strategy);var referenceClientRect=getBoundingClientRect(state.elements.reference);var popperOffsets=computeOffsets({reference:referenceClientRect,element:popperRect,strategy:"absolute",placement:placement});var popperClientRect=rectToClientRect(Object.assign({},popperRect,popperOffsets));var elementClientRect=elementContext===popper?popperClientRect:referenceClientRect;var overflowOffsets={top:clippingClientRect.top-elementClientRect.top+paddingObject.top,bottom:elementClientRect.bottom-clippingClientRect.bottom+paddingObject.bottom,left:clippingClientRect.left-elementClientRect.left+paddingObject.left,right:elementClientRect.right-clippingClientRect.right+paddingObject.right};var offsetData=state.modifiersData.offset;if(elementContext===popper&&offsetData){var offset=offsetData[placement];Object.keys(overflowOffsets).forEach(function(key){var multiply=[right,bottom].indexOf(key)>=0?1:-1;var axis=[top,bottom].indexOf(key)>=0?"y":"x";overflowOffsets[key]+=offset[axis]*multiply})}return overflowOffsets}var DEFAULT_OPTIONS={placement:"bottom",modifiers:[],strategy:"absolute"};function areValidElements(){for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}return!args.some(function(element){return!(element&&typeof element.getBoundingClientRect==="function")})}function popperGenerator(generatorOptions){if(generatorOptions===void 0){generatorOptions={}}var _generatorOptions=generatorOptions,_generatorOptions$def=_generatorOptions.defaultModifiers,defaultModifiers=_generatorOptions$def===void 0?[]:_generatorOptions$def,_generatorOptions$def2=_generatorOptions.defaultOptions,defaultOptions=_generatorOptions$def2===void 0?DEFAULT_OPTIONS:_generatorOptions$def2;return function createPopper(reference,popper,options){if(options===void 0){options=defaultOptions}var state={placement:"bottom",orderedModifiers:[],options:Object.assign({},DEFAULT_OPTIONS,defaultOptions),modifiersData:{},elements:{reference:reference,popper:popper},attributes:{},styles:{}};var effectCleanupFns=[];var isDestroyed=false;var instance={state:state,setOptions:function setOptions(setOptionsAction){var options=typeof setOptionsAction==="function"?setOptionsAction(state.options):setOptionsAction;cleanupModifierEffects();state.options=Object.assign({},defaultOptions,state.options,options);state.scrollParents={reference:isElement(reference)?listScrollParents(reference):reference.contextElement?listScrollParents(reference.contextElement):[],popper:listScrollParents(popper)};var orderedModifiers=orderModifiers(mergeByName([].concat(defaultModifiers,state.options.modifiers)));state.orderedModifiers=orderedModifiers.filter(function(m){return m.enabled});runModifierEffects();return instance.update()},forceUpdate:function forceUpdate(){if(isDestroyed){return}var _state$elements=state.elements,reference=_state$elements.reference,popper=_state$elements.popper;if(!areValidElements(reference,popper)){return}state.rects={reference:getCompositeRect(reference,getOffsetParent(popper),state.options.strategy==="fixed"),popper:getLayoutRect(popper)};state.reset=false;state.placement=state.options.placement;state.orderedModifiers.forEach(function(modifier){return state.modifiersData[modifier.name]=Object.assign({},modifier.data)});for(var index=0;index<state.orderedModifiers.length;index++){if(state.reset===true){state.reset=false;index=-1;continue}var _state$orderedModifie=state.orderedModifiers[index],fn=_state$orderedModifie.fn,_state$orderedModifie2=_state$orderedModifie.options,_options=_state$orderedModifie2===void 0?{}:_state$orderedModifie2,name=_state$orderedModifie.name;if(typeof fn==="function"){state=fn({state:state,options:_options,name:name,instance:instance})||state}}},update:debounce(function(){return new Promise(function(resolve){instance.forceUpdate();resolve(state)})}),destroy:function destroy(){cleanupModifierEffects();isDestroyed=true}};if(!areValidElements(reference,popper)){return instance}instance.setOptions(options).then(function(state){if(!isDestroyed&&options.onFirstUpdate){options.onFirstUpdate(state)}});function runModifierEffects(){state.orderedModifiers.forEach(function(_ref){var name=_ref.name,_ref$options=_ref.options,options=_ref$options===void 0?{}:_ref$options,effect=_ref.effect;if(typeof effect==="function"){var cleanupFn=effect({state:state,name:name,instance:instance,options:options});var noopFn=function noopFn(){};effectCleanupFns.push(cleanupFn||noopFn)}})}function cleanupModifierEffects(){effectCleanupFns.forEach(function(fn){return fn()});effectCleanupFns=[]}return instance}}var passive={passive:true};function effect$2(_ref){var state=_ref.state,instance=_ref.instance,options=_ref.options;var _options$scroll=options.scroll,scroll=_options$scroll===void 0?true:_options$scroll,_options$resize=options.resize,resize=_options$resize===void 0?true:_options$resize;var window=getWindow(state.elements.popper);var scrollParents=[].concat(state.scrollParents.reference,state.scrollParents.popper);if(scroll){scrollParents.forEach(function(scrollParent){scrollParent.addEventListener("scroll",instance.update,passive)})}if(resize){window.addEventListener("resize",instance.update,passive)}return function(){if(scroll){scrollParents.forEach(function(scrollParent){scrollParent.removeEventListener("scroll",instance.update,passive)})}if(resize){window.removeEventListener("resize",instance.update,passive)}}}var eventListeners={name:"eventListeners",enabled:true,phase:"write",fn:function fn(){},effect:effect$2,data:{}};function popperOffsets(_ref){var state=_ref.state,name=_ref.name;state.modifiersData[name]=computeOffsets({reference:state.rects.reference,element:state.rects.popper,strategy:"absolute",placement:state.placement})}var popperOffsets$1={name:"popperOffsets",enabled:true,phase:"read",fn:popperOffsets,data:{}};var unsetSides={top:"auto",right:"auto",bottom:"auto",left:"auto"};function roundOffsetsByDPR(_ref,win){var x=_ref.x,y=_ref.y;var dpr=win.devicePixelRatio||1;return{x:round(x*dpr)/dpr||0,y:round(y*dpr)/dpr||0}}function mapToStyles(_ref2){var _Object$assign2;var popper=_ref2.popper,popperRect=_ref2.popperRect,placement=_ref2.placement,variation=_ref2.variation,offsets=_ref2.offsets,position=_ref2.position,gpuAcceleration=_ref2.gpuAcceleration,adaptive=_ref2.adaptive,roundOffsets=_ref2.roundOffsets,isFixed=_ref2.isFixed;var _offsets$x=offsets.x,x=_offsets$x===void 0?0:_offsets$x,_offsets$y=offsets.y,y=_offsets$y===void 0?0:_offsets$y;var _ref3=typeof roundOffsets==="function"?roundOffsets({x:x,y:y}):{x:x,y:y};x=_ref3.x;y=_ref3.y;var hasX=offsets.hasOwnProperty("x");var hasY=offsets.hasOwnProperty("y");var sideX=left;var sideY=top;var win=window;if(adaptive){var offsetParent=getOffsetParent(popper);var heightProp="clientHeight";var widthProp="clientWidth";if(offsetParent===getWindow(popper)){offsetParent=getDocumentElement(popper);if(getComputedStyle(offsetParent).position!=="static"&&position==="absolute"){heightProp="scrollHeight";widthProp="scrollWidth"}}offsetParent=offsetParent;if(placement===top||(placement===left||placement===right)&&variation===end){sideY=bottom;var offsetY=isFixed&&offsetParent===win&&win.visualViewport?win.visualViewport.height:offsetParent[heightProp];y-=offsetY-popperRect.height;y*=gpuAcceleration?1:-1}if(placement===left||(placement===top||placement===bottom)&&variation===end){sideX=right;var offsetX=isFixed&&offsetParent===win&&win.visualViewport?win.visualViewport.width:offsetParent[widthProp];x-=offsetX-popperRect.width;x*=gpuAcceleration?1:-1}}var commonStyles=Object.assign({position:position},adaptive&&unsetSides);var _ref4=roundOffsets===true?roundOffsetsByDPR({x:x,y:y},getWindow(popper)):{x:x,y:y};x=_ref4.x;y=_ref4.y;if(gpuAcceleration){var _Object$assign;return Object.assign({},commonStyles,(_Object$assign={},_Object$assign[sideY]=hasY?"0":"",_Object$assign[sideX]=hasX?"0":"",_Object$assign.transform=(win.devicePixelRatio||1)<=1?"translate("+x+"px, "+y+"px)":"translate3d("+x+"px, "+y+"px, 0)",_Object$assign))}return Object.assign({},commonStyles,(_Object$assign2={},_Object$assign2[sideY]=hasY?y+"px":"",_Object$assign2[sideX]=hasX?x+"px":"",_Object$assign2.transform="",_Object$assign2))}function computeStyles(_ref5){var state=_ref5.state,options=_ref5.options;var _options$gpuAccelerat=options.gpuAcceleration,gpuAcceleration=_options$gpuAccelerat===void 0?true:_options$gpuAccelerat,_options$adaptive=options.adaptive,adaptive=_options$adaptive===void 0?true:_options$adaptive,_options$roundOffsets=options.roundOffsets,roundOffsets=_options$roundOffsets===void 0?true:_options$roundOffsets;var commonStyles={placement:getBasePlacement(state.placement),variation:getVariation(state.placement),popper:state.elements.popper,popperRect:state.rects.popper,gpuAcceleration:gpuAcceleration,isFixed:state.options.strategy==="fixed"};if(state.modifiersData.popperOffsets!=null){state.styles.popper=Object.assign({},state.styles.popper,mapToStyles(Object.assign({},commonStyles,{offsets:state.modifiersData.popperOffsets,position:state.options.strategy,adaptive:adaptive,roundOffsets:roundOffsets})))}if(state.modifiersData.arrow!=null){state.styles.arrow=Object.assign({},state.styles.arrow,mapToStyles(Object.assign({},commonStyles,{offsets:state.modifiersData.arrow,position:"absolute",adaptive:false,roundOffsets:roundOffsets})))}state.attributes.popper=Object.assign({},state.attributes.popper,{"data-popper-placement":state.placement})}var computeStyles$1={name:"computeStyles",enabled:true,phase:"beforeWrite",fn:computeStyles,data:{}};function applyStyles(_ref){var state=_ref.state;Object.keys(state.elements).forEach(function(name){var style=state.styles[name]||{};var attributes=state.attributes[name]||{};var element=state.elements[name];if(!isHTMLElement(element)||!getNodeName(element)){return}Object.assign(element.style,style);Object.keys(attributes).forEach(function(name){var value=attributes[name];if(value===false){element.removeAttribute(name)}else{element.setAttribute(name,value===true?"":value)}})})}function effect$1(_ref2){var state=_ref2.state;var initialStyles={popper:{position:state.options.strategy,left:"0",top:"0",margin:"0"},arrow:{position:"absolute"},reference:{}};Object.assign(state.elements.popper.style,initialStyles.popper);state.styles=initialStyles;if(state.elements.arrow){Object.assign(state.elements.arrow.style,initialStyles.arrow)}return function(){Object.keys(state.elements).forEach(function(name){var element=state.elements[name];var attributes=state.attributes[name]||{};var styleProperties=Object.keys(state.styles.hasOwnProperty(name)?state.styles[name]:initialStyles[name]);var style=styleProperties.reduce(function(style,property){style[property]="";return style},{});if(!isHTMLElement(element)||!getNodeName(element)){return}Object.assign(element.style,style);Object.keys(attributes).forEach(function(attribute){element.removeAttribute(attribute)})})}}var applyStyles$1={name:"applyStyles",enabled:true,phase:"write",fn:applyStyles,effect:effect$1,requires:["computeStyles"]};function distanceAndSkiddingToXY(placement,rects,offset){var basePlacement=getBasePlacement(placement);var invertDistance=[left,top].indexOf(basePlacement)>=0?-1:1;var _ref=typeof offset==="function"?offset(Object.assign({},rects,{placement:placement})):offset,skidding=_ref[0],distance=_ref[1];skidding=skidding||0;distance=(distance||0)*invertDistance;return[left,right].indexOf(basePlacement)>=0?{x:distance,y:skidding}:{x:skidding,y:distance}}function offset(_ref2){var state=_ref2.state,options=_ref2.options,name=_ref2.name;var _options$offset=options.offset,offset=_options$offset===void 0?[0,0]:_options$offset;var data=placements.reduce(function(acc,placement){acc[placement]=distanceAndSkiddingToXY(placement,state.rects,offset);return acc},{});var _data$state$placement=data[state.placement],x=_data$state$placement.x,y=_data$state$placement.y;if(state.modifiersData.popperOffsets!=null){state.modifiersData.popperOffsets.x+=x;state.modifiersData.popperOffsets.y+=y}state.modifiersData[name]=data}var offset$1={name:"offset",enabled:true,phase:"main",requires:["popperOffsets"],fn:offset};var hash$1={left:"right",right:"left",bottom:"top",top:"bottom"};function getOppositePlacement(placement){return placement.replace(/left|right|bottom|top/g,function(matched){return hash$1[matched]})}var hash={start:"end",end:"start"};function getOppositeVariationPlacement(placement){return placement.replace(/start|end/g,function(matched){return hash[matched]})}function computeAutoPlacement(state,options){if(options===void 0){options={}}var _options=options,placement=_options.placement,boundary=_options.boundary,rootBoundary=_options.rootBoundary,padding=_options.padding,flipVariations=_options.flipVariations,_options$allowedAutoP=_options.allowedAutoPlacements,allowedAutoPlacements=_options$allowedAutoP===void 0?placements:_options$allowedAutoP;var variation=getVariation(placement);var placements$1=variation?flipVariations?variationPlacements:variationPlacements.filter(function(placement){return getVariation(placement)===variation}):basePlacements;var allowedPlacements=placements$1.filter(function(placement){return allowedAutoPlacements.indexOf(placement)>=0});if(allowedPlacements.length===0){allowedPlacements=placements$1}var overflows=allowedPlacements.reduce(function(acc,placement){acc[placement]=detectOverflow(state,{placement:placement,boundary:boundary,rootBoundary:rootBoundary,padding:padding})[getBasePlacement(placement)];return acc},{});return Object.keys(overflows).sort(function(a,b){return overflows[a]-overflows[b]})}function getExpandedFallbackPlacements(placement){if(getBasePlacement(placement)===auto){return[]}var oppositePlacement=getOppositePlacement(placement);return[getOppositeVariationPlacement(placement),oppositePlacement,getOppositeVariationPlacement(oppositePlacement)]}function flip(_ref){var state=_ref.state,options=_ref.options,name=_ref.name;if(state.modifiersData[name]._skip){return}var _options$mainAxis=options.mainAxis,checkMainAxis=_options$mainAxis===void 0?true:_options$mainAxis,_options$altAxis=options.altAxis,checkAltAxis=_options$altAxis===void 0?true:_options$altAxis,specifiedFallbackPlacements=options.fallbackPlacements,padding=options.padding,boundary=options.boundary,rootBoundary=options.rootBoundary,altBoundary=options.altBoundary,_options$flipVariatio=options.flipVariations,flipVariations=_options$flipVariatio===void 0?true:_options$flipVariatio,allowedAutoPlacements=options.allowedAutoPlacements;var preferredPlacement=state.options.placement;var basePlacement=getBasePlacement(preferredPlacement);var isBasePlacement=basePlacement===preferredPlacement;var fallbackPlacements=specifiedFallbackPlacements||(isBasePlacement||!flipVariations?[getOppositePlacement(preferredPlacement)]:getExpandedFallbackPlacements(preferredPlacement));var placements=[preferredPlacement].concat(fallbackPlacements).reduce(function(acc,placement){return acc.concat(getBasePlacement(placement)===auto?computeAutoPlacement(state,{placement:placement,boundary:boundary,rootBoundary:rootBoundary,padding:padding,flipVariations:flipVariations,allowedAutoPlacements:allowedAutoPlacements}):placement)},[]);var referenceRect=state.rects.reference;var popperRect=state.rects.popper;var checksMap=new Map;var makeFallbackChecks=true;var firstFittingPlacement=placements[0];for(var i=0;i<placements.length;i++){var placement=placements[i];var _basePlacement=getBasePlacement(placement);var isStartVariation=getVariation(placement)===start;var isVertical=[top,bottom].indexOf(_basePlacement)>=0;var len=isVertical?"width":"height";var overflow=detectOverflow(state,{placement:placement,boundary:boundary,rootBoundary:rootBoundary,altBoundary:altBoundary,padding:padding});var mainVariationSide=isVertical?isStartVariation?right:left:isStartVariation?bottom:top;if(referenceRect[len]>popperRect[len]){mainVariationSide=getOppositePlacement(mainVariationSide)}var altVariationSide=getOppositePlacement(mainVariationSide);var checks=[];if(checkMainAxis){checks.push(overflow[_basePlacement]<=0)}if(checkAltAxis){checks.push(overflow[mainVariationSide]<=0,overflow[altVariationSide]<=0)}if(checks.every(function(check){return check})){firstFittingPlacement=placement;makeFallbackChecks=false;break}checksMap.set(placement,checks)}if(makeFallbackChecks){var numberOfChecks=flipVariations?3:1;var _loop=function _loop(_i){var fittingPlacement=placements.find(function(placement){var checks=checksMap.get(placement);if(checks){return checks.slice(0,_i).every(function(check){return check})}});if(fittingPlacement){firstFittingPlacement=fittingPlacement;return"break"}};for(var _i=numberOfChecks;_i>0;_i--){var _ret=_loop(_i);if(_ret==="break")break}}if(state.placement!==firstFittingPlacement){state.modifiersData[name]._skip=true;state.placement=firstFittingPlacement;state.reset=true}}var flip$1={name:"flip",enabled:true,phase:"main",fn:flip,requiresIfExists:["offset"],data:{_skip:false}};function getAltAxis(axis){return axis==="x"?"y":"x"}function within(min$1,value,max$1){return max(min$1,min(value,max$1))}function withinMaxClamp(min,value,max){var v=within(min,value,max);return v>max?max:v}function preventOverflow(_ref){var state=_ref.state,options=_ref.options,name=_ref.name;var _options$mainAxis=options.mainAxis,checkMainAxis=_options$mainAxis===void 0?true:_options$mainAxis,_options$altAxis=options.altAxis,checkAltAxis=_options$altAxis===void 0?false:_options$altAxis,boundary=options.boundary,rootBoundary=options.rootBoundary,altBoundary=options.altBoundary,padding=options.padding,_options$tether=options.tether,tether=_options$tether===void 0?true:_options$tether,_options$tetherOffset=options.tetherOffset,tetherOffset=_options$tetherOffset===void 0?0:_options$tetherOffset;var overflow=detectOverflow(state,{boundary:boundary,rootBoundary:rootBoundary,padding:padding,altBoundary:altBoundary});var basePlacement=getBasePlacement(state.placement);var variation=getVariation(state.placement);var isBasePlacement=!variation;var mainAxis=getMainAxisFromPlacement(basePlacement);var altAxis=getAltAxis(mainAxis);var popperOffsets=state.modifiersData.popperOffsets;var referenceRect=state.rects.reference;var popperRect=state.rects.popper;var tetherOffsetValue=typeof tetherOffset==="function"?tetherOffset(Object.assign({},state.rects,{placement:state.placement})):tetherOffset;var normalizedTetherOffsetValue=typeof tetherOffsetValue==="number"?{mainAxis:tetherOffsetValue,altAxis:tetherOffsetValue}:Object.assign({mainAxis:0,altAxis:0},tetherOffsetValue);var offsetModifierState=state.modifiersData.offset?state.modifiersData.offset[state.placement]:null;var data={x:0,y:0};if(!popperOffsets){return}if(checkMainAxis){var _offsetModifierState$;var mainSide=mainAxis==="y"?top:left;var altSide=mainAxis==="y"?bottom:right;var len=mainAxis==="y"?"height":"width";var offset=popperOffsets[mainAxis];var min$1=offset+overflow[mainSide];var max$1=offset-overflow[altSide];var additive=tether?-popperRect[len]/2:0;var minLen=variation===start?referenceRect[len]:popperRect[len];var maxLen=variation===start?-popperRect[len]:-referenceRect[len];var arrowElement=state.elements.arrow;var arrowRect=tether&&arrowElement?getLayoutRect(arrowElement):{width:0,height:0};var arrowPaddingObject=state.modifiersData["arrow#persistent"]?state.modifiersData["arrow#persistent"].padding:getFreshSideObject();var arrowPaddingMin=arrowPaddingObject[mainSide];var arrowPaddingMax=arrowPaddingObject[altSide];var arrowLen=within(0,referenceRect[len],arrowRect[len]);var minOffset=isBasePlacement?referenceRect[len]/2-additive-arrowLen-arrowPaddingMin-normalizedTetherOffsetValue.mainAxis:minLen-arrowLen-arrowPaddingMin-normalizedTetherOffsetValue.mainAxis;var maxOffset=isBasePlacement?-referenceRect[len]/2+additive+arrowLen+arrowPaddingMax+normalizedTetherOffsetValue.mainAxis:maxLen+arrowLen+arrowPaddingMax+normalizedTetherOffsetValue.mainAxis;var arrowOffsetParent=state.elements.arrow&&getOffsetParent(state.elements.arrow);var clientOffset=arrowOffsetParent?mainAxis==="y"?arrowOffsetParent.clientTop||0:arrowOffsetParent.clientLeft||0:0;var offsetModifierValue=(_offsetModifierState$=offsetModifierState==null?void 0:offsetModifierState[mainAxis])!=null?_offsetModifierState$:0;var tetherMin=offset+minOffset-offsetModifierValue-clientOffset;var tetherMax=offset+maxOffset-offsetModifierValue;var preventedOffset=within(tether?min(min$1,tetherMin):min$1,offset,tether?max(max$1,tetherMax):max$1);popperOffsets[mainAxis]=preventedOffset;data[mainAxis]=preventedOffset-offset}if(checkAltAxis){var _offsetModifierState$2;var _mainSide=mainAxis==="x"?top:left;var _altSide=mainAxis==="x"?bottom:right;var _offset=popperOffsets[altAxis];var _len=altAxis==="y"?"height":"width";var _min=_offset+overflow[_mainSide];var _max=_offset-overflow[_altSide];var isOriginSide=[top,left].indexOf(basePlacement)!==-1;var _offsetModifierValue=(_offsetModifierState$2=offsetModifierState==null?void 0:offsetModifierState[altAxis])!=null?_offsetModifierState$2:0;var _tetherMin=isOriginSide?_min:_offset-referenceRect[_len]-popperRect[_len]-_offsetModifierValue+normalizedTetherOffsetValue.altAxis;var _tetherMax=isOriginSide?_offset+referenceRect[_len]+popperRect[_len]-_offsetModifierValue-normalizedTetherOffsetValue.altAxis:_max;var _preventedOffset=tether&&isOriginSide?withinMaxClamp(_tetherMin,_offset,_tetherMax):within(tether?_tetherMin:_min,_offset,tether?_tetherMax:_max);popperOffsets[altAxis]=_preventedOffset;data[altAxis]=_preventedOffset-_offset}state.modifiersData[name]=data}var preventOverflow$1={name:"preventOverflow",enabled:true,phase:"main",fn:preventOverflow,requiresIfExists:["offset"]};var toPaddingObject=function toPaddingObject(padding,state){padding=typeof padding==="function"?padding(Object.assign({},state.rects,{placement:state.placement})):padding;return mergePaddingObject(typeof padding!=="number"?padding:expandToHashMap(padding,basePlacements))};function arrow(_ref){var _state$modifiersData$;var state=_ref.state,name=_ref.name,options=_ref.options;var arrowElement=state.elements.arrow;var popperOffsets=state.modifiersData.popperOffsets;var basePlacement=getBasePlacement(state.placement);var axis=getMainAxisFromPlacement(basePlacement);var isVertical=[left,right].indexOf(basePlacement)>=0;var len=isVertical?"height":"width";if(!arrowElement||!popperOffsets){return}var paddingObject=toPaddingObject(options.padding,state);var arrowRect=getLayoutRect(arrowElement);var minProp=axis==="y"?top:left;var maxProp=axis==="y"?bottom:right;var endDiff=state.rects.reference[len]+state.rects.reference[axis]-popperOffsets[axis]-state.rects.popper[len];var startDiff=popperOffsets[axis]-state.rects.reference[axis];var arrowOffsetParent=getOffsetParent(arrowElement);var clientSize=arrowOffsetParent?axis==="y"?arrowOffsetParent.clientHeight||0:arrowOffsetParent.clientWidth||0:0;var centerToReference=endDiff/2-startDiff/2;var min=paddingObject[minProp];var max=clientSize-arrowRect[len]-paddingObject[maxProp];var center=clientSize/2-arrowRect[len]/2+centerToReference;var offset=within(min,center,max);var axisProp=axis;state.modifiersData[name]=(_state$modifiersData$={},_state$modifiersData$[axisProp]=offset,_state$modifiersData$.centerOffset=offset-center,_state$modifiersData$)}function effect(_ref2){var state=_ref2.state,options=_ref2.options;var _options$element=options.element,arrowElement=_options$element===void 0?"[data-popper-arrow]":_options$element;if(arrowElement==null){return}if(typeof arrowElement==="string"){arrowElement=state.elements.popper.querySelector(arrowElement);if(!arrowElement){return}}if(!contains(state.elements.popper,arrowElement)){return}state.elements.arrow=arrowElement}var arrow$1={name:"arrow",enabled:true,phase:"main",fn:arrow,effect:effect,requires:["popperOffsets"],requiresIfExists:["preventOverflow"]};function getSideOffsets(overflow,rect,preventedOffsets){if(preventedOffsets===void 0){preventedOffsets={x:0,y:0}}return{top:overflow.top-rect.height-preventedOffsets.y,right:overflow.right-rect.width+preventedOffsets.x,bottom:overflow.bottom-rect.height+preventedOffsets.y,left:overflow.left-rect.width-preventedOffsets.x}}function isAnySideFullyClipped(overflow){return[top,right,bottom,left].some(function(side){return overflow[side]>=0})}function hide(_ref){var state=_ref.state,name=_ref.name;var referenceRect=state.rects.reference;var popperRect=state.rects.popper;var preventedOffsets=state.modifiersData.preventOverflow;var referenceOverflow=detectOverflow(state,{elementContext:"reference"});var popperAltOverflow=detectOverflow(state,{altBoundary:true});var referenceClippingOffsets=getSideOffsets(referenceOverflow,referenceRect);var popperEscapeOffsets=getSideOffsets(popperAltOverflow,popperRect,preventedOffsets);var isReferenceHidden=isAnySideFullyClipped(referenceClippingOffsets);var hasPopperEscaped=isAnySideFullyClipped(popperEscapeOffsets);state.modifiersData[name]={referenceClippingOffsets:referenceClippingOffsets,popperEscapeOffsets:popperEscapeOffsets,isReferenceHidden:isReferenceHidden,hasPopperEscaped:hasPopperEscaped};state.attributes.popper=Object.assign({},state.attributes.popper,{"data-popper-reference-hidden":isReferenceHidden,"data-popper-escaped":hasPopperEscaped})}var hide$1={name:"hide",enabled:true,phase:"main",requiresIfExists:["preventOverflow"],fn:hide};var defaultModifiers$1=[eventListeners,popperOffsets$1,computeStyles$1,applyStyles$1];var createPopper$1=popperGenerator({defaultModifiers:defaultModifiers$1});var defaultModifiers=[eventListeners,popperOffsets$1,computeStyles$1,applyStyles$1,offset$1,flip$1,preventOverflow$1,arrow$1,hide$1];var createPopper=popperGenerator({defaultModifiers:defaultModifiers});exports.applyStyles=applyStyles$1;exports.arrow=arrow$1;exports.computeStyles=computeStyles$1;exports.createPopper=createPopper;exports.createPopperLite=createPopper$1;exports.defaultModifiers=defaultModifiers;exports.detectOverflow=detectOverflow;exports.eventListeners=eventListeners;exports.flip=flip$1;exports.hide=hide$1;exports.offset=offset$1;exports.popperGenerator=popperGenerator;exports.popperOffsets=popperOffsets$1;exports.preventOverflow=preventOverflow$1;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?module.exports=factory(require("@popperjs/core")):typeof define==="function"&&define.amd?define(["@popperjs/core"],factory):(global=global||self,global.tippy=factory(global.Popper))})(this,function(core){"use strict";var css='.tippy-box[data-animation=fade][data-state=hidden]{opacity:0}[data-tippy-root]{max-width:calc(100vw - 10px)}.tippy-box{position:relative;background-color:#333;color:#fff;border-radius:4px;font-size:14px;line-height:1.4;white-space:normal;outline:0;transition-property:transform,visibility,opacity}.tippy-box[data-placement^=top]>.tippy-arrow{bottom:0}.tippy-box[data-placement^=top]>.tippy-arrow:before{bottom:-7px;left:0;border-width:8px 8px 0;border-top-color:initial;transform-origin:center top}.tippy-box[data-placement^=bottom]>.tippy-arrow{top:0}.tippy-box[data-placement^=bottom]>.tippy-arrow:before{top:-7px;left:0;border-width:0 8px 8px;border-bottom-color:initial;transform-origin:center bottom}.tippy-box[data-placement^=left]>.tippy-arrow{right:0}.tippy-box[data-placement^=left]>.tippy-arrow:before{border-width:8px 0 8px 8px;border-left-color:initial;right:-7px;transform-origin:center left}.tippy-box[data-placement^=right]>.tippy-arrow{left:0}.tippy-box[data-placement^=right]>.tippy-arrow:before{left:-7px;border-width:8px 8px 8px 0;border-right-color:initial;transform-origin:center right}.tippy-box[data-inertia][data-state=visible]{transition-timing-function:cubic-bezier(.54,1.5,.38,1.11)}.tippy-arrow{width:16px;height:16px;color:#333}.tippy-arrow:before{content:"";position:absolute;border-color:transparent;border-style:solid}.tippy-content{position:relative;padding:5px 9px;z-index:1}';function injectCSS(css){var style=document.createElement("style");style.textContent=css;style.setAttribute("data-tippy-stylesheet","");var head=document.head;var firstStyleOrLinkTag=document.querySelector("head>style,head>link");if(firstStyleOrLinkTag){head.insertBefore(style,firstStyleOrLinkTag)}else{head.appendChild(style)}}var isBrowser=typeof window!=="undefined"&&typeof document!=="undefined";var isIE11=isBrowser?!!window.msCrypto:false;var ROUND_ARROW='<svg width="16" height="6" xmlns="http://www.w3.org/2000/svg"><path d="M0 6s1.796-.013 4.67-3.615C5.851.9 6.93.006 8 0c1.07-.006 2.148.887 3.343 2.385C14.233 6.005 16 6 16 6H0z"></svg>';var BOX_CLASS="tippy-box";var CONTENT_CLASS="tippy-content";var BACKDROP_CLASS="tippy-backdrop";var ARROW_CLASS="tippy-arrow";var SVG_ARROW_CLASS="tippy-svg-arrow";var TOUCH_OPTIONS={passive:true,capture:true};var TIPPY_DEFAULT_APPEND_TO=function TIPPY_DEFAULT_APPEND_TO(){return document.body};function hasOwnProperty(obj,key){return{}.hasOwnProperty.call(obj,key)}function getValueAtIndexOrReturn(value,index,defaultValue){if(Array.isArray(value)){var v=value[index];return v==null?Array.isArray(defaultValue)?defaultValue[index]:defaultValue:v}return value}function isType(value,type){var str={}.toString.call(value);return str.indexOf("[object")===0&&str.indexOf(type+"]")>-1}function invokeWithArgsOrReturn(value,args){return typeof value==="function"?value.apply(void 0,args):value}function debounce(fn,ms){if(ms===0){return fn}var timeout;return function(arg){clearTimeout(timeout);timeout=setTimeout(function(){fn(arg)},ms)}}function removeProperties(obj,keys){var clone=Object.assign({},obj);keys.forEach(function(key){delete clone[key]});return clone}function splitBySpaces(value){return value.split(/\s+/).filter(Boolean)}function normalizeToArray(value){return[].concat(value)}function pushIfUnique(arr,value){if(arr.indexOf(value)===-1){arr.push(value)}}function unique(arr){return arr.filter(function(item,index){return arr.indexOf(item)===index})}function getBasePlacement(placement){return placement.split("-")[0]}function arrayFrom(value){return[].slice.call(value)}function removeUndefinedProps(obj){return Object.keys(obj).reduce(function(acc,key){if(obj[key]!==undefined){acc[key]=obj[key]}return acc},{})}function div(){return document.createElement("div")}function isElement(value){return["Element","Fragment"].some(function(type){return isType(value,type)})}function isNodeList(value){return isType(value,"NodeList")}function isMouseEvent(value){return isType(value,"MouseEvent")}function isReferenceElement(value){return!!(value&&value._tippy&&value._tippy.reference===value)}function getArrayOfElements(value){if(isElement(value)){return[value]}if(isNodeList(value)){return arrayFrom(value)}if(Array.isArray(value)){return value}return arrayFrom(document.querySelectorAll(value))}function setTransitionDuration(els,value){els.forEach(function(el){if(el){el.style.transitionDuration=value+"ms"}})}function setVisibilityState(els,state){els.forEach(function(el){if(el){el.setAttribute("data-state",state)}})}function getOwnerDocument(elementOrElements){var _element$ownerDocumen;var _normalizeToArray=normalizeToArray(elementOrElements),element=_normalizeToArray[0];return element!=null&&(_element$ownerDocumen=element.ownerDocument)!=null&&_element$ownerDocumen.body?element.ownerDocument:document}function isCursorOutsideInteractiveBorder(popperTreeData,event){var clientX=event.clientX,clientY=event.clientY;return popperTreeData.every(function(_ref){var popperRect=_ref.popperRect,popperState=_ref.popperState,props=_ref.props;var interactiveBorder=props.interactiveBorder;var basePlacement=getBasePlacement(popperState.placement);var offsetData=popperState.modifiersData.offset;if(!offsetData){return true}var topDistance=basePlacement==="bottom"?offsetData.top.y:0;var bottomDistance=basePlacement==="top"?offsetData.bottom.y:0;var leftDistance=basePlacement==="right"?offsetData.left.x:0;var rightDistance=basePlacement==="left"?offsetData.right.x:0;var exceedsTop=popperRect.top-clientY+topDistance>interactiveBorder;var exceedsBottom=clientY-popperRect.bottom-bottomDistance>interactiveBorder;var exceedsLeft=popperRect.left-clientX+leftDistance>interactiveBorder;var exceedsRight=clientX-popperRect.right-rightDistance>interactiveBorder;return exceedsTop||exceedsBottom||exceedsLeft||exceedsRight})}function updateTransitionEndListener(box,action,listener){var method=action+"EventListener";["transitionend","webkitTransitionEnd"].forEach(function(event){box[method](event,listener)})}function actualContains(parent,child){var target=child;while(target){var _target$getRootNode;if(parent.contains(target)){return true}target=target.getRootNode==null?void 0:(_target$getRootNode=target.getRootNode())==null?void 0:_target$getRootNode.host}return false}var currentInput={isTouch:false};var lastMouseMoveTime=0;function onDocumentTouchStart(){if(currentInput.isTouch){return}currentInput.isTouch=true;if(window.performance){document.addEventListener("mousemove",onDocumentMouseMove)}}function onDocumentMouseMove(){var now=performance.now();if(now-lastMouseMoveTime<20){currentInput.isTouch=false;document.removeEventListener("mousemove",onDocumentMouseMove)}lastMouseMoveTime=now}function onWindowBlur(){var activeElement=document.activeElement;if(isReferenceElement(activeElement)){var instance=activeElement._tippy;if(activeElement.blur&&!instance.state.isVisible){activeElement.blur()}}}function bindGlobalEventListeners(){document.addEventListener("touchstart",onDocumentTouchStart,TOUCH_OPTIONS);window.addEventListener("blur",onWindowBlur)}function createMemoryLeakWarning(method){var txt=method==="destroy"?"n already-":" ";return[method+"() was called on a"+txt+"destroyed instance. This is a no-op but","indicates a potential memory leak."].join(" ")}function clean(value){var spacesAndTabs=/[ \t]{2,}/g;var lineStartWithSpaces=/^[ \t]*/gm;return value.replace(spacesAndTabs," ").replace(lineStartWithSpaces,"").trim()}function getDevMessage(message){return clean("\n  %ctippy.js\n\n  %c"+clean(message)+"\n\n  %c👷‍ This is a development-only message. It will be removed in production.\n  ")}function getFormattedMessage(message){return[getDevMessage(message),"color: #00C584; font-size: 1.3em; font-weight: bold;","line-height: 1.5","color: #a6a095;"]}var visitedMessages;{resetVisitedMessages()}function resetVisitedMessages(){visitedMessages=new Set}function warnWhen(condition,message){if(condition&&!visitedMessages.has(message)){var _console;visitedMessages.add(message);(_console=console).warn.apply(_console,getFormattedMessage(message))}}function errorWhen(condition,message){if(condition&&!visitedMessages.has(message)){var _console2;visitedMessages.add(message);(_console2=console).error.apply(_console2,getFormattedMessage(message))}}function validateTargets(targets){var didPassFalsyValue=!targets;var didPassPlainObject=Object.prototype.toString.call(targets)==="[object Object]"&&!targets.addEventListener;errorWhen(didPassFalsyValue,["tippy() was passed","`"+String(targets)+"`","as its targets (first) argument. Valid types are: String, Element,","Element[], or NodeList."].join(" "));errorWhen(didPassPlainObject,["tippy() was passed a plain object which is not supported as an argument","for virtual positioning. Use props.getReferenceClientRect instead."].join(" "))}var pluginProps={animateFill:false,followCursor:false,inlinePositioning:false,sticky:false};var renderProps={allowHTML:false,animation:"fade",arrow:true,content:"",inertia:false,maxWidth:350,role:"tooltip",theme:"",zIndex:9999};var defaultProps=Object.assign({appendTo:TIPPY_DEFAULT_APPEND_TO,aria:{content:"auto",expanded:"auto"},delay:0,duration:[300,250],getReferenceClientRect:null,hideOnClick:true,ignoreAttributes:false,interactive:false,interactiveBorder:2,interactiveDebounce:0,moveTransition:"",offset:[0,10],onAfterUpdate:function onAfterUpdate(){},onBeforeUpdate:function onBeforeUpdate(){},onCreate:function onCreate(){},onDestroy:function onDestroy(){},onHidden:function onHidden(){},onHide:function onHide(){},onMount:function onMount(){},onShow:function onShow(){},onShown:function onShown(){},onTrigger:function onTrigger(){},onUntrigger:function onUntrigger(){},onClickOutside:function onClickOutside(){},placement:"top",plugins:[],popperOptions:{},render:null,showOnCreate:false,touch:true,trigger:"mouseenter focus",triggerTarget:null},pluginProps,renderProps);var defaultKeys=Object.keys(defaultProps);var setDefaultProps=function setDefaultProps(partialProps){{validateProps(partialProps,[])}var keys=Object.keys(partialProps);keys.forEach(function(key){defaultProps[key]=partialProps[key]})};function getExtendedPassedProps(passedProps){var plugins=passedProps.plugins||[];var pluginProps=plugins.reduce(function(acc,plugin){var name=plugin.name,defaultValue=plugin.defaultValue;if(name){var _name;acc[name]=passedProps[name]!==undefined?passedProps[name]:(_name=defaultProps[name])!=null?_name:defaultValue}return acc},{});return Object.assign({},passedProps,pluginProps)}function getDataAttributeProps(reference,plugins){var propKeys=plugins?Object.keys(getExtendedPassedProps(Object.assign({},defaultProps,{plugins:plugins}))):defaultKeys;var props=propKeys.reduce(function(acc,key){var valueAsString=(reference.getAttribute("data-tippy-"+key)||"").trim();if(!valueAsString){return acc}if(key==="content"){acc[key]=valueAsString}else{try{acc[key]=JSON.parse(valueAsString)}catch(e){acc[key]=valueAsString}}return acc},{});return props}function evaluateProps(reference,props){var out=Object.assign({},props,{content:invokeWithArgsOrReturn(props.content,[reference])},props.ignoreAttributes?{}:getDataAttributeProps(reference,props.plugins));out.aria=Object.assign({},defaultProps.aria,out.aria);out.aria={expanded:out.aria.expanded==="auto"?props.interactive:out.aria.expanded,content:out.aria.content==="auto"?props.interactive?null:"describedby":out.aria.content};return out}function validateProps(partialProps,plugins){if(partialProps===void 0){partialProps={}}if(plugins===void 0){plugins=[]}var keys=Object.keys(partialProps);keys.forEach(function(prop){var nonPluginProps=removeProperties(defaultProps,Object.keys(pluginProps));var didPassUnknownProp=!hasOwnProperty(nonPluginProps,prop);if(didPassUnknownProp){didPassUnknownProp=plugins.filter(function(plugin){return plugin.name===prop}).length===0}warnWhen(didPassUnknownProp,["`"+prop+"`","is not a valid prop. You may have spelled it incorrectly, or if it's","a plugin, forgot to pass it in an array as props.plugins.","\n\n","All props: https://atomiks.github.io/tippyjs/v6/all-props/\n","Plugins: https://atomiks.github.io/tippyjs/v6/plugins/"].join(" "))})}var innerHTML=function innerHTML(){return"innerHTML"};function dangerouslySetInnerHTML(element,html){element[innerHTML()]=html}function createArrowElement(value){var arrow=div();if(value===true){arrow.className=ARROW_CLASS}else{arrow.className=SVG_ARROW_CLASS;if(isElement(value)){arrow.appendChild(value)}else{dangerouslySetInnerHTML(arrow,value)}}return arrow}function setContent(content,props){if(isElement(props.content)){dangerouslySetInnerHTML(content,"");content.appendChild(props.content)}else if(typeof props.content!=="function"){if(props.allowHTML){dangerouslySetInnerHTML(content,props.content)}else{content.textContent=props.content}}}function getChildren(popper){var box=popper.firstElementChild;var boxChildren=arrayFrom(box.children);return{box:box,content:boxChildren.find(function(node){return node.classList.contains(CONTENT_CLASS)}),arrow:boxChildren.find(function(node){return node.classList.contains(ARROW_CLASS)||node.classList.contains(SVG_ARROW_CLASS)}),backdrop:boxChildren.find(function(node){return node.classList.contains(BACKDROP_CLASS)})}}function render(instance){var popper=div();var box=div();box.className=BOX_CLASS;box.setAttribute("data-state","hidden");box.setAttribute("tabindex","-1");var content=div();content.className=CONTENT_CLASS;content.setAttribute("data-state","hidden");setContent(content,instance.props);popper.appendChild(box);box.appendChild(content);onUpdate(instance.props,instance.props);function onUpdate(prevProps,nextProps){var _getChildren=getChildren(popper),box=_getChildren.box,content=_getChildren.content,arrow=_getChildren.arrow;if(nextProps.theme){box.setAttribute("data-theme",nextProps.theme)}else{box.removeAttribute("data-theme")}if(typeof nextProps.animation==="string"){box.setAttribute("data-animation",nextProps.animation)}else{box.removeAttribute("data-animation")}if(nextProps.inertia){box.setAttribute("data-inertia","")}else{box.removeAttribute("data-inertia")}box.style.maxWidth=typeof nextProps.maxWidth==="number"?nextProps.maxWidth+"px":nextProps.maxWidth;if(nextProps.role){box.setAttribute("role",nextProps.role)}else{box.removeAttribute("role")}if(prevProps.content!==nextProps.content||prevProps.allowHTML!==nextProps.allowHTML){setContent(content,instance.props)}if(nextProps.arrow){if(!arrow){box.appendChild(createArrowElement(nextProps.arrow))}else if(prevProps.arrow!==nextProps.arrow){box.removeChild(arrow);box.appendChild(createArrowElement(nextProps.arrow))}}else if(arrow){box.removeChild(arrow)}}return{popper:popper,onUpdate:onUpdate}}render.$$tippy=true;var idCounter=1;var mouseMoveListeners=[];var mountedInstances=[];function createTippy(reference,passedProps){var props=evaluateProps(reference,Object.assign({},defaultProps,getExtendedPassedProps(removeUndefinedProps(passedProps))));var showTimeout;var hideTimeout;var scheduleHideAnimationFrame;var isVisibleFromClick=false;var didHideDueToDocumentMouseDown=false;var didTouchMove=false;var ignoreOnFirstUpdate=false;var lastTriggerEvent;var currentTransitionEndListener;var onFirstUpdate;var listeners=[];var debouncedOnMouseMove=debounce(onMouseMove,props.interactiveDebounce);var currentTarget;var id=idCounter++;var popperInstance=null;var plugins=unique(props.plugins);var state={isEnabled:true,isVisible:false,isDestroyed:false,isMounted:false,isShown:false};var instance={id:id,reference:reference,popper:div(),popperInstance:popperInstance,props:props,state:state,plugins:plugins,clearDelayTimeouts:clearDelayTimeouts,setProps:setProps,setContent:setContent,show:show,hide:hide,hideWithInteractivity:hideWithInteractivity,enable:enable,disable:disable,unmount:unmount,destroy:destroy};if(!props.render){{errorWhen(true,"render() function has not been supplied.")}return instance}var _props$render=props.render(instance),popper=_props$render.popper,onUpdate=_props$render.onUpdate;popper.setAttribute("data-tippy-root","");popper.id="tippy-"+instance.id;instance.popper=popper;reference._tippy=instance;popper._tippy=instance;var pluginsHooks=plugins.map(function(plugin){return plugin.fn(instance)});var hasAriaExpanded=reference.hasAttribute("aria-expanded");addListeners();handleAriaExpandedAttribute();handleStyles();invokeHook("onCreate",[instance]);if(props.showOnCreate){scheduleShow()}popper.addEventListener("mouseenter",function(){if(instance.props.interactive&&instance.state.isVisible){instance.clearDelayTimeouts()}});popper.addEventListener("mouseleave",function(){if(instance.props.interactive&&instance.props.trigger.indexOf("mouseenter")>=0){getDocument().addEventListener("mousemove",debouncedOnMouseMove)}});return instance;function getNormalizedTouchSettings(){var touch=instance.props.touch;return Array.isArray(touch)?touch:[touch,0]}function getIsCustomTouchBehavior(){return getNormalizedTouchSettings()[0]==="hold"}function getIsDefaultRenderFn(){var _instance$props$rende;return!!((_instance$props$rende=instance.props.render)!=null&&_instance$props$rende.$$tippy)}function getCurrentTarget(){return currentTarget||reference}function getDocument(){var parent=getCurrentTarget().parentNode;return parent?getOwnerDocument(parent):document}function getDefaultTemplateChildren(){return getChildren(popper)}function getDelay(isShow){if(instance.state.isMounted&&!instance.state.isVisible||currentInput.isTouch||lastTriggerEvent&&lastTriggerEvent.type==="focus"){return 0}return getValueAtIndexOrReturn(instance.props.delay,isShow?0:1,defaultProps.delay)}function handleStyles(fromHide){if(fromHide===void 0){fromHide=false}popper.style.pointerEvents=instance.props.interactive&&!fromHide?"":"none";popper.style.zIndex=""+instance.props.zIndex}function invokeHook(hook,args,shouldInvokePropsHook){if(shouldInvokePropsHook===void 0){shouldInvokePropsHook=true}pluginsHooks.forEach(function(pluginHooks){if(pluginHooks[hook]){pluginHooks[hook].apply(pluginHooks,args)}});if(shouldInvokePropsHook){var _instance$props;(_instance$props=instance.props)[hook].apply(_instance$props,args)}}function handleAriaContentAttribute(){var aria=instance.props.aria;if(!aria.content){return}var attr="aria-"+aria.content;var id=popper.id;var nodes=normalizeToArray(instance.props.triggerTarget||reference);nodes.forEach(function(node){var currentValue=node.getAttribute(attr);if(instance.state.isVisible){node.setAttribute(attr,currentValue?currentValue+" "+id:id)}else{var nextValue=currentValue&&currentValue.replace(id,"").trim();if(nextValue){node.setAttribute(attr,nextValue)}else{node.removeAttribute(attr)}}})}function handleAriaExpandedAttribute(){if(hasAriaExpanded||!instance.props.aria.expanded){return}var nodes=normalizeToArray(instance.props.triggerTarget||reference);nodes.forEach(function(node){if(instance.props.interactive){node.setAttribute("aria-expanded",instance.state.isVisible&&node===getCurrentTarget()?"true":"false")}else{node.removeAttribute("aria-expanded")}})}function cleanupInteractiveMouseListeners(){getDocument().removeEventListener("mousemove",debouncedOnMouseMove);mouseMoveListeners=mouseMoveListeners.filter(function(listener){return listener!==debouncedOnMouseMove})}function onDocumentPress(event){if(currentInput.isTouch){if(didTouchMove||event.type==="mousedown"){return}}var actualTarget=event.composedPath&&event.composedPath()[0]||event.target;if(instance.props.interactive&&actualContains(popper,actualTarget)){return}if(normalizeToArray(instance.props.triggerTarget||reference).some(function(el){return actualContains(el,actualTarget)})){if(currentInput.isTouch){return}if(instance.state.isVisible&&instance.props.trigger.indexOf("click")>=0){return}}else{invokeHook("onClickOutside",[instance,event])}if(instance.props.hideOnClick===true){instance.clearDelayTimeouts();instance.hide();didHideDueToDocumentMouseDown=true;setTimeout(function(){didHideDueToDocumentMouseDown=false});if(!instance.state.isMounted){removeDocumentPress()}}}function onTouchMove(){didTouchMove=true}function onTouchStart(){didTouchMove=false}function addDocumentPress(){var doc=getDocument();doc.addEventListener("mousedown",onDocumentPress,true);doc.addEventListener("touchend",onDocumentPress,TOUCH_OPTIONS);doc.addEventListener("touchstart",onTouchStart,TOUCH_OPTIONS);doc.addEventListener("touchmove",onTouchMove,TOUCH_OPTIONS)}function removeDocumentPress(){var doc=getDocument();doc.removeEventListener("mousedown",onDocumentPress,true);doc.removeEventListener("touchend",onDocumentPress,TOUCH_OPTIONS);doc.removeEventListener("touchstart",onTouchStart,TOUCH_OPTIONS);doc.removeEventListener("touchmove",onTouchMove,TOUCH_OPTIONS)}function onTransitionedOut(duration,callback){onTransitionEnd(duration,function(){if(!instance.state.isVisible&&popper.parentNode&&popper.parentNode.contains(popper)){callback()}})}function onTransitionedIn(duration,callback){onTransitionEnd(duration,callback)}function onTransitionEnd(duration,callback){var box=getDefaultTemplateChildren().box;function listener(event){if(event.target===box){updateTransitionEndListener(box,"remove",listener);callback()}}if(duration===0){return callback()}updateTransitionEndListener(box,"remove",currentTransitionEndListener);updateTransitionEndListener(box,"add",listener);currentTransitionEndListener=listener}function on(eventType,handler,options){if(options===void 0){options=false}var nodes=normalizeToArray(instance.props.triggerTarget||reference);nodes.forEach(function(node){node.addEventListener(eventType,handler,options);listeners.push({node:node,eventType:eventType,handler:handler,options:options})})}function addListeners(){if(getIsCustomTouchBehavior()){on("touchstart",onTrigger,{passive:true});on("touchend",onMouseLeave,{passive:true})}splitBySpaces(instance.props.trigger).forEach(function(eventType){if(eventType==="manual"){return}on(eventType,onTrigger);switch(eventType){case"mouseenter":on("mouseleave",onMouseLeave);break;case"focus":on(isIE11?"focusout":"blur",onBlurOrFocusOut);break;case"focusin":on("focusout",onBlurOrFocusOut);break}})}function removeListeners(){listeners.forEach(function(_ref){var node=_ref.node,eventType=_ref.eventType,handler=_ref.handler,options=_ref.options;node.removeEventListener(eventType,handler,options)});listeners=[]}function onTrigger(event){var _lastTriggerEvent;var shouldScheduleClickHide=false;if(!instance.state.isEnabled||isEventListenerStopped(event)||didHideDueToDocumentMouseDown){return}var wasFocused=((_lastTriggerEvent=lastTriggerEvent)==null?void 0:_lastTriggerEvent.type)==="focus";lastTriggerEvent=event;currentTarget=event.currentTarget;handleAriaExpandedAttribute();if(!instance.state.isVisible&&isMouseEvent(event)){mouseMoveListeners.forEach(function(listener){return listener(event)})}if(event.type==="click"&&(instance.props.trigger.indexOf("mouseenter")<0||isVisibleFromClick)&&instance.props.hideOnClick!==false&&instance.state.isVisible){shouldScheduleClickHide=true}else{scheduleShow(event)}if(event.type==="click"){isVisibleFromClick=!shouldScheduleClickHide}if(shouldScheduleClickHide&&!wasFocused){scheduleHide(event)}}function onMouseMove(event){var target=event.target;var isCursorOverReferenceOrPopper=getCurrentTarget().contains(target)||popper.contains(target);if(event.type==="mousemove"&&isCursorOverReferenceOrPopper){return}var popperTreeData=getNestedPopperTree().concat(popper).map(function(popper){var _instance$popperInsta;var instance=popper._tippy;var state=(_instance$popperInsta=instance.popperInstance)==null?void 0:_instance$popperInsta.state;if(state){return{popperRect:popper.getBoundingClientRect(),popperState:state,props:props}}return null}).filter(Boolean);if(isCursorOutsideInteractiveBorder(popperTreeData,event)){cleanupInteractiveMouseListeners();scheduleHide(event)}}function onMouseLeave(event){var shouldBail=isEventListenerStopped(event)||instance.props.trigger.indexOf("click")>=0&&isVisibleFromClick;if(shouldBail){return}if(instance.props.interactive){instance.hideWithInteractivity(event);return}scheduleHide(event)}function onBlurOrFocusOut(event){if(instance.props.trigger.indexOf("focusin")<0&&event.target!==getCurrentTarget()){return}if(instance.props.interactive&&event.relatedTarget&&popper.contains(event.relatedTarget)){return}scheduleHide(event)}function isEventListenerStopped(event){return currentInput.isTouch?getIsCustomTouchBehavior()!==event.type.indexOf("touch")>=0:false}function createPopperInstance(){destroyPopperInstance();var _instance$props2=instance.props,popperOptions=_instance$props2.popperOptions,placement=_instance$props2.placement,offset=_instance$props2.offset,getReferenceClientRect=_instance$props2.getReferenceClientRect,moveTransition=_instance$props2.moveTransition;var arrow=getIsDefaultRenderFn()?getChildren(popper).arrow:null;var computedReference=getReferenceClientRect?{getBoundingClientRect:getReferenceClientRect,contextElement:getReferenceClientRect.contextElement||getCurrentTarget()}:reference;var tippyModifier={name:"$$tippy",enabled:true,phase:"beforeWrite",requires:["computeStyles"],fn:function fn(_ref2){var state=_ref2.state;if(getIsDefaultRenderFn()){var _getDefaultTemplateCh=getDefaultTemplateChildren(),box=_getDefaultTemplateCh.box;["placement","reference-hidden","escaped"].forEach(function(attr){if(attr==="placement"){box.setAttribute("data-placement",state.placement)}else{if(state.attributes.popper["data-popper-"+attr]){box.setAttribute("data-"+attr,"")}else{box.removeAttribute("data-"+attr)}}});state.attributes.popper={}}}};var modifiers=[{name:"offset",options:{offset:offset}},{name:"preventOverflow",options:{padding:{top:2,bottom:2,left:5,right:5}}},{name:"flip",options:{padding:5}},{name:"computeStyles",options:{adaptive:!moveTransition}},tippyModifier];if(getIsDefaultRenderFn()&&arrow){modifiers.push({name:"arrow",options:{element:arrow,padding:3}})}modifiers.push.apply(modifiers,(popperOptions==null?void 0:popperOptions.modifiers)||[]);instance.popperInstance=core.createPopper(computedReference,popper,Object.assign({},popperOptions,{placement:placement,onFirstUpdate:onFirstUpdate,modifiers:modifiers}))}function destroyPopperInstance(){if(instance.popperInstance){instance.popperInstance.destroy();instance.popperInstance=null}}function mount(){var appendTo=instance.props.appendTo;var parentNode;var node=getCurrentTarget();if(instance.props.interactive&&appendTo===TIPPY_DEFAULT_APPEND_TO||appendTo==="parent"){parentNode=node.parentNode}else{parentNode=invokeWithArgsOrReturn(appendTo,[node])}if(!parentNode.contains(popper)){parentNode.appendChild(popper)}instance.state.isMounted=true;createPopperInstance();{warnWhen(instance.props.interactive&&appendTo===defaultProps.appendTo&&node.nextElementSibling!==popper,["Interactive tippy element may not be accessible via keyboard","navigation because it is not directly after the reference element","in the DOM source order.","\n\n","Using a wrapper <div> or <span> tag around the reference element","solves this by creating a new parentNode context.","\n\n","Specifying `appendTo: document.body` silences this warning, but it","assumes you are using a focus management solution to handle","keyboard navigation.","\n\n","See: https://atomiks.github.io/tippyjs/v6/accessibility/#interactivity"].join(" "))}}function getNestedPopperTree(){return arrayFrom(popper.querySelectorAll("[data-tippy-root]"))}function scheduleShow(event){instance.clearDelayTimeouts();if(event){invokeHook("onTrigger",[instance,event])}addDocumentPress();var delay=getDelay(true);var _getNormalizedTouchSe=getNormalizedTouchSettings(),touchValue=_getNormalizedTouchSe[0],touchDelay=_getNormalizedTouchSe[1];if(currentInput.isTouch&&touchValue==="hold"&&touchDelay){delay=touchDelay}if(delay){showTimeout=setTimeout(function(){instance.show()},delay)}else{instance.show()}}function scheduleHide(event){instance.clearDelayTimeouts();invokeHook("onUntrigger",[instance,event]);if(!instance.state.isVisible){removeDocumentPress();return}if(instance.props.trigger.indexOf("mouseenter")>=0&&instance.props.trigger.indexOf("click")>=0&&["mouseleave","mousemove"].indexOf(event.type)>=0&&isVisibleFromClick){return}var delay=getDelay(false);if(delay){hideTimeout=setTimeout(function(){if(instance.state.isVisible){instance.hide()}},delay)}else{scheduleHideAnimationFrame=requestAnimationFrame(function(){instance.hide()})}}function enable(){instance.state.isEnabled=true}function disable(){instance.hide();instance.state.isEnabled=false}function clearDelayTimeouts(){clearTimeout(showTimeout);clearTimeout(hideTimeout);cancelAnimationFrame(scheduleHideAnimationFrame)}function setProps(partialProps){{warnWhen(instance.state.isDestroyed,createMemoryLeakWarning("setProps"))}if(instance.state.isDestroyed){return}invokeHook("onBeforeUpdate",[instance,partialProps]);removeListeners();var prevProps=instance.props;var nextProps=evaluateProps(reference,Object.assign({},prevProps,removeUndefinedProps(partialProps),{ignoreAttributes:true}));instance.props=nextProps;addListeners();if(prevProps.interactiveDebounce!==nextProps.interactiveDebounce){cleanupInteractiveMouseListeners();debouncedOnMouseMove=debounce(onMouseMove,nextProps.interactiveDebounce)}if(prevProps.triggerTarget&&!nextProps.triggerTarget){normalizeToArray(prevProps.triggerTarget).forEach(function(node){node.removeAttribute("aria-expanded")})}else if(nextProps.triggerTarget){reference.removeAttribute("aria-expanded")}handleAriaExpandedAttribute();handleStyles();if(onUpdate){onUpdate(prevProps,nextProps)}if(instance.popperInstance){createPopperInstance();getNestedPopperTree().forEach(function(nestedPopper){requestAnimationFrame(nestedPopper._tippy.popperInstance.forceUpdate)})}invokeHook("onAfterUpdate",[instance,partialProps])}function setContent(content){instance.setProps({content:content})}function show(){{warnWhen(instance.state.isDestroyed,createMemoryLeakWarning("show"))}var isAlreadyVisible=instance.state.isVisible;var isDestroyed=instance.state.isDestroyed;var isDisabled=!instance.state.isEnabled;var isTouchAndTouchDisabled=currentInput.isTouch&&!instance.props.touch;var duration=getValueAtIndexOrReturn(instance.props.duration,0,defaultProps.duration);if(isAlreadyVisible||isDestroyed||isDisabled||isTouchAndTouchDisabled){return}if(getCurrentTarget().hasAttribute("disabled")){return}invokeHook("onShow",[instance],false);if(instance.props.onShow(instance)===false){return}instance.state.isVisible=true;if(getIsDefaultRenderFn()){popper.style.visibility="visible"}handleStyles();addDocumentPress();if(!instance.state.isMounted){popper.style.transition="none"}if(getIsDefaultRenderFn()){var _getDefaultTemplateCh2=getDefaultTemplateChildren(),box=_getDefaultTemplateCh2.box,content=_getDefaultTemplateCh2.content;setTransitionDuration([box,content],0)}onFirstUpdate=function onFirstUpdate(){var _instance$popperInsta2;if(!instance.state.isVisible||ignoreOnFirstUpdate){return}ignoreOnFirstUpdate=true;void popper.offsetHeight;popper.style.transition=instance.props.moveTransition;if(getIsDefaultRenderFn()&&instance.props.animation){var _getDefaultTemplateCh3=getDefaultTemplateChildren(),_box=_getDefaultTemplateCh3.box,_content=_getDefaultTemplateCh3.content;setTransitionDuration([_box,_content],duration);setVisibilityState([_box,_content],"visible")}handleAriaContentAttribute();handleAriaExpandedAttribute();pushIfUnique(mountedInstances,instance);(_instance$popperInsta2=instance.popperInstance)==null?void 0:_instance$popperInsta2.forceUpdate();invokeHook("onMount",[instance]);if(instance.props.animation&&getIsDefaultRenderFn()){onTransitionedIn(duration,function(){instance.state.isShown=true;invokeHook("onShown",[instance])})}};mount()}function hide(){{warnWhen(instance.state.isDestroyed,createMemoryLeakWarning("hide"))}var isAlreadyHidden=!instance.state.isVisible;var isDestroyed=instance.state.isDestroyed;var isDisabled=!instance.state.isEnabled;var duration=getValueAtIndexOrReturn(instance.props.duration,1,defaultProps.duration);if(isAlreadyHidden||isDestroyed||isDisabled){return}invokeHook("onHide",[instance],false);if(instance.props.onHide(instance)===false){return}instance.state.isVisible=false;instance.state.isShown=false;ignoreOnFirstUpdate=false;isVisibleFromClick=false;if(getIsDefaultRenderFn()){popper.style.visibility="hidden"}cleanupInteractiveMouseListeners();removeDocumentPress();handleStyles(true);if(getIsDefaultRenderFn()){var _getDefaultTemplateCh4=getDefaultTemplateChildren(),box=_getDefaultTemplateCh4.box,content=_getDefaultTemplateCh4.content;if(instance.props.animation){setTransitionDuration([box,content],duration);setVisibilityState([box,content],"hidden")}}handleAriaContentAttribute();handleAriaExpandedAttribute();if(instance.props.animation){if(getIsDefaultRenderFn()){onTransitionedOut(duration,instance.unmount)}}else{instance.unmount()}}function hideWithInteractivity(event){{warnWhen(instance.state.isDestroyed,createMemoryLeakWarning("hideWithInteractivity"))}getDocument().addEventListener("mousemove",debouncedOnMouseMove);pushIfUnique(mouseMoveListeners,debouncedOnMouseMove);debouncedOnMouseMove(event)}function unmount(){{warnWhen(instance.state.isDestroyed,createMemoryLeakWarning("unmount"))}if(instance.state.isVisible){instance.hide()}if(!instance.state.isMounted){return}destroyPopperInstance();getNestedPopperTree().forEach(function(nestedPopper){nestedPopper._tippy.unmount()});if(popper.parentNode){popper.parentNode.removeChild(popper)}mountedInstances=mountedInstances.filter(function(i){return i!==instance});instance.state.isMounted=false;invokeHook("onHidden",[instance])}function destroy(){{warnWhen(instance.state.isDestroyed,createMemoryLeakWarning("destroy"))}if(instance.state.isDestroyed){return}instance.clearDelayTimeouts();instance.unmount();removeListeners();delete reference._tippy;instance.state.isDestroyed=true;invokeHook("onDestroy",[instance])}}function tippy(targets,optionalProps){if(optionalProps===void 0){optionalProps={}}var plugins=defaultProps.plugins.concat(optionalProps.plugins||[]);{validateTargets(targets);validateProps(optionalProps,plugins)}bindGlobalEventListeners();var passedProps=Object.assign({},optionalProps,{plugins:plugins});var elements=getArrayOfElements(targets);{var isSingleContentElement=isElement(passedProps.content);var isMoreThanOneReferenceElement=elements.length>1;warnWhen(isSingleContentElement&&isMoreThanOneReferenceElement,["tippy() was passed an Element as the `content` prop, but more than","one tippy instance was created by this invocation. This means the","content element will only be appended to the last tippy instance.","\n\n","Instead, pass the .innerHTML of the element, or use a function that","returns a cloned version of the element instead.","\n\n","1) content: element.innerHTML\n","2) content: () => element.cloneNode(true)"].join(" "))}var instances=elements.reduce(function(acc,reference){var instance=reference&&createTippy(reference,passedProps);if(instance){acc.push(instance)}return acc},[]);return isElement(targets)?instances[0]:instances}tippy.defaultProps=defaultProps;tippy.setDefaultProps=setDefaultProps;tippy.currentInput=currentInput;var hideAll=function hideAll(_temp){var _ref=_temp===void 0?{}:_temp,excludedReferenceOrInstance=_ref.exclude,duration=_ref.duration;mountedInstances.forEach(function(instance){var isExcluded=false;if(excludedReferenceOrInstance){isExcluded=isReferenceElement(excludedReferenceOrInstance)?instance.reference===excludedReferenceOrInstance:instance.popper===excludedReferenceOrInstance.popper}if(!isExcluded){var originalDuration=instance.props.duration;instance.setProps({duration:duration});instance.hide();if(!instance.state.isDestroyed){instance.setProps({duration:originalDuration})}}})};var applyStylesModifier=Object.assign({},core.applyStyles,{effect:function effect(_ref){var state=_ref.state;var initialStyles={popper:{position:state.options.strategy,left:"0",top:"0",margin:"0"},arrow:{position:"absolute"},reference:{}};Object.assign(state.elements.popper.style,initialStyles.popper);state.styles=initialStyles;if(state.elements.arrow){Object.assign(state.elements.arrow.style,initialStyles.arrow)}}});var createSingleton=function createSingleton(tippyInstances,optionalProps){var _optionalProps$popper;if(optionalProps===void 0){optionalProps={}}{errorWhen(!Array.isArray(tippyInstances),["The first argument passed to createSingleton() must be an array of","tippy instances. The passed value was",String(tippyInstances)].join(" "))}var individualInstances=tippyInstances;var references=[];var triggerTargets=[];var currentTarget;var overrides=optionalProps.overrides;var interceptSetPropsCleanups=[];var shownOnCreate=false;function setTriggerTargets(){triggerTargets=individualInstances.map(function(instance){return normalizeToArray(instance.props.triggerTarget||instance.reference)}).reduce(function(acc,item){return acc.concat(item)},[])}function setReferences(){references=individualInstances.map(function(instance){return instance.reference})}function enableInstances(isEnabled){individualInstances.forEach(function(instance){if(isEnabled){instance.enable()}else{instance.disable()}})}function interceptSetProps(singleton){return individualInstances.map(function(instance){var originalSetProps=instance.setProps;instance.setProps=function(props){originalSetProps(props);if(instance.reference===currentTarget){singleton.setProps(props)}};return function(){instance.setProps=originalSetProps}})}function prepareInstance(singleton,target){var index=triggerTargets.indexOf(target);if(target===currentTarget){return}currentTarget=target;var overrideProps=(overrides||[]).concat("content").reduce(function(acc,prop){acc[prop]=individualInstances[index].props[prop];return acc},{});singleton.setProps(Object.assign({},overrideProps,{getReferenceClientRect:typeof overrideProps.getReferenceClientRect==="function"?overrideProps.getReferenceClientRect:function(){var _references$index;return(_references$index=references[index])==null?void 0:_references$index.getBoundingClientRect()}}))}enableInstances(false);setReferences();setTriggerTargets();var plugin={fn:function fn(){return{onDestroy:function onDestroy(){enableInstances(true)},onHidden:function onHidden(){currentTarget=null},onClickOutside:function onClickOutside(instance){if(instance.props.showOnCreate&&!shownOnCreate){shownOnCreate=true;currentTarget=null}},onShow:function onShow(instance){if(instance.props.showOnCreate&&!shownOnCreate){shownOnCreate=true;prepareInstance(instance,references[0])}},onTrigger:function onTrigger(instance,event){prepareInstance(instance,event.currentTarget)}}}};var singleton=tippy(div(),Object.assign({},removeProperties(optionalProps,["overrides"]),{plugins:[plugin].concat(optionalProps.plugins||[]),triggerTarget:triggerTargets,popperOptions:Object.assign({},optionalProps.popperOptions,{modifiers:[].concat(((_optionalProps$popper=optionalProps.popperOptions)==null?void 0:_optionalProps$popper.modifiers)||[],[applyStylesModifier])})}));var originalShow=singleton.show;singleton.show=function(target){originalShow();if(!currentTarget&&target==null){return prepareInstance(singleton,references[0])}if(currentTarget&&target==null){return}if(typeof target==="number"){return references[target]&&prepareInstance(singleton,references[target])}if(individualInstances.indexOf(target)>=0){var ref=target.reference;return prepareInstance(singleton,ref)}if(references.indexOf(target)>=0){return prepareInstance(singleton,target)}};singleton.showNext=function(){var first=references[0];if(!currentTarget){return singleton.show(0)}var index=references.indexOf(currentTarget);singleton.show(references[index+1]||first)};singleton.showPrevious=function(){var last=references[references.length-1];if(!currentTarget){return singleton.show(last)}var index=references.indexOf(currentTarget);var target=references[index-1]||last;singleton.show(target)};var originalSetProps=singleton.setProps;singleton.setProps=function(props){overrides=props.overrides||overrides;originalSetProps(props)};singleton.setInstances=function(nextInstances){enableInstances(true);interceptSetPropsCleanups.forEach(function(fn){return fn()});individualInstances=nextInstances;enableInstances(false);setReferences();setTriggerTargets();interceptSetPropsCleanups=interceptSetProps(singleton);singleton.setProps({triggerTarget:triggerTargets})};interceptSetPropsCleanups=interceptSetProps(singleton);return singleton};var BUBBLING_EVENTS_MAP={mouseover:"mouseenter",focusin:"focus",click:"click"};function delegate(targets,props){{errorWhen(!(props&&props.target),["You must specity a `target` prop indicating a CSS selector string matching","the target elements that should receive a tippy."].join(" "))}var listeners=[];var childTippyInstances=[];var disabled=false;var target=props.target;var nativeProps=removeProperties(props,["target"]);var parentProps=Object.assign({},nativeProps,{trigger:"manual",touch:false});var childProps=Object.assign({touch:defaultProps.touch},nativeProps,{showOnCreate:true});var returnValue=tippy(targets,parentProps);var normalizedReturnValue=normalizeToArray(returnValue);function onTrigger(event){if(!event.target||disabled){return}var targetNode=event.target.closest(target);if(!targetNode){return}var trigger=targetNode.getAttribute("data-tippy-trigger")||props.trigger||defaultProps.trigger;if(targetNode._tippy){return}if(event.type==="touchstart"&&typeof childProps.touch==="boolean"){return}if(event.type!=="touchstart"&&trigger.indexOf(BUBBLING_EVENTS_MAP[event.type])<0){return}var instance=tippy(targetNode,childProps);if(instance){childTippyInstances=childTippyInstances.concat(instance)}}function on(node,eventType,handler,options){if(options===void 0){options=false}node.addEventListener(eventType,handler,options);listeners.push({node:node,eventType:eventType,handler:handler,options:options})}function addEventListeners(instance){var reference=instance.reference;on(reference,"touchstart",onTrigger,TOUCH_OPTIONS);on(reference,"mouseover",onTrigger);on(reference,"focusin",onTrigger);on(reference,"click",onTrigger)}function removeEventListeners(){listeners.forEach(function(_ref){var node=_ref.node,eventType=_ref.eventType,handler=_ref.handler,options=_ref.options;node.removeEventListener(eventType,handler,options)});listeners=[]}function applyMutations(instance){var originalDestroy=instance.destroy;var originalEnable=instance.enable;var originalDisable=instance.disable;instance.destroy=function(shouldDestroyChildInstances){if(shouldDestroyChildInstances===void 0){shouldDestroyChildInstances=true}if(shouldDestroyChildInstances){childTippyInstances.forEach(function(instance){instance.destroy()})}childTippyInstances=[];removeEventListeners();originalDestroy()};instance.enable=function(){originalEnable();childTippyInstances.forEach(function(instance){return instance.enable()});disabled=false};instance.disable=function(){originalDisable();childTippyInstances.forEach(function(instance){return instance.disable()});disabled=true};addEventListeners(instance)}normalizedReturnValue.forEach(applyMutations);return returnValue}var animateFill={name:"animateFill",defaultValue:false,fn:function fn(instance){var _instance$props$rende;if(!((_instance$props$rende=instance.props.render)!=null&&_instance$props$rende.$$tippy)){{errorWhen(instance.props.animateFill,"The `animateFill` plugin requires the default render function.")}return{}}var _getChildren=getChildren(instance.popper),box=_getChildren.box,content=_getChildren.content;var backdrop=instance.props.animateFill?createBackdropElement():null;return{onCreate:function onCreate(){if(backdrop){box.insertBefore(backdrop,box.firstElementChild);box.setAttribute("data-animatefill","");box.style.overflow="hidden";instance.setProps({arrow:false,animation:"shift-away"})}},onMount:function onMount(){if(backdrop){var transitionDuration=box.style.transitionDuration;var duration=Number(transitionDuration.replace("ms",""));content.style.transitionDelay=Math.round(duration/10)+"ms";backdrop.style.transitionDuration=transitionDuration;setVisibilityState([backdrop],"visible")}},onShow:function onShow(){if(backdrop){backdrop.style.transitionDuration="0ms"}},onHide:function onHide(){if(backdrop){setVisibilityState([backdrop],"hidden")}}}}};function createBackdropElement(){var backdrop=div();backdrop.className=BACKDROP_CLASS;setVisibilityState([backdrop],"hidden");return backdrop}var mouseCoords={clientX:0,clientY:0};var activeInstances=[];function storeMouseCoords(_ref){var clientX=_ref.clientX,clientY=_ref.clientY;mouseCoords={clientX:clientX,clientY:clientY}}function addMouseCoordsListener(doc){doc.addEventListener("mousemove",storeMouseCoords)}function removeMouseCoordsListener(doc){doc.removeEventListener("mousemove",storeMouseCoords)}var followCursor={name:"followCursor",defaultValue:false,fn:function fn(instance){var reference=instance.reference;var doc=getOwnerDocument(instance.props.triggerTarget||reference);var isInternalUpdate=false;var wasFocusEvent=false;var isUnmounted=true;var prevProps=instance.props;function getIsInitialBehavior(){return instance.props.followCursor==="initial"&&instance.state.isVisible}function addListener(){doc.addEventListener("mousemove",onMouseMove)}function removeListener(){doc.removeEventListener("mousemove",onMouseMove)}function unsetGetReferenceClientRect(){isInternalUpdate=true;instance.setProps({getReferenceClientRect:null});isInternalUpdate=false}function onMouseMove(event){var isCursorOverReference=event.target?reference.contains(event.target):true;var followCursor=instance.props.followCursor;var clientX=event.clientX,clientY=event.clientY;var rect=reference.getBoundingClientRect();var relativeX=clientX-rect.left;var relativeY=clientY-rect.top;if(isCursorOverReference||!instance.props.interactive){instance.setProps({getReferenceClientRect:function getReferenceClientRect(){var rect=reference.getBoundingClientRect();var x=clientX;var y=clientY;if(followCursor==="initial"){x=rect.left+relativeX;y=rect.top+relativeY}var top=followCursor==="horizontal"?rect.top:y;var right=followCursor==="vertical"?rect.right:x;var bottom=followCursor==="horizontal"?rect.bottom:y;var left=followCursor==="vertical"?rect.left:x;return{width:right-left,height:bottom-top,top:top,right:right,bottom:bottom,left:left}}})}}function create(){if(instance.props.followCursor){activeInstances.push({instance:instance,doc:doc});addMouseCoordsListener(doc)}}function destroy(){activeInstances=activeInstances.filter(function(data){return data.instance!==instance});if(activeInstances.filter(function(data){return data.doc===doc}).length===0){removeMouseCoordsListener(doc)}}return{onCreate:create,onDestroy:destroy,onBeforeUpdate:function onBeforeUpdate(){prevProps=instance.props},onAfterUpdate:function onAfterUpdate(_,_ref2){var followCursor=_ref2.followCursor;if(isInternalUpdate){return}if(followCursor!==undefined&&prevProps.followCursor!==followCursor){destroy();if(followCursor){create();if(instance.state.isMounted&&!wasFocusEvent&&!getIsInitialBehavior()){addListener()}}else{removeListener();unsetGetReferenceClientRect()}}},onMount:function onMount(){if(instance.props.followCursor&&!wasFocusEvent){if(isUnmounted){onMouseMove(mouseCoords);isUnmounted=false}if(!getIsInitialBehavior()){addListener()}}},onTrigger:function onTrigger(_,event){if(isMouseEvent(event)){mouseCoords={clientX:event.clientX,clientY:event.clientY}}wasFocusEvent=event.type==="focus"},onHidden:function onHidden(){if(instance.props.followCursor){unsetGetReferenceClientRect();removeListener();isUnmounted=true}}}}};function getProps(props,modifier){var _props$popperOptions;return{popperOptions:Object.assign({},props.popperOptions,{modifiers:[].concat((((_props$popperOptions=props.popperOptions)==null?void 0:_props$popperOptions.modifiers)||[]).filter(function(_ref){var name=_ref.name;return name!==modifier.name}),[modifier])})}}var inlinePositioning={name:"inlinePositioning",defaultValue:false,fn:function fn(instance){var reference=instance.reference;function isEnabled(){return!!instance.props.inlinePositioning}var placement;var cursorRectIndex=-1;var isInternalUpdate=false;var triedPlacements=[];var modifier={name:"tippyInlinePositioning",enabled:true,phase:"afterWrite",fn:function fn(_ref2){var state=_ref2.state;if(isEnabled()){if(triedPlacements.indexOf(state.placement)!==-1){triedPlacements=[]}if(placement!==state.placement&&triedPlacements.indexOf(state.placement)===-1){triedPlacements.push(state.placement);instance.setProps({getReferenceClientRect:function getReferenceClientRect(){return _getReferenceClientRect(state.placement)}})}placement=state.placement}}};function _getReferenceClientRect(placement){return getInlineBoundingClientRect(getBasePlacement(placement),reference.getBoundingClientRect(),arrayFrom(reference.getClientRects()),cursorRectIndex)}function setInternalProps(partialProps){isInternalUpdate=true;instance.setProps(partialProps);isInternalUpdate=false}function addModifier(){if(!isInternalUpdate){setInternalProps(getProps(instance.props,modifier))}}return{onCreate:addModifier,onAfterUpdate:addModifier,onTrigger:function onTrigger(_,event){if(isMouseEvent(event)){var rects=arrayFrom(instance.reference.getClientRects());var cursorRect=rects.find(function(rect){return rect.left-2<=event.clientX&&rect.right+2>=event.clientX&&rect.top-2<=event.clientY&&rect.bottom+2>=event.clientY});var index=rects.indexOf(cursorRect);cursorRectIndex=index>-1?index:cursorRectIndex}},onHidden:function onHidden(){cursorRectIndex=-1}}}};function getInlineBoundingClientRect(currentBasePlacement,boundingRect,clientRects,cursorRectIndex){if(clientRects.length<2||currentBasePlacement===null){return boundingRect}if(clientRects.length===2&&cursorRectIndex>=0&&clientRects[0].left>clientRects[1].right){return clientRects[cursorRectIndex]||boundingRect}switch(currentBasePlacement){case"top":case"bottom":{var firstRect=clientRects[0];var lastRect=clientRects[clientRects.length-1];var isTop=currentBasePlacement==="top";var top=firstRect.top;var bottom=lastRect.bottom;var left=isTop?firstRect.left:lastRect.left;var right=isTop?firstRect.right:lastRect.right;var width=right-left;var height=bottom-top;return{top:top,bottom:bottom,left:left,right:right,width:width,height:height}}case"left":case"right":{var minLeft=Math.min.apply(Math,clientRects.map(function(rects){return rects.left}));var maxRight=Math.max.apply(Math,clientRects.map(function(rects){return rects.right}));var measureRects=clientRects.filter(function(rect){return currentBasePlacement==="left"?rect.left===minLeft:rect.right===maxRight});var _top=measureRects[0].top;var _bottom=measureRects[measureRects.length-1].bottom;var _left=minLeft;var _right=maxRight;var _width=_right-_left;var _height=_bottom-_top;return{top:_top,bottom:_bottom,left:_left,right:_right,width:_width,height:_height}}default:{return boundingRect}}}var sticky={name:"sticky",defaultValue:false,fn:function fn(instance){var reference=instance.reference,popper=instance.popper;function getReference(){return instance.popperInstance?instance.popperInstance.state.elements.reference:reference}function shouldCheck(value){return instance.props.sticky===true||instance.props.sticky===value}var prevRefRect=null;var prevPopRect=null;function updatePosition(){var currentRefRect=shouldCheck("reference")?getReference().getBoundingClientRect():null;var currentPopRect=shouldCheck("popper")?popper.getBoundingClientRect():null;if(currentRefRect&&areRectsDifferent(prevRefRect,currentRefRect)||currentPopRect&&areRectsDifferent(prevPopRect,currentPopRect)){if(instance.popperInstance){instance.popperInstance.update()}}prevRefRect=currentRefRect;prevPopRect=currentPopRect;if(instance.state.isMounted){requestAnimationFrame(updatePosition)}}return{onMount:function onMount(){if(instance.props.sticky){updatePosition()}}}}};function areRectsDifferent(rectA,rectB){if(rectA&&rectB){return rectA.top!==rectB.top||rectA.right!==rectB.right||rectA.bottom!==rectB.bottom||rectA.left!==rectB.left}return true}if(isBrowser){injectCSS(css)}tippy.setDefaultProps({plugins:[animateFill,followCursor,inlinePositioning,sticky],render:render});tippy.createSingleton=createSingleton;tippy.delegate=delegate;tippy.hideAll=hideAll;tippy.roundArrow=ROUND_ARROW;return tippy});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?module.exports=factory():typeof define==="function"&&define.amd?define(factory):(global=global||self,global.Sortable=factory())})(this,function(){"use strict";function ownKeys(object,enumerableOnly){var keys=Object.keys(object);if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(object);if(enumerableOnly){symbols=symbols.filter(function(sym){return Object.getOwnPropertyDescriptor(object,sym).enumerable})}keys.push.apply(keys,symbols)}return keys}function _objectSpread2(target){for(var i=1;i<arguments.length;i++){var source=arguments[i]!=null?arguments[i]:{};if(i%2){ownKeys(Object(source),true).forEach(function(key){_defineProperty(target,key,source[key])})}else if(Object.getOwnPropertyDescriptors){Object.defineProperties(target,Object.getOwnPropertyDescriptors(source))}else{ownKeys(Object(source)).forEach(function(key){Object.defineProperty(target,key,Object.getOwnPropertyDescriptor(source,key))})}}return target}function _typeof(obj){"@babel/helpers - typeof";if(typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"){_typeof=function(obj){return typeof obj}}else{_typeof=function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj}}return _typeof(obj)}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}function _objectWithoutPropertiesLoose(source,excluded){if(source==null)return{};var target={};var sourceKeys=Object.keys(source);var key,i;for(i=0;i<sourceKeys.length;i++){key=sourceKeys[i];if(excluded.indexOf(key)>=0)continue;target[key]=source[key]}return target}function _objectWithoutProperties(source,excluded){if(source==null)return{};var target=_objectWithoutPropertiesLoose(source,excluded);var key,i;if(Object.getOwnPropertySymbols){var sourceSymbolKeys=Object.getOwnPropertySymbols(source);for(i=0;i<sourceSymbolKeys.length;i++){key=sourceSymbolKeys[i];if(excluded.indexOf(key)>=0)continue;if(!Object.prototype.propertyIsEnumerable.call(source,key))continue;target[key]=source[key]}}return target}function _toConsumableArray(arr){return _arrayWithoutHoles(arr)||_iterableToArray(arr)||_unsupportedIterableToArray(arr)||_nonIterableSpread()}function _arrayWithoutHoles(arr){if(Array.isArray(arr))return _arrayLikeToArray(arr)}function _iterableToArray(iter){if(typeof Symbol!=="undefined"&&iter[Symbol.iterator]!=null||iter["@@iterator"]!=null)return Array.from(iter)}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen)}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2}function _nonIterableSpread(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var version="1.15.6";function userAgent(pattern){if(typeof window!=="undefined"&&window.navigator){return!!navigator.userAgent.match(pattern)}}var IE11OrLess=userAgent(/(?:Trident.*rv[ :]?11\.|msie|iemobile|Windows Phone)/i);var Edge=userAgent(/Edge/i);var FireFox=userAgent(/firefox/i);var Safari=userAgent(/safari/i)&&!userAgent(/chrome/i)&&!userAgent(/android/i);var IOS=userAgent(/iP(ad|od|hone)/i);var ChromeForAndroid=userAgent(/chrome/i)&&userAgent(/android/i);var captureMode={capture:false,passive:false};function on(el,event,fn){el.addEventListener(event,fn,!IE11OrLess&&captureMode)}function off(el,event,fn){el.removeEventListener(event,fn,!IE11OrLess&&captureMode)}function matches(el,selector){if(!selector)return;selector[0]===">"&&(selector=selector.substring(1));if(el){try{if(el.matches){return el.matches(selector)}else if(el.msMatchesSelector){return el.msMatchesSelector(selector)}else if(el.webkitMatchesSelector){return el.webkitMatchesSelector(selector)}}catch(_){return false}}return false}function getParentOrHost(el){return el.host&&el!==document&&el.host.nodeType?el.host:el.parentNode}function closest(el,selector,ctx,includeCTX){if(el){ctx=ctx||document;do{if(selector!=null&&(selector[0]===">"?el.parentNode===ctx&&matches(el,selector):matches(el,selector))||includeCTX&&el===ctx){return el}if(el===ctx)break}while(el=getParentOrHost(el))}return null}var R_SPACE=/\s+/g;function toggleClass(el,name,state){if(el&&name){if(el.classList){el.classList[state?"add":"remove"](name)}else{var className=(" "+el.className+" ").replace(R_SPACE," ").replace(" "+name+" "," ");el.className=(className+(state?" "+name:"")).replace(R_SPACE," ")}}}function css(el,prop,val){var style=el&&el.style;if(style){if(val===void 0){if(document.defaultView&&document.defaultView.getComputedStyle){val=document.defaultView.getComputedStyle(el,"")}else if(el.currentStyle){val=el.currentStyle}return prop===void 0?val:val[prop]}else{if(!(prop in style)&&prop.indexOf("webkit")===-1){prop="-webkit-"+prop}style[prop]=val+(typeof val==="string"?"":"px")}}}function matrix(el,selfOnly){var appliedTransforms="";if(typeof el==="string"){appliedTransforms=el}else{do{var transform=css(el,"transform");if(transform&&transform!=="none"){appliedTransforms=transform+" "+appliedTransforms}}while(!selfOnly&&(el=el.parentNode))}var matrixFn=window.DOMMatrix||window.WebKitCSSMatrix||window.CSSMatrix||window.MSCSSMatrix;return matrixFn&&new matrixFn(appliedTransforms)}function find(ctx,tagName,iterator){if(ctx){var list=ctx.getElementsByTagName(tagName),i=0,n=list.length;if(iterator){for(;i<n;i++){iterator(list[i],i)}}return list}return[]}function getWindowScrollingElement(){var scrollingElement=document.scrollingElement;if(scrollingElement){return scrollingElement}else{return document.documentElement}}function getRect(el,relativeToContainingBlock,relativeToNonStaticParent,undoScale,container){if(!el.getBoundingClientRect&&el!==window)return;var elRect,top,left,bottom,right,height,width;if(el!==window&&el.parentNode&&el!==getWindowScrollingElement()){elRect=el.getBoundingClientRect();top=elRect.top;left=elRect.left;bottom=elRect.bottom;right=elRect.right;height=elRect.height;width=elRect.width}else{top=0;left=0;bottom=window.innerHeight;right=window.innerWidth;height=window.innerHeight;width=window.innerWidth}if((relativeToContainingBlock||relativeToNonStaticParent)&&el!==window){container=container||el.parentNode;if(!IE11OrLess){do{if(container&&container.getBoundingClientRect&&(css(container,"transform")!=="none"||relativeToNonStaticParent&&css(container,"position")!=="static")){var containerRect=container.getBoundingClientRect();top-=containerRect.top+parseInt(css(container,"border-top-width"));left-=containerRect.left+parseInt(css(container,"border-left-width"));bottom=top+elRect.height;right=left+elRect.width;break}}while(container=container.parentNode)}}if(undoScale&&el!==window){var elMatrix=matrix(container||el),scaleX=elMatrix&&elMatrix.a,scaleY=elMatrix&&elMatrix.d;if(elMatrix){top/=scaleY;left/=scaleX;width/=scaleX;height/=scaleY;bottom=top+height;right=left+width}}return{top:top,left:left,bottom:bottom,right:right,width:width,height:height}}function isScrolledPast(el,elSide,parentSide){var parent=getParentAutoScrollElement(el,true),elSideVal=getRect(el)[elSide];while(parent){var parentSideVal=getRect(parent)[parentSide],visible=void 0;if(parentSide==="top"||parentSide==="left"){visible=elSideVal>=parentSideVal}else{visible=elSideVal<=parentSideVal}if(!visible)return parent;if(parent===getWindowScrollingElement())break;parent=getParentAutoScrollElement(parent,false)}return false}function getChild(el,childNum,options,includeDragEl){var currentChild=0,i=0,children=el.children;while(i<children.length){if(children[i].style.display!=="none"&&children[i]!==Sortable.ghost&&(includeDragEl||children[i]!==Sortable.dragged)&&closest(children[i],options.draggable,el,false)){if(currentChild===childNum){return children[i]}currentChild++}i++}return null}function lastChild(el,selector){var last=el.lastElementChild;while(last&&(last===Sortable.ghost||css(last,"display")==="none"||selector&&!matches(last,selector))){last=last.previousElementSibling}return last||null}function index(el,selector){var index=0;if(!el||!el.parentNode){return-1}while(el=el.previousElementSibling){if(el.nodeName.toUpperCase()!=="TEMPLATE"&&el!==Sortable.clone&&(!selector||matches(el,selector))){index++}}return index}function getRelativeScrollOffset(el){var offsetLeft=0,offsetTop=0,winScroller=getWindowScrollingElement();if(el){do{var elMatrix=matrix(el),scaleX=elMatrix.a,scaleY=elMatrix.d;offsetLeft+=el.scrollLeft*scaleX;offsetTop+=el.scrollTop*scaleY}while(el!==winScroller&&(el=el.parentNode))}return[offsetLeft,offsetTop]}function indexOfObject(arr,obj){for(var i in arr){if(!arr.hasOwnProperty(i))continue;for(var key in obj){if(obj.hasOwnProperty(key)&&obj[key]===arr[i][key])return Number(i)}}return-1}function getParentAutoScrollElement(el,includeSelf){if(!el||!el.getBoundingClientRect)return getWindowScrollingElement();var elem=el;var gotSelf=false;do{if(elem.clientWidth<elem.scrollWidth||elem.clientHeight<elem.scrollHeight){var elemCSS=css(elem);if(elem.clientWidth<elem.scrollWidth&&(elemCSS.overflowX=="auto"||elemCSS.overflowX=="scroll")||elem.clientHeight<elem.scrollHeight&&(elemCSS.overflowY=="auto"||elemCSS.overflowY=="scroll")){if(!elem.getBoundingClientRect||elem===document.body)return getWindowScrollingElement();if(gotSelf||includeSelf)return elem;gotSelf=true}}}while(elem=elem.parentNode);return getWindowScrollingElement()}function extend(dst,src){if(dst&&src){for(var key in src){if(src.hasOwnProperty(key)){dst[key]=src[key]}}}return dst}function isRectEqual(rect1,rect2){return Math.round(rect1.top)===Math.round(rect2.top)&&Math.round(rect1.left)===Math.round(rect2.left)&&Math.round(rect1.height)===Math.round(rect2.height)&&Math.round(rect1.width)===Math.round(rect2.width)}var _throttleTimeout;function throttle(callback,ms){return function(){if(!_throttleTimeout){var args=arguments,_this=this;if(args.length===1){callback.call(_this,args[0])}else{callback.apply(_this,args)}_throttleTimeout=setTimeout(function(){_throttleTimeout=void 0},ms)}}}function cancelThrottle(){clearTimeout(_throttleTimeout);_throttleTimeout=void 0}function scrollBy(el,x,y){el.scrollLeft+=x;el.scrollTop+=y}function clone(el){var Polymer=window.Polymer;var $=window.jQuery||window.Zepto;if(Polymer&&Polymer.dom){return Polymer.dom(el).cloneNode(true)}else if($){return $(el).clone(true)[0]}else{return el.cloneNode(true)}}function setRect(el,rect){css(el,"position","absolute");css(el,"top",rect.top);css(el,"left",rect.left);css(el,"width",rect.width);css(el,"height",rect.height)}function unsetRect(el){css(el,"position","");css(el,"top","");css(el,"left","");css(el,"width","");css(el,"height","")}function getChildContainingRectFromElement(container,options,ghostEl){var rect={};Array.from(container.children).forEach(function(child){var _rect$left,_rect$top,_rect$right,_rect$bottom;if(!closest(child,options.draggable,container,false)||child.animated||child===ghostEl)return;var childRect=getRect(child);rect.left=Math.min((_rect$left=rect.left)!==null&&_rect$left!==void 0?_rect$left:Infinity,childRect.left);rect.top=Math.min((_rect$top=rect.top)!==null&&_rect$top!==void 0?_rect$top:Infinity,childRect.top);rect.right=Math.max((_rect$right=rect.right)!==null&&_rect$right!==void 0?_rect$right:-Infinity,childRect.right);rect.bottom=Math.max((_rect$bottom=rect.bottom)!==null&&_rect$bottom!==void 0?_rect$bottom:-Infinity,childRect.bottom)});rect.width=rect.right-rect.left;rect.height=rect.bottom-rect.top;rect.x=rect.left;rect.y=rect.top;return rect}var expando="Sortable"+(new Date).getTime();function AnimationStateManager(){var animationStates=[],animationCallbackId;return{captureAnimationState:function captureAnimationState(){animationStates=[];if(!this.options.animation)return;var children=[].slice.call(this.el.children);children.forEach(function(child){if(css(child,"display")==="none"||child===Sortable.ghost)return;animationStates.push({target:child,rect:getRect(child)});var fromRect=_objectSpread2({},animationStates[animationStates.length-1].rect);if(child.thisAnimationDuration){var childMatrix=matrix(child,true);if(childMatrix){fromRect.top-=childMatrix.f;fromRect.left-=childMatrix.e}}child.fromRect=fromRect})},addAnimationState:function addAnimationState(state){animationStates.push(state)},removeAnimationState:function removeAnimationState(target){animationStates.splice(indexOfObject(animationStates,{target:target}),1)},animateAll:function animateAll(callback){var _this=this;if(!this.options.animation){clearTimeout(animationCallbackId);if(typeof callback==="function")callback();return}var animating=false,animationTime=0;animationStates.forEach(function(state){var time=0,target=state.target,fromRect=target.fromRect,toRect=getRect(target),prevFromRect=target.prevFromRect,prevToRect=target.prevToRect,animatingRect=state.rect,targetMatrix=matrix(target,true);if(targetMatrix){toRect.top-=targetMatrix.f;toRect.left-=targetMatrix.e}target.toRect=toRect;if(target.thisAnimationDuration){if(isRectEqual(prevFromRect,toRect)&&!isRectEqual(fromRect,toRect)&&(animatingRect.top-toRect.top)/(animatingRect.left-toRect.left)===(fromRect.top-toRect.top)/(fromRect.left-toRect.left)){time=calculateRealTime(animatingRect,prevFromRect,prevToRect,_this.options)}}if(!isRectEqual(toRect,fromRect)){target.prevFromRect=fromRect;target.prevToRect=toRect;if(!time){time=_this.options.animation}_this.animate(target,animatingRect,toRect,time)}if(time){animating=true;animationTime=Math.max(animationTime,time);clearTimeout(target.animationResetTimer);target.animationResetTimer=setTimeout(function(){target.animationTime=0;target.prevFromRect=null;target.fromRect=null;target.prevToRect=null;target.thisAnimationDuration=null},time);target.thisAnimationDuration=time}});clearTimeout(animationCallbackId);if(!animating){if(typeof callback==="function")callback()}else{animationCallbackId=setTimeout(function(){if(typeof callback==="function")callback()},animationTime)}animationStates=[]},animate:function animate(target,currentRect,toRect,duration){if(duration){css(target,"transition","");css(target,"transform","");var elMatrix=matrix(this.el),scaleX=elMatrix&&elMatrix.a,scaleY=elMatrix&&elMatrix.d,translateX=(currentRect.left-toRect.left)/(scaleX||1),translateY=(currentRect.top-toRect.top)/(scaleY||1);target.animatingX=!!translateX;target.animatingY=!!translateY;css(target,"transform","translate3d("+translateX+"px,"+translateY+"px,0)");this.forRepaintDummy=repaint(target);css(target,"transition","transform "+duration+"ms"+(this.options.easing?" "+this.options.easing:""));css(target,"transform","translate3d(0,0,0)");typeof target.animated==="number"&&clearTimeout(target.animated);target.animated=setTimeout(function(){css(target,"transition","");css(target,"transform","");target.animated=false;target.animatingX=false;target.animatingY=false},duration)}}}}function repaint(target){return target.offsetWidth}function calculateRealTime(animatingRect,fromRect,toRect,options){return Math.sqrt(Math.pow(fromRect.top-animatingRect.top,2)+Math.pow(fromRect.left-animatingRect.left,2))/Math.sqrt(Math.pow(fromRect.top-toRect.top,2)+Math.pow(fromRect.left-toRect.left,2))*options.animation}var plugins=[];var defaults={initializeByDefault:true};var PluginManager={mount:function mount(plugin){for(var option in defaults){if(defaults.hasOwnProperty(option)&&!(option in plugin)){plugin[option]=defaults[option]}}plugins.forEach(function(p){if(p.pluginName===plugin.pluginName){throw"Sortable: Cannot mount plugin ".concat(plugin.pluginName," more than once")}});plugins.push(plugin)},pluginEvent:function pluginEvent(eventName,sortable,evt){var _this=this;this.eventCanceled=false;evt.cancel=function(){_this.eventCanceled=true};var eventNameGlobal=eventName+"Global";plugins.forEach(function(plugin){if(!sortable[plugin.pluginName])return;if(sortable[plugin.pluginName][eventNameGlobal]){sortable[plugin.pluginName][eventNameGlobal](_objectSpread2({sortable:sortable},evt))}if(sortable.options[plugin.pluginName]&&sortable[plugin.pluginName][eventName]){sortable[plugin.pluginName][eventName](_objectSpread2({sortable:sortable},evt))}})},initializePlugins:function initializePlugins(sortable,el,defaults,options){plugins.forEach(function(plugin){var pluginName=plugin.pluginName;if(!sortable.options[pluginName]&&!plugin.initializeByDefault)return;var initialized=new plugin(sortable,el,sortable.options);initialized.sortable=sortable;initialized.options=sortable.options;sortable[pluginName]=initialized;_extends(defaults,initialized.defaults)});for(var option in sortable.options){if(!sortable.options.hasOwnProperty(option))continue;var modified=this.modifyOption(sortable,option,sortable.options[option]);if(typeof modified!=="undefined"){sortable.options[option]=modified}}},getEventProperties:function getEventProperties(name,sortable){var eventProperties={};plugins.forEach(function(plugin){if(typeof plugin.eventProperties!=="function")return;_extends(eventProperties,plugin.eventProperties.call(sortable[plugin.pluginName],name))});return eventProperties},modifyOption:function modifyOption(sortable,name,value){var modifiedValue;plugins.forEach(function(plugin){if(!sortable[plugin.pluginName])return;if(plugin.optionListeners&&typeof plugin.optionListeners[name]==="function"){modifiedValue=plugin.optionListeners[name].call(sortable[plugin.pluginName],value)}});return modifiedValue}};function dispatchEvent(_ref){var sortable=_ref.sortable,rootEl=_ref.rootEl,name=_ref.name,targetEl=_ref.targetEl,cloneEl=_ref.cloneEl,toEl=_ref.toEl,fromEl=_ref.fromEl,oldIndex=_ref.oldIndex,newIndex=_ref.newIndex,oldDraggableIndex=_ref.oldDraggableIndex,newDraggableIndex=_ref.newDraggableIndex,originalEvent=_ref.originalEvent,putSortable=_ref.putSortable,extraEventProperties=_ref.extraEventProperties;sortable=sortable||rootEl&&rootEl[expando];if(!sortable)return;var evt,options=sortable.options,onName="on"+name.charAt(0).toUpperCase()+name.substr(1);if(window.CustomEvent&&!IE11OrLess&&!Edge){evt=new CustomEvent(name,{bubbles:true,cancelable:true})}else{evt=document.createEvent("Event");evt.initEvent(name,true,true)}evt.to=toEl||rootEl;evt.from=fromEl||rootEl;evt.item=targetEl||rootEl;evt.clone=cloneEl;evt.oldIndex=oldIndex;evt.newIndex=newIndex;evt.oldDraggableIndex=oldDraggableIndex;evt.newDraggableIndex=newDraggableIndex;evt.originalEvent=originalEvent;evt.pullMode=putSortable?putSortable.lastPutMode:undefined;var allEventProperties=_objectSpread2(_objectSpread2({},extraEventProperties),PluginManager.getEventProperties(name,sortable));for(var option in allEventProperties){evt[option]=allEventProperties[option]}if(rootEl){rootEl.dispatchEvent(evt)}if(options[onName]){options[onName].call(sortable,evt)}}var _excluded=["evt"];var pluginEvent=function pluginEvent(eventName,sortable){var _ref=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{},originalEvent=_ref.evt,data=_objectWithoutProperties(_ref,_excluded);PluginManager.pluginEvent.bind(Sortable)(eventName,sortable,_objectSpread2({dragEl:dragEl,parentEl:parentEl,ghostEl:ghostEl,rootEl:rootEl,nextEl:nextEl,lastDownEl:lastDownEl,cloneEl:cloneEl,cloneHidden:cloneHidden,dragStarted:moved,putSortable:putSortable,activeSortable:Sortable.active,originalEvent:originalEvent,oldIndex:oldIndex,oldDraggableIndex:oldDraggableIndex,newIndex:newIndex,newDraggableIndex:newDraggableIndex,hideGhostForTarget:_hideGhostForTarget,unhideGhostForTarget:_unhideGhostForTarget,cloneNowHidden:function cloneNowHidden(){cloneHidden=true},cloneNowShown:function cloneNowShown(){cloneHidden=false},dispatchSortableEvent:function dispatchSortableEvent(name){_dispatchEvent({sortable:sortable,name:name,originalEvent:originalEvent})}},data))};function _dispatchEvent(info){dispatchEvent(_objectSpread2({putSortable:putSortable,cloneEl:cloneEl,targetEl:dragEl,rootEl:rootEl,oldIndex:oldIndex,oldDraggableIndex:oldDraggableIndex,newIndex:newIndex,newDraggableIndex:newDraggableIndex},info))}var dragEl,parentEl,ghostEl,rootEl,nextEl,lastDownEl,cloneEl,cloneHidden,oldIndex,newIndex,oldDraggableIndex,newDraggableIndex,activeGroup,putSortable,awaitingDragStarted=false,ignoreNextClick=false,sortables=[],tapEvt,touchEvt,lastDx,lastDy,tapDistanceLeft,tapDistanceTop,moved,lastTarget,lastDirection,pastFirstInvertThresh=false,isCircumstantialInvert=false,targetMoveDistance,ghostRelativeParent,ghostRelativeParentInitialScroll=[],_silent=false,savedInputChecked=[];var documentExists=typeof document!=="undefined",PositionGhostAbsolutely=IOS,CSSFloatProperty=Edge||IE11OrLess?"cssFloat":"float",supportDraggable=documentExists&&!ChromeForAndroid&&!IOS&&"draggable"in document.createElement("div"),supportCssPointerEvents=function(){if(!documentExists)return;if(IE11OrLess){return false}var el=document.createElement("x");el.style.cssText="pointer-events:auto";return el.style.pointerEvents==="auto"}(),_detectDirection=function _detectDirection(el,options){var elCSS=css(el),elWidth=parseInt(elCSS.width)-parseInt(elCSS.paddingLeft)-parseInt(elCSS.paddingRight)-parseInt(elCSS.borderLeftWidth)-parseInt(elCSS.borderRightWidth),child1=getChild(el,0,options),child2=getChild(el,1,options),firstChildCSS=child1&&css(child1),secondChildCSS=child2&&css(child2),firstChildWidth=firstChildCSS&&parseInt(firstChildCSS.marginLeft)+parseInt(firstChildCSS.marginRight)+getRect(child1).width,secondChildWidth=secondChildCSS&&parseInt(secondChildCSS.marginLeft)+parseInt(secondChildCSS.marginRight)+getRect(child2).width;if(elCSS.display==="flex"){return elCSS.flexDirection==="column"||elCSS.flexDirection==="column-reverse"?"vertical":"horizontal"}if(elCSS.display==="grid"){return elCSS.gridTemplateColumns.split(" ").length<=1?"vertical":"horizontal"}if(child1&&firstChildCSS["float"]&&firstChildCSS["float"]!=="none"){var touchingSideChild2=firstChildCSS["float"]==="left"?"left":"right";return child2&&(secondChildCSS.clear==="both"||secondChildCSS.clear===touchingSideChild2)?"vertical":"horizontal"}return child1&&(firstChildCSS.display==="block"||firstChildCSS.display==="flex"||firstChildCSS.display==="table"||firstChildCSS.display==="grid"||firstChildWidth>=elWidth&&elCSS[CSSFloatProperty]==="none"||child2&&elCSS[CSSFloatProperty]==="none"&&firstChildWidth+secondChildWidth>elWidth)?"vertical":"horizontal"},_dragElInRowColumn=function _dragElInRowColumn(dragRect,targetRect,vertical){var dragElS1Opp=vertical?dragRect.left:dragRect.top,dragElS2Opp=vertical?dragRect.right:dragRect.bottom,dragElOppLength=vertical?dragRect.width:dragRect.height,targetS1Opp=vertical?targetRect.left:targetRect.top,targetS2Opp=vertical?targetRect.right:targetRect.bottom,targetOppLength=vertical?targetRect.width:targetRect.height;return dragElS1Opp===targetS1Opp||dragElS2Opp===targetS2Opp||dragElS1Opp+dragElOppLength/2===targetS1Opp+targetOppLength/2},_detectNearestEmptySortable=function _detectNearestEmptySortable(x,y){var ret;sortables.some(function(sortable){var threshold=sortable[expando].options.emptyInsertThreshold;if(!threshold||lastChild(sortable))return;var rect=getRect(sortable),insideHorizontally=x>=rect.left-threshold&&x<=rect.right+threshold,insideVertically=y>=rect.top-threshold&&y<=rect.bottom+threshold;if(insideHorizontally&&insideVertically){return ret=sortable}});return ret},_prepareGroup=function _prepareGroup(options){function toFn(value,pull){return function(to,from,dragEl,evt){var sameGroup=to.options.group.name&&from.options.group.name&&to.options.group.name===from.options.group.name;if(value==null&&(pull||sameGroup)){return true}else if(value==null||value===false){return false}else if(pull&&value==="clone"){return value}else if(typeof value==="function"){return toFn(value(to,from,dragEl,evt),pull)(to,from,dragEl,evt)}else{var otherGroup=(pull?to:from).options.group.name;return value===true||typeof value==="string"&&value===otherGroup||value.join&&value.indexOf(otherGroup)>-1}}}var group={};var originalGroup=options.group;if(!originalGroup||_typeof(originalGroup)!="object"){originalGroup={name:originalGroup}}group.name=originalGroup.name;group.checkPull=toFn(originalGroup.pull,true);group.checkPut=toFn(originalGroup.put);group.revertClone=originalGroup.revertClone;options.group=group},_hideGhostForTarget=function _hideGhostForTarget(){if(!supportCssPointerEvents&&ghostEl){css(ghostEl,"display","none")}},_unhideGhostForTarget=function _unhideGhostForTarget(){if(!supportCssPointerEvents&&ghostEl){css(ghostEl,"display","")}};if(documentExists&&!ChromeForAndroid){document.addEventListener("click",function(evt){if(ignoreNextClick){evt.preventDefault();evt.stopPropagation&&evt.stopPropagation();evt.stopImmediatePropagation&&evt.stopImmediatePropagation();ignoreNextClick=false;return false}},true)}var nearestEmptyInsertDetectEvent=function nearestEmptyInsertDetectEvent(evt){if(dragEl){evt=evt.touches?evt.touches[0]:evt;var nearest=_detectNearestEmptySortable(evt.clientX,evt.clientY);if(nearest){var event={};for(var i in evt){if(evt.hasOwnProperty(i)){event[i]=evt[i]}}event.target=event.rootEl=nearest;event.preventDefault=void 0;event.stopPropagation=void 0;nearest[expando]._onDragOver(event)}}};var _checkOutsideTargetEl=function _checkOutsideTargetEl(evt){if(dragEl){dragEl.parentNode[expando]._isOutsideThisEl(evt.target)}};function Sortable(el,options){if(!(el&&el.nodeType&&el.nodeType===1)){throw"Sortable: `el` must be an HTMLElement, not ".concat({}.toString.call(el))}this.el=el;this.options=options=_extends({},options);el[expando]=this;var defaults={group:null,sort:true,disabled:false,store:null,handle:null,draggable:/^[uo]l$/i.test(el.nodeName)?">li":">*",swapThreshold:1,invertSwap:false,invertedSwapThreshold:null,removeCloneOnHide:true,direction:function direction(){return _detectDirection(el,this.options)},ghostClass:"sortable-ghost",chosenClass:"sortable-chosen",dragClass:"sortable-drag",ignore:"a, img",filter:null,preventOnFilter:true,animation:0,easing:null,setData:function setData(dataTransfer,dragEl){dataTransfer.setData("Text",dragEl.textContent)},dropBubble:false,dragoverBubble:false,dataIdAttr:"data-id",delay:0,delayOnTouchOnly:false,touchStartThreshold:(Number.parseInt?Number:window).parseInt(window.devicePixelRatio,10)||1,forceFallback:false,fallbackClass:"sortable-fallback",fallbackOnBody:false,fallbackTolerance:0,fallbackOffset:{x:0,y:0},supportPointer:Sortable.supportPointer!==false&&"PointerEvent"in window&&(!Safari||IOS),emptyInsertThreshold:5};PluginManager.initializePlugins(this,el,defaults);for(var name in defaults){!(name in options)&&(options[name]=defaults[name])}_prepareGroup(options);for(var fn in this){if(fn.charAt(0)==="_"&&typeof this[fn]==="function"){this[fn]=this[fn].bind(this)}}this.nativeDraggable=options.forceFallback?false:supportDraggable;if(this.nativeDraggable){this.options.touchStartThreshold=1}if(options.supportPointer){on(el,"pointerdown",this._onTapStart)}else{on(el,"mousedown",this._onTapStart);on(el,"touchstart",this._onTapStart)}if(this.nativeDraggable){on(el,"dragover",this);on(el,"dragenter",this)}sortables.push(this.el);options.store&&options.store.get&&this.sort(options.store.get(this)||[]);_extends(this,AnimationStateManager())}Sortable.prototype={constructor:Sortable,_isOutsideThisEl:function _isOutsideThisEl(target){if(!this.el.contains(target)&&target!==this.el){lastTarget=null}},_getDirection:function _getDirection(evt,target){return typeof this.options.direction==="function"?this.options.direction.call(this,evt,target,dragEl):this.options.direction},_onTapStart:function _onTapStart(evt){if(!evt.cancelable)return;var _this=this,el=this.el,options=this.options,preventOnFilter=options.preventOnFilter,type=evt.type,touch=evt.touches&&evt.touches[0]||evt.pointerType&&evt.pointerType==="touch"&&evt,target=(touch||evt).target,originalTarget=evt.target.shadowRoot&&(evt.path&&evt.path[0]||evt.composedPath&&evt.composedPath()[0])||target,filter=options.filter;_saveInputCheckedState(el);if(dragEl){return}if(/mousedown|pointerdown/.test(type)&&evt.button!==0||options.disabled){return}if(originalTarget.isContentEditable){return}if(!this.nativeDraggable&&Safari&&target&&target.tagName.toUpperCase()==="SELECT"){return}target=closest(target,options.draggable,el,false);if(target&&target.animated){return}if(lastDownEl===target){return}oldIndex=index(target);oldDraggableIndex=index(target,options.draggable);if(typeof filter==="function"){if(filter.call(this,evt,target,this)){_dispatchEvent({sortable:_this,rootEl:originalTarget,name:"filter",targetEl:target,toEl:el,fromEl:el});pluginEvent("filter",_this,{evt:evt});preventOnFilter&&evt.preventDefault();return}}else if(filter){filter=filter.split(",").some(function(criteria){criteria=closest(originalTarget,criteria.trim(),el,false);if(criteria){_dispatchEvent({sortable:_this,rootEl:criteria,name:"filter",targetEl:target,fromEl:el,toEl:el});pluginEvent("filter",_this,{evt:evt});return true}});if(filter){preventOnFilter&&evt.preventDefault();return}}if(options.handle&&!closest(originalTarget,options.handle,el,false)){return}this._prepareDragStart(evt,touch,target)},_prepareDragStart:function _prepareDragStart(evt,touch,target){var _this=this,el=_this.el,options=_this.options,ownerDocument=el.ownerDocument,dragStartFn;if(target&&!dragEl&&target.parentNode===el){var dragRect=getRect(target);rootEl=el;dragEl=target;parentEl=dragEl.parentNode;nextEl=dragEl.nextSibling;lastDownEl=target;activeGroup=options.group;Sortable.dragged=dragEl;tapEvt={target:dragEl,clientX:(touch||evt).clientX,clientY:(touch||evt).clientY};tapDistanceLeft=tapEvt.clientX-dragRect.left;tapDistanceTop=tapEvt.clientY-dragRect.top;this._lastX=(touch||evt).clientX;this._lastY=(touch||evt).clientY;dragEl.style["will-change"]="all";dragStartFn=function dragStartFn(){pluginEvent("delayEnded",_this,{evt:evt});if(Sortable.eventCanceled){_this._onDrop();return}_this._disableDelayedDragEvents();if(!FireFox&&_this.nativeDraggable){dragEl.draggable=true}_this._triggerDragStart(evt,touch);_dispatchEvent({sortable:_this,name:"choose",originalEvent:evt});toggleClass(dragEl,options.chosenClass,true)};options.ignore.split(",").forEach(function(criteria){find(dragEl,criteria.trim(),_disableDraggable)});on(ownerDocument,"dragover",nearestEmptyInsertDetectEvent);on(ownerDocument,"mousemove",nearestEmptyInsertDetectEvent);on(ownerDocument,"touchmove",nearestEmptyInsertDetectEvent);if(options.supportPointer){on(ownerDocument,"pointerup",_this._onDrop);!this.nativeDraggable&&on(ownerDocument,"pointercancel",_this._onDrop)}else{on(ownerDocument,"mouseup",_this._onDrop);on(ownerDocument,"touchend",_this._onDrop);on(ownerDocument,"touchcancel",_this._onDrop)}if(FireFox&&this.nativeDraggable){this.options.touchStartThreshold=4;dragEl.draggable=true}pluginEvent("delayStart",this,{evt:evt});if(options.delay&&(!options.delayOnTouchOnly||touch)&&(!this.nativeDraggable||!(Edge||IE11OrLess))){if(Sortable.eventCanceled){this._onDrop();return}if(options.supportPointer){on(ownerDocument,"pointerup",_this._disableDelayedDrag);on(ownerDocument,"pointercancel",_this._disableDelayedDrag)}else{on(ownerDocument,"mouseup",_this._disableDelayedDrag);on(ownerDocument,"touchend",_this._disableDelayedDrag);on(ownerDocument,"touchcancel",_this._disableDelayedDrag)}on(ownerDocument,"mousemove",_this._delayedDragTouchMoveHandler);on(ownerDocument,"touchmove",_this._delayedDragTouchMoveHandler);options.supportPointer&&on(ownerDocument,"pointermove",_this._delayedDragTouchMoveHandler);_this._dragStartTimer=setTimeout(dragStartFn,options.delay)}else{dragStartFn()}}},_delayedDragTouchMoveHandler:function _delayedDragTouchMoveHandler(e){var touch=e.touches?e.touches[0]:e;if(Math.max(Math.abs(touch.clientX-this._lastX),Math.abs(touch.clientY-this._lastY))>=Math.floor(this.options.touchStartThreshold/(this.nativeDraggable&&window.devicePixelRatio||1))){this._disableDelayedDrag()}},_disableDelayedDrag:function _disableDelayedDrag(){dragEl&&_disableDraggable(dragEl);clearTimeout(this._dragStartTimer);this._disableDelayedDragEvents()},_disableDelayedDragEvents:function _disableDelayedDragEvents(){var ownerDocument=this.el.ownerDocument;off(ownerDocument,"mouseup",this._disableDelayedDrag);off(ownerDocument,"touchend",this._disableDelayedDrag);off(ownerDocument,"touchcancel",this._disableDelayedDrag);off(ownerDocument,"pointerup",this._disableDelayedDrag);off(ownerDocument,"pointercancel",this._disableDelayedDrag);off(ownerDocument,"mousemove",this._delayedDragTouchMoveHandler);off(ownerDocument,"touchmove",this._delayedDragTouchMoveHandler);off(ownerDocument,"pointermove",this._delayedDragTouchMoveHandler)},_triggerDragStart:function _triggerDragStart(evt,touch){touch=touch||evt.pointerType=="touch"&&evt;if(!this.nativeDraggable||touch){if(this.options.supportPointer){on(document,"pointermove",this._onTouchMove)}else if(touch){on(document,"touchmove",this._onTouchMove)}else{on(document,"mousemove",this._onTouchMove)}}else{on(dragEl,"dragend",this);on(rootEl,"dragstart",this._onDragStart)}try{if(document.selection){_nextTick(function(){document.selection.empty()})}else{window.getSelection().removeAllRanges()}}catch(err){}},_dragStarted:function _dragStarted(fallback,evt){awaitingDragStarted=false;if(rootEl&&dragEl){pluginEvent("dragStarted",this,{evt:evt});if(this.nativeDraggable){on(document,"dragover",_checkOutsideTargetEl)}var options=this.options;!fallback&&toggleClass(dragEl,options.dragClass,false);toggleClass(dragEl,options.ghostClass,true);Sortable.active=this;fallback&&this._appendGhost();_dispatchEvent({sortable:this,name:"start",originalEvent:evt})}else{this._nulling()}},_emulateDragOver:function _emulateDragOver(){if(touchEvt){this._lastX=touchEvt.clientX;this._lastY=touchEvt.clientY;_hideGhostForTarget();var target=document.elementFromPoint(touchEvt.clientX,touchEvt.clientY);var parent=target;while(target&&target.shadowRoot){target=target.shadowRoot.elementFromPoint(touchEvt.clientX,touchEvt.clientY);if(target===parent)break;parent=target}dragEl.parentNode[expando]._isOutsideThisEl(target);if(parent){do{if(parent[expando]){var inserted=void 0;inserted=parent[expando]._onDragOver({clientX:touchEvt.clientX,clientY:touchEvt.clientY,target:target,rootEl:parent});if(inserted&&!this.options.dragoverBubble){break}}target=parent}while(parent=getParentOrHost(parent))}_unhideGhostForTarget()}},_onTouchMove:function _onTouchMove(evt){if(tapEvt){var options=this.options,fallbackTolerance=options.fallbackTolerance,fallbackOffset=options.fallbackOffset,touch=evt.touches?evt.touches[0]:evt,ghostMatrix=ghostEl&&matrix(ghostEl,true),scaleX=ghostEl&&ghostMatrix&&ghostMatrix.a,scaleY=ghostEl&&ghostMatrix&&ghostMatrix.d,relativeScrollOffset=PositionGhostAbsolutely&&ghostRelativeParent&&getRelativeScrollOffset(ghostRelativeParent),dx=(touch.clientX-tapEvt.clientX+fallbackOffset.x)/(scaleX||1)+(relativeScrollOffset?relativeScrollOffset[0]-ghostRelativeParentInitialScroll[0]:0)/(scaleX||1),dy=(touch.clientY-tapEvt.clientY+fallbackOffset.y)/(scaleY||1)+(relativeScrollOffset?relativeScrollOffset[1]-ghostRelativeParentInitialScroll[1]:0)/(scaleY||1);if(!Sortable.active&&!awaitingDragStarted){if(fallbackTolerance&&Math.max(Math.abs(touch.clientX-this._lastX),Math.abs(touch.clientY-this._lastY))<fallbackTolerance){return}this._onDragStart(evt,true)}if(ghostEl){if(ghostMatrix){ghostMatrix.e+=dx-(lastDx||0);ghostMatrix.f+=dy-(lastDy||0)}else{ghostMatrix={a:1,b:0,c:0,d:1,e:dx,f:dy}}var cssMatrix="matrix(".concat(ghostMatrix.a,",").concat(ghostMatrix.b,",").concat(ghostMatrix.c,",").concat(ghostMatrix.d,",").concat(ghostMatrix.e,",").concat(ghostMatrix.f,")");css(ghostEl,"webkitTransform",cssMatrix);css(ghostEl,"mozTransform",cssMatrix);css(ghostEl,"msTransform",cssMatrix);css(ghostEl,"transform",cssMatrix);lastDx=dx;lastDy=dy;touchEvt=touch}evt.cancelable&&evt.preventDefault()}},_appendGhost:function _appendGhost(){if(!ghostEl){var container=this.options.fallbackOnBody?document.body:rootEl,rect=getRect(dragEl,true,PositionGhostAbsolutely,true,container),options=this.options;if(PositionGhostAbsolutely){ghostRelativeParent=container;while(css(ghostRelativeParent,"position")==="static"&&css(ghostRelativeParent,"transform")==="none"&&ghostRelativeParent!==document){ghostRelativeParent=ghostRelativeParent.parentNode}if(ghostRelativeParent!==document.body&&ghostRelativeParent!==document.documentElement){if(ghostRelativeParent===document)ghostRelativeParent=getWindowScrollingElement();rect.top+=ghostRelativeParent.scrollTop;rect.left+=ghostRelativeParent.scrollLeft}else{ghostRelativeParent=getWindowScrollingElement()}ghostRelativeParentInitialScroll=getRelativeScrollOffset(ghostRelativeParent)}ghostEl=dragEl.cloneNode(true);toggleClass(ghostEl,options.ghostClass,false);toggleClass(ghostEl,options.fallbackClass,true);toggleClass(ghostEl,options.dragClass,true);css(ghostEl,"transition","");css(ghostEl,"transform","");css(ghostEl,"box-sizing","border-box");css(ghostEl,"margin",0);css(ghostEl,"top",rect.top);css(ghostEl,"left",rect.left);css(ghostEl,"width",rect.width);css(ghostEl,"height",rect.height);css(ghostEl,"opacity","0.8");css(ghostEl,"position",PositionGhostAbsolutely?"absolute":"fixed");css(ghostEl,"zIndex","100000");css(ghostEl,"pointerEvents","none");Sortable.ghost=ghostEl;container.appendChild(ghostEl);css(ghostEl,"transform-origin",tapDistanceLeft/parseInt(ghostEl.style.width)*100+"% "+tapDistanceTop/parseInt(ghostEl.style.height)*100+"%")}},_onDragStart:function _onDragStart(evt,fallback){var _this=this;var dataTransfer=evt.dataTransfer;var options=_this.options;pluginEvent("dragStart",this,{evt:evt});if(Sortable.eventCanceled){this._onDrop();return}pluginEvent("setupClone",this);if(!Sortable.eventCanceled){cloneEl=clone(dragEl);cloneEl.removeAttribute("id");cloneEl.draggable=false;cloneEl.style["will-change"]="";this._hideClone();toggleClass(cloneEl,this.options.chosenClass,false);Sortable.clone=cloneEl}_this.cloneId=_nextTick(function(){pluginEvent("clone",_this);if(Sortable.eventCanceled)return;if(!_this.options.removeCloneOnHide){rootEl.insertBefore(cloneEl,dragEl)}_this._hideClone();_dispatchEvent({sortable:_this,name:"clone"})});!fallback&&toggleClass(dragEl,options.dragClass,true);if(fallback){ignoreNextClick=true;_this._loopId=setInterval(_this._emulateDragOver,50)}else{off(document,"mouseup",_this._onDrop);off(document,"touchend",_this._onDrop);off(document,"touchcancel",_this._onDrop);if(dataTransfer){dataTransfer.effectAllowed="move";options.setData&&options.setData.call(_this,dataTransfer,dragEl)}on(document,"drop",_this);css(dragEl,"transform","translateZ(0)")}awaitingDragStarted=true;_this._dragStartId=_nextTick(_this._dragStarted.bind(_this,fallback,evt));on(document,"selectstart",_this);moved=true;window.getSelection().removeAllRanges();if(Safari){css(document.body,"user-select","none")}},_onDragOver:function _onDragOver(evt){var el=this.el,target=evt.target,dragRect,targetRect,revert,options=this.options,group=options.group,activeSortable=Sortable.active,isOwner=activeGroup===group,canSort=options.sort,fromSortable=putSortable||activeSortable,vertical,_this=this,completedFired=false;if(_silent)return;function dragOverEvent(name,extra){pluginEvent(name,_this,_objectSpread2({evt:evt,isOwner:isOwner,axis:vertical?"vertical":"horizontal",revert:revert,dragRect:dragRect,targetRect:targetRect,canSort:canSort,fromSortable:fromSortable,target:target,completed:completed,onMove:function onMove(target,after){return _onMove(rootEl,el,dragEl,dragRect,target,getRect(target),evt,after)},changed:changed},extra))}function capture(){dragOverEvent("dragOverAnimationCapture");_this.captureAnimationState();if(_this!==fromSortable){fromSortable.captureAnimationState()}}function completed(insertion){dragOverEvent("dragOverCompleted",{insertion:insertion});if(insertion){if(isOwner){activeSortable._hideClone()}else{activeSortable._showClone(_this)}if(_this!==fromSortable){toggleClass(dragEl,putSortable?putSortable.options.ghostClass:activeSortable.options.ghostClass,false);toggleClass(dragEl,options.ghostClass,true)}if(putSortable!==_this&&_this!==Sortable.active){putSortable=_this}else if(_this===Sortable.active&&putSortable){putSortable=null}if(fromSortable===_this){_this._ignoreWhileAnimating=target}_this.animateAll(function(){dragOverEvent("dragOverAnimationComplete");_this._ignoreWhileAnimating=null});if(_this!==fromSortable){fromSortable.animateAll();fromSortable._ignoreWhileAnimating=null}}if(target===dragEl&&!dragEl.animated||target===el&&!target.animated){lastTarget=null}if(!options.dragoverBubble&&!evt.rootEl&&target!==document){dragEl.parentNode[expando]._isOutsideThisEl(evt.target);!insertion&&nearestEmptyInsertDetectEvent(evt)}!options.dragoverBubble&&evt.stopPropagation&&evt.stopPropagation();return completedFired=true}function changed(){newIndex=index(dragEl);newDraggableIndex=index(dragEl,options.draggable);_dispatchEvent({sortable:_this,name:"change",toEl:el,newIndex:newIndex,newDraggableIndex:newDraggableIndex,originalEvent:evt})}if(evt.preventDefault!==void 0){evt.cancelable&&evt.preventDefault()}target=closest(target,options.draggable,el,true);dragOverEvent("dragOver");if(Sortable.eventCanceled)return completedFired;if(dragEl.contains(evt.target)||target.animated&&target.animatingX&&target.animatingY||_this._ignoreWhileAnimating===target){return completed(false)}ignoreNextClick=false;if(activeSortable&&!options.disabled&&(isOwner?canSort||(revert=parentEl!==rootEl):putSortable===this||(this.lastPutMode=activeGroup.checkPull(this,activeSortable,dragEl,evt))&&group.checkPut(this,activeSortable,dragEl,evt))){vertical=this._getDirection(evt,target)==="vertical";dragRect=getRect(dragEl);dragOverEvent("dragOverValid");if(Sortable.eventCanceled)return completedFired;if(revert){parentEl=rootEl;capture();this._hideClone();dragOverEvent("revert");if(!Sortable.eventCanceled){if(nextEl){rootEl.insertBefore(dragEl,nextEl)}else{rootEl.appendChild(dragEl)}}return completed(true)}var elLastChild=lastChild(el,options.draggable);if(!elLastChild||_ghostIsLast(evt,vertical,this)&&!elLastChild.animated){if(elLastChild===dragEl){return completed(false)}if(elLastChild&&el===evt.target){target=elLastChild}if(target){targetRect=getRect(target)}if(_onMove(rootEl,el,dragEl,dragRect,target,targetRect,evt,!!target)!==false){capture();if(elLastChild&&elLastChild.nextSibling){el.insertBefore(dragEl,elLastChild.nextSibling)}else{el.appendChild(dragEl)}parentEl=el;changed();return completed(true)}}else if(elLastChild&&_ghostIsFirst(evt,vertical,this)){var firstChild=getChild(el,0,options,true);if(firstChild===dragEl){return completed(false)}target=firstChild;targetRect=getRect(target);if(_onMove(rootEl,el,dragEl,dragRect,target,targetRect,evt,false)!==false){capture();el.insertBefore(dragEl,firstChild);parentEl=el;changed();return completed(true)}}else if(target.parentNode===el){targetRect=getRect(target);var direction=0,targetBeforeFirstSwap,differentLevel=dragEl.parentNode!==el,differentRowCol=!_dragElInRowColumn(dragEl.animated&&dragEl.toRect||dragRect,target.animated&&target.toRect||targetRect,vertical),side1=vertical?"top":"left",scrolledPastTop=isScrolledPast(target,"top","top")||isScrolledPast(dragEl,"top","top"),scrollBefore=scrolledPastTop?scrolledPastTop.scrollTop:void 0;if(lastTarget!==target){targetBeforeFirstSwap=targetRect[side1];pastFirstInvertThresh=false;isCircumstantialInvert=!differentRowCol&&options.invertSwap||differentLevel}direction=_getSwapDirection(evt,target,targetRect,vertical,differentRowCol?1:options.swapThreshold,options.invertedSwapThreshold==null?options.swapThreshold:options.invertedSwapThreshold,isCircumstantialInvert,lastTarget===target);var sibling;if(direction!==0){var dragIndex=index(dragEl);do{dragIndex-=direction;sibling=parentEl.children[dragIndex]}while(sibling&&(css(sibling,"display")==="none"||sibling===ghostEl))}if(direction===0||sibling===target){return completed(false)}lastTarget=target;lastDirection=direction;var nextSibling=target.nextElementSibling,after=false;after=direction===1;var moveVector=_onMove(rootEl,el,dragEl,dragRect,target,targetRect,evt,after);if(moveVector!==false){if(moveVector===1||moveVector===-1){after=moveVector===1}_silent=true;setTimeout(_unsilent,30);capture();if(after&&!nextSibling){el.appendChild(dragEl)}else{target.parentNode.insertBefore(dragEl,after?nextSibling:target)}if(scrolledPastTop){scrollBy(scrolledPastTop,0,scrollBefore-scrolledPastTop.scrollTop)}parentEl=dragEl.parentNode;if(targetBeforeFirstSwap!==undefined&&!isCircumstantialInvert){targetMoveDistance=Math.abs(targetBeforeFirstSwap-getRect(target)[side1])}changed();return completed(true)}}if(el.contains(dragEl)){return completed(false)}}return false},_ignoreWhileAnimating:null,_offMoveEvents:function _offMoveEvents(){off(document,"mousemove",this._onTouchMove);off(document,"touchmove",this._onTouchMove);off(document,"pointermove",this._onTouchMove);off(document,"dragover",nearestEmptyInsertDetectEvent);off(document,"mousemove",nearestEmptyInsertDetectEvent);off(document,"touchmove",nearestEmptyInsertDetectEvent)},_offUpEvents:function _offUpEvents(){var ownerDocument=this.el.ownerDocument;off(ownerDocument,"mouseup",this._onDrop);off(ownerDocument,"touchend",this._onDrop);off(ownerDocument,"pointerup",this._onDrop);off(ownerDocument,"pointercancel",this._onDrop);off(ownerDocument,"touchcancel",this._onDrop);off(document,"selectstart",this)},_onDrop:function _onDrop(evt){var el=this.el,options=this.options;newIndex=index(dragEl);newDraggableIndex=index(dragEl,options.draggable);pluginEvent("drop",this,{evt:evt});parentEl=dragEl&&dragEl.parentNode;newIndex=index(dragEl);newDraggableIndex=index(dragEl,options.draggable);if(Sortable.eventCanceled){this._nulling();return}awaitingDragStarted=false;isCircumstantialInvert=false;pastFirstInvertThresh=false;clearInterval(this._loopId);clearTimeout(this._dragStartTimer);_cancelNextTick(this.cloneId);_cancelNextTick(this._dragStartId);if(this.nativeDraggable){off(document,"drop",this);off(el,"dragstart",this._onDragStart)}this._offMoveEvents();this._offUpEvents();if(Safari){css(document.body,"user-select","")}css(dragEl,"transform","");if(evt){if(moved){evt.cancelable&&evt.preventDefault();!options.dropBubble&&evt.stopPropagation()}ghostEl&&ghostEl.parentNode&&ghostEl.parentNode.removeChild(ghostEl);if(rootEl===parentEl||putSortable&&putSortable.lastPutMode!=="clone"){cloneEl&&cloneEl.parentNode&&cloneEl.parentNode.removeChild(cloneEl)}if(dragEl){if(this.nativeDraggable){off(dragEl,"dragend",this)}_disableDraggable(dragEl);dragEl.style["will-change"]="";if(moved&&!awaitingDragStarted){toggleClass(dragEl,putSortable?putSortable.options.ghostClass:this.options.ghostClass,false)}toggleClass(dragEl,this.options.chosenClass,false);_dispatchEvent({sortable:this,name:"unchoose",toEl:parentEl,newIndex:null,newDraggableIndex:null,originalEvent:evt});if(rootEl!==parentEl){if(newIndex>=0){_dispatchEvent({rootEl:parentEl,name:"add",toEl:parentEl,fromEl:rootEl,originalEvent:evt});_dispatchEvent({sortable:this,name:"remove",toEl:parentEl,originalEvent:evt});_dispatchEvent({rootEl:parentEl,name:"sort",toEl:parentEl,fromEl:rootEl,originalEvent:evt});_dispatchEvent({sortable:this,name:"sort",toEl:parentEl,originalEvent:evt})}putSortable&&putSortable.save()}else{if(newIndex!==oldIndex){if(newIndex>=0){_dispatchEvent({sortable:this,name:"update",toEl:parentEl,originalEvent:evt});_dispatchEvent({sortable:this,name:"sort",toEl:parentEl,originalEvent:evt})}}}if(Sortable.active){if(newIndex==null||newIndex===-1){newIndex=oldIndex;newDraggableIndex=oldDraggableIndex}_dispatchEvent({sortable:this,name:"end",toEl:parentEl,originalEvent:evt});this.save()}}}this._nulling()},_nulling:function _nulling(){pluginEvent("nulling",this);rootEl=dragEl=parentEl=ghostEl=nextEl=cloneEl=lastDownEl=cloneHidden=tapEvt=touchEvt=moved=newIndex=newDraggableIndex=oldIndex=oldDraggableIndex=lastTarget=lastDirection=putSortable=activeGroup=Sortable.dragged=Sortable.ghost=Sortable.clone=Sortable.active=null;savedInputChecked.forEach(function(el){el.checked=true});savedInputChecked.length=lastDx=lastDy=0},handleEvent:function handleEvent(evt){switch(evt.type){case"drop":case"dragend":this._onDrop(evt);break;case"dragenter":case"dragover":if(dragEl){this._onDragOver(evt);_globalDragOver(evt)}break;case"selectstart":evt.preventDefault();break}},toArray:function toArray(){var order=[],el,children=this.el.children,i=0,n=children.length,options=this.options;for(;i<n;i++){el=children[i];if(closest(el,options.draggable,this.el,false)){order.push(el.getAttribute(options.dataIdAttr)||_generateId(el))}}return order},sort:function sort(order,useAnimation){var items={},rootEl=this.el;this.toArray().forEach(function(id,i){var el=rootEl.children[i];if(closest(el,this.options.draggable,rootEl,false)){items[id]=el}},this);useAnimation&&this.captureAnimationState();order.forEach(function(id){if(items[id]){rootEl.removeChild(items[id]);rootEl.appendChild(items[id])}});useAnimation&&this.animateAll()},save:function save(){var store=this.options.store;store&&store.set&&store.set(this)},closest:function closest$1(el,selector){return closest(el,selector||this.options.draggable,this.el,false)},option:function option(name,value){var options=this.options;if(value===void 0){return options[name]}else{var modifiedValue=PluginManager.modifyOption(this,name,value);if(typeof modifiedValue!=="undefined"){options[name]=modifiedValue}else{options[name]=value}if(name==="group"){_prepareGroup(options)}}},destroy:function destroy(){pluginEvent("destroy",this);var el=this.el;el[expando]=null;off(el,"mousedown",this._onTapStart);off(el,"touchstart",this._onTapStart);off(el,"pointerdown",this._onTapStart);if(this.nativeDraggable){off(el,"dragover",this);off(el,"dragenter",this)}Array.prototype.forEach.call(el.querySelectorAll("[draggable]"),function(el){el.removeAttribute("draggable")});this._onDrop();this._disableDelayedDragEvents();sortables.splice(sortables.indexOf(this.el),1);this.el=el=null},_hideClone:function _hideClone(){if(!cloneHidden){pluginEvent("hideClone",this);if(Sortable.eventCanceled)return;css(cloneEl,"display","none");if(this.options.removeCloneOnHide&&cloneEl.parentNode){cloneEl.parentNode.removeChild(cloneEl)}cloneHidden=true}},_showClone:function _showClone(putSortable){if(putSortable.lastPutMode!=="clone"){this._hideClone();return}if(cloneHidden){pluginEvent("showClone",this);if(Sortable.eventCanceled)return;if(dragEl.parentNode==rootEl&&!this.options.group.revertClone){rootEl.insertBefore(cloneEl,dragEl)}else if(nextEl){rootEl.insertBefore(cloneEl,nextEl)}else{rootEl.appendChild(cloneEl)}if(this.options.group.revertClone){this.animate(dragEl,cloneEl)}css(cloneEl,"display","");cloneHidden=false}}};function _globalDragOver(evt){if(evt.dataTransfer){evt.dataTransfer.dropEffect="move"}evt.cancelable&&evt.preventDefault()}function _onMove(fromEl,toEl,dragEl,dragRect,targetEl,targetRect,originalEvent,willInsertAfter){var evt,sortable=fromEl[expando],onMoveFn=sortable.options.onMove,retVal;if(window.CustomEvent&&!IE11OrLess&&!Edge){evt=new CustomEvent("move",{bubbles:true,cancelable:true})}else{evt=document.createEvent("Event");evt.initEvent("move",true,true)}evt.to=toEl;evt.from=fromEl;evt.dragged=dragEl;evt.draggedRect=dragRect;evt.related=targetEl||toEl;evt.relatedRect=targetRect||getRect(toEl);evt.willInsertAfter=willInsertAfter;evt.originalEvent=originalEvent;fromEl.dispatchEvent(evt);if(onMoveFn){retVal=onMoveFn.call(sortable,evt,originalEvent)}return retVal}function _disableDraggable(el){el.draggable=false}function _unsilent(){_silent=false}function _ghostIsFirst(evt,vertical,sortable){var firstElRect=getRect(getChild(sortable.el,0,sortable.options,true));var childContainingRect=getChildContainingRectFromElement(sortable.el,sortable.options,ghostEl);var spacer=10;return vertical?evt.clientX<childContainingRect.left-spacer||evt.clientY<firstElRect.top&&evt.clientX<firstElRect.right:evt.clientY<childContainingRect.top-spacer||evt.clientY<firstElRect.bottom&&evt.clientX<firstElRect.left}function _ghostIsLast(evt,vertical,sortable){var lastElRect=getRect(lastChild(sortable.el,sortable.options.draggable));var childContainingRect=getChildContainingRectFromElement(sortable.el,sortable.options,ghostEl);var spacer=10;return vertical?evt.clientX>childContainingRect.right+spacer||evt.clientY>lastElRect.bottom&&evt.clientX>lastElRect.left:evt.clientY>childContainingRect.bottom+spacer||evt.clientX>lastElRect.right&&evt.clientY>lastElRect.top}function _getSwapDirection(evt,target,targetRect,vertical,swapThreshold,invertedSwapThreshold,invertSwap,isLastTarget){var mouseOnAxis=vertical?evt.clientY:evt.clientX,targetLength=vertical?targetRect.height:targetRect.width,targetS1=vertical?targetRect.top:targetRect.left,targetS2=vertical?targetRect.bottom:targetRect.right,invert=false;if(!invertSwap){if(isLastTarget&&targetMoveDistance<targetLength*swapThreshold){if(!pastFirstInvertThresh&&(lastDirection===1?mouseOnAxis>targetS1+targetLength*invertedSwapThreshold/2:mouseOnAxis<targetS2-targetLength*invertedSwapThreshold/2)){pastFirstInvertThresh=true}if(!pastFirstInvertThresh){if(lastDirection===1?mouseOnAxis<targetS1+targetMoveDistance:mouseOnAxis>targetS2-targetMoveDistance){return-lastDirection}}else{invert=true}}else{if(mouseOnAxis>targetS1+targetLength*(1-swapThreshold)/2&&mouseOnAxis<targetS2-targetLength*(1-swapThreshold)/2){return _getInsertDirection(target)}}}invert=invert||invertSwap;if(invert){if(mouseOnAxis<targetS1+targetLength*invertedSwapThreshold/2||mouseOnAxis>targetS2-targetLength*invertedSwapThreshold/2){return mouseOnAxis>targetS1+targetLength/2?1:-1}}return 0}function _getInsertDirection(target){if(index(dragEl)<index(target)){return 1}else{return-1}}function _generateId(el){var str=el.tagName+el.className+el.src+el.href+el.textContent,i=str.length,sum=0;while(i--){sum+=str.charCodeAt(i)}return sum.toString(36)}function _saveInputCheckedState(root){savedInputChecked.length=0;var inputs=root.getElementsByTagName("input");var idx=inputs.length;while(idx--){var el=inputs[idx];el.checked&&savedInputChecked.push(el)}}function _nextTick(fn){return setTimeout(fn,0)}function _cancelNextTick(id){return clearTimeout(id)}if(documentExists){on(document,"touchmove",function(evt){if((Sortable.active||awaitingDragStarted)&&evt.cancelable){evt.preventDefault()}})}Sortable.utils={on:on,off:off,css:css,find:find,is:function is(el,selector){return!!closest(el,selector,el,false)},extend:extend,throttle:throttle,closest:closest,toggleClass:toggleClass,clone:clone,index:index,nextTick:_nextTick,cancelNextTick:_cancelNextTick,detectDirection:_detectDirection,getChild:getChild,expando:expando};Sortable.get=function(element){return element[expando]};Sortable.mount=function(){for(var _len=arguments.length,plugins=new Array(_len),_key=0;_key<_len;_key++){plugins[_key]=arguments[_key]}if(plugins[0].constructor===Array)plugins=plugins[0];plugins.forEach(function(plugin){if(!plugin.prototype||!plugin.prototype.constructor){throw"Sortable: Mounted plugin must be a constructor function, not ".concat({}.toString.call(plugin))}if(plugin.utils)Sortable.utils=_objectSpread2(_objectSpread2({},Sortable.utils),plugin.utils);PluginManager.mount(plugin)})};Sortable.create=function(el,options){return new Sortable(el,options)};Sortable.version=version;var autoScrolls=[],scrollEl,scrollRootEl,scrolling=false,lastAutoScrollX,lastAutoScrollY,touchEvt$1,pointerElemChangedInterval;function AutoScrollPlugin(){function AutoScroll(){this.defaults={scroll:true,forceAutoScrollFallback:false,scrollSensitivity:30,scrollSpeed:10,bubbleScroll:true};for(var fn in this){if(fn.charAt(0)==="_"&&typeof this[fn]==="function"){this[fn]=this[fn].bind(this)}}}AutoScroll.prototype={dragStarted:function dragStarted(_ref){var originalEvent=_ref.originalEvent;if(this.sortable.nativeDraggable){on(document,"dragover",this._handleAutoScroll)}else{if(this.options.supportPointer){on(document,"pointermove",this._handleFallbackAutoScroll)}else if(originalEvent.touches){on(document,"touchmove",this._handleFallbackAutoScroll)}else{on(document,"mousemove",this._handleFallbackAutoScroll)}}},dragOverCompleted:function dragOverCompleted(_ref2){var originalEvent=_ref2.originalEvent;if(!this.options.dragOverBubble&&!originalEvent.rootEl){this._handleAutoScroll(originalEvent)}},drop:function drop(){if(this.sortable.nativeDraggable){off(document,"dragover",this._handleAutoScroll)}else{off(document,"pointermove",this._handleFallbackAutoScroll);off(document,"touchmove",this._handleFallbackAutoScroll);off(document,"mousemove",this._handleFallbackAutoScroll)}clearPointerElemChangedInterval();clearAutoScrolls();cancelThrottle()},nulling:function nulling(){touchEvt$1=scrollRootEl=scrollEl=scrolling=pointerElemChangedInterval=lastAutoScrollX=lastAutoScrollY=null;autoScrolls.length=0},_handleFallbackAutoScroll:function _handleFallbackAutoScroll(evt){this._handleAutoScroll(evt,true)},_handleAutoScroll:function _handleAutoScroll(evt,fallback){var _this=this;var x=(evt.touches?evt.touches[0]:evt).clientX,y=(evt.touches?evt.touches[0]:evt).clientY,elem=document.elementFromPoint(x,y);touchEvt$1=evt;if(fallback||this.options.forceAutoScrollFallback||Edge||IE11OrLess||Safari){autoScroll(evt,this.options,elem,fallback);var ogElemScroller=getParentAutoScrollElement(elem,true);if(scrolling&&(!pointerElemChangedInterval||x!==lastAutoScrollX||y!==lastAutoScrollY)){pointerElemChangedInterval&&clearPointerElemChangedInterval();pointerElemChangedInterval=setInterval(function(){var newElem=getParentAutoScrollElement(document.elementFromPoint(x,y),true);if(newElem!==ogElemScroller){ogElemScroller=newElem;clearAutoScrolls()}autoScroll(evt,_this.options,newElem,fallback)},10);lastAutoScrollX=x;lastAutoScrollY=y}}else{if(!this.options.bubbleScroll||getParentAutoScrollElement(elem,true)===getWindowScrollingElement()){clearAutoScrolls();return}autoScroll(evt,this.options,getParentAutoScrollElement(elem,false),false)}}};return _extends(AutoScroll,{pluginName:"scroll",initializeByDefault:true})}function clearAutoScrolls(){autoScrolls.forEach(function(autoScroll){clearInterval(autoScroll.pid)});autoScrolls=[]}function clearPointerElemChangedInterval(){clearInterval(pointerElemChangedInterval)}var autoScroll=throttle(function(evt,options,rootEl,isFallback){if(!options.scroll)return;var x=(evt.touches?evt.touches[0]:evt).clientX,y=(evt.touches?evt.touches[0]:evt).clientY,sens=options.scrollSensitivity,speed=options.scrollSpeed,winScroller=getWindowScrollingElement();var scrollThisInstance=false,scrollCustomFn;if(scrollRootEl!==rootEl){scrollRootEl=rootEl;clearAutoScrolls();scrollEl=options.scroll;scrollCustomFn=options.scrollFn;if(scrollEl===true){scrollEl=getParentAutoScrollElement(rootEl,true)}}var layersOut=0;var currentParent=scrollEl;do{var el=currentParent,rect=getRect(el),top=rect.top,bottom=rect.bottom,left=rect.left,right=rect.right,width=rect.width,height=rect.height,canScrollX=void 0,canScrollY=void 0,scrollWidth=el.scrollWidth,scrollHeight=el.scrollHeight,elCSS=css(el),scrollPosX=el.scrollLeft,scrollPosY=el.scrollTop;if(el===winScroller){canScrollX=width<scrollWidth&&(elCSS.overflowX==="auto"||elCSS.overflowX==="scroll"||elCSS.overflowX==="visible");canScrollY=height<scrollHeight&&(elCSS.overflowY==="auto"||elCSS.overflowY==="scroll"||elCSS.overflowY==="visible")}else{canScrollX=width<scrollWidth&&(elCSS.overflowX==="auto"||elCSS.overflowX==="scroll");canScrollY=height<scrollHeight&&(elCSS.overflowY==="auto"||elCSS.overflowY==="scroll")}var vx=canScrollX&&(Math.abs(right-x)<=sens&&scrollPosX+width<scrollWidth)-(Math.abs(left-x)<=sens&&!!scrollPosX);var vy=canScrollY&&(Math.abs(bottom-y)<=sens&&scrollPosY+height<scrollHeight)-(Math.abs(top-y)<=sens&&!!scrollPosY);if(!autoScrolls[layersOut]){for(var i=0;i<=layersOut;i++){if(!autoScrolls[i]){autoScrolls[i]={}}}}if(autoScrolls[layersOut].vx!=vx||autoScrolls[layersOut].vy!=vy||autoScrolls[layersOut].el!==el){autoScrolls[layersOut].el=el;autoScrolls[layersOut].vx=vx;autoScrolls[layersOut].vy=vy;clearInterval(autoScrolls[layersOut].pid);if(vx!=0||vy!=0){scrollThisInstance=true;autoScrolls[layersOut].pid=setInterval(function(){if(isFallback&&this.layer===0){Sortable.active._onTouchMove(touchEvt$1)}var scrollOffsetY=autoScrolls[this.layer].vy?autoScrolls[this.layer].vy*speed:0;var scrollOffsetX=autoScrolls[this.layer].vx?autoScrolls[this.layer].vx*speed:0;if(typeof scrollCustomFn==="function"){if(scrollCustomFn.call(Sortable.dragged.parentNode[expando],scrollOffsetX,scrollOffsetY,evt,touchEvt$1,autoScrolls[this.layer].el)!=="continue"){return}}scrollBy(autoScrolls[this.layer].el,scrollOffsetX,scrollOffsetY)}.bind({layer:layersOut}),24)}}layersOut++}while(options.bubbleScroll&&currentParent!==winScroller&&(currentParent=getParentAutoScrollElement(currentParent,false)));scrolling=scrollThisInstance},30);var drop=function drop(_ref){var originalEvent=_ref.originalEvent,putSortable=_ref.putSortable,dragEl=_ref.dragEl,activeSortable=_ref.activeSortable,dispatchSortableEvent=_ref.dispatchSortableEvent,hideGhostForTarget=_ref.hideGhostForTarget,unhideGhostForTarget=_ref.unhideGhostForTarget;if(!originalEvent)return;var toSortable=putSortable||activeSortable;hideGhostForTarget();var touch=originalEvent.changedTouches&&originalEvent.changedTouches.length?originalEvent.changedTouches[0]:originalEvent;var target=document.elementFromPoint(touch.clientX,touch.clientY);unhideGhostForTarget();if(toSortable&&!toSortable.el.contains(target)){dispatchSortableEvent("spill");this.onSpill({dragEl:dragEl,putSortable:putSortable})}};function Revert(){}Revert.prototype={startIndex:null,dragStart:function dragStart(_ref2){var oldDraggableIndex=_ref2.oldDraggableIndex;this.startIndex=oldDraggableIndex},onSpill:function onSpill(_ref3){var dragEl=_ref3.dragEl,putSortable=_ref3.putSortable;this.sortable.captureAnimationState();if(putSortable){putSortable.captureAnimationState()}var nextSibling=getChild(this.sortable.el,this.startIndex,this.options);if(nextSibling){this.sortable.el.insertBefore(dragEl,nextSibling)}else{this.sortable.el.appendChild(dragEl)}this.sortable.animateAll();if(putSortable){putSortable.animateAll()}},drop:drop};_extends(Revert,{pluginName:"revertOnSpill"});function Remove(){}Remove.prototype={onSpill:function onSpill(_ref4){var dragEl=_ref4.dragEl,putSortable=_ref4.putSortable;var parentSortable=putSortable||this.sortable;parentSortable.captureAnimationState();dragEl.parentNode&&dragEl.parentNode.removeChild(dragEl);parentSortable.animateAll()},drop:drop};_extends(Remove,{pluginName:"removeOnSpill"});var lastSwapEl;function SwapPlugin(){function Swap(){this.defaults={swapClass:"sortable-swap-highlight"}}Swap.prototype={dragStart:function dragStart(_ref){var dragEl=_ref.dragEl;lastSwapEl=dragEl},dragOverValid:function dragOverValid(_ref2){var completed=_ref2.completed,target=_ref2.target,onMove=_ref2.onMove,activeSortable=_ref2.activeSortable,changed=_ref2.changed,cancel=_ref2.cancel;if(!activeSortable.options.swap)return;var el=this.sortable.el,options=this.options;if(target&&target!==el){var prevSwapEl=lastSwapEl;if(onMove(target)!==false){toggleClass(target,options.swapClass,true);lastSwapEl=target}else{lastSwapEl=null}if(prevSwapEl&&prevSwapEl!==lastSwapEl){toggleClass(prevSwapEl,options.swapClass,false)}}changed();completed(true);cancel()},drop:function drop(_ref3){var activeSortable=_ref3.activeSortable,putSortable=_ref3.putSortable,dragEl=_ref3.dragEl;var toSortable=putSortable||this.sortable;var options=this.options;lastSwapEl&&toggleClass(lastSwapEl,options.swapClass,false);if(lastSwapEl&&(options.swap||putSortable&&putSortable.options.swap)){if(dragEl!==lastSwapEl){toSortable.captureAnimationState();if(toSortable!==activeSortable)activeSortable.captureAnimationState();swapNodes(dragEl,lastSwapEl);toSortable.animateAll();if(toSortable!==activeSortable)activeSortable.animateAll()}}},nulling:function nulling(){lastSwapEl=null}};return _extends(Swap,{pluginName:"swap",eventProperties:function eventProperties(){return{swapItem:lastSwapEl}}})}function swapNodes(n1,n2){var p1=n1.parentNode,p2=n2.parentNode,i1,i2;if(!p1||!p2||p1.isEqualNode(n2)||p2.isEqualNode(n1))return;i1=index(n1);i2=index(n2);if(p1.isEqualNode(p2)&&i1<i2){i2++}p1.insertBefore(n2,p1.children[i1]);p2.insertBefore(n1,p2.children[i2])}var multiDragElements=[],multiDragClones=[],lastMultiDragSelect,multiDragSortable,initialFolding=false,folding=false,dragStarted=false,dragEl$1,clonesFromRect,clonesHidden;function MultiDragPlugin(){function MultiDrag(sortable){for(var fn in this){if(fn.charAt(0)==="_"&&typeof this[fn]==="function"){this[fn]=this[fn].bind(this)}}if(!sortable.options.avoidImplicitDeselect){if(sortable.options.supportPointer){on(document,"pointerup",this._deselectMultiDrag)}else{on(document,"mouseup",this._deselectMultiDrag);on(document,"touchend",this._deselectMultiDrag)}}on(document,"keydown",this._checkKeyDown);on(document,"keyup",this._checkKeyUp);this.defaults={selectedClass:"sortable-selected",multiDragKey:null,avoidImplicitDeselect:false,setData:function setData(dataTransfer,dragEl){var data="";if(multiDragElements.length&&multiDragSortable===sortable){multiDragElements.forEach(function(multiDragElement,i){data+=(!i?"":", ")+multiDragElement.textContent})}else{data=dragEl.textContent}dataTransfer.setData("Text",data)}}}MultiDrag.prototype={multiDragKeyDown:false,isMultiDrag:false,delayStartGlobal:function delayStartGlobal(_ref){var dragged=_ref.dragEl;dragEl$1=dragged},delayEnded:function delayEnded(){this.isMultiDrag=~multiDragElements.indexOf(dragEl$1)},setupClone:function setupClone(_ref2){var sortable=_ref2.sortable,cancel=_ref2.cancel;if(!this.isMultiDrag)return;for(var i=0;i<multiDragElements.length;i++){multiDragClones.push(clone(multiDragElements[i]));multiDragClones[i].sortableIndex=multiDragElements[i].sortableIndex;multiDragClones[i].draggable=false;multiDragClones[i].style["will-change"]="";toggleClass(multiDragClones[i],this.options.selectedClass,false);multiDragElements[i]===dragEl$1&&toggleClass(multiDragClones[i],this.options.chosenClass,false)}sortable._hideClone();cancel()},clone:function clone(_ref3){var sortable=_ref3.sortable,rootEl=_ref3.rootEl,dispatchSortableEvent=_ref3.dispatchSortableEvent,cancel=_ref3.cancel;if(!this.isMultiDrag)return;if(!this.options.removeCloneOnHide){if(multiDragElements.length&&multiDragSortable===sortable){insertMultiDragClones(true,rootEl);dispatchSortableEvent("clone");cancel()}}},showClone:function showClone(_ref4){var cloneNowShown=_ref4.cloneNowShown,rootEl=_ref4.rootEl,cancel=_ref4.cancel;if(!this.isMultiDrag)return;insertMultiDragClones(false,rootEl);multiDragClones.forEach(function(clone){css(clone,"display","")});cloneNowShown();clonesHidden=false;cancel()},hideClone:function hideClone(_ref5){var _this=this;var sortable=_ref5.sortable,cloneNowHidden=_ref5.cloneNowHidden,cancel=_ref5.cancel;if(!this.isMultiDrag)return;multiDragClones.forEach(function(clone){css(clone,"display","none");if(_this.options.removeCloneOnHide&&clone.parentNode){clone.parentNode.removeChild(clone)}});cloneNowHidden();clonesHidden=true;cancel()},dragStartGlobal:function dragStartGlobal(_ref6){var sortable=_ref6.sortable;if(!this.isMultiDrag&&multiDragSortable){multiDragSortable.multiDrag._deselectMultiDrag()}multiDragElements.forEach(function(multiDragElement){multiDragElement.sortableIndex=index(multiDragElement)});multiDragElements=multiDragElements.sort(function(a,b){return a.sortableIndex-b.sortableIndex});dragStarted=true},dragStarted:function dragStarted(_ref7){var _this2=this;var sortable=_ref7.sortable;if(!this.isMultiDrag)return;if(this.options.sort){sortable.captureAnimationState();if(this.options.animation){multiDragElements.forEach(function(multiDragElement){if(multiDragElement===dragEl$1)return;css(multiDragElement,"position","absolute")});var dragRect=getRect(dragEl$1,false,true,true);multiDragElements.forEach(function(multiDragElement){if(multiDragElement===dragEl$1)return;setRect(multiDragElement,dragRect)});folding=true;initialFolding=true}}sortable.animateAll(function(){folding=false;initialFolding=false;if(_this2.options.animation){multiDragElements.forEach(function(multiDragElement){unsetRect(multiDragElement)})}if(_this2.options.sort){removeMultiDragElements()}})},dragOver:function dragOver(_ref8){var target=_ref8.target,completed=_ref8.completed,cancel=_ref8.cancel;if(folding&&~multiDragElements.indexOf(target)){completed(false);cancel()}},revert:function revert(_ref9){var fromSortable=_ref9.fromSortable,rootEl=_ref9.rootEl,sortable=_ref9.sortable,dragRect=_ref9.dragRect;if(multiDragElements.length>1){multiDragElements.forEach(function(multiDragElement){sortable.addAnimationState({target:multiDragElement,rect:folding?getRect(multiDragElement):dragRect});unsetRect(multiDragElement);multiDragElement.fromRect=dragRect;fromSortable.removeAnimationState(multiDragElement)});folding=false;insertMultiDragElements(!this.options.removeCloneOnHide,rootEl)}},dragOverCompleted:function dragOverCompleted(_ref10){var sortable=_ref10.sortable,isOwner=_ref10.isOwner,insertion=_ref10.insertion,activeSortable=_ref10.activeSortable,parentEl=_ref10.parentEl,putSortable=_ref10.putSortable;var options=this.options;if(insertion){if(isOwner){activeSortable._hideClone()}initialFolding=false;if(options.animation&&multiDragElements.length>1&&(folding||!isOwner&&!activeSortable.options.sort&&!putSortable)){var dragRectAbsolute=getRect(dragEl$1,false,true,true);multiDragElements.forEach(function(multiDragElement){if(multiDragElement===dragEl$1)return;setRect(multiDragElement,dragRectAbsolute);parentEl.appendChild(multiDragElement)});folding=true}if(!isOwner){if(!folding){removeMultiDragElements()}if(multiDragElements.length>1){var clonesHiddenBefore=clonesHidden;activeSortable._showClone(sortable);if(activeSortable.options.animation&&!clonesHidden&&clonesHiddenBefore){multiDragClones.forEach(function(clone){activeSortable.addAnimationState({target:clone,rect:clonesFromRect});clone.fromRect=clonesFromRect;clone.thisAnimationDuration=null})}}else{activeSortable._showClone(sortable)}}}},dragOverAnimationCapture:function dragOverAnimationCapture(_ref11){var dragRect=_ref11.dragRect,isOwner=_ref11.isOwner,activeSortable=_ref11.activeSortable;multiDragElements.forEach(function(multiDragElement){multiDragElement.thisAnimationDuration=null});if(activeSortable.options.animation&&!isOwner&&activeSortable.multiDrag.isMultiDrag){clonesFromRect=_extends({},dragRect);var dragMatrix=matrix(dragEl$1,true);clonesFromRect.top-=dragMatrix.f;clonesFromRect.left-=dragMatrix.e}},dragOverAnimationComplete:function dragOverAnimationComplete(){if(folding){folding=false;removeMultiDragElements()}},drop:function drop(_ref12){var evt=_ref12.originalEvent,rootEl=_ref12.rootEl,parentEl=_ref12.parentEl,sortable=_ref12.sortable,dispatchSortableEvent=_ref12.dispatchSortableEvent,oldIndex=_ref12.oldIndex,putSortable=_ref12.putSortable;var toSortable=putSortable||this.sortable;if(!evt)return;var options=this.options,children=parentEl.children;if(!dragStarted){if(options.multiDragKey&&!this.multiDragKeyDown){this._deselectMultiDrag()}toggleClass(dragEl$1,options.selectedClass,!~multiDragElements.indexOf(dragEl$1));if(!~multiDragElements.indexOf(dragEl$1)){multiDragElements.push(dragEl$1);dispatchEvent({sortable:sortable,rootEl:rootEl,name:"select",targetEl:dragEl$1,originalEvent:evt});if(evt.shiftKey&&lastMultiDragSelect&&sortable.el.contains(lastMultiDragSelect)){var lastIndex=index(lastMultiDragSelect),currentIndex=index(dragEl$1);if(~lastIndex&&~currentIndex&&lastIndex!==currentIndex){(function(){var n,i;if(currentIndex>lastIndex){i=lastIndex;n=currentIndex}else{i=currentIndex;n=lastIndex+1}var filter=options.filter;for(;i<n;i++){if(~multiDragElements.indexOf(children[i]))continue;if(!closest(children[i],options.draggable,parentEl,false))continue;var filtered=filter&&(typeof filter==="function"?filter.call(sortable,evt,children[i],sortable):filter.split(",").some(function(criteria){return closest(children[i],criteria.trim(),parentEl,false)}));if(filtered)continue;toggleClass(children[i],options.selectedClass,true);multiDragElements.push(children[i]);dispatchEvent({sortable:sortable,rootEl:rootEl,name:"select",targetEl:children[i],originalEvent:evt})}})()}}else{lastMultiDragSelect=dragEl$1}multiDragSortable=toSortable}else{multiDragElements.splice(multiDragElements.indexOf(dragEl$1),1);lastMultiDragSelect=null;dispatchEvent({sortable:sortable,rootEl:rootEl,name:"deselect",targetEl:dragEl$1,originalEvent:evt})}}if(dragStarted&&this.isMultiDrag){folding=false;if((parentEl[expando].options.sort||parentEl!==rootEl)&&multiDragElements.length>1){var dragRect=getRect(dragEl$1),multiDragIndex=index(dragEl$1,":not(."+this.options.selectedClass+")");if(!initialFolding&&options.animation)dragEl$1.thisAnimationDuration=null;toSortable.captureAnimationState();if(!initialFolding){if(options.animation){dragEl$1.fromRect=dragRect;multiDragElements.forEach(function(multiDragElement){multiDragElement.thisAnimationDuration=null;if(multiDragElement!==dragEl$1){var rect=folding?getRect(multiDragElement):dragRect;multiDragElement.fromRect=rect;toSortable.addAnimationState({target:multiDragElement,rect:rect})}})}removeMultiDragElements();multiDragElements.forEach(function(multiDragElement){if(children[multiDragIndex]){parentEl.insertBefore(multiDragElement,children[multiDragIndex])}else{parentEl.appendChild(multiDragElement)}multiDragIndex++});if(oldIndex===index(dragEl$1)){var update=false;multiDragElements.forEach(function(multiDragElement){if(multiDragElement.sortableIndex!==index(multiDragElement)){update=true;return}});if(update){dispatchSortableEvent("update");dispatchSortableEvent("sort")}}}multiDragElements.forEach(function(multiDragElement){unsetRect(multiDragElement)});toSortable.animateAll()}multiDragSortable=toSortable}if(rootEl===parentEl||putSortable&&putSortable.lastPutMode!=="clone"){multiDragClones.forEach(function(clone){clone.parentNode&&clone.parentNode.removeChild(clone)})}},nullingGlobal:function nullingGlobal(){this.isMultiDrag=dragStarted=false;multiDragClones.length=0},destroyGlobal:function destroyGlobal(){this._deselectMultiDrag();off(document,"pointerup",this._deselectMultiDrag);off(document,"mouseup",this._deselectMultiDrag);off(document,"touchend",this._deselectMultiDrag);off(document,"keydown",this._checkKeyDown);off(document,"keyup",this._checkKeyUp)},_deselectMultiDrag:function _deselectMultiDrag(evt){if(typeof dragStarted!=="undefined"&&dragStarted)return;if(multiDragSortable!==this.sortable)return;if(evt&&closest(evt.target,this.options.draggable,this.sortable.el,false))return;if(evt&&evt.button!==0)return;while(multiDragElements.length){var el=multiDragElements[0];toggleClass(el,this.options.selectedClass,false);multiDragElements.shift();dispatchEvent({sortable:this.sortable,rootEl:this.sortable.el,name:"deselect",targetEl:el,originalEvent:evt})}},_checkKeyDown:function _checkKeyDown(evt){if(evt.key===this.options.multiDragKey){this.multiDragKeyDown=true}},_checkKeyUp:function _checkKeyUp(evt){if(evt.key===this.options.multiDragKey){this.multiDragKeyDown=false}}};return _extends(MultiDrag,{pluginName:"multiDrag",utils:{select:function select(el){var sortable=el.parentNode[expando];if(!sortable||!sortable.options.multiDrag||~multiDragElements.indexOf(el))return;if(multiDragSortable&&multiDragSortable!==sortable){multiDragSortable.multiDrag._deselectMultiDrag();multiDragSortable=sortable}toggleClass(el,sortable.options.selectedClass,true);multiDragElements.push(el)},deselect:function deselect(el){var sortable=el.parentNode[expando],index=multiDragElements.indexOf(el);if(!sortable||!sortable.options.multiDrag||!~index)return;toggleClass(el,sortable.options.selectedClass,false);multiDragElements.splice(index,1)}},eventProperties:function eventProperties(){var _this3=this;var oldIndicies=[],newIndicies=[];multiDragElements.forEach(function(multiDragElement){oldIndicies.push({multiDragElement:multiDragElement,index:multiDragElement.sortableIndex});var newIndex;if(folding&&multiDragElement!==dragEl$1){newIndex=-1}else if(folding){newIndex=index(multiDragElement,":not(."+_this3.options.selectedClass+")")}else{newIndex=index(multiDragElement)}newIndicies.push({multiDragElement:multiDragElement,index:newIndex})});return{items:_toConsumableArray(multiDragElements),clones:[].concat(multiDragClones),oldIndicies:oldIndicies,newIndicies:newIndicies}},optionListeners:{multiDragKey:function multiDragKey(key){key=key.toLowerCase();if(key==="ctrl"){key="Control"}else if(key.length>1){key=key.charAt(0).toUpperCase()+key.substr(1)}return key}}})}function insertMultiDragElements(clonesInserted,rootEl){multiDragElements.forEach(function(multiDragElement,i){var target=rootEl.children[multiDragElement.sortableIndex+(clonesInserted?Number(i):0)];if(target){rootEl.insertBefore(multiDragElement,target)}else{rootEl.appendChild(multiDragElement)}})}function insertMultiDragClones(elementsInserted,rootEl){multiDragClones.forEach(function(clone,i){var target=rootEl.children[clone.sortableIndex+(elementsInserted?Number(i):0)];if(target){rootEl.insertBefore(clone,target)}else{rootEl.appendChild(clone)}})}function removeMultiDragElements(){multiDragElements.forEach(function(multiDragElement){if(multiDragElement===dragEl$1)return;multiDragElement.parentNode&&multiDragElement.parentNode.removeChild(multiDragElement)})}Sortable.mount(new AutoScrollPlugin);Sortable.mount(Remove,Revert);Sortable.mount(new SwapPlugin);Sortable.mount(new MultiDragPlugin);return Sortable});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?module.exports=factory():typeof define==="function"&&define.amd?define(factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,global.Cropper=factory())})(this,function(){"use strict";function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter(function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable})),t.push.apply(t,o)}return t}function _objectSpread2(e){for(var r=1;r<arguments.length;r++){var t=null!=arguments[r]?arguments[r]:{};r%2?ownKeys(Object(t),!0).forEach(function(r){_defineProperty(e,r,t[r])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach(function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))})}return e}function _toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor)}}function _createClass(Constructor,protoProps,staticProps){if(protoProps)_defineProperties(Constructor.prototype,protoProps);if(staticProps)_defineProperties(Constructor,staticProps);Object.defineProperty(Constructor,"prototype",{writable:false});return Constructor}function _defineProperty(obj,key,value){key=_toPropertyKey(key);if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _toConsumableArray(arr){return _arrayWithoutHoles(arr)||_iterableToArray(arr)||_unsupportedIterableToArray(arr)||_nonIterableSpread()}function _arrayWithoutHoles(arr){if(Array.isArray(arr))return _arrayLikeToArray(arr)}function _iterableToArray(iter){if(typeof Symbol!=="undefined"&&iter[Symbol.iterator]!=null||iter["@@iterator"]!=null)return Array.from(iter)}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen)}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2}function _nonIterableSpread(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var IS_BROWSER=typeof window!=="undefined"&&typeof window.document!=="undefined";var WINDOW=IS_BROWSER?window:{};var IS_TOUCH_DEVICE=IS_BROWSER&&WINDOW.document.documentElement?"ontouchstart"in WINDOW.document.documentElement:false;var HAS_POINTER_EVENT=IS_BROWSER?"PointerEvent"in WINDOW:false;var NAMESPACE="cropper";var ACTION_ALL="all";var ACTION_CROP="crop";var ACTION_MOVE="move";var ACTION_ZOOM="zoom";var ACTION_EAST="e";var ACTION_WEST="w";var ACTION_SOUTH="s";var ACTION_NORTH="n";var ACTION_NORTH_EAST="ne";var ACTION_NORTH_WEST="nw";var ACTION_SOUTH_EAST="se";var ACTION_SOUTH_WEST="sw";var CLASS_CROP="".concat(NAMESPACE,"-crop");var CLASS_DISABLED="".concat(NAMESPACE,"-disabled");var CLASS_HIDDEN="".concat(NAMESPACE,"-hidden");var CLASS_HIDE="".concat(NAMESPACE,"-hide");var CLASS_INVISIBLE="".concat(NAMESPACE,"-invisible");var CLASS_MODAL="".concat(NAMESPACE,"-modal");var CLASS_MOVE="".concat(NAMESPACE,"-move");var DATA_ACTION="".concat(NAMESPACE,"Action");var DATA_PREVIEW="".concat(NAMESPACE,"Preview");var DRAG_MODE_CROP="crop";var DRAG_MODE_MOVE="move";var DRAG_MODE_NONE="none";var EVENT_CROP="crop";var EVENT_CROP_END="cropend";var EVENT_CROP_MOVE="cropmove";var EVENT_CROP_START="cropstart";var EVENT_DBLCLICK="dblclick";var EVENT_TOUCH_START=IS_TOUCH_DEVICE?"touchstart":"mousedown";var EVENT_TOUCH_MOVE=IS_TOUCH_DEVICE?"touchmove":"mousemove";var EVENT_TOUCH_END=IS_TOUCH_DEVICE?"touchend touchcancel":"mouseup";var EVENT_POINTER_DOWN=HAS_POINTER_EVENT?"pointerdown":EVENT_TOUCH_START;var EVENT_POINTER_MOVE=HAS_POINTER_EVENT?"pointermove":EVENT_TOUCH_MOVE;var EVENT_POINTER_UP=HAS_POINTER_EVENT?"pointerup pointercancel":EVENT_TOUCH_END;var EVENT_READY="ready";var EVENT_RESIZE="resize";var EVENT_WHEEL="wheel";var EVENT_ZOOM="zoom";var MIME_TYPE_JPEG="image/jpeg";var REGEXP_ACTIONS=/^e|w|s|n|se|sw|ne|nw|all|crop|move|zoom$/;var REGEXP_DATA_URL=/^data:/;var REGEXP_DATA_URL_JPEG=/^data:image\/jpeg;base64,/;var REGEXP_TAG_NAME=/^img|canvas$/i;var MIN_CONTAINER_WIDTH=200;var MIN_CONTAINER_HEIGHT=100;var DEFAULTS={viewMode:0,dragMode:DRAG_MODE_CROP,initialAspectRatio:NaN,aspectRatio:NaN,data:null,preview:"",responsive:true,restore:true,checkCrossOrigin:true,checkOrientation:true,modal:true,guides:true,center:true,highlight:true,background:true,autoCrop:true,autoCropArea:.8,movable:true,rotatable:true,scalable:true,zoomable:true,zoomOnTouch:true,zoomOnWheel:true,wheelZoomRatio:.1,cropBoxMovable:true,cropBoxResizable:true,toggleDragModeOnDblclick:true,minCanvasWidth:0,minCanvasHeight:0,minCropBoxWidth:0,minCropBoxHeight:0,minContainerWidth:MIN_CONTAINER_WIDTH,minContainerHeight:MIN_CONTAINER_HEIGHT,ready:null,cropstart:null,cropmove:null,cropend:null,crop:null,zoom:null};var TEMPLATE='<div class="cropper-container" touch-action="none">'+'<div class="cropper-wrap-box">'+'<div class="cropper-canvas"></div>'+"</div>"+'<div class="cropper-drag-box"></div>'+'<div class="cropper-crop-box">'+'<span class="cropper-view-box"></span>'+'<span class="cropper-dashed dashed-h"></span>'+'<span class="cropper-dashed dashed-v"></span>'+'<span class="cropper-center"></span>'+'<span class="cropper-face"></span>'+'<span class="cropper-line line-e" data-cropper-action="e"></span>'+'<span class="cropper-line line-n" data-cropper-action="n"></span>'+'<span class="cropper-line line-w" data-cropper-action="w"></span>'+'<span class="cropper-line line-s" data-cropper-action="s"></span>'+'<span class="cropper-point point-e" data-cropper-action="e"></span>'+'<span class="cropper-point point-n" data-cropper-action="n"></span>'+'<span class="cropper-point point-w" data-cropper-action="w"></span>'+'<span class="cropper-point point-s" data-cropper-action="s"></span>'+'<span class="cropper-point point-ne" data-cropper-action="ne"></span>'+'<span class="cropper-point point-nw" data-cropper-action="nw"></span>'+'<span class="cropper-point point-sw" data-cropper-action="sw"></span>'+'<span class="cropper-point point-se" data-cropper-action="se"></span>'+"</div>"+"</div>";var isNaN=Number.isNaN||WINDOW.isNaN;function isNumber(value){return typeof value==="number"&&!isNaN(value)}var isPositiveNumber=function isPositiveNumber(value){return value>0&&value<Infinity};function isUndefined(value){return typeof value==="undefined"}function isObject(value){return _typeof(value)==="object"&&value!==null}var hasOwnProperty=Object.prototype.hasOwnProperty;function isPlainObject(value){if(!isObject(value)){return false}try{var _constructor=value.constructor;var prototype=_constructor.prototype;return _constructor&&prototype&&hasOwnProperty.call(prototype,"isPrototypeOf")}catch(error){return false}}function isFunction(value){return typeof value==="function"}var slice=Array.prototype.slice;function toArray(value){return Array.from?Array.from(value):slice.call(value)}function forEach(data,callback){if(data&&isFunction(callback)){if(Array.isArray(data)||isNumber(data.length)){toArray(data).forEach(function(value,key){callback.call(data,value,key,data)})}else if(isObject(data)){Object.keys(data).forEach(function(key){callback.call(data,data[key],key,data)})}}return data}var assign=Object.assign||function assign(target){for(var _len=arguments.length,args=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){args[_key-1]=arguments[_key]}if(isObject(target)&&args.length>0){args.forEach(function(arg){if(isObject(arg)){Object.keys(arg).forEach(function(key){target[key]=arg[key]})}})}return target};var REGEXP_DECIMALS=/\.\d*(?:0|9){12}\d*$/;function normalizeDecimalNumber(value){var times=arguments.length>1&&arguments[1]!==undefined?arguments[1]:1e11;return REGEXP_DECIMALS.test(value)?Math.round(value*times)/times:value}var REGEXP_SUFFIX=/^width|height|left|top|marginLeft|marginTop$/;function setStyle(element,styles){var style=element.style;forEach(styles,function(value,property){if(REGEXP_SUFFIX.test(property)&&isNumber(value)){value="".concat(value,"px")}style[property]=value})}function hasClass(element,value){return element.classList?element.classList.contains(value):element.className.indexOf(value)>-1}function addClass(element,value){if(!value){return}if(isNumber(element.length)){forEach(element,function(elem){addClass(elem,value)});return}if(element.classList){element.classList.add(value);return}var className=element.className.trim();if(!className){element.className=value}else if(className.indexOf(value)<0){element.className="".concat(className," ").concat(value)}}function removeClass(element,value){if(!value){return}if(isNumber(element.length)){forEach(element,function(elem){removeClass(elem,value)});return}if(element.classList){element.classList.remove(value);return}if(element.className.indexOf(value)>=0){element.className=element.className.replace(value,"")}}function toggleClass(element,value,added){if(!value){return}if(isNumber(element.length)){forEach(element,function(elem){toggleClass(elem,value,added)});return}if(added){addClass(element,value)}else{removeClass(element,value)}}var REGEXP_CAMEL_CASE=/([a-z\d])([A-Z])/g;function toParamCase(value){return value.replace(REGEXP_CAMEL_CASE,"$1-$2").toLowerCase()}function getData(element,name){if(isObject(element[name])){return element[name]}if(element.dataset){return element.dataset[name]}return element.getAttribute("data-".concat(toParamCase(name)))}function setData(element,name,data){if(isObject(data)){element[name]=data}else if(element.dataset){element.dataset[name]=data}else{element.setAttribute("data-".concat(toParamCase(name)),data)}}function removeData(element,name){if(isObject(element[name])){try{delete element[name]}catch(error){element[name]=undefined}}else if(element.dataset){try{delete element.dataset[name]}catch(error){element.dataset[name]=undefined}}else{element.removeAttribute("data-".concat(toParamCase(name)))}}var REGEXP_SPACES=/\s\s*/;var onceSupported=function(){var supported=false;if(IS_BROWSER){var once=false;var listener=function listener(){};var options=Object.defineProperty({},"once",{get:function get(){supported=true;return once},set:function set(value){once=value}});WINDOW.addEventListener("test",listener,options);WINDOW.removeEventListener("test",listener,options)}return supported}();function removeListener(element,type,listener){var options=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};var handler=listener;type.trim().split(REGEXP_SPACES).forEach(function(event){if(!onceSupported){var listeners=element.listeners;if(listeners&&listeners[event]&&listeners[event][listener]){handler=listeners[event][listener];delete listeners[event][listener];if(Object.keys(listeners[event]).length===0){delete listeners[event]}if(Object.keys(listeners).length===0){delete element.listeners}}}element.removeEventListener(event,handler,options)})}function addListener(element,type,listener){var options=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};var _handler=listener;type.trim().split(REGEXP_SPACES).forEach(function(event){if(options.once&&!onceSupported){var _element$listeners=element.listeners,listeners=_element$listeners===void 0?{}:_element$listeners;_handler=function handler(){delete listeners[event][listener];element.removeEventListener(event,_handler,options);for(var _len2=arguments.length,args=new Array(_len2),_key2=0;_key2<_len2;_key2++){args[_key2]=arguments[_key2]}listener.apply(element,args)};if(!listeners[event]){listeners[event]={}}if(listeners[event][listener]){element.removeEventListener(event,listeners[event][listener],options)}listeners[event][listener]=_handler;element.listeners=listeners}element.addEventListener(event,_handler,options)})}function dispatchEvent(element,type,data){var event;if(isFunction(Event)&&isFunction(CustomEvent)){event=new CustomEvent(type,{detail:data,bubbles:true,cancelable:true})}else{event=document.createEvent("CustomEvent");event.initCustomEvent(type,true,true,data)}return element.dispatchEvent(event)}function getOffset(element){var box=element.getBoundingClientRect();return{left:box.left+(window.pageXOffset-document.documentElement.clientLeft),top:box.top+(window.pageYOffset-document.documentElement.clientTop)}}var location=WINDOW.location;var REGEXP_ORIGINS=/^(\w+:)\/\/([^:/?#]*):?(\d*)/i;function isCrossOriginURL(url){var parts=url.match(REGEXP_ORIGINS);return parts!==null&&(parts[1]!==location.protocol||parts[2]!==location.hostname||parts[3]!==location.port)}function addTimestamp(url){var timestamp="timestamp=".concat((new Date).getTime());return url+(url.indexOf("?")===-1?"?":"&")+timestamp}function getTransforms(_ref){var rotate=_ref.rotate,scaleX=_ref.scaleX,scaleY=_ref.scaleY,translateX=_ref.translateX,translateY=_ref.translateY;var values=[];if(isNumber(translateX)&&translateX!==0){values.push("translateX(".concat(translateX,"px)"))}if(isNumber(translateY)&&translateY!==0){values.push("translateY(".concat(translateY,"px)"))}if(isNumber(rotate)&&rotate!==0){values.push("rotate(".concat(rotate,"deg)"))}if(isNumber(scaleX)&&scaleX!==1){values.push("scaleX(".concat(scaleX,")"))}if(isNumber(scaleY)&&scaleY!==1){values.push("scaleY(".concat(scaleY,")"))}var transform=values.length?values.join(" "):"none";return{WebkitTransform:transform,msTransform:transform,transform:transform}}function getMaxZoomRatio(pointers){var pointers2=_objectSpread2({},pointers);var maxRatio=0;forEach(pointers,function(pointer,pointerId){delete pointers2[pointerId];forEach(pointers2,function(pointer2){var x1=Math.abs(pointer.startX-pointer2.startX);var y1=Math.abs(pointer.startY-pointer2.startY);var x2=Math.abs(pointer.endX-pointer2.endX);var y2=Math.abs(pointer.endY-pointer2.endY);var z1=Math.sqrt(x1*x1+y1*y1);var z2=Math.sqrt(x2*x2+y2*y2);var ratio=(z2-z1)/z1;if(Math.abs(ratio)>Math.abs(maxRatio)){maxRatio=ratio}})});return maxRatio}function getPointer(_ref2,endOnly){var pageX=_ref2.pageX,pageY=_ref2.pageY;var end={endX:pageX,endY:pageY};return endOnly?end:_objectSpread2({startX:pageX,startY:pageY},end)}function getPointersCenter(pointers){var pageX=0;var pageY=0;var count=0;forEach(pointers,function(_ref3){var startX=_ref3.startX,startY=_ref3.startY;pageX+=startX;pageY+=startY;count+=1});pageX/=count;pageY/=count;return{pageX:pageX,pageY:pageY}}function getAdjustedSizes(_ref4){var aspectRatio=_ref4.aspectRatio,height=_ref4.height,width=_ref4.width;var type=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"contain";var isValidWidth=isPositiveNumber(width);var isValidHeight=isPositiveNumber(height);if(isValidWidth&&isValidHeight){var adjustedWidth=height*aspectRatio;if(type==="contain"&&adjustedWidth>width||type==="cover"&&adjustedWidth<width){height=width/aspectRatio}else{width=height*aspectRatio}}else if(isValidWidth){height=width/aspectRatio}else if(isValidHeight){width=height*aspectRatio}return{width:width,height:height}}function getRotatedSizes(_ref5){var width=_ref5.width,height=_ref5.height,degree=_ref5.degree;degree=Math.abs(degree)%180;if(degree===90){return{width:height,height:width}}var arc=degree%90*Math.PI/180;var sinArc=Math.sin(arc);var cosArc=Math.cos(arc);var newWidth=width*cosArc+height*sinArc;var newHeight=width*sinArc+height*cosArc;return degree>90?{width:newHeight,height:newWidth}:{width:newWidth,height:newHeight}}function getSourceCanvas(image,_ref6,_ref7,_ref8){var imageAspectRatio=_ref6.aspectRatio,imageNaturalWidth=_ref6.naturalWidth,imageNaturalHeight=_ref6.naturalHeight,_ref6$rotate=_ref6.rotate,rotate=_ref6$rotate===void 0?0:_ref6$rotate,_ref6$scaleX=_ref6.scaleX,scaleX=_ref6$scaleX===void 0?1:_ref6$scaleX,_ref6$scaleY=_ref6.scaleY,scaleY=_ref6$scaleY===void 0?1:_ref6$scaleY;var aspectRatio=_ref7.aspectRatio,naturalWidth=_ref7.naturalWidth,naturalHeight=_ref7.naturalHeight;var _ref8$fillColor=_ref8.fillColor,fillColor=_ref8$fillColor===void 0?"transparent":_ref8$fillColor,_ref8$imageSmoothingE=_ref8.imageSmoothingEnabled,imageSmoothingEnabled=_ref8$imageSmoothingE===void 0?true:_ref8$imageSmoothingE,_ref8$imageSmoothingQ=_ref8.imageSmoothingQuality,imageSmoothingQuality=_ref8$imageSmoothingQ===void 0?"low":_ref8$imageSmoothingQ,_ref8$maxWidth=_ref8.maxWidth,maxWidth=_ref8$maxWidth===void 0?Infinity:_ref8$maxWidth,_ref8$maxHeight=_ref8.maxHeight,maxHeight=_ref8$maxHeight===void 0?Infinity:_ref8$maxHeight,_ref8$minWidth=_ref8.minWidth,minWidth=_ref8$minWidth===void 0?0:_ref8$minWidth,_ref8$minHeight=_ref8.minHeight,minHeight=_ref8$minHeight===void 0?0:_ref8$minHeight;var canvas=document.createElement("canvas");var context=canvas.getContext("2d");var maxSizes=getAdjustedSizes({aspectRatio:aspectRatio,width:maxWidth,height:maxHeight});var minSizes=getAdjustedSizes({aspectRatio:aspectRatio,width:minWidth,height:minHeight},"cover");var width=Math.min(maxSizes.width,Math.max(minSizes.width,naturalWidth));var height=Math.min(maxSizes.height,Math.max(minSizes.height,naturalHeight));var destMaxSizes=getAdjustedSizes({aspectRatio:imageAspectRatio,width:maxWidth,height:maxHeight});var destMinSizes=getAdjustedSizes({aspectRatio:imageAspectRatio,width:minWidth,height:minHeight},"cover");var destWidth=Math.min(destMaxSizes.width,Math.max(destMinSizes.width,imageNaturalWidth));var destHeight=Math.min(destMaxSizes.height,Math.max(destMinSizes.height,imageNaturalHeight));var params=[-destWidth/2,-destHeight/2,destWidth,destHeight];canvas.width=normalizeDecimalNumber(width);canvas.height=normalizeDecimalNumber(height);context.fillStyle=fillColor;context.fillRect(0,0,width,height);context.save();context.translate(width/2,height/2);context.rotate(rotate*Math.PI/180);context.scale(scaleX,scaleY);context.imageSmoothingEnabled=imageSmoothingEnabled;context.imageSmoothingQuality=imageSmoothingQuality;context.drawImage.apply(context,[image].concat(_toConsumableArray(params.map(function(param){return Math.floor(normalizeDecimalNumber(param))}))));context.restore();return canvas}var fromCharCode=String.fromCharCode;function getStringFromCharCode(dataView,start,length){var str="";length+=start;for(var i=start;i<length;i+=1){str+=fromCharCode(dataView.getUint8(i))}return str}var REGEXP_DATA_URL_HEAD=/^data:.*,/;function dataURLToArrayBuffer(dataURL){var base64=dataURL.replace(REGEXP_DATA_URL_HEAD,"");var binary=atob(base64);var arrayBuffer=new ArrayBuffer(binary.length);var uint8=new Uint8Array(arrayBuffer);forEach(uint8,function(value,i){uint8[i]=binary.charCodeAt(i)});return arrayBuffer}function arrayBufferToDataURL(arrayBuffer,mimeType){var chunks=[];var chunkSize=8192;var uint8=new Uint8Array(arrayBuffer);while(uint8.length>0){chunks.push(fromCharCode.apply(null,toArray(uint8.subarray(0,chunkSize))));uint8=uint8.subarray(chunkSize)}return"data:".concat(mimeType,";base64,").concat(btoa(chunks.join("")))}function resetAndGetOrientation(arrayBuffer){var dataView=new DataView(arrayBuffer);var orientation;try{var littleEndian;var app1Start;var ifdStart;if(dataView.getUint8(0)===255&&dataView.getUint8(1)===216){var length=dataView.byteLength;var offset=2;while(offset+1<length){if(dataView.getUint8(offset)===255&&dataView.getUint8(offset+1)===225){app1Start=offset;break}offset+=1}}if(app1Start){var exifIDCode=app1Start+4;var tiffOffset=app1Start+10;if(getStringFromCharCode(dataView,exifIDCode,4)==="Exif"){var endianness=dataView.getUint16(tiffOffset);littleEndian=endianness===18761;if(littleEndian||endianness===19789){if(dataView.getUint16(tiffOffset+2,littleEndian)===42){var firstIFDOffset=dataView.getUint32(tiffOffset+4,littleEndian);if(firstIFDOffset>=8){ifdStart=tiffOffset+firstIFDOffset}}}}}if(ifdStart){var _length=dataView.getUint16(ifdStart,littleEndian);var _offset;var i;for(i=0;i<_length;i+=1){_offset=ifdStart+i*12+2;if(dataView.getUint16(_offset,littleEndian)===274){_offset+=8;orientation=dataView.getUint16(_offset,littleEndian);dataView.setUint16(_offset,1,littleEndian);break}}}}catch(error){orientation=1}return orientation}function parseOrientation(orientation){var rotate=0;var scaleX=1;var scaleY=1;switch(orientation){case 2:scaleX=-1;break;case 3:rotate=-180;break;case 4:scaleY=-1;break;case 5:rotate=90;scaleY=-1;break;case 6:rotate=90;break;case 7:rotate=90;scaleX=-1;break;case 8:rotate=-90;break}return{rotate:rotate,scaleX:scaleX,scaleY:scaleY}}var render={render:function render(){this.initContainer();this.initCanvas();this.initCropBox();this.renderCanvas();if(this.cropped){this.renderCropBox()}},initContainer:function initContainer(){var element=this.element,options=this.options,container=this.container,cropper=this.cropper;var minWidth=Number(options.minContainerWidth);var minHeight=Number(options.minContainerHeight);addClass(cropper,CLASS_HIDDEN);removeClass(element,CLASS_HIDDEN);var containerData={width:Math.max(container.offsetWidth,minWidth>=0?minWidth:MIN_CONTAINER_WIDTH),height:Math.max(container.offsetHeight,minHeight>=0?minHeight:MIN_CONTAINER_HEIGHT)};this.containerData=containerData;setStyle(cropper,{width:containerData.width,height:containerData.height});addClass(element,CLASS_HIDDEN);removeClass(cropper,CLASS_HIDDEN)},initCanvas:function initCanvas(){var containerData=this.containerData,imageData=this.imageData;var viewMode=this.options.viewMode;var rotated=Math.abs(imageData.rotate)%180===90;var naturalWidth=rotated?imageData.naturalHeight:imageData.naturalWidth;var naturalHeight=rotated?imageData.naturalWidth:imageData.naturalHeight;var aspectRatio=naturalWidth/naturalHeight;var canvasWidth=containerData.width;var canvasHeight=containerData.height;if(containerData.height*aspectRatio>containerData.width){if(viewMode===3){canvasWidth=containerData.height*aspectRatio}else{canvasHeight=containerData.width/aspectRatio}}else if(viewMode===3){canvasHeight=containerData.width/aspectRatio}else{canvasWidth=containerData.height*aspectRatio}var canvasData={aspectRatio:aspectRatio,naturalWidth:naturalWidth,naturalHeight:naturalHeight,width:canvasWidth,height:canvasHeight};this.canvasData=canvasData;this.limited=viewMode===1||viewMode===2;this.limitCanvas(true,true);canvasData.width=Math.min(Math.max(canvasData.width,canvasData.minWidth),canvasData.maxWidth);canvasData.height=Math.min(Math.max(canvasData.height,canvasData.minHeight),canvasData.maxHeight);canvasData.left=(containerData.width-canvasData.width)/2;canvasData.top=(containerData.height-canvasData.height)/2;canvasData.oldLeft=canvasData.left;canvasData.oldTop=canvasData.top;this.initialCanvasData=assign({},canvasData)},limitCanvas:function limitCanvas(sizeLimited,positionLimited){var options=this.options,containerData=this.containerData,canvasData=this.canvasData,cropBoxData=this.cropBoxData;var viewMode=options.viewMode;var aspectRatio=canvasData.aspectRatio;var cropped=this.cropped&&cropBoxData;if(sizeLimited){var minCanvasWidth=Number(options.minCanvasWidth)||0;var minCanvasHeight=Number(options.minCanvasHeight)||0;if(viewMode>1){minCanvasWidth=Math.max(minCanvasWidth,containerData.width);minCanvasHeight=Math.max(minCanvasHeight,containerData.height);if(viewMode===3){if(minCanvasHeight*aspectRatio>minCanvasWidth){minCanvasWidth=minCanvasHeight*aspectRatio}else{minCanvasHeight=minCanvasWidth/aspectRatio}}}else if(viewMode>0){if(minCanvasWidth){minCanvasWidth=Math.max(minCanvasWidth,cropped?cropBoxData.width:0)}else if(minCanvasHeight){minCanvasHeight=Math.max(minCanvasHeight,cropped?cropBoxData.height:0)}else if(cropped){minCanvasWidth=cropBoxData.width;minCanvasHeight=cropBoxData.height;if(minCanvasHeight*aspectRatio>minCanvasWidth){minCanvasWidth=minCanvasHeight*aspectRatio}else{minCanvasHeight=minCanvasWidth/aspectRatio}}}var _getAdjustedSizes=getAdjustedSizes({aspectRatio:aspectRatio,width:minCanvasWidth,height:minCanvasHeight});minCanvasWidth=_getAdjustedSizes.width;minCanvasHeight=_getAdjustedSizes.height;canvasData.minWidth=minCanvasWidth;canvasData.minHeight=minCanvasHeight;canvasData.maxWidth=Infinity;canvasData.maxHeight=Infinity}if(positionLimited){if(viewMode>(cropped?0:1)){var newCanvasLeft=containerData.width-canvasData.width;var newCanvasTop=containerData.height-canvasData.height;canvasData.minLeft=Math.min(0,newCanvasLeft);canvasData.minTop=Math.min(0,newCanvasTop);canvasData.maxLeft=Math.max(0,newCanvasLeft);canvasData.maxTop=Math.max(0,newCanvasTop);if(cropped&&this.limited){canvasData.minLeft=Math.min(cropBoxData.left,cropBoxData.left+(cropBoxData.width-canvasData.width));canvasData.minTop=Math.min(cropBoxData.top,cropBoxData.top+(cropBoxData.height-canvasData.height));canvasData.maxLeft=cropBoxData.left;canvasData.maxTop=cropBoxData.top;if(viewMode===2){if(canvasData.width>=containerData.width){canvasData.minLeft=Math.min(0,newCanvasLeft);canvasData.maxLeft=Math.max(0,newCanvasLeft)}if(canvasData.height>=containerData.height){canvasData.minTop=Math.min(0,newCanvasTop);canvasData.maxTop=Math.max(0,newCanvasTop)}}}}else{canvasData.minLeft=-canvasData.width;canvasData.minTop=-canvasData.height;canvasData.maxLeft=containerData.width;canvasData.maxTop=containerData.height}}},renderCanvas:function renderCanvas(changed,transformed){var canvasData=this.canvasData,imageData=this.imageData;if(transformed){var _getRotatedSizes=getRotatedSizes({width:imageData.naturalWidth*Math.abs(imageData.scaleX||1),height:imageData.naturalHeight*Math.abs(imageData.scaleY||1),degree:imageData.rotate||0}),naturalWidth=_getRotatedSizes.width,naturalHeight=_getRotatedSizes.height;var width=canvasData.width*(naturalWidth/canvasData.naturalWidth);var height=canvasData.height*(naturalHeight/canvasData.naturalHeight);canvasData.left-=(width-canvasData.width)/2;canvasData.top-=(height-canvasData.height)/2;canvasData.width=width;canvasData.height=height;canvasData.aspectRatio=naturalWidth/naturalHeight;canvasData.naturalWidth=naturalWidth;canvasData.naturalHeight=naturalHeight;this.limitCanvas(true,false)}if(canvasData.width>canvasData.maxWidth||canvasData.width<canvasData.minWidth){canvasData.left=canvasData.oldLeft}if(canvasData.height>canvasData.maxHeight||canvasData.height<canvasData.minHeight){canvasData.top=canvasData.oldTop}canvasData.width=Math.min(Math.max(canvasData.width,canvasData.minWidth),canvasData.maxWidth);canvasData.height=Math.min(Math.max(canvasData.height,canvasData.minHeight),canvasData.maxHeight);this.limitCanvas(false,true);canvasData.left=Math.min(Math.max(canvasData.left,canvasData.minLeft),canvasData.maxLeft);canvasData.top=Math.min(Math.max(canvasData.top,canvasData.minTop),canvasData.maxTop);canvasData.oldLeft=canvasData.left;canvasData.oldTop=canvasData.top;setStyle(this.canvas,assign({width:canvasData.width,height:canvasData.height},getTransforms({translateX:canvasData.left,translateY:canvasData.top})));this.renderImage(changed);if(this.cropped&&this.limited){this.limitCropBox(true,true)}},renderImage:function renderImage(changed){var canvasData=this.canvasData,imageData=this.imageData;var width=imageData.naturalWidth*(canvasData.width/canvasData.naturalWidth);var height=imageData.naturalHeight*(canvasData.height/canvasData.naturalHeight);assign(imageData,{width:width,height:height,left:(canvasData.width-width)/2,top:(canvasData.height-height)/2});setStyle(this.image,assign({width:imageData.width,height:imageData.height},getTransforms(assign({translateX:imageData.left,translateY:imageData.top},imageData))));if(changed){this.output()}},initCropBox:function initCropBox(){var options=this.options,canvasData=this.canvasData;var aspectRatio=options.aspectRatio||options.initialAspectRatio;var autoCropArea=Number(options.autoCropArea)||.8;var cropBoxData={width:canvasData.width,height:canvasData.height};if(aspectRatio){if(canvasData.height*aspectRatio>canvasData.width){cropBoxData.height=cropBoxData.width/aspectRatio}else{cropBoxData.width=cropBoxData.height*aspectRatio}}this.cropBoxData=cropBoxData;this.limitCropBox(true,true);cropBoxData.width=Math.min(Math.max(cropBoxData.width,cropBoxData.minWidth),cropBoxData.maxWidth);cropBoxData.height=Math.min(Math.max(cropBoxData.height,cropBoxData.minHeight),cropBoxData.maxHeight);cropBoxData.width=Math.max(cropBoxData.minWidth,cropBoxData.width*autoCropArea);cropBoxData.height=Math.max(cropBoxData.minHeight,cropBoxData.height*autoCropArea);cropBoxData.left=canvasData.left+(canvasData.width-cropBoxData.width)/2;cropBoxData.top=canvasData.top+(canvasData.height-cropBoxData.height)/2;cropBoxData.oldLeft=cropBoxData.left;cropBoxData.oldTop=cropBoxData.top;this.initialCropBoxData=assign({},cropBoxData)},limitCropBox:function limitCropBox(sizeLimited,positionLimited){var options=this.options,containerData=this.containerData,canvasData=this.canvasData,cropBoxData=this.cropBoxData,limited=this.limited;var aspectRatio=options.aspectRatio;if(sizeLimited){var minCropBoxWidth=Number(options.minCropBoxWidth)||0;var minCropBoxHeight=Number(options.minCropBoxHeight)||0;var maxCropBoxWidth=limited?Math.min(containerData.width,canvasData.width,canvasData.width+canvasData.left,containerData.width-canvasData.left):containerData.width;var maxCropBoxHeight=limited?Math.min(containerData.height,canvasData.height,canvasData.height+canvasData.top,containerData.height-canvasData.top):containerData.height;minCropBoxWidth=Math.min(minCropBoxWidth,containerData.width);minCropBoxHeight=Math.min(minCropBoxHeight,containerData.height);if(aspectRatio){if(minCropBoxWidth&&minCropBoxHeight){if(minCropBoxHeight*aspectRatio>minCropBoxWidth){minCropBoxHeight=minCropBoxWidth/aspectRatio}else{minCropBoxWidth=minCropBoxHeight*aspectRatio}}else if(minCropBoxWidth){minCropBoxHeight=minCropBoxWidth/aspectRatio}else if(minCropBoxHeight){minCropBoxWidth=minCropBoxHeight*aspectRatio}if(maxCropBoxHeight*aspectRatio>maxCropBoxWidth){maxCropBoxHeight=maxCropBoxWidth/aspectRatio}else{maxCropBoxWidth=maxCropBoxHeight*aspectRatio}}cropBoxData.minWidth=Math.min(minCropBoxWidth,maxCropBoxWidth);cropBoxData.minHeight=Math.min(minCropBoxHeight,maxCropBoxHeight);cropBoxData.maxWidth=maxCropBoxWidth;cropBoxData.maxHeight=maxCropBoxHeight}if(positionLimited){if(limited){cropBoxData.minLeft=Math.max(0,canvasData.left);cropBoxData.minTop=Math.max(0,canvasData.top);cropBoxData.maxLeft=Math.min(containerData.width,canvasData.left+canvasData.width)-cropBoxData.width;cropBoxData.maxTop=Math.min(containerData.height,canvasData.top+canvasData.height)-cropBoxData.height}else{cropBoxData.minLeft=0;cropBoxData.minTop=0;cropBoxData.maxLeft=containerData.width-cropBoxData.width;cropBoxData.maxTop=containerData.height-cropBoxData.height}}},renderCropBox:function renderCropBox(){var options=this.options,containerData=this.containerData,cropBoxData=this.cropBoxData;if(cropBoxData.width>cropBoxData.maxWidth||cropBoxData.width<cropBoxData.minWidth){cropBoxData.left=cropBoxData.oldLeft}if(cropBoxData.height>cropBoxData.maxHeight||cropBoxData.height<cropBoxData.minHeight){cropBoxData.top=cropBoxData.oldTop}cropBoxData.width=Math.min(Math.max(cropBoxData.width,cropBoxData.minWidth),cropBoxData.maxWidth);cropBoxData.height=Math.min(Math.max(cropBoxData.height,cropBoxData.minHeight),cropBoxData.maxHeight);this.limitCropBox(false,true);cropBoxData.left=Math.min(Math.max(cropBoxData.left,cropBoxData.minLeft),cropBoxData.maxLeft);cropBoxData.top=Math.min(Math.max(cropBoxData.top,cropBoxData.minTop),cropBoxData.maxTop);cropBoxData.oldLeft=cropBoxData.left;cropBoxData.oldTop=cropBoxData.top;if(options.movable&&options.cropBoxMovable){setData(this.face,DATA_ACTION,cropBoxData.width>=containerData.width&&cropBoxData.height>=containerData.height?ACTION_MOVE:ACTION_ALL)}setStyle(this.cropBox,assign({width:cropBoxData.width,height:cropBoxData.height},getTransforms({translateX:cropBoxData.left,translateY:cropBoxData.top})));if(this.cropped&&this.limited){this.limitCanvas(true,true)}if(!this.disabled){this.output()}},output:function output(){this.preview();dispatchEvent(this.element,EVENT_CROP,this.getData())}};var preview={initPreview:function initPreview(){var element=this.element,crossOrigin=this.crossOrigin;var preview=this.options.preview;var url=crossOrigin?this.crossOriginUrl:this.url;var alt=element.alt||"The image to preview";var image=document.createElement("img");if(crossOrigin){image.crossOrigin=crossOrigin}image.src=url;image.alt=alt;this.viewBox.appendChild(image);this.viewBoxImage=image;if(!preview){return}var previews=preview;if(typeof preview==="string"){previews=element.ownerDocument.querySelectorAll(preview)}else if(preview.querySelector){previews=[preview]}this.previews=previews;forEach(previews,function(el){var img=document.createElement("img");setData(el,DATA_PREVIEW,{width:el.offsetWidth,height:el.offsetHeight,html:el.innerHTML});if(crossOrigin){img.crossOrigin=crossOrigin}img.src=url;img.alt=alt;img.style.cssText="display:block;"+"width:100%;"+"height:auto;"+"min-width:0!important;"+"min-height:0!important;"+"max-width:none!important;"+"max-height:none!important;"+'image-orientation:0deg!important;"';el.innerHTML="";el.appendChild(img)})},resetPreview:function resetPreview(){forEach(this.previews,function(element){var data=getData(element,DATA_PREVIEW);setStyle(element,{width:data.width,height:data.height});element.innerHTML=data.html;removeData(element,DATA_PREVIEW)})},preview:function preview(){var imageData=this.imageData,canvasData=this.canvasData,cropBoxData=this.cropBoxData;var cropBoxWidth=cropBoxData.width,cropBoxHeight=cropBoxData.height;var width=imageData.width,height=imageData.height;var left=cropBoxData.left-canvasData.left-imageData.left;var top=cropBoxData.top-canvasData.top-imageData.top;if(!this.cropped||this.disabled){return}setStyle(this.viewBoxImage,assign({width:width,height:height},getTransforms(assign({translateX:-left,translateY:-top},imageData))));forEach(this.previews,function(element){var data=getData(element,DATA_PREVIEW);var originalWidth=data.width;var originalHeight=data.height;var newWidth=originalWidth;var newHeight=originalHeight;var ratio=1;if(cropBoxWidth){ratio=originalWidth/cropBoxWidth;newHeight=cropBoxHeight*ratio}if(cropBoxHeight&&newHeight>originalHeight){ratio=originalHeight/cropBoxHeight;newWidth=cropBoxWidth*ratio;newHeight=originalHeight}setStyle(element,{width:newWidth,height:newHeight});setStyle(element.getElementsByTagName("img")[0],assign({width:width*ratio,height:height*ratio},getTransforms(assign({translateX:-left*ratio,translateY:-top*ratio},imageData))))})}};var events={bind:function bind(){var element=this.element,options=this.options,cropper=this.cropper;if(isFunction(options.cropstart)){addListener(element,EVENT_CROP_START,options.cropstart)}if(isFunction(options.cropmove)){addListener(element,EVENT_CROP_MOVE,options.cropmove)}if(isFunction(options.cropend)){addListener(element,EVENT_CROP_END,options.cropend)}if(isFunction(options.crop)){addListener(element,EVENT_CROP,options.crop)}if(isFunction(options.zoom)){addListener(element,EVENT_ZOOM,options.zoom)}addListener(cropper,EVENT_POINTER_DOWN,this.onCropStart=this.cropStart.bind(this));if(options.zoomable&&options.zoomOnWheel){addListener(cropper,EVENT_WHEEL,this.onWheel=this.wheel.bind(this),{passive:false,capture:true})}if(options.toggleDragModeOnDblclick){addListener(cropper,EVENT_DBLCLICK,this.onDblclick=this.dblclick.bind(this))}addListener(element.ownerDocument,EVENT_POINTER_MOVE,this.onCropMove=this.cropMove.bind(this));addListener(element.ownerDocument,EVENT_POINTER_UP,this.onCropEnd=this.cropEnd.bind(this));if(options.responsive){addListener(window,EVENT_RESIZE,this.onResize=this.resize.bind(this))}},unbind:function unbind(){var element=this.element,options=this.options,cropper=this.cropper;if(isFunction(options.cropstart)){removeListener(element,EVENT_CROP_START,options.cropstart)}if(isFunction(options.cropmove)){removeListener(element,EVENT_CROP_MOVE,options.cropmove)}if(isFunction(options.cropend)){removeListener(element,EVENT_CROP_END,options.cropend)}if(isFunction(options.crop)){removeListener(element,EVENT_CROP,options.crop)}if(isFunction(options.zoom)){removeListener(element,EVENT_ZOOM,options.zoom)}removeListener(cropper,EVENT_POINTER_DOWN,this.onCropStart);if(options.zoomable&&options.zoomOnWheel){removeListener(cropper,EVENT_WHEEL,this.onWheel,{passive:false,capture:true})}if(options.toggleDragModeOnDblclick){removeListener(cropper,EVENT_DBLCLICK,this.onDblclick)}removeListener(element.ownerDocument,EVENT_POINTER_MOVE,this.onCropMove);removeListener(element.ownerDocument,EVENT_POINTER_UP,this.onCropEnd);if(options.responsive){removeListener(window,EVENT_RESIZE,this.onResize)}}};var handlers={resize:function resize(){if(this.disabled){return}var options=this.options,container=this.container,containerData=this.containerData;var ratioX=container.offsetWidth/containerData.width;var ratioY=container.offsetHeight/containerData.height;var ratio=Math.abs(ratioX-1)>Math.abs(ratioY-1)?ratioX:ratioY;if(ratio!==1){var canvasData;var cropBoxData;if(options.restore){canvasData=this.getCanvasData();cropBoxData=this.getCropBoxData()}this.render();if(options.restore){this.setCanvasData(forEach(canvasData,function(n,i){canvasData[i]=n*ratio}));this.setCropBoxData(forEach(cropBoxData,function(n,i){cropBoxData[i]=n*ratio}))}}},dblclick:function dblclick(){if(this.disabled||this.options.dragMode===DRAG_MODE_NONE){return}this.setDragMode(hasClass(this.dragBox,CLASS_CROP)?DRAG_MODE_MOVE:DRAG_MODE_CROP)},wheel:function wheel(event){var _this=this;var ratio=Number(this.options.wheelZoomRatio)||.1;var delta=1;if(this.disabled){return}event.preventDefault();if(this.wheeling){return}this.wheeling=true;setTimeout(function(){_this.wheeling=false},50);if(event.deltaY){delta=event.deltaY>0?1:-1}else if(event.wheelDelta){delta=-event.wheelDelta/120}else if(event.detail){delta=event.detail>0?1:-1}this.zoom(-delta*ratio,event)},cropStart:function cropStart(event){var buttons=event.buttons,button=event.button;if(this.disabled||(event.type==="mousedown"||event.type==="pointerdown"&&event.pointerType==="mouse")&&(isNumber(buttons)&&buttons!==1||isNumber(button)&&button!==0||event.ctrlKey)){return}var options=this.options,pointers=this.pointers;var action;if(event.changedTouches){forEach(event.changedTouches,function(touch){pointers[touch.identifier]=getPointer(touch)})}else{pointers[event.pointerId||0]=getPointer(event)}if(Object.keys(pointers).length>1&&options.zoomable&&options.zoomOnTouch){action=ACTION_ZOOM}else{action=getData(event.target,DATA_ACTION)}if(!REGEXP_ACTIONS.test(action)){return}if(dispatchEvent(this.element,EVENT_CROP_START,{originalEvent:event,action:action})===false){return}event.preventDefault();this.action=action;this.cropping=false;if(action===ACTION_CROP){this.cropping=true;addClass(this.dragBox,CLASS_MODAL)}},cropMove:function cropMove(event){var action=this.action;if(this.disabled||!action){return}var pointers=this.pointers;event.preventDefault();if(dispatchEvent(this.element,EVENT_CROP_MOVE,{originalEvent:event,action:action})===false){return}if(event.changedTouches){forEach(event.changedTouches,function(touch){assign(pointers[touch.identifier]||{},getPointer(touch,true))})}else{assign(pointers[event.pointerId||0]||{},getPointer(event,true))}this.change(event)},cropEnd:function cropEnd(event){if(this.disabled){return}var action=this.action,pointers=this.pointers;if(event.changedTouches){forEach(event.changedTouches,function(touch){delete pointers[touch.identifier]})}else{delete pointers[event.pointerId||0]}if(!action){return}event.preventDefault();if(!Object.keys(pointers).length){this.action=""}if(this.cropping){this.cropping=false;toggleClass(this.dragBox,CLASS_MODAL,this.cropped&&this.options.modal)}dispatchEvent(this.element,EVENT_CROP_END,{originalEvent:event,action:action})}};var change={change:function change(event){var options=this.options,canvasData=this.canvasData,containerData=this.containerData,cropBoxData=this.cropBoxData,pointers=this.pointers;var action=this.action;var aspectRatio=options.aspectRatio;var left=cropBoxData.left,top=cropBoxData.top,width=cropBoxData.width,height=cropBoxData.height;var right=left+width;var bottom=top+height;var minLeft=0;var minTop=0;var maxWidth=containerData.width;var maxHeight=containerData.height;var renderable=true;var offset;if(!aspectRatio&&event.shiftKey){aspectRatio=width&&height?width/height:1}if(this.limited){minLeft=cropBoxData.minLeft;minTop=cropBoxData.minTop;maxWidth=minLeft+Math.min(containerData.width,canvasData.width,canvasData.left+canvasData.width);maxHeight=minTop+Math.min(containerData.height,canvasData.height,canvasData.top+canvasData.height)}var pointer=pointers[Object.keys(pointers)[0]];var range={x:pointer.endX-pointer.startX,y:pointer.endY-pointer.startY};var check=function check(side){switch(side){case ACTION_EAST:if(right+range.x>maxWidth){range.x=maxWidth-right}break;case ACTION_WEST:if(left+range.x<minLeft){range.x=minLeft-left}break;case ACTION_NORTH:if(top+range.y<minTop){range.y=minTop-top}break;case ACTION_SOUTH:if(bottom+range.y>maxHeight){range.y=maxHeight-bottom}break}};switch(action){case ACTION_ALL:left+=range.x;top+=range.y;break;case ACTION_EAST:if(range.x>=0&&(right>=maxWidth||aspectRatio&&(top<=minTop||bottom>=maxHeight))){renderable=false;break}check(ACTION_EAST);width+=range.x;if(width<0){action=ACTION_WEST;width=-width;left-=width}if(aspectRatio){height=width/aspectRatio;top+=(cropBoxData.height-height)/2}break;case ACTION_NORTH:if(range.y<=0&&(top<=minTop||aspectRatio&&(left<=minLeft||right>=maxWidth))){renderable=false;break}check(ACTION_NORTH);height-=range.y;top+=range.y;if(height<0){action=ACTION_SOUTH;height=-height;top-=height}if(aspectRatio){width=height*aspectRatio;left+=(cropBoxData.width-width)/2}break;case ACTION_WEST:if(range.x<=0&&(left<=minLeft||aspectRatio&&(top<=minTop||bottom>=maxHeight))){renderable=false;break}check(ACTION_WEST);width-=range.x;left+=range.x;if(width<0){action=ACTION_EAST;width=-width;left-=width}if(aspectRatio){height=width/aspectRatio;top+=(cropBoxData.height-height)/2}break;case ACTION_SOUTH:if(range.y>=0&&(bottom>=maxHeight||aspectRatio&&(left<=minLeft||right>=maxWidth))){renderable=false;break}check(ACTION_SOUTH);height+=range.y;if(height<0){action=ACTION_NORTH;height=-height;top-=height}if(aspectRatio){width=height*aspectRatio;left+=(cropBoxData.width-width)/2}break;case ACTION_NORTH_EAST:if(aspectRatio){if(range.y<=0&&(top<=minTop||right>=maxWidth)){renderable=false;break}check(ACTION_NORTH);height-=range.y;top+=range.y;width=height*aspectRatio}else{check(ACTION_NORTH);check(ACTION_EAST);if(range.x>=0){if(right<maxWidth){width+=range.x}else if(range.y<=0&&top<=minTop){renderable=false}}else{width+=range.x}if(range.y<=0){if(top>minTop){height-=range.y;top+=range.y}}else{height-=range.y;top+=range.y}}if(width<0&&height<0){action=ACTION_SOUTH_WEST;height=-height;width=-width;top-=height;left-=width}else if(width<0){action=ACTION_NORTH_WEST;width=-width;left-=width}else if(height<0){action=ACTION_SOUTH_EAST;height=-height;top-=height}break;case ACTION_NORTH_WEST:if(aspectRatio){if(range.y<=0&&(top<=minTop||left<=minLeft)){renderable=false;break}check(ACTION_NORTH);height-=range.y;top+=range.y;width=height*aspectRatio;left+=cropBoxData.width-width}else{check(ACTION_NORTH);check(ACTION_WEST);if(range.x<=0){if(left>minLeft){width-=range.x;left+=range.x}else if(range.y<=0&&top<=minTop){renderable=false}}else{width-=range.x;left+=range.x}if(range.y<=0){if(top>minTop){height-=range.y;top+=range.y}}else{height-=range.y;top+=range.y}}if(width<0&&height<0){action=ACTION_SOUTH_EAST;height=-height;width=-width;top-=height;left-=width}else if(width<0){action=ACTION_NORTH_EAST;width=-width;left-=width}else if(height<0){action=ACTION_SOUTH_WEST;height=-height;top-=height}break;case ACTION_SOUTH_WEST:if(aspectRatio){if(range.x<=0&&(left<=minLeft||bottom>=maxHeight)){renderable=false;break}check(ACTION_WEST);width-=range.x;left+=range.x;height=width/aspectRatio}else{check(ACTION_SOUTH);check(ACTION_WEST);if(range.x<=0){if(left>minLeft){width-=range.x;left+=range.x}else if(range.y>=0&&bottom>=maxHeight){renderable=false}}else{width-=range.x;left+=range.x}if(range.y>=0){if(bottom<maxHeight){height+=range.y}}else{height+=range.y}}if(width<0&&height<0){action=ACTION_NORTH_EAST;height=-height;width=-width;top-=height;left-=width}else if(width<0){action=ACTION_SOUTH_EAST;width=-width;left-=width}else if(height<0){action=ACTION_NORTH_WEST;height=-height;top-=height}break;case ACTION_SOUTH_EAST:if(aspectRatio){if(range.x>=0&&(right>=maxWidth||bottom>=maxHeight)){renderable=false;break}check(ACTION_EAST);width+=range.x;height=width/aspectRatio}else{check(ACTION_SOUTH);check(ACTION_EAST);if(range.x>=0){if(right<maxWidth){width+=range.x}else if(range.y>=0&&bottom>=maxHeight){renderable=false}}else{width+=range.x}if(range.y>=0){if(bottom<maxHeight){height+=range.y}}else{height+=range.y}}if(width<0&&height<0){action=ACTION_NORTH_WEST;height=-height;width=-width;top-=height;left-=width}else if(width<0){action=ACTION_SOUTH_WEST;width=-width;left-=width}else if(height<0){action=ACTION_NORTH_EAST;height=-height;top-=height}break;case ACTION_MOVE:this.move(range.x,range.y);renderable=false;break;case ACTION_ZOOM:this.zoom(getMaxZoomRatio(pointers),event);renderable=false;break;case ACTION_CROP:if(!range.x||!range.y){renderable=false;break}offset=getOffset(this.cropper);left=pointer.startX-offset.left;top=pointer.startY-offset.top;width=cropBoxData.minWidth;height=cropBoxData.minHeight;if(range.x>0){action=range.y>0?ACTION_SOUTH_EAST:ACTION_NORTH_EAST}else if(range.x<0){left-=width;action=range.y>0?ACTION_SOUTH_WEST:ACTION_NORTH_WEST}if(range.y<0){top-=height}if(!this.cropped){removeClass(this.cropBox,CLASS_HIDDEN);this.cropped=true;if(this.limited){this.limitCropBox(true,true)}}break}if(renderable){cropBoxData.width=width;cropBoxData.height=height;cropBoxData.left=left;cropBoxData.top=top;this.action=action;this.renderCropBox()}forEach(pointers,function(p){p.startX=p.endX;p.startY=p.endY})}};var methods={crop:function crop(){if(this.ready&&!this.cropped&&!this.disabled){this.cropped=true;this.limitCropBox(true,true);if(this.options.modal){addClass(this.dragBox,CLASS_MODAL)}removeClass(this.cropBox,CLASS_HIDDEN);this.setCropBoxData(this.initialCropBoxData)}return this},reset:function reset(){if(this.ready&&!this.disabled){this.imageData=assign({},this.initialImageData);this.canvasData=assign({},this.initialCanvasData);this.cropBoxData=assign({},this.initialCropBoxData);this.renderCanvas();if(this.cropped){this.renderCropBox()}}return this},clear:function clear(){if(this.cropped&&!this.disabled){assign(this.cropBoxData,{left:0,top:0,width:0,height:0});this.cropped=false;this.renderCropBox();this.limitCanvas(true,true);this.renderCanvas();removeClass(this.dragBox,CLASS_MODAL);addClass(this.cropBox,CLASS_HIDDEN)}return this},replace:function replace(url){var hasSameSize=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;if(!this.disabled&&url){if(this.isImg){this.element.src=url}if(hasSameSize){this.url=url;this.image.src=url;if(this.ready){this.viewBoxImage.src=url;forEach(this.previews,function(element){element.getElementsByTagName("img")[0].src=url})}}else{if(this.isImg){this.replaced=true}this.options.data=null;this.uncreate();this.load(url)}}return this},enable:function enable(){if(this.ready&&this.disabled){this.disabled=false;removeClass(this.cropper,CLASS_DISABLED)}return this},disable:function disable(){if(this.ready&&!this.disabled){this.disabled=true;addClass(this.cropper,CLASS_DISABLED)}return this},destroy:function destroy(){var element=this.element;if(!element[NAMESPACE]){return this}element[NAMESPACE]=undefined;if(this.isImg&&this.replaced){element.src=this.originalUrl}this.uncreate();return this},move:function move(offsetX){var offsetY=arguments.length>1&&arguments[1]!==undefined?arguments[1]:offsetX;var _this$canvasData=this.canvasData,left=_this$canvasData.left,top=_this$canvasData.top;return this.moveTo(isUndefined(offsetX)?offsetX:left+Number(offsetX),isUndefined(offsetY)?offsetY:top+Number(offsetY))},moveTo:function moveTo(x){var y=arguments.length>1&&arguments[1]!==undefined?arguments[1]:x;var canvasData=this.canvasData;var changed=false;x=Number(x);y=Number(y);if(this.ready&&!this.disabled&&this.options.movable){if(isNumber(x)){canvasData.left=x;changed=true}if(isNumber(y)){canvasData.top=y;changed=true}if(changed){this.renderCanvas(true)}}return this},zoom:function zoom(ratio,_originalEvent){var canvasData=this.canvasData;ratio=Number(ratio);if(ratio<0){ratio=1/(1-ratio)}else{ratio=1+ratio}return this.zoomTo(canvasData.width*ratio/canvasData.naturalWidth,null,_originalEvent)},zoomTo:function zoomTo(ratio,pivot,_originalEvent){var options=this.options,canvasData=this.canvasData;var width=canvasData.width,height=canvasData.height,naturalWidth=canvasData.naturalWidth,naturalHeight=canvasData.naturalHeight;ratio=Number(ratio);if(ratio>=0&&this.ready&&!this.disabled&&options.zoomable){var newWidth=naturalWidth*ratio;var newHeight=naturalHeight*ratio;if(dispatchEvent(this.element,EVENT_ZOOM,{ratio:ratio,oldRatio:width/naturalWidth,originalEvent:_originalEvent})===false){return this}if(_originalEvent){var pointers=this.pointers;var offset=getOffset(this.cropper);var center=pointers&&Object.keys(pointers).length?getPointersCenter(pointers):{pageX:_originalEvent.pageX,pageY:_originalEvent.pageY};canvasData.left-=(newWidth-width)*((center.pageX-offset.left-canvasData.left)/width);canvasData.top-=(newHeight-height)*((center.pageY-offset.top-canvasData.top)/height)}else if(isPlainObject(pivot)&&isNumber(pivot.x)&&isNumber(pivot.y)){canvasData.left-=(newWidth-width)*((pivot.x-canvasData.left)/width);canvasData.top-=(newHeight-height)*((pivot.y-canvasData.top)/height)}else{canvasData.left-=(newWidth-width)/2;canvasData.top-=(newHeight-height)/2}canvasData.width=newWidth;canvasData.height=newHeight;this.renderCanvas(true)}return this},rotate:function rotate(degree){return this.rotateTo((this.imageData.rotate||0)+Number(degree))},rotateTo:function rotateTo(degree){degree=Number(degree);if(isNumber(degree)&&this.ready&&!this.disabled&&this.options.rotatable){this.imageData.rotate=degree%360;this.renderCanvas(true,true)}return this},scaleX:function scaleX(_scaleX){var scaleY=this.imageData.scaleY;return this.scale(_scaleX,isNumber(scaleY)?scaleY:1)},scaleY:function scaleY(_scaleY){var scaleX=this.imageData.scaleX;return this.scale(isNumber(scaleX)?scaleX:1,_scaleY)},scale:function scale(scaleX){var scaleY=arguments.length>1&&arguments[1]!==undefined?arguments[1]:scaleX;var imageData=this.imageData;var transformed=false;scaleX=Number(scaleX);scaleY=Number(scaleY);if(this.ready&&!this.disabled&&this.options.scalable){if(isNumber(scaleX)){imageData.scaleX=scaleX;transformed=true}if(isNumber(scaleY)){imageData.scaleY=scaleY;transformed=true}if(transformed){this.renderCanvas(true,true)}}return this},getData:function getData(){var rounded=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;var options=this.options,imageData=this.imageData,canvasData=this.canvasData,cropBoxData=this.cropBoxData;var data;if(this.ready&&this.cropped){data={x:cropBoxData.left-canvasData.left,y:cropBoxData.top-canvasData.top,width:cropBoxData.width,height:cropBoxData.height};var ratio=imageData.width/imageData.naturalWidth;forEach(data,function(n,i){data[i]=n/ratio});if(rounded){var bottom=Math.round(data.y+data.height);var right=Math.round(data.x+data.width);data.x=Math.round(data.x);data.y=Math.round(data.y);data.width=right-data.x;data.height=bottom-data.y}}else{data={x:0,y:0,width:0,height:0}}if(options.rotatable){data.rotate=imageData.rotate||0}if(options.scalable){data.scaleX=imageData.scaleX||1;data.scaleY=imageData.scaleY||1}return data},setData:function setData(data){var options=this.options,imageData=this.imageData,canvasData=this.canvasData;var cropBoxData={};if(this.ready&&!this.disabled&&isPlainObject(data)){var transformed=false;if(options.rotatable){if(isNumber(data.rotate)&&data.rotate!==imageData.rotate){imageData.rotate=data.rotate;transformed=true}}if(options.scalable){if(isNumber(data.scaleX)&&data.scaleX!==imageData.scaleX){imageData.scaleX=data.scaleX;transformed=true}if(isNumber(data.scaleY)&&data.scaleY!==imageData.scaleY){imageData.scaleY=data.scaleY;transformed=true}}if(transformed){this.renderCanvas(true,true)}var ratio=imageData.width/imageData.naturalWidth;if(isNumber(data.x)){cropBoxData.left=data.x*ratio+canvasData.left}if(isNumber(data.y)){cropBoxData.top=data.y*ratio+canvasData.top}if(isNumber(data.width)){cropBoxData.width=data.width*ratio}if(isNumber(data.height)){cropBoxData.height=data.height*ratio}this.setCropBoxData(cropBoxData)}return this},getContainerData:function getContainerData(){return this.ready?assign({},this.containerData):{}},getImageData:function getImageData(){return this.sized?assign({},this.imageData):{}},getCanvasData:function getCanvasData(){var canvasData=this.canvasData;var data={};if(this.ready){forEach(["left","top","width","height","naturalWidth","naturalHeight"],function(n){data[n]=canvasData[n]})}return data},setCanvasData:function setCanvasData(data){var canvasData=this.canvasData;var aspectRatio=canvasData.aspectRatio;if(this.ready&&!this.disabled&&isPlainObject(data)){if(isNumber(data.left)){canvasData.left=data.left}if(isNumber(data.top)){canvasData.top=data.top}if(isNumber(data.width)){canvasData.width=data.width;canvasData.height=data.width/aspectRatio}else if(isNumber(data.height)){canvasData.height=data.height;canvasData.width=data.height*aspectRatio}this.renderCanvas(true)}return this},getCropBoxData:function getCropBoxData(){var cropBoxData=this.cropBoxData;var data;if(this.ready&&this.cropped){data={left:cropBoxData.left,top:cropBoxData.top,width:cropBoxData.width,height:cropBoxData.height}}return data||{}},setCropBoxData:function setCropBoxData(data){var cropBoxData=this.cropBoxData;var aspectRatio=this.options.aspectRatio;var widthChanged;var heightChanged;if(this.ready&&this.cropped&&!this.disabled&&isPlainObject(data)){if(isNumber(data.left)){cropBoxData.left=data.left}if(isNumber(data.top)){cropBoxData.top=data.top}if(isNumber(data.width)&&data.width!==cropBoxData.width){widthChanged=true;cropBoxData.width=data.width}if(isNumber(data.height)&&data.height!==cropBoxData.height){heightChanged=true;cropBoxData.height=data.height}if(aspectRatio){if(widthChanged){cropBoxData.height=cropBoxData.width/aspectRatio}else if(heightChanged){cropBoxData.width=cropBoxData.height*aspectRatio}}this.renderCropBox()}return this},getCroppedCanvas:function getCroppedCanvas(){var options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};if(!this.ready||!window.HTMLCanvasElement){return null}var canvasData=this.canvasData;var source=getSourceCanvas(this.image,this.imageData,canvasData,options);if(!this.cropped){return source}var _this$getData=this.getData(options.rounded),initialX=_this$getData.x,initialY=_this$getData.y,initialWidth=_this$getData.width,initialHeight=_this$getData.height;var ratio=source.width/Math.floor(canvasData.naturalWidth);if(ratio!==1){initialX*=ratio;initialY*=ratio;initialWidth*=ratio;initialHeight*=ratio}var aspectRatio=initialWidth/initialHeight;var maxSizes=getAdjustedSizes({aspectRatio:aspectRatio,width:options.maxWidth||Infinity,height:options.maxHeight||Infinity});var minSizes=getAdjustedSizes({aspectRatio:aspectRatio,width:options.minWidth||0,height:options.minHeight||0},"cover");var _getAdjustedSizes=getAdjustedSizes({aspectRatio:aspectRatio,width:options.width||(ratio!==1?source.width:initialWidth),height:options.height||(ratio!==1?source.height:initialHeight)}),width=_getAdjustedSizes.width,height=_getAdjustedSizes.height;width=Math.min(maxSizes.width,Math.max(minSizes.width,width));height=Math.min(maxSizes.height,Math.max(minSizes.height,height));var canvas=document.createElement("canvas");var context=canvas.getContext("2d");canvas.width=normalizeDecimalNumber(width);canvas.height=normalizeDecimalNumber(height);context.fillStyle=options.fillColor||"transparent";context.fillRect(0,0,width,height);var _options$imageSmoothi=options.imageSmoothingEnabled,imageSmoothingEnabled=_options$imageSmoothi===void 0?true:_options$imageSmoothi,imageSmoothingQuality=options.imageSmoothingQuality;context.imageSmoothingEnabled=imageSmoothingEnabled;if(imageSmoothingQuality){context.imageSmoothingQuality=imageSmoothingQuality}var sourceWidth=source.width;var sourceHeight=source.height;var srcX=initialX;var srcY=initialY;var srcWidth;var srcHeight;var dstX;var dstY;var dstWidth;var dstHeight;if(srcX<=-initialWidth||srcX>sourceWidth){srcX=0;srcWidth=0;dstX=0;dstWidth=0}else if(srcX<=0){dstX=-srcX;srcX=0;srcWidth=Math.min(sourceWidth,initialWidth+srcX);dstWidth=srcWidth}else if(srcX<=sourceWidth){dstX=0;srcWidth=Math.min(initialWidth,sourceWidth-srcX);dstWidth=srcWidth}if(srcWidth<=0||srcY<=-initialHeight||srcY>sourceHeight){srcY=0;srcHeight=0;dstY=0;dstHeight=0}else if(srcY<=0){dstY=-srcY;srcY=0;srcHeight=Math.min(sourceHeight,initialHeight+srcY);dstHeight=srcHeight}else if(srcY<=sourceHeight){dstY=0;srcHeight=Math.min(initialHeight,sourceHeight-srcY);dstHeight=srcHeight}var params=[srcX,srcY,srcWidth,srcHeight];if(dstWidth>0&&dstHeight>0){var scale=width/initialWidth;params.push(dstX*scale,dstY*scale,dstWidth*scale,dstHeight*scale)}context.drawImage.apply(context,[source].concat(_toConsumableArray(params.map(function(param){return Math.floor(normalizeDecimalNumber(param))}))));return canvas},setAspectRatio:function setAspectRatio(aspectRatio){var options=this.options;if(!this.disabled&&!isUndefined(aspectRatio)){options.aspectRatio=Math.max(0,aspectRatio)||NaN;if(this.ready){this.initCropBox();if(this.cropped){this.renderCropBox()}}}return this},setDragMode:function setDragMode(mode){var options=this.options,dragBox=this.dragBox,face=this.face;if(this.ready&&!this.disabled){var croppable=mode===DRAG_MODE_CROP;var movable=options.movable&&mode===DRAG_MODE_MOVE;mode=croppable||movable?mode:DRAG_MODE_NONE;options.dragMode=mode;setData(dragBox,DATA_ACTION,mode);toggleClass(dragBox,CLASS_CROP,croppable);toggleClass(dragBox,CLASS_MOVE,movable);if(!options.cropBoxMovable){setData(face,DATA_ACTION,mode);toggleClass(face,CLASS_CROP,croppable);toggleClass(face,CLASS_MOVE,movable)}}return this}};var AnotherCropper=WINDOW.Cropper;var Cropper=function(){function Cropper(element){var options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};_classCallCheck(this,Cropper);if(!element||!REGEXP_TAG_NAME.test(element.tagName)){throw new Error("The first argument is required and must be an <img> or <canvas> element.")}this.element=element;this.options=assign({},DEFAULTS,isPlainObject(options)&&options);this.cropped=false;this.disabled=false;this.pointers={};this.ready=false;this.reloading=false;this.replaced=false;this.sized=false;this.sizing=false;this.init()}return _createClass(Cropper,[{key:"init",value:function init(){var element=this.element;var tagName=element.tagName.toLowerCase();var url;if(element[NAMESPACE]){return}element[NAMESPACE]=this;if(tagName==="img"){this.isImg=true;url=element.getAttribute("src")||"";this.originalUrl=url;if(!url){return}url=element.src}else if(tagName==="canvas"&&window.HTMLCanvasElement){url=element.toDataURL()}this.load(url)}},{key:"load",value:function load(url){var _this=this;if(!url){return}this.url=url;this.imageData={};var element=this.element,options=this.options;if(!options.rotatable&&!options.scalable){options.checkOrientation=false}if(!options.checkOrientation||!window.ArrayBuffer){this.clone();return}if(REGEXP_DATA_URL.test(url)){if(REGEXP_DATA_URL_JPEG.test(url)){this.read(dataURLToArrayBuffer(url))}else{this.clone()}return}var xhr=new XMLHttpRequest;var clone=this.clone.bind(this);this.reloading=true;this.xhr=xhr;xhr.onabort=clone;xhr.onerror=clone;xhr.ontimeout=clone;xhr.onprogress=function(){if(xhr.getResponseHeader("content-type")!==MIME_TYPE_JPEG){xhr.abort()}};xhr.onload=function(){_this.read(xhr.response)};xhr.onloadend=function(){_this.reloading=false;_this.xhr=null};if(options.checkCrossOrigin&&isCrossOriginURL(url)&&element.crossOrigin){url=addTimestamp(url)}xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.withCredentials=element.crossOrigin==="use-credentials";xhr.send()}},{key:"read",value:function read(arrayBuffer){var options=this.options,imageData=this.imageData;var orientation=resetAndGetOrientation(arrayBuffer);var rotate=0;var scaleX=1;var scaleY=1;if(orientation>1){this.url=arrayBufferToDataURL(arrayBuffer,MIME_TYPE_JPEG);var _parseOrientation=parseOrientation(orientation);rotate=_parseOrientation.rotate;scaleX=_parseOrientation.scaleX;scaleY=_parseOrientation.scaleY}if(options.rotatable){imageData.rotate=rotate}if(options.scalable){imageData.scaleX=scaleX;imageData.scaleY=scaleY}this.clone()}},{key:"clone",value:function clone(){var element=this.element,url=this.url;var crossOrigin=element.crossOrigin;var crossOriginUrl=url;if(this.options.checkCrossOrigin&&isCrossOriginURL(url)){if(!crossOrigin){crossOrigin="anonymous"}crossOriginUrl=addTimestamp(url)}this.crossOrigin=crossOrigin;this.crossOriginUrl=crossOriginUrl;var image=document.createElement("img");if(crossOrigin){image.crossOrigin=crossOrigin}image.src=crossOriginUrl||url;image.alt=element.alt||"The image to crop";this.image=image;image.onload=this.start.bind(this);image.onerror=this.stop.bind(this);addClass(image,CLASS_HIDE);element.parentNode.insertBefore(image,element.nextSibling)}},{key:"start",value:function start(){var _this2=this;var image=this.image;image.onload=null;image.onerror=null;this.sizing=true;var isIOSWebKit=WINDOW.navigator&&/(?:iPad|iPhone|iPod).*?AppleWebKit/i.test(WINDOW.navigator.userAgent);var done=function done(naturalWidth,naturalHeight){assign(_this2.imageData,{naturalWidth:naturalWidth,naturalHeight:naturalHeight,aspectRatio:naturalWidth/naturalHeight});_this2.initialImageData=assign({},_this2.imageData);_this2.sizing=false;_this2.sized=true;_this2.build()};if(image.naturalWidth&&!isIOSWebKit){done(image.naturalWidth,image.naturalHeight);return}var sizingImage=document.createElement("img");var body=document.body||document.documentElement;this.sizingImage=sizingImage;sizingImage.onload=function(){done(sizingImage.width,sizingImage.height);if(!isIOSWebKit){body.removeChild(sizingImage)}};sizingImage.src=image.src;if(!isIOSWebKit){sizingImage.style.cssText="left:0;"+"max-height:none!important;"+"max-width:none!important;"+"min-height:0!important;"+"min-width:0!important;"+"opacity:0;"+"position:absolute;"+"top:0;"+"z-index:-1;";body.appendChild(sizingImage)}}},{key:"stop",value:function stop(){var image=this.image;image.onload=null;image.onerror=null;image.parentNode.removeChild(image);this.image=null}},{key:"build",value:function build(){if(!this.sized||this.ready){return}var element=this.element,options=this.options,image=this.image;var container=element.parentNode;var template=document.createElement("div");template.innerHTML=TEMPLATE;var cropper=template.querySelector(".".concat(NAMESPACE,"-container"));var canvas=cropper.querySelector(".".concat(NAMESPACE,"-canvas"));var dragBox=cropper.querySelector(".".concat(NAMESPACE,"-drag-box"));var cropBox=cropper.querySelector(".".concat(NAMESPACE,"-crop-box"));var face=cropBox.querySelector(".".concat(NAMESPACE,"-face"));this.container=container;this.cropper=cropper;this.canvas=canvas;this.dragBox=dragBox;this.cropBox=cropBox;this.viewBox=cropper.querySelector(".".concat(NAMESPACE,"-view-box"));this.face=face;canvas.appendChild(image);addClass(element,CLASS_HIDDEN);container.insertBefore(cropper,element.nextSibling);removeClass(image,CLASS_HIDE);this.initPreview();this.bind();options.initialAspectRatio=Math.max(0,options.initialAspectRatio)||NaN;options.aspectRatio=Math.max(0,options.aspectRatio)||NaN;options.viewMode=Math.max(0,Math.min(3,Math.round(options.viewMode)))||0;addClass(cropBox,CLASS_HIDDEN);if(!options.guides){addClass(cropBox.getElementsByClassName("".concat(NAMESPACE,"-dashed")),CLASS_HIDDEN)}if(!options.center){addClass(cropBox.getElementsByClassName("".concat(NAMESPACE,"-center")),CLASS_HIDDEN)}if(options.background){addClass(cropper,"".concat(NAMESPACE,"-bg"))}if(!options.highlight){addClass(face,CLASS_INVISIBLE)}if(options.cropBoxMovable){addClass(face,CLASS_MOVE);setData(face,DATA_ACTION,ACTION_ALL)}if(!options.cropBoxResizable){addClass(cropBox.getElementsByClassName("".concat(NAMESPACE,"-line")),CLASS_HIDDEN);addClass(cropBox.getElementsByClassName("".concat(NAMESPACE,"-point")),CLASS_HIDDEN)}this.render();this.ready=true;this.setDragMode(options.dragMode);if(options.autoCrop){this.crop()}this.setData(options.data);if(isFunction(options.ready)){addListener(element,EVENT_READY,options.ready,{once:true})}dispatchEvent(element,EVENT_READY)}},{key:"unbuild",value:function unbuild(){if(!this.ready){return}this.ready=false;this.unbind();this.resetPreview();var parentNode=this.cropper.parentNode;if(parentNode){parentNode.removeChild(this.cropper)}removeClass(this.element,CLASS_HIDDEN)}},{key:"uncreate",value:function uncreate(){if(this.ready){this.unbuild();this.ready=false;this.cropped=false}else if(this.sizing){this.sizingImage.onload=null;this.sizing=false;this.sized=false}else if(this.reloading){this.xhr.onabort=null;this.xhr.abort()}else if(this.image){this.stop()}}}],[{key:"noConflict",value:function noConflict(){window.Cropper=AnotherCropper;return Cropper}},{key:"setDefaults",value:function setDefaults(options){assign(DEFAULTS,isPlainObject(options)&&options)}}])}();assign(Cropper.prototype,render,preview,events,handlers,change,methods);return Cropper});window.lam=window.lam||{};function list_click(box){var cbox=document.getElementsByName(box)[0];if(cbox.checked){cbox.checked=false}else{cbox.checked=true}}function listOUchanged(type,element){location.href="list.php?type="+type+"&suffix="+element.options[element.selectedIndex].value}function listPageNumberKeyPress(url,e){const pageNumber=document.getElementById("listNavPage").value;if(e.key==="Enter"){if(e.preventDefault){e.preventDefault()}location.href=url+"&page="+encodeURIComponent(pageNumber);return false}return true}window.lam.accountLists=window.lam.accountLists||{};window.lam.accountLists.listShowSettingsDialog=function(title,okText,cancelText){const dialogContent=document.getElementById("settingsDialog").cloneNode(true);dialogContent.classList.remove("hidden");dialogContent.firstElementChild.id="settingsDialogForm_dlg";Swal.fire({title:title,confirmButtonText:okText,cancelButtonText:cancelText,showCancelButton:true,html:dialogContent.outerHTML,width:"48em"}).then(result=>{if(result.isConfirmed){document.forms["settingsDialogForm_dlg"].submit()}})};window.lam.accountLists.lockUnlockRadioChange=function(){if(document.querySelector("#lam_accountStatusAction0:checked")){document.getElementById("lam_accountStatusDialogLockDiv").classList.remove("hidden");document.getElementById("lam_accountStatusDialogUnlockDiv").classList.add("hidden")}else{document.getElementById("lam_accountStatusDialogLockDiv").classList.add("hidden");document.getElementById("lam_accountStatusDialogUnlockDiv").classList.remove("hidden")}};function SubmitForm(id,e){if(e.key==="Enter"){if(e.preventDefault){e.preventDefault()}if(e.returnValue){e.returnValue=false}if(window.lam_lastKey){if(window.lam_lastKey==="ArrowUp"||window.lam_lastKey==="ArrowDown"||window.lam_lastKey==="PageUp"||window.lam_lastKey==="PageDown"){window.lam_lastKey=e.key;return true}}document.getElementsByName(id)[0].click();return false}window.lam_lastKey=e.key;return true}function list_switchAccountSelection(){document.querySelectorAll("input.accountBoxUnchecked").forEach(item=>{item.checked=true});document.querySelectorAll("input.accountBoxChecked").forEach(item=>{item.checked=false});const nowChecked=document.querySelectorAll("input.accountBoxUnchecked");const nowUnchecked=document.querySelectorAll("input.accountBoxChecked");nowChecked.forEach(item=>{item.classList.add("accountBoxChecked");item.classList.remove("accountBoxUnchecked")});nowUnchecked.forEach(item=>{item.classList.remove("accountBoxChecked");item.classList.add("accountBoxUnchecked")})}function loginProfileChanged(element){location.href="login.php?useProfile="+element.options[element.selectedIndex].value}function profileShowDeleteDialog(title,okText,cancelText,scope,selectFieldName){const profileName=document.getElementsByName(selectFieldName)[0].value;document.getElementById("deleteText").textContent=profileName;document.getElementById("profileDeleteType").value=scope;document.getElementById("profileDeleteName").value=profileName;const dialogContent=document.getElementById("deleteProfileDialog").cloneNode(true);dialogContent.classList.remove("hidden");dialogContent.firstElementChild.id="deleteProfileDialog_dlg";Swal.fire({title:title,confirmButtonText:okText,cancelButtonText:cancelText,showCancelButton:true,html:dialogContent.outerHTML,width:"48em"}).then(result=>{if(result.isConfirmed){document.forms["deleteProfileDialog_dlg"].submit()}})}function passwordHandleInput(random,ajaxURL,tokenName,tokenValue,okText){let modules=new Array;const passwordDialog=document.getElementById("passwordDialog");passwordDialog.querySelectorAll(":checked").forEach(item=>{modules.push(item.name)});const pwd1=passwordDialog.querySelector("[name=newPassword1]").value;const pwd2=passwordDialog.querySelector("[name=newPassword2]").value;let forcePasswordChange=false;const lamForcePasswordChangeBox=passwordDialog.querySelector("input[name=lamForcePasswordChange]");if(lamForcePasswordChangeBox&&lamForcePasswordChangeBox.checked){forcePasswordChange=true}let sendMail=false;const lamPasswordChangeSendMailBox=passwordDialog.querySelector("input[name=lamPasswordChangeSendMail]");if(lamPasswordChangeSendMailBox&&lamPasswordChangeSendMailBox.checked){sendMail=true}let sendMailAlternateAddress="";const lamPasswordChangeMailAddress=passwordDialog.querySelector("[name=lamPasswordChangeMailAddress]");if(lamPasswordChangeMailAddress){sendMailAlternateAddress=lamPasswordChangeMailAddress.value}const pwdJSON={modules:modules,password1:pwd1,password2:pwd2,random:random,forcePasswordChange:forcePasswordChange,sendMail:sendMail,sendMailAlternateAddress:sendMailAlternateAddress};let data=new FormData;data.append("jsonInput",JSON.stringify(pwdJSON));data.append(tokenName,tokenValue);fetch(ajaxURL,{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();document.querySelector(".modal").classList.remove("show-modal");Swal.fire({confirmButtonText:okText,html:jsonData.messages})})}function appendDialogInputsToFormAndSubmit(dialogDiv,formName){const inputFields=document.getElementById(dialogDiv).querySelectorAll("input");inputFields.forEach(item=>{item.classList.add("hidden");document.forms[formName].append(item)});document.forms[formName].submit()}async function confirmLoadProfile(title,text,okText,cancelText,e){const button=document.getElementById("btn_accountContainerLoadProfileButton");const lastProfile=button.dataset.lastprofile;const profiles=JSON.parse(button.dataset.profiles);const{value:selectedProfile}=await Swal.fire({confirmButtonText:okText,cancelButtonText:cancelText,showCancelButton:true,title:title,text:text,input:"select",inputValue:lastProfile,inputOptions:profiles});if(selectedProfile){const form=document.forms["inputForm"];let buttonValue=document.createElement("input");buttonValue.type="hidden";buttonValue.name="accountContainerLoadProfile";buttonValue.value="yes";form.appendChild(buttonValue);let selectValue=document.createElement("input");selectValue.type="hidden";selectValue.name="accountContainerSelectLoadProfile";selectValue.value=selectedProfile;form.appendChild(selectValue);form.submit()}if(e.preventDefault){e.preventDefault()}if(e.returnValue){e.returnValue=false}return false}window.lam.profilePdfEditor=window.lam.profilePdfEditor||{};window.lam.profilePdfEditor.showDistributionDialog=function(title,okText,cancelText,typeId,type,selectFieldName){let dialogId="";let formId="";if(type=="export"){document.getElementById("name_"+typeId).value=document.getElementById(selectFieldName).value;dialogId="exportDialog_"+typeId;formId="exportDialogForm_"+typeId}else if(type=="import"){dialogId="importDialog_"+typeId;formId="importDialogForm_"+typeId}const dialogContent=document.getElementById(dialogId).cloneNode(true);dialogContent.classList.remove("hidden");dialogContent.firstElementChild.id=formId+"_dlg";Swal.fire({title:title,confirmButtonText:okText,cancelButtonText:cancelText,showCancelButton:true,html:dialogContent.outerHTML,width:"auto"}).then(result=>{if(result.isConfirmed){document.forms[formId+"_dlg"].submit()}})};window.lam.profilePdfEditor.showPdfLogoExportDialog=function(title,okText,cancelText){var selectedLogo=document.getElementById("logo").value;document.getElementById("exportLogoName").value=selectedLogo;window.lam.dialog.showSimpleDialog(title,okText,cancelText,"logoExportForm","logoExportDiv")};window.lam.profilePdfEditor.showPdfLogoImportDialog=function(title,okText,cancelText){window.lam.dialog.showSimpleDialog(title,okText,cancelText,"logoImportForm","logoImportDiv")};function bindShowNewZoneDialog(title,okText,cancelText){window.lam.dialog.showSimpleDialog(title,okText,cancelText,"newBindZoneDialogForm","newBindZoneDialog")}function checkFieldsHaveSameValues(fieldID,fieldIDReference){const field=document.getElementById(fieldID);const fieldRef=document.getElementById(fieldIDReference);const check=function(){const value=field.value;const valueRef=fieldRef.value;if(value==""&&valueRef==""){field.classList.remove("markFail");field.classList.remove("markOk")}else{if(value==valueRef){field.classList.remove("markFail");field.classList.add("markOk")}else{field.classList.add("markFail");field.classList.remove("markOk")}}};field.addEventListener("keyup",check);fieldRef.addEventListener("keyup",check)}function checkPasswordStrength(fieldID,ajaxURL,tokenName,tokenValue){const field=document.getElementById(fieldID);const check=function(){const value=field.value;const pwdJSON={password:value};let data=new FormData;data.append("jsonInput",JSON.stringify(pwdJSON));data.append(tokenName,tokenValue);fetch(ajaxURL+"&function=passwordStrengthCheck",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();checkPasswordStrengthHandleReply(jsonData,fieldID)})};field.addEventListener("keyup",check)}function checkPasswordStrengthHandleReply(data,fieldID){const field=document.getElementById(fieldID);if(data.result===true){field.classList.remove("markFail");field.classList.add("markOk");field.title=""}else if(field.value==""){field.classList.remove("markFail");field.classList.remove("markOk")}else{field.classList.add("markFail");field.classList.remove("markOk");field.title=data.result}}function updateModulePositions(inputId,containerId){const input=document.getElementById(inputId);let positions=[];const container=document.getElementById(containerId);const childLiElements=container.children;for(let i=0;i<childLiElements.length;i++){positions[i]=childLiElements[i].getAttribute("data-position-orig")}input.value=positions.join(",")}window.lam.filterSelect=window.lam.filterSelect||{};window.lam.filterSelect.activate=function(filterInput,select,event){const inputField=document.getElementById(filterInput);const selectField=document.getElementById(select);if(selectField.classList.contains("lam-dynamicOptions")){window.lam.filterSelect.filterDynamic(inputField,selectField)}else{window.lam.filterSelect.filterStandard(inputField,selectField)}};window.lam.filterSelect.filterStandard=function(inputField,selectField){selectField.classList.add("lam-filteredOptions");if(!selectField.dataset.options){let options={};selectField.querySelectorAll("option").forEach(item=>{options[item.value]={selected:item.selected,text:item.innerText,cssClasses:item.classList}});selectField.dataset.options=JSON.stringify(options)}let storedOptions=JSON.parse(selectField.dataset.options);selectField.querySelectorAll("option").forEach(item=>{storedOptions[item.value].selected=item.selected});selectField.dataset.options=JSON.stringify(storedOptions);selectField.innerHTML="";let search=inputField.value.trim();search=search.replace("*",".*");const regex=new RegExp(search,"gi");let index=0;for(const value in storedOptions){const option=storedOptions[value];if(option.text.match(regex)!==null){const newOption=document.createElement("option");newOption.innerText=option.text;newOption.value=value;if(option.selected){newOption.selected=true;if(selectField.size===1){selectField.selectedIndex=index}}if(option.cssClasses){newOption.classList=option.cssClasses}selectField.appendChild(newOption)}index++}if(selectField.size===1&&selectField.onchange){selectField.onchange()}};window.lam.filterSelect.addFormListener=function(){const forms=Array.from(document.forms);forms.forEach(form=>{form.addEventListener("submit",function(){const selectFields=form.querySelectorAll(".lam-filteredOptions[multiple]");selectFields.forEach(item=>{const storedOptions=JSON.parse(item.dataset.options);item.querySelectorAll("option").forEach(optionItem=>{storedOptions[optionItem.value].selected=optionItem.selected});item.innerHTML="";for(const value in storedOptions){const option=storedOptions[value];if(option.selected){const newOption=document.createElement("option");newOption.innerText=option.text;newOption.value=value;newOption.selected=true;item.appendChild(newOption)}}})})})};window.lam.filterSelect.filterDynamic=function(inputField,selectField){let optionsOrig=selectField.dataset.dynamicOptionsOrig;if(optionsOrig===undefined){selectField.dataset.dynamicOptionsOrig=selectField.dataset.dynamicOptions;optionsOrig=selectField.dataset.dynamicOptionsOrig}optionsOrig=JSON.parse(optionsOrig);const currentOptions=JSON.parse(selectField.dataset.dynamicOptions);const optionTags=Array.from(selectField.children);optionTags.forEach(element=>{const index=currentOptions[parseInt(element.dataset.index)].index;optionsOrig[index].selected=element.selected});selectField.dataset.dynamicOptionsOrig=JSON.stringify(optionsOrig);selectField.innerHTML="";const newOptions=[];let search=inputField.value.trim();search=search.replace("*",".*");const regex=new RegExp(search,"gi");optionsOrig.forEach(function(option,i){if(option.label.match(regex)!==null){newOptions.push(option)}});selectField.dataset.dynamicOptions=JSON.stringify(newOptions);selectField.append(window.lam.dynamicSelect.createOption("#",0));window.lam.dynamicSelect.initSelect(selectField)};window.lam.dynamicSelect=window.lam.dynamicSelect||{};window.lam.dynamicSelect.activate=function(){const dynamicSelects=document.querySelectorAll(".lam-dynamicOptions");dynamicSelects.forEach(item=>{window.lam.dynamicSelect.initSelect(item)});const forms=Array.from(document.forms);forms.forEach(form=>{form.addEventListener("submit",function(){window.lam.dynamicSelect.formListener(form)})})};window.lam.dynamicSelect.formListener=function(form){form.querySelectorAll(".lam-dynamicOptions").forEach(select=>{let dynamicOptions=select.dataset.dynamicOptions;if(select.dataset.dynamicOptionsOrig){dynamicOptions=select.dataset.dynamicOptionsOrig}dynamicOptions=JSON.parse(dynamicOptions);if(select.dataset.dynamicOptionsOrig){const dynamicOptionsOld=JSON.parse(select.dataset.dynamicOptions);for(const dynamicOptionOld of dynamicOptionsOld){dynamicOptions[dynamicOptionOld.index].selected=dynamicOptionOld.selected}}const children=Array.from(select.children);children.forEach(option=>{dynamicOptions[parseInt(option.dataset.index)].selected=option.selected});select.innerHTML="";dynamicOptions.forEach(item=>{if(item.selected){select.appendChild(window.lam.dynamicSelect.createOption(item,item.index))}})})};window.lam.dynamicSelect.initSelect=function(selectField){const optionTag=selectField.querySelector("option");if(optionTag){selectField.dataset.optionHeight=optionTag.clientHeight}else{selectField.dataset.optionHeight=10}selectField.dataset.selectHeight=selectField.clientHeight;selectField.dataset.selectLastScrollTop="0";selectField.dataset.selectCurrentScroll="0";selectField.innerHTML="";const options=JSON.parse(selectField.dataset.dynamicOptions);const maxOptions=3e3;const numOfOptionBeforeToLoadNextSet=10;const numberOfOptionsToLoad=200;for(let i=0;i<maxOptions&&i<options.length;i++){selectField.append(window.lam.dynamicSelect.createOption(options[i],options[i].index))}if(options.length>maxOptions){selectField.onscroll=function(){window.lam.dynamicSelect.onScroll(selectField,maxOptions,numOfOptionBeforeToLoadNextSet,numberOfOptionsToLoad)}}};window.lam.dynamicSelect.createOption=function(data,index){const newOption=document.createElement("option");newOption.setAttribute("value",data.value);newOption.dataset.index=index;newOption.textContent=data.label;if(data.selected){newOption.selected=true}return newOption};window.lam.dynamicSelect.onScroll=function(selectField,maxOptions,numOfOptionBeforeToLoadNextSet,numberOfOptionsToLoad){const scrollTop=selectField.scrollTop;const totalHeight=selectField.querySelectorAll("option").length*selectField.dataset.optionHeight;const lastScrollTop=parseInt(selectField.dataset.selectLastScrollTop);const selectBoxHeight=parseInt(selectField.dataset.selectHeight);const singleOptionHeight=parseInt(selectField.dataset.optionHeight);const currentScroll=scrollTop+selectBoxHeight;selectField.dataset.selectCurrentScrollTop=scrollTop;if(scrollTop>=lastScrollTop&&currentScroll+numOfOptionBeforeToLoadNextSet*singleOptionHeight>=totalHeight){window.lam.dynamicSelect.loadNextOptions(selectField,maxOptions,numberOfOptionsToLoad)}else if(scrollTop<=lastScrollTop&&scrollTop-numOfOptionBeforeToLoadNextSet*singleOptionHeight<=0){window.lam.dynamicSelect.loadPreviousOptions(selectField,maxOptions,numberOfOptionsToLoad)}selectField.dataset.selectLastScrollTop=scrollTop};window.lam.dynamicSelect.loadNextOptions=function(selectField,maxOptions,numberOfOptionsToLoad){if(selectField.children.length===0){return}const selectBoxHeight=parseInt(selectField.dataset.selectHeight);const singleOptionHeight=parseInt(selectField.dataset.optionHeight);const currentScrollPosition=parseInt(selectField.dataset.selectCurrentScrollTop)+selectBoxHeight;const options=JSON.parse(selectField.dataset.dynamicOptions);let lastIndex=parseInt(selectField.children[selectField.children.length-1].dataset.index);for(let i=0;i<options.length;i++){if(options[i].index===lastIndex){lastIndex=i;break}}for(let toAdd=0;toAdd<numberOfOptionsToLoad;toAdd++){const addPos=lastIndex+1+toAdd;if(options[addPos]===undefined){break}selectField.append(window.lam.dynamicSelect.createOption(options[addPos],options[addPos].index))}const numberOfOptions=selectField.children.length;let toRemove=numberOfOptions-maxOptions;if(toRemove>0){for(let i=toRemove;i>=0;i--){const optionToRemove=selectField.children[i];const indexToRemove=parseInt(optionToRemove.dataset.index);for(const option of options){if(option.index===indexToRemove){option.selected=optionToRemove.selected}}optionToRemove.remove()}}else{toRemove=0}selectField.scrollTop=currentScrollPosition-selectBoxHeight-toRemove*singleOptionHeight;selectField.dataset.dynamicOptions=JSON.stringify(options)};window.lam.dynamicSelect.loadPreviousOptions=function(selectField,maxOptions,numberOfOptionsToLoad){if(selectField.children.length===0){return}const singleOptionHeight=parseInt(selectField.dataset.optionHeight);const currentScrollPosition=parseInt(selectField.dataset.selectCurrentScrollTop);const options=JSON.parse(selectField.dataset.dynamicOptions);let lastIndex=parseInt(selectField.children[0].dataset.index);for(let i=0;i<options.length;i++){if(options[i].index===lastIndex){lastIndex=i;break}}let added=0;for(let toAdd=0;toAdd<numberOfOptionsToLoad;toAdd++){const addPos=lastIndex-1-toAdd;if(options[addPos]===undefined){break}added++;selectField.prepend(window.lam.dynamicSelect.createOption(options[addPos],options[addPos].index))}const numberOfOptions=selectField.children.length;const toRemove=numberOfOptions-maxOptions;if(toRemove>0){for(let i=maxOptions;i<selectField.children.length;i++){const optionToRemove=selectField.children[i];const indexToRemove=parseInt(optionToRemove.dataset.index);for(const option of options){if(option.index===indexToRemove){option.selected=optionToRemove.selected}}optionToRemove.remove()}}selectField.scrollTop=currentScrollPosition+added*singleOptionHeight;selectField.dataset.dynamicOptions=JSON.stringify(options)};window.lam.upload=window.lam.upload||{};window.lam.upload.changeVisibleModules=function(selectBox){document.querySelectorAll("div.typeOptions").forEach(item=>{item.classList.add("hidden")});document.getElementById(selectBox.options[selectBox.selectedIndex].value).classList.toggle("hidden")};window.lam.upload.continueUpload=function(url,tokenName,tokenValue){let data=new FormData;data.append(tokenName,tokenValue);fetch(url,{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();if(!jsonData.accountsFinished){window.lam.upload.printBasicStatus(jsonData)}else if(!jsonData.postActionsFinished){window.lam.upload.printPostActionStatus(jsonData)}else if(!jsonData.pdfFinished){window.lam.upload.printPDFStatus(jsonData)}if(!jsonData.allDone){window.lam.upload.continueUpload(url,tokenName,tokenValue)}else{window.lam.upload.uploadDone(jsonData)}})};window.lam.upload.printBasicStatus=function(jsonData){let htmlOut='<div class="title">';htmlOut+='<h2 class="titleText">'+jsonData.title+"</h2>";htmlOut+="</div>";htmlOut+=window.lam.progressbar.getMarkup("progressbarGeneral");document.getElementById("uploadContent").innerHTML=htmlOut;window.lam.progressbar.setProgress("progressbarGeneral",jsonData.accountsProgress)};window.lam.upload.printPostActionStatus=function(jsonData){let htmlOut='<div class="title">';htmlOut+='<h2 class="titleText">'+jsonData.title+"</h2>";htmlOut+="</div>";htmlOut+=window.lam.progressbar.getMarkup("progressbarGeneral");if(jsonData.postActionsTitle){htmlOut+="<h2>"+jsonData.postActionsTitle+"</h2>";htmlOut+=window.lam.progressbar.getMarkup("progressbarPostActions")}document.getElementById("uploadContent").innerHTML=htmlOut;window.lam.progressbar.setProgress("progressbarGeneral",100);if(jsonData.postActionsTitle){window.lam.progressbar.setProgress("progressbarPostActions",jsonData.postActionsProgress)}};window.lam.upload.printPDFStatus=function(jsonData){let htmlOut='<div class="title">';htmlOut+='<h2 class="titleText">'+jsonData.title+"</h2>";htmlOut+="</div>";htmlOut+=window.lam.progressbar.getMarkup("progressbarGeneral");htmlOut+="<h2>"+jsonData.titlePDF+"</h2>";htmlOut+=window.lam.progressbar.getMarkup("progressbarPDF");document.getElementById("uploadContent").innerHTML=htmlOut;window.lam.progressbar.setProgress("progressbarGeneral",100);window.lam.progressbar.setProgress("progressbarPDF",jsonData.pdfProgress)};window.lam.upload.uploadDone=function(jsonData){if(jsonData.errorHtml){let htmlOut='<div class="subTitle">';htmlOut+='<h4  class="subTitleText">'+jsonData.titleErrors+"</h4>";htmlOut+="</div>";htmlOut+=jsonData.errorHtml;document.getElementById("uploadContent").innerHTML=htmlOut}else{top.location.href="../lists/list.php?type="+jsonData.typeId+"&uploadAllOk"}};window.lam.form=window.lam.form||{};window.lam.form.autoTrim=function(){for(let singleForm of document.forms){singleForm.addEventListener("submit",function(){const autoTrimFields=singleForm.querySelectorAll(".lam-autotrim");autoTrimFields.forEach(item=>{item.value=String(item.value).trim()})})}};window.lam.dialog=window.lam.dialog||{};window.lam.dialog.showInfo=function(text,okText){Swal.fire({text:text,confirmButtonText:okText,width:"auto"})};window.lam.dialog.showError=function(title,text,okText){Swal.fire({icon:"error",title:title,text:text,confirmButtonText:okText,width:"auto"})};window.lam.dialog.showMessage=function(title,okText,divId,callbackFunction){const dialogContent=document.getElementById(divId).cloneNode(true);dialogContent.classList.remove("hidden");Swal.fire({title:title,confirmButtonText:okText,html:dialogContent.outerHTML,width:"auto"}).then(result=>{if(callbackFunction){callbackFunction()}})};window.lam.dialog.showConfirmation=async function(title,okText,cancelText,divId,callbackFunction,preConfirmFunction,postDisplayFunction){const div=document.getElementById(divId);const dialogContent=div.cloneNode(true);const divContent=div.innerHTML;div.innerHTML="";dialogContent.classList.remove("hidden");let options={title:title,confirmButtonText:okText,cancelButtonText:cancelText,showCancelButton:true,html:dialogContent.outerHTML,width:"auto"};if(preConfirmFunction){options.preConfirm=preConfirmFunction}if(postDisplayFunction){options.didOpen=postDisplayFunction}const{value:formValues}=await Swal.fire(options);if(callbackFunction&&formValues){callbackFunction(formValues)}div.innerHTML=divContent};window.lam.dialog.showSimpleDialog=function(title,okText,cancelText,formID,dialogDivID){const dialogContent=document.getElementById(dialogDivID).cloneNode(true);dialogContent.classList.remove("hidden");dialogContent.firstElementChild.id=formID+"_dlg";Swal.fire({title:title,confirmButtonText:okText,cancelButtonText:cancelText,showCancelButton:true,showConfirmButton:okText!==null,html:dialogContent.outerHTML,width:"auto"}).then(result=>{if(result.isConfirmed){document.forms[formID+"_dlg"].submit()}})};window.lam.dialog.confirmAndSendForm=function(title,okText,cancelText,message,formId){Swal.fire({title:title,confirmButtonText:okText,cancelButtonText:cancelText,showCancelButton:true,text:message,width:"auto"}).then(result=>{if(result.isConfirmed){document.forms[formId].submit()}})};window.lam.dialog.requestPasswordAndSendForm=async function(title,okText,cancelText,passwordLabel,passwordInputName,formId){const{value}=await Swal.fire({title:title,confirmButtonText:okText,cancelButtonText:cancelText,showCancelButton:true,input:"password",inputLabel:passwordLabel,width:"auto"});if(value){let passwordTag=document.createElement("input");passwordTag.name=passwordInputName;passwordTag.value=value;passwordTag.hidden="hidden";document.forms[formId].appendChild(passwordTag);document.forms[formId].submit()}};window.lam.dialog.showModal=function(selector){let modal=document.querySelector(selector);modal.classList.add("show-modal");window.addEventListener("click",function(event){if(event.target===modal){modal.classList.remove("show-modal")}});let myElement=modal.querySelector("input");if(!myElement){myElement=modal.querySelector("select")}if(myElement){myElement.focus()}};window.lam.dialog.showSuccessMessageAndRedirect=function(title,message,buttonText,redirectUrl){Swal.fire({icon:"success",title:title,confirmButtonText:buttonText,text:message,width:"auto",timer:3e3,timerProgressBar:true}).then(result=>{window.location=redirectUrl})};window.lam.dialog.showErrorMessageAndRedirect=function(title,message,buttonText,redirectUrl){Swal.fire({icon:"error",title:title,confirmButtonText:buttonText,text:message,width:"auto"}).then(result=>{window.location=redirectUrl})};window.lam.account=window.lam.account||{};window.lam.account.addDefaultProfileListener=function(){const defaultProfileLink=document.getElementById("lam-make-default-profile");if(defaultProfileLink){defaultProfileLink.addEventListener("click",function(){const typeId=this.dataset.typeid;const name=this.dataset.name;const okText=this.dataset.ok;let date=new Date;date.setTime(date.getTime()+365*24*60*60*1e3);document.cookie="defaultProfile_"+typeId+"="+name+"; expires="+date.toUTCString();window.lam.dialog.showMessage(null,okText,"lam-make-default-profile-dlg")})}};window.lam.tools=window.lam.tools||{};window.lam.tools.addSavedSelectListener=function(){if(!window.localStorage){return}const selects=document.querySelectorAll("select.lam-save-selection");selects.forEach(item=>{const name=item.name;const storageKey="lam_selectionStore_"+name;const storageValue=window.localStorage.getItem(storageKey);if(storageValue){const option=item.querySelector('option[value="'+storageValue+'"]');if(option){item.value=storageValue}}item.addEventListener("change",function(){const selectedValue=item.value;window.localStorage.setItem(storageKey,selectedValue)})});const checkboxes=document.querySelectorAll("input.lam-save-selection");checkboxes.forEach(item=>{const name=item.name;const storageKey="lam_selectionStore_"+name;const storageValue=window.localStorage.getItem(storageKey);if(storageValue){item.checked=storageValue==="true"}item.addEventListener("change",function(){const selectedValue=item.checked;window.localStorage.setItem(storageKey,selectedValue)})})};window.lam.tools.setInitialFocus=function(){const elementToFocus=document.querySelector(".lam-initial-focus");if(elementToFocus){elementToFocus.focus()}};window.lam.tools.webcam=window.lam.tools.webcam||{};window.lam.tools.webcam.init=function(){const contentDiv=document.getElementById("lam_webcam_div");if(contentDiv&&navigator.mediaDevices&&navigator.mediaDevices.enumerateDevices){navigator.mediaDevices.enumerateDevices().then(function(mediaDevices){for(let i=0;i<mediaDevices.length;i++){const mediaDevice=mediaDevices[i];if(mediaDevice.kind==="videoinput"){contentDiv.classList.remove("hidden")}}})}};window.lam.tools.webcam.capture=function(event){event.preventDefault();const video=document.getElementById("lam-webcam-video");const msg=document.querySelector(".lam-webcam-message");msg.classList.add("hidden");navigator.mediaDevices.getUserMedia({video:{facingMode:"user",width:{min:1024,ideal:1280,max:1920},height:{min:576,ideal:720,max:1080}},audio:false}).then(function(stream){video.srcObject=stream;video.play();window.lam.tools.webcamStream=stream;document.getElementById("btn_lam-webcam-capture").classList.add("hidden");document.querySelector(".btn-lam-webcam-upload").classList.remove("hidden");document.getElementById("lam-webcam-video").classList.remove("hidden")}).catch(function(err){msg.querySelector(".statusTitle").textContent=err.message;msg.classList.remove("hidden")});return false};window.lam.tools.webcam.upload=function(){const form=document.getElementById("lam-webcam-canvas").closest("form");const canvasData=window.lam.tools.webcam.prepareData();const canvasDataInput=document.createElement("input");canvasDataInput.setAttribute("name","webcamData");canvasDataInput.setAttribute("id","webcamData");canvasDataInput.setAttribute("type","hidden");canvasDataInput.setAttribute("value",canvasData);form.append(canvasDataInput);form.submit();return true};window.lam.tools.webcam.uploadSelfService=function(event,tokenName,tokenValue,moduleName,scope,uploadErrorMessage,contentId){event.preventDefault();const msg=document.querySelector(".lam-webcam-message");const canvasData=window.lam.tools.webcam.prepareData();let data=new FormData;data.append("webcamData",canvasData);data.append(tokenName,tokenValue);const ajaxURL="../misc/ajax.php?selfservice=1&action=ajaxPhotoUpload"+"&module="+moduleName+"&scope="+scope;fetch(ajaxURL,{method:"POST",body:data}).then(async response=>{if(response.ok===false){msg.querySelector(".statusTitle").innerText=uploadErrorMessage;msg.classList.remove("hidden");return}const jsonData=await response.json();if(jsonData.success){if(jsonData.html){document.getElementById(contentId).innerHTML=jsonData.html;window.lam.tools.webcam.init();window.lam.html.initCropping()}}else if(jsonData.error){msg.querySelector(".statusTitle").innerText=jsonData.error;msg.classList.remove("hidden")}});document.getElementById("btn_lam-webcam-capture").classList.remove("hidden");document.getElementById("btn-lam-webcam-upload").classList.add("hidden");return false};window.lam.tools.webcam.prepareData=function(){const canvas=document.getElementById("lam-webcam-canvas");const video=document.getElementById("lam-webcam-video");canvas.setAttribute("width",video.videoWidth);canvas.setAttribute("height",video.videoHeight);const context=canvas.getContext("2d");context.drawImage(video,0,0,video.videoWidth,video.videoHeight);const canvasData=canvas.toDataURL("image/png");video.pause();const tracks=window.lam.tools.webcamStream.getTracks();for(let i=0;i<tracks.length;i++){tracks[i].stop()}canvas.classList.add("hidden");video.classList.add("hidden");return canvasData};window.lam.tools.schema=window.lam.tools.schema||{};window.lam.tools.schema.select=function(){const select=document.getElementById("lam-schema-select");if(!select){return}const display=select.dataset.display;select.addEventListener("change",function(){const value=select.value;document.location="schema.php?display="+display+"&sel="+value})};window.lam.importexport=window.lam.importexport||{};window.lam.importexport.startImport=function(tokenName,tokenValue){if(document.readyState==="loading"){document.addEventListener("DOMContentLoaded",function(){window.lam.importexport.startImport(tokenName,tokenValue)});return}const output=document.getElementById("importResults");let data=new FormData;data.append(tokenName,tokenValue);const ajaxURL="../misc/ajax.php?function=import";fetch(ajaxURL,{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();if(jsonData.data&&jsonData.data!==""){output.innerHTML+=jsonData.data}if(jsonData.status=="done"){document.getElementById("progressbarImport").classList.add("hidden");document.getElementById("btn_submitImportCancel").classList.add("hidden");document.getElementById("statusImportInprogress").classList.add("hidden");document.getElementById("statusImportDone").classList.remove("hidden");document.querySelector(".newimport").classList.remove("hidden")}else if(jsonData.status=="failed"){document.getElementById("btn_submitImportCancel").classList.add("hidden");document.getElementById("statusImportInprogress").classList.add("hidden");document.getElementById("statusImportFailed").classList.remove("hidden");document.querySelector(".newimport").classList.remove("hidden")}else{window.lam.progressbar.setProgress("progressbarImport",jsonData.progress);window.lam.importexport.startImport(tokenName,tokenValue)}})};window.lam.importexport.startExport=function(tokenName,tokenValue){if(document.readyState==="loading"){document.addEventListener("DOMContentLoaded",function(){window.lam.importexport.startExport(tokenName,tokenValue)});return}window.lam.progressbar.setProgress("progressbarExport",50);const output=document.getElementById("exportResults");let data=new FormData;data.append(tokenName,tokenValue);data.append("baseDn",document.getElementById("baseDn").value);data.append("searchScope",document.getElementById("searchScope").value);data.append("filter",document.getElementById("filter").value);data.append("attributes",document.getElementById("attributes").value);data.append("format",document.getElementById("format").value);data.append("ending",document.getElementById("ending").value);data.append("includeSystem",document.getElementById("includeSystem").value);data.append("saveAsFile",document.getElementById("saveAsFile").value);fetch("../misc/ajax.php?function=export",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();if(jsonData.data&&jsonData.data!=""){output.append(jsonData.data)}if(jsonData.status=="done"){document.getElementById("progressbarExport").classList.add("hidden");document.getElementById("btn_submitExportCancel").classList.add("hidden");document.getElementById("statusExportInprogress").classList.add("hidden");document.getElementById("statusExportDone").classList.remove("hidden");document.querySelector(".newexport").classList.remove("hidden");if(jsonData.output){document.getElementById("exportResults").querySelector("pre").innerText=jsonData.output}else if(jsonData.file){window.open(jsonData.file,"_blank")}}else{document.getElementById("progressbarExport").classList.add("hidden");document.getElementById("btn_submitExportCancel").classList.add("hidden");document.getElementById("statusExportDone").classList.add("hidden");document.getElementById("statusExportInprogress").classList.add("hidden");document.getElementById("statusExportFailed").classList.remove("hidden");document.querySelector(".newexport").classList.remove("hidden")}}).catch(error=>{document.getElementById("progressbarExport").classList.add("hidden");document.getElementById("btn_submitExportCancel").classList.add("hidden");document.getElementById("statusExportDone").classList.add("hidden");document.getElementById("statusExportInprogress").classList.add("hidden");document.getElementById("statusExportFailed").classList.remove("hidden");document.querySelector(".newexport").classList.remove("hidden")})};window.lam.multiedit=window.lam.multiedit||{};window.lam.multiedit.runActions=function(){document.querySelectorAll("input, select, button").forEach(function(item){item.disabled=true});fetch("multiEdit.php?ajaxStatus",{method:"GET"}).then(async response=>{const jsonData=await response.json();window.lam.multiedit.runActionsHandleReply(jsonData)})};window.lam.multiedit.runActionsHandleReply=function(data){window.lam.progressbar.setProgress("progressBar",data.progress);document.getElementById("progressArea").innerHTML=data.content;if(data.status!="finished"){fetch("multiEdit.php?ajaxStatus",{method:"GET"}).then(async response=>{const jsonData=await response.json();window.lam.multiedit.runActionsHandleReply(jsonData)})}else{document.querySelectorAll("input, select, button").forEach(function(item){item.disabled=false});document.getElementById("progressBar").classList.add("hidden")}};window.lam.html=window.lam.html||{};window.lam.html.showDnSelection=function(fieldId,title,okText,cancelText,tokenName,tokenValue){const field=document.getElementById(fieldId);const dnValue=field.value;let data=new FormData;data.append(tokenName,tokenValue);data.append("fieldId",fieldId);data.append("dn",dnValue);fetch("../misc/ajax.php?function=dnselection",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();const dlgHtml='<div id="dlg_'+fieldId+'">'+jsonData.dialogData+"</div>";Swal.fire({title:title,cancelButtonText:cancelText,showCancelButton:true,showConfirmButton:false,html:dlgHtml,width:"auto"})})};window.lam.html.selectDn=function(el,fieldId){const field=document.getElementById(fieldId);let parent=el.parentElement;while(!parent.classList.contains("row")){parent=parent.parentElement}const dn=parent.dataset.dn;field.value=dn;Swal.close();return false};window.lam.html.updateDnSelection=function(el,fieldId,tokenName,tokenValue){let parent=el.parentElement;while(!parent.classList.contains("row")){parent=parent.parentElement}const dn=parent.dataset.dn;let data=new FormData;data.append(tokenName,tokenValue);data.append("fieldId",fieldId);data.append("dn",dn);fetch("../misc/ajax.php?function=dnselection",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();document.getElementById("dlg_"+fieldId).innerHTML=jsonData.dialogData}).catch(error=>{Swal.close()})};window.lam.html.activateLightboxes=function(){document.querySelectorAll(".lam-lightbox").forEach(item=>{item.onclick=function(){Swal.fire({imageUrl:item.src,confirmButtonText:item.dataset.lightboxLabelClose,width:"auto"})}})};window.lam.html.preventEnter=function(){document.querySelectorAll(".lam-prevent-enter").forEach(item=>{item.addEventListener("keypress",function(event){if(event.key==="Enter"){event.preventDefault()}})})};window.lam.html.initCropping=function(){const image=document.querySelector(".cropperjsImage");new Cropper(image,{viewMode:1,movable:false,zoomable:false,crop:function(event){document.getElementById("croppingDataX").value=event.detail.x;document.getElementById("croppingDataY").value=event.detail.y;document.getElementById("croppingDataWidth").value=event.detail.width;document.getElementById("croppingDataHeight").value=event.detail.height}})};window.lam.html.updateAccordionSorting=function(accordionId){const positionsField=document.getElementById(accordionId+"_sorting");let positions=[];document.getElementById(accordionId).querySelectorAll(".lam-accordion-button").forEach(function(item){const index=item.dataset.index;positions.push(index)});positionsField.value=positions.join(",")};window.lam.selfservice=window.lam.selfservice||{};window.lam.selfservice.delMultiValue=function(fieldNamePrefix,delButton){const fields=document.querySelectorAll("input[name^='"+fieldNamePrefix+"'], textarea[name^='"+fieldNamePrefix+"']");const isOnlyOneField=fields.length===1;if(!isOnlyOneField){const addButton=delButton.nextElementSibling;if(addButton){const lastLastDelLink=fields[fields.length-2].parentElement.parentElement.querySelector(".del-link");const lastLastDelLinkParent=lastLastDelLink.parentElement;lastLastDelLinkParent.append(addButton)}let parent=delButton.parentElement;while(!parent.classList.contains("row")){parent=parent.parentElement}const row=parent.parentElement;row.remove()}else{fields[0].value=""}};window.lam.selfservice.addMultiValue=function(fieldNamePrefix,addButton){const fields=document.querySelectorAll("input[name^='"+fieldNamePrefix+"'], textarea[name^='"+fieldNamePrefix+"']");const lastFieldName=fields[fields.length-1].name;const lastFieldNameIndex=lastFieldName.substring(fieldNamePrefix.length);const newFieldNameIndex=parseInt(lastFieldNameIndex)+1;let parent=addButton.parentElement;while(!parent.classList.contains("row")){parent=parent.parentElement}const row=parent.parentElement;const clone=row.cloneNode(true);row.parentElement.append(clone);const cloneInput=clone.querySelector("input[name^='"+fieldNamePrefix+"'], textarea[name^='"+fieldNamePrefix+"']");cloneInput.name=fieldNamePrefix+newFieldNameIndex;cloneInput.id=fieldNamePrefix+newFieldNameIndex;cloneInput.value="";addButton.remove()};window.lam.webauthn=window.lam.webauthn||{};window.lam.webauthn.charAt=function(c){return c.charCodeAt(0)};window.lam.webauthn.start=function(prefix,isSelfService,newDeviceNameTitle,newDeviceNameLabel,okText,cancelText){document.addEventListener("DOMContentLoaded",function(){window.lam.webauthn.run(prefix,isSelfService,newDeviceNameTitle,newDeviceNameLabel,okText,cancelText)})};window.lam.webauthn.run=function(prefix,isSelfService,newDeviceNameTitle,newDeviceNameLabel,okText,cancelText){const skipButton=document.getElementById("btn_skip_webauthn");if(skipButton){skipButton.onclick=function(){const form=document.getElementById("2faform");const hiddenSkip=document.createElement("input");hiddenSkip.type="hidden";hiddenSkip.name="sig_response";hiddenSkip.value="skip";form.appendChild(hiddenSkip);form.submit();return}}const token=document.getElementById("sec_token").value;if(!navigator.credentials||typeof PublicKeyCredential==="undefined"){document.querySelector(".webauthn-error").classList.remove("hidden");return}let data=new FormData;data.append("sec_token",token);data.append("action","status");var extraParam=isSelfService?"&selfservice=true":"";fetch(prefix+"misc/ajax.php?function=webauthn"+extraParam,{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();if(jsonData.action==="register"){const registerFunction=function(){const successCallback=async function(publicKeyCredential){const{value:newName}=await Swal.fire({title:newDeviceNameTitle,confirmButtonText:okText,cancelButtonText:cancelText,showCancelButton:true,input:"text",inputLabel:newDeviceNameLabel,width:"auto"});const form=document.getElementById("2faform");if(newName){const newNameElement=document.createElement("input");newNameElement.type="hidden";newNameElement.name="newName";newNameElement.value=newName;form.appendChild(newNameElement)}const response=btoa(JSON.stringify(publicKeyCredential));const hiddenResponse=document.createElement("input");hiddenResponse.type="hidden";hiddenResponse.name="sig_response";hiddenResponse.value=response;form.appendChild(hiddenResponse);form.submit()};const errorCallback=function(error){const errorDiv=document.getElementById("generic-webauthn-error");const buttonLabel=errorDiv.dataset.button;const dialogTitle=errorDiv.dataset.title;errorDiv.innerText=error.message;window.lam.dialog.showMessage(dialogTitle,buttonLabel,"generic-webauthn-error",function(){document.getElementById("btn_logout").click()})};window.lam.webauthn.register(jsonData.registration,successCallback,errorCallback);return false};let registerButton=document.getElementById("btn_register_webauthn");if(!registerButton){registerFunction()}else{registerButton.onclick=registerFunction}}else if(jsonData.action==="authenticate"){window.lam.webauthn.authenticate(jsonData.authentication)}}).catch(function(err){console.log("WebAuthn failed")})};window.lam.webauthn.register=function(publicKey,successCallback,errorCallback){if(!(publicKey.challenge instanceof Uint8Array)){publicKey.challenge=Uint8Array.from(window.atob(publicKey.challenge),window.lam.webauthn.charAt);publicKey.user.id=Uint8Array.from(window.atob(publicKey.user.id),window.lam.webauthn.charAt);publicKey.rp.icon=window.location.href.substring(0,window.location.href.lastIndexOf("/"))+publicKey.rp.icon;if(publicKey.excludeCredentials){for(var i=0;i<publicKey.excludeCredentials.length;i++){var idOrig=publicKey.excludeCredentials[i]["id"];idOrig=idOrig.replace(/-/g,"+").replace(/_/g,"/");var idOrigDecoded=atob(idOrig);var idArray=Uint8Array.from(idOrigDecoded,window.lam.webauthn.charAt);publicKey.excludeCredentials[i]["id"]=idArray}}}navigator.credentials.create({publicKey:publicKey}).then(function(data){var publicKeyCredential={id:data.id,type:data.type,rawId:window.lam.webauthn.arrayToBase64String(new Uint8Array(data.rawId)),response:{clientDataJSON:window.lam.webauthn.arrayToBase64String(new Uint8Array(data.response.clientDataJSON)),attestationObject:window.lam.webauthn.arrayToBase64String(new Uint8Array(data.response.attestationObject))}};successCallback(publicKeyCredential)},function(error){console.log(error.message);errorCallback(error)})};window.lam.webauthn.authenticate=function(publicKey){publicKey.challenge=Uint8Array.from(window.atob(publicKey.challenge),window.lam.webauthn.charAt);for(var i=0;i<publicKey.allowCredentials.length;i++){let idOrig=publicKey.allowCredentials[i]["id"];idOrig=idOrig.replace(/-/g,"+").replace(/_/g,"/");const idOrigDecoded=atob(idOrig);const idArray=Uint8Array.from(idOrigDecoded,window.lam.webauthn.charAt);publicKey.allowCredentials[i]["id"]=idArray}navigator.credentials.get({publicKey:publicKey}).then(function(data){const publicKeyCredential={id:data.id,type:data.type,rawId:window.lam.webauthn.arrayToBase64String(new Uint8Array(data.rawId)),response:{authenticatorData:window.lam.webauthn.arrayToBase64String(new Uint8Array(data.response.authenticatorData)),clientDataJSON:window.lam.webauthn.arrayToBase64String(new Uint8Array(data.response.clientDataJSON)),signature:window.lam.webauthn.arrayToBase64String(new Uint8Array(data.response.signature)),userHandle:data.response.userHandle?window.lam.webauthn.arrayToBase64String(new Uint8Array(data.response.userHandle)):null}};const form=document.getElementById("2faform");const response=btoa(JSON.stringify(publicKeyCredential));const hiddenResponse=document.createElement("input");hiddenResponse.type="hidden";hiddenResponse.name="sig_response";hiddenResponse.value=response;form.appendChild(hiddenResponse);form.submit()},function(error){console.log(error.message);const errorDiv=document.getElementById("generic-webauthn-error");const buttonLabel=errorDiv.dataset.button;const dialogTitle=errorDiv.dataset.title;errorDiv.innerText=error.message;window.lam.dialog.showMessage(dialogTitle,buttonLabel,"generic-webauthn-error",function(){document.getElementById("btn_logout").click()})})};window.lam.webauthn.arrayToBase64String=function(input){return btoa(String.fromCharCode.apply(null,input)).replaceAll("=","")};window.lam.webauthn.setupDeviceManagement=function(){const searchButton=document.getElementById("btn_webauthn_search");if(searchButton){searchButton.onclick=window.lam.webauthn.searchDevices}const searchInput=document.getElementById("webauthn_searchTerm");if(searchInput){searchInput.onkeydown=function(event){if(event.key==="Enter"){event.preventDefault();searchButton.click();return false}}}};window.lam.webauthn.searchDevices=function(event){if(event!==null){event.preventDefault()}const resultDiv=document.getElementById("webauthn_results");const tokenValue=resultDiv.dataset.sec_token_value;const searchData=document.getElementById("webauthn_searchTerm").value;let data=new FormData;data.append("sec_token",tokenValue);data.append("action","search");data.append("searchTerm",searchData);fetch("../misc/ajax.php?function=webauthnDevices",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();resultDiv.innerHTML=jsonData.content;window.lam.webauthn.addDeviceActionListeners()}).catch(function(error){console.log("WebAuthn search failed: "+error.message)});return false};window.lam.webauthn.addDeviceActionListeners=function(){const inputs=document.querySelectorAll(".webauthn-delete");inputs.forEach(item=>{item.onclick=function(event){window.lam.webauthn.removeDevice(event);return false}})};window.lam.webauthn.removeDevice=function(event){event.preventDefault();const element=event.target;window.lam.webauthn.removeDeviceDialog(element,"webauthnDevices")};window.lam.webauthn.removeOwnDevice=function(event,isSelfService){event.preventDefault();const element=event.currentTarget;let successCallback=null;if(!isSelfService){successCallback=function(){const form=document.getElementById("webauthnform");const hiddenRemoved=document.createElement("input");hiddenRemoved.type="hidden";hiddenRemoved.name="removed";hiddenRemoved.value="true";form.appendChild(hiddenRemoved);form.submit()}}let action="webauthnOwnDevices";if(isSelfService){action=action+"&selfservice=true&module=webauthn&scope=user"}window.lam.webauthn.removeDeviceDialog(element,action,successCallback,isSelfService);return false};window.lam.webauthn.removeDeviceDialog=function(element,action,successCallback,isSelfService){const dialogTitle=element.dataset.dialogtitle;const okText=element.dataset.oktext;const cancelText=element.dataset.canceltext;const dialogContent=document.getElementById("webauthnDeleteConfirm").cloneNode(true);dialogContent.classList.remove("hidden");Swal.fire({title:dialogTitle,confirmButtonText:okText,cancelButtonText:cancelText,showCancelButton:true,html:dialogContent.outerHTML,width:"auto"}).then(result=>{if(result.isConfirmed){window.lam.webauthn.sendRemoveDeviceRequest(element,action,successCallback,isSelfService)}})};window.lam.webauthn.sendRemoveDeviceRequest=function(element,action,successCallback,isSelfService){const dn=element.dataset.dn;const credential=element.dataset.credential;const resultDiv=document.getElementById("webauthn_results");const tokenValue=resultDiv.dataset.sec_token_value;let data=new FormData;data.append("sec_token",tokenValue);data.append("action","delete");data.append("dn",dn);data.append("credentialId",credential);if(isSelfService){document.querySelectorAll(".webauthn_device_name").forEach(item=>{data.append(item.name,item.value)})}fetch("../misc/ajax.php?function="+action,{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();if(successCallback){successCallback()}else{resultDiv.innerHTML=jsonData.content}}).catch(function(err){console.log("WebAuthn device deletion failed: "+err.message)})};window.lam.webauthn.updateOwnDeviceName=function(event){event.preventDefault();const element=event.currentTarget;const dn=element.dataset.dn;const nameElementId=element.dataset.nameelement;const nameElement=document.getElementById(nameElementId);const name=nameElement.value;const credential=element.dataset.credential;const resultDiv=document.getElementById("webauthn_results");const tokenValue=resultDiv.dataset.sec_token_value;let data=new FormData;data.append("sec_token",tokenValue);data.append("action","setName");data.append("dn",dn);data.append("name",name);data.append("credentialId",credential);let action="webauthnOwnDevices";fetch("../misc/ajax.php?function="+action,{method:"POST",body:data}).then(async response=>{window.location.href="webauthn.php?updated="+encodeURIComponent(credential)}).catch(function(err){console.log("WebAuthn device name change failed: "+err.message)});return false};window.lam.webauthn.registerOwnDevice=function(event,isSelfService){event.preventDefault();const element=event.target;const dn=element.dataset.dn;const tokenValue=element.dataset.sec_token_value;const publicKey=JSON.parse(element.dataset.publickey);let successCallback=function(publicKeyCredential){const form=document.getElementById("webauthnform");const response=btoa(JSON.stringify(publicKeyCredential));const registrationData=document.getElementById("registrationData");registrationData.value=response;form.submit()};if(isSelfService){successCallback=function(publicKeyCredential){let data=new FormData;data.append("sec_token",tokenValue);data.append("action","register");data.append("dn",dn);data.append("credential",btoa(JSON.stringify(publicKeyCredential)));document.querySelectorAll(".webauthn_device_name").forEach(item=>{data.append(item.name,item.value)});fetch("../misc/ajax.php?selfservice=true&module=webauthn&scope=user",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();const resultDiv=document.getElementById("webauthn_results");resultDiv.innerHTML=jsonData.content}).catch(error=>{console.log("WebAuthn device registration failed: "+error.message)})}}const errorCallback=function(error){const errorDiv=document.getElementById("generic-webauthn-error");const buttonLabel=errorDiv.dataset.button;const dialogTitle=errorDiv.dataset.title;errorDiv.innerText=error.message;window.lam.dialog.showMessage(dialogTitle,buttonLabel,"generic-webauthn-error")};window.lam.webauthn.register(publicKey,successCallback,errorCallback);return false};window.lam.treeview=window.lam.treeview||{};window.lam.treeview.createNode=function(tokenName,tokenValue,dn){let data=new FormData;data.append(tokenName,tokenValue);data.append("dn",dn);fetch("../misc/ajax.php?function=treeview&command=createNewNode&step=getObjectClasses",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();window.lam.treeview.checkSession(jsonData);document.getElementById("ldap_actionarea").innerHTML=jsonData.content})};window.lam.treeview.createNodeSelectObjectClassesStep=function(event,tokenName,tokenValue){event.preventDefault();let data=new FormData;data.append(tokenName,tokenValue);data.append("dn",document.getElementById("parentDn").value);const selectedOptions=document.getElementById("objectClasses").selectedOptions;let objectClasses=[];for(const selectedOption of selectedOptions){objectClasses.push(selectedOption.value)}data.append("objectClasses",objectClasses.join(","));fetch("../misc/ajax.php?function=treeview&command=createNewNode&step=checkObjectClasses",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();window.lam.treeview.checkSession(jsonData);document.getElementById("ldap_actionarea").innerHTML=jsonData.content;window.lam.treeview.addFileInputListeners()})};window.lam.treeview.createNodeEnterAttributesStep=function(event,tokenName,tokenValue){event.preventDefault();let data=new FormData;data.append(tokenName,tokenValue);const parentDn=document.getElementById("parentDn").value;data.append("dn",parentDn);data.append("rdn",document.getElementById("rdn").value);data.append("objectClasses",document.getElementById("objectClasses").value);document.querySelectorAll(".single-input").forEach(item=>{item.dataset.valueOrig=""});document.querySelectorAll(".multi-input").forEach(item=>{item.dataset.valueOrig=""});const attributeChanges=window.lam.treeview.findAttributeChanges();data.append("attributes",JSON.stringify(attributeChanges));fetch("../misc/ajax.php?function=treeview&command=createNewNode&step=checkAttributes",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();window.lam.treeview.checkSession(jsonData);document.getElementById("ldap_actionarea").innerHTML=jsonData.content;const tree=mar10.Wunderbaum.getTree("#ldap_tree");const node=tree.findKey(parentDn);if(node){await node.setExpanded(true);node.lazy=true;node.loadLazy(true)}window.scrollTo(0,0)})};window.lam.treeview.deleteNode=function(tokenName,tokenValue,dn,text,okText,cancelText,title,errorOkText,errorTitle){const textSpan=document.querySelector(".treeview-delete-entry");textSpan.innerText=window.atob(text);const dialogContent=document.getElementById("treeview_delete_dlg").cloneNode(true);dialogContent.classList.remove("hidden");Swal.fire({title:title,confirmButtonText:okText,cancelButtonText:cancelText,showCancelButton:true,html:dialogContent.outerHTML,width:"48em"}).then(result=>{if(result.isConfirmed){let data=new FormData;data.append(tokenName,tokenValue);data.append("dn",dn);fetch("../misc/ajax.php?function=treeview&command=deleteNode",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();window.lam.treeview.checkSession(jsonData);const tree=mar10.Wunderbaum.getTree("#ldap_tree");const parentNode=tree.findKey(dn).parent;await parentNode.setActive();parentNode.loadLazy(true);window.lam.treeview.getNodeContent(tokenName,tokenValue,parentNode.key);if(jsonData["errors"]){const errTextTitle=jsonData["errors"][0][1];const textSpanErrorTitle=document.querySelector(".treeview-error-title");textSpanErrorTitle.innerText=errTextTitle;const errText=jsonData["errors"][0][2];const textSpanErrorText=document.querySelector(".treeview-error-text");textSpanErrorText.innerText=errText;window.lam.dialog.showSimpleDialog(errorTitle,null,errorOkText,null,"treeview_error_dlg")}})}})};window.lam.treeview.restoreNode=function(tokenName,tokenValue,dn,text,okText,cancelText,title,errorOkText,errorTitle){const textSpan=document.querySelector(".treeview-restore-entry");textSpan.innerText=window.atob(text);const dialogContent=document.getElementById("treeview_restore_dlg").cloneNode(true);dialogContent.classList.remove("hidden");const targetDn=document.getElementById("treeview-restore-dn").value;Swal.fire({title:title,confirmButtonText:okText,cancelButtonText:cancelText,showCancelButton:true,html:dialogContent.outerHTML,width:"48em"}).then(result=>{if(result.isConfirmed){let data=new FormData;data.append(tokenName,tokenValue);data.append("dn",dn);data.append("targetDn",targetDn);fetch("../misc/ajax.php?function=treeview&command=restoreNode",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();window.lam.treeview.checkSession(jsonData);const tree=mar10.Wunderbaum.getTree("#ldap_tree");const parentNode=tree.findKey(dn).parent;await parentNode.setActive();parentNode.loadLazy(true);window.lam.treeview.getNodeContent(tokenName,tokenValue,parentNode.key);if(jsonData["errorTitle"]){const errTextTitle=jsonData["errorTitle"];const textSpanErrorTitle=document.querySelector(".treeview-error-title");textSpanErrorTitle.innerText=errTextTitle;const errText=jsonData["errorText"];const textSpanErrorText=document.querySelector(".treeview-error-text");textSpanErrorText.innerText=errText;window.lam.dialog.showSimpleDialog(errorTitle,null,errorOkText,null,"treeview_error_dlg")}})}})};window.lam.treeview.getNodeContent=function(tokenName,tokenValue,dn,messages,attributesToHighlight){let data=new FormData;data.append(tokenName,tokenValue);data.append("dn",dn);data.append("highlight",attributesToHighlight?attributesToHighlight:"");fetch("../misc/ajax.php?function=treeview&command=getNodeContent",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();window.lam.treeview.checkSession(jsonData);document.getElementById("ldap_actionarea").innerHTML=jsonData.content;if(messages){document.getElementById("ldap_actionarea_messages").innerHTML=messages}window.scrollTo(0,0);window.lam.html.activateLightboxes();window.lam.treeview.addFileInputListeners();window.lam.treeview.activateSortableInputs()})};window.lam.treeview.addFileInputListeners=function(){document.querySelectorAll(".image-upload").forEach(input=>{input.addEventListener("change",function(){const files=input.files;if(!files[0]){return}const reader=new FileReader;reader.onload=function(){const content=btoa(reader.result);input.dataset.dataBinary=content};reader.readAsBinaryString(files[0])})})};window.lam.treeview.activateSortableInputs=function(){document.querySelectorAll(".tree-attribute-sorted-list").forEach(list=>{const listId=list.id;Sortable.create(document.getElementById(listId),{onUpdate:function(){window.lam.treeview.updateAttributePositionData(listId)}})})};window.lam.treeview.saveAttributes=function(event,tokenName,tokenValue,dn){event.preventDefault();let data=new FormData;data.append(tokenName,tokenValue);data.append("dn",dn);const attributeChanges=window.lam.treeview.findAttributeChanges();const attributesToHighlight=Object.keys(attributeChanges).join(",");data.append("changes",JSON.stringify(attributeChanges));fetch("../misc/ajax.php?function=treeview&command=saveAttributes",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();window.lam.treeview.checkSession(jsonData);if(jsonData.newDn){const tree=mar10.Wunderbaum.getTree("#ldap_tree");tree.findKey(jsonData["parent"]).loadLazy(true);window.lam.treeview.getNodeContent(tokenName,tokenValue,jsonData.newDn,jsonData.result,attributesToHighlight)}else{window.lam.treeview.getNodeContent(tokenName,tokenValue,dn,jsonData.result,attributesToHighlight)}})};window.lam.treeview.findAttributeChanges=function(){let attributeChanges={};document.querySelectorAll(".single-input").forEach(input=>{if(window.lam.utility.isHidden(input)){return}const attrName=input.dataset.attrName;const valueOrig=input.dataset.valueOrig;const valueNew=input.value;if(valueNew!=valueOrig){attributeChanges[attrName]={old:[valueOrig]};if(valueNew==""){attributeChanges[attrName]["new"]=[]}else{attributeChanges[attrName]["new"]=[valueNew]}}});let lastAttrName="";let lastAttrValuesNew=[];let lastAttrValuesOld=[];let lastAttrHasChange=false;document.querySelectorAll(".multi-input").forEach(input=>{if(window.lam.utility.isHidden(input)){return}const attrName=input.dataset.attrName;if(attrName!=lastAttrName){if(lastAttrHasChange){attributeChanges[lastAttrName]={old:lastAttrValuesOld,new:lastAttrValuesNew}}lastAttrHasChange=false;lastAttrName=attrName;lastAttrValuesNew=[];lastAttrValuesOld=[]}const valueOrig=input.dataset.valueOrig;const valueNew=input.value;if(valueOrig!=""){lastAttrValuesOld.push(valueOrig)}if(valueNew!=""){lastAttrValuesNew.push(valueNew)}if(valueNew!=valueOrig){lastAttrHasChange=true}});if(lastAttrHasChange){attributeChanges[lastAttrName]={old:lastAttrValuesOld,new:lastAttrValuesNew}}document.querySelectorAll(".hash-select").forEach(input=>{const attrName=input.dataset.attrName;if(!attributeChanges[attrName]){return}if(!attributeChanges[attrName]["hash"]){attributeChanges[attrName]["hash"]=[input.value]}else{attributeChanges[attrName]["hash"].push(input.value)}});document.querySelectorAll(".image-input").forEach(input=>{const toDelete=input.dataset.delete;if(toDelete!=="true"){return}const attrName=input.dataset.attrName;const attrIndex=input.dataset.index;if(!attrIndex){return}if(!attributeChanges[attrName]){attributeChanges[attrName]={delete:[attrIndex]}}else{attributeChanges[attrName]["delete"].push(attrIndex)}});document.querySelectorAll(".image-upload").forEach(input=>{const content=input.dataset.dataBinary;if(!content){return}const attrName=input.dataset.attrName;if(!attrName){return}if(!attributeChanges[attrName]){attributeChanges[attrName]={upload:content}}else{attributeChanges[attrName]["upload"]=content}});return attributeChanges};window.lam.treeview.clearValue=function(event,link){event.preventDefault();const parentTr=link.closest("tr");const input=parentTr.querySelector("input, textarea");if(input!==null){input.value=""}const image=parentTr.querySelector(".image-input");if(image){parentTr.classList.add("hidden");image.dataset.delete="true"}};window.lam.treeview.addValue=function(event,link){event.preventDefault();const parentTr=link.closest("tr");const newTr=parentTr.cloneNode(true);const newField=newTr.querySelector("input, textarea");newField.value="";newField.dataset.valueOrig="";parentTr.after(newTr)};window.lam.treeview.updatePossibleNewAttributes=function(tokenName,tokenValue){if(window.lam.treeview.updatePossibleNewAttributesRequest){window.lam.treeview.updatePossibleNewAttributesRequest.abort();window.lam.treeview.updatePossibleNewAttributesRequest=null}const fields=document.querySelectorAll(".lam-attr-objectclass");const listener=function(){window.lam.treeview.updatePossibleNewAttributes(tokenName,tokenValue)};fields.forEach(function(field){field.removeEventListener("change",listener);field.addEventListener("change",listener)});let objectCLasses=[];fields.forEach(function(field){objectCLasses.push(field.value)});let data=new FormData;data.append("dn","none");data.append(tokenName,tokenValue);data.append("objectClasses",JSON.stringify(objectCLasses));fetch("../misc/ajax.php?function=treeview&command=getPossibleNewAttributes",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();window.lam.treeview.checkSession(jsonData);const select=document.getElementById("newAttribute");select.innerHTML="";const existingAttributeFieldNames=[];document.querySelectorAll(".attribute-field").forEach(input=>{if(input.dataset.attrName){existingAttributeFieldNames.push(input.dataset.attrName)}});const data=jsonData["data"];for(const attributeName in data){if(existingAttributeFieldNames.includes(attributeName)){continue}const option=document.createElement("option");option.value=data[attributeName];option.innerText=attributeName;select.appendChild(option)}window.lam.treeview.updatePossibleNewAttributesRequest=null})};window.lam.treeview.updatePossibleNewAttributesRequest=null;window.lam.treeview.addAttributeField=function(event,select){event.preventDefault();let attributeParts=select.value;if(attributeParts==""){return}select.options.remove(select.options.selectedIndex);attributeParts=attributeParts.split("__#__");const attributeName=attributeParts[0];const isSingleValue=attributeParts[1];const fieldType=attributeParts[2];const placeHolderId="new-attributes-"+isSingleValue+"-"+fieldType;let newContent=document.getElementById(placeHolderId).querySelector(".row").cloneNode(true);newContent.children[0].innerText=attributeName;const inputField=newContent.querySelector("input, textarea");inputField.dataset.attrName=attributeName;inputField.name="lam_attr_"+attributeName;inputField.id="lam_attr_"+attributeName;const hashSelect=newContent.querySelector(".hash-select");if(hashSelect){hashSelect.id="lam_hash_"+attributeName;hashSelect.name="lam_hash_"+attributeName;hashSelect.dataset.attrName=attributeName}newContent=[...newContent.children];while(newContent.length>0){select.closest("div").after(newContent.pop())}window.lam.treeview.addFileInputListeners()};window.lam.treeview.getInternalAttributesContent=function(event,tokenName,tokenValue,dn){event.preventDefault();let data=new FormData;data.append(tokenName,tokenValue);data.append("dn",dn);fetch("../misc/ajax.php?function=treeview&command=getInternalAttributesContent",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();window.lam.treeview.checkSession(jsonData);document.getElementById("actionarea-internal-attributes").innerHTML=jsonData.content})};window.lam.treeview.search=function(tokenName,tokenValue,dn){let data=new FormData;data.append(tokenName,tokenValue);data.append("dn",dn);fetch("../misc/ajax.php?function=treeview&command=search",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();window.lam.treeview.checkSession(jsonData);document.getElementById("ldap_actionarea").innerHTML=jsonData.content;window.scrollTo(0,0)})};window.lam.treeview.searchResults=function(event,tokenName,tokenValue,dn){event.preventDefault();let data=new FormData;data.append(tokenName,tokenValue);data.append("dn",dn);data.append("scope",document.getElementById("scope").value);data.append("filter",document.getElementById("filter").value);data.append("attributes",document.getElementById("attributes").value);data.append("orderBy",document.getElementById("orderBy").value);data.append("limit",document.getElementById("limit").value);data.append("format",document.getElementById("format").value);fetch("../misc/ajax.php?function=treeview&command=searchResults",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();window.lam.treeview.checkSession(jsonData);document.getElementById("ldap_actionarea").innerHTML=jsonData.content;window.scrollTo(0,0)})};window.lam.treeview.openInitial=async function(tree,ids){if(ids.length===0){return}let lastNode=null;for(const id of ids){const node=tree.findKey(id);if(node){await node.setExpanded();lastNode=node}}if(lastNode){await lastNode.setActive()}};window.lam.treeview.copyNode=function(dn){if(!window.sessionStorage){return}const tree=mar10.Wunderbaum.getTree("#ldap_tree");const node=tree.findKey(dn);window.sessionStorage.setItem("LAM_COPY_PASTE_ACTION","COPY");const oldNodeDn=window.sessionStorage.getItem("LAM_COPY_PASTE_DN");if(oldNodeDn){const oldNode=tree.findKey(oldNodeDn);if(oldNode){oldNode.data.badge=null;oldNode.update()}}window.sessionStorage.setItem("LAM_COPY_PASTE_DN",node.key);node.data.badge="../../graphics/copy.svg";node.update()};window.lam.treeview.cutNode=function(dn){if(!window.sessionStorage){return}const tree=mar10.Wunderbaum.getTree("#ldap_tree");const node=tree.findKey(dn);window.sessionStorage.setItem("LAM_COPY_PASTE_ACTION","CUT");const oldNodeDn=window.sessionStorage.getItem("LAM_COPY_PASTE_DN");if(oldNodeDn){const oldNode=tree.findKey(oldNodeDn);if(oldNode){oldNode.data.badge=null;oldNode.update()}}window.sessionStorage.setItem("LAM_COPY_PASTE_DN",node.key);node.data.badge="../../graphics/cut.svg";node.update()};window.lam.treeview.pasteNode=function(tokenName,tokenValue,destinationDn){const dn=window.sessionStorage.getItem("LAM_COPY_PASTE_DN");if(!dn){return}const tree=mar10.Wunderbaum.getTree("#ldap_tree");const action=window.sessionStorage.getItem("LAM_COPY_PASTE_ACTION");let data=new FormData;data.append(tokenName,tokenValue);data.append("dn",dn);data.append("targetDn",destinationDn);data.append("action",action);fetch("../misc/ajax.php?function=treeview&command=paste",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();window.lam.treeview.checkSession(jsonData);if(jsonData.error){document.getElementById("ldap_actionarea_messages").innerHTML=jsonData.error;return}window.sessionStorage.removeItem("LAM_COPY_PASTE_ACTION");window.sessionStorage.removeItem("LAM_COPY_PASTE_DN");const oldNode=tree.findKey(dn);if(action=="CUT"){const parentNode=oldNode.parent;parentNode.loadLazy(true)}else{oldNode.data.badge=null;oldNode.update()}const newParentNode=tree.findKey(destinationDn);newParentNode.lazy=true;newParentNode.expanded=true;newParentNode.loadLazy(true)})};window.lam.treeview.checkSession=function(json){if(json&&json.sessionExpired=="true"){location.href="../login.php?expired=yes"}};window.lam.treeview.checkPassword=function(event,element,tokenName,tokenValue,title,checkText,cancelText,okText){event.preventDefault();const outputDiv=document.getElementById("lam-pwd-check-dialog-result");outputDiv.innerHTML="";const dialogContent=document.getElementById("lam-pwd-check-dialog").cloneNode(true);dialogContent.classList.remove("hidden");dialogContent.querySelector(".lam_pwd_check").classList.add("lam_pwd_check_dlg");Swal.fire({title:title,confirmButtonText:checkText,cancelButtonText:cancelText,showCancelButton:true,html:dialogContent.outerHTML,width:"48em"}).then(result=>{if(result.isConfirmed){const hashValue=element.closest("table").querySelector("input[type=password]").value;const checkValue=document.querySelector(".lam_pwd_check_dlg").value;let data=new FormData;data.append("jsonInput","");data.append(tokenName,tokenValue);data.append("hashValue",hashValue);data.append("checkValue",checkValue);fetch("../misc/ajax.php?function=checkPassword",{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();if(jsonData.resultHtml){outputDiv.innerHTML=jsonData.resultHtml;window.lam.dialog.showSimpleDialog(null,null,okText,null,"lam-pwd-check-dialog-result")}})}})};window.lam.treeview.updateAttributePositionData=function(containerId){const container=document.getElementById(containerId);const childLiElements=container.children;for(let i=0;i<childLiElements.length;i++){let inputField=childLiElements[i].querySelector("input");if(inputField===null){inputField=childLiElements[i].querySelector("textarea")}inputField.value="{"+i+"}"+inputField.value.replace(/^\{[0-9]+\}/,"")}};window.lam.topmenu=window.lam.topmenu||{};window.lam.topmenu.toggle=function(){var topnav=document.getElementById("lam-topnav");if(topnav.className=="lam-header"){topnav.className="lam-header lam-header-open"}else{topnav.className="lam-header"}};window.lam.topmenu.openSubmenu=function(event,layerId,listener){const layer=document.getElementById(layerId);if(layer.style.height&&layer.style.height!=="0px"){return}document.removeEventListener("click",listener);document.removeEventListener("mouseover",listener);event.preventDefault();event.stopImmediatePropagation();let layers=document.getElementsByClassName("lam-navigation-layer");for(let i=0;i<layers.length;i++){layers[i].style.height="0px"}const height=layer.getElementsByClassName("lam-navigation-layer-content")[0].offsetHeight;layer.style.height=height+"px";window.lam.topmenu.lastOpened=(new Date).getTime();document.addEventListener("click",listener);document.addEventListener("mouseover",listener)};window.lam.topmenu.subMenuCloseListenerTools=function(event){const timeLimit=(new Date).getTime()-100;if(!window.lam.topmenu.lastOpened||timeLimit<window.lam.topmenu.lastOpened){return}if(event.type=="click"&&!event.target.closest("#lam-navigation-tools")){document.getElementById("lam-navigation-tools").style.height="0px"}if(event.type=="mouseover"&&!event.target.closest("#lam-topnav")){document.getElementById("lam-navigation-tools").style.height="0px"}};window.lam.topmenu.subMenuCloseListenerTypes=function(event){const timeLimit=(new Date).getTime()-100;if(!window.lam.topmenu.lastOpened||timeLimit<window.lam.topmenu.lastOpened){return}if(event.type=="click"&&!event.target.closest("#lam-navigation-types")){document.getElementById("lam-navigation-types").style.height="0px"}if(event.type=="mouseover"&&!event.target.closest("#lam-topnav")){document.getElementById("lam-navigation-types").style.height="0px"}};window.lam.tabs=window.lam.tabs||{};window.lam.tabs.init=function(){const tabs=document.querySelectorAll("li.lam-tab");tabs.forEach(function(element){if(element.dataset.tabid){element.onclick=function(){window.lam.tabs.tabClick(element);return false}}})};window.lam.tabs.tabClick=function(element){const tabId=element.dataset.tabid;const contents=document.querySelectorAll("div.lam-tab-content");contents.forEach(function(element){if(element.dataset.tabid==tabId){element.classList.add("lam-tab-active")}else{element.classList.remove("lam-tab-active")}});const tabs=document.querySelectorAll("li.lam-tab");tabs.forEach(function(element){if(element.dataset.tabid==tabId){element.classList.add("lam-tab-active")}else{element.classList.remove("lam-tab-active")}});const selectedTabInput=document.querySelector("#selectedTab");if(selectedTabInput){selectedTabInput.value=tabId}};window.lam.progressbar=window.lam.progressbar||{};window.lam.progressbar.setProgress=function(htmlId,progress){const bar=document.getElementById(htmlId).querySelector(".lam-progressbar-bar");bar.style.width=progress+"%"};window.lam.progressbar.getMarkup=function(htmlId){return'<div id="'+htmlId+'" class="lam-progressbar">'+'<div class="lam-progressbar-bar" style="width: 0%"></div>'+"</div>"};window.lam.accordion=window.lam.accordion||{};window.lam.accordion.init=function(){const accordionButtons=document.getElementsByClassName("lam-accordion-button");Array.from(accordionButtons).forEach(function(button){button.addEventListener("click",function(event){window.lam.accordion.onClick(event,this);return false})});const accordions=document.getElementsByClassName("lam-accordion-container");Array.from(accordions).forEach(function(accordion){const isSaveState=accordion.dataset.savestate&&accordion.dataset.savestate==="true";let openInitial=false;const storageKey="lam_accordionStore_"+accordion.id;if(isSaveState&&window.localStorage.getItem(storageKey)){openInitial=window.localStorage.getItem(storageKey)}else if(accordion.dataset.openinitial){openInitial=accordion.dataset.openinitial}if(openInitial!==false){accordion.querySelectorAll(".lam-accordion-button").forEach(item=>{const buttonIndex=item.dataset.index;if(openInitial===buttonIndex){item.classList.add("lam-accordion-button-active")}});accordion.querySelectorAll(".lam-accordion-content").forEach(item=>{const contentIndex=item.dataset.index;if(openInitial===contentIndex){item.style.maxHeight=null;item.classList.add("lam-accordion-content-active");item.style.maxHeight=item.scrollHeight+"px"}})}})};window.lam.accordion.onClick=function(event,button){event.preventDefault();button.classList.toggle("lam-accordion-button-active");const content=button.nextElementSibling;if(content.style.maxHeight){content.style.maxHeight=null;content.classList.remove("lam-accordion-content-active")}else{content.style.maxHeight=content.scrollHeight+"px";content.classList.add("lam-accordion-content-active")}const indexActive=button.dataset.index;const accordion=button.parentElement;const isSaveState=accordion.dataset.savestate&&accordion.dataset.savestate==="true";if(isSaveState){const storageKey="lam_accordionStore_"+accordion.id;window.localStorage.setItem(storageKey,indexActive)}accordion.querySelectorAll(".lam-accordion-button").forEach(item=>{const buttonIndex=item.dataset.index;if(indexActive!==buttonIndex){item.classList.remove("lam-accordion-button-active")}});accordion.querySelectorAll(".lam-accordion-content").forEach(item=>{const contentIndex=item.dataset.index;if(indexActive!==contentIndex){item.style.maxHeight=null;item.classList.remove("lam-accordion-content-active")}})};window.lam.tooltip=window.lam.tooltip||{};window.lam.tooltip.init=function(){document.querySelectorAll("[helpdata]").forEach(item=>{let helpString="<div class='lam-tooltip'><h4 class=\"lam-tooltip-title\">";helpString+=item.attributes.helptitle.value;helpString+='</h4><div class="lam-tooltip-content">';helpString+=item.attributes.helpdata.value;helpString+="</div></h4></div>";tippy(item,{content:helpString,allowHTML:true,arrow:false,delay:[100,20]})})};window.lam.smtp=window.lam.smtp||{};window.lam.smtp.test=function(event,tokenName,tokenValue,okText,cancelText,title){event.preventDefault();const runTestPreCallback=function(){const mailFrom=document.getElementById("testSmtpFrom").value;const mailTo=document.getElementById("testSmtpTo").value;if(!mailFrom||!mailTo){return false}return{mailFrom:mailFrom,mailTo:mailTo}};const runTestCallback=function(formData){document.getElementById("btn_testSmtp").disabled=true;let data=new FormData;data.append(tokenName,tokenValue);data.append("server",document.getElementById("mailServer").value);data.append("user",document.getElementById("mailUser").value);data.append("password",document.getElementById("mailPassword").value);data.append("encryption",document.getElementById("mailEncryption").value);data.append("mailFrom",formData.mailFrom);data.append("mailTo",formData.mailTo);const url="../misc/ajax.php?function=testSmtp";fetch(url,{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();if(jsonData.info){window.lam.dialog.showInfo(jsonData.info,okText)}else if(jsonData.error){window.lam.dialog.showError(jsonData.error,jsonData.details,okText)}document.getElementById("btn_testSmtp").disabled=false})};window.lam.dialog.showConfirmation(title,okText,cancelText,"smtpTestDialogDiv",runTestCallback,runTestPreCallback)};window.lam.config=window.lam.config||{};window.lam.config.updateModuleFilter=function(inputField){const filterValue=inputField.value.toLowerCase();const table=inputField.parentElement.parentElement.querySelector("table");table.querySelectorAll("tr").forEach(row=>{let matches=false;for(let i=0;i<row.children.length;i++){const cell=row.children[i];if(cell.children.length>0){continue}if(cell.innerText.toLowerCase().includes(filterValue)){matches=true}}if(matches){row.classList.remove("hidden")}else{row.classList.add("hidden")}})};window.lam.richEdit=window.lam.richEdit||{};window.lam.richEdit.init=function(){document.querySelectorAll(".lam-rich-edit").forEach(textarea=>{Jodit.make(textarea,{beautifyHTML:false,sourceEditorCDNUrlsJS:[],sourceEditor:"area",uploader:{insertImageAsBase64URI:true}})})};window.lam.datatable=window.lam.datatable||{};window.lam.datatable.tables=window.lam.datatable.tables||{};window.lam.datatable.unfinishedTables=window.lam.datatable.unfinishedTables||{};window.lam.datatable.init=function(id,table){window.lam.datatable.tables[id]=table;window.lam.datatable.unfinishedTables[id]=true;table.on("tableBuilt",()=>{window.lam.datatable.unfinishedTables[id]=false})};window.lam.datatable.refreshTableData=function(id){const tableDiv=document.getElementById(id);if(!tableDiv){return}const ajaxUrl=tableDiv.dataset.ajaxurl;const tokenName=tableDiv.dataset.tokenname;const tokenValue=tableDiv.dataset.tokenvalue;const action=tableDiv.dataset.action;const okText=tableDiv.dataset.oktext;let data=new FormData;data.append(tokenName,tokenValue);data.append("action",action);fetch(ajaxUrl,{method:"POST",body:data}).then(async response=>{const jsonData=await response.json();if(jsonData.message){window.lam.dialog.showError(jsonData.message,okText)}else{window.lam.datatable.setData(id,jsonData)}})};window.lam.datatable.setData=function(id,data){const table=window.lam.datatable.tables[id];for(let i=0;i<data.length;i++){data[i].id=i}if(window.lam.datatable.unfinishedTables[id]===false){table.replaceData(data)}else{table.on("tableBuilt",()=>{window.lam.datatable.unfinishedTables[id]=false;table.replaceData(data)})}};window.lam.loadingIndicator=window.lam.loadingIndicator||{};window.lam.loadingIndicator.start=function(){Swal.fire({title:"",imageUrl:"../../style/loading.gif",showConfirmButton:false,allowOutsideClick:false,timer:6e4})};window.lam.loadingIndicator.stop=function(){Swal.close()};window.lam.utility=window.lam.utility||{};window.lam.utility.documentReady=function(callback){if(document.readyState!=="loading"){callback()}else{document.addEventListener("DOMContentLoaded",callback)}};window.lam.utility.saveScrollPosition=function(formName){const top=window.scrollY;const left=window.scrollX;let scrollPositionTop=document.createElement("input");scrollPositionTop.name="scrollPositionTop";scrollPositionTop.value=top;scrollPositionTop.hidden="hidden";document.forms[formName].appendChild(scrollPositionTop);let scrollPositionLeft=document.createElement("input");scrollPositionLeft.name="scrollPositionLeft";scrollPositionLeft.value=left;scrollPositionLeft.hidden="hidden";document.forms[formName].appendChild(scrollPositionLeft)};window.lam.utility.restoreScrollPosition=function(topValue,leftValue){window.lam.utility.documentReady(function(){window.scrollTo(leftValue,topValue)})};window.lam.utility.isHidden=function(element){return!element.offsetWidth||!element.offsetHeight||element.getClientRects().length==0};window.lam.utility.documentReady(function(){window.lam.form.autoTrim();window.lam.account.addDefaultProfileListener();window.lam.tools.addSavedSelectListener();window.lam.tools.setInitialFocus();window.lam.tools.webcam.init();window.lam.tools.schema.select();window.lam.html.activateLightboxes();window.lam.html.preventEnter();window.lam.filterSelect.addFormListener();window.lam.dynamicSelect.activate();window.lam.webauthn.setupDeviceManagement();window.lam.tabs.init();window.lam.accordion.init();window.lam.tooltip.init();window.lam.richEdit.init()});if("serviceWorker"in navigator){if(!navigator.serviceWorker.controller){var basePath=document.currentScript.src;basePath=basePath.replace(/\/[^/]+\.js/gi,"");var workerJS=basePath+"/../../pwa_worker.js";navigator.serviceWorker.register(workerJS,{scope:basePath+"../../"})}}(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?module.exports=factory():typeof define==="function"&&define.amd?define(factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,global.flatpickr=factory())})(this,function(){"use strict";var __assign=function(){__assign=Object.assign||function __assign(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)if(Object.prototype.hasOwnProperty.call(s,p))t[p]=s[p]}return t};return __assign.apply(this,arguments)};function __spreadArrays(){for(var s=0,i=0,il=arguments.length;i<il;i++)s+=arguments[i].length;for(var r=Array(s),k=0,i=0;i<il;i++)for(var a=arguments[i],j=0,jl=a.length;j<jl;j++,k++)r[k]=a[j];return r}var HOOKS=["onChange","onClose","onDayCreate","onDestroy","onKeyDown","onMonthChange","onOpen","onParseConfig","onReady","onValueUpdate","onYearChange","onPreCalendarPosition"];var defaults={_disable:[],allowInput:false,allowInvalidPreload:false,altFormat:"F j, Y",altInput:false,altInputClass:"form-control input",animate:typeof window==="object"&&window.navigator.userAgent.indexOf("MSIE")===-1,ariaDateFormat:"F j, Y",autoFillDefaultTime:true,clickOpens:true,closeOnSelect:true,conjunction:", ",dateFormat:"Y-m-d",defaultHour:12,defaultMinute:0,defaultSeconds:0,disable:[],disableMobile:false,enableSeconds:false,enableTime:false,errorHandler:function(err){return typeof console!=="undefined"&&console.warn(err)},getWeek:function(givenDate){var date=new Date(givenDate.getTime());date.setHours(0,0,0,0);date.setDate(date.getDate()+3-(date.getDay()+6)%7);var week1=new Date(date.getFullYear(),0,4);return 1+Math.round(((date.getTime()-week1.getTime())/864e5-3+(week1.getDay()+6)%7)/7)},hourIncrement:1,ignoredFocusElements:[],inline:false,locale:"default",minuteIncrement:5,mode:"single",monthSelectorType:"dropdown",nextArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>",noCalendar:false,now:new Date,onChange:[],onClose:[],onDayCreate:[],onDestroy:[],onKeyDown:[],onMonthChange:[],onOpen:[],onParseConfig:[],onReady:[],onValueUpdate:[],onYearChange:[],onPreCalendarPosition:[],plugins:[],position:"auto",positionElement:undefined,prevArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>",shorthandCurrentMonth:false,showMonths:1,static:false,time_24hr:false,weekNumbers:false,wrap:false};var english={weekdays:{shorthand:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],longhand:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},months:{shorthand:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],longhand:["January","February","March","April","May","June","July","August","September","October","November","December"]},daysInMonth:[31,28,31,30,31,30,31,31,30,31,30,31],firstDayOfWeek:0,ordinal:function(nth){var s=nth%100;if(s>3&&s<21)return"th";switch(s%10){case 1:return"st";case 2:return"nd";case 3:return"rd";default:return"th"}},rangeSeparator:" to ",weekAbbreviation:"Wk",scrollTitle:"Scroll to increment",toggleTitle:"Click to toggle",amPM:["AM","PM"],yearAriaLabel:"Year",monthAriaLabel:"Month",hourAriaLabel:"Hour",minuteAriaLabel:"Minute",time_24hr:false};var pad=function(number,length){if(length===void 0){length=2}return("000"+number).slice(length*-1)};var int=function(bool){return bool===true?1:0};function debounce(fn,wait){var t;return function(){var _this=this;var args=arguments;clearTimeout(t);t=setTimeout(function(){return fn.apply(_this,args)},wait)}}var arrayify=function(obj){return obj instanceof Array?obj:[obj]};function toggleClass(elem,className,bool){if(bool===true)return elem.classList.add(className);elem.classList.remove(className)}function createElement(tag,className,content){var e=window.document.createElement(tag);className=className||"";content=content||"";e.className=className;if(content!==undefined)e.textContent=content;return e}function clearNode(node){while(node.firstChild)node.removeChild(node.firstChild)}function findParent(node,condition){if(condition(node))return node;else if(node.parentNode)return findParent(node.parentNode,condition);return undefined}function createNumberInput(inputClassName,opts){var wrapper=createElement("div","numInputWrapper"),numInput=createElement("input","numInput "+inputClassName),arrowUp=createElement("span","arrowUp"),arrowDown=createElement("span","arrowDown");if(navigator.userAgent.indexOf("MSIE 9.0")===-1){numInput.type="number"}else{numInput.type="text";numInput.pattern="\\d*"}if(opts!==undefined)for(var key in opts)numInput.setAttribute(key,opts[key]);wrapper.appendChild(numInput);wrapper.appendChild(arrowUp);wrapper.appendChild(arrowDown);return wrapper}function getEventTarget(event){try{if(typeof event.composedPath==="function"){var path=event.composedPath();return path[0]}return event.target}catch(error){return event.target}}var doNothing=function(){return undefined};var monthToStr=function(monthNumber,shorthand,locale){return locale.months[shorthand?"shorthand":"longhand"][monthNumber]};var revFormat={D:doNothing,F:function(dateObj,monthName,locale){dateObj.setMonth(locale.months.longhand.indexOf(monthName))},G:function(dateObj,hour){dateObj.setHours((dateObj.getHours()>=12?12:0)+parseFloat(hour))},H:function(dateObj,hour){dateObj.setHours(parseFloat(hour))},J:function(dateObj,day){dateObj.setDate(parseFloat(day))},K:function(dateObj,amPM,locale){dateObj.setHours(dateObj.getHours()%12+12*int(new RegExp(locale.amPM[1],"i").test(amPM)))},M:function(dateObj,shortMonth,locale){dateObj.setMonth(locale.months.shorthand.indexOf(shortMonth))},S:function(dateObj,seconds){dateObj.setSeconds(parseFloat(seconds))},U:function(_,unixSeconds){return new Date(parseFloat(unixSeconds)*1e3)},W:function(dateObj,weekNum,locale){var weekNumber=parseInt(weekNum);var date=new Date(dateObj.getFullYear(),0,2+(weekNumber-1)*7,0,0,0,0);date.setDate(date.getDate()-date.getDay()+locale.firstDayOfWeek);return date},Y:function(dateObj,year){dateObj.setFullYear(parseFloat(year))},Z:function(_,ISODate){return new Date(ISODate)},d:function(dateObj,day){dateObj.setDate(parseFloat(day))},h:function(dateObj,hour){dateObj.setHours((dateObj.getHours()>=12?12:0)+parseFloat(hour))},i:function(dateObj,minutes){dateObj.setMinutes(parseFloat(minutes))},j:function(dateObj,day){dateObj.setDate(parseFloat(day))},l:doNothing,m:function(dateObj,month){dateObj.setMonth(parseFloat(month)-1)},n:function(dateObj,month){dateObj.setMonth(parseFloat(month)-1)},s:function(dateObj,seconds){dateObj.setSeconds(parseFloat(seconds))},u:function(_,unixMillSeconds){return new Date(parseFloat(unixMillSeconds))},w:doNothing,y:function(dateObj,year){dateObj.setFullYear(2e3+parseFloat(year))}};var tokenRegex={D:"",F:"",G:"(\\d\\d|\\d)",H:"(\\d\\d|\\d)",J:"(\\d\\d|\\d)\\w+",K:"",M:"",S:"(\\d\\d|\\d)",U:"(.+)",W:"(\\d\\d|\\d)",Y:"(\\d{4})",Z:"(.+)",d:"(\\d\\d|\\d)",h:"(\\d\\d|\\d)",i:"(\\d\\d|\\d)",j:"(\\d\\d|\\d)",l:"",m:"(\\d\\d|\\d)",n:"(\\d\\d|\\d)",s:"(\\d\\d|\\d)",u:"(.+)",w:"(\\d\\d|\\d)",y:"(\\d{2})"};var formats={Z:function(date){return date.toISOString()},D:function(date,locale,options){return locale.weekdays.shorthand[formats.w(date,locale,options)]},F:function(date,locale,options){return monthToStr(formats.n(date,locale,options)-1,false,locale)},G:function(date,locale,options){return pad(formats.h(date,locale,options))},H:function(date){return pad(date.getHours())},J:function(date,locale){return locale.ordinal!==undefined?date.getDate()+locale.ordinal(date.getDate()):date.getDate()},K:function(date,locale){return locale.amPM[int(date.getHours()>11)]},M:function(date,locale){return monthToStr(date.getMonth(),true,locale)},S:function(date){return pad(date.getSeconds())},U:function(date){return date.getTime()/1e3},W:function(date,_,options){return options.getWeek(date)},Y:function(date){return pad(date.getFullYear(),4)},d:function(date){return pad(date.getDate())},h:function(date){return date.getHours()%12?date.getHours()%12:12},i:function(date){return pad(date.getMinutes())},j:function(date){return date.getDate()},l:function(date,locale){return locale.weekdays.longhand[date.getDay()]},m:function(date){return pad(date.getMonth()+1)},n:function(date){return date.getMonth()+1},s:function(date){return date.getSeconds()},u:function(date){return date.getTime()},w:function(date){return date.getDay()},y:function(date){return String(date.getFullYear()).substring(2)}};var createDateFormatter=function(_a){var _b=_a.config,config=_b===void 0?defaults:_b,_c=_a.l10n,l10n=_c===void 0?english:_c,_d=_a.isMobile,isMobile=_d===void 0?false:_d;return function(dateObj,frmt,overrideLocale){var locale=overrideLocale||l10n;if(config.formatDate!==undefined&&!isMobile){return config.formatDate(dateObj,frmt,locale)}return frmt.split("").map(function(c,i,arr){return formats[c]&&arr[i-1]!=="\\"?formats[c](dateObj,locale,config):c!=="\\"?c:""}).join("")}};var createDateParser=function(_a){var _b=_a.config,config=_b===void 0?defaults:_b,_c=_a.l10n,l10n=_c===void 0?english:_c;return function(date,givenFormat,timeless,customLocale){if(date!==0&&!date)return undefined;var locale=customLocale||l10n;var parsedDate;var dateOrig=date;if(date instanceof Date)parsedDate=new Date(date.getTime());else if(typeof date!=="string"&&date.toFixed!==undefined)parsedDate=new Date(date);else if(typeof date==="string"){var format=givenFormat||(config||defaults).dateFormat;var datestr=String(date).trim();if(datestr==="today"){parsedDate=new Date;timeless=true}else if(config&&config.parseDate){parsedDate=config.parseDate(date,format)}else if(/Z$/.test(datestr)||/GMT$/.test(datestr)){parsedDate=new Date(date)}else{var matched=void 0,ops=[];for(var i=0,matchIndex=0,regexStr="";i<format.length;i++){var token_1=format[i];var isBackSlash=token_1==="\\";var escaped=format[i-1]==="\\"||isBackSlash;if(tokenRegex[token_1]&&!escaped){regexStr+=tokenRegex[token_1];var match=new RegExp(regexStr).exec(date);if(match&&(matched=true)){ops[token_1!=="Y"?"push":"unshift"]({fn:revFormat[token_1],val:match[++matchIndex]})}}else if(!isBackSlash)regexStr+="."}parsedDate=!config||!config.noCalendar?new Date((new Date).getFullYear(),0,1,0,0,0,0):new Date((new Date).setHours(0,0,0,0));ops.forEach(function(_a){var fn=_a.fn,val=_a.val;return parsedDate=fn(parsedDate,val,locale)||parsedDate});parsedDate=matched?parsedDate:undefined}}if(!(parsedDate instanceof Date&&!isNaN(parsedDate.getTime()))){config.errorHandler(new Error("Invalid date provided: "+dateOrig));return undefined}if(timeless===true)parsedDate.setHours(0,0,0,0);return parsedDate}};function compareDates(date1,date2,timeless){if(timeless===void 0){timeless=true}if(timeless!==false){return new Date(date1.getTime()).setHours(0,0,0,0)-new Date(date2.getTime()).setHours(0,0,0,0)}return date1.getTime()-date2.getTime()}var isBetween=function(ts,ts1,ts2){return ts>Math.min(ts1,ts2)&&ts<Math.max(ts1,ts2)};var calculateSecondsSinceMidnight=function(hours,minutes,seconds){return hours*3600+minutes*60+seconds};var parseSeconds=function(secondsSinceMidnight){var hours=Math.floor(secondsSinceMidnight/3600),minutes=(secondsSinceMidnight-hours*3600)/60;return[hours,minutes,secondsSinceMidnight-hours*3600-minutes*60]};var duration={DAY:864e5};function getDefaultHours(config){var hours=config.defaultHour;var minutes=config.defaultMinute;var seconds=config.defaultSeconds;if(config.minDate!==undefined){var minHour=config.minDate.getHours();var minMinutes=config.minDate.getMinutes();var minSeconds=config.minDate.getSeconds();if(hours<minHour){hours=minHour}if(hours===minHour&&minutes<minMinutes){minutes=minMinutes}if(hours===minHour&&minutes===minMinutes&&seconds<minSeconds)seconds=config.minDate.getSeconds()}if(config.maxDate!==undefined){var maxHr=config.maxDate.getHours();var maxMinutes=config.maxDate.getMinutes();hours=Math.min(hours,maxHr);if(hours===maxHr)minutes=Math.min(maxMinutes,minutes);if(hours===maxHr&&minutes===maxMinutes)seconds=config.maxDate.getSeconds()}return{hours:hours,minutes:minutes,seconds:seconds}}if(typeof Object.assign!=="function"){Object.assign=function(target){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}if(!target){throw TypeError("Cannot convert undefined or null to object")}var _loop_1=function(source){if(source){Object.keys(source).forEach(function(key){return target[key]=source[key]})}};for(var _a=0,args_1=args;_a<args_1.length;_a++){var source=args_1[_a];_loop_1(source)}return target}}var DEBOUNCED_CHANGE_MS=300;function FlatpickrInstance(element,instanceConfig){var self={config:__assign(__assign({},defaults),flatpickr.defaultConfig),l10n:english};self.parseDate=createDateParser({config:self.config,l10n:self.l10n});self._handlers=[];self.pluginElements=[];self.loadedPlugins=[];self._bind=bind;self._setHoursFromDate=setHoursFromDate;self._positionCalendar=positionCalendar;self.changeMonth=changeMonth;self.changeYear=changeYear;self.clear=clear;self.close=close;self.onMouseOver=onMouseOver;self._createElement=createElement;self.createDay=createDay;self.destroy=destroy;self.isEnabled=isEnabled;self.jumpToDate=jumpToDate;self.updateValue=updateValue;self.open=open;self.redraw=redraw;self.set=set;self.setDate=setDate;self.toggle=toggle;function setupHelperFunctions(){self.utils={getDaysInMonth:function(month,yr){if(month===void 0){month=self.currentMonth}if(yr===void 0){yr=self.currentYear}if(month===1&&(yr%4===0&&yr%100!==0||yr%400===0))return 29;return self.l10n.daysInMonth[month]}}}function init(){self.element=self.input=element;self.isOpen=false;parseConfig();setupLocale();setupInputs();setupDates();setupHelperFunctions();if(!self.isMobile)build();bindEvents();if(self.selectedDates.length||self.config.noCalendar){if(self.config.enableTime){setHoursFromDate(self.config.noCalendar?self.latestSelectedDateObj:undefined)}updateValue(false)}setCalendarWidth();var isSafari=/^((?!chrome|android).)*safari/i.test(navigator.userAgent);if(!self.isMobile&&isSafari){positionCalendar()}triggerEvent("onReady")}function getClosestActiveElement(){var _a;return((_a=self.calendarContainer)===null||_a===void 0?void 0:_a.getRootNode()).activeElement||document.activeElement}function bindToInstance(fn){return fn.bind(self)}function setCalendarWidth(){var config=self.config;if(config.weekNumbers===false&&config.showMonths===1){return}else if(config.noCalendar!==true){window.requestAnimationFrame(function(){if(self.calendarContainer!==undefined){self.calendarContainer.style.visibility="hidden";self.calendarContainer.style.display="block"}if(self.daysContainer!==undefined){var daysWidth=(self.days.offsetWidth+1)*config.showMonths;self.daysContainer.style.width=daysWidth+"px";self.calendarContainer.style.width=daysWidth+(self.weekWrapper!==undefined?self.weekWrapper.offsetWidth:0)+"px";self.calendarContainer.style.removeProperty("visibility");self.calendarContainer.style.removeProperty("display")}})}}function updateTime(e){if(self.selectedDates.length===0){var defaultDate=self.config.minDate===undefined||compareDates(new Date,self.config.minDate)>=0?new Date:new Date(self.config.minDate.getTime());var defaults=getDefaultHours(self.config);defaultDate.setHours(defaults.hours,defaults.minutes,defaults.seconds,defaultDate.getMilliseconds());self.selectedDates=[defaultDate];self.latestSelectedDateObj=defaultDate}if(e!==undefined&&e.type!=="blur"){timeWrapper(e)}var prevValue=self._input.value;setHoursFromInputs();updateValue();if(self._input.value!==prevValue){self._debouncedChange()}}function ampm2military(hour,amPM){return hour%12+12*int(amPM===self.l10n.amPM[1])}function military2ampm(hour){switch(hour%24){case 0:case 12:return 12;default:return hour%12}}function setHoursFromInputs(){if(self.hourElement===undefined||self.minuteElement===undefined)return;var hours=(parseInt(self.hourElement.value.slice(-2),10)||0)%24,minutes=(parseInt(self.minuteElement.value,10)||0)%60,seconds=self.secondElement!==undefined?(parseInt(self.secondElement.value,10)||0)%60:0;if(self.amPM!==undefined){hours=ampm2military(hours,self.amPM.textContent)}var limitMinHours=self.config.minTime!==undefined||self.config.minDate&&self.minDateHasTime&&self.latestSelectedDateObj&&compareDates(self.latestSelectedDateObj,self.config.minDate,true)===0;var limitMaxHours=self.config.maxTime!==undefined||self.config.maxDate&&self.maxDateHasTime&&self.latestSelectedDateObj&&compareDates(self.latestSelectedDateObj,self.config.maxDate,true)===0;if(self.config.maxTime!==undefined&&self.config.minTime!==undefined&&self.config.minTime>self.config.maxTime){var minBound=calculateSecondsSinceMidnight(self.config.minTime.getHours(),self.config.minTime.getMinutes(),self.config.minTime.getSeconds());var maxBound=calculateSecondsSinceMidnight(self.config.maxTime.getHours(),self.config.maxTime.getMinutes(),self.config.maxTime.getSeconds());var currentTime=calculateSecondsSinceMidnight(hours,minutes,seconds);if(currentTime>maxBound&&currentTime<minBound){var result=parseSeconds(minBound);hours=result[0];minutes=result[1];seconds=result[2]}}else{if(limitMaxHours){var maxTime=self.config.maxTime!==undefined?self.config.maxTime:self.config.maxDate;hours=Math.min(hours,maxTime.getHours());if(hours===maxTime.getHours())minutes=Math.min(minutes,maxTime.getMinutes());if(minutes===maxTime.getMinutes())seconds=Math.min(seconds,maxTime.getSeconds())}if(limitMinHours){var minTime=self.config.minTime!==undefined?self.config.minTime:self.config.minDate;hours=Math.max(hours,minTime.getHours());if(hours===minTime.getHours()&&minutes<minTime.getMinutes())minutes=minTime.getMinutes();if(minutes===minTime.getMinutes())seconds=Math.max(seconds,minTime.getSeconds())}}setHours(hours,minutes,seconds)}function setHoursFromDate(dateObj){var date=dateObj||self.latestSelectedDateObj;if(date&&date instanceof Date){setHours(date.getHours(),date.getMinutes(),date.getSeconds())}}function setHours(hours,minutes,seconds){if(self.latestSelectedDateObj!==undefined){self.latestSelectedDateObj.setHours(hours%24,minutes,seconds||0,0)}if(!self.hourElement||!self.minuteElement||self.isMobile)return;self.hourElement.value=pad(!self.config.time_24hr?(12+hours)%12+12*int(hours%12===0):hours);self.minuteElement.value=pad(minutes);if(self.amPM!==undefined)self.amPM.textContent=self.l10n.amPM[int(hours>=12)];if(self.secondElement!==undefined)self.secondElement.value=pad(seconds)}function onYearInput(event){var eventTarget=getEventTarget(event);var year=parseInt(eventTarget.value)+(event.delta||0);if(year/1e3>1||event.key==="Enter"&&!/[^\d]/.test(year.toString())){changeYear(year)}}function bind(element,event,handler,options){if(event instanceof Array)return event.forEach(function(ev){return bind(element,ev,handler,options)});if(element instanceof Array)return element.forEach(function(el){return bind(el,event,handler,options)});element.addEventListener(event,handler,options);self._handlers.push({remove:function(){return element.removeEventListener(event,handler,options)}})}function triggerChange(){triggerEvent("onChange")}function bindEvents(){if(self.config.wrap){["open","close","toggle","clear"].forEach(function(evt){Array.prototype.forEach.call(self.element.querySelectorAll("[data-"+evt+"]"),function(el){return bind(el,"click",self[evt])})})}if(self.isMobile){setupMobile();return}var debouncedResize=debounce(onResize,50);self._debouncedChange=debounce(triggerChange,DEBOUNCED_CHANGE_MS);if(self.daysContainer&&!/iPhone|iPad|iPod/i.test(navigator.userAgent))bind(self.daysContainer,"mouseover",function(e){if(self.config.mode==="range")onMouseOver(getEventTarget(e))});bind(self._input,"keydown",onKeyDown);if(self.calendarContainer!==undefined){bind(self.calendarContainer,"keydown",onKeyDown)}if(!self.config.inline&&!self.config.static)bind(window,"resize",debouncedResize);if(window.ontouchstart!==undefined)bind(window.document,"touchstart",documentClick);else bind(window.document,"mousedown",documentClick);bind(window.document,"focus",documentClick,{capture:true});if(self.config.clickOpens===true){bind(self._input,"focus",self.open);bind(self._input,"click",self.open)}if(self.daysContainer!==undefined){bind(self.monthNav,"click",onMonthNavClick);bind(self.monthNav,["keyup","increment"],onYearInput);bind(self.daysContainer,"click",selectDate)}if(self.timeContainer!==undefined&&self.minuteElement!==undefined&&self.hourElement!==undefined){var selText=function(e){return getEventTarget(e).select()};bind(self.timeContainer,["increment"],updateTime);bind(self.timeContainer,"blur",updateTime,{capture:true});bind(self.timeContainer,"click",timeIncrement);bind([self.hourElement,self.minuteElement],["focus","click"],selText);if(self.secondElement!==undefined)bind(self.secondElement,"focus",function(){return self.secondElement&&self.secondElement.select()});if(self.amPM!==undefined){bind(self.amPM,"click",function(e){updateTime(e)})}}if(self.config.allowInput){bind(self._input,"blur",onBlur)}}function jumpToDate(jumpDate,triggerChange){var jumpTo=jumpDate!==undefined?self.parseDate(jumpDate):self.latestSelectedDateObj||(self.config.minDate&&self.config.minDate>self.now?self.config.minDate:self.config.maxDate&&self.config.maxDate<self.now?self.config.maxDate:self.now);var oldYear=self.currentYear;var oldMonth=self.currentMonth;try{if(jumpTo!==undefined){self.currentYear=jumpTo.getFullYear();self.currentMonth=jumpTo.getMonth()}}catch(e){e.message="Invalid date supplied: "+jumpTo;self.config.errorHandler(e)}if(triggerChange&&self.currentYear!==oldYear){triggerEvent("onYearChange");buildMonthSwitch()}if(triggerChange&&(self.currentYear!==oldYear||self.currentMonth!==oldMonth)){triggerEvent("onMonthChange")}self.redraw()}function timeIncrement(e){var eventTarget=getEventTarget(e);if(~eventTarget.className.indexOf("arrow"))incrementNumInput(e,eventTarget.classList.contains("arrowUp")?1:-1)}function incrementNumInput(e,delta,inputElem){var target=e&&getEventTarget(e);var input=inputElem||target&&target.parentNode&&target.parentNode.firstChild;var event=createEvent("increment");event.delta=delta;input&&input.dispatchEvent(event)}function build(){var fragment=window.document.createDocumentFragment();self.calendarContainer=createElement("div","flatpickr-calendar");self.calendarContainer.tabIndex=-1;if(!self.config.noCalendar){fragment.appendChild(buildMonthNav());self.innerContainer=createElement("div","flatpickr-innerContainer");if(self.config.weekNumbers){var _a=buildWeeks(),weekWrapper=_a.weekWrapper,weekNumbers=_a.weekNumbers;self.innerContainer.appendChild(weekWrapper);self.weekNumbers=weekNumbers;self.weekWrapper=weekWrapper}self.rContainer=createElement("div","flatpickr-rContainer");self.rContainer.appendChild(buildWeekdays());if(!self.daysContainer){self.daysContainer=createElement("div","flatpickr-days");self.daysContainer.tabIndex=-1}buildDays();self.rContainer.appendChild(self.daysContainer);self.innerContainer.appendChild(self.rContainer);fragment.appendChild(self.innerContainer)}if(self.config.enableTime){fragment.appendChild(buildTime())}toggleClass(self.calendarContainer,"rangeMode",self.config.mode==="range");toggleClass(self.calendarContainer,"animate",self.config.animate===true);toggleClass(self.calendarContainer,"multiMonth",self.config.showMonths>1);self.calendarContainer.appendChild(fragment);var customAppend=self.config.appendTo!==undefined&&self.config.appendTo.nodeType!==undefined;if(self.config.inline||self.config.static){self.calendarContainer.classList.add(self.config.inline?"inline":"static");if(self.config.inline){if(!customAppend&&self.element.parentNode)self.element.parentNode.insertBefore(self.calendarContainer,self._input.nextSibling);else if(self.config.appendTo!==undefined)self.config.appendTo.appendChild(self.calendarContainer)}if(self.config.static){var wrapper=createElement("div","flatpickr-wrapper");if(self.element.parentNode)self.element.parentNode.insertBefore(wrapper,self.element);wrapper.appendChild(self.element);if(self.altInput)wrapper.appendChild(self.altInput);wrapper.appendChild(self.calendarContainer)}}if(!self.config.static&&!self.config.inline)(self.config.appendTo!==undefined?self.config.appendTo:window.document.body).appendChild(self.calendarContainer)}function createDay(className,date,_dayNumber,i){var dateIsEnabled=isEnabled(date,true),dayElement=createElement("span",className,date.getDate().toString());dayElement.dateObj=date;dayElement.$i=i;dayElement.setAttribute("aria-label",self.formatDate(date,self.config.ariaDateFormat));if(className.indexOf("hidden")===-1&&compareDates(date,self.now)===0){self.todayDateElem=dayElement;dayElement.classList.add("today");dayElement.setAttribute("aria-current","date")}if(dateIsEnabled){dayElement.tabIndex=-1;if(isDateSelected(date)){dayElement.classList.add("selected");self.selectedDateElem=dayElement;if(self.config.mode==="range"){toggleClass(dayElement,"startRange",self.selectedDates[0]&&compareDates(date,self.selectedDates[0],true)===0);toggleClass(dayElement,"endRange",self.selectedDates[1]&&compareDates(date,self.selectedDates[1],true)===0);if(className==="nextMonthDay")dayElement.classList.add("inRange")}}}else{dayElement.classList.add("flatpickr-disabled")}if(self.config.mode==="range"){if(isDateInRange(date)&&!isDateSelected(date))dayElement.classList.add("inRange")}if(self.weekNumbers&&self.config.showMonths===1&&className!=="prevMonthDay"&&i%7===6){self.weekNumbers.insertAdjacentHTML("beforeend","<span class='flatpickr-day'>"+self.config.getWeek(date)+"</span>")}triggerEvent("onDayCreate",dayElement);return dayElement}function focusOnDayElem(targetNode){targetNode.focus();if(self.config.mode==="range")onMouseOver(targetNode)}function getFirstAvailableDay(delta){var startMonth=delta>0?0:self.config.showMonths-1;var endMonth=delta>0?self.config.showMonths:-1;for(var m=startMonth;m!=endMonth;m+=delta){var month=self.daysContainer.children[m];var startIndex=delta>0?0:month.children.length-1;var endIndex=delta>0?month.children.length:-1;for(var i=startIndex;i!=endIndex;i+=delta){var c=month.children[i];if(c.className.indexOf("hidden")===-1&&isEnabled(c.dateObj))return c}}return undefined}function getNextAvailableDay(current,delta){var givenMonth=current.className.indexOf("Month")===-1?current.dateObj.getMonth():self.currentMonth;var endMonth=delta>0?self.config.showMonths:-1;var loopDelta=delta>0?1:-1;for(var m=givenMonth-self.currentMonth;m!=endMonth;m+=loopDelta){var month=self.daysContainer.children[m];var startIndex=givenMonth-self.currentMonth===m?current.$i+delta:delta<0?month.children.length-1:0;var numMonthDays=month.children.length;for(var i=startIndex;i>=0&&i<numMonthDays&&i!=(delta>0?numMonthDays:-1);i+=loopDelta){var c=month.children[i];if(c.className.indexOf("hidden")===-1&&isEnabled(c.dateObj)&&Math.abs(current.$i-i)>=Math.abs(delta))return focusOnDayElem(c)}}self.changeMonth(loopDelta);focusOnDay(getFirstAvailableDay(loopDelta),0);return undefined}function focusOnDay(current,offset){var activeElement=getClosestActiveElement();var dayFocused=isInView(activeElement||document.body);var startElem=current!==undefined?current:dayFocused?activeElement:self.selectedDateElem!==undefined&&isInView(self.selectedDateElem)?self.selectedDateElem:self.todayDateElem!==undefined&&isInView(self.todayDateElem)?self.todayDateElem:getFirstAvailableDay(offset>0?1:-1);if(startElem===undefined){self._input.focus()}else if(!dayFocused){focusOnDayElem(startElem)}else{getNextAvailableDay(startElem,offset)}}function buildMonthDays(year,month){var firstOfMonth=(new Date(year,month,1).getDay()-self.l10n.firstDayOfWeek+7)%7;var prevMonthDays=self.utils.getDaysInMonth((month-1+12)%12,year);var daysInMonth=self.utils.getDaysInMonth(month,year),days=window.document.createDocumentFragment(),isMultiMonth=self.config.showMonths>1,prevMonthDayClass=isMultiMonth?"prevMonthDay hidden":"prevMonthDay",nextMonthDayClass=isMultiMonth?"nextMonthDay hidden":"nextMonthDay";var dayNumber=prevMonthDays+1-firstOfMonth,dayIndex=0;for(;dayNumber<=prevMonthDays;dayNumber++,dayIndex++){days.appendChild(createDay("flatpickr-day "+prevMonthDayClass,new Date(year,month-1,dayNumber),dayNumber,dayIndex))}for(dayNumber=1;dayNumber<=daysInMonth;dayNumber++,dayIndex++){days.appendChild(createDay("flatpickr-day",new Date(year,month,dayNumber),dayNumber,dayIndex))}for(var dayNum=daysInMonth+1;dayNum<=42-firstOfMonth&&(self.config.showMonths===1||dayIndex%7!==0);dayNum++,dayIndex++){days.appendChild(createDay("flatpickr-day "+nextMonthDayClass,new Date(year,month+1,dayNum%daysInMonth),dayNum,dayIndex))}var dayContainer=createElement("div","dayContainer");dayContainer.appendChild(days);return dayContainer}function buildDays(){if(self.daysContainer===undefined){return}clearNode(self.daysContainer);if(self.weekNumbers)clearNode(self.weekNumbers);var frag=document.createDocumentFragment();for(var i=0;i<self.config.showMonths;i++){var d=new Date(self.currentYear,self.currentMonth,1);d.setMonth(self.currentMonth+i);frag.appendChild(buildMonthDays(d.getFullYear(),d.getMonth()))}self.daysContainer.appendChild(frag);self.days=self.daysContainer.firstChild;if(self.config.mode==="range"&&self.selectedDates.length===1){onMouseOver()}}function buildMonthSwitch(){if(self.config.showMonths>1||self.config.monthSelectorType!=="dropdown")return;var shouldBuildMonth=function(month){if(self.config.minDate!==undefined&&self.currentYear===self.config.minDate.getFullYear()&&month<self.config.minDate.getMonth()){return false}return!(self.config.maxDate!==undefined&&self.currentYear===self.config.maxDate.getFullYear()&&month>self.config.maxDate.getMonth())};self.monthsDropdownContainer.tabIndex=-1;self.monthsDropdownContainer.innerHTML="";for(var i=0;i<12;i++){if(!shouldBuildMonth(i))continue;var month=createElement("option","flatpickr-monthDropdown-month");month.value=new Date(self.currentYear,i).getMonth().toString();month.textContent=monthToStr(i,self.config.shorthandCurrentMonth,self.l10n);month.tabIndex=-1;if(self.currentMonth===i){month.selected=true}self.monthsDropdownContainer.appendChild(month)}}function buildMonth(){var container=createElement("div","flatpickr-month");var monthNavFragment=window.document.createDocumentFragment();var monthElement;if(self.config.showMonths>1||self.config.monthSelectorType==="static"){monthElement=createElement("span","cur-month")}else{self.monthsDropdownContainer=createElement("select","flatpickr-monthDropdown-months");self.monthsDropdownContainer.setAttribute("aria-label",self.l10n.monthAriaLabel);bind(self.monthsDropdownContainer,"change",function(e){var target=getEventTarget(e);var selectedMonth=parseInt(target.value,10);self.changeMonth(selectedMonth-self.currentMonth);triggerEvent("onMonthChange")});buildMonthSwitch();monthElement=self.monthsDropdownContainer}var yearInput=createNumberInput("cur-year",{tabindex:"-1"});var yearElement=yearInput.getElementsByTagName("input")[0];yearElement.setAttribute("aria-label",self.l10n.yearAriaLabel);if(self.config.minDate){yearElement.setAttribute("min",self.config.minDate.getFullYear().toString())}if(self.config.maxDate){yearElement.setAttribute("max",self.config.maxDate.getFullYear().toString());yearElement.disabled=!!self.config.minDate&&self.config.minDate.getFullYear()===self.config.maxDate.getFullYear()}var currentMonth=createElement("div","flatpickr-current-month");currentMonth.appendChild(monthElement);currentMonth.appendChild(yearInput);monthNavFragment.appendChild(currentMonth);container.appendChild(monthNavFragment);return{container:container,yearElement:yearElement,monthElement:monthElement}}function buildMonths(){clearNode(self.monthNav);self.monthNav.appendChild(self.prevMonthNav);if(self.config.showMonths){self.yearElements=[];self.monthElements=[]}for(var m=self.config.showMonths;m--;){var month=buildMonth();self.yearElements.push(month.yearElement);self.monthElements.push(month.monthElement);self.monthNav.appendChild(month.container)}self.monthNav.appendChild(self.nextMonthNav)}function buildMonthNav(){self.monthNav=createElement("div","flatpickr-months");self.yearElements=[];self.monthElements=[];self.prevMonthNav=createElement("span","flatpickr-prev-month");self.prevMonthNav.innerHTML=self.config.prevArrow;self.nextMonthNav=createElement("span","flatpickr-next-month");self.nextMonthNav.innerHTML=self.config.nextArrow;buildMonths();Object.defineProperty(self,"_hidePrevMonthArrow",{get:function(){return self.__hidePrevMonthArrow},set:function(bool){if(self.__hidePrevMonthArrow!==bool){toggleClass(self.prevMonthNav,"flatpickr-disabled",bool);self.__hidePrevMonthArrow=bool}}});Object.defineProperty(self,"_hideNextMonthArrow",{get:function(){return self.__hideNextMonthArrow},set:function(bool){if(self.__hideNextMonthArrow!==bool){toggleClass(self.nextMonthNav,"flatpickr-disabled",bool);self.__hideNextMonthArrow=bool}}});self.currentYearElement=self.yearElements[0];updateNavigationCurrentMonth();return self.monthNav}function buildTime(){self.calendarContainer.classList.add("hasTime");if(self.config.noCalendar)self.calendarContainer.classList.add("noCalendar");var defaults=getDefaultHours(self.config);self.timeContainer=createElement("div","flatpickr-time");self.timeContainer.tabIndex=-1;var separator=createElement("span","flatpickr-time-separator",":");var hourInput=createNumberInput("flatpickr-hour",{"aria-label":self.l10n.hourAriaLabel});self.hourElement=hourInput.getElementsByTagName("input")[0];var minuteInput=createNumberInput("flatpickr-minute",{"aria-label":self.l10n.minuteAriaLabel});self.minuteElement=minuteInput.getElementsByTagName("input")[0];self.hourElement.tabIndex=self.minuteElement.tabIndex=-1;self.hourElement.value=pad(self.latestSelectedDateObj?self.latestSelectedDateObj.getHours():self.config.time_24hr?defaults.hours:military2ampm(defaults.hours));self.minuteElement.value=pad(self.latestSelectedDateObj?self.latestSelectedDateObj.getMinutes():defaults.minutes);self.hourElement.setAttribute("step",self.config.hourIncrement.toString());self.minuteElement.setAttribute("step",self.config.minuteIncrement.toString());self.hourElement.setAttribute("min",self.config.time_24hr?"0":"1");self.hourElement.setAttribute("max",self.config.time_24hr?"23":"12");self.hourElement.setAttribute("maxlength","2");self.minuteElement.setAttribute("min","0");self.minuteElement.setAttribute("max","59");self.minuteElement.setAttribute("maxlength","2");self.timeContainer.appendChild(hourInput);self.timeContainer.appendChild(separator);self.timeContainer.appendChild(minuteInput);if(self.config.time_24hr)self.timeContainer.classList.add("time24hr");if(self.config.enableSeconds){self.timeContainer.classList.add("hasSeconds");var secondInput=createNumberInput("flatpickr-second");self.secondElement=secondInput.getElementsByTagName("input")[0];self.secondElement.value=pad(self.latestSelectedDateObj?self.latestSelectedDateObj.getSeconds():defaults.seconds);self.secondElement.setAttribute("step",self.minuteElement.getAttribute("step"));self.secondElement.setAttribute("min","0");self.secondElement.setAttribute("max","59");self.secondElement.setAttribute("maxlength","2");self.timeContainer.appendChild(createElement("span","flatpickr-time-separator",":"));self.timeContainer.appendChild(secondInput)}if(!self.config.time_24hr){self.amPM=createElement("span","flatpickr-am-pm",self.l10n.amPM[int((self.latestSelectedDateObj?self.hourElement.value:self.config.defaultHour)>11)]);self.amPM.title=self.l10n.toggleTitle;self.amPM.tabIndex=-1;self.timeContainer.appendChild(self.amPM)}return self.timeContainer}function buildWeekdays(){if(!self.weekdayContainer)self.weekdayContainer=createElement("div","flatpickr-weekdays");else clearNode(self.weekdayContainer);for(var i=self.config.showMonths;i--;){var container=createElement("div","flatpickr-weekdaycontainer");self.weekdayContainer.appendChild(container)}updateWeekdays();return self.weekdayContainer}function updateWeekdays(){if(!self.weekdayContainer){return}var firstDayOfWeek=self.l10n.firstDayOfWeek;var weekdays=__spreadArrays(self.l10n.weekdays.shorthand);if(firstDayOfWeek>0&&firstDayOfWeek<weekdays.length){weekdays=__spreadArrays(weekdays.splice(firstDayOfWeek,weekdays.length),weekdays.splice(0,firstDayOfWeek))}for(var i=self.config.showMonths;i--;){self.weekdayContainer.children[i].innerHTML="\n      <span class='flatpickr-weekday'>\n        "+weekdays.join("</span><span class='flatpickr-weekday'>")+"\n      </span>\n      "}}function buildWeeks(){self.calendarContainer.classList.add("hasWeeks");var weekWrapper=createElement("div","flatpickr-weekwrapper");weekWrapper.appendChild(createElement("span","flatpickr-weekday",self.l10n.weekAbbreviation));var weekNumbers=createElement("div","flatpickr-weeks");weekWrapper.appendChild(weekNumbers);return{weekWrapper:weekWrapper,weekNumbers:weekNumbers}}function changeMonth(value,isOffset){if(isOffset===void 0){isOffset=true}var delta=isOffset?value:value-self.currentMonth;if(delta<0&&self._hidePrevMonthArrow===true||delta>0&&self._hideNextMonthArrow===true)return;self.currentMonth+=delta;if(self.currentMonth<0||self.currentMonth>11){self.currentYear+=self.currentMonth>11?1:-1;self.currentMonth=(self.currentMonth+12)%12;triggerEvent("onYearChange");buildMonthSwitch()}buildDays();triggerEvent("onMonthChange");updateNavigationCurrentMonth()}function clear(triggerChangeEvent,toInitial){if(triggerChangeEvent===void 0){triggerChangeEvent=true}if(toInitial===void 0){toInitial=true}self.input.value="";if(self.altInput!==undefined)self.altInput.value="";if(self.mobileInput!==undefined)self.mobileInput.value="";self.selectedDates=[];self.latestSelectedDateObj=undefined;if(toInitial===true){self.currentYear=self._initialDate.getFullYear();self.currentMonth=self._initialDate.getMonth()}if(self.config.enableTime===true){var _a=getDefaultHours(self.config),hours=_a.hours,minutes=_a.minutes,seconds=_a.seconds;setHours(hours,minutes,seconds)}self.redraw();if(triggerChangeEvent)triggerEvent("onChange")}function close(){self.isOpen=false;if(!self.isMobile){if(self.calendarContainer!==undefined){self.calendarContainer.classList.remove("open")}if(self._input!==undefined){self._input.classList.remove("active")}}triggerEvent("onClose")}function destroy(){if(self.config!==undefined)triggerEvent("onDestroy");for(var i=self._handlers.length;i--;){self._handlers[i].remove()}self._handlers=[];if(self.mobileInput){if(self.mobileInput.parentNode)self.mobileInput.parentNode.removeChild(self.mobileInput);self.mobileInput=undefined}else if(self.calendarContainer&&self.calendarContainer.parentNode){if(self.config.static&&self.calendarContainer.parentNode){var wrapper=self.calendarContainer.parentNode;wrapper.lastChild&&wrapper.removeChild(wrapper.lastChild);if(wrapper.parentNode){while(wrapper.firstChild)wrapper.parentNode.insertBefore(wrapper.firstChild,wrapper);wrapper.parentNode.removeChild(wrapper)}}else self.calendarContainer.parentNode.removeChild(self.calendarContainer)}if(self.altInput){self.input.type="text";if(self.altInput.parentNode)self.altInput.parentNode.removeChild(self.altInput);delete self.altInput}if(self.input){self.input.type=self.input._type;self.input.classList.remove("flatpickr-input");self.input.removeAttribute("readonly")}["_showTimeInput","latestSelectedDateObj","_hideNextMonthArrow","_hidePrevMonthArrow","__hideNextMonthArrow","__hidePrevMonthArrow","isMobile","isOpen","selectedDateElem","minDateHasTime","maxDateHasTime","days","daysContainer","_input","_positionElement","innerContainer","rContainer","monthNav","todayDateElem","calendarContainer","weekdayContainer","prevMonthNav","nextMonthNav","monthsDropdownContainer","currentMonthElement","currentYearElement","navigationCurrentMonth","selectedDateElem","config"].forEach(function(k){try{delete self[k]}catch(_){}})}function isCalendarElem(elem){return self.calendarContainer.contains(elem)}function documentClick(e){if(self.isOpen&&!self.config.inline){var eventTarget_1=getEventTarget(e);var isCalendarElement=isCalendarElem(eventTarget_1);var isInput=eventTarget_1===self.input||eventTarget_1===self.altInput||self.element.contains(eventTarget_1)||e.path&&e.path.indexOf&&(~e.path.indexOf(self.input)||~e.path.indexOf(self.altInput));var lostFocus=!isInput&&!isCalendarElement&&!isCalendarElem(e.relatedTarget);var isIgnored=!self.config.ignoredFocusElements.some(function(elem){return elem.contains(eventTarget_1)});if(lostFocus&&isIgnored){if(self.config.allowInput){self.setDate(self._input.value,false,self.config.altInput?self.config.altFormat:self.config.dateFormat)}if(self.timeContainer!==undefined&&self.minuteElement!==undefined&&self.hourElement!==undefined&&self.input.value!==""&&self.input.value!==undefined){updateTime()}self.close();if(self.config&&self.config.mode==="range"&&self.selectedDates.length===1)self.clear(false)}}}function changeYear(newYear){if(!newYear||self.config.minDate&&newYear<self.config.minDate.getFullYear()||self.config.maxDate&&newYear>self.config.maxDate.getFullYear())return;var newYearNum=newYear,isNewYear=self.currentYear!==newYearNum;self.currentYear=newYearNum||self.currentYear;if(self.config.maxDate&&self.currentYear===self.config.maxDate.getFullYear()){self.currentMonth=Math.min(self.config.maxDate.getMonth(),self.currentMonth)}else if(self.config.minDate&&self.currentYear===self.config.minDate.getFullYear()){self.currentMonth=Math.max(self.config.minDate.getMonth(),self.currentMonth)}if(isNewYear){self.redraw();triggerEvent("onYearChange");buildMonthSwitch()}}function isEnabled(date,timeless){var _a;if(timeless===void 0){timeless=true}var dateToCheck=self.parseDate(date,undefined,timeless);if(self.config.minDate&&dateToCheck&&compareDates(dateToCheck,self.config.minDate,timeless!==undefined?timeless:!self.minDateHasTime)<0||self.config.maxDate&&dateToCheck&&compareDates(dateToCheck,self.config.maxDate,timeless!==undefined?timeless:!self.maxDateHasTime)>0)return false;if(!self.config.enable&&self.config.disable.length===0)return true;if(dateToCheck===undefined)return false;var bool=!!self.config.enable,array=(_a=self.config.enable)!==null&&_a!==void 0?_a:self.config.disable;for(var i=0,d=void 0;i<array.length;i++){d=array[i];if(typeof d==="function"&&d(dateToCheck))return bool;else if(d instanceof Date&&dateToCheck!==undefined&&d.getTime()===dateToCheck.getTime())return bool;else if(typeof d==="string"){var parsed=self.parseDate(d,undefined,true);return parsed&&parsed.getTime()===dateToCheck.getTime()?bool:!bool}else if(typeof d==="object"&&dateToCheck!==undefined&&d.from&&d.to&&dateToCheck.getTime()>=d.from.getTime()&&dateToCheck.getTime()<=d.to.getTime())return bool}return!bool}function isInView(elem){if(self.daysContainer!==undefined)return elem.className.indexOf("hidden")===-1&&elem.className.indexOf("flatpickr-disabled")===-1&&self.daysContainer.contains(elem);return false}function onBlur(e){var isInput=e.target===self._input;var valueChanged=self._input.value.trimEnd()!==getDateStr();if(isInput&&valueChanged&&!(e.relatedTarget&&isCalendarElem(e.relatedTarget))){self.setDate(self._input.value,true,e.target===self.altInput?self.config.altFormat:self.config.dateFormat)}}function onKeyDown(e){var eventTarget=getEventTarget(e);var isInput=self.config.wrap?element.contains(eventTarget):eventTarget===self._input;var allowInput=self.config.allowInput;var allowKeydown=self.isOpen&&(!allowInput||!isInput);var allowInlineKeydown=self.config.inline&&isInput&&!allowInput;if(e.keyCode===13&&isInput){if(allowInput){self.setDate(self._input.value,true,eventTarget===self.altInput?self.config.altFormat:self.config.dateFormat);self.close();return eventTarget.blur()}else{self.open()}}else if(isCalendarElem(eventTarget)||allowKeydown||allowInlineKeydown){var isTimeObj=!!self.timeContainer&&self.timeContainer.contains(eventTarget);switch(e.keyCode){case 13:if(isTimeObj){e.preventDefault();updateTime();focusAndClose()}else selectDate(e);break;case 27:e.preventDefault();focusAndClose();break;case 8:case 46:if(isInput&&!self.config.allowInput){e.preventDefault();self.clear()}break;case 37:case 39:if(!isTimeObj&&!isInput){e.preventDefault();var activeElement=getClosestActiveElement();if(self.daysContainer!==undefined&&(allowInput===false||activeElement&&isInView(activeElement))){var delta_1=e.keyCode===39?1:-1;if(!e.ctrlKey)focusOnDay(undefined,delta_1);else{e.stopPropagation();changeMonth(delta_1);focusOnDay(getFirstAvailableDay(1),0)}}}else if(self.hourElement)self.hourElement.focus();break;case 38:case 40:e.preventDefault();var delta=e.keyCode===40?1:-1;if(self.daysContainer&&eventTarget.$i!==undefined||eventTarget===self.input||eventTarget===self.altInput){if(e.ctrlKey){e.stopPropagation();changeYear(self.currentYear-delta);focusOnDay(getFirstAvailableDay(1),0)}else if(!isTimeObj)focusOnDay(undefined,delta*7)}else if(eventTarget===self.currentYearElement){changeYear(self.currentYear-delta)}else if(self.config.enableTime){if(!isTimeObj&&self.hourElement)self.hourElement.focus();updateTime(e);self._debouncedChange()}break;case 9:if(isTimeObj){var elems=[self.hourElement,self.minuteElement,self.secondElement,self.amPM].concat(self.pluginElements).filter(function(x){return x});var i=elems.indexOf(eventTarget);if(i!==-1){var target=elems[i+(e.shiftKey?-1:1)];e.preventDefault();(target||self._input).focus()}}else if(!self.config.noCalendar&&self.daysContainer&&self.daysContainer.contains(eventTarget)&&e.shiftKey){e.preventDefault();self._input.focus()}break}}if(self.amPM!==undefined&&eventTarget===self.amPM){switch(e.key){case self.l10n.amPM[0].charAt(0):case self.l10n.amPM[0].charAt(0).toLowerCase():self.amPM.textContent=self.l10n.amPM[0];setHoursFromInputs();updateValue();break;case self.l10n.amPM[1].charAt(0):case self.l10n.amPM[1].charAt(0).toLowerCase():self.amPM.textContent=self.l10n.amPM[1];setHoursFromInputs();updateValue();break}}if(isInput||isCalendarElem(eventTarget)){triggerEvent("onKeyDown",e)}}function onMouseOver(elem,cellClass){if(cellClass===void 0){cellClass="flatpickr-day"}if(self.selectedDates.length!==1||elem&&(!elem.classList.contains(cellClass)||elem.classList.contains("flatpickr-disabled")))return;var hoverDate=elem?elem.dateObj.getTime():self.days.firstElementChild.dateObj.getTime(),initialDate=self.parseDate(self.selectedDates[0],undefined,true).getTime(),rangeStartDate=Math.min(hoverDate,self.selectedDates[0].getTime()),rangeEndDate=Math.max(hoverDate,self.selectedDates[0].getTime());var containsDisabled=false;var minRange=0,maxRange=0;for(var t=rangeStartDate;t<rangeEndDate;t+=duration.DAY){if(!isEnabled(new Date(t),true)){containsDisabled=containsDisabled||t>rangeStartDate&&t<rangeEndDate;if(t<initialDate&&(!minRange||t>minRange))minRange=t;else if(t>initialDate&&(!maxRange||t<maxRange))maxRange=t}}var hoverableCells=Array.from(self.rContainer.querySelectorAll("*:nth-child(-n+"+self.config.showMonths+") > ."+cellClass));hoverableCells.forEach(function(dayElem){var date=dayElem.dateObj;var timestamp=date.getTime();var outOfRange=minRange>0&&timestamp<minRange||maxRange>0&&timestamp>maxRange;if(outOfRange){dayElem.classList.add("notAllowed");["inRange","startRange","endRange"].forEach(function(c){dayElem.classList.remove(c)});return}else if(containsDisabled&&!outOfRange)return;["startRange","inRange","endRange","notAllowed"].forEach(function(c){dayElem.classList.remove(c)});if(elem!==undefined){elem.classList.add(hoverDate<=self.selectedDates[0].getTime()?"startRange":"endRange");if(initialDate<hoverDate&&timestamp===initialDate)dayElem.classList.add("startRange");else if(initialDate>hoverDate&&timestamp===initialDate)dayElem.classList.add("endRange");if(timestamp>=minRange&&(maxRange===0||timestamp<=maxRange)&&isBetween(timestamp,initialDate,hoverDate))dayElem.classList.add("inRange")}})}function onResize(){if(self.isOpen&&!self.config.static&&!self.config.inline)positionCalendar()}function open(e,positionElement){if(positionElement===void 0){positionElement=self._positionElement}if(self.isMobile===true){if(e){e.preventDefault();var eventTarget=getEventTarget(e);if(eventTarget){eventTarget.blur()}}if(self.mobileInput!==undefined){self.mobileInput.focus();self.mobileInput.click()}triggerEvent("onOpen");return}else if(self._input.disabled||self.config.inline){return}var wasOpen=self.isOpen;self.isOpen=true;if(!wasOpen){self.calendarContainer.classList.add("open");self._input.classList.add("active");triggerEvent("onOpen");positionCalendar(positionElement)}if(self.config.enableTime===true&&self.config.noCalendar===true){if(self.config.allowInput===false&&(e===undefined||!self.timeContainer.contains(e.relatedTarget))){setTimeout(function(){return self.hourElement.select()},50)}}}function minMaxDateSetter(type){return function(date){var dateObj=self.config["_"+type+"Date"]=self.parseDate(date,self.config.dateFormat);var inverseDateObj=self.config["_"+(type==="min"?"max":"min")+"Date"];if(dateObj!==undefined){self[type==="min"?"minDateHasTime":"maxDateHasTime"]=dateObj.getHours()>0||dateObj.getMinutes()>0||dateObj.getSeconds()>0}if(self.selectedDates){self.selectedDates=self.selectedDates.filter(function(d){return isEnabled(d)});if(!self.selectedDates.length&&type==="min")setHoursFromDate(dateObj);updateValue()}if(self.daysContainer){redraw();if(dateObj!==undefined)self.currentYearElement[type]=dateObj.getFullYear().toString();else self.currentYearElement.removeAttribute(type);self.currentYearElement.disabled=!!inverseDateObj&&dateObj!==undefined&&inverseDateObj.getFullYear()===dateObj.getFullYear()}}}function parseConfig(){var boolOpts=["wrap","weekNumbers","allowInput","allowInvalidPreload","clickOpens","time_24hr","enableTime","noCalendar","altInput","shorthandCurrentMonth","inline","static","enableSeconds","disableMobile"];var userConfig=__assign(__assign({},JSON.parse(JSON.stringify(element.dataset||{}))),instanceConfig);var formats={};self.config.parseDate=userConfig.parseDate;self.config.formatDate=userConfig.formatDate;Object.defineProperty(self.config,"enable",{get:function(){return self.config._enable},set:function(dates){self.config._enable=parseDateRules(dates)}});Object.defineProperty(self.config,"disable",{get:function(){return self.config._disable},set:function(dates){self.config._disable=parseDateRules(dates)}});var timeMode=userConfig.mode==="time";if(!userConfig.dateFormat&&(userConfig.enableTime||timeMode)){var defaultDateFormat=flatpickr.defaultConfig.dateFormat||defaults.dateFormat;formats.dateFormat=userConfig.noCalendar||timeMode?"H:i"+(userConfig.enableSeconds?":S":""):defaultDateFormat+" H:i"+(userConfig.enableSeconds?":S":"")}if(userConfig.altInput&&(userConfig.enableTime||timeMode)&&!userConfig.altFormat){var defaultAltFormat=flatpickr.defaultConfig.altFormat||defaults.altFormat;formats.altFormat=userConfig.noCalendar||timeMode?"h:i"+(userConfig.enableSeconds?":S K":" K"):defaultAltFormat+(" h:i"+(userConfig.enableSeconds?":S":"")+" K")}Object.defineProperty(self.config,"minDate",{get:function(){return self.config._minDate},set:minMaxDateSetter("min")});Object.defineProperty(self.config,"maxDate",{get:function(){return self.config._maxDate},set:minMaxDateSetter("max")});var minMaxTimeSetter=function(type){return function(val){self.config[type==="min"?"_minTime":"_maxTime"]=self.parseDate(val,"H:i:S")}};Object.defineProperty(self.config,"minTime",{get:function(){return self.config._minTime},set:minMaxTimeSetter("min")});Object.defineProperty(self.config,"maxTime",{get:function(){return self.config._maxTime},set:minMaxTimeSetter("max")});if(userConfig.mode==="time"){self.config.noCalendar=true;self.config.enableTime=true}Object.assign(self.config,formats,userConfig);for(var i=0;i<boolOpts.length;i++)self.config[boolOpts[i]]=self.config[boolOpts[i]]===true||self.config[boolOpts[i]]==="true";HOOKS.filter(function(hook){return self.config[hook]!==undefined}).forEach(function(hook){self.config[hook]=arrayify(self.config[hook]||[]).map(bindToInstance)});self.isMobile=!self.config.disableMobile&&!self.config.inline&&self.config.mode==="single"&&!self.config.disable.length&&!self.config.enable&&!self.config.weekNumbers&&/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);for(var i=0;i<self.config.plugins.length;i++){var pluginConf=self.config.plugins[i](self)||{};for(var key in pluginConf){if(HOOKS.indexOf(key)>-1){self.config[key]=arrayify(pluginConf[key]).map(bindToInstance).concat(self.config[key])}else if(typeof userConfig[key]==="undefined")self.config[key]=pluginConf[key]}}if(!userConfig.altInputClass){self.config.altInputClass=getInputElem().className+" "+self.config.altInputClass}triggerEvent("onParseConfig")}function getInputElem(){return self.config.wrap?element.querySelector("[data-input]"):element}function setupLocale(){if(typeof self.config.locale!=="object"&&typeof flatpickr.l10ns[self.config.locale]==="undefined")self.config.errorHandler(new Error("flatpickr: invalid locale "+self.config.locale));self.l10n=__assign(__assign({},flatpickr.l10ns.default),typeof self.config.locale==="object"?self.config.locale:self.config.locale!=="default"?flatpickr.l10ns[self.config.locale]:undefined);tokenRegex.D="("+self.l10n.weekdays.shorthand.join("|")+")";tokenRegex.l="("+self.l10n.weekdays.longhand.join("|")+")";tokenRegex.M="("+self.l10n.months.shorthand.join("|")+")";tokenRegex.F="("+self.l10n.months.longhand.join("|")+")";tokenRegex.K="("+self.l10n.amPM[0]+"|"+self.l10n.amPM[1]+"|"+self.l10n.amPM[0].toLowerCase()+"|"+self.l10n.amPM[1].toLowerCase()+")";var userConfig=__assign(__assign({},instanceConfig),JSON.parse(JSON.stringify(element.dataset||{})));if(userConfig.time_24hr===undefined&&flatpickr.defaultConfig.time_24hr===undefined){self.config.time_24hr=self.l10n.time_24hr}self.formatDate=createDateFormatter(self);self.parseDate=createDateParser({config:self.config,l10n:self.l10n})}function positionCalendar(customPositionElement){if(typeof self.config.position==="function"){return void self.config.position(self,customPositionElement)}if(self.calendarContainer===undefined)return;triggerEvent("onPreCalendarPosition");var positionElement=customPositionElement||self._positionElement;var calendarHeight=Array.prototype.reduce.call(self.calendarContainer.children,function(acc,child){return acc+child.offsetHeight},0),calendarWidth=self.calendarContainer.offsetWidth,configPos=self.config.position.split(" "),configPosVertical=configPos[0],configPosHorizontal=configPos.length>1?configPos[1]:null,inputBounds=positionElement.getBoundingClientRect(),distanceFromBottom=window.innerHeight-inputBounds.bottom,showOnTop=configPosVertical==="above"||configPosVertical!=="below"&&distanceFromBottom<calendarHeight&&inputBounds.top>calendarHeight;var top=window.pageYOffset+inputBounds.top+(!showOnTop?positionElement.offsetHeight+2:-calendarHeight-2);toggleClass(self.calendarContainer,"arrowTop",!showOnTop);toggleClass(self.calendarContainer,"arrowBottom",showOnTop);if(self.config.inline)return;var left=window.pageXOffset+inputBounds.left;var isCenter=false;var isRight=false;if(configPosHorizontal==="center"){left-=(calendarWidth-inputBounds.width)/2;isCenter=true}else if(configPosHorizontal==="right"){left-=calendarWidth-inputBounds.width;isRight=true}toggleClass(self.calendarContainer,"arrowLeft",!isCenter&&!isRight);toggleClass(self.calendarContainer,"arrowCenter",isCenter);toggleClass(self.calendarContainer,"arrowRight",isRight);var right=window.document.body.offsetWidth-(window.pageXOffset+inputBounds.right);var rightMost=left+calendarWidth>window.document.body.offsetWidth;var centerMost=right+calendarWidth>window.document.body.offsetWidth;toggleClass(self.calendarContainer,"rightMost",rightMost);if(self.config.static)return;self.calendarContainer.style.top=top+"px";if(!rightMost){self.calendarContainer.style.left=left+"px";self.calendarContainer.style.right="auto"}else if(!centerMost){self.calendarContainer.style.left="auto";self.calendarContainer.style.right=right+"px"}else{var doc=getDocumentStyleSheet();if(doc===undefined)return;var bodyWidth=window.document.body.offsetWidth;var centerLeft=Math.max(0,bodyWidth/2-calendarWidth/2);var centerBefore=".flatpickr-calendar.centerMost:before";var centerAfter=".flatpickr-calendar.centerMost:after";var centerIndex=doc.cssRules.length;var centerStyle="{left:"+inputBounds.left+"px;right:auto;}";toggleClass(self.calendarContainer,"rightMost",false);toggleClass(self.calendarContainer,"centerMost",true);doc.insertRule(centerBefore+","+centerAfter+centerStyle,centerIndex);self.calendarContainer.style.left=centerLeft+"px";self.calendarContainer.style.right="auto"}}function getDocumentStyleSheet(){var editableSheet=null;for(var i=0;i<document.styleSheets.length;i++){var sheet=document.styleSheets[i];if(!sheet.cssRules)continue;try{sheet.cssRules}catch(err){continue}editableSheet=sheet;break}return editableSheet!=null?editableSheet:createStyleSheet()}function createStyleSheet(){var style=document.createElement("style");document.head.appendChild(style);return style.sheet}function redraw(){if(self.config.noCalendar||self.isMobile)return;buildMonthSwitch();updateNavigationCurrentMonth();buildDays()}function focusAndClose(){self._input.focus();if(window.navigator.userAgent.indexOf("MSIE")!==-1||navigator.msMaxTouchPoints!==undefined){setTimeout(self.close,0)}else{self.close()}}function selectDate(e){e.preventDefault();e.stopPropagation();var isSelectable=function(day){return day.classList&&day.classList.contains("flatpickr-day")&&!day.classList.contains("flatpickr-disabled")&&!day.classList.contains("notAllowed")};var t=findParent(getEventTarget(e),isSelectable);if(t===undefined)return;var target=t;var selectedDate=self.latestSelectedDateObj=new Date(target.dateObj.getTime());var shouldChangeMonth=(selectedDate.getMonth()<self.currentMonth||selectedDate.getMonth()>self.currentMonth+self.config.showMonths-1)&&self.config.mode!=="range";self.selectedDateElem=target;if(self.config.mode==="single")self.selectedDates=[selectedDate];else if(self.config.mode==="multiple"){var selectedIndex=isDateSelected(selectedDate);if(selectedIndex)self.selectedDates.splice(parseInt(selectedIndex),1);else self.selectedDates.push(selectedDate)}else if(self.config.mode==="range"){if(self.selectedDates.length===2){self.clear(false,false)}self.latestSelectedDateObj=selectedDate;self.selectedDates.push(selectedDate);if(compareDates(selectedDate,self.selectedDates[0],true)!==0)self.selectedDates.sort(function(a,b){return a.getTime()-b.getTime()})}setHoursFromInputs();if(shouldChangeMonth){var isNewYear=self.currentYear!==selectedDate.getFullYear();self.currentYear=selectedDate.getFullYear();self.currentMonth=selectedDate.getMonth();if(isNewYear){triggerEvent("onYearChange");buildMonthSwitch()}triggerEvent("onMonthChange")}updateNavigationCurrentMonth();buildDays();updateValue();if(!shouldChangeMonth&&self.config.mode!=="range"&&self.config.showMonths===1)focusOnDayElem(target);else if(self.selectedDateElem!==undefined&&self.hourElement===undefined){self.selectedDateElem&&self.selectedDateElem.focus()}if(self.hourElement!==undefined)self.hourElement!==undefined&&self.hourElement.focus();if(self.config.closeOnSelect){var single=self.config.mode==="single"&&!self.config.enableTime;var range=self.config.mode==="range"&&self.selectedDates.length===2&&!self.config.enableTime;if(single||range){focusAndClose()}}triggerChange()}var CALLBACKS={locale:[setupLocale,updateWeekdays],showMonths:[buildMonths,setCalendarWidth,buildWeekdays],minDate:[jumpToDate],maxDate:[jumpToDate],positionElement:[updatePositionElement],clickOpens:[function(){if(self.config.clickOpens===true){bind(self._input,"focus",self.open);bind(self._input,"click",self.open)}else{self._input.removeEventListener("focus",self.open);self._input.removeEventListener("click",self.open)}}]};function set(option,value){if(option!==null&&typeof option==="object"){Object.assign(self.config,option);for(var key in option){if(CALLBACKS[key]!==undefined)CALLBACKS[key].forEach(function(x){return x()})}}else{self.config[option]=value;if(CALLBACKS[option]!==undefined)CALLBACKS[option].forEach(function(x){return x()});else if(HOOKS.indexOf(option)>-1)self.config[option]=arrayify(value)}self.redraw();updateValue(true)}function setSelectedDate(inputDate,format){var dates=[];if(inputDate instanceof Array)dates=inputDate.map(function(d){return self.parseDate(d,format)});else if(inputDate instanceof Date||typeof inputDate==="number")dates=[self.parseDate(inputDate,format)];else if(typeof inputDate==="string"){switch(self.config.mode){case"single":case"time":dates=[self.parseDate(inputDate,format)];break;case"multiple":dates=inputDate.split(self.config.conjunction).map(function(date){return self.parseDate(date,format)});break;case"range":dates=inputDate.split(self.l10n.rangeSeparator).map(function(date){return self.parseDate(date,format)});break}}else self.config.errorHandler(new Error("Invalid date supplied: "+JSON.stringify(inputDate)));self.selectedDates=self.config.allowInvalidPreload?dates:dates.filter(function(d){return d instanceof Date&&isEnabled(d,false)});if(self.config.mode==="range")self.selectedDates.sort(function(a,b){return a.getTime()-b.getTime()})}function setDate(date,triggerChange,format){if(triggerChange===void 0){triggerChange=false}if(format===void 0){format=self.config.dateFormat}if(date!==0&&!date||date instanceof Array&&date.length===0)return self.clear(triggerChange);setSelectedDate(date,format);self.latestSelectedDateObj=self.selectedDates[self.selectedDates.length-1];self.redraw();jumpToDate(undefined,triggerChange);setHoursFromDate();if(self.selectedDates.length===0){self.clear(false)}updateValue(triggerChange);if(triggerChange)triggerEvent("onChange")}function parseDateRules(arr){return arr.slice().map(function(rule){if(typeof rule==="string"||typeof rule==="number"||rule instanceof Date){return self.parseDate(rule,undefined,true)}else if(rule&&typeof rule==="object"&&rule.from&&rule.to)return{from:self.parseDate(rule.from,undefined),to:self.parseDate(rule.to,undefined)};return rule}).filter(function(x){return x})}function setupDates(){self.selectedDates=[];self.now=self.parseDate(self.config.now)||new Date;var preloadedDate=self.config.defaultDate||((self.input.nodeName==="INPUT"||self.input.nodeName==="TEXTAREA")&&self.input.placeholder&&self.input.value===self.input.placeholder?null:self.input.value);if(preloadedDate)setSelectedDate(preloadedDate,self.config.dateFormat);self._initialDate=self.selectedDates.length>0?self.selectedDates[0]:self.config.minDate&&self.config.minDate.getTime()>self.now.getTime()?self.config.minDate:self.config.maxDate&&self.config.maxDate.getTime()<self.now.getTime()?self.config.maxDate:self.now;self.currentYear=self._initialDate.getFullYear();self.currentMonth=self._initialDate.getMonth();if(self.selectedDates.length>0)self.latestSelectedDateObj=self.selectedDates[0];if(self.config.minTime!==undefined)self.config.minTime=self.parseDate(self.config.minTime,"H:i");if(self.config.maxTime!==undefined)self.config.maxTime=self.parseDate(self.config.maxTime,"H:i");self.minDateHasTime=!!self.config.minDate&&(self.config.minDate.getHours()>0||self.config.minDate.getMinutes()>0||self.config.minDate.getSeconds()>0);self.maxDateHasTime=!!self.config.maxDate&&(self.config.maxDate.getHours()>0||self.config.maxDate.getMinutes()>0||self.config.maxDate.getSeconds()>0)}function setupInputs(){self.input=getInputElem();if(!self.input){self.config.errorHandler(new Error("Invalid input element specified"));return}self.input._type=self.input.type;self.input.type="text";self.input.classList.add("flatpickr-input");self._input=self.input;if(self.config.altInput){self.altInput=createElement(self.input.nodeName,self.config.altInputClass);self._input=self.altInput;self.altInput.placeholder=self.input.placeholder;self.altInput.disabled=self.input.disabled;self.altInput.required=self.input.required;self.altInput.tabIndex=self.input.tabIndex;self.altInput.type="text";self.input.setAttribute("type","hidden");if(!self.config.static&&self.input.parentNode)self.input.parentNode.insertBefore(self.altInput,self.input.nextSibling)}if(!self.config.allowInput)self._input.setAttribute("readonly","readonly");updatePositionElement()}function updatePositionElement(){self._positionElement=self.config.positionElement||self._input}function setupMobile(){var inputType=self.config.enableTime?self.config.noCalendar?"time":"datetime-local":"date";self.mobileInput=createElement("input",self.input.className+" flatpickr-mobile");self.mobileInput.tabIndex=1;self.mobileInput.type=inputType;self.mobileInput.disabled=self.input.disabled;self.mobileInput.required=self.input.required;self.mobileInput.placeholder=self.input.placeholder;self.mobileFormatStr=inputType==="datetime-local"?"Y-m-d\\TH:i:S":inputType==="date"?"Y-m-d":"H:i:S";if(self.selectedDates.length>0){self.mobileInput.defaultValue=self.mobileInput.value=self.formatDate(self.selectedDates[0],self.mobileFormatStr)}if(self.config.minDate)self.mobileInput.min=self.formatDate(self.config.minDate,"Y-m-d");if(self.config.maxDate)self.mobileInput.max=self.formatDate(self.config.maxDate,"Y-m-d");if(self.input.getAttribute("step"))self.mobileInput.step=String(self.input.getAttribute("step"));self.input.type="hidden";if(self.altInput!==undefined)self.altInput.type="hidden";try{if(self.input.parentNode)self.input.parentNode.insertBefore(self.mobileInput,self.input.nextSibling)}catch(_a){}bind(self.mobileInput,"change",function(e){self.setDate(getEventTarget(e).value,false,self.mobileFormatStr);triggerEvent("onChange");triggerEvent("onClose")})}function toggle(e){if(self.isOpen===true)return self.close();self.open(e)}function triggerEvent(event,data){if(self.config===undefined)return;var hooks=self.config[event];if(hooks!==undefined&&hooks.length>0){for(var i=0;hooks[i]&&i<hooks.length;i++)hooks[i](self.selectedDates,self.input.value,self,data)}if(event==="onChange"){self.input.dispatchEvent(createEvent("change"));self.input.dispatchEvent(createEvent("input"))}}function createEvent(name){var e=document.createEvent("Event");e.initEvent(name,true,true);return e}function isDateSelected(date){for(var i=0;i<self.selectedDates.length;i++){var selectedDate=self.selectedDates[i];if(selectedDate instanceof Date&&compareDates(selectedDate,date)===0)return""+i}return false}function isDateInRange(date){if(self.config.mode!=="range"||self.selectedDates.length<2)return false;return compareDates(date,self.selectedDates[0])>=0&&compareDates(date,self.selectedDates[1])<=0}function updateNavigationCurrentMonth(){if(self.config.noCalendar||self.isMobile||!self.monthNav)return;self.yearElements.forEach(function(yearElement,i){var d=new Date(self.currentYear,self.currentMonth,1);d.setMonth(self.currentMonth+i);if(self.config.showMonths>1||self.config.monthSelectorType==="static"){self.monthElements[i].textContent=monthToStr(d.getMonth(),self.config.shorthandCurrentMonth,self.l10n)+" "}else{self.monthsDropdownContainer.value=d.getMonth().toString()}yearElement.value=d.getFullYear().toString()});self._hidePrevMonthArrow=self.config.minDate!==undefined&&(self.currentYear===self.config.minDate.getFullYear()?self.currentMonth<=self.config.minDate.getMonth():self.currentYear<self.config.minDate.getFullYear());self._hideNextMonthArrow=self.config.maxDate!==undefined&&(self.currentYear===self.config.maxDate.getFullYear()?self.currentMonth+1>self.config.maxDate.getMonth():self.currentYear>self.config.maxDate.getFullYear())}function getDateStr(specificFormat){var format=specificFormat||(self.config.altInput?self.config.altFormat:self.config.dateFormat);return self.selectedDates.map(function(dObj){return self.formatDate(dObj,format)}).filter(function(d,i,arr){return self.config.mode!=="range"||self.config.enableTime||arr.indexOf(d)===i}).join(self.config.mode!=="range"?self.config.conjunction:self.l10n.rangeSeparator)}function updateValue(triggerChange){if(triggerChange===void 0){triggerChange=true}if(self.mobileInput!==undefined&&self.mobileFormatStr){self.mobileInput.value=self.latestSelectedDateObj!==undefined?self.formatDate(self.latestSelectedDateObj,self.mobileFormatStr):""}self.input.value=getDateStr(self.config.dateFormat);if(self.altInput!==undefined){self.altInput.value=getDateStr(self.config.altFormat)}if(triggerChange!==false)triggerEvent("onValueUpdate")}function onMonthNavClick(e){var eventTarget=getEventTarget(e);var isPrevMonth=self.prevMonthNav.contains(eventTarget);var isNextMonth=self.nextMonthNav.contains(eventTarget);if(isPrevMonth||isNextMonth){changeMonth(isPrevMonth?-1:1)}else if(self.yearElements.indexOf(eventTarget)>=0){eventTarget.select()}else if(eventTarget.classList.contains("arrowUp")){self.changeYear(self.currentYear+1)}else if(eventTarget.classList.contains("arrowDown")){self.changeYear(self.currentYear-1)}}function timeWrapper(e){e.preventDefault();var isKeyDown=e.type==="keydown",eventTarget=getEventTarget(e),input=eventTarget;if(self.amPM!==undefined&&eventTarget===self.amPM){self.amPM.textContent=self.l10n.amPM[int(self.amPM.textContent===self.l10n.amPM[0])]}var min=parseFloat(input.getAttribute("min")),max=parseFloat(input.getAttribute("max")),step=parseFloat(input.getAttribute("step")),curValue=parseInt(input.value,10),delta=e.delta||(isKeyDown?e.which===38?1:-1:0);var newValue=curValue+step*delta;if(typeof input.value!=="undefined"&&input.value.length===2){var isHourElem=input===self.hourElement,isMinuteElem=input===self.minuteElement;if(newValue<min){newValue=max+newValue+int(!isHourElem)+(int(isHourElem)&&int(!self.amPM));if(isMinuteElem)incrementNumInput(undefined,-1,self.hourElement)}else if(newValue>max){newValue=input===self.hourElement?newValue-max-int(!self.amPM):min;if(isMinuteElem)incrementNumInput(undefined,1,self.hourElement)}if(self.amPM&&isHourElem&&(step===1?newValue+curValue===23:Math.abs(newValue-curValue)>step)){self.amPM.textContent=self.l10n.amPM[int(self.amPM.textContent===self.l10n.amPM[0])]}input.value=pad(newValue)}}init();return self}function _flatpickr(nodeList,config){var nodes=Array.prototype.slice.call(nodeList).filter(function(x){return x instanceof HTMLElement});var instances=[];for(var i=0;i<nodes.length;i++){var node=nodes[i];try{if(node.getAttribute("data-fp-omit")!==null)continue;if(node._flatpickr!==undefined){node._flatpickr.destroy();node._flatpickr=undefined}node._flatpickr=FlatpickrInstance(node,config||{});instances.push(node._flatpickr)}catch(e){console.error(e)}}return instances.length===1?instances[0]:instances}if(typeof HTMLElement!=="undefined"&&typeof HTMLCollection!=="undefined"&&typeof NodeList!=="undefined"){HTMLCollection.prototype.flatpickr=NodeList.prototype.flatpickr=function(config){return _flatpickr(this,config)};HTMLElement.prototype.flatpickr=function(config){return _flatpickr([this],config)}}var flatpickr=function(selector,config){if(typeof selector==="string"){return _flatpickr(window.document.querySelectorAll(selector),config)}else if(selector instanceof Node){return _flatpickr([selector],config)}else{return _flatpickr(selector,config)}};flatpickr.defaultConfig={};flatpickr.l10ns={en:__assign({},english),default:__assign({},english)};flatpickr.localize=function(l10n){flatpickr.l10ns.default=__assign(__assign({},flatpickr.l10ns.default),l10n)};flatpickr.setDefaults=function(config){flatpickr.defaultConfig=__assign(__assign({},flatpickr.defaultConfig),config)};flatpickr.parseDate=createDateParser({});flatpickr.formatDate=createDateFormatter({});flatpickr.compareDates=compareDates;if(typeof jQuery!=="undefined"&&typeof jQuery.fn!=="undefined"){jQuery.fn.flatpickr=function(config){return _flatpickr(this,config)}}Date.prototype.fp_incr=function(days){return new Date(this.getFullYear(),this.getMonth(),this.getDate()+(typeof days==="string"?parseInt(days,10):days))};if(typeof window!=="undefined"){window.flatpickr=flatpickr}return flatpickr});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.de={}))})(this,function(exports){"use strict";var fp=typeof window!=="undefined"&&window.flatpickr!==undefined?window.flatpickr:{l10ns:{}};var German={weekdays:{shorthand:["So","Mo","Di","Mi","Do","Fr","Sa"],longhand:["Sonntag","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag"]},months:{shorthand:["Jan","Feb","Mär","Apr","Mai","Jun","Jul","Aug","Sep","Okt","Nov","Dez"],longhand:["Januar","Februar","März","April","Mai","Juni","Juli","August","September","Oktober","November","Dezember"]},firstDayOfWeek:1,weekAbbreviation:"KW",rangeSeparator:" bis ",scrollTitle:"Zum Ändern scrollen",toggleTitle:"Zum Umschalten klicken",time_24hr:true};fp.l10ns.de=German;var de=fp.l10ns;exports.German=German;exports.default=de;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.es={}))})(this,function(exports){"use strict";var fp=typeof window!=="undefined"&&window.flatpickr!==undefined?window.flatpickr:{l10ns:{}};var Spanish={weekdays:{shorthand:["Dom","Lun","Mar","Mié","Jue","Vie","Sáb"],longhand:["Domingo","Lunes","Martes","Miércoles","Jueves","Viernes","Sábado"]},months:{shorthand:["Ene","Feb","Mar","Abr","May","Jun","Jul","Ago","Sep","Oct","Nov","Dic"],longhand:["Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"]},ordinal:function(){return"º"},firstDayOfWeek:1,rangeSeparator:" a ",time_24hr:true};fp.l10ns.es=Spanish;var es=fp.l10ns;exports.Spanish=Spanish;exports.default=es;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.fr={}))})(this,function(exports){"use strict";var fp=typeof window!=="undefined"&&window.flatpickr!==undefined?window.flatpickr:{l10ns:{}};var French={firstDayOfWeek:1,weekdays:{shorthand:["dim","lun","mar","mer","jeu","ven","sam"],longhand:["dimanche","lundi","mardi","mercredi","jeudi","vendredi","samedi"]},months:{shorthand:["janv","févr","mars","avr","mai","juin","juil","août","sept","oct","nov","déc"],longhand:["janvier","février","mars","avril","mai","juin","juillet","août","septembre","octobre","novembre","décembre"]},ordinal:function(nth){if(nth>1)return"";return"er"},rangeSeparator:" au ",weekAbbreviation:"Sem",scrollTitle:"Défiler pour augmenter la valeur",toggleTitle:"Cliquer pour basculer",time_24hr:true};fp.l10ns.fr=French;var fr=fp.l10ns;exports.French=French;exports.default=fr;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.it={}))})(this,function(exports){"use strict";var fp=typeof window!=="undefined"&&window.flatpickr!==undefined?window.flatpickr:{l10ns:{}};var Italian={weekdays:{shorthand:["Dom","Lun","Mar","Mer","Gio","Ven","Sab"],longhand:["Domenica","Lunedì","Martedì","Mercoledì","Giovedì","Venerdì","Sabato"]},months:{shorthand:["Gen","Feb","Mar","Apr","Mag","Giu","Lug","Ago","Set","Ott","Nov","Dic"],longhand:["Gennaio","Febbraio","Marzo","Aprile","Maggio","Giugno","Luglio","Agosto","Settembre","Ottobre","Novembre","Dicembre"]},firstDayOfWeek:1,ordinal:function(){return"°"},rangeSeparator:" al ",weekAbbreviation:"Se",scrollTitle:"Scrolla per aumentare",toggleTitle:"Clicca per cambiare",time_24hr:true};fp.l10ns.it=Italian;var it=fp.l10ns;exports.Italian=Italian;exports.default=it;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.ja={}))})(this,function(exports){"use strict";var fp=typeof window!=="undefined"&&window.flatpickr!==undefined?window.flatpickr:{l10ns:{}};var Japanese={weekdays:{shorthand:["日","月","火","水","木","金","土"],longhand:["日曜日","月曜日","火曜日","水曜日","木曜日","金曜日","土曜日"]},months:{shorthand:["1月","2月","3月","4月","5月","6月","7月","8月","9月","10月","11月","12月"],longhand:["1月","2月","3月","4月","5月","6月","7月","8月","9月","10月","11月","12月"]},time_24hr:true,rangeSeparator:" から ",monthAriaLabel:"月",amPM:["午前","午後"],yearAriaLabel:"年",hourAriaLabel:"時間",minuteAriaLabel:"分"};fp.l10ns.ja=Japanese;var ja=fp.l10ns;exports.Japanese=Japanese;exports.default=ja;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.nl={}))})(this,function(exports){"use strict";var fp=typeof window!=="undefined"&&window.flatpickr!==undefined?window.flatpickr:{l10ns:{}};var Dutch={weekdays:{shorthand:["zo","ma","di","wo","do","vr","za"],longhand:["zondag","maandag","dinsdag","woensdag","donderdag","vrijdag","zaterdag"]},months:{shorthand:["jan","feb","mrt","apr","mei","jun","jul","aug","sept","okt","nov","dec"],longhand:["januari","februari","maart","april","mei","juni","juli","augustus","september","oktober","november","december"]},firstDayOfWeek:1,weekAbbreviation:"wk",rangeSeparator:" t/m ",scrollTitle:"Scroll voor volgende / vorige",toggleTitle:"Klik om te wisselen",time_24hr:true,ordinal:function(nth){if(nth===1||nth===8||nth>=20)return"ste";return"de"}};fp.l10ns.nl=Dutch;var nl=fp.l10ns;exports.Dutch=Dutch;exports.default=nl;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.pl={}))})(this,function(exports){"use strict";var fp=typeof window!=="undefined"&&window.flatpickr!==undefined?window.flatpickr:{l10ns:{}};var Polish={weekdays:{shorthand:["Nd","Pn","Wt","Śr","Cz","Pt","So"],longhand:["Niedziela","Poniedziałek","Wtorek","Środa","Czwartek","Piątek","Sobota"]},months:{shorthand:["Sty","Lut","Mar","Kwi","Maj","Cze","Lip","Sie","Wrz","Paź","Lis","Gru"],longhand:["Styczeń","Luty","Marzec","Kwiecień","Maj","Czerwiec","Lipiec","Sierpień","Wrzesień","Październik","Listopad","Grudzień"]},rangeSeparator:" do ",weekAbbreviation:"tydz.",scrollTitle:"Przewiń, aby zwiększyć",toggleTitle:"Kliknij, aby przełączyć",firstDayOfWeek:1,time_24hr:true,ordinal:function(){return"."}};fp.l10ns.pl=Polish;var pl=fp.l10ns;exports.Polish=Polish;exports.default=pl;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.pt={}))})(this,function(exports){"use strict";var fp=typeof window!=="undefined"&&window.flatpickr!==undefined?window.flatpickr:{l10ns:{}};var Portuguese={weekdays:{shorthand:["Dom","Seg","Ter","Qua","Qui","Sex","Sáb"],longhand:["Domingo","Segunda-feira","Terça-feira","Quarta-feira","Quinta-feira","Sexta-feira","Sábado"]},months:{shorthand:["Jan","Fev","Mar","Abr","Mai","Jun","Jul","Ago","Set","Out","Nov","Dez"],longhand:["Janeiro","Fevereiro","Março","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"]},rangeSeparator:" até ",time_24hr:true};fp.l10ns.pt=Portuguese;var pt=fp.l10ns;exports.Portuguese=Portuguese;exports.default=pt;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.ru={}))})(this,function(exports){"use strict";var fp=typeof window!=="undefined"&&window.flatpickr!==undefined?window.flatpickr:{l10ns:{}};var Russian={weekdays:{shorthand:["Вс","Пн","Вт","Ср","Чт","Пт","Сб"],longhand:["Воскресенье","Понедельник","Вторник","Среда","Четверг","Пятница","Суббота"]},months:{shorthand:["Янв","Фев","Март","Апр","Май","Июнь","Июль","Авг","Сен","Окт","Ноя","Дек"],longhand:["Январь","Февраль","Март","Апрель","Май","Июнь","Июль","Август","Сентябрь","Октябрь","Ноябрь","Декабрь"]},firstDayOfWeek:1,ordinal:function(){return""},rangeSeparator:" — ",weekAbbreviation:"Нед.",scrollTitle:"Прокрутите для увеличения",toggleTitle:"Нажмите для переключения",amPM:["ДП","ПП"],yearAriaLabel:"Год",time_24hr:true};fp.l10ns.ru=Russian;var ru=fp.l10ns;exports.Russian=Russian;exports.default=ru;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.sk={}))})(this,function(exports){"use strict";var fp=typeof window!=="undefined"&&window.flatpickr!==undefined?window.flatpickr:{l10ns:{}};var Slovak={weekdays:{shorthand:["Ned","Pon","Ut","Str","Štv","Pia","Sob"],longhand:["Nedeľa","Pondelok","Utorok","Streda","Štvrtok","Piatok","Sobota"]},months:{shorthand:["Jan","Feb","Mar","Apr","Máj","Jún","Júl","Aug","Sep","Okt","Nov","Dec"],longhand:["Január","Február","Marec","Apríl","Máj","Jún","Júl","August","September","Október","November","December"]},firstDayOfWeek:1,rangeSeparator:" do ",time_24hr:true,ordinal:function(){return"."}};fp.l10ns.sk=Slovak;var sk=fp.l10ns;exports.Slovak=Slovak;exports.default=sk;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.uk={}))})(this,function(exports){"use strict";var fp=typeof window!=="undefined"&&window.flatpickr!==undefined?window.flatpickr:{l10ns:{}};var Ukrainian={firstDayOfWeek:1,weekdays:{shorthand:["Нд","Пн","Вт","Ср","Чт","Пт","Сб"],longhand:["Неділя","Понеділок","Вівторок","Середа","Четвер","П'ятниця","Субота"]},months:{shorthand:["Січ","Лют","Бер","Кві","Тра","Чер","Лип","Сер","Вер","Жов","Лис","Гру"],longhand:["Січень","Лютий","Березень","Квітень","Травень","Червень","Липень","Серпень","Вересень","Жовтень","Листопад","Грудень"]},time_24hr:true};fp.l10ns.uk=Ukrainian;var uk=fp.l10ns;exports.Ukrainian=Ukrainian;exports.default=uk;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global.zh={}))})(this,function(exports){"use strict";var fp=typeof window!=="undefined"&&window.flatpickr!==undefined?window.flatpickr:{l10ns:{}};var Mandarin={weekdays:{shorthand:["周日","周一","周二","周三","周四","周五","周六"],longhand:["星期日","星期一","星期二","星期三","星期四","星期五","星期六"]},months:{shorthand:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"],longhand:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"]},rangeSeparator:" 至 ",weekAbbreviation:"周",scrollTitle:"滚动切换",toggleTitle:"点击切换 12/24 小时时制"};fp.l10ns.zh=Mandarin;var zh=fp.l10ns;exports.Mandarin=Mandarin;exports.default=zh;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory(global["zh-tw"]={}))})(this,function(exports){"use strict";var fp=typeof window!=="undefined"&&window.flatpickr!==undefined?window.flatpickr:{l10ns:{}};var MandarinTraditional={weekdays:{shorthand:["週日","週一","週二","週三","週四","週五","週六"],longhand:["星期日","星期一","星期二","星期三","星期四","星期五","星期六"]},months:{shorthand:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"],longhand:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"]},rangeSeparator:" 至 ",weekAbbreviation:"週",scrollTitle:"滾動切換",toggleTitle:"點擊切換 12/24 小時時制"};fp.l10ns.zh_tw=MandarinTraditional;var zhTw=fp.l10ns;exports.MandarinTraditional=MandarinTraditional;exports.default=zhTw;Object.defineProperty(exports,"__esModule",{value:true})});(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?module.exports=factory():typeof define==="function"&&define.amd?define(factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,global.Sweetalert2=factory())})(this,function(){"use strict";function _assertClassBrand(e,t,n){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:n;throw new TypeError("Private element is not present on this object")}function _checkPrivateRedeclaration(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function _classPrivateFieldGet2(s,a){return s.get(_assertClassBrand(s,a))}function _classPrivateFieldInitSpec(e,t,a){_checkPrivateRedeclaration(e,t),t.set(e,a)}function _classPrivateFieldSet2(s,a,r){return s.set(_assertClassBrand(s,a),r),r}const RESTORE_FOCUS_TIMEOUT=100;const globalState={};const focusPreviousActiveElement=()=>{if(globalState.previousActiveElement instanceof HTMLElement){globalState.previousActiveElement.focus();globalState.previousActiveElement=null}else if(document.body){document.body.focus()}};const restoreActiveElement=returnFocus=>{return new Promise(resolve=>{if(!returnFocus){return resolve()}const x=window.scrollX;const y=window.scrollY;globalState.restoreFocusTimeout=setTimeout(()=>{focusPreviousActiveElement();resolve()},RESTORE_FOCUS_TIMEOUT);window.scrollTo(x,y)})};const swalPrefix="swal2-";const classNames=["container","shown","height-auto","iosfix","popup","modal","no-backdrop","no-transition","toast","toast-shown","show","hide","close","title","html-container","actions","confirm","deny","cancel","footer","icon","icon-content","image","input","file","range","select","radio","checkbox","label","textarea","inputerror","input-label","validation-message","progress-steps","active-progress-step","progress-step","progress-step-line","loader","loading","styled","top","top-start","top-end","top-left","top-right","center","center-start","center-end","center-left","center-right","bottom","bottom-start","bottom-end","bottom-left","bottom-right","grow-row","grow-column","grow-fullscreen","rtl","timer-progress-bar","timer-progress-bar-container","scrollbar-measure","icon-success","icon-warning","icon-info","icon-question","icon-error","draggable","dragging"];const swalClasses=classNames.reduce((acc,className)=>{acc[className]=swalPrefix+className;return acc},{});const icons=["success","warning","info","question","error"];const iconTypes=icons.reduce((acc,icon)=>{acc[icon]=swalPrefix+icon;return acc},{});const consolePrefix="SweetAlert2:";const capitalizeFirstLetter=str=>str.charAt(0).toUpperCase()+str.slice(1);const warn=message=>{console.warn(`${consolePrefix} ${typeof message==="object"?message.join(" "):message}`)};const error=message=>{console.error(`${consolePrefix} ${message}`)};const previousWarnOnceMessages=[];const warnOnce=message=>{if(!previousWarnOnceMessages.includes(message)){previousWarnOnceMessages.push(message);warn(message)}};const warnAboutDeprecation=function(deprecatedParam){let useInstead=arguments.length>1&&arguments[1]!==undefined?arguments[1]:null;warnOnce(`"${deprecatedParam}" is deprecated and will be removed in the next major release.${useInstead?` Use "${useInstead}" instead.`:""}`)};const callIfFunction=arg=>typeof arg==="function"?arg():arg;const hasToPromiseFn=arg=>arg&&typeof arg.toPromise==="function";const asPromise=arg=>hasToPromiseFn(arg)?arg.toPromise():Promise.resolve(arg);const isPromise=arg=>arg&&Promise.resolve(arg)===arg;const getContainer=()=>document.body.querySelector(`.${swalClasses.container}`);const elementBySelector=selectorString=>{const container=getContainer();return container?container.querySelector(selectorString):null};const elementByClass=className=>{return elementBySelector(`.${className}`)};const getPopup=()=>elementByClass(swalClasses.popup);const getIcon=()=>elementByClass(swalClasses.icon);const getIconContent=()=>elementByClass(swalClasses["icon-content"]);const getTitle=()=>elementByClass(swalClasses.title);const getHtmlContainer=()=>elementByClass(swalClasses["html-container"]);const getImage=()=>elementByClass(swalClasses.image);const getProgressSteps=()=>elementByClass(swalClasses["progress-steps"]);const getValidationMessage=()=>elementByClass(swalClasses["validation-message"]);const getConfirmButton=()=>elementBySelector(`.${swalClasses.actions} .${swalClasses.confirm}`);const getCancelButton=()=>elementBySelector(`.${swalClasses.actions} .${swalClasses.cancel}`);const getDenyButton=()=>elementBySelector(`.${swalClasses.actions} .${swalClasses.deny}`);const getInputLabel=()=>elementByClass(swalClasses["input-label"]);const getLoader=()=>elementBySelector(`.${swalClasses.loader}`);const getActions=()=>elementByClass(swalClasses.actions);const getFooter=()=>elementByClass(swalClasses.footer);const getTimerProgressBar=()=>elementByClass(swalClasses["timer-progress-bar"]);const getCloseButton=()=>elementByClass(swalClasses.close);const focusable=`
  a[href],
  area[href],
  input:not([disabled]),
  select:not([disabled]),
  textarea:not([disabled]),
  button:not([disabled]),
  iframe,
  object,
  embed,
  [tabindex="0"],
  [contenteditable],
  audio[controls],
  video[controls],
  summary
`;const getFocusableElements=()=>{const popup=getPopup();if(!popup){return[]}const focusableElementsWithTabindex=popup.querySelectorAll('[tabindex]:not([tabindex="-1"]):not([tabindex="0"])');const focusableElementsWithTabindexSorted=Array.from(focusableElementsWithTabindex).sort((a,b)=>{const tabindexA=parseInt(a.getAttribute("tabindex")||"0");const tabindexB=parseInt(b.getAttribute("tabindex")||"0");if(tabindexA>tabindexB){return 1}else if(tabindexA<tabindexB){return-1}return 0});const otherFocusableElements=popup.querySelectorAll(focusable);const otherFocusableElementsFiltered=Array.from(otherFocusableElements).filter(el=>el.getAttribute("tabindex")!=="-1");return[...new Set(focusableElementsWithTabindexSorted.concat(otherFocusableElementsFiltered))].filter(el=>isVisible$1(el))};const isModal=()=>{return hasClass(document.body,swalClasses.shown)&&!hasClass(document.body,swalClasses["toast-shown"])&&!hasClass(document.body,swalClasses["no-backdrop"])};const isToast=()=>{const popup=getPopup();if(!popup){return false}return hasClass(popup,swalClasses.toast)};const isLoading=()=>{const popup=getPopup();if(!popup){return false}return popup.hasAttribute("data-loading")};const setInnerHtml=(elem,html)=>{elem.textContent="";if(html){const parser=new DOMParser;const parsed=parser.parseFromString(html,`text/html`);const head=parsed.querySelector("head");if(head){Array.from(head.childNodes).forEach(child=>{elem.appendChild(child)})}const body=parsed.querySelector("body");if(body){Array.from(body.childNodes).forEach(child=>{if(child instanceof HTMLVideoElement||child instanceof HTMLAudioElement){elem.appendChild(child.cloneNode(true))}else{elem.appendChild(child)}})}}};const hasClass=(elem,className)=>{if(!className){return false}const classList=className.split(/\s+/);for(let i=0;i<classList.length;i++){if(!elem.classList.contains(classList[i])){return false}}return true};const removeCustomClasses=(elem,params)=>{Array.from(elem.classList).forEach(className=>{if(!Object.values(swalClasses).includes(className)&&!Object.values(iconTypes).includes(className)&&!Object.values(params.showClass||{}).includes(className)){elem.classList.remove(className)}})};const applyCustomClass=(elem,params,className)=>{removeCustomClasses(elem,params);if(!params.customClass){return}const customClass=params.customClass[className];if(!customClass){return}if(typeof customClass!=="string"&&!customClass.forEach){warn(`Invalid type of customClass.${className}! Expected string or iterable object, got "${typeof customClass}"`);return}addClass(elem,customClass)};const getInput$1=(popup,inputClass)=>{if(!inputClass){return null}switch(inputClass){case"select":case"textarea":case"file":return popup.querySelector(`.${swalClasses.popup} > .${swalClasses[inputClass]}`);case"checkbox":return popup.querySelector(`.${swalClasses.popup} > .${swalClasses.checkbox} input`);case"radio":return popup.querySelector(`.${swalClasses.popup} > .${swalClasses.radio} input:checked`)||popup.querySelector(`.${swalClasses.popup} > .${swalClasses.radio} input:first-child`);case"range":return popup.querySelector(`.${swalClasses.popup} > .${swalClasses.range} input`);default:return popup.querySelector(`.${swalClasses.popup} > .${swalClasses.input}`)}};const focusInput=input=>{input.focus();if(input.type!=="file"){const val=input.value;input.value="";input.value=val}};const toggleClass=(target,classList,condition)=>{if(!target||!classList){return}if(typeof classList==="string"){classList=classList.split(/\s+/).filter(Boolean)}classList.forEach(className=>{if(Array.isArray(target)){target.forEach(elem=>{if(condition){elem.classList.add(className)}else{elem.classList.remove(className)}})}else{if(condition){target.classList.add(className)}else{target.classList.remove(className)}}})};const addClass=(target,classList)=>{toggleClass(target,classList,true)};const removeClass=(target,classList)=>{toggleClass(target,classList,false)};const getDirectChildByClass=(elem,className)=>{const children=Array.from(elem.children);for(let i=0;i<children.length;i++){const child=children[i];if(child instanceof HTMLElement&&hasClass(child,className)){return child}}};const applyNumericalStyle=(elem,property,value)=>{if(value===`${parseInt(value)}`){value=parseInt(value)}if(value||parseInt(value)===0){elem.style.setProperty(property,typeof value==="number"?`${value}px`:value)}else{elem.style.removeProperty(property)}};const show=function(elem){let display=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"flex";if(!elem){return}elem.style.display=display};const hide=elem=>{if(!elem){return}elem.style.display="none"};const showWhenInnerHtmlPresent=function(elem){let display=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"block";if(!elem){return}new MutationObserver(()=>{toggle(elem,elem.innerHTML,display)}).observe(elem,{childList:true,subtree:true})};const setStyle=(parent,selector,property,value)=>{const el=parent.querySelector(selector);if(el){el.style.setProperty(property,value)}};const toggle=function(elem,condition){let display=arguments.length>2&&arguments[2]!==undefined?arguments[2]:"flex";if(condition){show(elem,display)}else{hide(elem)}};const isVisible$1=elem=>!!(elem&&(elem.offsetWidth||elem.offsetHeight||elem.getClientRects().length));const allButtonsAreHidden=()=>!isVisible$1(getConfirmButton())&&!isVisible$1(getDenyButton())&&!isVisible$1(getCancelButton());const isScrollable=elem=>!!(elem.scrollHeight>elem.clientHeight);const hasCssAnimation=elem=>{const style=window.getComputedStyle(elem);const animDuration=parseFloat(style.getPropertyValue("animation-duration")||"0");const transDuration=parseFloat(style.getPropertyValue("transition-duration")||"0");return animDuration>0||transDuration>0};const animateTimerProgressBar=function(timer){let reset=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;const timerProgressBar=getTimerProgressBar();if(!timerProgressBar){return}if(isVisible$1(timerProgressBar)){if(reset){timerProgressBar.style.transition="none";timerProgressBar.style.width="100%"}setTimeout(()=>{timerProgressBar.style.transition=`width ${timer/1e3}s linear`;timerProgressBar.style.width="0%"},10)}};const stopTimerProgressBar=()=>{const timerProgressBar=getTimerProgressBar();if(!timerProgressBar){return}const timerProgressBarWidth=parseInt(window.getComputedStyle(timerProgressBar).width);timerProgressBar.style.removeProperty("transition");timerProgressBar.style.width="100%";const timerProgressBarFullWidth=parseInt(window.getComputedStyle(timerProgressBar).width);const timerProgressBarPercent=timerProgressBarWidth/timerProgressBarFullWidth*100;timerProgressBar.style.width=`${timerProgressBarPercent}%`};const isNodeEnv=()=>typeof window==="undefined"||typeof document==="undefined";const sweetHTML=`
 <div aria-labelledby="${swalClasses.title}" aria-describedby="${swalClasses["html-container"]}" class="${swalClasses.popup}" tabindex="-1">
   <button type="button" class="${swalClasses.close}"></button>
   <ul class="${swalClasses["progress-steps"]}"></ul>
   <div class="${swalClasses.icon}"></div>
   <img class="${swalClasses.image}" />
   <h2 class="${swalClasses.title}" id="${swalClasses.title}"></h2>
   <div class="${swalClasses["html-container"]}" id="${swalClasses["html-container"]}"></div>
   <input class="${swalClasses.input}" id="${swalClasses.input}" />
   <input type="file" class="${swalClasses.file}" />
   <div class="${swalClasses.range}">
     <input type="range" />
     <output></output>
   </div>
   <select class="${swalClasses.select}" id="${swalClasses.select}"></select>
   <div class="${swalClasses.radio}"></div>
   <label class="${swalClasses.checkbox}">
     <input type="checkbox" id="${swalClasses.checkbox}" />
     <span class="${swalClasses.label}"></span>
   </label>
   <textarea class="${swalClasses.textarea}" id="${swalClasses.textarea}"></textarea>
   <div class="${swalClasses["validation-message"]}" id="${swalClasses["validation-message"]}"></div>
   <div class="${swalClasses.actions}">
     <div class="${swalClasses.loader}"></div>
     <button type="button" class="${swalClasses.confirm}"></button>
     <button type="button" class="${swalClasses.deny}"></button>
     <button type="button" class="${swalClasses.cancel}"></button>
   </div>
   <div class="${swalClasses.footer}"></div>
   <div class="${swalClasses["timer-progress-bar-container"]}">
     <div class="${swalClasses["timer-progress-bar"]}"></div>
   </div>
 </div>
`.replace(/(^|\n)\s*/g,"");const resetOldContainer=()=>{const oldContainer=getContainer();if(!oldContainer){return false}oldContainer.remove();removeClass([document.documentElement,document.body],[swalClasses["no-backdrop"],swalClasses["toast-shown"],swalClasses["has-column"]]);return true};const resetValidationMessage$1=()=>{globalState.currentInstance.resetValidationMessage()};const addInputChangeListeners=()=>{const popup=getPopup();const input=getDirectChildByClass(popup,swalClasses.input);const file=getDirectChildByClass(popup,swalClasses.file);const range=popup.querySelector(`.${swalClasses.range} input`);const rangeOutput=popup.querySelector(`.${swalClasses.range} output`);const select=getDirectChildByClass(popup,swalClasses.select);const checkbox=popup.querySelector(`.${swalClasses.checkbox} input`);const textarea=getDirectChildByClass(popup,swalClasses.textarea);input.oninput=resetValidationMessage$1;file.onchange=resetValidationMessage$1;select.onchange=resetValidationMessage$1;checkbox.onchange=resetValidationMessage$1;textarea.oninput=resetValidationMessage$1;range.oninput=()=>{resetValidationMessage$1();rangeOutput.value=range.value};range.onchange=()=>{resetValidationMessage$1();rangeOutput.value=range.value}};const getTarget=target=>typeof target==="string"?document.querySelector(target):target;const setupAccessibility=params=>{const popup=getPopup();popup.setAttribute("role",params.toast?"alert":"dialog");popup.setAttribute("aria-live",params.toast?"polite":"assertive");if(!params.toast){popup.setAttribute("aria-modal","true")}};const setupRTL=targetElement=>{if(window.getComputedStyle(targetElement).direction==="rtl"){addClass(getContainer(),swalClasses.rtl)}};const init=params=>{const oldContainerExisted=resetOldContainer();if(isNodeEnv()){error("SweetAlert2 requires document to initialize");return}const container=document.createElement("div");container.className=swalClasses.container;if(oldContainerExisted){addClass(container,swalClasses["no-transition"])}setInnerHtml(container,sweetHTML);container.dataset["swal2Theme"]=params.theme;const targetElement=getTarget(params.target);targetElement.appendChild(container);if(params.topLayer){container.setAttribute("popover","");container.showPopover()}setupAccessibility(params);setupRTL(targetElement);addInputChangeListeners()};const parseHtmlToContainer=(param,target)=>{if(param instanceof HTMLElement){target.appendChild(param)}else if(typeof param==="object"){handleObject(param,target)}else if(param){setInnerHtml(target,param)}};const handleObject=(param,target)=>{if(param.jquery){handleJqueryElem(target,param)}else{setInnerHtml(target,param.toString())}};const handleJqueryElem=(target,elem)=>{target.textContent="";if(0 in elem){for(let i=0;i in elem;i++){target.appendChild(elem[i].cloneNode(true))}}else{target.appendChild(elem.cloneNode(true))}};const renderActions=(instance,params)=>{const actions=getActions();const loader=getLoader();if(!actions||!loader){return}if(!params.showConfirmButton&&!params.showDenyButton&&!params.showCancelButton){hide(actions)}else{show(actions)}applyCustomClass(actions,params,"actions");renderButtons(actions,loader,params);setInnerHtml(loader,params.loaderHtml||"");applyCustomClass(loader,params,"loader")};function renderButtons(actions,loader,params){const confirmButton=getConfirmButton();const denyButton=getDenyButton();const cancelButton=getCancelButton();if(!confirmButton||!denyButton||!cancelButton){return}renderButton(confirmButton,"confirm",params);renderButton(denyButton,"deny",params);renderButton(cancelButton,"cancel",params);handleButtonsStyling(confirmButton,denyButton,cancelButton,params);if(params.reverseButtons){if(params.toast){actions.insertBefore(cancelButton,confirmButton);actions.insertBefore(denyButton,confirmButton)}else{actions.insertBefore(cancelButton,loader);actions.insertBefore(denyButton,loader);actions.insertBefore(confirmButton,loader)}}}function handleButtonsStyling(confirmButton,denyButton,cancelButton,params){if(!params.buttonsStyling){removeClass([confirmButton,denyButton,cancelButton],swalClasses.styled);return}addClass([confirmButton,denyButton,cancelButton],swalClasses.styled);if(params.confirmButtonColor){confirmButton.style.setProperty("--swal2-confirm-button-background-color",params.confirmButtonColor)}if(params.denyButtonColor){denyButton.style.setProperty("--swal2-deny-button-background-color",params.denyButtonColor)}if(params.cancelButtonColor){cancelButton.style.setProperty("--swal2-cancel-button-background-color",params.cancelButtonColor)}applyOutlineColor(confirmButton);applyOutlineColor(denyButton);applyOutlineColor(cancelButton)}function applyOutlineColor(button){const buttonStyle=window.getComputedStyle(button);const outlineColor=buttonStyle.backgroundColor.replace(/rgba?\((\d+), (\d+), (\d+).*/,"rgba($1, $2, $3, 0.5)");button.style.setProperty("--swal2-action-button-outline",buttonStyle.getPropertyValue("--swal2-outline").replace(/ rgba\(.*/,` ${outlineColor}`))}function renderButton(button,buttonType,params){const buttonName=capitalizeFirstLetter(buttonType);toggle(button,params[`show${buttonName}Button`],"inline-block");setInnerHtml(button,params[`${buttonType}ButtonText`]||"");button.setAttribute("aria-label",params[`${buttonType}ButtonAriaLabel`]||"");button.className=swalClasses[buttonType];applyCustomClass(button,params,`${buttonType}Button`)}const renderCloseButton=(instance,params)=>{const closeButton=getCloseButton();if(!closeButton){return}setInnerHtml(closeButton,params.closeButtonHtml||"");applyCustomClass(closeButton,params,"closeButton");toggle(closeButton,params.showCloseButton);closeButton.setAttribute("aria-label",params.closeButtonAriaLabel||"")};const renderContainer=(instance,params)=>{const container=getContainer();if(!container){return}handleBackdropParam(container,params.backdrop);handlePositionParam(container,params.position);handleGrowParam(container,params.grow);applyCustomClass(container,params,"container")};function handleBackdropParam(container,backdrop){if(typeof backdrop==="string"){container.style.background=backdrop}else if(!backdrop){addClass([document.documentElement,document.body],swalClasses["no-backdrop"])}}function handlePositionParam(container,position){if(!position){return}if(position in swalClasses){addClass(container,swalClasses[position])}else{warn('The "position" parameter is not valid, defaulting to "center"');addClass(container,swalClasses.center)}}function handleGrowParam(container,grow){if(!grow){return}addClass(container,swalClasses[`grow-${grow}`])}var privateProps={innerParams:new WeakMap,domCache:new WeakMap};const inputClasses=["input","file","range","select","radio","checkbox","textarea"];const renderInput=(instance,params)=>{const popup=getPopup();if(!popup){return}const innerParams=privateProps.innerParams.get(instance);const rerender=!innerParams||params.input!==innerParams.input;inputClasses.forEach(inputClass=>{const inputContainer=getDirectChildByClass(popup,swalClasses[inputClass]);if(!inputContainer){return}setAttributes(inputClass,params.inputAttributes);inputContainer.className=swalClasses[inputClass];if(rerender){hide(inputContainer)}});if(params.input){if(rerender){showInput(params)}setCustomClass(params)}};const showInput=params=>{if(!params.input){return}if(!renderInputType[params.input]){error(`Unexpected type of input! Expected ${Object.keys(renderInputType).join(" | ")}, got "${params.input}"`);return}const inputContainer=getInputContainer(params.input);if(!inputContainer){return}const input=renderInputType[params.input](inputContainer,params);show(inputContainer);if(params.inputAutoFocus){setTimeout(()=>{focusInput(input)})}};const removeAttributes=input=>{for(let i=0;i<input.attributes.length;i++){const attrName=input.attributes[i].name;if(!["id","type","value","style"].includes(attrName)){input.removeAttribute(attrName)}}};const setAttributes=(inputClass,inputAttributes)=>{const popup=getPopup();if(!popup){return}const input=getInput$1(popup,inputClass);if(!input){return}removeAttributes(input);for(const attr in inputAttributes){input.setAttribute(attr,inputAttributes[attr])}};const setCustomClass=params=>{if(!params.input){return}const inputContainer=getInputContainer(params.input);if(inputContainer){applyCustomClass(inputContainer,params,"input")}};const setInputPlaceholder=(input,params)=>{if(!input.placeholder&&params.inputPlaceholder){input.placeholder=params.inputPlaceholder}};const setInputLabel=(input,prependTo,params)=>{if(params.inputLabel){const label=document.createElement("label");const labelClass=swalClasses["input-label"];label.setAttribute("for",input.id);label.className=labelClass;if(typeof params.customClass==="object"){addClass(label,params.customClass.inputLabel)}label.innerText=params.inputLabel;prependTo.insertAdjacentElement("beforebegin",label)}};const getInputContainer=inputType=>{const popup=getPopup();if(!popup){return}return getDirectChildByClass(popup,swalClasses[inputType]||swalClasses.input)};const checkAndSetInputValue=(input,inputValue)=>{if(["string","number"].includes(typeof inputValue)){input.value=`${inputValue}`}else if(!isPromise(inputValue)){warn(`Unexpected type of inputValue! Expected "string", "number" or "Promise", got "${typeof inputValue}"`)}};const renderInputType={};renderInputType.text=renderInputType.email=renderInputType.password=renderInputType.number=renderInputType.tel=renderInputType.url=renderInputType.search=renderInputType.date=renderInputType["datetime-local"]=renderInputType.time=renderInputType.week=renderInputType.month=(input,params)=>{checkAndSetInputValue(input,params.inputValue);setInputLabel(input,input,params);setInputPlaceholder(input,params);input.type=params.input;return input};renderInputType.file=(input,params)=>{setInputLabel(input,input,params);setInputPlaceholder(input,params);return input};renderInputType.range=(range,params)=>{const rangeInput=range.querySelector("input");const rangeOutput=range.querySelector("output");checkAndSetInputValue(rangeInput,params.inputValue);rangeInput.type=params.input;checkAndSetInputValue(rangeOutput,params.inputValue);setInputLabel(rangeInput,range,params);return range};renderInputType.select=(select,params)=>{select.textContent="";if(params.inputPlaceholder){const placeholder=document.createElement("option");setInnerHtml(placeholder,params.inputPlaceholder);placeholder.value="";placeholder.disabled=true;placeholder.selected=true;select.appendChild(placeholder)}setInputLabel(select,select,params);return select};renderInputType.radio=radio=>{radio.textContent="";return radio};renderInputType.checkbox=(checkboxContainer,params)=>{const checkbox=getInput$1(getPopup(),"checkbox");checkbox.value="1";checkbox.checked=Boolean(params.inputValue);const label=checkboxContainer.querySelector("span");setInnerHtml(label,params.inputPlaceholder||params.inputLabel);return checkbox};renderInputType.textarea=(textarea,params)=>{checkAndSetInputValue(textarea,params.inputValue);setInputPlaceholder(textarea,params);setInputLabel(textarea,textarea,params);const getMargin=el=>parseInt(window.getComputedStyle(el).marginLeft)+parseInt(window.getComputedStyle(el).marginRight);setTimeout(()=>{if("MutationObserver"in window){const initialPopupWidth=parseInt(window.getComputedStyle(getPopup()).width);const textareaResizeHandler=()=>{if(!document.body.contains(textarea)){return}const textareaWidth=textarea.offsetWidth+getMargin(textarea);if(textareaWidth>initialPopupWidth){getPopup().style.width=`${textareaWidth}px`}else{applyNumericalStyle(getPopup(),"width",params.width)}};new MutationObserver(textareaResizeHandler).observe(textarea,{attributes:true,attributeFilter:["style"]})}});return textarea};const renderContent=(instance,params)=>{const htmlContainer=getHtmlContainer();if(!htmlContainer){return}showWhenInnerHtmlPresent(htmlContainer);applyCustomClass(htmlContainer,params,"htmlContainer");if(params.html){parseHtmlToContainer(params.html,htmlContainer);show(htmlContainer,"block")}else if(params.text){htmlContainer.textContent=params.text;show(htmlContainer,"block")}else{hide(htmlContainer)}renderInput(instance,params)};const renderFooter=(instance,params)=>{const footer=getFooter();if(!footer){return}showWhenInnerHtmlPresent(footer);toggle(footer,params.footer,"block");if(params.footer){parseHtmlToContainer(params.footer,footer)}applyCustomClass(footer,params,"footer")};const renderIcon=(instance,params)=>{const innerParams=privateProps.innerParams.get(instance);const icon=getIcon();if(!icon){return}if(innerParams&&params.icon===innerParams.icon){setContent(icon,params);applyStyles(icon,params);return}if(!params.icon&&!params.iconHtml){hide(icon);return}if(params.icon&&Object.keys(iconTypes).indexOf(params.icon)===-1){error(`Unknown icon! Expected "success", "error", "warning", "info" or "question", got "${params.icon}"`);hide(icon);return}show(icon);setContent(icon,params);applyStyles(icon,params);addClass(icon,params.showClass&&params.showClass.icon);const colorSchemeQueryList=window.matchMedia("(prefers-color-scheme: dark)");colorSchemeQueryList.addEventListener("change",adjustSuccessIconBackgroundColor)};const applyStyles=(icon,params)=>{for(const[iconType,iconClassName]of Object.entries(iconTypes)){if(params.icon!==iconType){removeClass(icon,iconClassName)}}addClass(icon,params.icon&&iconTypes[params.icon]);setColor(icon,params);adjustSuccessIconBackgroundColor();applyCustomClass(icon,params,"icon")};const adjustSuccessIconBackgroundColor=()=>{const popup=getPopup();if(!popup){return}const popupBackgroundColor=window.getComputedStyle(popup).getPropertyValue("background-color");const successIconParts=popup.querySelectorAll("[class^=swal2-success-circular-line], .swal2-success-fix");for(let i=0;i<successIconParts.length;i++){successIconParts[i].style.backgroundColor=popupBackgroundColor}};const successIconHtml=`
  <div class="swal2-success-circular-line-left"></div>
  <span class="swal2-success-line-tip"></span> <span class="swal2-success-line-long"></span>
  <div class="swal2-success-ring"></div> <div class="swal2-success-fix"></div>
  <div class="swal2-success-circular-line-right"></div>
`;const errorIconHtml=`
  <span class="swal2-x-mark">
    <span class="swal2-x-mark-line-left"></span>
    <span class="swal2-x-mark-line-right"></span>
  </span>
`;const setContent=(icon,params)=>{if(!params.icon&&!params.iconHtml){return}let oldContent=icon.innerHTML;let newContent="";if(params.iconHtml){newContent=iconContent(params.iconHtml)}else if(params.icon==="success"){newContent=successIconHtml;oldContent=oldContent.replace(/ style=".*?"/g,"")}else if(params.icon==="error"){newContent=errorIconHtml}else if(params.icon){const defaultIconHtml={question:"?",warning:"!",info:"i"};newContent=iconContent(defaultIconHtml[params.icon])}if(oldContent.trim()!==newContent.trim()){setInnerHtml(icon,newContent)}};const setColor=(icon,params)=>{if(!params.iconColor){return}icon.style.color=params.iconColor;icon.style.borderColor=params.iconColor;for(const sel of[".swal2-success-line-tip",".swal2-success-line-long",".swal2-x-mark-line-left",".swal2-x-mark-line-right"]){setStyle(icon,sel,"background-color",params.iconColor)}setStyle(icon,".swal2-success-ring","border-color",params.iconColor)};const iconContent=content=>`<div class="${swalClasses["icon-content"]}">${content}</div>`;const renderImage=(instance,params)=>{const image=getImage();if(!image){return}if(!params.imageUrl){hide(image);return}show(image,"");image.setAttribute("src",params.imageUrl);image.setAttribute("alt",params.imageAlt||"");applyNumericalStyle(image,"width",params.imageWidth);applyNumericalStyle(image,"height",params.imageHeight);image.className=swalClasses.image;applyCustomClass(image,params,"image")};let dragging=false;let mousedownX=0;let mousedownY=0;let initialX=0;let initialY=0;const addDraggableListeners=popup=>{popup.addEventListener("mousedown",down);document.body.addEventListener("mousemove",move);popup.addEventListener("mouseup",up);popup.addEventListener("touchstart",down);document.body.addEventListener("touchmove",move);popup.addEventListener("touchend",up)};const removeDraggableListeners=popup=>{popup.removeEventListener("mousedown",down);document.body.removeEventListener("mousemove",move);popup.removeEventListener("mouseup",up);popup.removeEventListener("touchstart",down);document.body.removeEventListener("touchmove",move);popup.removeEventListener("touchend",up)};const down=event=>{const popup=getPopup();if(event.target===popup||getIcon().contains(event.target)){dragging=true;const clientXY=getClientXY(event);mousedownX=clientXY.clientX;mousedownY=clientXY.clientY;initialX=parseInt(popup.style.insetInlineStart)||0;initialY=parseInt(popup.style.insetBlockStart)||0;addClass(popup,"swal2-dragging")}};const move=event=>{const popup=getPopup();if(dragging){let{clientX,clientY}=getClientXY(event);popup.style.insetInlineStart=`${initialX+(clientX-mousedownX)}px`;popup.style.insetBlockStart=`${initialY+(clientY-mousedownY)}px`}};const up=()=>{const popup=getPopup();dragging=false;removeClass(popup,"swal2-dragging")};const getClientXY=event=>{let clientX=0,clientY=0;if(event.type.startsWith("mouse")){clientX=event.clientX;clientY=event.clientY}else if(event.type.startsWith("touch")){clientX=event.touches[0].clientX;clientY=event.touches[0].clientY}return{clientX:clientX,clientY:clientY}};const renderPopup=(instance,params)=>{const container=getContainer();const popup=getPopup();if(!container||!popup){return}if(params.toast){applyNumericalStyle(container,"width",params.width);popup.style.width="100%";const loader=getLoader();if(loader){popup.insertBefore(loader,getIcon())}}else{applyNumericalStyle(popup,"width",params.width)}applyNumericalStyle(popup,"padding",params.padding);if(params.color){popup.style.color=params.color}if(params.background){popup.style.background=params.background}hide(getValidationMessage());addClasses$1(popup,params);if(params.draggable&&!params.toast){addClass(popup,swalClasses.draggable);addDraggableListeners(popup)}else{removeClass(popup,swalClasses.draggable);removeDraggableListeners(popup)}};const addClasses$1=(popup,params)=>{const showClass=params.showClass||{};popup.className=`${swalClasses.popup} ${isVisible$1(popup)?showClass.popup:""}`;if(params.toast){addClass([document.documentElement,document.body],swalClasses["toast-shown"]);addClass(popup,swalClasses.toast)}else{addClass(popup,swalClasses.modal)}applyCustomClass(popup,params,"popup");if(typeof params.customClass==="string"){addClass(popup,params.customClass)}if(params.icon){addClass(popup,swalClasses[`icon-${params.icon}`])}};const renderProgressSteps=(instance,params)=>{const progressStepsContainer=getProgressSteps();if(!progressStepsContainer){return}const{progressSteps,currentProgressStep}=params;if(!progressSteps||progressSteps.length===0||currentProgressStep===undefined){hide(progressStepsContainer);return}show(progressStepsContainer);progressStepsContainer.textContent="";if(currentProgressStep>=progressSteps.length){warn("Invalid currentProgressStep parameter, it should be less than progressSteps.length "+"(currentProgressStep like JS arrays starts from 0)")}progressSteps.forEach((step,index)=>{const stepEl=createStepElement(step);progressStepsContainer.appendChild(stepEl);if(index===currentProgressStep){addClass(stepEl,swalClasses["active-progress-step"])}if(index!==progressSteps.length-1){const lineEl=createLineElement(params);progressStepsContainer.appendChild(lineEl)}})};const createStepElement=step=>{const stepEl=document.createElement("li");addClass(stepEl,swalClasses["progress-step"]);setInnerHtml(stepEl,step);return stepEl};const createLineElement=params=>{const lineEl=document.createElement("li");addClass(lineEl,swalClasses["progress-step-line"]);if(params.progressStepsDistance){applyNumericalStyle(lineEl,"width",params.progressStepsDistance)}return lineEl};const renderTitle=(instance,params)=>{const title=getTitle();if(!title){return}showWhenInnerHtmlPresent(title);toggle(title,params.title||params.titleText,"block");if(params.title){parseHtmlToContainer(params.title,title)}if(params.titleText){title.innerText=params.titleText}applyCustomClass(title,params,"title")};const render=(instance,params)=>{renderPopup(instance,params);renderContainer(instance,params);renderProgressSteps(instance,params);renderIcon(instance,params);renderImage(instance,params);renderTitle(instance,params);renderCloseButton(instance,params);renderContent(instance,params);renderActions(instance,params);renderFooter(instance,params);const popup=getPopup();if(typeof params.didRender==="function"&&popup){params.didRender(popup)}globalState.eventEmitter.emit("didRender",popup)};const isVisible=()=>{return isVisible$1(getPopup())};const clickConfirm=()=>{var _dom$getConfirmButton;return(_dom$getConfirmButton=getConfirmButton())===null||_dom$getConfirmButton===void 0?void 0:_dom$getConfirmButton.click()};const clickDeny=()=>{var _dom$getDenyButton;return(_dom$getDenyButton=getDenyButton())===null||_dom$getDenyButton===void 0?void 0:_dom$getDenyButton.click()};const clickCancel=()=>{var _dom$getCancelButton;return(_dom$getCancelButton=getCancelButton())===null||_dom$getCancelButton===void 0?void 0:_dom$getCancelButton.click()};const DismissReason=Object.freeze({cancel:"cancel",backdrop:"backdrop",close:"close",esc:"esc",timer:"timer"});const removeKeydownHandler=globalState=>{if(globalState.keydownTarget&&globalState.keydownHandlerAdded){globalState.keydownTarget.removeEventListener("keydown",globalState.keydownHandler,{capture:globalState.keydownListenerCapture});globalState.keydownHandlerAdded=false}};const addKeydownHandler=(globalState,innerParams,dismissWith)=>{removeKeydownHandler(globalState);if(!innerParams.toast){globalState.keydownHandler=e=>keydownHandler(innerParams,e,dismissWith);globalState.keydownTarget=innerParams.keydownListenerCapture?window:getPopup();globalState.keydownListenerCapture=innerParams.keydownListenerCapture;globalState.keydownTarget.addEventListener("keydown",globalState.keydownHandler,{capture:globalState.keydownListenerCapture});globalState.keydownHandlerAdded=true}};const setFocus=(index,increment)=>{var _dom$getPopup;const focusableElements=getFocusableElements();if(focusableElements.length){index=index+increment;if(index===-2){index=focusableElements.length-1}if(index===focusableElements.length){index=0}else if(index===-1){index=focusableElements.length-1}focusableElements[index].focus();return}(_dom$getPopup=getPopup())===null||_dom$getPopup===void 0||_dom$getPopup.focus()};const arrowKeysNextButton=["ArrowRight","ArrowDown"];const arrowKeysPreviousButton=["ArrowLeft","ArrowUp"];const keydownHandler=(innerParams,event,dismissWith)=>{if(!innerParams){return}if(event.isComposing||event.keyCode===229){return}if(innerParams.stopKeydownPropagation){event.stopPropagation()}if(event.key==="Enter"){handleEnter(event,innerParams)}else if(event.key==="Tab"){handleTab(event)}else if([...arrowKeysNextButton,...arrowKeysPreviousButton].includes(event.key)){handleArrows(event.key)}else if(event.key==="Escape"){handleEsc(event,innerParams,dismissWith)}};const handleEnter=(event,innerParams)=>{if(!callIfFunction(innerParams.allowEnterKey)){return}const input=getInput$1(getPopup(),innerParams.input);if(event.target&&input&&event.target instanceof HTMLElement&&event.target.outerHTML===input.outerHTML){if(["textarea","file"].includes(innerParams.input)){return}clickConfirm();event.preventDefault()}};const handleTab=event=>{const targetElement=event.target;const focusableElements=getFocusableElements();let btnIndex=-1;for(let i=0;i<focusableElements.length;i++){if(targetElement===focusableElements[i]){btnIndex=i;break}}if(!event.shiftKey){setFocus(btnIndex,1)}else{setFocus(btnIndex,-1)}event.stopPropagation();event.preventDefault()};const handleArrows=key=>{const actions=getActions();const confirmButton=getConfirmButton();const denyButton=getDenyButton();const cancelButton=getCancelButton();if(!actions||!confirmButton||!denyButton||!cancelButton){return}const buttons=[confirmButton,denyButton,cancelButton];if(document.activeElement instanceof HTMLElement&&!buttons.includes(document.activeElement)){return}const sibling=arrowKeysNextButton.includes(key)?"nextElementSibling":"previousElementSibling";let buttonToFocus=document.activeElement;if(!buttonToFocus){return}for(let i=0;i<actions.children.length;i++){buttonToFocus=buttonToFocus[sibling];if(!buttonToFocus){return}if(buttonToFocus instanceof HTMLButtonElement&&isVisible$1(buttonToFocus)){break}}if(buttonToFocus instanceof HTMLButtonElement){buttonToFocus.focus()}};const handleEsc=(event,innerParams,dismissWith)=>{if(callIfFunction(innerParams.allowEscapeKey)){event.preventDefault();dismissWith(DismissReason.esc)}};var privateMethods={swalPromiseResolve:new WeakMap,swalPromiseReject:new WeakMap};const setAriaHidden=()=>{const container=getContainer();const bodyChildren=Array.from(document.body.children);bodyChildren.forEach(el=>{if(el.contains(container)){return}if(el.hasAttribute("aria-hidden")){el.setAttribute("data-previous-aria-hidden",el.getAttribute("aria-hidden")||"")}el.setAttribute("aria-hidden","true")})};const unsetAriaHidden=()=>{const bodyChildren=Array.from(document.body.children);bodyChildren.forEach(el=>{if(el.hasAttribute("data-previous-aria-hidden")){el.setAttribute("aria-hidden",el.getAttribute("data-previous-aria-hidden")||"");el.removeAttribute("data-previous-aria-hidden")}else{el.removeAttribute("aria-hidden")}})};const isSafariOrIOS=typeof window!=="undefined"&&!!window.GestureEvent;const iOSfix=()=>{if(isSafariOrIOS&&!hasClass(document.body,swalClasses.iosfix)){const offset=document.body.scrollTop;document.body.style.top=`${offset*-1}px`;addClass(document.body,swalClasses.iosfix);lockBodyScroll()}};const lockBodyScroll=()=>{const container=getContainer();if(!container){return}let preventTouchMove;container.ontouchstart=event=>{preventTouchMove=shouldPreventTouchMove(event)};container.ontouchmove=event=>{if(preventTouchMove){event.preventDefault();event.stopPropagation()}}};const shouldPreventTouchMove=event=>{const target=event.target;const container=getContainer();const htmlContainer=getHtmlContainer();if(!container||!htmlContainer){return false}if(isStylus(event)||isZoom(event)){return false}if(target===container){return true}if(!isScrollable(container)&&target instanceof HTMLElement&&target.tagName!=="INPUT"&&target.tagName!=="TEXTAREA"&&!(isScrollable(htmlContainer)&&htmlContainer.contains(target))){return true}return false};const isStylus=event=>{return event.touches&&event.touches.length&&event.touches[0].touchType==="stylus"};const isZoom=event=>{return event.touches&&event.touches.length>1};const undoIOSfix=()=>{if(hasClass(document.body,swalClasses.iosfix)){const offset=parseInt(document.body.style.top,10);removeClass(document.body,swalClasses.iosfix);document.body.style.top="";document.body.scrollTop=offset*-1}};const measureScrollbar=()=>{const scrollDiv=document.createElement("div");scrollDiv.className=swalClasses["scrollbar-measure"];document.body.appendChild(scrollDiv);const scrollbarWidth=scrollDiv.getBoundingClientRect().width-scrollDiv.clientWidth;document.body.removeChild(scrollDiv);return scrollbarWidth};let previousBodyPadding=null;const replaceScrollbarWithPadding=initialBodyOverflow=>{if(previousBodyPadding!==null){return}if(document.body.scrollHeight>window.innerHeight||initialBodyOverflow==="scroll"){previousBodyPadding=parseInt(window.getComputedStyle(document.body).getPropertyValue("padding-right"));document.body.style.paddingRight=`${previousBodyPadding+measureScrollbar()}px`}};const undoReplaceScrollbarWithPadding=()=>{if(previousBodyPadding!==null){document.body.style.paddingRight=`${previousBodyPadding}px`;previousBodyPadding=null}};function removePopupAndResetState(instance,container,returnFocus,didClose){if(isToast()){triggerDidCloseAndDispose(instance,didClose)}else{restoreActiveElement(returnFocus).then(()=>triggerDidCloseAndDispose(instance,didClose));removeKeydownHandler(globalState)}if(isSafariOrIOS){container.setAttribute("style","display:none !important");container.removeAttribute("class");container.innerHTML=""}else{container.remove()}if(isModal()){undoReplaceScrollbarWithPadding();undoIOSfix();unsetAriaHidden()}removeBodyClasses()}function removeBodyClasses(){removeClass([document.documentElement,document.body],[swalClasses.shown,swalClasses["height-auto"],swalClasses["no-backdrop"],swalClasses["toast-shown"]])}function close(resolveValue){resolveValue=prepareResolveValue(resolveValue);const swalPromiseResolve=privateMethods.swalPromiseResolve.get(this);const didClose=triggerClosePopup(this);if(this.isAwaitingPromise){if(!resolveValue.isDismissed){handleAwaitingPromise(this);swalPromiseResolve(resolveValue)}}else if(didClose){swalPromiseResolve(resolveValue)}}const triggerClosePopup=instance=>{const popup=getPopup();if(!popup){return false}const innerParams=privateProps.innerParams.get(instance);if(!innerParams||hasClass(popup,innerParams.hideClass.popup)){return false}removeClass(popup,innerParams.showClass.popup);addClass(popup,innerParams.hideClass.popup);const backdrop=getContainer();removeClass(backdrop,innerParams.showClass.backdrop);addClass(backdrop,innerParams.hideClass.backdrop);handlePopupAnimation(instance,popup,innerParams);return true};function rejectPromise(error){const rejectPromise=privateMethods.swalPromiseReject.get(this);handleAwaitingPromise(this);if(rejectPromise){rejectPromise(error)}}const handleAwaitingPromise=instance=>{if(instance.isAwaitingPromise){delete instance.isAwaitingPromise;if(!privateProps.innerParams.get(instance)){instance._destroy()}}};const prepareResolveValue=resolveValue=>{if(typeof resolveValue==="undefined"){return{isConfirmed:false,isDenied:false,isDismissed:true}}return Object.assign({isConfirmed:false,isDenied:false,isDismissed:false},resolveValue)};const handlePopupAnimation=(instance,popup,innerParams)=>{var _globalState$eventEmi;const container=getContainer();const animationIsSupported=hasCssAnimation(popup);if(typeof innerParams.willClose==="function"){innerParams.willClose(popup)}(_globalState$eventEmi=globalState.eventEmitter)===null||_globalState$eventEmi===void 0||_globalState$eventEmi.emit("willClose",popup);if(animationIsSupported){animatePopup(instance,popup,container,innerParams.returnFocus,innerParams.didClose)}else{removePopupAndResetState(instance,container,innerParams.returnFocus,innerParams.didClose)}};const animatePopup=(instance,popup,container,returnFocus,didClose)=>{globalState.swalCloseEventFinishedCallback=removePopupAndResetState.bind(null,instance,container,returnFocus,didClose);const swalCloseAnimationFinished=function(e){if(e.target===popup){var _globalState$swalClos;(_globalState$swalClos=globalState.swalCloseEventFinishedCallback)===null||_globalState$swalClos===void 0||_globalState$swalClos.call(globalState);delete globalState.swalCloseEventFinishedCallback;popup.removeEventListener("animationend",swalCloseAnimationFinished);popup.removeEventListener("transitionend",swalCloseAnimationFinished)}};popup.addEventListener("animationend",swalCloseAnimationFinished);popup.addEventListener("transitionend",swalCloseAnimationFinished)};const triggerDidCloseAndDispose=(instance,didClose)=>{setTimeout(()=>{var _globalState$eventEmi2;if(typeof didClose==="function"){didClose.bind(instance.params)()}(_globalState$eventEmi2=globalState.eventEmitter)===null||_globalState$eventEmi2===void 0||_globalState$eventEmi2.emit("didClose");if(instance._destroy){instance._destroy()}})};const showLoading=buttonToReplace=>{let popup=getPopup();if(!popup){new Swal}popup=getPopup();if(!popup){return}const loader=getLoader();if(isToast()){hide(getIcon())}else{replaceButton(popup,buttonToReplace)}show(loader);popup.setAttribute("data-loading","true");popup.setAttribute("aria-busy","true");popup.focus()};const replaceButton=(popup,buttonToReplace)=>{const actions=getActions();const loader=getLoader();if(!actions||!loader){return}if(!buttonToReplace&&isVisible$1(getConfirmButton())){buttonToReplace=getConfirmButton()}show(actions);if(buttonToReplace){hide(buttonToReplace);loader.setAttribute("data-button-to-replace",buttonToReplace.className);actions.insertBefore(loader,buttonToReplace)}addClass([popup,actions],swalClasses.loading)};const handleInputOptionsAndValue=(instance,params)=>{if(params.input==="select"||params.input==="radio"){handleInputOptions(instance,params)}else if(["text","email","number","tel","textarea"].some(i=>i===params.input)&&(hasToPromiseFn(params.inputValue)||isPromise(params.inputValue))){showLoading(getConfirmButton());handleInputValue(instance,params)}};const getInputValue=(instance,innerParams)=>{const input=instance.getInput();if(!input){return null}switch(innerParams.input){case"checkbox":return getCheckboxValue(input);case"radio":return getRadioValue(input);case"file":return getFileValue(input);default:return innerParams.inputAutoTrim?input.value.trim():input.value}};const getCheckboxValue=input=>input.checked?1:0;const getRadioValue=input=>input.checked?input.value:null;const getFileValue=input=>input.files&&input.files.length?input.getAttribute("multiple")!==null?input.files:input.files[0]:null;const handleInputOptions=(instance,params)=>{const popup=getPopup();if(!popup){return}const processInputOptions=inputOptions=>{if(params.input==="select"){populateSelectOptions(popup,formatInputOptions(inputOptions),params)}else if(params.input==="radio"){populateRadioOptions(popup,formatInputOptions(inputOptions),params)}};if(hasToPromiseFn(params.inputOptions)||isPromise(params.inputOptions)){showLoading(getConfirmButton());asPromise(params.inputOptions).then(inputOptions=>{instance.hideLoading();processInputOptions(inputOptions)})}else if(typeof params.inputOptions==="object"){processInputOptions(params.inputOptions)}else{error(`Unexpected type of inputOptions! Expected object, Map or Promise, got ${typeof params.inputOptions}`)}};const handleInputValue=(instance,params)=>{const input=instance.getInput();if(!input){return}hide(input);asPromise(params.inputValue).then(inputValue=>{input.value=params.input==="number"?`${parseFloat(inputValue)||0}`:`${inputValue}`;show(input);input.focus();instance.hideLoading()}).catch(err=>{error(`Error in inputValue promise: ${err}`);input.value="";show(input);input.focus();instance.hideLoading()})};function populateSelectOptions(popup,inputOptions,params){const select=getDirectChildByClass(popup,swalClasses.select);if(!select){return}const renderOption=(parent,optionLabel,optionValue)=>{const option=document.createElement("option");option.value=optionValue;setInnerHtml(option,optionLabel);option.selected=isSelected(optionValue,params.inputValue);parent.appendChild(option)};inputOptions.forEach(inputOption=>{const optionValue=inputOption[0];const optionLabel=inputOption[1];if(Array.isArray(optionLabel)){const optgroup=document.createElement("optgroup");optgroup.label=optionValue;optgroup.disabled=false;select.appendChild(optgroup);optionLabel.forEach(o=>renderOption(optgroup,o[1],o[0]))}else{renderOption(select,optionLabel,optionValue)}});select.focus()}function populateRadioOptions(popup,inputOptions,params){const radio=getDirectChildByClass(popup,swalClasses.radio);if(!radio){return}inputOptions.forEach(inputOption=>{const radioValue=inputOption[0];const radioLabel=inputOption[1];const radioInput=document.createElement("input");const radioLabelElement=document.createElement("label");radioInput.type="radio";radioInput.name=swalClasses.radio;radioInput.value=radioValue;if(isSelected(radioValue,params.inputValue)){radioInput.checked=true}const label=document.createElement("span");setInnerHtml(label,radioLabel);label.className=swalClasses.label;radioLabelElement.appendChild(radioInput);radioLabelElement.appendChild(label);radio.appendChild(radioLabelElement)});const radios=radio.querySelectorAll("input");if(radios.length){radios[0].focus()}}const formatInputOptions=inputOptions=>{const result=[];if(inputOptions instanceof Map){inputOptions.forEach((value,key)=>{let valueFormatted=value;if(typeof valueFormatted==="object"){valueFormatted=formatInputOptions(valueFormatted)}result.push([key,valueFormatted])})}else{Object.keys(inputOptions).forEach(key=>{let valueFormatted=inputOptions[key];if(typeof valueFormatted==="object"){valueFormatted=formatInputOptions(valueFormatted)}result.push([key,valueFormatted])})}return result};const isSelected=(optionValue,inputValue)=>{return!!inputValue&&inputValue.toString()===optionValue.toString()};const handleConfirmButtonClick=instance=>{const innerParams=privateProps.innerParams.get(instance);instance.disableButtons();if(innerParams.input){handleConfirmOrDenyWithInput(instance,"confirm")}else{confirm(instance,true)}};const handleDenyButtonClick=instance=>{const innerParams=privateProps.innerParams.get(instance);instance.disableButtons();if(innerParams.returnInputValueOnDeny){handleConfirmOrDenyWithInput(instance,"deny")}else{deny(instance,false)}};const handleCancelButtonClick=(instance,dismissWith)=>{instance.disableButtons();dismissWith(DismissReason.cancel)};const handleConfirmOrDenyWithInput=(instance,type)=>{const innerParams=privateProps.innerParams.get(instance);if(!innerParams.input){error(`The "input" parameter is needed to be set when using returnInputValueOn${capitalizeFirstLetter(type)}`);return}const input=instance.getInput();const inputValue=getInputValue(instance,innerParams);if(innerParams.inputValidator){handleInputValidator(instance,inputValue,type)}else if(input&&!input.checkValidity()){instance.enableButtons();instance.showValidationMessage(innerParams.validationMessage||input.validationMessage)}else if(type==="deny"){deny(instance,inputValue)}else{confirm(instance,inputValue)}};const handleInputValidator=(instance,inputValue,type)=>{const innerParams=privateProps.innerParams.get(instance);instance.disableInput();const validationPromise=Promise.resolve().then(()=>asPromise(innerParams.inputValidator(inputValue,innerParams.validationMessage)));validationPromise.then(validationMessage=>{instance.enableButtons();instance.enableInput();if(validationMessage){instance.showValidationMessage(validationMessage)}else if(type==="deny"){deny(instance,inputValue)}else{confirm(instance,inputValue)}})};const deny=(instance,value)=>{const innerParams=privateProps.innerParams.get(instance||undefined);if(innerParams.showLoaderOnDeny){showLoading(getDenyButton())}if(innerParams.preDeny){instance.isAwaitingPromise=true;const preDenyPromise=Promise.resolve().then(()=>asPromise(innerParams.preDeny(value,innerParams.validationMessage)));preDenyPromise.then(preDenyValue=>{if(preDenyValue===false){instance.hideLoading();handleAwaitingPromise(instance)}else{instance.close({isDenied:true,value:typeof preDenyValue==="undefined"?value:preDenyValue})}}).catch(error=>rejectWith(instance||undefined,error))}else{instance.close({isDenied:true,value:value})}};const succeedWith=(instance,value)=>{instance.close({isConfirmed:true,value:value})};const rejectWith=(instance,error)=>{instance.rejectPromise(error)};const confirm=(instance,value)=>{const innerParams=privateProps.innerParams.get(instance||undefined);if(innerParams.showLoaderOnConfirm){showLoading()}if(innerParams.preConfirm){instance.resetValidationMessage();instance.isAwaitingPromise=true;const preConfirmPromise=Promise.resolve().then(()=>asPromise(innerParams.preConfirm(value,innerParams.validationMessage)));preConfirmPromise.then(preConfirmValue=>{if(isVisible$1(getValidationMessage())||preConfirmValue===false){instance.hideLoading();handleAwaitingPromise(instance)}else{succeedWith(instance,typeof preConfirmValue==="undefined"?value:preConfirmValue)}}).catch(error=>rejectWith(instance||undefined,error))}else{succeedWith(instance,value)}};function hideLoading(){const innerParams=privateProps.innerParams.get(this);if(!innerParams){return}const domCache=privateProps.domCache.get(this);hide(domCache.loader);if(isToast()){if(innerParams.icon){show(getIcon())}}else{showRelatedButton(domCache)}removeClass([domCache.popup,domCache.actions],swalClasses.loading);domCache.popup.removeAttribute("aria-busy");domCache.popup.removeAttribute("data-loading");domCache.confirmButton.disabled=false;domCache.denyButton.disabled=false;domCache.cancelButton.disabled=false}const showRelatedButton=domCache=>{const buttonToReplace=domCache.popup.getElementsByClassName(domCache.loader.getAttribute("data-button-to-replace"));if(buttonToReplace.length){show(buttonToReplace[0],"inline-block")}else if(allButtonsAreHidden()){hide(domCache.actions)}};function getInput(){const innerParams=privateProps.innerParams.get(this);const domCache=privateProps.domCache.get(this);if(!domCache){return null}return getInput$1(domCache.popup,innerParams.input)}function setButtonsDisabled(instance,buttons,disabled){const domCache=privateProps.domCache.get(instance);buttons.forEach(button=>{domCache[button].disabled=disabled})}function setInputDisabled(input,disabled){const popup=getPopup();if(!popup||!input){return}if(input.type==="radio"){const radios=popup.querySelectorAll(`[name="${swalClasses.radio}"]`);for(let i=0;i<radios.length;i++){radios[i].disabled=disabled}}else{input.disabled=disabled}}function enableButtons(){setButtonsDisabled(this,["confirmButton","denyButton","cancelButton"],false)}function disableButtons(){setButtonsDisabled(this,["confirmButton","denyButton","cancelButton"],true)}function enableInput(){setInputDisabled(this.getInput(),false)}function disableInput(){setInputDisabled(this.getInput(),true)}function showValidationMessage(error){const domCache=privateProps.domCache.get(this);const params=privateProps.innerParams.get(this);setInnerHtml(domCache.validationMessage,error);domCache.validationMessage.className=swalClasses["validation-message"];if(params.customClass&&params.customClass.validationMessage){addClass(domCache.validationMessage,params.customClass.validationMessage)}show(domCache.validationMessage);const input=this.getInput();if(input){input.setAttribute("aria-invalid","true");input.setAttribute("aria-describedby",swalClasses["validation-message"]);focusInput(input);addClass(input,swalClasses.inputerror)}}function resetValidationMessage(){const domCache=privateProps.domCache.get(this);if(domCache.validationMessage){hide(domCache.validationMessage)}const input=this.getInput();if(input){input.removeAttribute("aria-invalid");input.removeAttribute("aria-describedby");removeClass(input,swalClasses.inputerror)}}const defaultParams={title:"",titleText:"",text:"",html:"",footer:"",icon:undefined,iconColor:undefined,iconHtml:undefined,template:undefined,toast:false,draggable:false,animation:true,theme:"light",showClass:{popup:"swal2-show",backdrop:"swal2-backdrop-show",icon:"swal2-icon-show"},hideClass:{popup:"swal2-hide",backdrop:"swal2-backdrop-hide",icon:"swal2-icon-hide"},customClass:{},target:"body",color:undefined,backdrop:true,heightAuto:true,allowOutsideClick:true,allowEscapeKey:true,allowEnterKey:true,stopKeydownPropagation:true,keydownListenerCapture:false,showConfirmButton:true,showDenyButton:false,showCancelButton:false,preConfirm:undefined,preDeny:undefined,confirmButtonText:"OK",confirmButtonAriaLabel:"",confirmButtonColor:undefined,denyButtonText:"No",denyButtonAriaLabel:"",denyButtonColor:undefined,cancelButtonText:"Cancel",cancelButtonAriaLabel:"",cancelButtonColor:undefined,buttonsStyling:true,reverseButtons:false,focusConfirm:true,focusDeny:false,focusCancel:false,returnFocus:true,showCloseButton:false,closeButtonHtml:"&times;",closeButtonAriaLabel:"Close this dialog",loaderHtml:"",showLoaderOnConfirm:false,showLoaderOnDeny:false,imageUrl:undefined,imageWidth:undefined,imageHeight:undefined,imageAlt:"",timer:undefined,timerProgressBar:false,width:undefined,padding:undefined,background:undefined,input:undefined,inputPlaceholder:"",inputLabel:"",inputValue:"",inputOptions:{},inputAutoFocus:true,inputAutoTrim:true,inputAttributes:{},inputValidator:undefined,returnInputValueOnDeny:false,validationMessage:undefined,grow:false,position:"center",progressSteps:[],currentProgressStep:undefined,progressStepsDistance:undefined,willOpen:undefined,didOpen:undefined,didRender:undefined,willClose:undefined,didClose:undefined,didDestroy:undefined,scrollbarPadding:true,topLayer:false};const updatableParams=["allowEscapeKey","allowOutsideClick","background","buttonsStyling","cancelButtonAriaLabel","cancelButtonColor","cancelButtonText","closeButtonAriaLabel","closeButtonHtml","color","confirmButtonAriaLabel","confirmButtonColor","confirmButtonText","currentProgressStep","customClass","denyButtonAriaLabel","denyButtonColor","denyButtonText","didClose","didDestroy","draggable","footer","hideClass","html","icon","iconColor","iconHtml","imageAlt","imageHeight","imageUrl","imageWidth","preConfirm","preDeny","progressSteps","returnFocus","reverseButtons","showCancelButton","showCloseButton","showConfirmButton","showDenyButton","text","title","titleText","theme","willClose"];const deprecatedParams={allowEnterKey:undefined};const toastIncompatibleParams=["allowOutsideClick","allowEnterKey","backdrop","draggable","focusConfirm","focusDeny","focusCancel","returnFocus","heightAuto","keydownListenerCapture"];const isValidParameter=paramName=>{return Object.prototype.hasOwnProperty.call(defaultParams,paramName)};const isUpdatableParameter=paramName=>{return updatableParams.indexOf(paramName)!==-1};const isDeprecatedParameter=paramName=>{return deprecatedParams[paramName]};const checkIfParamIsValid=param=>{if(!isValidParameter(param)){warn(`Unknown parameter "${param}"`)}};const checkIfToastParamIsValid=param=>{if(toastIncompatibleParams.includes(param)){warn(`The parameter "${param}" is incompatible with toasts`)}};const checkIfParamIsDeprecated=param=>{const isDeprecated=isDeprecatedParameter(param);if(isDeprecated){warnAboutDeprecation(param,isDeprecated)}};const showWarningsForParams=params=>{if(params.backdrop===false&&params.allowOutsideClick){warn('"allowOutsideClick" parameter requires `backdrop` parameter to be set to `true`')}if(params.theme&&!["light","dark","auto","minimal","borderless","embed-iframe"].includes(params.theme)){warn(`Invalid theme "${params.theme}". Expected "light", "dark", "auto", "minimal", "borderless", or "embed-iframe"`)}for(const param in params){checkIfParamIsValid(param);if(params.toast){checkIfToastParamIsValid(param)}checkIfParamIsDeprecated(param)}};function update(params){const container=getContainer();const popup=getPopup();const innerParams=privateProps.innerParams.get(this);if(!popup||hasClass(popup,innerParams.hideClass.popup)){warn(`You're trying to update the closed or closing popup, that won't work. Use the update() method in preConfirm parameter or show a new popup.`);return}const validUpdatableParams=filterValidParams(params);const updatedParams=Object.assign({},innerParams,validUpdatableParams);showWarningsForParams(updatedParams);container.dataset["swal2Theme"]=updatedParams.theme;render(this,updatedParams);privateProps.innerParams.set(this,updatedParams);Object.defineProperties(this,{params:{value:Object.assign({},this.params,params),writable:false,enumerable:true}})}const filterValidParams=params=>{const validUpdatableParams={};Object.keys(params).forEach(param=>{if(isUpdatableParameter(param)){validUpdatableParams[param]=params[param]}else{warn(`Invalid parameter to update: ${param}`)}});return validUpdatableParams};function _destroy(){const domCache=privateProps.domCache.get(this);const innerParams=privateProps.innerParams.get(this);if(!innerParams){disposeWeakMaps(this);return}if(domCache.popup&&globalState.swalCloseEventFinishedCallback){globalState.swalCloseEventFinishedCallback();delete globalState.swalCloseEventFinishedCallback}if(typeof innerParams.didDestroy==="function"){innerParams.didDestroy()}globalState.eventEmitter.emit("didDestroy");disposeSwal(this)}const disposeSwal=instance=>{disposeWeakMaps(instance);delete instance.params;delete globalState.keydownHandler;delete globalState.keydownTarget;delete globalState.currentInstance};const disposeWeakMaps=instance=>{if(instance.isAwaitingPromise){unsetWeakMaps(privateProps,instance);instance.isAwaitingPromise=true}else{unsetWeakMaps(privateMethods,instance);unsetWeakMaps(privateProps,instance);delete instance.isAwaitingPromise;delete instance.disableButtons;delete instance.enableButtons;delete instance.getInput;delete instance.disableInput;delete instance.enableInput;delete instance.hideLoading;delete instance.disableLoading;delete instance.showValidationMessage;delete instance.resetValidationMessage;delete instance.close;delete instance.closePopup;delete instance.closeModal;delete instance.closeToast;delete instance.rejectPromise;delete instance.update;delete instance._destroy}};const unsetWeakMaps=(obj,instance)=>{for(const i in obj){obj[i].delete(instance)}};var instanceMethods=Object.freeze({__proto__:null,_destroy:_destroy,close:close,closeModal:close,closePopup:close,closeToast:close,disableButtons:disableButtons,disableInput:disableInput,disableLoading:hideLoading,enableButtons:enableButtons,enableInput:enableInput,getInput:getInput,handleAwaitingPromise:handleAwaitingPromise,hideLoading:hideLoading,rejectPromise:rejectPromise,resetValidationMessage:resetValidationMessage,showValidationMessage:showValidationMessage,update:update});const handlePopupClick=(innerParams,domCache,dismissWith)=>{if(innerParams.toast){handleToastClick(innerParams,domCache,dismissWith)}else{handleModalMousedown(domCache);handleContainerMousedown(domCache);handleModalClick(innerParams,domCache,dismissWith)}};const handleToastClick=(innerParams,domCache,dismissWith)=>{domCache.popup.onclick=()=>{if(innerParams&&(isAnyButtonShown(innerParams)||innerParams.timer||innerParams.input)){return}dismissWith(DismissReason.close)}};const isAnyButtonShown=innerParams=>{return!!(innerParams.showConfirmButton||innerParams.showDenyButton||innerParams.showCancelButton||innerParams.showCloseButton)};let ignoreOutsideClick=false;const handleModalMousedown=domCache=>{domCache.popup.onmousedown=()=>{domCache.container.onmouseup=function(e){domCache.container.onmouseup=()=>{};if(e.target===domCache.container){ignoreOutsideClick=true}}}};const handleContainerMousedown=domCache=>{domCache.container.onmousedown=e=>{if(e.target===domCache.container){e.preventDefault()}domCache.popup.onmouseup=function(e){domCache.popup.onmouseup=()=>{};if(e.target===domCache.popup||e.target instanceof HTMLElement&&domCache.popup.contains(e.target)){ignoreOutsideClick=true}}}};const handleModalClick=(innerParams,domCache,dismissWith)=>{domCache.container.onclick=e=>{if(ignoreOutsideClick){ignoreOutsideClick=false;return}if(e.target===domCache.container&&callIfFunction(innerParams.allowOutsideClick)){dismissWith(DismissReason.backdrop)}}};const isJqueryElement=elem=>typeof elem==="object"&&elem.jquery;const isElement=elem=>elem instanceof Element||isJqueryElement(elem);const argsToParams=args=>{const params={};if(typeof args[0]==="object"&&!isElement(args[0])){Object.assign(params,args[0])}else{["title","html","icon"].forEach((name,index)=>{const arg=args[index];if(typeof arg==="string"||isElement(arg)){params[name]=arg}else if(arg!==undefined){error(`Unexpected type of ${name}! Expected "string" or "Element", got ${typeof arg}`)}})}return params};function fire(){for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}return new this(...args)}function mixin(mixinParams){class MixinSwal extends this{_main(params,priorityMixinParams){return super._main(params,Object.assign({},mixinParams,priorityMixinParams))}}return MixinSwal}const getTimerLeft=()=>{return globalState.timeout&&globalState.timeout.getTimerLeft()};const stopTimer=()=>{if(globalState.timeout){stopTimerProgressBar();return globalState.timeout.stop()}};const resumeTimer=()=>{if(globalState.timeout){const remaining=globalState.timeout.start();animateTimerProgressBar(remaining);return remaining}};const toggleTimer=()=>{const timer=globalState.timeout;return timer&&(timer.running?stopTimer():resumeTimer())};const increaseTimer=ms=>{if(globalState.timeout){const remaining=globalState.timeout.increase(ms);animateTimerProgressBar(remaining,true);return remaining}};const isTimerRunning=()=>{return!!(globalState.timeout&&globalState.timeout.isRunning())};let bodyClickListenerAdded=false;const clickHandlers={};function bindClickHandler(){let attr=arguments.length>0&&arguments[0]!==undefined?arguments[0]:"data-swal-template";clickHandlers[attr]=this;if(!bodyClickListenerAdded){document.body.addEventListener("click",bodyClickListener);bodyClickListenerAdded=true}}const bodyClickListener=event=>{for(let el=event.target;el&&el!==document;el=el.parentNode){for(const attr in clickHandlers){const template=el.getAttribute(attr);if(template){clickHandlers[attr].fire({template:template});return}}}};class EventEmitter{constructor(){this.events={}}_getHandlersByEventName(eventName){if(typeof this.events[eventName]==="undefined"){this.events[eventName]=[]}return this.events[eventName]}on(eventName,eventHandler){const currentHandlers=this._getHandlersByEventName(eventName);if(!currentHandlers.includes(eventHandler)){currentHandlers.push(eventHandler)}}once(eventName,eventHandler){var _this=this;const onceFn=function(){_this.removeListener(eventName,onceFn);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}eventHandler.apply(_this,args)};this.on(eventName,onceFn)}emit(eventName){for(var _len2=arguments.length,args=new Array(_len2>1?_len2-1:0),_key2=1;_key2<_len2;_key2++){args[_key2-1]=arguments[_key2]}this._getHandlersByEventName(eventName).forEach(eventHandler=>{try{eventHandler.apply(this,args)}catch(error){console.error(error)}})}removeListener(eventName,eventHandler){const currentHandlers=this._getHandlersByEventName(eventName);const index=currentHandlers.indexOf(eventHandler);if(index>-1){currentHandlers.splice(index,1)}}removeAllListeners(eventName){if(this.events[eventName]!==undefined){this.events[eventName].length=0}}reset(){this.events={}}}globalState.eventEmitter=new EventEmitter;const on=(eventName,eventHandler)=>{globalState.eventEmitter.on(eventName,eventHandler)};const once=(eventName,eventHandler)=>{globalState.eventEmitter.once(eventName,eventHandler)};const off=(eventName,eventHandler)=>{if(!eventName){globalState.eventEmitter.reset();return}if(eventHandler){globalState.eventEmitter.removeListener(eventName,eventHandler)}else{globalState.eventEmitter.removeAllListeners(eventName)}};var staticMethods=Object.freeze({__proto__:null,argsToParams:argsToParams,bindClickHandler:bindClickHandler,clickCancel:clickCancel,clickConfirm:clickConfirm,clickDeny:clickDeny,enableLoading:showLoading,fire:fire,getActions:getActions,getCancelButton:getCancelButton,getCloseButton:getCloseButton,getConfirmButton:getConfirmButton,getContainer:getContainer,getDenyButton:getDenyButton,getFocusableElements:getFocusableElements,getFooter:getFooter,getHtmlContainer:getHtmlContainer,getIcon:getIcon,getIconContent:getIconContent,getImage:getImage,getInputLabel:getInputLabel,getLoader:getLoader,getPopup:getPopup,getProgressSteps:getProgressSteps,getTimerLeft:getTimerLeft,getTimerProgressBar:getTimerProgressBar,getTitle:getTitle,getValidationMessage:getValidationMessage,increaseTimer:increaseTimer,isDeprecatedParameter:isDeprecatedParameter,isLoading:isLoading,isTimerRunning:isTimerRunning,isUpdatableParameter:isUpdatableParameter,isValidParameter:isValidParameter,isVisible:isVisible,mixin:mixin,off:off,on:on,once:once,resumeTimer:resumeTimer,showLoading:showLoading,stopTimer:stopTimer,toggleTimer:toggleTimer});class Timer{constructor(callback,delay){this.callback=callback;this.remaining=delay;this.running=false;this.start()}start(){if(!this.running){this.running=true;this.started=new Date;this.id=setTimeout(this.callback,this.remaining)}return this.remaining}stop(){if(this.started&&this.running){this.running=false;clearTimeout(this.id);this.remaining-=(new Date).getTime()-this.started.getTime()}return this.remaining}increase(n){const running=this.running;if(running){this.stop()}this.remaining+=n;if(running){this.start()}return this.remaining}getTimerLeft(){if(this.running){this.stop();this.start()}return this.remaining}isRunning(){return this.running}}const swalStringParams=["swal-title","swal-html","swal-footer"];const getTemplateParams=params=>{const template=typeof params.template==="string"?document.querySelector(params.template):params.template;if(!template){return{}}const templateContent=template.content;showWarningsForElements(templateContent);const result=Object.assign(getSwalParams(templateContent),getSwalFunctionParams(templateContent),getSwalButtons(templateContent),getSwalImage(templateContent),getSwalIcon(templateContent),getSwalInput(templateContent),getSwalStringParams(templateContent,swalStringParams));return result};const getSwalParams=templateContent=>{const result={};const swalParams=Array.from(templateContent.querySelectorAll("swal-param"));swalParams.forEach(param=>{showWarningsForAttributes(param,["name","value"]);const paramName=param.getAttribute("name");const value=param.getAttribute("value");if(!paramName||!value){return}if(typeof defaultParams[paramName]==="boolean"){result[paramName]=value!=="false"}else if(typeof defaultParams[paramName]==="object"){result[paramName]=JSON.parse(value)}else{result[paramName]=value}});return result};const getSwalFunctionParams=templateContent=>{const result={};const swalFunctions=Array.from(templateContent.querySelectorAll("swal-function-param"));swalFunctions.forEach(param=>{const paramName=param.getAttribute("name");const value=param.getAttribute("value");if(!paramName||!value){return}result[paramName]=new Function(`return ${value}`)()});return result};const getSwalButtons=templateContent=>{const result={};const swalButtons=Array.from(templateContent.querySelectorAll("swal-button"));swalButtons.forEach(button=>{showWarningsForAttributes(button,["type","color","aria-label"]);const type=button.getAttribute("type");if(!type||!["confirm","cancel","deny"].includes(type)){return}result[`${type}ButtonText`]=button.innerHTML;result[`show${capitalizeFirstLetter(type)}Button`]=true;if(button.hasAttribute("color")){result[`${type}ButtonColor`]=button.getAttribute("color")}if(button.hasAttribute("aria-label")){result[`${type}ButtonAriaLabel`]=button.getAttribute("aria-label")}});return result};const getSwalImage=templateContent=>{const result={};const image=templateContent.querySelector("swal-image");if(image){showWarningsForAttributes(image,["src","width","height","alt"]);if(image.hasAttribute("src")){result.imageUrl=image.getAttribute("src")||undefined}if(image.hasAttribute("width")){result.imageWidth=image.getAttribute("width")||undefined}if(image.hasAttribute("height")){result.imageHeight=image.getAttribute("height")||undefined}if(image.hasAttribute("alt")){result.imageAlt=image.getAttribute("alt")||undefined}}return result};const getSwalIcon=templateContent=>{const result={};const icon=templateContent.querySelector("swal-icon");if(icon){showWarningsForAttributes(icon,["type","color"]);if(icon.hasAttribute("type")){result.icon=icon.getAttribute("type")}if(icon.hasAttribute("color")){result.iconColor=icon.getAttribute("color")}result.iconHtml=icon.innerHTML}return result};const getSwalInput=templateContent=>{const result={};const input=templateContent.querySelector("swal-input");if(input){showWarningsForAttributes(input,["type","label","placeholder","value"]);result.input=input.getAttribute("type")||"text";if(input.hasAttribute("label")){result.inputLabel=input.getAttribute("label")}if(input.hasAttribute("placeholder")){result.inputPlaceholder=input.getAttribute("placeholder")}if(input.hasAttribute("value")){result.inputValue=input.getAttribute("value")}}const inputOptions=Array.from(templateContent.querySelectorAll("swal-input-option"));if(inputOptions.length){result.inputOptions={};inputOptions.forEach(option=>{showWarningsForAttributes(option,["value"]);const optionValue=option.getAttribute("value");if(!optionValue){return}const optionName=option.innerHTML;result.inputOptions[optionValue]=optionName})}return result};const getSwalStringParams=(templateContent,paramNames)=>{const result={};for(const i in paramNames){const paramName=paramNames[i];const tag=templateContent.querySelector(paramName);if(tag){showWarningsForAttributes(tag,[]);result[paramName.replace(/^swal-/,"")]=tag.innerHTML.trim()}}return result};const showWarningsForElements=templateContent=>{const allowedElements=swalStringParams.concat(["swal-param","swal-function-param","swal-button","swal-image","swal-icon","swal-input","swal-input-option"]);Array.from(templateContent.children).forEach(el=>{const tagName=el.tagName.toLowerCase();if(!allowedElements.includes(tagName)){warn(`Unrecognized element <${tagName}>`)}})};const showWarningsForAttributes=(el,allowedAttributes)=>{Array.from(el.attributes).forEach(attribute=>{if(allowedAttributes.indexOf(attribute.name)===-1){warn([`Unrecognized attribute "${attribute.name}" on <${el.tagName.toLowerCase()}>.`,`${allowedAttributes.length?`Allowed attributes are: ${allowedAttributes.join(", ")}`:"To set the value, use HTML within the element."}`])}})};const SHOW_CLASS_TIMEOUT=10;const openPopup=params=>{const container=getContainer();const popup=getPopup();if(typeof params.willOpen==="function"){params.willOpen(popup)}globalState.eventEmitter.emit("willOpen",popup);const bodyStyles=window.getComputedStyle(document.body);const initialBodyOverflow=bodyStyles.overflowY;addClasses(container,popup,params);setTimeout(()=>{setScrollingVisibility(container,popup)},SHOW_CLASS_TIMEOUT);if(isModal()){fixScrollContainer(container,params.scrollbarPadding,initialBodyOverflow);setAriaHidden()}if(!isToast()&&!globalState.previousActiveElement){globalState.previousActiveElement=document.activeElement}if(typeof params.didOpen==="function"){setTimeout(()=>params.didOpen(popup))}globalState.eventEmitter.emit("didOpen",popup);removeClass(container,swalClasses["no-transition"])};const swalOpenAnimationFinished=event=>{const popup=getPopup();if(event.target!==popup){return}const container=getContainer();popup.removeEventListener("animationend",swalOpenAnimationFinished);popup.removeEventListener("transitionend",swalOpenAnimationFinished);container.style.overflowY="auto"};const setScrollingVisibility=(container,popup)=>{if(hasCssAnimation(popup)){container.style.overflowY="hidden";popup.addEventListener("animationend",swalOpenAnimationFinished);popup.addEventListener("transitionend",swalOpenAnimationFinished)}else{container.style.overflowY="auto"}};const fixScrollContainer=(container,scrollbarPadding,initialBodyOverflow)=>{iOSfix();if(scrollbarPadding&&initialBodyOverflow!=="hidden"){replaceScrollbarWithPadding(initialBodyOverflow)}setTimeout(()=>{container.scrollTop=0})};const addClasses=(container,popup,params)=>{addClass(container,params.showClass.backdrop);if(params.animation){popup.style.setProperty("opacity","0","important");show(popup,"grid");setTimeout(()=>{addClass(popup,params.showClass.popup);popup.style.removeProperty("opacity")},SHOW_CLASS_TIMEOUT)}else{show(popup,"grid")}addClass([document.documentElement,document.body],swalClasses.shown);if(params.heightAuto&&params.backdrop&&!params.toast){addClass([document.documentElement,document.body],swalClasses["height-auto"])}};var defaultInputValidators={email:(string,validationMessage)=>{return/^[a-zA-Z0-9.+_'-]+@[a-zA-Z0-9.-]+\.[a-zA-Z0-9-]+$/.test(string)?Promise.resolve():Promise.resolve(validationMessage||"Invalid email address")},url:(string,validationMessage)=>{return/^https?:\/\/(www\.)?[-a-zA-Z0-9@:%._+~#=]{1,256}\.[a-z]{2,63}\b([-a-zA-Z0-9@:%_+.~#?&/=]*)$/.test(string)?Promise.resolve():Promise.resolve(validationMessage||"Invalid URL")}};function setDefaultInputValidators(params){if(params.inputValidator){return}if(params.input==="email"){params.inputValidator=defaultInputValidators["email"]}if(params.input==="url"){params.inputValidator=defaultInputValidators["url"]}}function validateCustomTargetElement(params){if(!params.target||typeof params.target==="string"&&!document.querySelector(params.target)||typeof params.target!=="string"&&!params.target.appendChild){warn('Target parameter is not valid, defaulting to "body"');params.target="body"}}function setParameters(params){setDefaultInputValidators(params);if(params.showLoaderOnConfirm&&!params.preConfirm){warn("showLoaderOnConfirm is set to true, but preConfirm is not defined.\n"+"showLoaderOnConfirm should be used together with preConfirm, see usage example:\n"+"https://sweetalert2.github.io/#ajax-request")}validateCustomTargetElement(params);if(typeof params.title==="string"){params.title=params.title.split("\n").join("<br />")}init(params)}let currentInstance;var _promise=new WeakMap;class SweetAlert{constructor(){_classPrivateFieldInitSpec(this,_promise,void 0);if(typeof window==="undefined"){return}currentInstance=this;for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}const outerParams=Object.freeze(this.constructor.argsToParams(args));this.params=outerParams;this.isAwaitingPromise=false;_classPrivateFieldSet2(_promise,this,this._main(currentInstance.params))}_main(userParams){let mixinParams=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};showWarningsForParams(Object.assign({},mixinParams,userParams));if(globalState.currentInstance){const swalPromiseResolve=privateMethods.swalPromiseResolve.get(globalState.currentInstance);const{isAwaitingPromise}=globalState.currentInstance;globalState.currentInstance._destroy();if(!isAwaitingPromise){swalPromiseResolve({isDismissed:true})}if(isModal()){unsetAriaHidden()}}globalState.currentInstance=currentInstance;const innerParams=prepareParams(userParams,mixinParams);setParameters(innerParams);Object.freeze(innerParams);if(globalState.timeout){globalState.timeout.stop();delete globalState.timeout}clearTimeout(globalState.restoreFocusTimeout);const domCache=populateDomCache(currentInstance);render(currentInstance,innerParams);privateProps.innerParams.set(currentInstance,innerParams);return swalPromise(currentInstance,domCache,innerParams)}then(onFulfilled){return _classPrivateFieldGet2(_promise,this).then(onFulfilled)}finally(onFinally){return _classPrivateFieldGet2(_promise,this).finally(onFinally)}}const swalPromise=(instance,domCache,innerParams)=>{return new Promise((resolve,reject)=>{const dismissWith=dismiss=>{instance.close({isDismissed:true,dismiss:dismiss})};privateMethods.swalPromiseResolve.set(instance,resolve);privateMethods.swalPromiseReject.set(instance,reject);domCache.confirmButton.onclick=()=>{handleConfirmButtonClick(instance)};domCache.denyButton.onclick=()=>{handleDenyButtonClick(instance)};domCache.cancelButton.onclick=()=>{handleCancelButtonClick(instance,dismissWith)};domCache.closeButton.onclick=()=>{dismissWith(DismissReason.close)};handlePopupClick(innerParams,domCache,dismissWith);addKeydownHandler(globalState,innerParams,dismissWith);handleInputOptionsAndValue(instance,innerParams);openPopup(innerParams);setupTimer(globalState,innerParams,dismissWith);initFocus(domCache,innerParams);setTimeout(()=>{domCache.container.scrollTop=0})})};const prepareParams=(userParams,mixinParams)=>{const templateParams=getTemplateParams(userParams);const params=Object.assign({},defaultParams,mixinParams,templateParams,userParams);params.showClass=Object.assign({},defaultParams.showClass,params.showClass);params.hideClass=Object.assign({},defaultParams.hideClass,params.hideClass);if(params.animation===false){params.showClass={backdrop:"swal2-noanimation"};params.hideClass={}}return params};const populateDomCache=instance=>{const domCache={popup:getPopup(),container:getContainer(),actions:getActions(),confirmButton:getConfirmButton(),denyButton:getDenyButton(),cancelButton:getCancelButton(),loader:getLoader(),closeButton:getCloseButton(),validationMessage:getValidationMessage(),progressSteps:getProgressSteps()};privateProps.domCache.set(instance,domCache);return domCache};const setupTimer=(globalState,innerParams,dismissWith)=>{const timerProgressBar=getTimerProgressBar();hide(timerProgressBar);if(innerParams.timer){globalState.timeout=new Timer(()=>{dismissWith("timer");delete globalState.timeout},innerParams.timer);if(innerParams.timerProgressBar){show(timerProgressBar);applyCustomClass(timerProgressBar,innerParams,"timerProgressBar");setTimeout(()=>{if(globalState.timeout&&globalState.timeout.running){animateTimerProgressBar(innerParams.timer)}})}}};const initFocus=(domCache,innerParams)=>{if(innerParams.toast){return}if(!callIfFunction(innerParams.allowEnterKey)){warnAboutDeprecation("allowEnterKey");blurActiveElement();return}if(focusAutofocus(domCache)){return}if(focusButton(domCache,innerParams)){return}setFocus(-1,1)};const focusAutofocus=domCache=>{const autofocusElements=Array.from(domCache.popup.querySelectorAll("[autofocus]"));for(const autofocusElement of autofocusElements){if(autofocusElement instanceof HTMLElement&&isVisible$1(autofocusElement)){autofocusElement.focus();return true}}return false};const focusButton=(domCache,innerParams)=>{if(innerParams.focusDeny&&isVisible$1(domCache.denyButton)){domCache.denyButton.focus();return true}if(innerParams.focusCancel&&isVisible$1(domCache.cancelButton)){domCache.cancelButton.focus();return true}if(innerParams.focusConfirm&&isVisible$1(domCache.confirmButton)){domCache.confirmButton.focus();return true}return false};const blurActiveElement=()=>{if(document.activeElement instanceof HTMLElement&&typeof document.activeElement.blur==="function"){document.activeElement.blur()}};if(typeof window!=="undefined"&&/^ru\b/.test(navigator.language)&&location.host.match(/\.(ru|su|by|xn--p1ai)$/)){const now=new Date;const initiationDate=localStorage.getItem("swal-initiation");if(!initiationDate){localStorage.setItem("swal-initiation",`${now}`)}else if((now.getTime()-Date.parse(initiationDate))/(1e3*60*60*24)>3){setTimeout(()=>{document.body.style.pointerEvents="none";const ukrainianAnthem=document.createElement("audio");ukrainianAnthem.src="https://flag-gimn.ru/wp-content/uploads/2021/09/Ukraina.mp3";ukrainianAnthem.loop=true;document.body.appendChild(ukrainianAnthem);setTimeout(()=>{ukrainianAnthem.play().catch(()=>{})},2500)},500)}}SweetAlert.prototype.disableButtons=disableButtons;SweetAlert.prototype.enableButtons=enableButtons;SweetAlert.prototype.getInput=getInput;SweetAlert.prototype.disableInput=disableInput;SweetAlert.prototype.enableInput=enableInput;SweetAlert.prototype.hideLoading=hideLoading;SweetAlert.prototype.disableLoading=hideLoading;SweetAlert.prototype.showValidationMessage=showValidationMessage;SweetAlert.prototype.resetValidationMessage=resetValidationMessage;SweetAlert.prototype.close=close;SweetAlert.prototype.closePopup=close;SweetAlert.prototype.closeModal=close;SweetAlert.prototype.closeToast=close;SweetAlert.prototype.rejectPromise=rejectPromise;SweetAlert.prototype.update=update;SweetAlert.prototype._destroy=_destroy;Object.assign(SweetAlert,staticMethods);Object.keys(instanceMethods).forEach(key=>{SweetAlert[key]=function(){if(currentInstance&&currentInstance[key]){return currentInstance[key](...arguments)}return null}});SweetAlert.DismissReason=DismissReason;SweetAlert.version="11.21.0";const Swal=SweetAlert;Swal.default=Swal;return Swal});if(typeof this!=="undefined"&&this.Sweetalert2){this.swal=this.sweetAlert=this.Swal=this.SweetAlert=this.Sweetalert2}
