/*!
 * jodit - Jodit is an awesome and useful wysiwyg editor with filebrowser
 * Author: Chupurnov <chupurnov@gmail.com> (https://xdsoft.net/jodit/)
 * Version: v4.6.2
 * Url: https://xdsoft.net/jodit/
 * License(s): MIT
 */
	
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("{}"));
	else if(typeof define === 'function' && define.amd)
		define(["{}"], factory);
	else {
		var a = typeof exports === 'object' ? factory(require("{}")) : factory(root["{}"]);
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(self, function(__WEBPACK_EXTERNAL_MODULE__41324__) {
return /******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 140:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* binding */ FileBrowser; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(50025);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_storage__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63915);
/* harmony import */ var jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(58597);
/* harmony import */ var jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(14961);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(36115);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(70265);
/* harmony import */ var _fetch_load_items__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(9979);
/* harmony import */ var _fetch_load_tree__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(31859);
/* harmony import */ var _listeners_native_listeners__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(62994);
/* harmony import */ var _listeners_self_listeners__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(18043);
/* harmony import */ var _listeners_state_listeners__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(80004);
/* harmony import */ var _data_provider__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(75889);
/* harmony import */ var _factories__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(83797);
/* harmony import */ var _ui__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(10274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






















let FileBrowser = class FileBrowser extends jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_8__/* .ViewWithToolbar */ .T {
    /** @override */
    className() {
        return 'FileBrowser';
    }
    get dataProvider() {
        return (0,_factories__WEBPACK_IMPORTED_MODULE_16__/* .makeDataProvider */ .S)(this, this.options);
    }
    onSelect(callback) {
        return () => {
            if (this.state.activeElements.length) {
                const files = [];
                const isImages = [];
                this.state.activeElements.forEach(elm => {
                    const url = elm.fileURL;
                    if (url) {
                        files.push(url);
                        isImages.push(elm.isImage || false);
                    }
                });
                this.close();
                const data = {
                    baseurl: '',
                    files,
                    isImages
                };
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isFunction)(callback)) {
                    callback(data);
                }
                this.close();
            }
            return false;
        };
    }
    get _dialog() {
        var _a;
        const dialog = this.dlg({
            minWidth: Math.min(700, screen.width),
            minHeight: 300,
            buttons: (_a = this.o.headerButtons) !== null && _a !== void 0 ? _a : ['fullsize', 'dialog.close']
        });
        ['beforeClose', 'afterClose', 'beforeOpen'].forEach(proxyEvent => dialog.events.on(dialog, proxyEvent, () => this.e.fire(proxyEvent)));
        dialog.setSize(this.o.width, this.o.height);
        return dialog;
    }
    /**
     * Container for set/get value
     */
    get storage() {
        return jodit_core_storage__WEBPACK_IMPORTED_MODULE_6__/* .Storage */ .wc.makeStorage(Boolean(this.o.saveStateInStorage), this.componentName);
    }
    get isOpened() {
        return this._dialog.isOpened && this.browser.style.display !== 'none';
    }
    /**
     * It displays a message in the status bar of filebrowser
     *
     * @param message - The message that will be displayed
     * @param success - true It will be shown a message light . If no option is specified ,
     * ßan error will be shown the red
     * @example
     * ```javascript
     * parent.filebrowser.status('There was an error uploading file', false);
     * ```
     */
    status(message, success) {
        if (!message || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isAbortError)(message)) {
            return;
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isString)(message)) {
            message = message.message;
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isString)(message) || !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.trim)(message).length) {
            return;
        }
        this.message.message(message, success ? 'success' : 'error', this.o.howLongShowMsg);
    }
    /**
     * It opens a web browser window
     *
     * @param callback - The function that will be called after the file selection in the browser
     * @param onlyImages - Show only images
     * @example
     * ```javascript
     * var fb = new Jodit.modules.FileBrowser(parent);
     * fb.open(function (data) {
     *     var i;
     *     for (i = 0;i < data.files.length; i += 1) {
     *         parent.s.insertImage(data.baseurl + data.files[i]);
     *     }
     * });
     * ```
     */
    open(callback = this.o
        .defaultCallback, onlyImages = false) {
        this.state.onlyImages = onlyImages;
        return this.async
            .promise((resolve, reject) => {
            var _a;
            if (!this.o.items || !this.o.items.url) {
                throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.error)('Need set options.filebrowser.ajax.url');
            }
            let localTimeout = 0;
            this.e
                .off(this.files.container, 'dblclick')
                .on(this.files.container, 'dblclick', this.onSelect(callback))
                .on(this.files.container, 'touchstart', () => {
                const now = new Date().getTime();
                if (now - localTimeout <
                    jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.EMULATE_DBLCLICK_TIMEOUT) {
                    this.onSelect(callback)();
                }
                localTimeout = now;
            })
                .off('select.filebrowser')
                .on('select.filebrowser', this.onSelect(callback));
            const header = this.c.div();
            (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.appendTo(header);
            this.__updateToolbarButtons();
            this._dialog.open(this.browser, header);
            this.e.fire('sort.filebrowser', this.state.sortBy);
            (0,_fetch_load_tree__WEBPACK_IMPORTED_MODULE_11__/* .loadTree */ .r)(this)
                .then(resolve, reject)
                .finally(() => {
                var _a;
                if (this.isInDestruct) {
                    return;
                }
                (_a = this === null || this === void 0 ? void 0 : this.e) === null || _a === void 0 ? void 0 : _a.fire('fileBrowserReady.filebrowser');
            });
        })
            .catch((e) => {
            if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isAbortError)(e) && !jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD) {
                throw e;
            }
        });
    }
    __getButtons() {
        var _a;
        const options = ((_a = this.o.buttons) !== null && _a !== void 0 ? _a : []);
        return options.filter((btn) => {
            if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isString)(btn)) {
                return true;
            }
            switch (btn) {
                case 'filebrowser.upload':
                    return this.dataProvider.canI('FileUpload');
                case 'filebrowser.edit':
                    return (this.dataProvider.canI('ImageResize') ||
                        this.dataProvider.canI('ImageCrop'));
                case 'filebrowser.remove':
                    return this.dataProvider.canI('FileRemove');
            }
            return true;
        });
    }
    initUploader(editor) {
        var _a;
        const self = this, options = (_a = editor === null || editor === void 0 ? void 0 : editor.options) === null || _a === void 0 ? void 0 : _a.uploader, uploaderOptions = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_9__/* .Config */ .T.defaultOptions.uploader);
        const uploadHandler = () => (0,_fetch_load_items__WEBPACK_IMPORTED_MODULE_18__/* .loadItems */ .f)(this);
        self.uploader = self.getInstance('Uploader', uploaderOptions);
        self.uploader
            .setPath(self.state.currentPath)
            .setSource(self.state.currentSource)
            .bind(self.browser, uploadHandler, self.errorHandler);
        this.state.on(['change.currentPath', 'change.currentSource'], () => {
            this.uploader
                .setPath(this.state.currentPath)
                .setSource(this.state.currentSource);
        });
        self.e.on('bindUploader.filebrowser', (button) => {
            self.uploader.bind(button, uploadHandler, self.errorHandler);
        });
    }
    constructor(options) {
        super(options);
        this.browser = this.c.div(this.componentName);
        this.status_line = this.c.div(this.getFullElName('status'));
        this.tree = new _ui__WEBPACK_IMPORTED_MODULE_17__/* .FileBrowserTree */ .V(this);
        this.files = new _ui__WEBPACK_IMPORTED_MODULE_17__/* .FileBrowserFiles */ .Q(this);
        this.state = (0,jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_4__/* .observable */ .sH)({
            currentPath: '',
            currentSource: _data_provider__WEBPACK_IMPORTED_MODULE_15__/* .DEFAULT_SOURCE_NAME */ .o,
            currentBaseUrl: '',
            activeElements: [],
            elements: [],
            sources: [],
            view: 'tiles',
            sortBy: 'changed-desc',
            filterWord: '',
            onlyImages: false
        });
        this.errorHandler = (resp) => {
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.isAbortError)(resp)) {
                return;
            }
            if (resp instanceof Error) {
                this.status(this.i18n(resp.message));
            }
            else {
                this.status(this.dataProvider.getMessage(resp));
            }
        };
        /**
         * Close dialog
         */
        this.close = () => {
            this._dialog.close();
        };
        this.__prevButtons = [];
        this.attachEvents(options);
        const self = this;
        self.options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_9__/* .Config */ .T.defaultOptions.filebrowser);
        self.browser.component = this;
        self.container = self.browser;
        if (self.o.showFoldersPanel) {
            self.browser.appendChild(self.tree.container);
        }
        self.browser.appendChild(self.files.container);
        self.browser.appendChild(self.status_line);
        _listeners_self_listeners__WEBPACK_IMPORTED_MODULE_13__/* .selfListeners */ .c.call(self);
        _listeners_native_listeners__WEBPACK_IMPORTED_MODULE_12__/* .nativeListeners */ .nW.call(self);
        _listeners_state_listeners__WEBPACK_IMPORTED_MODULE_14__/* .stateListeners */ .r.call(self);
        const keys = [
            'getLocalFileByUrl',
            'crop',
            'resize',
            'create',
            'fileMove',
            'folderMove',
            'fileRename',
            'folderRename',
            'fileRemove',
            'folderRemove',
            'folder',
            'items',
            'permissions'
        ];
        keys.forEach(key => {
            if (this.options[key] != null) {
                this.options[key] = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_5__.ConfigProto)(this.options[key], this.o.ajax);
            }
        });
        const { storeView, storeSortBy, storeLastOpenedFolder } = this.o
            .saveStateInStorage || {
            storeLastOpenedFolder: false,
            storeView: false,
            storeSortBy: false
        };
        const view = storeView && this.storage.get('view');
        if (view && this.o.view == null) {
            self.state.view = view === 'list' ? 'list' : 'tiles';
        }
        else {
            self.state.view = self.o.view === 'list' ? 'list' : 'tiles';
        }
        self.files.setMod('view', self.state.view);
        const sortBy = storeSortBy && self.storage.get('sortBy');
        if (sortBy) {
            const parts = sortBy.split('-');
            self.state.sortBy = ['changed', 'name', 'size'].includes(parts[0])
                ? sortBy
                : 'changed-desc';
        }
        else {
            self.state.sortBy = self.o.sortBy || 'changed-desc';
        }
        if (storeLastOpenedFolder) {
            const currentPath = self.storage.get('currentPath'), currentSource = self.storage.get('currentSource');
            self.state.currentPath = currentPath !== null && currentPath !== void 0 ? currentPath : '';
            self.state.currentSource = currentSource !== null && currentSource !== void 0 ? currentSource : '';
        }
        self.initUploader(self);
        self.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready);
    }
    destruct() {
        var _a;
        if (this.isInDestruct) {
            return;
        }
        (_a = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.cached)(this, '_dialog')) === null || _a === void 0 ? void 0 : _a.destruct();
        super.destruct();
        this.events && this.e.off('.filebrowser');
        this.uploader && this.uploader.destruct();
    }
    __updateToolbarButtons() {
        var _a;
        const buttons = this.__getButtons();
        if (isEqualButtonList(this.__prevButtons, buttons)) {
            return;
        }
        this.__prevButtons = buttons;
        (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.build(buttons);
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.cache
], FileBrowser.prototype, "dataProvider", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.cache
], FileBrowser.prototype, "_dialog", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.cache
], FileBrowser.prototype, "storage", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], FileBrowser.prototype, "status", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], FileBrowser.prototype, "open", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_3__/* .watch */ .w)('dataProvider:changePermissions')
], FileBrowser.prototype, "__updateToolbarButtons", null);
FileBrowser = (0,tslib__WEBPACK_IMPORTED_MODULE_19__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.derive)(jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_7__/* .Dlgs */ .z)
], FileBrowser);

function isEqualButtonList(prevButtons, buttons) {
    if (prevButtons.length !== buttons.length) {
        return false;
    }
    for (let i = 0; i < prevButtons.length; i++) {
        if (prevButtons[i] !== buttons[i]) {
            return false;
        }
    }
    return true;
}


/***/ }),

/***/ 449:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   N: function() { return /* binding */ CamelCaseToKebabCase; },
/* harmony export */   k: function() { return /* binding */ kebabCase; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/string
 */
const kebabCase = (key) => {
    return key
        .replace(/([A-Z])([A-Z])([a-z])/g, '$1-$2$3')
        .replace(/([a-z])([A-Z])/g, '$1-$2')
        .replace(/[\s_]+/g, '-')
        .toLowerCase();
};
const CamelCaseToKebabCase = (key) => {
    return key
        .replace(/([A-Z])([A-Z])([a-z])/g, '$1-$2$3')
        .replace(/([a-z])([A-Z])/g, '$1-$2')
        .toLowerCase();
};


/***/ }),

/***/ 641:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ scrollIntoViewIfNeeded; },
/* harmony export */   l: function() { return /* binding */ inView; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @module helpers/utils
 */
/**
 * Check if element is in view
 */
function inView(elm, root, doc) {
    let rect = elm.getBoundingClientRect(), el = elm;
    const top = rect.top, height = rect.height;
    while (el && el !== root && el.parentNode) {
        el = el.parentNode;
        rect = el.getBoundingClientRect();
        if (!(top <= rect.bottom)) {
            return false;
        }
        // Check if the element is out of view due to a container scrolling
        if (top + height <= rect.top) {
            return false;
        }
    }
    // Check it's within the document viewport
    return (top <= ((doc.documentElement && doc.documentElement.clientHeight) || 0));
}
/**
 * Scroll element into view if it is not in view
 */
function scrollIntoViewIfNeeded(elm, root, doc) {
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(elm) && !inView(elm, root, doc)) {
        if (root.clientHeight !== root.scrollHeight) {
            root.scrollTop = elm.offsetTop;
        }
        if (!inView(elm, root, doc)) {
            elm.scrollIntoView();
        }
    }
}


/***/ }),

/***/ 926:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   r: function() { return /* binding */ removeEmptyTextNode; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @private
 */
function removeEmptyTextNode(jodit, node, hadEffect, arg, argi, currentNode) {
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isText(node) && !node.nodeValue) {
        if (node === currentNode && jodit.s.isCollapsed()) {
            jodit.s.setCursorAfter(node);
        }
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(node);
        return true;
    }
    return hadEffect;
}


/***/ }),

/***/ 928:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M621 1280h595v-595zm-45-45l595-595h-595v595zm1152 77v192q0 14-9 23t-23 9h-224v224q0 14-9 23t-23 9h-192q-14 0-23-9t-9-23v-224h-864q-14 0-23-9t-9-23v-864h-224q-14 0-23-9t-9-23v-192q0-14 9-23t23-9h224v-224q0-14 9-23t23-9h192q14 0 23 9t9 23v224h851l246-247q10-9 23-9t23 9q9 10 9 23t-9 23l-247 246v851h224q14 0 23 9t9 23z\"/> </svg>"

/***/ }),

/***/ 931:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I: function() { return /* binding */ Icon; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38322);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



class Icon {
    static getIcon(name) {
        if (/<svg/i.test(name)) {
            return name;
        }
        const icon = Icon.icons[name] ||
            Icon.icons[name.replace(/-/g, '_')] ||
            Icon.icons[name.replace(/_/g, '-')] ||
            Icon.icons[(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.camelCase)(name)] ||
            Icon.icons[(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.kebabCase)(name)] ||
            Icon.icons[name.toLowerCase()];
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && !icon) {
            console.warn(`Icon "${name}" not found`);
        }
        return icon;
    }
    /**
     * Check if icon exist in store
     */
    static exists(name) {
        return this.getIcon(name) !== undefined;
    }
    /**
     * Return SVG icon
     */
    static get(name, defaultValue = '<span></span>') {
        return this.getIcon(name) || defaultValue;
    }
    /**
     * Set SVG in store
     */
    static set(name, value) {
        this.icons[name.replace('_', '-')] = value;
        return this;
    }
    /**
     * Make icon html element
     */
    static makeIcon(jodit, icon) {
        var _a, _b, _c, _d;
        if (!icon) {
            return;
        }
        let iconElement;
        const { name, iconURL, fill } = icon;
        const clearName = name.replace(/[^a-zA-Z0-9]/g, '_');
        let iconFromEvent;
        if (!/<svg/.test(name)) {
            iconFromEvent = (_b = (_a = jodit.o).getIcon) === null || _b === void 0 ? void 0 : _b.call(_a, name, clearName);
        }
        const cacheKey = `${name}${iconURL}${fill}${iconFromEvent !== null && iconFromEvent !== void 0 ? iconFromEvent : ''}`;
        if (jodit.o.cache && this.__cache.has(cacheKey)) {
            return (_c = this.__cache.get(cacheKey)) === null || _c === void 0 ? void 0 : _c.cloneNode(true);
        }
        if (iconURL) {
            iconElement = jodit.c.span();
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(iconElement, 'backgroundImage', 'url(' +
                iconURL.replace('{basePath}', (jodit === null || jodit === void 0 ? void 0 : jodit.basePath) || '') +
                ')');
        }
        else {
            const svg = iconFromEvent ||
                Icon.get(name, '') ||
                ((_d = jodit.o.extraIcons) === null || _d === void 0 ? void 0 : _d[name]);
            if (svg) {
                iconElement = jodit.c.fromHTML(svg.trim());
                if (!/^<svg/i.test(name)) {
                    iconElement.classList.add('jodit-icon_' + clearName);
                }
            }
        }
        if (iconElement) {
            iconElement.classList.add('jodit-icon');
            iconElement.style.fill = fill;
            jodit.o.cache &&
                this.__cache.set(cacheKey, iconElement.cloneNode(true));
        }
        return iconElement;
    }
}
Icon.icons = {};
Icon.__cache = new Map();


/***/ }),

/***/ 1239:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export orderedList */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71005);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20797);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Process commands insertOrderedList and insertUnOrderedList
 */
class orderedList extends jodit_core_plugin__WEBPACK_IMPORTED_MODULE_2__/* .Plugin */ .k {
    constructor() {
        super(...arguments);
        this.buttons = [
            {
                name: 'ul',
                group: 'list'
            },
            {
                name: 'ol',
                group: 'list'
            }
        ];
    }
    afterInit(jodit) {
        jodit
            .registerCommand('insertUnorderedList', this.onCommand)
            .registerCommand('insertOrderedList', this.onCommand);
    }
    onCommand(command, _, type) {
        this.jodit.s.commitStyle({
            element: command === 'insertunorderedlist' ? 'ul' : 'ol',
            attributes: {
                style: {
                    listStyleType: type !== null && type !== void 0 ? type : null
                }
            }
        });
        this.jodit.synchronizeValues();
        return false;
    }
    beforeDestruct(jodit) { }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], orderedList.prototype, "onCommand", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('orderedList', orderedList);


/***/ }),

/***/ 1540:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ UISelect; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69198);
/* harmony import */ var jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(84103);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var UISelect_1;






let UISelect = UISelect_1 = class UISelect extends jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t {
    /** @override */
    className() {
        return 'UISelect';
    }
    /** @override **/
    createContainer(state) {
        var _a;
        const container = super.createContainer(state);
        const { j } = this, { nativeInput } = this;
        const opt = () => j.create.element('option');
        if (state.placeholder !== undefined) {
            const option = opt();
            option.value = '';
            option.text = j.i18n(state.placeholder);
            nativeInput.add(option);
        }
        (_a = state.options) === null || _a === void 0 ? void 0 : _a.forEach(element => {
            const option = opt();
            option.value = element.value.toString();
            option.text = j.i18n(element.text);
            nativeInput.add(option);
        });
        if (state.size && state.size > 0) {
            (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(nativeInput, 'size', state.size);
        }
        if (state.multiple) {
            (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(nativeInput, 'multiple', '');
        }
        return container;
    }
    /** @override **/
    createNativeInput() {
        return this.j.create.element('select');
    }
    /** @override **/
    updateValidators() {
        super.updateValidators();
        if (this.state.required) {
            this.validators.delete(jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_2__/* .inputValidators.required */ .O.required);
            this.validators.add(jodit_core_ui_form_validators__WEBPACK_IMPORTED_MODULE_2__/* .selectValidators.required */ .U.m);
        }
    }
    constructor(jodit, state) {
        super(jodit, state);
        /** @override */
        this.state = Object.assign({}, UISelect_1.defaultState);
        Object.assign(this.state, state);
    }
};
/** @override */
UISelect.defaultState = Object.assign(Object.assign({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t.defaultState), { options: [], size: 1, multiple: false });
UISelect = UISelect_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__/* .component */ .s
], UISelect);



/***/ }),

/***/ 1663:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'Simbolo'
};


/***/ }),

/***/ 1963:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: function() { return /* binding */ derive; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(69052);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/decorators/derive/README.md]]
 * @packageDocumentation
 * @module decorators/derive
 */

function derive(...traits) {
    return (target) => {
        const origin = target.prototype;
        for (let i = 0; i < traits.length; i++) {
            const trait = traits[i];
            const keys = Object.getOwnPropertyNames(trait.prototype);
            for (let j = 0; j < keys.length; j++) {
                const key = keys[j], method = Object.getOwnPropertyDescriptor(trait.prototype, key);
                const canDerive = method != null &&
                    (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(method.value) &&
                    !(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(origin[key]);
                if (canDerive) {
                    Object.defineProperty(origin, key, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: function (...args) {
                            return method.value.call(this, ...args);
                        }
                    });
                }
            }
        }
    };
}


/***/ }),

/***/ 1992:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   b: function() { return /* binding */ createSourceEditor; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var _engines__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(76134);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


function createSourceEditor(type, editor, container, toWYSIWYG, fromWYSIWYG) {
    let sourceEditor;
    if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(type)) {
        sourceEditor = type(editor);
    }
    else {
        switch (type) {
            case 'ace':
                if (!editor.o.shadowRoot) {
                    sourceEditor = new _engines__WEBPACK_IMPORTED_MODULE_1__/* .AceEditor */ .p(editor, container, toWYSIWYG, fromWYSIWYG);
                    break;
                }
            default:
                sourceEditor = new _engines__WEBPACK_IMPORTED_MODULE_1__/* .TextAreaEditor */ .S(editor, container, toWYSIWYG, fromWYSIWYG);
        }
    }
    sourceEditor.init(editor);
    sourceEditor.onReadyAlways(() => {
        sourceEditor.setReadOnly(editor.o.readonly);
    });
    return sourceEditor;
}


/***/ }),

/***/ 2461:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: function() { return /* binding */ isNumber; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check value is a number
 */
function isNumber(value) {
    return typeof value === 'number' && !isNaN(value) && isFinite(value);
}


/***/ }),

/***/ 2533:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export tableKeyboardNavigation */
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_modules_table_table__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11648);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





const WORK_KEYS = new Set([
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB,
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT,
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_RIGHT,
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP,
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN
]);
/**
 * Process navigates key pressing in table cell
 */
function tableKeyboardNavigation(editor) {
    editor.e
        .off('.tableKeyboardNavigation')
        .on('keydown.tableKeyboardNavigation', (event) => {
        const { key } = event;
        const cell = findCell(editor, key);
        if (!cell) {
            return;
        }
        const tableModule = editor.getInstance(jodit_modules_table_table__WEBPACK_IMPORTED_MODULE_4__/* .Table */ .X, editor.o);
        const table = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(cell, 'table', editor.editor);
        let next = null;
        const isPrev = key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT || event.shiftKey;
        const getNextCell = () => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)(isPrev ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.prev : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.next, cell, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isCell, table);
        switch (key) {
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB:
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT: {
                next = getNextCell();
                if (!next) {
                    tableModule.appendRow(table, !isPrev
                        ? false
                        : table.querySelector('tr'), !isPrev);
                    next = getNextCell();
                }
                break;
            }
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP:
            case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN:
                {
                    const matrix = tableModule.formalMatrix(table);
                    const [row, column] = tableModule.formalCoordinate(table, cell);
                    if (key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP) {
                        if (matrix[row - 1] !== undefined) {
                            next = matrix[row - 1][column];
                        }
                    }
                    else {
                        if (matrix[row + 1] !== undefined) {
                            next = matrix[row + 1][column];
                        }
                    }
                }
                break;
        }
        if (!next) {
            return;
        }
        editor.e.fire('hidePopup hideResizer');
        if (!next.firstChild) {
            const first = editor.createInside.element('br');
            next.appendChild(first);
            editor.s.setCursorBefore(first);
        }
        else {
            if (key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB) {
                editor.s.select(next, true);
            }
            else {
                editor.s.setCursorIn(next, key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_RIGHT || key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN);
            }
        }
        editor.synchronizeValues();
        return false;
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('tableKeyboardNavigation', tableKeyboardNavigation);
function findCell(editor, key) {
    if (!WORK_KEYS.has(key)) {
        return;
    }
    const current = editor.s.current();
    if (!current) {
        return;
    }
    const cell = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.up(current, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isCell, editor.editor);
    if (!cell) {
        return;
    }
    const { range } = editor.s;
    if (key !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB && current !== cell) {
        const isNextDirection = key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_RIGHT || key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN;
        const hasNext = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)(!isNextDirection ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.prev : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.next, current, elm => key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP || key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN
            ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(elm, 'br')
            : Boolean(elm), cell);
        if ((!isNextDirection &&
            (hasNext ||
                (key !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP &&
                    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(current) &&
                    range.startOffset !== 0))) ||
            (isNextDirection &&
                (hasNext ||
                    (key !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN &&
                        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(current) &&
                        current.nodeValue &&
                        range.startOffset !== current.nodeValue.length)))) {
            return;
        }
    }
    return cell;
}


/***/ }),

/***/ 2788:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   M: function() { return /* binding */ MemoryStorageProvider; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
class MemoryStorageProvider {
    constructor() {
        this.data = new Map();
    }
    set(key, value) {
        this.data.set(key, value);
        return this;
    }
    delete(key) {
        this.data.delete(key);
        return this;
    }
    get(key) {
        return this.data.get(key);
    }
    exists(key) {
        return this.data.has(key);
    }
    clear() {
        this.data.clear();
        return this;
    }
}


/***/ }),

/***/ 3006:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ UICheckbox; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69198);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var UICheckbox_1;





let UICheckbox = UICheckbox_1 = class UICheckbox extends jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .t {
    /** @override */
    className() {
        return 'UICheckbox';
    }
    /** @override */
    render() {
        return this.j.c.element('label', {
            className: this.componentName
        });
    }
    /** @override **/
    constructor(jodit, options) {
        super(jodit, Object.assign(Object.assign({}, options), { type: 'checkbox' }));
        /** @override */
        this.state = Object.assign({}, UICheckbox_1.defaultState);
        Object.assign(this.state, options);
    }
    onChangeChecked() {
        this.value = this.state.checked.toString();
        this.nativeInput.checked = this.state.checked;
        this.setMod('checked', this.state.checked);
    }
    onChangeNativeCheckBox() {
        this.state.checked = this.nativeInput.checked;
    }
    onChangeSwitch() {
        this.setMod('switch', this.state.switch);
        let slider = this.getElm('switch-slider');
        if (this.state.switch) {
            if (!slider) {
                slider = this.j.c.div(this.getFullElName('switch-slider'));
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.after(this.nativeInput, slider);
        }
        else {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(slider);
        }
    }
};
/** @override */
UICheckbox.defaultState = Object.assign(Object.assign({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .t.defaultState), { checked: false, switch: false });
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.checked'),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready')
], UICheckbox.prototype, "onChangeChecked", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('nativeInput:change')
], UICheckbox.prototype, "onChangeNativeCheckBox", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.switch'),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready')
], UICheckbox.prototype, "onChangeSwitch", null);
UICheckbox = UICheckbox_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.component
], UICheckbox);



/***/ }),

/***/ 3101:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: function() { return /* binding */ wrap; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26150);
/* harmony import */ var _list_wrap_list__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61001);
/* harmony import */ var _wrap_unwrapped_text__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(80394);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Replaces the parent tag with the applicable one, or wraps the text and also replaces the tag
 * @private
 */
function wrap(commitStyle, font, jodit) {
    const wrapper = findOrCreateWrapper(commitStyle, font, jodit);
    return commitStyle.elementIsList
        ? (0,_list_wrap_list__WEBPACK_IMPORTED_MODULE_2__/* .wrapList */ .z)(commitStyle, wrapper, jodit)
        : jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.replace(wrapper, commitStyle.element, jodit.createInside, true);
}
const WRAP_NODES = new Set([
    'td',
    'th',
    'tr',
    'tbody',
    'table',
    'li',
    'ul',
    'ol'
]);
/**
 * If we apply a block element, then it finds the closest block parent (exclude table cell etc.),
 * otherwise it wraps free text in an element.
 */
function findOrCreateWrapper(commitStyle, font, jodit) {
    if (commitStyle.elementIsBlock) {
        const box = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.up(font, node => jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(node) && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(node, WRAP_NODES), jodit.editor);
        if (box) {
            return box;
        }
        return (0,_wrap_unwrapped_text__WEBPACK_IMPORTED_MODULE_3__/* .wrapUnwrappedText */ .Y)(commitStyle, font, jodit);
    }
    (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .C)(font, 'size', null);
    return font;
}


/***/ }),

/***/ 3258:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I: function() { return /* binding */ ToolbarButton; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(35265);
/* harmony import */ var jodit_core_ui_helpers_get_control_type__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57023);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(931);
/* harmony import */ var jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(80071);
/* harmony import */ var jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(97394);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(8809);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */












let ToolbarButton = class ToolbarButton extends jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .UIButton */ .lD {
    /** @override */
    className() {
        return 'ToolbarButton';
    }
    /**
     * Get parent toolbar
     */
    get toolbar() {
        return this.closest(jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_8__/* .ToolbarCollection */ .Q);
    }
    /** @override **/
    update() {
        var _a, _b;
        const { control, state } = this, tc = this.closest(jodit_modules_toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_8__/* .ToolbarCollection */ .Q);
        if (!tc) {
            return;
        }
        const value = (_a = control.value) === null || _a === void 0 ? void 0 : _a.call(control, tc.jodit, this);
        if (value !== undefined) {
            state.value = value;
        }
        state.disabled = this.__calculateDisabledStatus(tc);
        state.activated = this.__calculateActivatedStatus(tc);
        (_b = control.update) === null || _b === void 0 ? void 0 : _b.call(control, tc.jodit, this);
    }
    /**
     * Calculates whether the button is active
     */
    __calculateActivatedStatus(tc) {
        var _a, _b;
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isJoditObject)(this.j) && !this.j.editorIsActive) {
            return false;
        }
        if ((_b = (_a = this.control).isActive) === null || _b === void 0 ? void 0 : _b.call(_a, this.j, this)) {
            return true;
        }
        return Boolean(tc && tc.shouldBeActive(this));
    }
    /**
     * Calculates whether an element is blocked for the user
     */
    __calculateDisabledStatus(tc) {
        var _a, _b;
        if (this.j.o.disabled) {
            return true;
        }
        if (this.j.o.readonly &&
            (!this.j.o.activeButtonsInReadOnly ||
                !this.j.o.activeButtonsInReadOnly.includes(this.control.name))) {
            return true;
        }
        if ((_b = (_a = this.control).isDisabled) === null || _b === void 0 ? void 0 : _b.call(_a, this.j, this)) {
            return true;
        }
        return Boolean(tc && tc.shouldBeDisabled(this));
    }
    /** @override */
    onChangeActivated() {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.button, 'aria-pressed', this.state.activated);
        super.onChangeActivated();
    }
    /** @override */
    onChangeText() {
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(this.control.template)) {
            this.text.innerHTML = this.control.template(this.j, this.control.name, this.j.i18n(this.state.text));
        }
        else {
            super.onChangeText();
        }
        this.setMod('text-icons', Boolean(this.text.innerText.trim().length));
    }
    /** @override */
    onChangeTabIndex() {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.button, 'tabindex', this.state.tabIndex);
    }
    createContainer() {
        const cn = this.componentName;
        const container = this.j.c.span(cn);
        const button = super.createContainer();
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(container, 'role', 'listitem');
        button.classList.remove(cn);
        button.classList.add(cn + '__button');
        Object.defineProperty(button, 'component', {
            value: this
        });
        container.appendChild(button);
        const trigger = this.j.c.fromHTML(`<span role="trigger" class="${cn}__trigger">${jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__/* .Icon */ .I.get('chevron')}</span>`);
        // For caching
        button.appendChild(trigger);
        return container;
    }
    /** @override */
    focus() {
        var _a;
        (_a = this.container.querySelector('button')) === null || _a === void 0 ? void 0 : _a.focus();
    }
    onChangeHasTrigger() {
        if (this.state.hasTrigger) {
            this.container.appendChild(this.trigger);
        }
        else {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.trigger);
        }
        this.setMod('with-trigger', this.state.hasTrigger || null);
    }
    /** @override */
    onChangeDisabled() {
        const disabled = this.state.disabled ? 'disabled' : null;
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.trigger, 'disabled', disabled);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.button, 'disabled', disabled);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.container, 'disabled', disabled);
    }
    constructor(jodit, control, target = null) {
        super(jodit);
        this.control = control;
        this.target = target;
        this.state = Object.assign(Object.assign({}, (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .UIButtonState */ .ue)()), { theme: 'toolbar', currentValue: '', hasTrigger: false });
        this.openedPopup = null;
        const button = this.getElm('button');
        void 0;
        this.button = button;
        Object.defineProperty(button, 'component', {
            value: this,
            configurable: true
        });
        const trigger = this.getElm('trigger');
        void 0;
        this.trigger = trigger;
        trigger.remove();
        // Prevent lost focus
        jodit.e.on([this.button, this.trigger], 'mousedown', (e) => e.preventDefault());
        this.onAction(this.onClick);
        this.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, () => {
            this.__initFromControl();
            this.update();
        });
        if (control.mods) {
            Object.keys(control.mods).forEach(mod => {
                control.mods && this.setMod(mod, control.mods[mod]);
            });
        }
    }
    /**
     * Init constant data from control
     */
    __initFromControl() {
        var _a;
        const { control: ctr, state } = this;
        this.updateSize();
        state.name = ctr.name;
        const { textIcons } = this.j.o;
        if (textIcons === true ||
            ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(textIcons) && textIcons(ctr.name)) ||
            ctr.template) {
            state.icon = (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .UIButtonState */ .ue)().icon;
            state.text = ctr.text || ctr.name;
        }
        else {
            if (ctr.iconURL) {
                state.icon.iconURL = ctr.iconURL;
            }
            else {
                const name = ctr.icon || ctr.name;
                state.icon.name =
                    jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_6__/* .Icon */ .I.exists(name) || ((_a = this.j.o.extraIcons) === null || _a === void 0 ? void 0 : _a[name])
                        ? name
                        : '';
            }
            if (!ctr.iconURL && !state.icon.name) {
                state.text = ctr.text || ctr.name;
            }
        }
        if (ctr.tooltip) {
            state.tooltip = this.j.i18n((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(ctr.tooltip)
                ? ctr.tooltip(this.j, ctr, this)
                : ctr.tooltip);
        }
        state.hasTrigger = Boolean(ctr.list || (ctr.popup && ctr.exec));
    }
    /**
     * Click on trigger button
     */
    onTriggerClick(e) {
        var _a, _b, _c;
        if (this.openedPopup) {
            this.__closePopup();
            return;
        }
        const { control: ctr } = this;
        e.buffer = {
            actionTrigger: this
        };
        if (ctr.list) {
            return this.__openControlList(ctr);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(ctr.popup)) {
            const popup = this.openPopup();
            popup.parentElement = this;
            try {
                if (this.j.e.fire((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.camelCase)(`before-${ctr.name}-open-popup`), this.target, ctr, popup) !== false) {
                    const target = (_c = (_b = (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.getTarget(this)) !== null && _b !== void 0 ? _b : this.target) !== null && _c !== void 0 ? _c : null;
                    const elm = ctr.popup(this.j, target, this.__closePopup, this);
                    if (elm) {
                        popup
                            .setContent((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(elm) ? this.j.c.fromHTML(elm) : elm)
                            .open(() => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.position)(this.container), false, this.j.o.allowTabNavigation
                            ? this.container
                            : undefined);
                    }
                    else {
                        this.__closePopup();
                    }
                }
            }
            catch (e) {
                this.__closePopup();
                throw e;
            }
            /**
             * Fired after the popup was opened for some control button
             */
            /**
             * Close all opened popups
             */
            this.j.e.fire((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.camelCase)(`after-${ctr.name}-open-popup`), popup.container);
        }
    }
    /**
     * Create an open popup list
     */
    __openControlList(control) {
        var _a;
        const controls = (_a = this.jodit.options.controls) !== null && _a !== void 0 ? _a : {}, getControl = (key) => (0,jodit_core_ui_helpers_get_control_type__WEBPACK_IMPORTED_MODULE_5__/* .findControlType */ .x)(key, controls);
        const list = control.list, menu = this.openPopup(), toolbar = (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_9__/* .makeCollection */ .$K)(this.j);
        menu.parentElement = this;
        toolbar.parentElement = menu;
        toolbar.mode = 'vertical';
        const isListItem = (key) => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isPlainObject)(key) && 'title' in key && 'value' in key;
        const getButton = (key, value) => {
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value) && getControl(value)) {
                return Object.assign({ name: value.toString() }, getControl(value));
            }
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(key) && getControl(key)) {
                return Object.assign(Object.assign({ name: key.toString() }, getControl(key)), (typeof value === 'object' ? value : {}));
            }
            if (isListItem(key)) {
                value = key.value;
                key = key.title;
            }
            const { childTemplate } = control;
            const childControl = {
                name: key.toString(),
                template: childTemplate &&
                    ((j, k, v) => childTemplate(j, k, v, this)),
                exec: control.childExec
                    ? (view, current, options) => {
                        var _a;
                        return (_a = control.childExec) === null || _a === void 0 ? void 0 : _a.call(control, view, current, Object.assign(Object.assign({}, options), { parentControl: control }));
                    }
                    : control.exec,
                data: control.data,
                command: control.command,
                isActive: control.isChildActive,
                value: control.value,
                isDisabled: control.isChildDisabled,
                mode: control.mode,
                args: [...(control.args ? control.args : []), key, value]
            };
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value)) {
                childControl.text = value;
            }
            return childControl;
        };
        toolbar.build((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isArray)(list)
            ? list.map(getButton)
            : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.keys)(list, false).map(key => getButton(key, list[key])), this.target);
        menu.setContent(toolbar).open(() => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.position)(this.container), false, this.j.o.allowTabNavigation ? this.container : undefined);
        this.state.activated = true;
    }
    onOutsideClick(e) {
        if (!this.openedPopup) {
            return;
        }
        if (!e ||
            !jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isNode(e.target) ||
            (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.container, e.target) &&
                !this.openedPopup.isOwnClick(e))) {
            this.__closePopup();
        }
    }
    openPopup() {
        this.__closePopup();
        this.openedPopup = new jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_7__/* .Popup */ .z(this.j, false);
        this.j.e
            .on(this.ow, 'mousedown touchstart', this.onOutsideClick)
            .on('escape closeAllPopups', this.onOutsideClick);
        return this.openedPopup;
    }
    __closePopup() {
        if (this.openedPopup) {
            this.j.e
                .off(this.ow, 'mousedown touchstart', this.onOutsideClick)
                .off('escape closeAllPopups', this.onOutsideClick);
            this.state.activated = false;
            this.openedPopup.close();
            this.openedPopup.destruct();
            this.openedPopup = null;
        }
    }
    /**
     * Click handler
     */
    onClick(originalEvent) {
        var _a, _b, _c, _d, _e, _f, _g;
        const { control: ctr } = this;
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(ctr.exec)) {
            const target = (_c = (_b = (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.getTarget(this)) !== null && _b !== void 0 ? _b : this.target) !== null && _c !== void 0 ? _c : null;
            const result = ctr.exec(this.j, target, {
                control: ctr,
                originalEvent,
                button: this
            });
            // For memorise exec
            if (result !== false && result !== true) {
                (_e = (_d = this.j) === null || _d === void 0 ? void 0 : _d.e) === null || _e === void 0 ? void 0 : _e.fire('synchro');
                if (this.parentElement) {
                    this.parentElement.update();
                }
                /**
                 * Fired after calling `button.exec` function
                 */
                (_g = (_f = this.j) === null || _f === void 0 ? void 0 : _f.e) === null || _g === void 0 ? void 0 : _g.fire('closeAllPopups afterExec');
            }
            if (result !== false) {
                return;
            }
        }
        if (ctr.list) {
            return this.__openControlList(ctr);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(ctr.popup)) {
            return this.onTriggerClick(originalEvent);
        }
        if (ctr.command || ctr.name) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isJoditObject)(this.j)
                ? this.j.execCommand.bind(this.j)
                : this.j.od.execCommand.bind(this.j.od), ctr.command || ctr.name, false, ctr.args && ctr.args[0]);
            this.j.e.fire('closeAllPopups');
        }
    }
    destruct() {
        this.__closePopup();
        return super.destruct();
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cacheHTML
], ToolbarButton.prototype, "createContainer", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('state.hasTrigger', { immediately: false })
], ToolbarButton.prototype, "onChangeHasTrigger", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('trigger:click')
], ToolbarButton.prototype, "onTriggerClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ToolbarButton.prototype, "onOutsideClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ToolbarButton.prototype, "__closePopup", null);
ToolbarButton = (0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
], ToolbarButton);



/***/ }),

/***/ 3268:
/***/ (function(module) {

module.exports["default"] = ["Begin met typen..","Over Jodit","Jodit Editor","Jodit gebruikershandleiding","bevat gedetailleerde informatie voor gebruik.","Voor informatie over de licentie, ga naar onze website:","Volledige versie kopen","Copyright © XDSoft.net - Chupurnov Valeriy. Alle rechten voorbehouden.","Anker","Open in nieuwe tab","Editor in volledig scherm openen","Opmaak verwijderen","Vulkleur of tekstkleur aanpassen","Opnieuw","Ongedaan maken","Vet","Cursief","Geordende list invoegen","Ongeordende lijst invoegen","Centreren","Uitlijnen op volledige breedte","Links uitlijnen","Rechts uitlijnen","Horizontale lijn invoegen","Afbeelding invoegen","Bestand invoegen","Youtube/Vimeo video invoegen","Link toevoegen","Tekstgrootte","Lettertype","Format blok invoegen","Normaal","Koptekst 1","Koptekst 2","Koptekst 3","Koptekst 4","Citaat","Code","Invoegen","Tabel invoegen","Inspringing verkleinen","Inspringing vergroten","Symbool selecteren","Symbool invoegen","Opmaak kopieren","Modus veranderen","Marges","Boven","Rechts","Onder","Links","CSS styles","CSS classes","Uitlijning","Rechts","Gecentreerd","Links","--Leeg--","Src","Titel","Alternatieve tekst","Link","Link in nieuwe tab openen","Afbeelding","Bestand","Geavanceerd","Afbeeldingseigenschappen","Annuleren","OK","Bestandsbrowser","Fout bij het laden van de lijst","Fout bij het laden van de mappenlijst","Weet je het zeker?","Geef de map een naam","Map aanmaken","Type naam","Sleep hier een afbeelding naartoe","Sleep hier een bestand naartoe","of klik","Alternatieve tekst","Uploaden","Bladeren","Achtergrond","Tekst","Boven","Midden","Onder","Kolom invoegen (voor)","Kolom invoegen (na)","Rij invoegen (boven)","Rij invoegen (onder)","Tabel verwijderen","Rij verwijderen","Kolom verwijderen","Cel leegmaken","Tekens: %d","Woorden: %d","Doorstrepen","Onderstrepen","Superscript","Subscript","Selectie knippen","Selecteer alles","Enter","Zoek naar","Vervangen door","Vervangen","Plakken","Kies content om te plakken","Broncode","vet","cursief","kwast","link","ongedaan maken","opnieuw","tabel","afbeelding","gum","paragraaf","lettergrootte","video","lettertype","over","afdrukken","onderstreept","doorgestreept","inspringen","minder inspringen","volledige grootte","kleiner maken","horizontale lijn","lijst","genummerde lijst","knip","alles selecteren","Embed code","Link openen","Link aanpassen","Niet volgen","link verwijderen","Updaten","Om te bewerken","Recensie"," URL","Bewerken","Horizontaal uitlijnen","Filteren","Sorteren op wijzigingsdatum","Sorteren op naam","Sorteren op grootte","Map toevoegen","Herstellen","Opslaan","Opslaan als ...","Grootte aanpassen","Bijknippen","Breedte","Hoogte","Verhouding behouden","Ja","Nee","Verwijderen","Selecteren","Selecteer: %s","Verticaal uitlijnen","Splitsen","Samenvoegen","Kolom toevoegen","Rij toevoegen",null,"Verwijderen","Verticaal splitsen","Horizontaal splitsen","Rand","Deze code lijkt op HTML. Als HTML behouden?","Invoegen als HTML","Origineel behouden","Als tekst invoegen","Als onopgemaakte tekst invoegen","Je kunt alleen je eigen afbeeldingen aanpassen. Deze afbeelding downloaden?","De afbeelding is succesvol geüploadet!","Palette","Er zijn geen bestanden in deze map.","Hernoemen","Voer een nieuwe naam in","Voorvertoning","Download","Plakken van klembord","Uw browser ondersteunt geen directe toegang tot het klembord.","Selectie kopiëren","kopiëren","Border radius","Toon alle","Toepassen","Vul dit veld in","Voer een webadres in","Standaard","Cirkel","Punt","Kwadraat","Zoeken","Vorige Zoeken","Volgende Zoeken","De geplakte tekst is afkomstig van een Microsoft Word/Excel document. Wil je de opmaak behouden of opschonen?","Word-tekst gedetecteerd","Opschonen","Voeg de klassenaam in","Druk op Alt voor aangepaste grootte",null,null,null]

/***/ }),

/***/ 3392:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   i: function() { return /* binding */ getKey; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/indent
 */

/**
 * Get style rule key for current direction
 * @internal
 */
const getKey = (direction, box) => `${jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isCell(box) ? 'padding' : 'margin'}${direction === 'rtl' ? 'Right' : 'Left'}`;


/***/ }),

/***/ 3459:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export inlinePopup */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71005);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(53048);
/* harmony import */ var jodit_core_ui_popup__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(96369);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8809);
/* harmony import */ var _config_config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(15776);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */











/**
 * Plugin for show inline popup dialog
 */
class inlinePopup extends jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k {
    constructor() {
        super(...arguments);
        this.type = null;
        this.snapRange = null;
        this.elmsList = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.keys)(this.j.o.popup, false).filter(s => !this.isExcludedTarget(s));
    }
    get popup() {
        return new jodit_core_ui_popup__WEBPACK_IMPORTED_MODULE_6__/* .Popup */ .z(this.jodit, false);
    }
    get toolbar() {
        return (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_7__/* .makeCollection */ .$K)(this.jodit, this.popup);
    }
    onClick(node) {
        const elements = this.elmsList, target = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(node, 'img')
            ? node
            : jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(node, elements, this.j.editor);
        if (target && this.canShowPopupForType(target.nodeName.toLowerCase())) {
            this.showPopup(() => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.position)(target, this.j), target.nodeName.toLowerCase(), target);
            return false;
        }
    }
    /**
     * Show inline popup with some toolbar
     *
     * @param type - selection, img, a etc.
     */
    showPopup(rect, type, target) {
        type = type.toLowerCase();
        if (!this.canShowPopupForType(type)) {
            return false;
        }
        if (this.type !== type || target !== this.previousTarget) {
            this.previousTarget = target;
            const data = this.j.o.popup[type];
            let content;
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(data)) {
                content = data(this.j, target, this.popup.close);
            }
            else {
                content = data;
            }
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isArray)(content)) {
                this.toolbar.build(content, target);
                this.toolbar.buttonSize = this.j.o.toolbarButtonSize;
                content = this.toolbar.container;
            }
            this.popup.setContent(content);
            this.type = type;
        }
        this.popup.open(rect);
        return true;
    }
    /**
     * Hide opened popup
     */
    hidePopup(type) {
        if (this.popup.isOpened && (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(type) || type === this.type)) {
            this.popup.close();
        }
    }
    onOutsideClick() {
        this.popup.close();
    }
    /**
     * Can show popup for this type
     */
    canShowPopupForType(type) {
        const data = this.j.o.popup[type.toLowerCase()];
        if (this.j.o.readonly || !this.j.o.toolbarInline || !data) {
            return false;
        }
        return !this.isExcludedTarget(type);
    }
    /**
     * For some elements do not show popup
     */
    isExcludedTarget(type) {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.splitArray)(this.j.o.toolbarInlineDisableFor)
            .map(a => a.toLowerCase())
            .includes(type.toLowerCase());
    }
    /** @override **/
    afterInit(jodit) {
        this.j.e
            .on('getDiffButtons.mobile', (toolbar) => {
            if (this.toolbar === toolbar) {
                const names = this.toolbar.getButtonsNames();
                return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.toArray)(jodit.registeredButtons)
                    .filter(btn => !this.j.o.toolbarInlineDisabledButtons.includes(btn.name))
                    .filter(item => {
                    const name = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(item) ? item : item.name;
                    return (name &&
                        name !== '|' &&
                        name !== '\n' &&
                        !names.includes(name));
                });
            }
        })
            .on('hidePopup', this.hidePopup)
            .on('showInlineToolbar', this.showInlineToolbar)
            .on('showPopup', (elm, rect, type) => {
            this.showPopup(rect, type || ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(elm) ? elm : elm.nodeName), (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(elm) ? undefined : elm);
        })
            .on('mousedown keydown', this.onSelectionStart)
            .on('change', () => {
            if (this.popup.isOpened &&
                this.previousTarget &&
                !this.previousTarget.parentNode) {
                this.hidePopup();
                this.previousTarget = undefined;
            }
        })
            .on([this.j.ew, this.j.ow], 'mouseup keyup', this.onSelectionEnd);
        this.addListenersForElements();
    }
    onSelectionStart() {
        this.snapRange = this.j.s.range.cloneRange();
    }
    onSelectionEnd(e) {
        if (e &&
            e.target &&
            jodit_core_ui__WEBPACK_IMPORTED_MODULE_5__/* .UIElement */ .D$.closestElement(e.target, jodit_core_ui_popup__WEBPACK_IMPORTED_MODULE_6__/* .Popup */ .z)) {
            return;
        }
        const { snapRange } = this, { range } = this.j.s;
        if (!snapRange ||
            range.collapsed ||
            range.startContainer !== snapRange.startContainer ||
            range.startOffset !== snapRange.startOffset ||
            range.endContainer !== snapRange.endContainer ||
            range.endOffset !== snapRange.endOffset) {
            this.onSelectionChange();
        }
    }
    /**
     * Selection change handler
     */
    onSelectionChange() {
        if (!this.j.o.toolbarInlineForSelection) {
            return;
        }
        const type = 'selection';
        const sel = this.j.s.sel;
        const range = this.j.s.range;
        if ((sel === null || sel === void 0 ? void 0 : sel.isCollapsed) || this.isSelectedTarget(range)) {
            if (this.type === type && this.popup.isOpened) {
                this.hidePopup();
            }
            return;
        }
        const node = this.j.s.current();
        if (!node) {
            return;
        }
        this.showPopup(() => range.getBoundingClientRect(), type);
    }
    /**
     * In not collapsed selection - only one image
     */
    isSelectedTarget(r) {
        const sc = r.startContainer;
        return (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(sc) &&
            sc === r.endContainer &&
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(sc.childNodes[r.startOffset], new Set((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.keys)(this.j.o.popup, false))) &&
            r.startOffset === r.endOffset - 1);
    }
    /**
     * Shortcut for Table module
     */
    // private get tableModule(): Table {
    // 	return this.j.getInstance<Table>('Table', this.j.o);
    // }
    /** @override **/
    beforeDestruct(jodit) {
        jodit.e
            .off('showPopup')
            .off([this.j.ew, this.j.ow], 'mouseup keyup', this.onSelectionEnd);
        this.removeListenersForElements();
    }
    _eventsList() {
        const el = this.elmsList;
        return el
            .map(e => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.camelCase)(`click_${e}`))
            .concat(el.map(e => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.camelCase)(`touchstart_${e}`)))
            .join(' ');
    }
    addListenersForElements() {
        this.j.e.on(this._eventsList(), this.onClick);
    }
    removeListenersForElements() {
        this.j.e.off(this._eventsList(), this.onClick);
    }
    /**
     * Show the inline WYSIWYG toolbar editor.
     */
    showInlineToolbar(bound) {
        this.showPopup(() => {
            if (bound) {
                return bound;
            }
            const { range } = this.j.s;
            return range.getBoundingClientRect();
        }, 'toolbar');
    }
}
inlinePopup.requires = ['select'];
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cache
], inlinePopup.prototype, "popup", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cache
], inlinePopup.prototype, "toolbar", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], inlinePopup.prototype, "onClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.wait)((ctx) => !ctx.j.isLocked)
], inlinePopup.prototype, "showPopup", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([':clickEditor', ':beforeCommandDelete', ':backSpaceAfterDelete']),
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], inlinePopup.prototype, "hidePopup", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(':outsideClick')
], inlinePopup.prototype, "onOutsideClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], inlinePopup.prototype, "onSelectionStart", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], inlinePopup.prototype, "onSelectionEnd", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.debounce)(ctx => ctx.defaultTimeout)
], inlinePopup.prototype, "onSelectionChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_9__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], inlinePopup.prototype, "showInlineToolbar", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('inlinePopup', inlinePopup);


/***/ }),

/***/ 3593:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   allowAttributes: function() { return /* reexport safe */ _allow_attributes__WEBPACK_IMPORTED_MODULE_0__.f; },
/* harmony export */   fillEmptyParagraph: function() { return /* reexport safe */ _fill_empty_paragraph__WEBPACK_IMPORTED_MODULE_1__.f; },
/* harmony export */   removeEmptyTextNode: function() { return /* reexport safe */ _remove_empty_text_node__WEBPACK_IMPORTED_MODULE_2__.r; },
/* harmony export */   removeInvTextNodes: function() { return /* reexport safe */ _remove_inv_text_nodes__WEBPACK_IMPORTED_MODULE_3__.u; },
/* harmony export */   replaceOldTags: function() { return /* reexport safe */ _replace_old_tags__WEBPACK_IMPORTED_MODULE_4__.H; },
/* harmony export */   sanitizeAttributes: function() { return /* reexport safe */ _sanitize_attributes__WEBPACK_IMPORTED_MODULE_5__.L; },
/* harmony export */   tryRemoveNode: function() { return /* reexport safe */ _try_remove_node__WEBPACK_IMPORTED_MODULE_6__.k; }
/* harmony export */ });
/* harmony import */ var _allow_attributes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5232);
/* harmony import */ var _fill_empty_paragraph__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63443);
/* harmony import */ var _remove_empty_text_node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(926);
/* harmony import */ var _remove_inv_text_nodes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(67431);
/* harmony import */ var _replace_old_tags__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(81199);
/* harmony import */ var _sanitize_attributes__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(32782);
/* harmony import */ var _try_remove_node__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(32014);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/clean-html
 */
/**
 * @private
 */









/***/ }),

/***/ 3843:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 16 16\"> <path stroke-width=\"0\" d=\"M16 9v-6h-3v-1c0-0.55-0.45-1-1-1h-11c-0.55 0-1 0.45-1 1v3c0 0.55 0.45 1 1 1h11c0.55 0 1-0.45 1-1v-1h2v4h-9v2h-0.5c-0.276 0-0.5 0.224-0.5 0.5v5c0 0.276 0.224 0.5 0.5 0.5h2c0.276 0 0.5-0.224 0.5-0.5v-5c0-0.276-0.224-0.5-0.5-0.5h-0.5v-1h9zM12 3h-11v-1h11v1z\"/> </svg>"

/***/ }),

/***/ 3947:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: function() { return /* binding */ isInt; }
/* harmony export */ });
/* harmony import */ var _is_numeric__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12461);
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */


/**
 * Check value is Int
 */
function isInt(value) {
    if ((0,_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(value) && (0,_is_numeric__WEBPACK_IMPORTED_MODULE_1__/* .isNumeric */ .k)(value)) {
        value = parseFloat(value);
    }
    return typeof value === 'number' && Number.isFinite(value) && !(value % 1);
}


/***/ }),

/***/ 4726:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'symbol'
};


/***/ }),

/***/ 4909:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ TabsWidget; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53048);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Build tabs system
 *
 * @param tabs - PlainObject where 'key' will be tab's Title and `value` is tab's content
 * @param state - You can use for this param any HTML element for remembering active tab
 *
 * @example
 * ```javascript
 * const editor = Jodit.make('#editor');
 * const tabs = Jodit.modules.TabsWidget(editor, [
 *  { name: 'Images', content: '<div>Images</div>' },
 *  {
 *    name: 'Title 2',
 *    content: editor.c.fromHTML('<div>Some content</div>')
 *  },
 *  {
 *    name: 'Color Picker',
 *    content: ColorPickerWidget(
 *      editor,
 *      function (color) {
 *        box.style.color = color;
 *      },
 *      box.style.color
 *    )
 *  }
 * ]);
 * ```
 */
const TabsWidget = (jodit, tabs, state) => {
    const box = jodit.c.div('jodit-tabs');
    const tabBox = jodit.c.div('jodit-tabs__wrapper');
    const buttons = jodit.c.div('jodit-tabs__buttons');
    (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_2__/* .attr */ .C)(buttons, {
        role: 'tablist',
        'aria-orientation': 'horizontal'
    });
    const nameToTab = {};
    const buttonList = [];
    let firstTab = '';
    box.appendChild(buttons);
    box.appendChild(tabBox);
    const setActive = (tab) => {
        if (!nameToTab[tab]) {
            return;
        }
        buttonList.forEach(b => {
            b.state.activated = false;
        });
        Object.values(nameToTab).forEach(({ tab }) => tab.classList.remove('jodit-tab_active'));
        nameToTab[tab].button.state.activated = true;
        nameToTab[tab].tab.classList.add('jodit-tab_active');
    };
    tabs.forEach(({ icon, name, content }) => {
        const tab = jodit.c.div('jodit-tab');
        (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_2__/* .attr */ .C)(tab, {
            role: 'tabpanel'
        });
        const button = (0,jodit_core_ui__WEBPACK_IMPORTED_MODULE_3__/* .Button */ .$n)(jodit, icon || name, name);
        button.state.role = 'tab';
        // Stop lose the focus
        jodit.e.on(button.container, 'pointerdown', (e) => e.preventDefault());
        if (!firstTab) {
            firstTab = name;
        }
        buttons.appendChild(button.container);
        buttonList.push(button);
        button.container.classList.add('jodit-tabs__button', 'jodit-tabs__button_columns_' + tabs.length);
        if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_4__/* .isFunction */ .T)(content)) {
            tab.appendChild(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .uA.isInstanceOf(content, jodit_core_ui__WEBPACK_IMPORTED_MODULE_3__/* .UIElement */ .D$)
                ? content.container
                : content);
        }
        else {
            tab.appendChild(jodit.c.div('jodit-tab_empty'));
        }
        tabBox.appendChild(tab);
        button.onAction(() => {
            setActive(name);
            if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_4__/* .isFunction */ .T)(content) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(content)) {
                content.call(jodit);
            }
            if (state) {
                state.activeTab = name;
            }
            return false;
        });
        nameToTab[name] = {
            button,
            tab
        };
    });
    Object.values(nameToTab).forEach(({ button }) => {
        button.container.style.width = (100 / tabs.length).toFixed(10) + '%';
    });
    const tab = !state || !state.activeTab || !nameToTab[state.activeTab]
        ? firstTab
        : state.activeTab;
    setActive(tab);
    if (state) {
        let activeTab = state.activeTab;
        Object.defineProperty(state, 'activeTab', {
            configurable: true,
            enumerable: false,
            get() {
                return activeTab;
            },
            set(value) {
                activeTab = value;
                setActive(value);
            }
        });
    }
    return box;
};


/***/ }),

/***/ 4960:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   G: function() { return /* binding */ htmlspecialchars; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */

/**
 * Convert special characters to HTML entities
 */
function htmlspecialchars(html) {
    const tmp = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('div');
    tmp.textContent = html;
    return tmp.innerHTML;
}


/***/ }),

/***/ 5232:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   f: function() { return /* binding */ allowAttributes; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @private
 */
function allowAttributes(jodit, nodeElm, hadEffect, allow) {
    if (allow && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(nodeElm) && allow[nodeElm.nodeName] !== true) {
        const attrs = nodeElm.attributes;
        if (attrs && attrs.length) {
            const removeAttrs = [];
            for (let i = 0; i < attrs.length; i += 1) {
                const attr = allow[nodeElm.nodeName][attrs[i].name];
                if (!attr || (attr !== true && attr !== attrs[i].value)) {
                    removeAttrs.push(attrs[i].name);
                }
            }
            if (removeAttrs.length) {
                hadEffect = true;
            }
            removeAttrs.forEach(attr => {
                nodeElm.removeAttribute(attr);
            });
        }
    }
    return hadEffect;
}


/***/ }),

/***/ 5298:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   W: function() { return /* binding */ moveNodeInsideStart; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Moves the fake node inside the adjacent element if it lies next to it but not inside.
 * When the cursor is positioned in its place, it must be inside the element and not outside its border.
 * @private
 */
function moveNodeInsideStart(j, node, start) {
    let sibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findSibling(node, start), anotherSibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findSibling(node, !start);
    while (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(sibling) &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(sibling, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS) &&
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isContentEditable(sibling, j.editor) &&
        (!anotherSibling || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(node, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement, j.editor))) {
        if (start || !sibling.firstChild) {
            sibling.appendChild(node);
        }
        else {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(sibling.firstChild, node);
        }
        sibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.sibling(node, start);
        anotherSibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.sibling(node, !start);
    }
}


/***/ }),

/***/ 5454:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F: function() { return /* binding */ UITextArea; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69198);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var UITextArea_1;





let UITextArea = UITextArea_1 = class UITextArea extends jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t {
    /** @override */
    className() {
        return 'UITextArea';
    }
    createNativeInput(options) {
        return this.j.create.element('textarea');
    }
    constructor(jodit, state) {
        super(jodit, state);
        /** @override */
        this.state = Object.assign({}, UITextArea_1.defaultState);
        Object.assign(this.state, state);
        if (this.state.resizable === false) {
            this.nativeInput.style.resize = 'none';
        }
    }
    onChangeStateSize() {
        const { size, resizable } = this.state;
        this.nativeInput.style.resize = resizable ? 'auto' : 'none';
        this.nativeInput.rows = size !== null && size !== void 0 ? size : 5;
    }
};
/** @override */
UITextArea.defaultState = Object.assign(Object.assign({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t.defaultState), { size: 5, resizable: true });
(0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(['state.size', 'state.resizable'])
], UITextArea.prototype, "onChangeStateSize", null);
UITextArea = UITextArea_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__/* .component */ .s
], UITextArea);



/***/ }),

/***/ 5533:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   p: function() { return /* binding */ AceEditor; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_plugins_source_editor_sourceEditor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53380);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



class AceEditor extends jodit_plugins_source_editor_sourceEditor__WEBPACK_IMPORTED_MODULE_2__/* .SourceEditor */ .F {
    constructor() {
        super(...arguments);
        this.className = 'jodit_ace_editor';
        /**
         * Proxy Method
         */
        this.proxyOnBlur = (e) => {
            this.j.e.fire('blur', e);
        };
        this.proxyOnFocus = (e) => {
            this.j.e.fire('focus', e);
        };
        this.proxyOnMouseDown = (e) => {
            this.j.e.fire('mousedown', e);
        };
    }
    aceExists() {
        return this.j.ow.ace !== undefined;
    }
    getLastColumnIndex(row) {
        return this.instance.session.getLine(row).length;
    }
    getLastColumnIndices() {
        const rows = this.instance.session.getLength();
        const lastColumnIndices = [];
        let lastColIndex = 0;
        for (let i = 0; i < rows; i++) {
            lastColIndex += this.getLastColumnIndex(i);
            if (i > 0) {
                lastColIndex += 1;
            }
            lastColumnIndices[i] = lastColIndex;
        }
        return lastColumnIndices;
    }
    getRowColumnIndices(characterIndex) {
        const lastColumnIndices = this.getLastColumnIndices();
        if (characterIndex <= lastColumnIndices[0]) {
            return { row: 0, column: characterIndex };
        }
        let row = 1;
        for (let i = 1; i < lastColumnIndices.length; i++) {
            if (characterIndex > lastColumnIndices[i]) {
                row = i + 1;
            }
        }
        const column = characterIndex - lastColumnIndices[row - 1] - 1;
        return { row, column };
    }
    setSelectionRangeIndices(start, end) {
        const startRowColumn = this.getRowColumnIndices(start);
        const endRowColumn = this.getRowColumnIndices(end);
        this.instance.getSelection().setSelectionRange({
            start: startRowColumn,
            end: endRowColumn
        });
    }
    getIndexByRowColumn(row, column) {
        const lastColumnIndices = this.getLastColumnIndices();
        return lastColumnIndices[row] - this.getLastColumnIndex(row) + column;
    }
    init(editor) {
        const tryInitAceEditor = () => {
            if (this.instance !== undefined || !this.aceExists()) {
                return;
            }
            const fakeMirror = this.j.c.div('jodit-source__mirror-fake');
            this.container.appendChild(fakeMirror);
            const ace = editor.ow.ace;
            this.instance = ace.edit(fakeMirror);
            if (editor.o.direction === 'rtl') {
                this.instance.setOption('rtlText', true);
                this.instance.setOption('rtl', true);
            }
            this.instance.setTheme(editor.o.sourceEditorNativeOptions.theme);
            this.instance.renderer.setShowGutter(editor.o.sourceEditorNativeOptions.showGutter);
            this.instance
                .getSession()
                .setMode(editor.o.sourceEditorNativeOptions.mode);
            this.instance.setHighlightActiveLine(editor.o.sourceEditorNativeOptions.highlightActiveLine);
            this.instance.getSession().setUseWrapMode(true);
            this.instance.setOption('indentedSoftWrap', false);
            this.instance.setOption('wrap', editor.o.sourceEditorNativeOptions.wrap);
            this.instance.getSession().setUseWorker(false);
            this.instance.$blockScrolling = Infinity;
            this.instance.on('change', this.toWYSIWYG);
            this.instance.on('focus', this.proxyOnFocus);
            this.instance.on('mousedown', this.proxyOnMouseDown);
            this.instance.on('blur', this.proxyOnBlur);
            if (editor.getRealMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG) {
                this.setValue(this.getValue());
            }
            const onResize = this.j.async.throttle(() => {
                if (editor.isInDestruct ||
                    editor.getMode() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG) {
                    return;
                }
                const hasFocus = this.instance.isFocused();
                if (editor.o.height !== 'auto') {
                    this.instance.setOption('maxLines', editor.workplace.offsetHeight /
                        this.instance.renderer.lineHeight);
                }
                else {
                    this.instance.setOption('maxLines', Infinity);
                }
                this.instance.resize();
                hasFocus && this.focus();
            }, this.j.defaultTimeout * 2);
            editor.e
                .on(editor, 'resize', onResize)
                .on('afterResize afterSetMode', onResize);
            onResize();
            this.onReady();
        };
        editor.e.on('afterSetMode', () => {
            if (editor.getRealMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE &&
                editor.getMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SPLIT) {
                return;
            }
            this.fromWYSIWYG();
            tryInitAceEditor();
        });
        tryInitAceEditor();
        // global add ace editor in browser
        if (!this.aceExists()) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.loadNext)(editor, editor.o.sourceEditorCDNUrlsJS)
                .then(() => {
                if (!editor.isInDestruct) {
                    tryInitAceEditor();
                }
            })
                .catch(() => null);
        }
    }
    destruct() {
        var _a, _b;
        this.instance.off('change', this.toWYSIWYG);
        this.instance.off('focus', this.proxyOnFocus);
        this.instance.off('mousedown', this.proxyOnMouseDown);
        this.instance.destroy();
        (_b = (_a = this.j) === null || _a === void 0 ? void 0 : _a.events) === null || _b === void 0 ? void 0 : _b.off('aceInited.source');
    }
    setValue(value) {
        if (!this.j.o.editHTMLDocumentMode && this.j.o.beautifyHTML) {
            const html = this.j.e.fire('beautifyHTML', value);
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isString)(html)) {
                value = html;
            }
        }
        this.instance.setValue(value);
        this.instance.clearSelection();
    }
    getValue() {
        return this.instance.getValue();
    }
    setReadOnly(isReadOnly) {
        this.instance.setReadOnly(isReadOnly);
    }
    get isFocused() {
        return this.instance.isFocused();
    }
    focus() {
        this.instance.container.focus();
        this.instance.focus();
    }
    blur() {
        this.instance.blur();
    }
    getSelectionStart() {
        const range = this.instance.selection.getRange();
        return this.getIndexByRowColumn(range.start.row, range.start.column);
    }
    getSelectionEnd() {
        const range = this.instance.selection.getRange();
        return this.getIndexByRowColumn(range.end.row, range.end.column);
    }
    selectAll() {
        this.instance.selection.selectAll();
    }
    insertRaw(html) {
        const start = this.instance.selection.getCursor(), end = this.instance.session.insert(start, html);
        this.instance.selection.setRange({
            start,
            end
        }, false);
    }
    setSelectionRange(start, end) {
        this.setSelectionRangeIndices(start, end);
    }
    setPlaceHolder(title) {
        // ACE does not support placeholder
        // title
    }
    replaceUndoManager() {
        const { history } = this.jodit;
        this.instance.commands.addCommand({
            name: 'Undo',
            bindKey: { win: 'Ctrl-Z', mac: 'Command-Z' },
            exec: () => {
                history.undo();
            }
        });
        this.instance.commands.addCommand({
            name: 'Redo',
            bindKey: { win: 'Ctrl-Shift-Z', mac: 'Command-Shift-Z' },
            exec: () => {
                history.redo();
            }
        });
    }
}


/***/ }),

/***/ 5549:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   U: function() { return /* binding */ readValuesFromImage; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26150);
/* harmony import */ var _align__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(74260);
/* harmony import */ var _link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33201);
/* harmony import */ var _margin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85079);
/* harmony import */ var _size__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(17880);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Read values from image and set it to state
 * @private
 */
function readValuesFromImage(j, state) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
        const { sourceImage: image, values } = state;
        (0,_align__WEBPACK_IMPORTED_MODULE_4__/* .readAlign */ .g)(image, values);
        // Border radius
        values.borderRadius = parseInt(image.style.borderRadius || '0', 10) || 0;
        // Id
        values.id = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'id') || '';
        // Title
        values.imageTitle = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'title') || '';
        // Alt
        values.imageAlt = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'alt') || '';
        // Style
        values.style = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'style') || '';
        // Classes
        values.classes = ((0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'class') || '').replace(/jodit_focused_image[\s]*/, '');
        // Margins
        (0,_margin__WEBPACK_IMPORTED_MODULE_5__/* .readMargins */ .E)(image, values, state);
        // Link
        (0,_link__WEBPACK_IMPORTED_MODULE_1__/* .readLink */ .X)(state, j, values);
        // Src
        values.imageSrc = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'src') || '';
        // Image size
        return (0,_size__WEBPACK_IMPORTED_MODULE_2__/* .readSizes */ .P)(image, values, state);
    });
}


/***/ }),

/***/ 5832:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IB: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.I; },
/* harmony export */   P1: function() { return /* reexport safe */ _content__WEBPACK_IMPORTED_MODULE_1__.P; },
/* harmony export */   q4: function() { return /* reexport safe */ _select_select__WEBPACK_IMPORTED_MODULE_2__.q; }
/* harmony export */ });
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3258);
/* harmony import */ var _content__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(49405);
/* harmony import */ var _select_select__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(48053);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module modules/toolbar/button
 */





/***/ }),

/***/ 5854:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F: function() { return /* binding */ Alert; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_array_as_array__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(82317);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(92032);
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(58006);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Show `alert` dialog. Work without Jodit object
 * @example
 * ```javascript
 * Jodit.Alert("File was uploaded");
 * Jodit.Alert("File was uploaded", "Message");
 * Jodit.Alert("File was uploaded", function() {
 *    $('form').hide();
 * });
 * Jodit.Alert("File wasn't uploaded", "Error", function() {
 *    $('form').hide();
 * });
 * ```
 */
function Alert(msg, title, callback, className = 'jodit-dialog_alert') {
    if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__/* .isFunction */ .T)(title)) {
        callback = title;
        title = undefined;
    }
    const dialog = this instanceof _dialog__WEBPACK_IMPORTED_MODULE_2__/* .Dialog */ .l
        ? this
        : new _dialog__WEBPACK_IMPORTED_MODULE_2__/* .Dialog */ .l({ closeOnClickOverlay: true }), container = dialog.c.div(className), okButton = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__/* .Button */ .$n)(dialog, 'ok', 'Ok');
    (0,jodit_core_helpers_array_as_array__WEBPACK_IMPORTED_MODULE_4__/* .asArray */ ._)(msg).forEach(oneMessage => {
        container.appendChild(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isNode(oneMessage) ? oneMessage : dialog.c.fromHTML(oneMessage));
    });
    okButton.onAction(() => {
        if (!callback || !(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_3__/* .isFunction */ .T)(callback) || callback(dialog) !== false) {
            dialog.close();
        }
    });
    dialog.setFooter([okButton]);
    dialog.open(container, title || '&nbsp;', true, true);
    okButton.focus();
    return dialog;
}


/***/ }),

/***/ 5878:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'copy-format': 'Kopyalama Biçimi'
};


/***/ }),

/***/ 6110:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: function() { return /* binding */ checkBR; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils_scroll_into_view__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(641);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Checks the possibility and necessity of inserting a BR instead of a block
 * @private
 */
function checkBR(fake, jodit, shiftKeyPressed) {
    const isMultiLineBlock = Boolean(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(fake, ['pre', 'blockquote'], jodit.editor));
    const isCell = !isMultiLineBlock && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(fake, ['td', 'th'], jodit.editor);
    const isBRMode = jodit.o.enter.toLowerCase() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.BR.toLowerCase();
    // if you use <br> defaultTag for break line or when was entered SHIFt key or in <td> or <th> or <blockquote>
    if (isBRMode ||
        isCell ||
        (shiftKeyPressed && !isMultiLineBlock) ||
        (!shiftKeyPressed && isMultiLineBlock)) {
        // 2 BR before
        if (isMultiLineBlock && checkSeveralBR(fake)) {
            return false;
        }
        const br = jodit.createInside.element('br');
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(fake, br);
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findNotEmptySibling(br, false)) {
            const clone = br.cloneNode();
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.after(br, clone);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(clone, fake);
        }
        (0,jodit_core_helpers_utils_scroll_into_view__WEBPACK_IMPORTED_MODULE_2__/* .scrollIntoViewIfNeeded */ .$)(br, jodit.editor, jodit.ed);
        return true;
    }
    return false;
}
function checkSeveralBR(fake) {
    // 2 BR before
    const preBr = brBefore(brBefore(fake));
    if (preBr) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(brBefore(fake));
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(preBr);
        return true;
    }
    return false;
}
function brBefore(start) {
    if (!start) {
        return false;
    }
    const prev = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findSibling(start, true);
    if (!prev || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(prev, 'br')) {
        return false;
    }
    return prev;
}


/***/ }),

/***/ 6295:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _img__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26396);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/* harmony default export */ __webpack_exports__.A = ([
    {
        name: 'bin',
        tooltip: 'Delete',
        exec: (editor, image) => {
            image && editor.s.removeNode(image);
        }
    },
    _img__WEBPACK_IMPORTED_MODULE_0__/* .align */ .M
]);


/***/ }),

/***/ 6455:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   U: function() { return /* binding */ UIGroup; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37474);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29780);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var UIGroup_1;








let UIGroup = UIGroup_1 = class UIGroup extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_5__/* .UIElement */ .D {
    className() {
        return 'UIGroup';
    }
    /**
     * All group children
     */
    get allChildren() {
        const result = [];
        const stack = [
            ...this.elements
        ];
        while (stack.length) {
            const elm = stack.shift();
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isArray)(elm)) {
                stack.push(...elm);
            }
            else if (jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(elm, UIGroup_1)) {
                stack.push(...elm.elements);
            }
            else {
                elm && result.push(elm);
            }
        }
        return result;
    }
    /**
     * Update all children
     */
    update() {
        this.elements.forEach(elm => elm.update());
        this.setMod('size', this.buttonSize);
    }
    /**
     * Append new element into group
     */
    append(elm, distElement) {
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isArray)(elm)) {
            elm.forEach(item => this.append(item, distElement));
            return this;
        }
        this.elements.push(elm);
        if (elm.name) {
            elm.container.classList.add(this.getFullElName(elm.name));
        }
        if (distElement) {
            const distElm = this.getElm(distElement);
            void 0;
            distElm.appendChild(elm.container);
        }
        else {
            this.appendChildToContainer(elm.container);
        }
        elm.parentElement = this;
        return this;
    }
    /** @override */
    afterSetMod(name, value) {
        if (this.syncMod) {
            this.elements.forEach(elm => elm.setMod(name, value));
        }
    }
    /**
     * Allow set another container for the box of all children
     */
    appendChildToContainer(childContainer) {
        this.container.appendChild(childContainer);
    }
    /**
     * Remove element from group
     */
    remove(elm) {
        const index = this.elements.indexOf(elm);
        if (index !== -1) {
            this.elements.splice(index, 1);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(elm.container);
            elm.parentElement = null;
        }
        return this;
    }
    /**
     * Clear group
     */
    clear() {
        this.elements.forEach(elm => elm.destruct());
        this.elements.length = 0;
        return this;
    }
    /**
     * @param elements - Items of group
     */
    constructor(jodit, elements, options) {
        super(jodit, options);
        this.options = options;
        /**
         * Synchronize mods to all children
         */
        this.syncMod = false;
        this.elements = [];
        this.buttonSize = 'middle';
        elements === null || elements === void 0 ? void 0 : elements.forEach(elm => elm && this.append(elm));
        if (options === null || options === void 0 ? void 0 : options.name) {
            this.name = options.name;
        }
    }
    /** @override */
    destruct() {
        this.clear();
        return super.destruct();
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)('buttonSize')
], UIGroup.prototype, "update", null);
UIGroup = UIGroup_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
], UIGroup);



/***/ }),

/***/ 6589:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   As: function() { return /* reexport safe */ _stringify__WEBPACK_IMPORTED_MODULE_4__.A; },
/* harmony export */   Bq: function() { return /* reexport safe */ _trim__WEBPACK_IMPORTED_MODULE_5__.Bq; },
/* harmony export */   Gd: function() { return /* reexport safe */ _trim__WEBPACK_IMPORTED_MODULE_5__.Gd; },
/* harmony export */   Hp: function() { return /* reexport safe */ _fuzzy_search_index__WEBPACK_IMPORTED_MODULE_1__.H; },
/* harmony export */   N: function() { return /* reexport safe */ _kebab_case__WEBPACK_IMPORTED_MODULE_3__.N; },
/* harmony export */   Ru: function() { return /* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_2__.R; },
/* harmony export */   Z2: function() { return /* reexport safe */ _ucfirst__WEBPACK_IMPORTED_MODULE_6__.Z; },
/* harmony export */   gj: function() { return /* reexport safe */ _trim__WEBPACK_IMPORTED_MODULE_5__.gj; },
/* harmony export */   kW: function() { return /* reexport safe */ _kebab_case__WEBPACK_IMPORTED_MODULE_3__.k; },
/* harmony export */   nv: function() { return /* reexport safe */ _i18n__WEBPACK_IMPORTED_MODULE_2__.n; },
/* harmony export */   xQ: function() { return /* reexport safe */ _camel_case__WEBPACK_IMPORTED_MODULE_0__.x; }
/* harmony export */ });
/* harmony import */ var _camel_case__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83260);
/* harmony import */ var _fuzzy_search_index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67975);
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(91093);
/* harmony import */ var _kebab_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(449);
/* harmony import */ var _stringify__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28616);
/* harmony import */ var _trim__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(59101);
/* harmony import */ var _ucfirst__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(10467);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/string
 */









/***/ }),

/***/ 6857:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export resizer */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29866);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(69505);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










const keyBInd = '__jodit-resizer_binded';
/**
 * The module creates a supporting frame for resizing of the elements img and table
 */
class resizer extends jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__/* .Plugin */ .k {
    constructor() {
        super(...arguments);
        this.LOCK_KEY = 'resizer';
        this.element = null;
        this.isResizeMode = false;
        this.isShown = false;
        this.startX = 0;
        this.startY = 0;
        this.width = 0;
        this.height = 0;
        this.ratio = 0;
        this.rect = this.j.c.fromHTML(`<div title="${this.j.i18n('Press Alt for custom resizing')}" class="jodit-resizer">
				<div class="jodit-resizer__top-left"></div>
				<div class="jodit-resizer__top-right"></div>
				<div class="jodit-resizer__bottom-right"></div>
				<div class="jodit-resizer__bottom-left"></div>
				<span>100x100</span>
			</div>`);
        this.sizeViewer = this.rect.getElementsByTagName('span')[0];
        this.pointerX = 0;
        this.pointerY = 0;
        this.isAltMode = false;
        this.onClickElement = (element) => {
            if (this.isResizeMode) {
                return;
            }
            if (this.element !== element || !this.isShown) {
                this.element = element;
                this.show();
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(this.element, 'img') && !this.element.complete) {
                    this.j.e.one(this.element, 'load', this.updateSize);
                }
            }
        };
        this.updateSize = () => {
            if (this.isInDestruct || !this.isShown) {
                return;
            }
            if (this.element && this.rect) {
                const workplacePosition = this.getWorkplacePosition();
                const pos = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)(this.element, this.j, this.j.ed), left = parseInt(this.rect.style.left || '0', 10), top = parseInt(this.rect.style.top || '0', 10), w = this.rect.offsetWidth, h = this.rect.offsetHeight;
                const newTop = pos.top - workplacePosition.top, newLeft = pos.left - workplacePosition.left;
                if (top !== newTop ||
                    left !== newLeft ||
                    w !== this.element.offsetWidth ||
                    h !== this.element.offsetHeight) {
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(this.rect, {
                        top: newTop,
                        left: newLeft,
                        width: this.element.offsetWidth,
                        height: this.element.offsetHeight
                    });
                    if (this.j.events) {
                        this.j.e.fire(this.element, 'changesize');
                        // check for first init. Ex. inlinePopup hides when it was fired
                        if (!isNaN(left)) {
                            this.j.e.fire('resize');
                        }
                    }
                }
            }
        };
        this.hideSizeViewer = () => {
            this.sizeViewer.style.opacity = '0';
        };
    }
    /** @override */
    afterInit(editor) {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.$$)('div', this.rect).forEach((resizeHandle) => {
            editor.e.on(resizeHandle, 'mousedown.resizer touchstart.resizer', this.onStartResizing.bind(this, resizeHandle));
        });
        jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .eventEmitter */ .RR.on('hideHelpers', this.hide);
        editor.e
            .on('readonly', (isReadOnly) => {
            if (isReadOnly) {
                this.hide();
            }
        })
            .on('afterInit changePlace', this.addEventListeners.bind(this))
            .on('afterGetValueFromEditor.resizer', (data) => {
            const rgx = /<jodit[^>]+data-jodit_iframe_wrapper[^>]+>(.*?<iframe[^>]*>.*?<\/iframe>.*?)<\/jodit>/gi;
            if (rgx.test(data.value)) {
                data.value = data.value.replace(rgx, '$1');
            }
        });
        this.addEventListeners();
        this.__onChangeEditor();
    }
    /**
     * Click in the editor area
     */
    onEditorClick(e) {
        let node = e.target;
        const { editor, options: { allowResizeTags } } = this.j;
        while (node && node !== editor) {
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(node, allowResizeTags)) {
                this.__bind(node);
                this.onClickElement(node);
                return;
            }
            node = node.parentNode;
        }
    }
    __afterInsertImage(image) {
        if (this.j.o.resizer.forImageChangeAttributes) {
            return;
        }
        const width = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(image, 'width');
        if (width && !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(image, 'width', true)) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(image, 'width', width);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(image, 'width', null);
        }
    }
    addEventListeners() {
        const editor = this.j;
        editor.e
            .off(editor.editor, '.resizer')
            .off(editor.ow, '.resizer')
            .on(editor.editor, 'keydown.resizer', (e) => {
            if (this.isShown &&
                e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DELETE &&
                this.element &&
                !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(this.element, 'table')) {
                this.onDelete(e);
            }
        })
            .on(editor.ow, 'resize.resizer', this.updateSize)
            .on('resize.resizer', this.updateSize)
            .on([editor.ow, editor.editor], 'scroll.resizer', () => {
            if (this.isShown && !this.isResizeMode) {
                this.hide();
            }
        })
            .on(editor.ow, 'keydown.resizer', this.onKeyDown)
            .on(editor.ow, 'keyup.resizer', this.onKeyUp)
            .on(editor.ow, 'mouseup.resizer touchend.resizer', this.onClickOutside);
    }
    onStartResizing(resizeHandle, e) {
        if (!this.element || !this.element.parentNode) {
            this.hide();
            return false;
        }
        this.handle = resizeHandle;
        if (e.cancelable) {
            e.preventDefault();
        }
        e.stopImmediatePropagation();
        this.width = this.element.offsetWidth;
        this.height = this.element.offsetHeight;
        this.ratio = this.width / this.height;
        this.isResizeMode = true;
        this.startX = e.clientX;
        this.startY = e.clientY;
        this.pointerX = e.clientX;
        this.pointerY = e.clientY;
        const { j } = this;
        j.e.fire('hidePopup');
        j.lock(this.LOCK_KEY);
        j.e.on(j.ow, 'mousemove.resizer touchmove.resizer', this.onResize);
    }
    onEndResizing() {
        const { j } = this;
        j.unlock();
        this.isResizeMode = false;
        this.isAltMode = false;
        j.synchronizeValues();
        j.e.off(j.ow, 'mousemove.resizer touchmove.resizer', this.onResize);
    }
    onResize(e) {
        if (this.isResizeMode) {
            if (!this.element) {
                return;
            }
            this.pointerX = e.clientX;
            this.pointerY = e.clientY;
            let diff_x, diff_y;
            if (this.j.options.iframe) {
                const workplacePosition = this.getWorkplacePosition();
                diff_x = e.clientX + workplacePosition.left - this.startX;
                diff_y = e.clientY + workplacePosition.top - this.startY;
            }
            else {
                diff_x = this.pointerX - this.startX;
                diff_y = this.pointerY - this.startY;
            }
            const className = this.handle.className;
            let new_w = 0, new_h = 0;
            const uar = this.j.o.resizer.useAspectRatio;
            if (!this.isAltMode &&
                (uar === true || (uar && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(this.element, uar)))) {
                if (diff_x) {
                    new_w =
                        this.width +
                            (className.match(/left/) ? -1 : 1) * diff_x;
                    new_h = Math.round(new_w / this.ratio);
                }
                else {
                    new_h =
                        this.height +
                            (className.match(/top/) ? -1 : 1) * diff_y;
                    new_w = Math.round(new_h * this.ratio);
                }
                if (new_w > (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.innerWidth)(this.j.editor, this.j.ow)) {
                    new_w = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.innerWidth)(this.j.editor, this.j.ow);
                    new_h = Math.round(new_w / this.ratio);
                }
            }
            else {
                new_w =
                    this.width + (className.match(/left/) ? -1 : 1) * diff_x;
                new_h =
                    this.height + (className.match(/top/) ? -1 : 1) * diff_y;
            }
            if (new_w > this.j.o.resizer.min_width) {
                if (new_w < this.rect.parentNode.offsetWidth) {
                    this.applySize(this.element, 'width', new_w);
                }
                else {
                    this.applySize(this.element, 'width', '100%');
                }
            }
            if (new_h > this.j.o.resizer.min_height) {
                this.applySize(this.element, 'height', new_h);
            }
            this.updateSize();
            this.showSizeViewer(this.element.offsetWidth, this.element.offsetHeight);
            e.stopImmediatePropagation();
        }
    }
    onKeyDown(e) {
        this.isAltMode = e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_ALT;
        if (!this.isAltMode && this.isResizeMode) {
            this.onEndResizing();
        }
    }
    onKeyUp() {
        if (this.isAltMode && this.isResizeMode && this.element) {
            this.width = this.element.offsetWidth;
            this.height = this.element.offsetHeight;
            this.ratio = this.width / this.height;
            this.startX = this.pointerX;
            this.startY = this.pointerY;
        }
        this.isAltMode = false;
    }
    onClickOutside(e) {
        if (!this.isShown) {
            return;
        }
        if (!this.isResizeMode) {
            return this.hide();
        }
        e.stopImmediatePropagation();
        this.onEndResizing();
    }
    getWorkplacePosition() {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)((this.rect.parentNode || this.j.od.documentElement), this.j, this.j.od, true);
    }
    applySize(element, key, value) {
        const changeAttrs = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isImage(element) && this.j.o.resizer.forImageChangeAttributes;
        if (changeAttrs) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(element, key, value);
        }
        if (!changeAttrs || element.style[key]) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(element, key, value);
        }
    }
    onDelete(e) {
        if (!this.element) {
            return;
        }
        if (this.element.tagName !== 'JODIT') {
            this.j.s.select(this.element);
        }
        else {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.element);
            this.hide();
            e.preventDefault();
        }
    }
    __onChangeEditor() {
        if (this.isShown) {
            if (!this.element || !this.element.parentNode) {
                this.hide();
            }
            else {
                this.updateSize();
            }
        }
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.$$)('iframe', this.j.editor).forEach(this.__bind);
    }
    /**
     * Bind an edit element to element
     * @param element - The element that you want to add a function to resize
     */
    __bind(element) {
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isHTMLElement(element) ||
            !this.j.o.allowResizeTags.has(element.tagName.toLowerCase()) ||
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.dataBind)(element, keyBInd)) {
            return;
        }
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.dataBind)(element, keyBInd, true);
        let wrapper;
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(element, 'iframe')) {
            const iframe = element;
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isHTMLElement(element.parentNode) &&
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(element.parentNode, '-jodit_iframe_wrapper')) {
                element = element.parentNode;
            }
            else {
                wrapper = this.j.createInside.element('jodit', {
                    'data-jodit-temp': 1,
                    contenteditable: false,
                    draggable: true,
                    'data-jodit_iframe_wrapper': 1
                });
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(wrapper, 'style', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(element, 'style'));
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(wrapper, {
                    display: element.style.display === 'inline-block'
                        ? 'inline-block'
                        : 'block',
                    width: element.offsetWidth,
                    height: element.offsetHeight
                });
                if (element.parentNode) {
                    element.parentNode.insertBefore(wrapper, element);
                }
                wrapper.appendChild(element);
                this.j.e.on(wrapper, 'click', () => {
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(wrapper, 'data-jodit-wrapper_active', true);
                });
                element = wrapper;
            }
            this.j.e
                .off(element, 'mousedown.select touchstart.select')
                .on(element, 'mousedown.select touchstart.select', () => {
                this.j.s.select(element);
            })
                .off(element, 'changesize')
                .on(element, 'changesize', () => {
                iframe.setAttribute('width', element.offsetWidth + 'px');
                iframe.setAttribute('height', element.offsetHeight + 'px');
            });
        }
        this.j.e.on(element, 'dragstart', this.hide);
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_ES_NEXT && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_IE) {
            // for IE don't show native resizer
            this.j.e.on(element, 'mousedown', (event) => {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(element, 'img')) {
                    event.preventDefault();
                }
            });
        }
    }
    showSizeViewer(w, h) {
        if (!this.j.o.resizer.showSize) {
            return;
        }
        if (w < this.sizeViewer.offsetWidth ||
            h < this.sizeViewer.offsetHeight) {
            this.hideSizeViewer();
            return;
        }
        this.sizeViewer.style.opacity = '1';
        this.sizeViewer.textContent = `${w} x ${h}`;
        this.j.async.setTimeout(this.hideSizeViewer, {
            timeout: this.j.o.resizer.hideSizeTimeout,
            label: 'hideSizeViewer'
        });
    }
    /**
     * Show resizer
     */
    show() {
        if (this.j.o.readonly || this.isShown) {
            return;
        }
        this.isShown = true;
        if (!this.rect.parentNode) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.markOwner)(this.j, this.rect);
            this.j.workplace.appendChild(this.rect);
        }
        if (this.j.isFullSize) {
            this.rect.style.zIndex = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.css)(this.j.container, 'zIndex').toString();
        }
        this.updateSize();
    }
    /**
     * Hide resizer
     */
    hide() {
        if (!this.isResizeMode) {
            this.isResizeMode = false;
            this.isShown = false;
            this.element = null;
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.rect);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.$$)("[data-jodit-wrapper_active='true']", this.j.editor).forEach(elm => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.attr)(elm, 'data-jodit-wrapper_active', false));
        }
    }
    beforeDestruct(jodit) {
        this.hide();
        jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .eventEmitter */ .RR.off('hideHelpers', this.hide);
        jodit.e.off(this.j.ow, '.resizer').off('.resizer');
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':click')
], resizer.prototype, "onEditorClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':afterInsertImage')
], resizer.prototype, "__afterInsertImage", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], resizer.prototype, "onStartResizing", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], resizer.prototype, "onEndResizing", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], resizer.prototype, "onResize", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], resizer.prototype, "onKeyDown", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], resizer.prototype, "onKeyUp", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], resizer.prototype, "onClickOutside", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':change')
], resizer.prototype, "__onChangeEditor", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], resizer.prototype, "__bind", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind,
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':hideResizer')
], resizer.prototype, "hide", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('resizer', resizer);


/***/ }),

/***/ 6939:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: function() { return /* binding */ isURL; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */

/**
 * Check if a string is an url
 */
function isURL(str) {
    if (str.includes(' ')) {
        return false;
    }
    if (typeof URL !== 'undefined') {
        try {
            const url = new URL(str);
            return ['https:', 'http:', 'ftp:', 'file:', 'rtmp:'].includes(url.protocol);
        }
        catch (e) {
            return false;
        }
    }
    const a = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('a');
    a.href = str;
    return Boolean(a.hostname);
}


/***/ }),

/***/ 7920:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   r: function() { return /* binding */ normalizeSize; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */
/**
 * Normalize value to CSS meters
 */
const normalizeSize = (value, units) => {
    if (/^[0-9]+$/.test(value.toString())) {
        return value + units;
    }
    return value.toString();
};


/***/ }),

/***/ 7982:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   v: function() { return /* binding */ ViewComponent; }
/* harmony export */ });
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37474);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

class ViewComponent extends _component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u {
    /**
     * Shortcut for `this.jodit`
     */
    get j() {
        return this.jodit;
    }
    get defaultTimeout() {
        return this.j.defaultTimeout;
    }
    i18n(text, ...params) {
        return this.j.i18n(text, ...params);
    }
    /**
     * Attach component to View
     */
    setParentView(jodit) {
        this.jodit = jodit;
        jodit.components.add(this);
        return this;
    }
    constructor(jodit) {
        super();
        this.setParentView(jodit);
    }
    /** @override */
    destruct() {
        this.j.components.delete(this);
        return super.destruct();
    }
}


/***/ }),

/***/ 8136:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1792 1344v128q0 26-19 45t-45 19h-1664q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1664q26 0 45 19t19 45zm-384-384v128q0 26-19 45t-45 19h-1280q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1280q26 0 45 19t19 45zm256-384v128q0 26-19 45t-45 19h-1536q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1536q26 0 45 19t19 45zm-384-384v128q0 26-19 45t-45 19h-1152q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1152q26 0 45 19t19 45z\"/> </svg>"

/***/ }),

/***/ 8453:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   p: function() { return /* binding */ LazyWalker; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_event_emitter_eventify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(43431);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




class LazyWalker extends jodit_core_event_emitter_eventify__WEBPACK_IMPORTED_MODULE_2__/* .Eventify */ .h {
    setWork(root) {
        if (this.isWorked) {
            this.break();
        }
        this.workNodes = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.eachGen(root, !this.options.reverse);
        this.isFinished = false;
        this._requestStarting();
        return this;
    }
    constructor(async, options = {}) {
        super();
        this.async = async;
        this.options = options;
        this.workNodes = null;
        this.hadAffect = false;
        this.isWorked = false;
        this.isFinished = false;
        this.idleId = 0;
        this.__schedulerController = null;
    }
    _requestStarting() {
        this.__schedulerController = new AbortController();
        this.async
            .schedulerPostTask(this.__workPerform, {
            delay: this.options.timeout,
            signal: this.__schedulerController.signal
        })
            .catch(() => null);
    }
    break(reason) {
        if (this.isWorked) {
            this.stop();
            this.emit('break', reason);
        }
    }
    end() {
        if (this.isWorked) {
            this.stop();
            this.emit('end', this.hadAffect);
            this.hadAffect = false;
        }
    }
    stop() {
        this.isWorked = false;
        this.isFinished = true;
        this.workNodes = null;
        this.async.cancelIdleCallback(this.idleId);
    }
    destruct() {
        super.destruct();
        this.stop();
    }
    __workPerform() {
        var _a;
        if (this.workNodes) {
            this.isWorked = true;
            let count = 0;
            const chunkSize = (_a = this.options.timeoutChunkSize) !== null && _a !== void 0 ? _a : 50;
            while (!this.isFinished && count <= chunkSize) {
                const item = this.workNodes.next();
                count += 1;
                if (this.visitNode(item.value)) {
                    this.hadAffect = true;
                }
                if (item.done) {
                    this.end();
                    return;
                }
            }
        }
        else {
            this.end();
        }
        if (!this.isFinished) {
            this._requestStarting();
        }
    }
    visitNode(nodeElm) {
        var _a;
        if (!nodeElm ||
            (this.options.whatToShow !== undefined &&
                nodeElm.nodeType !== this.options.whatToShow)) {
            return false;
        }
        return (_a = this.emit('visit', nodeElm)) !== null && _a !== void 0 ? _a : false;
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], LazyWalker.prototype, "__workPerform", null);


/***/ }),

/***/ 8757:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   x: function() { return /* binding */ CommitStyle; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83260);
/* harmony import */ var jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12043);
/* harmony import */ var _apply_style__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10494);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




class CommitStyle {
    isApplied(elm, key) {
        const data = this.__applyMap.get(elm);
        if (!data) {
            return false;
        }
        return data[key];
    }
    setApplied(elm, key) {
        var _a;
        const data = (_a = this.__applyMap.get(elm)) !== null && _a !== void 0 ? _a : {};
        data[key] = true;
        this.__applyMap.set(elm, data);
    }
    get elementIsList() {
        return Boolean(this.options.element && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS.has(this.options.element));
    }
    get element() {
        return this.options.element || this.defaultTag;
    }
    /**
     * New element is blocked
     */
    get elementIsBlock() {
        return Boolean(this.options.element && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_BLOCK.test(this.options.element));
    }
    /**
     * The commit applies the tag change
     */
    get isElementCommit() {
        return Boolean(this.options.element &&
            this.options.element !== this.options.defaultTag);
    }
    get defaultTag() {
        if (this.options.defaultTag) {
            return this.options.defaultTag;
        }
        return this.elementIsBlock ? 'p' : 'span';
    }
    get elementIsDefault() {
        return this.element === this.defaultTag;
    }
    constructor(options) {
        this.options = options;
        this.__applyMap = new WeakMap();
    }
    apply(jodit) {
        const { hooks } = this.options;
        const keys = (hooks ? Object.keys(hooks) : []);
        try {
            keys.forEach(key => {
                jodit.e.on((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__/* .camelCase */ .x)(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_3__/* ._PREFIX */ .ar + '_' + key), hooks[key]);
            });
            (0,_apply_style__WEBPACK_IMPORTED_MODULE_1__/* .ApplyStyle */ .O)(jodit, this);
        }
        finally {
            keys.forEach(key => {
                jodit.e.off((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_2__/* .camelCase */ .x)(jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_3__/* ._PREFIX */ .ar + '_' + key), hooks[key]);
            });
            this.__applyMap = new WeakMap();
        }
        jodit.synchronizeValues();
        jodit.e.fire('afterCommitStyle', this);
    }
}


/***/ }),

/***/ 8809:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $K: function() { return /* binding */ makeCollection; },
/* harmony export */   BJ: function() { return /* binding */ makeButton; },
/* harmony export */   RR: function() { return /* binding */ makeSelect; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3258);
/* harmony import */ var _button_content__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(49405);
/* harmony import */ var _button_select_select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(48053);
/* harmony import */ var _collection_collection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97394);
/* harmony import */ var _collection_editor_collection__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(90428);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Collection factory
 */
function makeCollection(jodit, parentElement) {
    const collection = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isJoditObject)(jodit)
        ? new _collection_editor_collection__WEBPACK_IMPORTED_MODULE_5__/* .ToolbarEditorCollection */ .b(jodit)
        : new _collection_collection__WEBPACK_IMPORTED_MODULE_4__/* .ToolbarCollection */ .Q(jodit);
    if (jodit.o.textIcons) {
        collection.container.classList.add('jodit_text_icons');
    }
    if (parentElement) {
        collection.parentElement = parentElement;
    }
    if (jodit.o.toolbarButtonSize) {
        collection.buttonSize = jodit.o.toolbarButtonSize;
    }
    return collection;
}
/**
 * Button factory
 */
function makeButton(jodit, control, target = null) {
    if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(control.getContent)) {
        return new _button_content__WEBPACK_IMPORTED_MODULE_2__/* .ToolbarContent */ .P(jodit, control, target);
    }
    const button = new _button_button__WEBPACK_IMPORTED_MODULE_1__/* .ToolbarButton */ .I(jodit, control, target);
    button.state.tabIndex = jodit.o.allowTabNavigation ? 0 : -1;
    return button;
}
function makeSelect(view, control, target = null) {
    return new _button_select_select__WEBPACK_IMPORTED_MODULE_3__/* .ToolbarSelect */ .q(view, control, target);
}


/***/ }),

/***/ 9103:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M553 1399l-50 50q-10 10-23 10t-23-10l-466-466q-10-10-10-23t10-23l466-466q10-10 23-10t23 10l50 50q10 10 10 23t-10 23l-393 393 393 393q10 10 10 23t-10 23zm591-1067l-373 1291q-4 13-15.5 19.5t-23.5 2.5l-62-17q-13-4-19.5-15.5t-2.5-24.5l373-1291q4-13 15.5-19.5t23.5-2.5l62 17q13 4 19.5 15.5t2.5 24.5zm657 651l-466 466q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l393-393-393-393q-10-10-10-23t10-23l50-50q10-10 23-10t23 10l466 466q10 10 10 23t-10 23z\"/> </svg>"

/***/ }),

/***/ 9443:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export fullsize */
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83044);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38322);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(70061);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





const fullsizeStack = new Set();
/**
 * Process `toggleFullSize` event, and behavior - set/unset fullsize mode
 */
function fullsize(editor) {
    editor.registerButton({
        name: 'fullsize'
    });
    let isEnabled = false, oldHeight = 0, oldWidth = 0, wasToggled = false;
    const resize = () => {
        const { container, events } = editor;
        if (!events) {
            return;
        }
        if (isEnabled) {
            oldHeight = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(container, 'height', true);
            oldWidth = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(container, 'width', true);
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(container, {
                height: editor.ow.innerHeight,
                width: editor.ow.innerWidth
            });
            wasToggled = true;
        }
        else if (wasToggled) {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(container, {
                height: oldHeight || 'auto',
                width: oldWidth || 'auto'
            });
        }
    }, 
    /**
     * Change editor's state between FullSize and normal
     */
    toggle = (enable) => {
        var _a;
        const { container, events } = editor;
        if (!container) {
            return;
        }
        if (enable === undefined) {
            enable = !container.classList.contains('jodit_fullsize');
        }
        editor.setMod('fullsize', enable);
        editor.o.fullsize = enable;
        isEnabled = enable;
        container.classList.toggle('jodit_fullsize', enable);
        if (editor.toolbar) {
            (0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_3__/* .isJoditObject */ .y)(editor) &&
                ((_a = editor.toolbarContainer) === null || _a === void 0 ? void 0 : _a.appendChild(editor.toolbar.container));
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(editor.toolbar.container, 'width', 'auto');
        }
        enable
            ? fullsizeStack.add(container)
            : fullsizeStack.delete(container);
        const shouldToggleGlobalFullsize = editor.o.globalFullSize &&
            ((fullsizeStack.size === 1 && enable) ||
                (fullsizeStack.size === 0 && !enable));
        if (shouldToggleGlobalFullsize) {
            let node = container.parentNode;
            while (node &&
                node.nodeType !== Node.DOCUMENT_NODE &&
                node.nodeType !== Node.DOCUMENT_FRAGMENT_NODE) {
                node.classList.toggle('jodit_fullsize-box_true', enable);
                node = node.parentNode;
            }
            resize();
        }
        events.fire('afterResize');
    };
    if (editor.o.globalFullSize) {
        editor.e.on(editor.ow, 'resize', resize);
    }
    editor.e
        .on('afterInit afterOpen', () => {
        var _a;
        editor.toggleFullSize((_a = editor === null || editor === void 0 ? void 0 : editor.options) === null || _a === void 0 ? void 0 : _a.fullsize);
    })
        .on('toggleFullSize', toggle)
        .on('beforeDestruct', () => {
        isEnabled && toggle(false);
    })
        .on('beforeDestruct', () => {
        editor.events && editor.e.off(editor.ow, 'resize', resize);
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_0__/* .pluginSystem */ .fg.add('fullsize', fullsize);


/***/ }),

/***/ 9645:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   G: function() { return /* binding */ normalSizeFromString; },
/* harmony export */   n: function() { return /* binding */ normalSizeToString; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_number__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2461);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/image-properties
 */


/** @private */
const normalSizeFromString = (value) => {
    return /^[-+]?[0-9.]+(px)?$/.test(value.toString())
        ? parseFloat(value.toString())
        : value;
};
/** @private */
const normalSizeToString = (value) => {
    if ((0,jodit_core_helpers_checker_is_number__WEBPACK_IMPORTED_MODULE_1__/* .isNumber */ .E)(value)) {
        return value ? value + 'px' : value.toString();
    }
    value = (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__/* .trim */ .Bq)(value);
    return /^[0-9]+$/.test(value) ? value + 'px' : value;
};


/***/ }),

/***/ 9810:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: function() { return /* binding */ isBoolean; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
function isBoolean(elm) {
    return typeof elm === 'boolean';
}


/***/ }),

/***/ 9823:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AH: function() { return /* reexport safe */ _is_html__WEBPACK_IMPORTED_MODULE_6__.A; },
/* harmony export */   Bo: function() { return /* reexport safe */ _is_string__WEBPACK_IMPORTED_MODULE_19__.B; },
/* harmony export */   CE: function() { return /* reexport safe */ _is_html_from_word__WEBPACK_IMPORTED_MODULE_7__.C; },
/* harmony export */   E6: function() { return /* reexport safe */ _is_int__WEBPACK_IMPORTED_MODULE_9__.E; },
/* harmony export */   Et: function() { return /* reexport safe */ _is_number__WEBPACK_IMPORTED_MODULE_14__.E; },
/* harmony export */   Gp: function() { return /* reexport safe */ _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__.n4; },
/* harmony export */   Kg: function() { return /* reexport safe */ _is_string__WEBPACK_IMPORTED_MODULE_19__.K; },
/* harmony export */   Lm: function() { return /* reexport safe */ _is_boolean__WEBPACK_IMPORTED_MODULE_3__.L; },
/* harmony export */   Mj: function() { return /* reexport safe */ _is_license__WEBPACK_IMPORTED_MODULE_11__.M; },
/* harmony export */   P5: function() { return /* reexport safe */ _is_equal__WEBPACK_IMPORTED_MODULE_4__.P; },
/* harmony export */   Qd: function() { return /* reexport safe */ _is_plain_object__WEBPACK_IMPORTED_MODULE_16__.Q; },
/* harmony export */   Rd: function() { return /* reexport safe */ _is_void__WEBPACK_IMPORTED_MODULE_23__.R; },
/* harmony export */   Tn: function() { return /* reexport safe */ _is_function__WEBPACK_IMPORTED_MODULE_5__.T; },
/* harmony export */   a3: function() { return /* reexport safe */ _is_native_function__WEBPACK_IMPORTED_MODULE_13__.a; },
/* harmony export */   cy: function() { return /* reexport safe */ _is_array__WEBPACK_IMPORTED_MODULE_2__.c; },
/* harmony export */   hH: function() { return /* reexport safe */ _is_view_object__WEBPACK_IMPORTED_MODULE_22__.h; },
/* harmony export */   kC: function() { return /* reexport safe */ _has_browser_color_picker__WEBPACK_IMPORTED_MODULE_0__.k; },
/* harmony export */   kO: function() { return /* reexport safe */ _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__.kO; },
/* harmony export */   kf: function() { return /* reexport safe */ _is_numeric__WEBPACK_IMPORTED_MODULE_15__.k; },
/* harmony export */   l6: function() { return /* reexport safe */ _is_window__WEBPACK_IMPORTED_MODULE_24__.l; },
/* harmony export */   mv: function() { return /* reexport safe */ _is_url__WEBPACK_IMPORTED_MODULE_20__.m; },
/* harmony export */   n4: function() { return /* reexport safe */ _is_equal__WEBPACK_IMPORTED_MODULE_4__.n; },
/* harmony export */   pV: function() { return /* reexport safe */ _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__.pV; },
/* harmony export */   rg: function() { return /* reexport safe */ _is_marker__WEBPACK_IMPORTED_MODULE_12__.r; },
/* harmony export */   uV: function() { return /* reexport safe */ _is_valid_name__WEBPACK_IMPORTED_MODULE_21__.u; },
/* harmony export */   vM: function() { return /* reexport safe */ _is_set__WEBPACK_IMPORTED_MODULE_18__.v; },
/* harmony export */   y0: function() { return /* reexport safe */ _is_jodit_object__WEBPACK_IMPORTED_MODULE_10__.y; },
/* harmony export */   yL: function() { return /* reexport safe */ _is_promise__WEBPACK_IMPORTED_MODULE_17__.y; },
/* harmony export */   zf: function() { return /* reexport safe */ _is_abort_error__WEBPACK_IMPORTED_MODULE_1__.z; }
/* harmony export */ });
/* harmony import */ var _has_browser_color_picker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(78479);
/* harmony import */ var _is_abort_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99951);
/* harmony import */ var _is_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(37923);
/* harmony import */ var _is_boolean__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9810);
/* harmony import */ var _is_equal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(69810);
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(69052);
/* harmony import */ var _is_html__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53701);
/* harmony import */ var _is_html_from_word__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(21811);
/* harmony import */ var _is_imp_interface__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(10058);
/* harmony import */ var _is_int__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(3947);
/* harmony import */ var _is_jodit_object__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(83044);
/* harmony import */ var _is_license__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(82201);
/* harmony import */ var _is_marker__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(71274);
/* harmony import */ var _is_native_function__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(34796);
/* harmony import */ var _is_number__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(2461);
/* harmony import */ var _is_numeric__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(12461);
/* harmony import */ var _is_plain_object__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(25376);
/* harmony import */ var _is_promise__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(92039);
/* harmony import */ var _is_set__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(53470);
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(98253);
/* harmony import */ var _is_url__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(6939);
/* harmony import */ var _is_valid_name__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(59082);
/* harmony import */ var _is_view_object__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(12041);
/* harmony import */ var _is_void__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(35642);
/* harmony import */ var _is_window__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(76776);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */



























/***/ }),

/***/ 9979:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   f: function() { return /* binding */ loadItems; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Loads a list of files and adds them to the state
 * @private
 */
function loadItems(fb) {
    fb.files.setMod('active', true);
    fb.files.setMod('loading', true);
    return fb.dataProvider
        .items(fb.state.currentPath, fb.state.currentSource, {
        sortBy: fb.state.sortBy,
        onlyImages: fb.state.onlyImages,
        filterWord: fb.state.filterWord
    })
        .then(resp => {
        if (resp) {
            fb.state.elements = resp;
            fb.state.activeElements = [];
        }
    })
        .catch(fb.status)
        .finally(() => fb.files.setMod('loading', false));
}


/***/ }),

/***/ 10004:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ defaultNameSpace; },
/* harmony export */   d: function() { return /* binding */ EventHandlersStore; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42448);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


const defaultNameSpace = 'JoditEventDefaultNamespace';
class EventHandlersStore {
    constructor() {
        this.__store = new Map();
    }
    get(event, namespace) {
        if (this.__store.has(namespace)) {
            const ns = this.__store.get(namespace);
            void 0;
            return ns[event];
        }
    }
    indexOf(event, namespace, originalCallback) {
        const blocks = this.get(event, namespace);
        if (blocks) {
            for (let i = 0; i < blocks.length; i += 1) {
                if (blocks[i].originalCallback === originalCallback) {
                    return i;
                }
            }
        }
        return false;
    }
    namespaces(withoutDefault = false) {
        const nss = (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_0__/* .toArray */ .$)(this.__store.keys());
        return withoutDefault ? nss.filter(ns => ns !== defaultNameSpace) : nss;
    }
    events(namespace) {
        const ns = this.__store.get(namespace);
        return ns ? Object.keys(ns) : [];
    }
    set(event, namespace, data, onTop = false) {
        let ns = this.__store.get(namespace);
        if (!ns) {
            ns = {};
            this.__store.set(namespace, ns);
        }
        if (ns[event] === undefined) {
            ns[event] = [];
        }
        if (!onTop) {
            ns[event].push(data);
        }
        else {
            ns[event].unshift(data);
        }
    }
    clear() {
        this.__store.clear();
    }
    clearEvents(namespace, event) {
        const ns = this.__store.get(namespace);
        if (ns && ns[event]) {
            delete ns[event];
            if (!Object.keys(ns).length) {
                this.__store.delete(namespace);
            }
        }
    }
    isEmpty() {
        return this.__store.size === 0;
    }
}


/***/ }),

/***/ 10025:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   H: function() { return /* binding */ nl2br; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */
/**
 *  Inserts HTML line breaks before all newlines in a string
 */
function nl2br(html) {
    return html.replace(/\r\n|\r|\n/g, '<br/>');
}


/***/ }),

/***/ 10058:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   kO: function() { return /* binding */ hasContainer; },
/* harmony export */   n4: function() { return /* binding */ isInitable; },
/* harmony export */   pV: function() { return /* binding */ isDestructable; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69052);
/* harmony import */ var _is_void__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(35642);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Check value has method init
 */
function isInitable(value) {
    return !(0,_is_void__WEBPACK_IMPORTED_MODULE_1__/* .isVoid */ .R)(value) && (0,_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(value.init);
}
/**
 * Check value has method destruct
 */
function isDestructable(value) {
    return !(0,_is_void__WEBPACK_IMPORTED_MODULE_1__/* .isVoid */ .R)(value) && (0,_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(value.destruct);
}
/**
 * Check value is instant that implements IContainer
 */
function hasContainer(value) {
    return !(0,_is_void__WEBPACK_IMPORTED_MODULE_1__/* .isVoid */ .R)(value) && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(value.container);
}


/***/ }),

/***/ 10067:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ FileSelectorWidget; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53048);
/* harmony import */ var jodit_modules_widget_tabs_tabs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4909);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Generate 3 tabs
 * upload - Use Drag and Drop
 * url - By specifying the image url
 * filebrowser - After opening the file browser. In the absence of one of the parameters will be less tabs
 *
 * @param callbacks - Object with keys `url`, `upload` and `filebrowser`, values which are callback
 * functions with different parameters
 */
const FileSelectorWidget = (editor, callbacks, elm, close, isImage = true) => {
    let currentImage;
    const tabs = [];
    if (callbacks.upload &&
        editor.o.uploader &&
        (editor.o.uploader.url || editor.o.uploader.insertImageAsBase64URI)) {
        const dragBox = editor.c.fromHTML('<div class="jodit-drag-and-drop__file-box">' +
            `<strong>${editor.i18n(isImage ? 'Drop image' : 'Drop file')}</strong>` +
            `<span><br>${editor.i18n('or click')}</span>` +
            `<input type="file" accept="${isImage ? 'image/*' : '*'}" tabindex="-1" dir="auto" multiple=""/>` +
            '</div>');
        editor.uploader.bind(dragBox, resp => {
            const handler = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(callbacks.upload)
                ? callbacks.upload
                : editor.o.uploader.defaultHandlerSuccess;
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(handler)) {
                handler.call(editor, resp);
            }
            editor.e.fire('closeAllPopups');
        }, error => {
            editor.message.error(error.message);
            editor.e.fire('closeAllPopups');
        });
        tabs.push({
            icon: 'upload',
            name: 'Upload',
            content: dragBox
        });
    }
    if (callbacks.filebrowser) {
        if (editor.o.filebrowser.ajax.url || editor.o.filebrowser.items.url) {
            tabs.push({
                icon: 'folder',
                name: 'Browse',
                content: () => {
                    close && close();
                    if (callbacks.filebrowser) {
                        editor.filebrowser.open(callbacks.filebrowser, isImage);
                    }
                }
            });
        }
    }
    if (callbacks.url) {
        const button = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIButton */ .lD(editor, {
            type: 'submit',
            variant: 'primary',
            text: 'Insert'
        }), form = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIForm */ .XV(editor, [
            new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .tS(editor, {
                required: true,
                label: 'URL',
                name: 'url',
                type: 'text',
                placeholder: 'https://'
            }),
            new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .tS(editor, {
                name: 'text',
                label: 'Alternative text'
            }),
            new jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .UIBlock */ .Yh(editor, [button])
        ]);
        currentImage = null;
        if (elm &&
            !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isText(elm) &&
            !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isComment(elm) &&
            (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, 'img') || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.$$)('img', elm).length)) {
            currentImage = elm.tagName === 'IMG' ? elm : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.$$)('img', elm)[0];
            val(form.container, 'input[name=url]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(currentImage, 'src'));
            val(form.container, 'input[name=text]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(currentImage, 'alt'));
            button.state.text = 'Update';
        }
        if (elm && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, 'a')) {
            val(form.container, 'input[name=url]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'href'));
            val(form.container, 'input[name=text]', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'title'));
            button.state.text = 'Update';
        }
        form.onSubmit(data => {
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isFunction)(callbacks.url)) {
                callbacks.url.call(editor, data.url, data.text);
            }
        });
        tabs.push({
            icon: 'link',
            name: 'URL',
            content: form.container
        });
    }
    return (0,jodit_modules_widget_tabs_tabs__WEBPACK_IMPORTED_MODULE_3__/* .TabsWidget */ .Z)(editor, tabs);
};
function val(elm, selector, value) {
    const child = elm.querySelector(selector);
    if (!child) {
        return '';
    }
    if (value) {
        child.value = value;
    }
    return child.value;
}


/***/ }),

/***/ 10274:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Q: function() { return /* reexport safe */ _files_files__WEBPACK_IMPORTED_MODULE_0__.Q; },
/* harmony export */   V: function() { return /* reexport safe */ _tree_tree__WEBPACK_IMPORTED_MODULE_1__.V; }
/* harmony export */ });
/* harmony import */ var _files_files__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(96025);
/* harmony import */ var _tree_tree__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(73307);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module modules/file-browser
 */




/***/ }),

/***/ 10466:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: function() { return /* binding */ FiniteStateMachine; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_1__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * A state machine implementation for applying styles.
 */
class FiniteStateMachine {
    setState(state) {
        void 0;
        this.__previewsStates.add(state);
        this.__state = state;
    }
    getState() {
        return this.__state;
    }
    disableSilent() {
        this.silent = false;
    }
    constructor(state, transitions) {
        this.transitions = transitions;
        this.silent = true;
        this.__previewsStates = new Set();
        this.setState(state);
    }
    dispatch(actionName, value) {
        const action = this.transitions[this.getState()][actionName];
        if (action) {
            const res = action.call(this, value);
            void 0;
            void 0;
            void 0;
            this.setState(res.next);
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && !this.silent) {
                // eslint-disable-next-line no-console
                console.log(`State: ${this.getState()}`);
            }
            return res;
        }
        throw new Error(`invalid action: ${this.getState()}.${actionName.toString()}`);
    }
}


/***/ }),

/***/ 10467:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ ucfirst; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/string
 */
/**
 * Make a string's first character uppercase
 */
function ucfirst(value) {
    if (!value.length) {
        return '';
    }
    return value[0].toUpperCase() + value.substring(1);
}


/***/ }),

/***/ 10494:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   O: function() { return /* binding */ ApplyStyle; }
/* harmony export */ });
/* harmony import */ var _api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97621);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12043);
/* harmony import */ var _transactions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37649);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/** @internal */
function ApplyStyle(jodit, cs) {
    var _a;
    const { s: sel, editor } = jodit;
    // sel.save();
    (_a = editor.firstChild) === null || _a === void 0 ? void 0 : _a.normalize(); // FF fix for test "commandsTest - Exec command "bold"
    const fakes = sel.fakes();
    const gen = jodit.s.wrapInTagGen(fakes);
    let font = gen.next();
    if (font.done) {
        return;
    }
    let state = {
        collapsed: sel.isCollapsed(),
        mode: _constants__WEBPACK_IMPORTED_MODULE_2__/* .INITIAL */ .DI,
        element: font.value,
        next: _transactions__WEBPACK_IMPORTED_MODULE_1__/* .states */ .x.START,
        jodit,
        style: cs
    };
    while (font && !font.done) {
        const machine = new _api__WEBPACK_IMPORTED_MODULE_0__/* .FiniteStateMachine */ .EF(_transactions__WEBPACK_IMPORTED_MODULE_1__/* .states */ .x.START, _transactions__WEBPACK_IMPORTED_MODULE_1__/* .transactions */ .g);
        state.element = font.value;
        // machine.disableSilent();
        while (machine.getState() !== _transactions__WEBPACK_IMPORTED_MODULE_1__/* .states */ .x.END) {
            // console.log(machine.getState(), state);
            state = machine.dispatch('exec', state);
        }
        // console.log('-------------------');
        font = gen.next();
    }
    // sel.restore();
    sel.restoreFakes(fakes);
}


/***/ }),

/***/ 11095:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'copy-format': 'Format kopierenт'
};


/***/ }),

/***/ 11133:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ FileBrowserItem; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

class FileBrowserItem {
    constructor(data) {
        this.data = data;
        // TODO Check with Object.assign
        Object.keys(data).forEach(key => {
            this[key] = data[key];
        });
    }
    static create(data) {
        if (data instanceof FileBrowserItem) {
            return data;
        }
        return new FileBrowserItem(data);
    }
    get path() {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(this.data.source.path ? this.data.source.path + '/' : '/');
    }
    get imageURL() {
        const timestamp = this.time || new Date().getTime().toString(), { thumbIsAbsolute, source, thumb, file } = this.data, path = thumb || file;
        return thumbIsAbsolute && path
            ? path
            : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.normalizeUrl)(source.baseurl, source.path, path || '') +
                '?_tmst=' +
                encodeURIComponent(timestamp);
    }
    get fileURL() {
        let { name } = this.data;
        const { file, fileIsAbsolute, source } = this.data;
        if (file !== undefined) {
            name = file;
        }
        return fileIsAbsolute && name
            ? name
            : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.normalizeUrl)(source.baseurl, source.path, name || '');
    }
    get time() {
        const { changed } = this.data;
        return ((changed &&
            (typeof changed === 'number'
                ? new Date(changed).toLocaleString()
                : changed)) ||
            '');
    }
    get uniqueHashKey() {
        const data = this.data;
        let key = [
            data.sourceName,
            data.name,
            data.file,
            this.time,
            data.thumb
        ].join('_');
        key = key.toLowerCase().replace(/[^0-9a-z\-.]/g, '-');
        return key;
    }
    toJSON() {
        return this.data;
    }
}


/***/ }),

/***/ 11395:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'copy-format': 'Formátum másolás'
};


/***/ }),

/***/ 11648:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ Table; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65147);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







const markedValue = new WeakMap();
class Table extends jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    constructor() {
        super(...arguments);
        this.selected = new Set();
    }
    /** @override */
    className() {
        return 'Table';
    }
    __recalculateStyles() {
        const style = (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_4__/* .getContainer */ .My)(this.j, Table, 'style', true);
        const selectors = [];
        this.selected.forEach(td => {
            const selector = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.cssPath)(td);
            selector && selectors.push(selector);
        });
        style.innerHTML = selectors.length
            ? selectors.join(',') +
                `{${this.jodit.options.table.selectionCellStyle}}`
            : '';
    }
    addSelection(td) {
        this.selected.add(td);
        this.__recalculateStyles();
        const table = jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.closest(td, 'table', this.j.editor);
        if (table) {
            const cells = Table.__selectedByTable.get(table) || new Set();
            cells.add(td);
            Table.__selectedByTable.set(table, cells);
        }
    }
    removeSelection(td) {
        this.selected.delete(td);
        this.__recalculateStyles();
        const table = jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.closest(td, 'table', this.j.editor);
        if (table) {
            const cells = Table.__selectedByTable.get(table);
            if (cells) {
                cells.delete(td);
                if (!cells.size) {
                    Table.__selectedByTable.delete(table);
                }
            }
        }
    }
    /**
     * Returns array of selected cells
     */
    getAllSelectedCells() {
        return (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(this.selected);
    }
    static __getSelectedCellsByTable(table) {
        const cells = Table.__selectedByTable.get(table);
        return cells ? (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(cells) : [];
    }
    /** @override **/
    destruct() {
        this.selected.clear();
        return super.destruct();
    }
    static __getRowsCount(table) {
        return table.rows.length;
    }
    /**
     * Returns rows count in the table
     */
    getRowsCount(table) {
        return Table.__getRowsCount(table);
    }
    static __getColumnsCount(table) {
        const matrix = Table.__formalMatrix(table);
        return matrix.reduce((max_count, cells) => Math.max(max_count, cells.length), 0);
    }
    /**
     * Returns columns count in the table
     */
    getColumnsCount(table) {
        return Table.__getColumnsCount(table);
    }
    static __formalMatrix(table, callback) {
        const matrix = [[]];
        const rows = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(table.rows);
        const setCell = (cell, i) => {
            if (matrix[i] === undefined) {
                matrix[i] = [];
            }
            const colSpan = cell.colSpan, rowSpan = cell.rowSpan;
            let column, row, currentColumn = 0;
            while (matrix[i][currentColumn]) {
                currentColumn += 1;
            }
            for (row = 0; row < rowSpan; row += 1) {
                for (column = 0; column < colSpan; column += 1) {
                    if (matrix[i + row] === undefined) {
                        matrix[i + row] = [];
                    }
                    if (callback &&
                        callback(cell, i + row, currentColumn + column, colSpan, rowSpan) === false) {
                        return false;
                    }
                    matrix[i + row][currentColumn + column] = cell;
                }
            }
        };
        for (let i = 0; i < rows.length; i += 1) {
            const cells = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(rows[i].cells);
            for (let j = 0; j < cells.length; j += 1) {
                if (setCell(cells[j], i) === false) {
                    return matrix;
                }
            }
        }
        return matrix;
    }
    /**
     * Generate formal table martix columns*rows
     * @param table - Working table
     * @param callback - if return false cycle break
     */
    formalMatrix(table, callback) {
        return Table.__formalMatrix(table, callback);
    }
    static __formalCoordinate(table, cell, max = false) {
        let i = 0, j = 0, width = 1, height = 1;
        Table.__formalMatrix(table, (td, ii, jj, colSpan, rowSpan) => {
            if (cell === td) {
                i = ii;
                j = jj;
                width = colSpan || 1;
                height = rowSpan || 1;
                if (max) {
                    j += (colSpan || 1) - 1;
                    i += (rowSpan || 1) - 1;
                }
                return false;
            }
        });
        return [i, j, width, height];
    }
    /**
     * Get cell coordinate in formal table (without colspan and rowspan)
     */
    formalCoordinate(table, cell, max = false) {
        return Table.__formalCoordinate(table, cell, max);
    }
    static __appendRow(table, line, after, create) {
        var _a;
        let row;
        if (!line) {
            const columnsCount = Table.__getColumnsCount(table);
            row = create.element('tr');
            for (let j = 0; j < columnsCount; j += 1) {
                row.appendChild(create.element('td'));
            }
        }
        else {
            row = line.cloneNode(true);
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.$$)('td,th', line).forEach(cell => {
                const rowspan = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'rowspan');
                if (rowspan && parseInt(rowspan, 10) > 1) {
                    const newRowSpan = parseInt(rowspan, 10) - 1;
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'rowspan', newRowSpan > 1 ? newRowSpan : null);
                }
            });
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.$$)('td,th', row).forEach(cell => {
                cell.innerHTML = '';
            });
        }
        if (after && line && line.nextSibling) {
            line.parentNode &&
                line.parentNode.insertBefore(row, line.nextSibling);
        }
        else if (!after && line) {
            line.parentNode && line.parentNode.insertBefore(row, line);
        }
        else {
            (((_a = table.getElementsByTagName('tbody')) === null || _a === void 0 ? void 0 : _a[0]) || table).appendChild(row);
        }
    }
    /**
     * Inserts a new line after row what contains the selected cell
     *
     * @param table - Working table
     * @param line - Insert a new line after/before this
     * line contains the selected cell
     * @param after - Insert a new line after line contains the selected cell
     */
    appendRow(table, line, after) {
        return Table.__appendRow(table, line, after, this.j.createInside);
    }
    static __removeRow(table, rowIndex) {
        const box = Table.__formalMatrix(table);
        let dec;
        const row = table.rows[rowIndex];
        box[rowIndex].forEach((cell, j) => {
            dec = false;
            if (rowIndex - 1 >= 0 && box[rowIndex - 1][j] === cell) {
                dec = true;
            }
            else if (box[rowIndex + 1] && box[rowIndex + 1][j] === cell) {
                if (cell.parentNode === row && cell.parentNode.nextSibling) {
                    dec = true;
                    let nextCell = j + 1;
                    while (box[rowIndex + 1][nextCell] === cell) {
                        nextCell += 1;
                    }
                    const nextRow = jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.next(cell.parentNode, elm => jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.isTag(elm, 'tr'), table);
                    if (nextRow) {
                        if (box[rowIndex + 1][nextCell]) {
                            nextRow.insertBefore(cell, box[rowIndex + 1][nextCell]);
                        }
                        else {
                            nextRow.appendChild(cell);
                        }
                    }
                }
            }
            else {
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(cell);
            }
            if (dec &&
                (cell.parentNode === row || cell !== box[rowIndex][j - 1])) {
                const rowSpan = cell.rowSpan;
                (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'rowspan', rowSpan - 1 > 1 ? rowSpan - 1 : null);
            }
        });
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(row);
    }
    /**
     * Remove row
     */
    removeRow(table, rowIndex) {
        return Table.__removeRow(table, rowIndex);
    }
    /**
     * Insert column before / after all the columns containing the selected cells
     */
    appendColumn(table, selectedCell, insertAfter = true) {
        const box = Table.__formalMatrix(table);
        if (!insertAfter && jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.isCell(selectedCell.previousElementSibling)) {
            return this.appendColumn(table, selectedCell.previousElementSibling, true);
        }
        const columnIndex = insertAfter
            ? selectedCell.cellIndex + ((selectedCell.colSpan || 1) - 1)
            : selectedCell.cellIndex;
        const newColumnIndex = insertAfter ? columnIndex + 1 : columnIndex;
        for (let i = 0; i < box.length;) {
            const cells = box[i];
            if (cells[columnIndex] !== cells[newColumnIndex] ||
                columnIndex === newColumnIndex) {
                const cell = this.j.createInside.element('td');
                if (insertAfter) {
                    jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.after(cells[columnIndex], cell);
                }
                else {
                    jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.before(cells[columnIndex], cell);
                }
                if (cells[columnIndex].rowSpan > 1) {
                    cell.rowSpan = cells[columnIndex].rowSpan;
                }
            }
            else {
                cells[columnIndex].colSpan += 1;
            }
            i += cells[columnIndex].rowSpan || 1;
        }
    }
    static __removeColumn(table, j) {
        const box = Table.__formalMatrix(table);
        let dec;
        box.forEach((cells, i) => {
            const td = cells[j];
            dec = false;
            if (j - 1 >= 0 && box[i][j - 1] === td) {
                dec = true;
            }
            else if (j + 1 < cells.length && box[i][j + 1] === td) {
                dec = true;
            }
            else {
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(td);
            }
            if (dec && (i - 1 < 0 || td !== box[i - 1][j])) {
                const colSpan = td.colSpan;
                (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(td, 'colspan', colSpan - 1 > 1 ? (colSpan - 1).toString() : null);
            }
        });
    }
    /**
     * Remove column by index
     */
    removeColumn(table, j) {
        return Table.__removeColumn(table, j);
    }
    static __getSelectedBound(table, selectedCells) {
        const bound = [
            [Infinity, Infinity],
            [0, 0]
        ];
        const box = Table.__formalMatrix(table);
        let i, j, k;
        for (i = 0; i < box.length; i += 1) {
            for (j = 0; box[i] && j < box[i].length; j += 1) {
                if (selectedCells.includes(box[i][j])) {
                    bound[0][0] = Math.min(i, bound[0][0]);
                    bound[0][1] = Math.min(j, bound[0][1]);
                    bound[1][0] = Math.max(i, bound[1][0]);
                    bound[1][1] = Math.max(j, bound[1][1]);
                }
            }
        }
        for (i = bound[0][0]; i <= bound[1][0]; i += 1) {
            for (k = 1, j = bound[0][1]; j <= bound[1][1]; j += 1) {
                while (box[i] && box[i][j - k] && box[i][j] === box[i][j - k]) {
                    bound[0][1] = Math.min(j - k, bound[0][1]);
                    bound[1][1] = Math.max(j - k, bound[1][1]);
                    k += 1;
                }
                k = 1;
                while (box[i] && box[i][j + k] && box[i][j] === box[i][j + k]) {
                    bound[0][1] = Math.min(j + k, bound[0][1]);
                    bound[1][1] = Math.max(j + k, bound[1][1]);
                    k += 1;
                }
                k = 1;
                while (box[i - k] && box[i][j] === box[i - k][j]) {
                    bound[0][0] = Math.min(i - k, bound[0][0]);
                    bound[1][0] = Math.max(i - k, bound[1][0]);
                    k += 1;
                }
                k = 1;
                while (box[i + k] && box[i][j] === box[i + k][j]) {
                    bound[0][0] = Math.min(i + k, bound[0][0]);
                    bound[1][0] = Math.max(i + k, bound[1][0]);
                    k += 1;
                }
            }
        }
        return bound;
    }
    /**
     * Define bound for selected cells
     */
    getSelectedBound(table, selectedCells) {
        return Table.__getSelectedBound(table, selectedCells);
    }
    static __normalizeTable(table) {
        const __marked = [], box = Table.__formalMatrix(table);
        Table.__removeExtraColspans(box, __marked);
        Table.__removeExtraRowspans(box, __marked);
        // remove rowspans and colspans equal 1 and empty class
        for (let i = 0; i < box.length; i += 1) {
            for (let j = 0; j < box[i].length; j += 1) {
                if (box[i][j] === undefined) {
                    continue; // broken table
                }
                if (box[i][j].hasAttribute('rowspan') &&
                    box[i][j].rowSpan === 1) {
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'rowspan', null);
                }
                if (box[i][j].hasAttribute('colspan') &&
                    box[i][j].colSpan === 1) {
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'colspan', null);
                }
                if (box[i][j].hasAttribute('class') &&
                    !(0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'class')) {
                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(box[i][j], 'class', null);
                }
            }
        }
        Table.__unmark(__marked);
    }
    static __removeExtraColspans(box, __marked) {
        for (let j = 0; j < box[0].length; j += 1) {
            let min = 1000000;
            let not = false;
            for (let i = 0; i < box.length; i += 1) {
                if (box[i][j] === undefined) {
                    continue; // broken table
                }
                if (box[i][j].colSpan < 2) {
                    not = true;
                    break;
                }
                min = Math.min(min, box[i][j].colSpan);
            }
            if (!not) {
                for (let i = 0; i < box.length; i += 1) {
                    if (box[i][j] === undefined) {
                        continue; // broken table
                    }
                    Table.__mark(box[i][j], 'colspan', box[i][j].colSpan - min + 1, __marked);
                }
            }
        }
    }
    static __removeExtraRowspans(box, marked) {
        let i = 0;
        let j = 0;
        for (i = 0; i < box.length; i += 1) {
            let min = 1000000;
            let not = false;
            for (j = 0; j < box[i].length; j += 1) {
                if (box[i][j] === undefined) {
                    continue; // broken table
                }
                if (box[i][j].rowSpan < 2) {
                    not = true;
                    break;
                }
                min = Math.min(min, box[i][j].rowSpan);
            }
            if (!not) {
                for (j = 0; j < box[i].length; j += 1) {
                    if (box[i][j] === undefined) {
                        continue; // broken table
                    }
                    Table.__mark(box[i][j], 'rowspan', box[i][j].rowSpan - min + 1, marked);
                }
            }
        }
    }
    /**
     * Try recalculate all coluns and rows after change
     */
    normalizeTable(table) {
        return Table.__normalizeTable(table);
    }
    static __mergeSelected(table, jodit) {
        const html = [], bound = Table.__getSelectedBound(table, Table.__getSelectedCellsByTable(table));
        let w = 0, first = null, first_j = 0, td, cols = 0, rows = 0;
        const alreadyMerged = new Set(), __marked = [];
        if (bound && (bound[0][0] - bound[1][0] || bound[0][1] - bound[1][1])) {
            Table.__formalMatrix(table, (cell, i, j, cs, rs) => {
                if (i >= bound[0][0] && i <= bound[1][0]) {
                    if (j >= bound[0][1] && j <= bound[1][1]) {
                        td = cell;
                        if (alreadyMerged.has(td)) {
                            return;
                        }
                        alreadyMerged.add(td);
                        if (i === bound[0][0] && td.style.width) {
                            w += td.offsetWidth;
                        }
                        if ((0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.trim)(cell.innerHTML.replace(/<br(\/)?>/g, '')) !== '') {
                            html.push(cell.innerHTML);
                        }
                        if (cs > 1) {
                            cols += cs - 1;
                        }
                        if (rs > 1) {
                            rows += rs - 1;
                        }
                        if (!first) {
                            first = cell;
                            first_j = j;
                        }
                        else {
                            Table.__mark(td, 'remove', 1, __marked);
                            instance(jodit).removeSelection(td);
                        }
                    }
                }
            });
            cols = bound[1][1] - bound[0][1] + 1;
            rows = bound[1][0] - bound[0][0] + 1;
            if (first) {
                if (cols > 1) {
                    Table.__mark(first, 'colspan', cols, __marked);
                }
                if (rows > 1) {
                    Table.__mark(first, 'rowspan', rows, __marked);
                }
                if (w) {
                    Table.__mark(first, 'width', ((w / table.offsetWidth) * 100).toFixed(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.ACCURACY) + '%', __marked);
                    if (first_j) {
                        Table.__setColumnWidthByDelta(table, first_j, 0, true, __marked);
                    }
                }
                first.innerHTML = html.join('<br/>');
                instance(jodit).addSelection(first);
                alreadyMerged.delete(first);
                Table.__unmark(__marked);
                Table.__normalizeTable(table);
                (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.toArray)(table.rows).forEach(tr => {
                    if (!tr.cells.length) {
                        jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(tr);
                    }
                });
            }
        }
    }
    /**
     * It combines all the selected cells into one. The contents of the cells will also be combined
     */
    mergeSelected(table) {
        return Table.__mergeSelected(table, this.j);
    }
    static __splitHorizontal(table, jodit) {
        let coord, td, tr, parent, after;
        const __marked = [];
        Table.__getSelectedCellsByTable(table).forEach((cell) => {
            td = jodit.createInside.element('td');
            td.appendChild(jodit.createInside.element('br'));
            tr = jodit.createInside.element('tr');
            coord = Table.__formalCoordinate(table, cell);
            if (cell.rowSpan < 2) {
                Table.__formalMatrix(table, (tdElm, i, j) => {
                    if (coord[0] === i &&
                        coord[1] !== j &&
                        tdElm !== cell) {
                        Table.__mark(tdElm, 'rowspan', tdElm.rowSpan + 1, __marked);
                    }
                });
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.after(jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.closest(cell, 'tr', table), tr);
                tr.appendChild(td);
            }
            else {
                Table.__mark(cell, 'rowspan', cell.rowSpan - 1, __marked);
                Table.__formalMatrix(table, (tdElm, i, j) => {
                    if (i > coord[0] &&
                        i < coord[0] + cell.rowSpan &&
                        coord[1] > j &&
                        tdElm.parentNode
                            .rowIndex === i) {
                        after = tdElm;
                    }
                    if (coord[0] < i && tdElm === cell) {
                        parent = table.rows[i];
                    }
                });
                if (after) {
                    jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.after(after, td);
                }
                else {
                    parent.insertBefore(td, parent.firstChild);
                }
            }
            if (cell.colSpan > 1) {
                Table.__mark(td, 'colspan', cell.colSpan, __marked);
            }
            Table.__unmark(__marked);
            instance(jodit).removeSelection(cell);
        });
        this.__normalizeTable(table);
    }
    /**
     * Divides all selected by `jodit_focused_cell` class table cell in 2 parts vertical. Those division into 2 columns
     */
    splitHorizontal(table) {
        return Table.__splitHorizontal(table, this.j);
    }
    static __splitVertical(table, jodit) {
        let coord, td, percentage;
        const __marked = [];
        Table.__getSelectedCellsByTable(table).forEach(cell => {
            coord = Table.__formalCoordinate(table, cell);
            if (cell.colSpan < 2) {
                Table.__formalMatrix(table, (tdElm, i, j) => {
                    if (coord[1] === j && coord[0] !== i && tdElm !== cell) {
                        Table.__mark(tdElm, 'colspan', tdElm.colSpan + 1, __marked);
                    }
                });
            }
            else {
                Table.__mark(cell, 'colspan', cell.colSpan - 1, __marked);
            }
            td = jodit.createInside.element('td');
            td.appendChild(jodit.createInside.element('br'));
            if (cell.rowSpan > 1) {
                Table.__mark(td, 'rowspan', cell.rowSpan, __marked);
            }
            const oldWidth = cell.offsetWidth; // get old width
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.after(cell, td);
            percentage = oldWidth / table.offsetWidth / 2;
            Table.__mark(cell, 'width', (percentage * 100).toFixed(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.ACCURACY) + '%', __marked);
            Table.__mark(td, 'width', (percentage * 100).toFixed(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.ACCURACY) + '%', __marked);
            Table.__unmark(__marked);
            instance(jodit).removeSelection(cell);
        });
        Table.__normalizeTable(table);
    }
    /**
     * It splits all the selected cells into 2 parts horizontally. Those. are added new row
     */
    splitVertical(table) {
        return Table.__splitVertical(table, this.j);
    }
    static __setColumnWidthByDelta(table, column, delta, noUnmark, marked) {
        const box = Table.__formalMatrix(table);
        let clearWidthIndex = 0;
        for (let i = 0; i < box.length; i += 1) {
            const cell = box[i][column];
            if (cell.colSpan > 1 && box.length > 1) {
                continue;
            }
            const w = cell.offsetWidth;
            const percent = ((w + delta) / table.offsetWidth) * 100;
            Table.__mark(cell, 'width', percent.toFixed(jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.ACCURACY) + '%', marked);
            clearWidthIndex = i;
            break;
        }
        for (let i = clearWidthIndex + 1; i < box.length; i += 1) {
            const cell = box[i][column];
            Table.__mark(cell, 'width', null, marked);
        }
        if (!noUnmark) {
            Table.__unmark(marked);
        }
    }
    /**
     * Set column width used delta value
     */
    setColumnWidthByDelta(table, column, delta, noUnmark, marked) {
        return Table.__setColumnWidthByDelta(table, column, delta, noUnmark, marked);
    }
    static __mark(cell, key, value, marked) {
        var _a;
        marked.push(cell);
        const dict = (_a = markedValue.get(cell)) !== null && _a !== void 0 ? _a : {};
        dict[key] = value === undefined ? 1 : value;
        markedValue.set(cell, dict);
    }
    static __unmark(marked) {
        marked.forEach(cell => {
            const dict = markedValue.get(cell);
            if (dict) {
                Object.keys(dict).forEach((key) => {
                    const value = dict[key];
                    switch (key) {
                        case 'remove':
                            jodit_core_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(cell);
                            break;
                        case 'rowspan':
                            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'rowspan', (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.isNumber)(value) && value > 1 ? value : null);
                            break;
                        case 'colspan':
                            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'colspan', (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.isNumber)(value) && value > 1 ? value : null);
                            break;
                        case 'width':
                            if (value == null) {
                                cell.style.removeProperty('width');
                                if (!(0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'style')) {
                                    (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_5__.attr)(cell, 'style', null);
                                }
                            }
                            else {
                                cell.style.width = value.toString();
                            }
                            break;
                    }
                    delete dict[key];
                });
                markedValue.delete(cell);
            }
        });
    }
}
Table.__selectedByTable = new WeakMap();
(0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.debounce)()
], Table.prototype, "__recalculateStyles", null);
const instance = (j) => j.getInstance('Table', j.o);


/***/ }),

/***/ 11961:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: function() { return /* reexport safe */ autobind_decorator__WEBPACK_IMPORTED_MODULE_0__.Ay; }
/* harmony export */ });
/* harmony import */ var autobind_decorator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(52201);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/decorators/autobind/README.md]]
 * @packageDocumentation
 * @module decorators/autobind
 */



/***/ }),

/***/ 12041:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ isViewObject; }
/* harmony export */ });
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(69052);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Check if an element is instance of View
 */
function isViewObject(jodit) {
    return Boolean(jodit &&
        jodit instanceof Object &&
        (0,_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(jodit.constructor) &&
        jodit.isView);
}


/***/ }),

/***/ 12043:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ag: function() { return /* binding */ UNSET; },
/* harmony export */   DI: function() { return /* binding */ INITIAL; },
/* harmony export */   OJ: function() { return /* binding */ UNWRAP; },
/* harmony export */   PL: function() { return /* binding */ CHANGE; },
/* harmony export */   Zk: function() { return /* binding */ WRAP; },
/* harmony export */   ar: function() { return /* binding */ _PREFIX; },
/* harmony export */   dj: function() { return /* binding */ REPLACE; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module selection
 */
/** @internal */
const WRAP = 'wrap';
/** @internal */
const UNWRAP = 'unwrap';
/** @internal */
const CHANGE = 'change';
/** @internal */
const UNSET = 'unset';
/** @internal */
const INITIAL = 'initial';
/** @internal */
const REPLACE = 'replace';
/** @internal */
const _PREFIX = 'commitStyle';


/***/ }),

/***/ 12461:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ isNumeric; }
/* harmony export */ });
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */

/**
 * Check value has numeric format
 */
function isNumeric(value) {
    if ((0,_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(value)) {
        if (!value.match(/^([+-])?[0-9]+(\.?)([0-9]+)?(e[0-9]+)?$/)) {
            return false;
        }
        value = parseFloat(value);
    }
    return typeof value === 'number' && !isNaN(value) && isFinite(value);
}


/***/ }),

/***/ 13265:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* binding */ normalizeRelativePath; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */
const normalizeRelativePath = (path) => {
    const sections = path.split('/'), builder = sections.reduce((builder, section) => {
        switch (section) {
            case '': {
                break;
            }
            case '.': {
                break;
            }
            case '..': {
                builder.pop();
                break;
            }
            default: {
                builder.push(section);
                break;
            }
        }
        return builder;
    }, []);
    return builder.join('/') + (path.endsWith('/') ? '/' : '');
};


/***/ }),

/***/ 13405:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export enter */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9810);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29866);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(81781);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









/**
 * One of most important core plugins. It is responsible for all the browsers to have the same effect when the Enter
 * button is pressed. By default, it should insert the <p>
 */
class enter extends jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k {
    /** @override */
    afterInit(editor) {
        // use 'enter' option if no set
        const defaultTag = editor.o.enter.toLowerCase();
        const brMode = defaultTag === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.BR.toLowerCase();
        if (!editor.o.enterBlock) {
            editor.o.enterBlock = brMode
                ? jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.PARAGRAPH
                : defaultTag;
        }
        editor.registerCommand('enter', (command, value, event = {}) => this.onEnter(event));
    }
    onEnterKeyDown(event) {
        if (event.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_ENTER) {
            const editor = this.j;
            const beforeEnter = editor.e.fire('beforeEnter', event);
            if (beforeEnter !== undefined) {
                return beforeEnter;
            }
            if (!editor.s.isCollapsed()) {
                editor.execCommand('Delete');
            }
            editor.s.focus();
            this.onEnter(event);
            editor.e.fire('afterEnter', event);
            editor.synchronizeValues(); // fire change
            return false;
        }
    }
    onEnter(event) {
        const { jodit } = this;
        const fake = jodit.createInside.fake();
        try {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeInsertNode(jodit.s.range, fake);
            (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .moveCursorOutFromSpecialTags */ .Mt)(jodit, fake, ['a']);
            let block = (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .getBlockWrapper */ .Dk)(fake, jodit);
            const isLi = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isLeaf(block);
            // if use <br> defaultTag for break line or when was entered SHIFt key or in <td> or <th> or <blockquote>
            if ((!isLi || (event === null || event === void 0 ? void 0 : event.shiftKey)) &&
                (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .checkBR */ .lN)(fake, jodit, event === null || event === void 0 ? void 0 : event.shiftKey)) {
                return false;
            }
            // wrap no wrapped element
            if (!block && !(0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .hasPreviousBlock */ .tX)(fake, jodit)) {
                block = (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .wrapText */ .C1)(fake, jodit);
            }
            if (!block) {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .insertParagraph */ .yh)(fake, jodit, isLi ? 'li' : jodit.o.enter);
                return false;
            }
            if (!(0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .checkUnsplittableBox */ .bD)(fake, jodit, block)) {
                return false;
            }
            if (isLi && this.__isEmptyListLeaf(block)) {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .processEmptyLILeaf */ .cf)(fake, jodit, block);
                return false;
            }
            (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .splitFragment */ .HS)(fake, jodit, block);
        }
        finally {
            fake.isConnected && jodit.s.setCursorBefore(fake);
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(fake);
        }
    }
    __isEmptyListLeaf(li) {
        const result = this.j.e.fire('enterIsEmptyListLeaf', li);
        return (0,jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_6__/* .isBoolean */ .L)(result) ? result : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isEmpty(li);
    }
    /** @override */
    beforeDestruct(editor) {
        editor.e.off('keydown.enter');
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':keydown.enter')
], enter.prototype, "onEnterKeyDown", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('enter', enter);


/***/ }),

/***/ 13642:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   b: function() { return /* binding */ UISpacer; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29780);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @module ui/group
 */


let UISpacer = class UISpacer extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_0__/* .UIElement */ .D {
    className() {
        return 'UISpacer';
    }
};
UISpacer = (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_2__/* .component */ .s
], UISpacer);



/***/ }),

/***/ 13676:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D: function() { return /* binding */ elementsEqualAttributes; },
/* harmony export */   M: function() { return /* binding */ isSameAttributes; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(95350);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _has_same_style__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(70592);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Compares whether the given attributes match the element's own attributes
 * @private
 */
function isSameAttributes(elm, attrs) {
    if (!elm.attributes.length && !(0,jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_0__/* .size */ .E)(attrs)) {
        return true;
    }
    if (!(0,jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_0__/* .size */ .E)(attrs)) {
        return true;
    }
    void 0;
    return Object.keys(attrs).every(key => {
        if (key === 'class' || key === 'className') {
            return elm.classList.contains(attrs[key]);
        }
        if (key === 'style') {
            return (0,_has_same_style__WEBPACK_IMPORTED_MODULE_3__/* .hasSameStyle */ .g)(elm, attrs[key]);
        }
        return (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, key) === attrs[key];
    });
}
function elementsEqualAttributes(elm1, elm2) {
    return (elm1.attributes.length === elm2.attributes.length &&
        Array.from(elm1.attributes).every(attr => elm2.hasAttribute(attr.name) &&
            elm2.getAttribute(attr.name) === attr.value));
}


/***/ }),

/***/ 13861:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export paste */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29866);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(70674);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(90823);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









/**
 * Ask before paste HTML source
 */
class paste extends jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__/* .Plugin */ .k {
    constructor() {
        super(...arguments);
        this.pasteStack = new jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.LimitedStack(20);
        /**
         * The dialog box was already open
         */
        this._isDialogOpened = false;
    }
    /** @override **/
    afterInit(jodit) {
        jodit.e
            .on('paste.paste', this.onPaste)
            .on('pasteStack.paste', (item) => this.pasteStack.push(item));
        if (jodit.o.nl2brInPlainText) {
            this.j.e.on('processPaste.paste', this.onProcessPasteReplaceNl2Br);
        }
    }
    /** @override **/
    beforeDestruct(jodit) {
        jodit.e
            .off('paste.paste', this.onPaste)
            .off('processPaste.paste', this.onProcessPasteReplaceNl2Br)
            .off('.paste');
    }
    /**
     * Paste event handler
     */
    onPaste(e) {
        try {
            if (this.customPasteProcess(e) === false ||
                this.j.e.fire('beforePaste', e) === false) {
                e.preventDefault();
                return false;
            }
            this.defaultPasteProcess(e);
        }
        finally {
            this.j.e.fire('afterPaste', e);
        }
    }
    /**
     * Process before paste
     */
    customPasteProcess(e) {
        if (!this.j.o.processPasteHTML) {
            return;
        }
        const dt = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.getDataTransfer)(e), texts = [
            dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_PLAIN),
            dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_HTML),
            dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_RTF)
        ];
        for (const value of texts) {
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.isHTML)(value) &&
                (this.j.e.fire('processHTML', e, value, {
                    plain: texts[0],
                    html: texts[1],
                    rtf: texts[2]
                }) ||
                    this.processHTML(e, value))) {
                return false;
            }
        }
    }
    /**
     * Default paster process
     */
    defaultPasteProcess(e) {
        const dt = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.getDataTransfer)(e);
        let text = (dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_HTML)) || (dt === null || dt === void 0 ? void 0 : dt.getData(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_PLAIN));
        if (dt && text && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.trim)(text) !== '') {
            const result = this.j.e.fire('processPaste', e, text, (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .getAllTypes */ .DI)(dt));
            if (result !== undefined) {
                text = result;
            }
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.isString)(text) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isNode(text)) {
                this.__insertByType(e, text, this.j.o.defaultActionOnPaste);
            }
            e.preventDefault();
            e.stopPropagation();
        }
    }
    /**
     * Process usual HTML text fragment
     */
    processHTML(e, html) {
        if (!this.j.o.askBeforePasteHTML) {
            return false;
        }
        if (this.j.o.memorizeChoiceWhenPasteFragment) {
            const cached = this.pasteStack.find(cachedItem => cachedItem.html === html);
            if (cached) {
                this.__insertByType(e, html, cached.action || this.j.o.defaultActionOnPaste);
                return true;
            }
        }
        if (this._isDialogOpened) {
            return true;
        }
        const dialog = (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .askInsertTypeDialog */ .PU)(this.j, 'Your code is similar to HTML. Keep as HTML?', 'Paste as HTML', insertType => {
            this._isDialogOpened = false;
            this.__insertByType(e, html, insertType);
        }, this.j.o.pasteHTMLActionList);
        if (dialog) {
            this._isDialogOpened = true;
            dialog.e.on('beforeClose', () => {
                this._isDialogOpened = false;
            });
        }
        return true;
    }
    /**
     * Insert HTML by option type
     */
    __insertByType(e, html, action) {
        this.pasteStack.push({ html, action });
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.isString)(html)) {
            this.j.buffer.set(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.CLIPBOARD_ID, html);
            switch (action) {
                case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSERT_CLEAR_HTML:
                    html = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.cleanFromWord)(html);
                    break;
                case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSERT_ONLY_TEXT:
                    html = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.stripTags)(html, this.j.ed, new Set(this.j.o.pasteExcludeStripTags));
                    break;
                case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSERT_AS_TEXT:
                    html = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.htmlspecialchars)(html);
                    break;
                default: {
                    const newHTML = this.j.e.fire('onCustomPasteHTMLOption', action, html, e);
                    if (typeof newHTML === 'string') {
                        html = newHTML;
                    }
                }
            }
        }
        (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .pasteInsertHtml */ .sX)(e, this.j, html);
    }
    /**
     * Replace all \\n chars in plain text to br
     */
    onProcessPasteReplaceNl2Br(ignore, text, type) {
        if (type === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEXT_PLAIN + ';' && !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.isHTML)(text)) {
            return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.nl2br)(text);
        }
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], paste.prototype, "onPaste", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], paste.prototype, "onProcessPasteReplaceNl2Br", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('paste', paste);


/***/ }),

/***/ 13917:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export backspace */
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71005);
/* harmony import */ var jodit_core_selection_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(46602);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(81982);
/* harmony import */ var _cases_check_not_collapsed__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(90084);
/* harmony import */ var _cases__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(89832);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









class backspace extends jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__/* .Plugin */ .k {
    afterInit(jodit) {
        jodit
            .registerCommand('deleteButton', {
            exec: () => this.onDelete(false),
            hotkeys: jodit.o.delete.hotkeys.delete
        }, {
            stopPropagation: false
        })
            .registerCommand('backspaceButton', {
            exec: () => this.onDelete(true),
            hotkeys: jodit.o.delete.hotkeys.backspace
        }, {
            stopPropagation: false
        })
            .registerCommand('deleteWordButton', {
            exec: () => this.onDelete(false, 'word'),
            hotkeys: jodit.o.delete.hotkeys.deleteWord
        })
            .registerCommand('backspaceWordButton', {
            exec: () => this.onDelete(true, 'word'),
            hotkeys: jodit.o.delete.hotkeys.backspaceWord
        })
            .registerCommand('deleteSentenceButton', {
            exec: () => this.onDelete(false, 'sentence'),
            hotkeys: jodit.o.delete.hotkeys.deleteSentence
        })
            .registerCommand('backspaceSentenceButton', {
            exec: () => this.onDelete(true, 'sentence'),
            hotkeys: jodit.o.delete.hotkeys.backspaceSentence
        });
    }
    beforeDestruct(jodit) {
        jodit.e.off('afterCommand.delete');
    }
    /**
     * Listener BackSpace or Delete button
     */
    onDelete(backspace, mode = 'char') {
        const jodit = this.j;
        const sel = jodit.selection;
        if (!sel.isFocused()) {
            sel.focus();
        }
        if ((0,_cases_check_not_collapsed__WEBPACK_IMPORTED_MODULE_7__/* .checkNotCollapsed */ .L)(jodit)) {
            return false;
        }
        const range = sel.range;
        const fakeNode = jodit.createInside.text(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE);
        try {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeInsertNode(range, fakeNode);
            if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isOrContains(jodit.editor, fakeNode)) {
                return;
            }
            if (jodit.e.fire('backSpaceBeforeCases', backspace, fakeNode)) {
                return false;
            }
            (0,jodit_core_selection_helpers__WEBPACK_IMPORTED_MODULE_4__/* .moveNodeInsideStart */ .W8)(jodit, fakeNode, backspace);
            if (_cases__WEBPACK_IMPORTED_MODULE_6__/* .cases */ .C.some((func) => {
                if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_8__/* .isFunction */ .T)(func) &&
                    func(jodit, fakeNode, backspace, mode)) {
                    if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                        console.info('Remove case:', func.name);
                    }
                    return true;
                }
            })) {
                return false;
            }
        }
        catch (e) {
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                console.error(e);
            }
            throw e;
        }
        finally {
            jodit.e.fire('backSpaceAfterDelete', backspace, fakeNode);
            this.safeRemoveEmptyNode(fakeNode);
        }
        return false;
    }
    /**
     * Remove node and replace cursor position out of it
     */
    safeRemoveEmptyNode(fakeNode) {
        var _a, _b;
        const { range } = this.j.s;
        if (range.startContainer === fakeNode) {
            if (fakeNode.previousSibling) {
                if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(fakeNode.previousSibling)) {
                    range.setStart(fakeNode.previousSibling, (_b = (_a = fakeNode.previousSibling.nodeValue) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0);
                }
                else {
                    range.setStartAfter(fakeNode.previousSibling);
                }
            }
            else if (fakeNode.nextSibling) {
                if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(fakeNode.nextSibling)) {
                    range.setStart(fakeNode.nextSibling, 0);
                }
                else {
                    range.setStartBefore(fakeNode.nextSibling);
                }
            }
            range.collapse(true);
            this.j.s.selectRange(range);
        }
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(fakeNode);
    }
}
backspace.requires = ['hotkeys'];
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('backspace', backspace);


/***/ }),

/***/ 14006:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1216 320q0 26-19 45t-45 19h-128v1024h128q26 0 45 19t19 45-19 45l-256 256q-19 19-45 19t-45-19l-256-256q-19-19-19-45t19-45 45-19h128v-1024h-128q-26 0-45-19t-19-45 19-45l256-256q19-19 45-19t45 19l256 256q19 19 19 45z\"/> </svg>"

/***/ }),

/***/ 14017:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M384 544v576q0 13-9.5 22.5t-22.5 9.5q-14 0-23-9l-288-288q-9-9-9-23t9-23l288-288q9-9 23-9 13 0 22.5 9.5t9.5 22.5zm1408 768v192q0 13-9.5 22.5t-22.5 9.5h-1728q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1728q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1088q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1088q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1088q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1088q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1728q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1728q13 0 22.5 9.5t9.5 22.5z\"/> </svg>"

/***/ }),

/***/ 14305:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1171 960q0 13-10 23l-466 466q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l393-393-393-393q-10-10-10-23t10-23l50-50q10-10 23-10t23 10l466 466q10 10 10 23z\"/> </svg>"

/***/ }),

/***/ 14961:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   T: function() { return /* binding */ ViewWithToolbar; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(52201);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(32709);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(58720);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(53048);
/* harmony import */ var jodit_core_ui_helpers_buttons__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(39611);
/* harmony import */ var jodit_core_view_view__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(77782);
/* harmony import */ var jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8809);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */













class ViewWithToolbar extends jodit_core_view_view__WEBPACK_IMPORTED_MODULE_6__/* .View */ .S {
    /**
     * Container for toolbar
     */
    get toolbarContainer() {
        if (!this.o.fullsize &&
            ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_8__/* .isString */ .K)(this.o.toolbar) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isHTMLElement(this.o.toolbar))) {
            return (0,jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_4__/* .resolveElement */ .tI)(this.o.toolbar, this.o.shadowRoot || this.od);
        }
        this.o.toolbar &&
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.appendChildFirst(this.container, this.__defaultToolbarContainer);
        return this.__defaultToolbarContainer;
    }
    /**
     * Change panel container
     */
    setPanel(element) {
        this.o.toolbar = element;
        this.buildToolbar();
    }
    /**
     * Helper for appended toolbar in its place
     */
    buildToolbar() {
        var _a;
        if (!this.o.toolbar) {
            return;
        }
        const buttons = this.o.buttons
            ? (0,jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_3__/* .splitArray */ .uM)(this.o.buttons)
            : [];
        (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.setRemoveButtons(this.o.removeButtons).build(buttons.concat(this.o.extraButtons || [])).appendTo(this.toolbarContainer);
    }
    getRegisteredButtonGroups() {
        return this.groupToButtons;
    }
    /**
     * Register button for a group
     */
    registerButton(btn) {
        var _a;
        this.registeredButtons.add(btn);
        const group = (_a = btn.group) !== null && _a !== void 0 ? _a : 'other';
        if (!this.groupToButtons[group]) {
            this.groupToButtons[group] = [];
        }
        if (btn.position != null) {
            this.groupToButtons[group][btn.position] = btn.name;
        }
        else {
            this.groupToButtons[group].push(btn.name);
        }
        return this;
    }
    /**
     * Remove button from a group
     */
    unregisterButton(btn) {
        var _a;
        this.registeredButtons.delete(btn);
        const groupName = (_a = btn.group) !== null && _a !== void 0 ? _a : 'other', group = this.groupToButtons[groupName];
        if (group) {
            const index = group.indexOf(btn.name);
            if (index !== -1) {
                group.splice(index, 1);
            }
            if (group.length === 0) {
                delete this.groupToButtons[groupName];
            }
        }
        return this;
    }
    /**
     * Prepare toolbar items and append buttons in groups
     */
    beforeToolbarBuild(items) {
        if (Object.keys(this.groupToButtons).length) {
            return items.map(item => {
                if ((0,jodit_core_ui_helpers_buttons__WEBPACK_IMPORTED_MODULE_9__/* .isButtonGroup */ .i)(item) &&
                    item.group &&
                    this.groupToButtons[item.group]) {
                    return {
                        group: item.group,
                        buttons: [
                            ...item.buttons,
                            ...this.groupToButtons[item.group]
                        ]
                    };
                }
                return item;
            });
        }
    }
    /** @override **/
    constructor(options, isJodit = false) {
        super(options, isJodit);
        this.toolbar = (0,jodit_modules_toolbar_factory__WEBPACK_IMPORTED_MODULE_7__/* .makeCollection */ .$K)(this);
        this.__defaultToolbarContainer = this.c.div('jodit-toolbar__box');
        this.registeredButtons = new Set();
        this.groupToButtons = {};
        this.isJodit = false;
        this.__tooltip = new jodit_core_ui__WEBPACK_IMPORTED_MODULE_5__/* .UITooltip */ .SB(this);
        this.isJodit = isJodit;
        this.e.on('beforeToolbarBuild', this.beforeToolbarBuild);
    }
    destruct() {
        if (this.isDestructed) {
            return;
        }
        this.setStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.beforeDestruct);
        this.e.off('beforeToolbarBuild', this.beforeToolbarBuild);
        this.__tooltip.destruct();
        this.toolbar.destruct();
        // @ts-ignore After destruct, we are not responsible for anything
        this.toolbar = undefined;
        super.destruct();
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)(':rebuildToolbar')
], ViewWithToolbar.prototype, "buildToolbar", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_10__/* .__decorate */ .Cg)([
    jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Ay
], ViewWithToolbar.prototype, "beforeToolbarBuild", null);


/***/ }),

/***/ 15396:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Zd: function() { return /* reexport safe */ _get_hash__WEBPACK_IMPORTED_MODULE_0__.Z; },
/* harmony export */   eZ: function() { return /* reexport safe */ _visitor_visit_node_walker__WEBPACK_IMPORTED_MODULE_3__.e; },
/* harmony export */   hk: function() { return /* reexport safe */ _remove_format_remove_format_for_selection__WEBPACK_IMPORTED_MODULE_2__.h; },
/* harmony export */   w5: function() { return /* reexport safe */ _remove_format_remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_1__.w; }
/* harmony export */ });
/* harmony import */ var _get_hash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(60549);
/* harmony import */ var _remove_format_remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(30526);
/* harmony import */ var _remove_format_remove_format_for_selection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20646);
/* harmony import */ var _visitor_visit_node_walker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(52306);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/clean-html
 */






/***/ }),

/***/ 15776:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36115);
/* harmony import */ var _items_a__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(97836);
/* harmony import */ var _items_cells__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(82558);
/* harmony import */ var _items_iframe__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6295);
/* harmony import */ var _items_img__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(26396);
/* harmony import */ var _items_toolbar__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(58540);
/* harmony import */ var jodit_plugins_inline_popup_icons_addcolumn_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(38681);
/* harmony import */ var jodit_plugins_inline_popup_icons_addcolumn_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_addcolumn_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var jodit_plugins_inline_popup_icons_addrow_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(64637);
/* harmony import */ var jodit_plugins_inline_popup_icons_addrow_svg__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_addrow_svg__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var jodit_plugins_inline_popup_icons_merge_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(94190);
/* harmony import */ var jodit_plugins_inline_popup_icons_merge_svg__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_merge_svg__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var jodit_plugins_inline_popup_icons_splitg_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(51957);
/* harmony import */ var jodit_plugins_inline_popup_icons_splitg_svg__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_splitg_svg__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var jodit_plugins_inline_popup_icons_splitv_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(71940);
/* harmony import */ var jodit_plugins_inline_popup_icons_splitv_svg__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_splitv_svg__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var jodit_plugins_inline_popup_icons_th_svg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(43218);
/* harmony import */ var jodit_plugins_inline_popup_icons_th_svg__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_th_svg__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var jodit_plugins_inline_popup_icons_th_list_svg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(48007);
/* harmony import */ var jodit_plugins_inline_popup_icons_th_list_svg__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(jodit_plugins_inline_popup_icons_th_list_svg__WEBPACK_IMPORTED_MODULE_12__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */














jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.toolbarInline = true;
jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.toolbarInlineForSelection = false;
jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.toolbarInlineDisableFor = [];
jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.toolbarInlineDisabledButtons = ['source'];
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_0__/* .Icon */ .I.set('addcolumn', (jodit_plugins_inline_popup_icons_addcolumn_svg__WEBPACK_IMPORTED_MODULE_6___default()))
    .set('addrow', (jodit_plugins_inline_popup_icons_addrow_svg__WEBPACK_IMPORTED_MODULE_7___default()))
    .set('merge', (jodit_plugins_inline_popup_icons_merge_svg__WEBPACK_IMPORTED_MODULE_8___default()))
    .set('th', (jodit_plugins_inline_popup_icons_th_svg__WEBPACK_IMPORTED_MODULE_11___default()))
    .set('splitg', (jodit_plugins_inline_popup_icons_splitg_svg__WEBPACK_IMPORTED_MODULE_9___default()))
    .set('splitv', (jodit_plugins_inline_popup_icons_splitv_svg__WEBPACK_IMPORTED_MODULE_10___default()))
    .set('th-list', (jodit_plugins_inline_popup_icons_th_list_svg__WEBPACK_IMPORTED_MODULE_12___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.prototype.popup = {
    a: _items_a__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .A,
    img: _items_img__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .A,
    cells: _items_cells__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .A,
    toolbar: _items_toolbar__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .A,
    jodit: _items_iframe__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A,
    iframe: _items_iframe__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A,
    'jodit-media': _items_iframe__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .A,
    selection: [
        'bold',
        'underline',
        'italic',
        'ul',
        'ol',
        '\n',
        'outdent',
        'indent',
        'fontsize',
        'brush',
        'cut',
        '\n',
        'paragraph',
        'link',
        'align',
        'dots'
    ]
};


/***/ }),

/***/ 16113:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Gq: function() { return /* reexport safe */ _htmlspecialchars__WEBPACK_IMPORTED_MODULE_2__.G; },
/* harmony export */   HA: function() { return /* reexport safe */ _nl2br__WEBPACK_IMPORTED_MODULE_3__.H; },
/* harmony export */   Kq: function() { return /* reexport safe */ _strip_tags__WEBPACK_IMPORTED_MODULE_5__.K; },
/* harmony export */   ZM: function() { return /* reexport safe */ _apply_styles__WEBPACK_IMPORTED_MODULE_0__.Z; },
/* harmony export */   t_: function() { return /* reexport safe */ _safe_html__WEBPACK_IMPORTED_MODULE_4__.t; },
/* harmony export */   vn: function() { return /* reexport safe */ _safe_html__WEBPACK_IMPORTED_MODULE_4__.v; },
/* harmony export */   wE: function() { return /* reexport safe */ _clean_from_word__WEBPACK_IMPORTED_MODULE_1__.w; }
/* harmony export */ });
/* harmony import */ var _apply_styles__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56176);
/* harmony import */ var _clean_from_word__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94450);
/* harmony import */ var _htmlspecialchars__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4960);
/* harmony import */ var _nl2br__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10025);
/* harmony import */ var _safe_html__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26328);
/* harmony import */ var _strip_tags__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(61793);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */








/***/ }),

/***/ 16116:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Kn: function() { return /* reexport safe */ _color_picker_color_picker__WEBPACK_IMPORTED_MODULE_0__.K; },
/* harmony export */   Zg: function() { return /* reexport safe */ _tabs_tabs__WEBPACK_IMPORTED_MODULE_2__.Z; },
/* harmony export */   kG: function() { return /* reexport safe */ _file_selector_file_selector__WEBPACK_IMPORTED_MODULE_1__.k; }
/* harmony export */ });
/* harmony import */ var _color_picker_color_picker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19633);
/* harmony import */ var _file_selector_file_selector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10067);
/* harmony import */ var _tabs_tabs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4909);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:modules/widget/README.md]]
 * @packageDocumentation
 * @module modules/widget
 */





/***/ }),

/***/ 16841:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   J: function() { return /* binding */ get; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(35642);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Safe access in tree object
 *
 * @example
 * ```js
 * const obj = {
 *   a: {
 *     b: {
 *       c: {
 *         e: false
 *       }
 *     }
 *   }
 * };
 *
 * console.log(Jodit.modules.Helpers.get('a.b.c.d.e', obj) === false); // true
 * console.log(Jodit.modules.Helpers.get('a.b.a.d.e', obj) === null); // false
 * ```
 */
function get(chain, obj) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(chain) || !chain.length) {
        return null;
    }
    const parts = chain.split('.');
    let result = obj;
    try {
        for (const part of parts) {
            if ((0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_1__/* .isVoid */ .R)(result[part])) {
                return null;
            }
            result = result[part];
        }
    }
    catch (_a) {
        return null; // permission denied ore another access exception
    }
    if ((0,jodit_core_helpers_checker_is_void__WEBPACK_IMPORTED_MODULE_1__/* .isVoid */ .R)(result)) {
        return null;
    }
    return result;
}


/***/ }),

/***/ 17352:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCURACY: function() { return /* binding */ ACCURACY; },
/* harmony export */   APP_VERSION: function() { return /* binding */ APP_VERSION; },
/* harmony export */   BASE_PATH: function() { return /* binding */ BASE_PATH; },
/* harmony export */   BASE_PATH_IS_MIN: function() { return /* binding */ BASE_PATH_IS_MIN; },
/* harmony export */   BR: function() { return /* binding */ BR; },
/* harmony export */   CLIPBOARD_ID: function() { return /* binding */ CLIPBOARD_ID; },
/* harmony export */   COMMAND_KEYS: function() { return /* binding */ COMMAND_KEYS; },
/* harmony export */   EMULATE_DBLCLICK_TIMEOUT: function() { return /* binding */ EMULATE_DBLCLICK_TIMEOUT; },
/* harmony export */   ES: function() { return /* binding */ ES; },
/* harmony export */   FAT_MODE: function() { return /* binding */ FAT_MODE; },
/* harmony export */   HOMEPAGE: function() { return /* binding */ HOMEPAGE; },
/* harmony export */   INSEPARABLE_TAGS: function() { return /* binding */ INSEPARABLE_TAGS; },
/* harmony export */   INSERT_AS_HTML: function() { return /* binding */ INSERT_AS_HTML; },
/* harmony export */   INSERT_AS_TEXT: function() { return /* binding */ INSERT_AS_TEXT; },
/* harmony export */   INSERT_CLEAR_HTML: function() { return /* binding */ INSERT_CLEAR_HTML; },
/* harmony export */   INSERT_ONLY_TEXT: function() { return /* binding */ INSERT_ONLY_TEXT; },
/* harmony export */   INVISIBLE_SPACE: function() { return /* binding */ INVISIBLE_SPACE; },
/* harmony export */   INVISIBLE_SPACE_REG_EXP: function() { return /* binding */ INVISIBLE_SPACE_REG_EXP; },
/* harmony export */   INVISIBLE_SPACE_REG_EXP_END: function() { return /* binding */ INVISIBLE_SPACE_REG_EXP_END; },
/* harmony export */   INVISIBLE_SPACE_REG_EXP_START: function() { return /* binding */ INVISIBLE_SPACE_REG_EXP_START; },
/* harmony export */   IS_BLOCK: function() { return /* binding */ IS_BLOCK; },
/* harmony export */   IS_ES_MODERN: function() { return /* binding */ IS_ES_MODERN; },
/* harmony export */   IS_ES_NEXT: function() { return /* binding */ IS_ES_NEXT; },
/* harmony export */   IS_IE: function() { return /* binding */ IS_IE; },
/* harmony export */   IS_INLINE: function() { return /* binding */ IS_INLINE; },
/* harmony export */   IS_MAC: function() { return /* binding */ IS_MAC; },
/* harmony export */   IS_PROD: function() { return /* binding */ IS_PROD; },
/* harmony export */   IS_TEST: function() { return /* binding */ IS_TEST; },
/* harmony export */   KEY_ALIASES: function() { return /* binding */ KEY_ALIASES; },
/* harmony export */   KEY_ALT: function() { return /* binding */ KEY_ALT; },
/* harmony export */   KEY_BACKSPACE: function() { return /* binding */ KEY_BACKSPACE; },
/* harmony export */   KEY_DELETE: function() { return /* binding */ KEY_DELETE; },
/* harmony export */   KEY_DOWN: function() { return /* binding */ KEY_DOWN; },
/* harmony export */   KEY_ENTER: function() { return /* binding */ KEY_ENTER; },
/* harmony export */   KEY_ESC: function() { return /* binding */ KEY_ESC; },
/* harmony export */   KEY_F3: function() { return /* binding */ KEY_F3; },
/* harmony export */   KEY_LEFT: function() { return /* binding */ KEY_LEFT; },
/* harmony export */   KEY_META: function() { return /* binding */ KEY_META; },
/* harmony export */   KEY_RIGHT: function() { return /* binding */ KEY_RIGHT; },
/* harmony export */   KEY_SPACE: function() { return /* binding */ KEY_SPACE; },
/* harmony export */   KEY_TAB: function() { return /* binding */ KEY_TAB; },
/* harmony export */   KEY_UP: function() { return /* binding */ KEY_UP; },
/* harmony export */   LIST_TAGS: function() { return /* binding */ LIST_TAGS; },
/* harmony export */   MARKER_CLASS: function() { return /* binding */ MARKER_CLASS; },
/* harmony export */   MODE_SOURCE: function() { return /* binding */ MODE_SOURCE; },
/* harmony export */   MODE_SPLIT: function() { return /* binding */ MODE_SPLIT; },
/* harmony export */   MODE_WYSIWYG: function() { return /* binding */ MODE_WYSIWYG; },
/* harmony export */   NBSP_SPACE: function() { return /* binding */ NBSP_SPACE; },
/* harmony export */   NEARBY: function() { return /* binding */ NEARBY; },
/* harmony export */   NO_EMPTY_TAGS: function() { return /* binding */ NO_EMPTY_TAGS; },
/* harmony export */   PARAGRAPH: function() { return /* binding */ PARAGRAPH; },
/* harmony export */   PASSIVE_EVENTS: function() { return /* binding */ PASSIVE_EVENTS; },
/* harmony export */   SAFE_COUNT_CHANGE_CALL: function() { return /* binding */ SAFE_COUNT_CHANGE_CALL; },
/* harmony export */   SET_TEST: function() { return /* binding */ SET_TEST; },
/* harmony export */   SOURCE_CONSUMER: function() { return /* binding */ SOURCE_CONSUMER; },
/* harmony export */   SPACE_REG_EXP: function() { return /* binding */ SPACE_REG_EXP; },
/* harmony export */   SPACE_REG_EXP_END: function() { return /* binding */ SPACE_REG_EXP_END; },
/* harmony export */   SPACE_REG_EXP_START: function() { return /* binding */ SPACE_REG_EXP_START; },
/* harmony export */   TEMP_ATTR: function() { return /* binding */ TEMP_ATTR; },
/* harmony export */   TEXT_HTML: function() { return /* binding */ TEXT_HTML; },
/* harmony export */   TEXT_PLAIN: function() { return /* binding */ TEXT_PLAIN; },
/* harmony export */   TEXT_RTF: function() { return /* binding */ TEXT_RTF; },
/* harmony export */   TOKENS: function() { return /* binding */ TOKENS; },
/* harmony export */   globalDocument: function() { return /* binding */ globalDocument; },
/* harmony export */   globalWindow: function() { return /* binding */ globalWindow; },
/* harmony export */   lang: function() { return /* binding */ lang; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
const APP_VERSION = "4.6.2";
// prettier-ignore
const ES = "es2015";
const IS_ES_MODERN = true;
const IS_ES_NEXT = false;
const IS_PROD = true;
let IS_TEST = false;
const FAT_MODE = false;
const HOMEPAGE = "https://xdsoft.net/jodit/";
const SET_TEST = () => (IS_TEST = true);
const TOKENS = {};
const INVISIBLE_SPACE = '\uFEFF';
const NBSP_SPACE = '\u00A0';
const INVISIBLE_SPACE_REG_EXP = () => /[\uFEFF]/g;
const INVISIBLE_SPACE_REG_EXP_END = () => /[\uFEFF]+$/g;
const INVISIBLE_SPACE_REG_EXP_START = () => /^[\uFEFF]+/g;
const SPACE_REG_EXP = () => /[\s\n\t\r\uFEFF\u200b]+/g;
const SPACE_REG_EXP_START = () => /^[\s\n\t\r\uFEFF\u200b]+/g;
const SPACE_REG_EXP_END = () => /[\s\n\t\r\uFEFF\u200b]+$/g;
const globalWindow = typeof window !== 'undefined' ? window : undefined;
const globalDocument = typeof document !== 'undefined'
    ? document
    : undefined;
const IS_BLOCK = /^(ADDRESS|ARTICLE|ASIDE|BLOCKQUOTE|CANVAS|DD|DFN|DIV|DL|DT|FIELDSET|FIGCAPTION|FIGURE|FOOTER|FORM|H[1-6]|HEADER|HGROUP|HR|LI|MAIN|NAV|NOSCRIPT|OUTPUT|P|PRE|RUBY|SCRIPT|STYLE|OBJECT|OL|SECTION|IFRAME|JODIT|JODIT-MEDIA|UL|TR|TD|TH|TBODY|THEAD|TFOOT|TABLE|BODY|HTML|VIDEO)$/i;
const IS_INLINE = /^(STRONG|SPAN|I|EM|B|SUP|SUB|A|U)$/i;
const LIST_TAGS = new Set(['ul', 'ol']);
const __UNSEPARABLE_TAGS = [
    'img',
    'video',
    'svg',
    'iframe',
    'script',
    'input',
    'textarea',
    'link',
    'jodit',
    'jodit-media'
];
const INSEPARABLE_TAGS = new Set([
    ...__UNSEPARABLE_TAGS,
    'br',
    'hr'
]);
const NO_EMPTY_TAGS = new Set(__UNSEPARABLE_TAGS);
const KEY_META = 'Meta';
const KEY_BACKSPACE = 'Backspace';
const KEY_TAB = 'Tab';
const KEY_ENTER = 'Enter';
const KEY_ESC = 'Escape';
const KEY_ALT = 'Alt';
const KEY_LEFT = 'ArrowLeft';
const KEY_UP = 'ArrowUp';
const KEY_RIGHT = 'ArrowRight';
const KEY_DOWN = 'ArrowDown';
const KEY_SPACE = 'Space';
const KEY_DELETE = 'Delete';
const KEY_F3 = 'F3';
const NEARBY = 5;
const ACCURACY = 10;
const COMMAND_KEYS = [
    KEY_META,
    KEY_BACKSPACE,
    KEY_DELETE,
    KEY_UP,
    KEY_DOWN,
    KEY_RIGHT,
    KEY_LEFT,
    KEY_ENTER,
    KEY_ESC,
    KEY_F3,
    KEY_TAB
];
const BR = 'br';
const PARAGRAPH = 'p';
/**
 * WYSIWYG editor mode
 */
const MODE_WYSIWYG = 1;
/**
 * html editor mode
 */
const MODE_SOURCE = 2;
/**
 * Source code editor and HTML editor both like
 * @see http://getuikit.com/docs/htmleditor.html|this
 */
const MODE_SPLIT = 3;
/**
 * Is Internet Explorer
 */
const IS_IE = typeof navigator !== 'undefined' &&
    (navigator.userAgent.indexOf('MSIE') !== -1 ||
        /rv:11.0/i.test(navigator.userAgent));
/**
 * For IE11 it will be 'text'. Need for dataTransfer.setData
 */
const TEXT_PLAIN = IS_IE ? 'text' : 'text/plain';
const TEXT_HTML = IS_IE ? 'html' : 'text/html';
const TEXT_RTF = IS_IE ? 'rtf' : 'text/rtf';
const MARKER_CLASS = 'jodit-selection_marker';
const EMULATE_DBLCLICK_TIMEOUT = 300;
/**
 * Paste the copied text as HTML, all content will be pasted exactly as it was on the clipboard.
 * So how would you copy its code directly into the source document.
 * ```
 * <h1 style="color:red">test</h1>
 * ```
 * Will be inserted into the document as
 * ```
 * <h1 style="color:red">test</h1>
 * ```
 */
const INSERT_AS_HTML = 'insert_as_html';
/**
 * Same as [[INSERT_AS_HTML]], but content will be stripped of extra styles and empty tags
 * ```html
 * <h1 style="color:red">test</h1>
 * ```
 * Will be inserted into the document as
 * ```html
 * <h1>test</h1>
 * ```
 */
const INSERT_CLEAR_HTML = 'insert_clear_html';
/**
 * The contents of the clipboard will be pasted into the document as plain text, i.e. all tags will be displayed as text.
 * ```html
 * <h1>test</h1>
 * ```
 * Will be inserted into the document as
 * ```html
 * &gt;&lt;h1&gt;test&lt;/h1&gt;
 * ```
 */
const INSERT_AS_TEXT = 'insert_as_text';
/**
 * All tags will be stripped:
 * ```html
 * <h1>test</h1>
 * ```
 * Will be inserted into the document as
 * ```html
 * test
 * ```
 */
const INSERT_ONLY_TEXT = 'insert_only_text';
const SAFE_COUNT_CHANGE_CALL = 10;
const IS_MAC = typeof globalWindow !== 'undefined' &&
    /Mac|iPod|iPhone|iPad/.test(globalWindow.navigator.platform);
const KEY_ALIASES = {
    add: '+',
    break: 'pause',
    cmd: 'meta',
    command: 'meta',
    ctl: 'control',
    ctrl: 'control',
    del: 'delete',
    down: 'arrowdown',
    esc: 'escape',
    ins: 'insert',
    left: 'arrowleft',
    mod: IS_MAC ? 'meta' : 'control',
    opt: 'alt',
    option: 'alt',
    return: 'enter',
    right: 'arrowright',
    space: 'space',
    spacebar: 'space',
    up: 'arrowup',
    win: 'meta',
    windows: 'meta'
};
const removeScriptName = (src) => {
    const parts = src.split('/');
    const isMin =  true
        ? false
        : 0;
    if (/\.js/.test(parts[parts.length - 1])) {
        return {
            basePath: parts.slice(0, parts.length - 1).join('/') + '/',
            isMin
        };
    }
    return {
        basePath: src,
        isMin
    };
};
const { basePath, isMin } = (() => {
    if (typeof document === 'undefined') {
        return {
            basePath: '',
            isMin: Boolean(false)
        };
    }
    const script = globalDocument.currentScript;
    if (script) {
        return removeScriptName(script.src);
    }
    const scripts = globalDocument.querySelectorAll('script[src]');
    if (scripts && scripts.length) {
        return removeScriptName(scripts[scripts.length - 1].src);
    }
    return removeScriptName(globalWindow.location.href);
})();
/**
 * Path to the current script
 */
const BASE_PATH = basePath;
/**
 * Current script is minified
 */
const BASE_PATH_IS_MIN = isMin;
const TEMP_ATTR = 'data-jodit-temp';
const lang = {};
const CLIPBOARD_ID = 'clipboard';
const SOURCE_CONSUMER = 'source-consumer';
const PASSIVE_EVENTS = new Set([
    'touchstart',
    'touchend',
    'scroll',
    'mousewheel',
    'mousemove',
    'touchmove'
]);


/***/ }),

/***/ 17527:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   e: function() { return /* binding */ defaultLanguage; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */


/**
 * Try define user language
 */
const defaultLanguage = (language, defaultLanguage = 'en') => {
    if (language !== 'auto' && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__/* .isString */ .K)(language)) {
        return language;
    }
    if (jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.documentElement && jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.documentElement.lang) {
        return jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.documentElement.lang;
    }
    if (navigator.language) {
        return navigator.language.substring(0, 2);
    }
    return defaultLanguage;
};


/***/ }),

/***/ 17800:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I: function() { return /* binding */ canUsePersistentStorage; },
/* harmony export */   O: function() { return /* binding */ LocalStorageProvider; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Check if user disable local storages/cookie etc.
 */
const canUsePersistentStorage = (() => {
    const canUse = () => {
        const tmpKey = '___Jodit___' + Math.random().toString();
        try {
            localStorage.setItem(tmpKey, '1');
            const result = localStorage.getItem(tmpKey) === '1';
            localStorage.removeItem(tmpKey);
            return result;
        }
        catch (_a) { }
        return false;
    };
    let result;
    return () => {
        if (result === undefined) {
            result = canUse();
        }
        return result;
    };
})();
/**
 * Persistent storage in localStorage
 */
class LocalStorageProvider {
    set(key, value) {
        try {
            const buffer = localStorage.getItem(this.rootKey);
            const json = buffer ? JSON.parse(buffer) : {};
            json[key] = value;
            localStorage.setItem(this.rootKey, JSON.stringify(json));
        }
        catch (_a) { }
        return this;
    }
    delete(key) {
        try {
            localStorage.removeItem(this.rootKey);
        }
        catch (_a) { }
        return this;
    }
    get(key) {
        try {
            const buffer = localStorage.getItem(this.rootKey);
            const json = buffer ? JSON.parse(buffer) : {};
            return json[key] !== undefined ? json[key] : undefined;
        }
        catch (_a) { }
    }
    exists(key) {
        return this.get(key) != null;
    }
    constructor(rootKey) {
        this.rootKey = rootKey;
    }
    clear() {
        try {
            localStorage.removeItem(this.rootKey);
        }
        catch (_a) { }
        return this;
    }
}


/***/ }),

/***/ 17880:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   P: function() { return /* binding */ readSizes; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12461);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38322);
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9645);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @module plugins/image-properties
 */




/** @private */
function readSizes(image, values, state) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
        yield image.decode();
        const width = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__/* .css */ .A)(image, 'width', true) || (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'width') || false;
        const height = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__/* .css */ .A)(image, 'height', true) || (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'height') || false;
        values.imageWidth =
            width !== false
                ? (0,_utils_utils__WEBPACK_IMPORTED_MODULE_1__/* .normalSizeFromString */ .G)(width)
                : image.offsetWidth || image.naturalWidth;
        if ((0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_4__/* .isNumeric */ .k)(values.imageWidth)) {
            values.imageHeight =
                height !== false
                    ? (0,_utils_utils__WEBPACK_IMPORTED_MODULE_1__/* .normalSizeFromString */ .G)(height)
                    : image.offsetHeight || image.naturalHeight;
        }
        else {
            values.imageHeight = height || '';
        }
        const { imageWidth, imageHeight } = values;
        const w = parseFloat(imageWidth.toString());
        if (!(0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_4__/* .isNumeric */ .k)(imageWidth) || !(0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_4__/* .isNumeric */ .k)(imageHeight)) {
            state.sizeIsLocked = false;
            return;
        }
        if (height === false) {
            values.imageHeight = Math.round(w / state.ratio);
            state.sizeIsLocked = true;
            return;
        }
        const h = parseFloat(imageHeight.toString());
        state.sizeIsLocked = Math.abs(w - h * state.ratio) < 1;
    });
}


/***/ }),

/***/ 18043:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ selfListeners; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9823);
/* harmony import */ var jodit_modules_file_browser_data_provider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(75889);
/* harmony import */ var jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(97324);
/* harmony import */ var jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9979);
/* harmony import */ var jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31859);
/* harmony import */ var jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(53804);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







/**
 * @private
 */
function selfListeners() {
    const state = this.state, dp = this.dataProvider, self = this;
    self.e
        .on('view.filebrowser', (view) => {
        if (view !== state.view) {
            state.view = view;
        }
    })
        .on('sort.filebrowser', (value) => {
        if (value !== state.sortBy) {
            state.sortBy = value;
            (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_5__/* .loadItems */ .f)(self);
        }
    })
        .on('filter.filebrowser', (value) => {
        if (value !== state.filterWord) {
            state.filterWord = value;
            (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_5__/* .loadItems */ .f)(self);
        }
    })
        .on('openFolder.filebrowser', (data) => {
        let path;
        if (data.name === '..') {
            path = data.path
                .split('/')
                .filter((p) => p.length)
                .slice(0, -1)
                .join('/');
        }
        else {
            path = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.normalizePath)(data.path, data.name);
        }
        self.state.currentPath = path;
        self.state.currentSource =
            data.name === '.' ? jodit_modules_file_browser_data_provider__WEBPACK_IMPORTED_MODULE_2__/* .DEFAULT_SOURCE_NAME */ .o : data.source;
    })
        .on('removeFolder.filebrowser', (data) => {
        self.confirm('Are you sure?', 'Delete', (yes) => {
            if (yes) {
                dp.folderRemove(data.path, data.name, data.source)
                    .then(message => {
                    self.status(message, true);
                    return (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(self);
                })
                    .catch(self.status);
            }
        });
    })
        .on('renameFolder.filebrowser', (data) => {
        self.prompt('Enter new name', 'Rename', (newName) => {
            if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isValidName */ .uV)(newName)) {
                self.status(self.i18n('Enter new name'));
                return false;
            }
            dp.folderRename(data.path, data.name, newName, data.source)
                .then(message => {
                self.state.activeElements = [];
                self.status(message, true);
                return (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(self);
            })
                .catch(self.status);
            return;
        }, 'type name', data.name);
    })
        .on('addFolder.filebrowser', (data) => {
        self.prompt('Enter Directory name', 'Create directory', (name) => {
            dp.createFolder(name, data.path, data.source)
                .then(() => (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(self))
                .catch(self.status);
        }, 'type name');
    })
        .on('fileRemove.filebrowser', () => {
        if (self.state.activeElements.length) {
            self.confirm('Are you sure?', '', (yes) => {
                if (yes) {
                    const promises = [];
                    self.state.activeElements.forEach(item => {
                        promises.push((0,jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_6__/* .deleteFile */ .W)(self, item.file || item.name || '', item.sourceName));
                    });
                    self.state.activeElements = [];
                    Promise.all(promises).then(() => (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(self).catch(self.status), self.status);
                }
            });
        }
    })
        .on('edit.filebrowser', () => {
        if (self.state.activeElements.length === 1) {
            const [file] = this.state.activeElements;
            jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_4__/* .openImageEditor */ .B.call(self, file.fileURL, file.file || '', file.path, file.sourceName);
        }
    })
        .on('fileRename.filebrowser', (name, path, source) => {
        if (self.state.activeElements.length === 1) {
            self.prompt('Enter new name', 'Rename', (newName) => {
                if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isValidName */ .uV)(newName)) {
                    self.status(self.i18n('Enter new name'));
                    return false;
                }
                dp.fileRename(path, name, newName, source)
                    .then(message => {
                    self.state.activeElements = [];
                    self.status(message, true);
                    (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_5__/* .loadItems */ .f)(self);
                })
                    .catch(self.status);
                return;
            }, 'type name', name);
        }
    })
        .on('update.filebrowser', () => {
        (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_3__/* .loadTree */ .r)(this).then(this.status, this.status);
    });
}


/***/ }),

/***/ 18605:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1025 1369v167h-248l-159-252-24-42q-8-9-11-21h-3l-9 21q-10 20-25 44l-155 250h-258v-167h128l197-291-185-272h-137v-168h276l139 228q2 4 23 42 8 9 11 21h3q3-9 11-21l25-42 140-228h257v168h-125l-184 267 204 296h109zm637-679v206h-514l-3-27q-4-28-4-46 0-64 26-117t65-86.5 84-65 84-54.5 65-54 26-64q0-38-29.5-62.5t-70.5-24.5q-51 0-97 39-14 11-36 38l-105-92q26-37 63-66 83-65 188-65 110 0 178 59.5t68 158.5q0 56-24.5 103t-62 76.5-81.5 58.5-82 50.5-65.5 51.5-30.5 63h232v-80h126z\"/> </svg>"

/***/ }),

/***/ 19085:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export imageProperties */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29866);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(35265);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(24654);
/* harmony import */ var _ui_ui_image_form__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31970);
/* harmony import */ var _utils_open_image_editor__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(80778);
/* harmony import */ var _utils_open_image_popup__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(33733);
/* harmony import */ var _readers__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(5549);
/* harmony import */ var _writers__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(30393);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */













/**
 * Plug-in for image editing window
 *
 * @example
 * ```javascript
 * const editor = Jodit.make('#editor', {
 *     image: {
 *         editSrc: false,
 *         editLink: false
 *     }
 * });
 * ```
 */
/**
 * Show dialog with image's options
 */
class imageProperties extends jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k {
    constructor() {
        super(...arguments);
        this.state = {
            image: new Image(),
            sourceImage: new Image(),
            get ratio() {
                const { naturalWidth, naturalHeight } = this.image;
                return naturalWidth / naturalHeight || 1;
            },
            sizeIsLocked: true,
            marginIsLocked: true,
            values: {
                style: '',
                imageSrc: '',
                borderRadius: 0,
                imageTitle: '',
                imageAlt: '',
                imageLink: '',
                imageLinkOpenInNewTab: false,
                imageWidth: 0,
                imageHeight: 0,
                marginTop: 0,
                marginRight: 0,
                marginBottom: 0,
                marginLeft: 0,
                classes: '',
                id: '',
                align: ''
            }
        };
        this.activeTabState = {
            activeTab: 'Image'
        };
    }
    get form() {
        return new _ui_ui_image_form__WEBPACK_IMPORTED_MODULE_7__/* .UIImagePropertiesForm */ .l(this.j, this.state, this.activeTabState, {
            openImageEditor: () => (0,_utils_open_image_editor__WEBPACK_IMPORTED_MODULE_8__/* .openImageEditorDialog */ .v)(this.j, this.state),
            openImagePopup: target => (0,_utils_open_image_popup__WEBPACK_IMPORTED_MODULE_9__/* .openImagePopup */ .q)(this.j, this.dialog, this.state, target)
        });
    }
    /**
     * Dialog for form
     */
    get dialog() {
        const { j } = this;
        const dialog = j.dlg({
            minWidth: Math.min(400, screen.width),
            minHeight: 590,
            buttons: ['fullsize', 'dialog.close']
        });
        const buttons = this.__buttons;
        buttons.check.onAction(() => {
            (0,_writers__WEBPACK_IMPORTED_MODULE_11__/* .applyValuesToImage */ .j)(j, this.state, this.state.sourceImage);
            j.synchronizeValues();
            dialog.close();
        });
        buttons.remove.onAction(() => {
            j.s.removeNode(this.state.sourceImage);
            dialog.close();
        });
        buttons.cancel.onAction(() => {
            dialog.close();
        });
        dialog.setHeader(j.i18n('Image properties'));
        dialog.setContent(this.form);
        dialog.setFooter([[buttons.cancel, buttons.remove], buttons.check]);
        j.e.on(dialog, 'afterClose', () => {
            if (this.state.image.parentNode &&
                j.o.image.selectImageAfterClose) {
                j.s.select(this.state.sourceImage);
            }
        });
        dialog.setSize(j.o.image.dialogWidth);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.markOwner)(j, dialog.container);
        return dialog;
    }
    get __buttons() {
        const { j } = this;
        return {
            check: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_5__/* .Button */ .$n)(j, 'ok', 'Apply', 'primary'),
            remove: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_5__/* .Button */ .$n)(j, 'bin', 'Delete'),
            cancel: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_5__/* .Button */ .$n)(j, 'cancel', 'Cancel')
        };
    }
    /**
     * Open dialog editing image properties
     *
     * @example
     * ```javascript
     * const editor = Jodit.makeJodit('#editor');
     *     img = editor.createInside.element('img');
     *
     * img.setAttribute('src', 'images/some-image.png');
     * editor.s.insertImage(img);
     * // open the properties of the editing window
     * editor.events.fire('openImageProperties', img);
     * ```
     */
    open() {
        this.activeTabState.activeTab = 'Image';
        this.__lock();
        this.dialog.open().setModal(true).setPosition();
        this.async
            .promise((resolve, reject) => (0,_readers__WEBPACK_IMPORTED_MODULE_10__/* .readValuesFromImage */ .U)(this.j, this.state).then(resolve, reject))
            .catch((e) => {
            if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isAbortError)(e)) {
                this.dialog.message.error(e.message);
            }
        })
            .finally(() => this.__unlock());
        return false;
    }
    __lock() {
        this.dialog.lock();
        this.form.setMod('lock', true);
        Object.values(this.__buttons).forEach(b => (b.state.disabled = true));
    }
    __unlock() {
        this.dialog.unlock();
        this.form.setMod('lock', false);
        Object.values(this.__buttons).forEach(b => (b.state.disabled = false));
    }
    /** @override **/
    afterInit(editor) {
        const self = this;
        editor.e
            .on('afterConstructor changePlace', () => {
            editor.e
                .off(editor.editor, '.imageproperties')
                .on(editor.editor, 'dblclick.imageproperties', (e) => {
                const image = e.target;
                if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(image, 'img')) {
                    return;
                }
                if (editor.o.image.openOnDblClick) {
                    if (this.j.e.fire('openOnDblClick', image) ===
                        false) {
                        return;
                    }
                    self.state.sourceImage = image;
                    self.state.image = image.cloneNode(true);
                    if (!editor.o.readonly) {
                        e.stopImmediatePropagation();
                        e.preventDefault();
                        self.open();
                    }
                }
                else {
                    e.stopImmediatePropagation();
                    editor.s.select(image);
                }
            });
        })
            .on('openImageProperties.imageproperties', (image) => {
            self.state.sourceImage = image;
            this.state.image = image.cloneNode(true);
            this.open();
        });
    }
    onStateValuesImageSrcChange() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
            const { image, values } = this.state;
            if (!image.src) {
                return;
            }
            try {
                this.__lock();
                yield image.decode();
                if (this.state.sizeIsLocked && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isNumeric)(values.imageWidth)) {
                    const w = parseFloat(values.imageWidth.toString());
                    values.imageHeight = Math.round(w / this.state.ratio);
                }
                this.j.e.fire('updateImageProperties.imageproperties', image);
            }
            catch (e) {
                this.j.alert(e.message);
            }
            finally {
                this.__unlock();
            }
        });
    }
    /** @override */
    beforeDestruct(editor) {
        var _a, _b, _c;
        Object.values((_a = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cached)(this, '__buttons')) !== null && _a !== void 0 ? _a : {}).forEach(b => b.destruct());
        (_b = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cached)(this, 'dialog')) === null || _b === void 0 ? void 0 : _b.destruct();
        (_c = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cached)(this, 'form')) === null || _c === void 0 ? void 0 : _c.destruct();
        editor.e.off(editor.editor, '.imageproperties').off('.imageproperties');
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cache
], imageProperties.prototype, "form", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cache
], imageProperties.prototype, "dialog", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.cache
], imageProperties.prototype, "__buttons", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_12__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.image')
], imageProperties.prototype, "onStateValuesImageSrcChange", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('imageProperties', imageProperties);


/***/ }),

/***/ 19627:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* reexport safe */ _file_browser__WEBPACK_IMPORTED_MODULE_0__.V; }
/* harmony export */ });
/* harmony import */ var _file_browser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(140);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:modules/file-browser/README.md]]
 * @packageDocumentation
 * @module modules/file-browser
 */



/***/ }),

/***/ 19633:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   K: function() { return /* binding */ ColorPickerWidget; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53048);
/* harmony import */ var _palette_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(54522);
/* harmony import */ var _palette_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_palette_svg__WEBPACK_IMPORTED_MODULE_3__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .In.set('palette', (_palette_svg__WEBPACK_IMPORTED_MODULE_3___default()));
/**
 * Build color picker
 *
 * @param callback - Callback 'function (color) \{\}'
 * @param coldColor - Color value ex. #fff or rgb(123, 123, 123) or rgba(123, 123, 123, 1)
 * @example
 * ```javascript
 * const tabs = TabsWidget(editor, {
 *    'Text': ColorPickerWidget(editor, function (color) {
 *         box.style.color = color;
 *     }, box.style.color),
 *     'Background': ColorPickerWidget(editor, function (color) {
 *         box.style.backgroundColor = color;
 *     }, box.style.backgroundColor),
 * });
 * ```
 */
const ColorPickerWidget = (editor, callback, coldColor) => {
    const cn = 'jodit-color-picker', valueHex = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.normalizeColor)(coldColor), form = editor.c.div(cn), iconPalette = editor.o.textIcons
        ? `<span>${editor.i18n('palette')}</span>`
        : jodit_core_ui__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .In.get('palette'), eachColor = (colors) => {
        const stack = [];
        if ((0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isPlainObject)(colors)) {
            Object.keys(colors).forEach(key => {
                stack.push(`<div class="${cn}__group ${cn}__group-${key}">`);
                stack.push(eachColor(colors[key]));
                stack.push('</div>');
            });
        }
        else if ((0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isArray)(colors)) {
            colors.forEach(color => {
                stack.push(`<span class='${cn}__color-item ${valueHex === color
                    ? cn + '__color-item_active_true'
                    : ''}' title="${color}" style="background-color:${color}" data-color="${color}"></span>`);
            });
        }
        return stack.join('');
    };
    form.appendChild(editor.c.fromHTML(`<div class="${cn}__groups">${eachColor(editor.o.colors)}</div>`));
    form.appendChild(editor.c.fromHTML(`<div data-ref="extra" class="${cn}__extra"></div>`));
    const { extra } = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.refs)(form);
    if (editor.o.showBrowserColorPicker && (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.hasBrowserColorPicker)()) {
        extra.appendChild(editor.c.fromHTML(`<div class="${cn}__native">${iconPalette}<input type="color" value="#ffffff"/></div>`));
        editor.e.on(form, 'change', (e) => {
            e.stopPropagation();
            const target = e.target;
            if (!target || !target.tagName || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(target, 'input')) {
                return;
            }
            const color = target.value || '';
            if ((0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isFunction)(callback)) {
                callback(color);
            }
            e.preventDefault();
        });
    }
    editor.e.on(form, 'mousedown touchend', (e) => {
        e.stopPropagation();
        e.preventDefault();
        let target = e.target;
        if ((!target ||
            !target.tagName ||
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(target, 'svg') ||
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(target, 'path')) &&
            target.parentNode) {
            target = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(target.parentNode, 'span', editor.editor);
        }
        if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(target, 'span') ||
            !target.classList.contains(cn + '__color-item')) {
            return;
        }
        const color = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.attr)(target, '-color') || '';
        if (callback && (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isFunction)(callback)) {
            callback(color);
        }
    });
    editor.e.fire('afterGenerateColorPicker', form, extra, callback, valueHex);
    return form;
};


/***/ }),

/***/ 20222:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Rc: function() { return /* reexport safe */ _connection_error__WEBPACK_IMPORTED_MODULE_1__.R; },
/* harmony export */   ZW: function() { return /* reexport safe */ _options_error__WEBPACK_IMPORTED_MODULE_2__.Z; },
/* harmony export */   h2: function() { return /* reexport safe */ _abort_error__WEBPACK_IMPORTED_MODULE_0__.h; },
/* harmony export */   rV: function() { return /* reexport safe */ _abort_error__WEBPACK_IMPORTED_MODULE_0__.r; }
/* harmony export */ });
/* harmony import */ var _abort_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(21567);
/* harmony import */ var _connection_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(30495);
/* harmony import */ var _options_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34899);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */





/***/ }),

/***/ 20384:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   y: function() { return /* binding */ extractSelectedPart; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71274);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59101);
/* harmony import */ var jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84976);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * If the selection area is inside an element that matches the commit (suitable relative),
 * but does not completely fill it.
 * Then the method cuts the parent and leaves itself in a copy of the parent (suitable relative) in the middle.
 *
 * @example
 * Apply strong to
 * ```html
 * 	<strong><span>some<font>SELECTED</font>text</span></strong>
 * ```
 * Should extract selection from parent `strong`
 * ```html
 * `<strong><span>some</span></strong><strong><span><font>SELECTED</font></span></strong><strong><span>test</span></strong>
 * ```
 * @private
 */
function extractSelectedPart(wrapper, font, jodit) {
    const range = jodit.s.createRange();
    // Left part
    const leftEdge = (0,jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__/* .isMarker */ .r)(font.previousSibling)
        ? font.previousSibling
        : font;
    range.setStartBefore(wrapper);
    range.setEndBefore(leftEdge);
    extractAndMove(wrapper, range, true);
    // Right part
    const rightEdge = (0,jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__/* .isMarker */ .r)(font.nextSibling) ? font.nextSibling : font;
    range.setStartAfter(rightEdge);
    range.setEndAfter(wrapper);
    extractAndMove(wrapper, range, false);
}
/**
 * Retrieves content before after the selected area, clears it if it is empty, and inserts before after the framed selection
 * @private
 */
function extractAndMove(wrapper, range, left) {
    const fragment = range.extractContents();
    if ((!fragment.textContent || !(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__/* .trim */ .Bq)(fragment.textContent).length) &&
        fragment.firstChild) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.unwrap(fragment.firstChild);
    }
    if (wrapper.parentNode) {
        (0,jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_3__/* .call */ .T1)(left ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.before : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.after, wrapper, fragment);
    }
}


/***/ }),

/***/ 20646:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ removeFormatForSelection; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var _remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(30526);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Remove formatting for all selected elements
 * @private
 */
function removeFormatForSelection(jodit) {
    const { s, editor, createInside } = jodit, { range } = s, left = range.cloneRange(), right = range.cloneRange(), fakeLeft = createInside.fake(), fakeRight = createInside.fake();
    left.collapse(true);
    right.collapse(false);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeInsertNode(left, fakeLeft);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeInsertNode(right, fakeRight);
    range.setStartBefore(fakeLeft);
    range.collapse(true);
    s.selectRange(range);
    (0,_remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_2__/* .removeFormatForCollapsedSelection */ .w)(jodit, fakeLeft);
    range.setEndAfter(fakeRight);
    range.collapse(false);
    s.selectRange(range);
    (0,_remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_2__/* .removeFormatForCollapsedSelection */ .w)(jodit, fakeRight);
    const shouldUnwrap = [];
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.between(fakeLeft, fakeRight, node => {
        if ((0,_remove_format_for_collapsed_selection__WEBPACK_IMPORTED_MODULE_2__/* .isInlineBlock */ .D)(node) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(node, 'a')) {
            shouldUnwrap.push(node);
        }
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(node) && (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(node, 'style')) {
            (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(node, 'style', null);
        }
    });
    shouldUnwrap.forEach(node => jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.unwrap(node));
    const clearParent = (node, left) => {
        if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.findNotEmptySibling(node, left)) {
            const pn = node.parentNode;
            if (pn && pn !== editor && (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(pn, 'style')) {
                (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(pn, 'style', null);
                clearParent(pn, left);
                return true;
            }
        }
    };
    clearParent(fakeLeft, true) && clearParent(fakeRight, false);
    range.setStartAfter(fakeLeft);
    range.setEndBefore(fakeRight);
    s.selectRange(range);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(fakeLeft);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(fakeRight);
}


/***/ }),

/***/ 20703:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $6: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.$6; },
/* harmony export */   F0: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.F0; },
/* harmony export */   XV: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_1__.X; },
/* harmony export */   Yh: function() { return /* reexport safe */ _block_block__WEBPACK_IMPORTED_MODULE_0__.Y; },
/* harmony export */   cY: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.cY; },
/* harmony export */   nE: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.nE; },
/* harmony export */   tS: function() { return /* reexport safe */ _inputs__WEBPACK_IMPORTED_MODULE_2__.tS; }
/* harmony export */ });
/* harmony import */ var _block_block__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(68752);
/* harmony import */ var _form__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28709);
/* harmony import */ var _inputs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47165);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module ui/form
 */





/***/ }),

/***/ 20784:
/***/ (function(module) {

module.exports = "<svg viewBox=\"0 0 48 48\" xmlns=\"http://www.w3.org/2000/svg\"> <path stroke=\"null\" d=\"m42.276011,26.302547c0.098397,-0.76605 0.172194,-1.54407 0.172194,-2.33406s-0.073797,-1.56801 -0.172194,-2.33406l5.202718,-3.961917c0.467384,-0.359086 0.602679,-1.005441 0.29519,-1.532101l-4.919828,-8.29489c-0.307489,-0.51469 -0.947067,-0.730142 -1.500548,-0.51469l-6.125186,2.405877c-1.266856,-0.945594 -2.656707,-1.747553 -4.157255,-2.357999l-0.922468,-6.343855c-0.110696,-0.562568 -0.614979,-1.005441 -1.229957,-1.005441l-9.839656,0c-0.614979,0 -1.119261,0.442873 -1.217657,1.005441l-0.922468,6.343855c-1.500548,0.610446 -2.890399,1.400436 -4.157255,2.357999l-6.125186,-2.405877c-0.553481,-0.203482 -1.193058,0 -1.500548,0.51469l-4.919828,8.29489c-0.307489,0.51469 -0.172194,1.161045 0.29519,1.532101l5.190419,3.961917c-0.098397,0.76605 -0.172194,1.54407 -0.172194,2.33406s0.073797,1.56801 0.172194,2.33406l-5.190419,3.961917c-0.467384,0.359086 -0.602679,1.005441 -0.29519,1.532101l4.919828,8.29489c0.307489,0.51469 0.947067,0.730142 1.500548,0.51469l6.125186,-2.405877c1.266856,0.945594 2.656707,1.747553 4.157255,2.357999l0.922468,6.343855c0.098397,0.562568 0.602679,1.005441 1.217657,1.005441l9.839656,0c0.614979,0 1.119261,-0.442873 1.217657,-1.005441l0.922468,-6.343855c1.500548,-0.610446 2.890399,-1.400436 4.157255,-2.357999l6.125186,2.405877c0.553481,0.203482 1.193058,0 1.500548,-0.51469l4.919828,-8.29489c0.307489,-0.51469 0.172194,-1.161045 -0.29519,-1.532101l-5.190419,-3.961917zm-18.277162,6.044617c-4.759934,0 -8.609699,-3.746465 -8.609699,-8.378677s3.849766,-8.378677 8.609699,-8.378677s8.609699,3.746465 8.609699,8.378677s-3.849766,8.378677 -8.609699,8.378677z\"/> </svg>"

/***/ }),

/***/ 20797:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(72197);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(36115);
/* harmony import */ var _icons_ol_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(40037);
/* harmony import */ var _icons_ol_svg__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_icons_ol_svg__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _icons_ul_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(83207);
/* harmony import */ var _icons_ul_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_icons_ul_svg__WEBPACK_IMPORTED_MODULE_4__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





const memoExec = (jodit, _, { control }) => {
    var _a;
    const key = `button${control.command}`;
    const value = (_a = (control.args && control.args[0])) !== null && _a !== void 0 ? _a : (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_0__/* .dataBind */ .m)(jodit, key);
    (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_0__/* .dataBind */ .m)(jodit, key, value);
    jodit.execCommand(control.command, false, value === 'default' ? null : value);
};
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_1__/* .Icon */ .I.set('ol', (_icons_ol_svg__WEBPACK_IMPORTED_MODULE_3___default())).set('ul', (_icons_ul_svg__WEBPACK_IMPORTED_MODULE_4___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_2__/* .Config */ .T.prototype.controls.ul = {
    command: 'insertUnorderedList',
    tags: ['ul'],
    tooltip: 'Insert Unordered List',
    list: {
        default: 'Default',
        circle: 'Circle',
        disc: 'Dot',
        square: 'Quadrate'
    },
    exec: memoExec
};
jodit_config__WEBPACK_IMPORTED_MODULE_2__/* .Config */ .T.prototype.controls.ol = {
    command: 'insertOrderedList',
    tags: ['ol'],
    tooltip: 'Insert Ordered List',
    list: {
        default: 'Default',
        'lower-alpha': 'Lower Alpha',
        'lower-greek': 'Lower Greek',
        'lower-roman': 'Lower Roman',
        'upper-alpha': 'Upper Alpha',
        'upper-roman': 'Upper Roman'
    },
    exec: memoExec
};


/***/ }),

/***/ 21195:
/***/ (function(module) {

module.exports["default"] = ["なにかタイプしてください","Joditについて","Jodit Editor","Jodit ユーザーズ・ガイド","詳しい使い方","ライセンス詳細についてはJodit Webサイトを確認ください：","フルバージョンを購入","Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.","Anchor","新しいタブで開く","エディターのサイズ（フル/ノーマル）","書式をクリア","テキストの色","やり直し","元に戻す","太字","斜体","箇条書き","番号付きリスト","中央揃え","両端揃え","左揃え","右揃え","区切り線を挿入","画像を挿入","ファイルを挿入","Youtube/Vimeo 動画","リンクを挿入","フォントサイズ","フォント","テキストのスタイル","指定なし","タイトル1","タイトル2","タイトル3","タイトル4","引用","コード","挿入","表を挿入","インデント減","インデント増","特殊文字を選択","特殊文字を挿入","書式を貼付け","編集モード切替え","マージン","上","右","下","左","スタイル","クラス","配置","右寄せ","中央寄せ","左寄せ","指定なし","ソース","タイトル","代替テキスト","リンク","新しいタブで開く","画像","ファイル","高度な設定","画像のプロパティー","キャンセル","確定","File Browser","Error on load list","Error on load folders","Are you sure?","Enter Directory name","Create directory","type name","ここに画像をドロップ","ここにファイルをドロップ","or クリック","代替テキスト","アップロード","ブラウズ","背景","文字","上","中央","下","左に列を挿入","右に列を挿入","上に行を挿入","下に行を挿入","表を削除","行を削除","列を削除","セルを空にする","文字数: %d","単語数: %d","取り消し線","下線","上付き文字","下付き文字","切り取り","すべて選択","Pause","検索","置換","交換","貼付け","選択した内容を貼付け","source","bold","italic","brush","link","undo","redo","table","image","eraser","paragraph","fontsize","video","font","about","print","underline","strikethrough","indent","outdent","fullsize","shrink","分割線","箇条書き","番号付きリスト","切り取り","すべて選択","埋め込みコード","リンクを開く","リンクを編集","No follow","リンク解除","更新","鉛筆","サイトを確認","URL","編集","水平方向の配置","Filter","Sort by changed","Sort by name","Sort by size","Add folder","リセット","保存","Save as ...","リサイズ","Crop","幅","高さ","縦横比を保持","はい","いいえ","移除","選択","選択: %s","垂直方向の配置","分割","セルの結合","列を追加","行を追加",null,"削除","セルの分割（垂直方向）","セルの分割（水平方向）","境界線","HTMLコードを保持しますか？","HTMLで貼付け","HTMLを保持","HTMLをテキストにする","テキストだけ","You can only edit your own images. Download this image on the host?","The image has been successfully uploaded to the host!","パレット","There are no files","Rename","Enter new name","プレビュー","ダウンロード","貼り付け","お使いのブラウザはクリップボードを使用できません","コピー","copy","角の丸み","全て表示","適用","まだこの分野","を入力してくださいウェブアドレス","デフォルト","白丸","黒丸","四角","見","探前","由来","The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?","Word Paste Detected","Clean","クラス名を挿入","カスタムサイズ変更のためのAltキーを押します",null,null,null]

/***/ }),

/***/ 21329:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   B: function() { return /* binding */ formTemplate; }
/* harmony export */ });
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35265);
/* harmony import */ var jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20703);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


const formTemplate = (editor) => {
    const { openInNewTabCheckbox, noFollowCheckbox, modeClassName, selectSizeClassName, selectMultipleClassName, selectOptionsClassName } = editor.o.link;
    return new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIForm */ .XV(editor, [
        new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIBlock */ .Yh(editor, [
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .tS(editor, {
                name: 'url',
                type: 'text',
                ref: 'url_input',
                label: 'URL',
                placeholder: 'http://',
                required: true
            })
        ]),
        new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIBlock */ .Yh(editor, [
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .tS(editor, {
                name: 'content',
                ref: 'content_input',
                label: 'Text'
            })
        ], {
            ref: 'content_input_box'
        }),
        modeClassName
            ? new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIBlock */ .Yh(editor, [
                (() => {
                    if (modeClassName === 'input') {
                        return new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .tS(editor, {
                            name: 'className',
                            ref: 'className_input',
                            label: 'Class name'
                        });
                    }
                    if (modeClassName === 'select') {
                        return new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UISelect */ .$6(editor, {
                            name: 'className',
                            ref: 'className_select',
                            label: 'Class name',
                            size: selectSizeClassName,
                            multiple: selectMultipleClassName,
                            options: selectOptionsClassName
                        });
                    }
                    return null;
                })()
            ])
            : null,
        openInNewTabCheckbox
            ? new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UICheckbox */ .cY(editor, {
                name: 'target',
                ref: 'target_checkbox',
                label: 'Open in new tab'
            })
            : null,
        noFollowCheckbox
            ? new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UICheckbox */ .cY(editor, {
                name: 'nofollow',
                ref: 'nofollow_checkbox',
                label: 'No follow'
            })
            : null,
        new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_1__/* .UIBlock */ .Yh(editor, [
            new jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_0__/* .UIButton */ .lD(editor, {
                name: 'unlink',
                variant: 'default',
                text: 'Unlink'
            }),
            new jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_0__/* .UIButton */ .lD(editor, {
                name: 'insert',
                type: 'submit',
                variant: 'primary',
                text: 'Insert'
            })
        ], {
            align: 'full'
        })
    ]);
};


/***/ }),

/***/ 21567:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ abort; },
/* harmony export */   r: function() { return /* binding */ isAbort; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_abort_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99951);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */

function abort(message = 'Aborted') {
    return new DOMException(message, 'AbortError');
}
/**
 * @deprecated use `isAbortError` instead
 */
const isAbort = jodit_core_helpers_checker_is_abort_error__WEBPACK_IMPORTED_MODULE_0__/* .isAbortError */ .z;


/***/ }),

/***/ 21811:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: function() { return /* binding */ isHtmlFromWord; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Detect if string is HTML from MS Word or Excel
 */
function isHtmlFromWord(data) {
    return (data.search(/<meta.*?Microsoft Excel\s[\d].*?>/) !== -1 ||
        data.search(/<meta.*?Microsoft Word\s[\d].*?>/) !== -1 ||
        (data.search(/style="[^"]*mso-/) !== -1 && data.search(/<font/) !== -1));
}


/***/ }),

/***/ 22664:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   autobind: function() { return /* reexport safe */ _autobind_autobind__WEBPACK_IMPORTED_MODULE_0__.d; },
/* harmony export */   cache: function() { return /* reexport safe */ _cache_cache__WEBPACK_IMPORTED_MODULE_1__.PP; },
/* harmony export */   cacheHTML: function() { return /* reexport safe */ _cache_cache__WEBPACK_IMPORTED_MODULE_1__.OK; },
/* harmony export */   cached: function() { return /* reexport safe */ _cache_cache__WEBPACK_IMPORTED_MODULE_1__.PO; },
/* harmony export */   component: function() { return /* reexport safe */ _component_component__WEBPACK_IMPORTED_MODULE_2__.s; },
/* harmony export */   debounce: function() { return /* reexport safe */ _debounce_debounce__WEBPACK_IMPORTED_MODULE_3__.s; },
/* harmony export */   derive: function() { return /* reexport safe */ _derive_derive__WEBPACK_IMPORTED_MODULE_4__.C; },
/* harmony export */   getPropertyDescriptor: function() { return /* reexport safe */ _watch_watch__WEBPACK_IMPORTED_MODULE_10__.N; },
/* harmony export */   hook: function() { return /* reexport safe */ _hook_hook__WEBPACK_IMPORTED_MODULE_5__.A; },
/* harmony export */   idle: function() { return /* reexport safe */ _idle_idle__WEBPACK_IMPORTED_MODULE_6__.N; },
/* harmony export */   nonenumerable: function() { return /* reexport safe */ _nonenumerable_nonenumerable__WEBPACK_IMPORTED_MODULE_7__.m; },
/* harmony export */   persistent: function() { return /* reexport safe */ _persistent_persistent__WEBPACK_IMPORTED_MODULE_8__.y; },
/* harmony export */   throttle: function() { return /* reexport safe */ _debounce_debounce__WEBPACK_IMPORTED_MODULE_3__.n; },
/* harmony export */   wait: function() { return /* reexport safe */ _wait_wait__WEBPACK_IMPORTED_MODULE_9__.u; },
/* harmony export */   watch: function() { return /* reexport safe */ _watch_watch__WEBPACK_IMPORTED_MODULE_10__.w; }
/* harmony export */ });
/* harmony import */ var _autobind_autobind__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11961);
/* harmony import */ var _cache_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87875);
/* harmony import */ var _component_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24767);
/* harmony import */ var _debounce_debounce__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37075);
/* harmony import */ var _derive_derive__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1963);
/* harmony import */ var _hook_hook__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(71151);
/* harmony import */ var _idle_idle__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(86285);
/* harmony import */ var _nonenumerable_nonenumerable__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(48791);
/* harmony import */ var _persistent_persistent__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(33087);
/* harmony import */ var _wait_wait__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(48647);
/* harmony import */ var _watch_watch__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(66927);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/decorators/README.md]]
 * @packageDocumentation
 * @module decorators
 */













/***/ }),

/***/ 23132:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   p: function() { return /* binding */ Confirm; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92032);
/* harmony import */ var jodit_modules_dialog_dialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58006);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Show `confirm` dialog. Work without Jodit object
 *
 * @param title - Title or callback
 * @param callback - callback. The first argument is the value entered
 * @example
 * ```javascript
 * Jodit.Confirm("Are you sure?", "Confirm Dialog", function (yes) {
 *     if (yes) {
 *         // do something
 *     }
 * });
 * ```
 */
function Confirm(msg, title, callback) {
    const dialog = this instanceof jodit_modules_dialog_dialog__WEBPACK_IMPORTED_MODULE_1__/* .Dialog */ .l
        ? this
        : new jodit_modules_dialog_dialog__WEBPACK_IMPORTED_MODULE_1__/* .Dialog */ .l({ closeOnClickOverlay: true }), $div = dialog.c.fromHTML('<form class="jodit-dialog_prompt"></form>'), $label = dialog.c.element('label');
    if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(title)) {
        callback = title;
        title = undefined;
    }
    $label.appendChild(dialog.c.fromHTML(msg));
    $div.appendChild($label);
    const action = (yes) => () => {
        if (!callback || callback(yes) !== false) {
            dialog.close();
        }
    };
    const $cancel = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__/* .Button */ .$n)(dialog, 'cancel', 'Cancel');
    const $ok = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__/* .Button */ .$n)(dialog, 'ok', 'Yes');
    $cancel.onAction(action(false));
    $ok.onAction(action(true));
    dialog.e.on($div, 'submit', () => {
        action(true)();
        return false;
    });
    dialog.setFooter([$ok, $cancel]);
    dialog.open($div, title || '&nbsp;', true, true);
    $ok.focus();
    return dialog;
}


/***/ }),

/***/ 24654:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.image = {
    dialogWidth: 600,
    openOnDblClick: true,
    editSrc: true,
    useImageEditor: true,
    editTitle: true,
    editAlt: true,
    editLink: true,
    editSize: true,
    editBorderRadius: true,
    editMargins: true,
    editClass: true,
    availableClasses: [],
    editStyle: true,
    editId: true,
    editAlign: true,
    showPreview: true,
    selectImageAfterClose: true
};


/***/ }),

/***/ 24767:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   s: function() { return /* binding */ component; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Decorate components and set status isReady after constructor
 * @param constructorFunction - Component constructor class
 */
function component(constructorFunction) {
    class newConstructorFunction extends constructorFunction {
        constructor(...args) {
            super(...args);
            const isRootConstructor = this.constructor === newConstructorFunction;
            // We can add a decorator to multiple classes in a chain.
            // Status should be set only as root
            if (isRootConstructor) {
                // In some es/minimizer builds, JS instantiates the original class rather than the new constructor
                if (!(this instanceof newConstructorFunction)) {
                    Object.setPrototypeOf(this, newConstructorFunction.prototype);
                }
                this.setStatus('ready');
            }
        }
    }
    return newConstructorFunction;
}


/***/ }),

/***/ 24772:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 24 24\"> <path stroke-width=\"0\" d=\"M22,20.6L3.4,2H8V0H0v8h2V3.4L20.6,22H16v2h8v-8h-2V20.6z M16,0v2h4.7l-6.3,6.3l1.4,1.4L22,3.5V8h2V0H16z M8.3,14.3L2,20.6V16H0v8h8v-2H3.5l6.3-6.3L8.3,14.3z\"/> </svg>"

/***/ }),

/***/ 24834:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   w: function() { return /* binding */ Storage; }
/* harmony export */ });
/* unused harmony export StorageKey */
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83260);
/* harmony import */ var _engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17800);
/* harmony import */ var _engines_memory_storage_provider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2788);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



const StorageKey = 'Jodit_';
class Storage {
    set(key, value) {
        this.provider.set((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__/* .camelCase */ .x)(this.prefix + key), value);
        return this;
    }
    delete(key) {
        this.provider.delete((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__/* .camelCase */ .x)(this.prefix + key));
        return this;
    }
    get(key) {
        return this.provider.get((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__/* .camelCase */ .x)(this.prefix + key));
    }
    exists(key) {
        return this.provider.exists((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_1__/* .camelCase */ .x)(this.prefix + key));
    }
    clear() {
        this.provider.clear();
        return this;
    }
    constructor(provider, suffix) {
        this.provider = provider;
        this.prefix = StorageKey;
        if (suffix) {
            this.prefix += suffix;
        }
    }
    static makeStorage(persistent = false, suffix) {
        let provider;
        if (persistent && (0,_engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_0__/* .canUsePersistentStorage */ .I)()) {
            provider = new _engines_local_storage_provider__WEBPACK_IMPORTED_MODULE_0__/* .LocalStorageProvider */ .O(StorageKey + suffix);
        }
        if (!provider) {
            provider = new _engines_memory_storage_provider__WEBPACK_IMPORTED_MODULE_2__/* .MemoryStorageProvider */ .M();
        }
        return new Storage(provider, suffix);
    }
}


/***/ }),

/***/ 24863:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ form; }
/* harmony export */ });
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(53048);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

const jie = 'jodit-image-editor';
const gi = jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__/* .Icon */ .In.get.bind(jodit_core_ui__WEBPACK_IMPORTED_MODULE_0__/* .Icon */ .In);
const act = (el, className = 'jodti-image-editor_active') => el ? className : '';
const form = (editor, o) => {
    const i = editor.i18n.bind(editor);
    const switcher = (label, ref, active = true) => `<div class="jodit-form__group">
			<label class="jodit-switcher-wrapper">
				<span class='jodit-switcher'>
					<input ${act(active, 'checked')} data-ref="${ref}" type="checkbox"/>
					<span class="jodit-switcher__slider"></span>
				</span>
				<span>${i(label)}</span>
			</label>
	</div>`;
    return editor.create.fromHTML(`<form class="${jie} jodit-properties">
		<div class="jodit-grid jodit-grid_xs-column">
			<div class="jodit_col-lg-3-4 jodit_col-sm-5-5">
			${o.resize
        ? `<div class="${jie}__area ${jie}__area_resize ${jie}_active">
							<div data-ref="resizeBox" class="${jie}__box"></div>
							<div class="${jie}__resizer">
								<i class="jodit_bottomright"></i>
							</div>
						</div>`
        : ''}
			${o.crop
        ? `<div class="${jie}__area ${jie}__area_crop ${act(!o.resize)}">
							<div data-ref="cropBox" class="${jie}__box">
								<div class="${jie}__croper">
									<i class="jodit_bottomright"></i>
									<i class="${jie}__sizes"></i>
								</div>
							</div>
						</div>`
        : ''}
			</div>
			<div class="jodit_col-lg-1-4 jodit_col-sm-5-5">
			${o.resize
        ? `<div data-area="resize" class="${jie}__slider ${jie}_active">
							<div class="${jie}__slider-title">
								${gi('resize')}
								${i('Resize')}
							</div>
							<div class="${jie}__slider-content">
								<div class="jodit-form__group">
									<label>
										${i('Width')}
									</label>
									<input type="number" data-ref="widthInput" class="jodit-input"/>
								</div>
								<div class="jodit-form__group">
									<label>
										${i('Height')}
									</label>
									<input type="number" data-ref="heightInput" class="jodit-input"/>
								</div>
								${switcher('Keep Aspect Ratio', 'keepAspectRatioResize')}
							</div>
						</div>`
        : ''}
			${o.crop
        ? `<div data-area="crop" class="${jie}__slider ${act(!o.resize)}'">
							<div class="${jie}__slider-title">
								${gi('crop')}
								${i('Crop')}
							</div>
							<div class="${jie}__slider-content">
								${switcher('Keep Aspect Ratio', 'keepAspectRatioCrop')}
							</div>
						</div>`
        : ''}
			</div>
		</div>
	</form>`);
};


/***/ }),

/***/ 25090:
/***/ (function(module) {

module.exports["default"] = ["Ecrivez ici","A propos de Jodit","Editeur Jodit","Guide de l'utilisateur","Aide détaillée à l'utilisation","Consulter la licence sur notre site web:","Acheter la version complète","Copyright © XDSoft.net - Chupurnov Valeriy. Tous droits réservés.","Ancre","Ouvrir dans un nouvel onglet","Ouvrir l'éditeur en pleine page","Supprimer le formattage","Modifier la couleur du fond ou du texte","Refaire","Défaire","Gras","Italique","Liste non ordonnée","Liste ordonnée","Centrer","Justifier","Aligner à gauche ","Aligner à droite","Insérer une ligne horizontale","Insérer une image","Insérer un fichier","Insérer une vidéo","Insérer un lien","Taille des caractères","Famille des caractères","Bloc formatté","Normal","Titre 1","Titre 2","Titre 3","Titre 4","Citation","Code","Insérer","Insérer un tableau","Diminuer le retrait","Retrait plus","Sélectionnez un caractère spécial","Insérer un caractère spécial","Cloner le format","Mode wysiwyg <-> code html","Marges","haut","droite","Bas","gauche","Styles","Classes","Alignement","Droite","Centre","Gauche","--Non disponible--","Source","Titre","Alternative","Lien","Ouvrir le lien dans un nouvel onglet","Image","fichier","Avancé","Propriétés de l'image","Annuler","OK","Explorateur de fichiers","Erreur de liste de chargement","Erreur de dossier de chargement","Etes-vous sûrs ?","Entrer le nom de dossier","Créer un dossier","type de fichier","Coller une image","Déposer un fichier","ou cliquer","Texte de remplacemement","Charger","Chercher","Arrière-plan","Texte","Haut","Milieu","Bas","Insérer une colonne avant","Insérer une colonne après","Insérer une ligne au dessus","Insérer une ligne en dessous","Supprimer le tableau","Supprimer la ligne","Supprimer la colonne","Vider la cellule","Symboles: %d","Mots: %d","Barrer","Souligner","exposant","indice","Couper la sélection","Tout sélectionner","Pause","Rechercher","Remplacer par","Remplacer","Coller","Choisissez le contenu à coller","la source","gras","italique","pinceau","lien","annuler","refaire","tableau","image","gomme","clause","taille de police","Video","police","à propos de l'éditeur","impression","souligné","barré","indentation","retrait","taille réelle","taille conventionnelle","la ligne","Liste","Liste numérotée","Couper","Sélectionner tout",null,"Ouvrir le lien","Modifier le lien","Attribut Nofollow","Supprimer le lien","Mettre à jour","Pour éditer","Voir","URL",null,"Alignement horizontal","Filtre","Trier par modification","Trier par nom","Trier par taille","Créer le dossier","Restaurer","Sauvegarder","Enregistrer sous","Changer la taille","Taille de garniture","Largeur","Hauteur","Garder les proportions","Oui","Non","Supprimer","Mettre en évidence","Mettre en évidence: %s","Alignement vertical","Split","aller","Ajouter une colonne","Ajouter une rangée",null,"Effacer","Split vertical","Split horizontal","Bordure","Votre texte que vous essayez de coller est similaire au HTML. Collez-le en HTML?","Coller en HTML?","Sauvegarder l'original","Coller en tant que texte","Coller le texte seulement","Vous ne pouvez éditer que vos propres images. Téléchargez cette image sur l'hôte?","L'image a été téléchargée avec succès sur le serveur!","Palette","Il n'y a aucun fichier dans ce répertoire.","renommer","Entrez un nouveau nom","Aperçu","Télécharger","Coller à partir du presse-papiers","Votre navigateur ne prend pas en charge l'accès direct au presse-papiers.","Copier la sélection","copie","Rayon des bordures","Afficher tous","Appliquer","Veuillez remplir ce champ","Veuillez entrer une adresse web","Par défaut","Cercle","Point","Quadratique","Trouver","Précédent","Suivant","Le contenu que vous insérez provient d'un document Microsoft Word / Excel. Voulez-vous enregistrer le format ou l'effacer?","C'est peut-être un fragment de Word ou Excel","Nettoyer","Insérer un nom de classe","Appuyez sur Alt pour un redimensionnement personnalisé",null,null,null]

/***/ }),

/***/ 25182:
/***/ (function(module) {

module.exports["default"] = ["输入一些内容","关于Jodit","Jodit Editor","开发者指南","使用帮助","有关许可证的信息，请访问我们的网站：","购买完整版本","Copyright © XDSoft.net - Chupurnov Valeriy. 版权所有","Anchor","在新窗口打开","全屏编辑","清除样式","颜色","重做","撤销","粗体","斜体","符号列表","编号","居中","对齐文本","左对齐","右对齐","分割线","图片","文件","视频","链接","字号","字体","格式块","默认","标题1","标题2","标题3","标题4","引用","代码","插入","表格","减少缩进","增加缩进","选择特殊符号","特殊符号","格式复制","改变模式","外边距（Margins）","top","right","bottom","left","样式","Classes","对齐方式","居右","居中","居左","无","Src","Title","Alternative","Link","在新窗口打开链接","图片","file","高级","图片属性","取消","确定","文件管理","加载list错误","加载folders错误","你确定吗？","输入路径","创建路径","type name","拖动图片到此","拖动文件到此","或点击","Alternative text","上传","浏览","背景色","文字","顶部","中间","底部","在之前插入列","在之后插入列","在之前插入行","在之后插入行","删除表格","删除行","删除列","清除内容","字符数: %d","单词数: %d","删除线","下划线","上标","下标","剪切","全选","Break","查找","替换为","替换","粘贴","选择内容并粘贴","源码","粗体","斜体","颜色","链接","撤销","重做","表格","图片","橡皮擦","段落","字号","视频","字体","关于","打印","下划线","上出现","增加缩进","减少缩进","全屏","收缩","分割线","无序列表","顺序列表","剪切","全选","嵌入代码","打开链接","编辑链接","No follow","取消链接","更新","铅笔","预览","URL","编辑","水平对齐","筛选","修改时间排序","名称排序","大小排序","新建文件夹","重置","保存","保存为","调整大小","剪切","宽","高","保持长宽比","是","不","移除","选择","选择: %s","垂直对齐","拆分","合并","添加列","添加行",null,"删除","垂直拆分","水平拆分","边框","你粘贴的文本是一段html代码，是否保留源格式","html粘贴","保留源格式","把html代码视为普通文本","只保留文本","你只能编辑你自己的图片。Download this image on the host?","图片上传成功","调色板","此目录中沒有文件。","重命名","输入新名称","预览","下载","粘贴从剪贴板","你浏览器不支持直接访问的剪贴板。","复制选中内容","复制","边界半径","显示所有","应用","请填写这个字段","请输入一个网址","默认","圆圈","点","方形","搜索","查找上一个","查找下一个","正在粘贴 Word/Excel 的文本，是否保留源格式？","文本粘贴","匹配目标格式","插入班级名称","按Alt自定义调整大小",null,null,null]

/***/ }),

/***/ 25376:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Q: function() { return /* binding */ isPlainObject; }
/* harmony export */ });
/* harmony import */ var _is_window__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(76776);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Check if element is simple plaint object
 */
function isPlainObject(obj) {
    if (!obj || typeof obj !== 'object' || obj.nodeType || (0,_is_window__WEBPACK_IMPORTED_MODULE_0__/* .isWindow */ .l)(obj)) {
        return false;
    }
    return !(obj.constructor &&
        !{}.hasOwnProperty.call(obj.constructor.prototype, 'isPrototypeOf'));
}


/***/ }),

/***/ 25501:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1744 1408q33 0 42 18.5t-11 44.5l-126 162q-20 26-49 26t-49-26l-126-162q-20-26-11-44.5t42-18.5h80v-1024h-80q-33 0-42-18.5t11-44.5l126-162q20-26 49-26t49 26l126 162q20 26 11 44.5t-42 18.5h-80v1024h80zm-1663-1279l54 27q12 5 211 5 44 0 132-2t132-2q36 0 107.5.5t107.5.5h293q6 0 21 .5t20.5 0 16-3 17.5-9 15-17.5l42-1q4 0 14 .5t14 .5q2 112 2 336 0 80-5 109-39 14-68 18-25-44-54-128-3-9-11-48t-14.5-73.5-7.5-35.5q-6-8-12-12.5t-15.5-6-13-2.5-18-.5-16.5.5q-17 0-66.5-.5t-74.5-.5-64 2-71 6q-9 81-8 136 0 94 2 388t2 455q0 16-2.5 71.5t0 91.5 12.5 69q40 21 124 42.5t120 37.5q5 40 5 50 0 14-3 29l-34 1q-76 2-218-8t-207-10q-50 0-151 9t-152 9q-3-51-3-52v-9q17-27 61.5-43t98.5-29 78-27q19-42 19-383 0-101-3-303t-3-303v-117q0-2 .5-15.5t.5-25-1-25.5-3-24-5-14q-11-12-162-12-33 0-93 12t-80 26q-19 13-34 72.5t-31.5 111-42.5 53.5q-42-26-56-44v-383z\"/> </svg>"

/***/ }),

/***/ 26150:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: function() { return /* binding */ attr; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(449);
/* harmony import */ var _css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38322);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Alias for `elm.getAttribute` but if set second argument `-{key}`
 * it will also check `data-{key}` attribute
 * if set `value` it is alias for setAttribute with the same logic
 */
function attr(elm, keyOrAttributes, value) {
    if (!elm || !(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .Tn)(elm.getAttribute)) {
        return null;
    }
    if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .Kg)(keyOrAttributes)) {
        Object.keys(keyOrAttributes).forEach(key => {
            const value = keyOrAttributes[key];
            if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_0__/* .isPlainObject */ .Qd)(value) && key === 'style') {
                (0,_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(elm, value);
            }
            else {
                if (key === 'className') {
                    key = 'class';
                }
                attr(elm, key, value);
            }
        });
        return null;
    }
    let key = (0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_2__/* .CamelCaseToKebabCase */ .N)(keyOrAttributes);
    if (/^-/.test(key)) {
        const res = attr(elm, `data${key}`);
        if (res) {
            return res;
        }
        key = key.substr(1);
    }
    if (value !== undefined) {
        if (value == null) {
            elm.hasAttribute(key) && elm.removeAttribute(key);
        }
        else {
            let replaceValue = value.toString();
            if (elm.nodeName === 'IMG' &&
                (key === 'width' || key === 'height')) {
                replaceValue = replaceValue.replace('px', '');
            }
            elm.setAttribute(key, replaceValue);
            return replaceValue;
        }
    }
    return elm.getAttribute(key);
}


/***/ }),

/***/ 26328:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: function() { return /* binding */ safeHTML; },
/* harmony export */   v: function() { return /* binding */ sanitizeHTMLElement; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */


/**
 * Removes dangerous constructs from HTML
 */
function safeHTML(box, options) {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(box) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isFragment(box)) {
        return;
    }
    if (options.removeOnError) {
        sanitizeHTMLElement(box);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.$$)('[onerror]', box).forEach(elm => sanitizeHTMLElement(elm, options));
    }
    if (options.safeJavaScriptLink) {
        sanitizeHTMLElement(box);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.$$)('a[href^="javascript"]', box).forEach(elm => sanitizeHTMLElement(elm, options));
    }
}
function sanitizeHTMLElement(elm, { safeJavaScriptLink, removeOnError } = {
    safeJavaScriptLink: true,
    removeOnError: true
}) {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(elm)) {
        return false;
    }
    let effected = false;
    if (removeOnError && elm.hasAttribute('onerror')) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'onerror', null);
        effected = true;
    }
    const href = elm.getAttribute('href');
    if (safeJavaScriptLink && href && href.trim().indexOf('javascript') === 0) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(elm, 'href', location.protocol + '//' + href);
        effected = true;
    }
    return effected;
}


/***/ }),

/***/ 26396:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   M: function() { return /* binding */ align; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_utils_align__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40080);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38322);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




const align = {
    name: 'left',
    childTemplate: (_, __, value) => value,
    list: ['Left', 'Right', 'Center', 'Normal'],
    exec: (editor, elm, { control }) => {
        if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, new Set(['img', 'jodit', 'jodit-media']))) {
            return;
        }
        const command = control.args && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .K)(control.args[0])
            ? control.args[0].toLowerCase()
            : '';
        if (!command) {
            return false;
        }
        (0,jodit_core_helpers_utils_align__WEBPACK_IMPORTED_MODULE_1__/* .hAlignElement */ .Mr)(elm, command);
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(elm, new Set(['jodit', 'jodit-media'])) &&
            elm.firstElementChild) {
            (0,jodit_core_helpers_utils_align__WEBPACK_IMPORTED_MODULE_1__/* .hAlignElement */ .Mr)(elm.firstElementChild, command);
        }
        editor.synchronizeValues();
        editor.e.fire('recalcPositionPopup');
    },
    tooltip: 'Horizontal align'
};
/* harmony default export */ __webpack_exports__.A = ([
    {
        name: 'delete',
        icon: 'bin',
        tooltip: 'Delete',
        exec: (editor, image) => {
            image && editor.s.removeNode(image);
        }
    },
    {
        name: 'pencil',
        exec(editor, current) {
            const tagName = current.tagName.toLowerCase();
            if (tagName === 'img') {
                editor.e.fire('openImageProperties', current);
            }
        },
        tooltip: 'Edit'
    },
    {
        name: 'valign',
        list: ['Top', 'Middle', 'Bottom', 'Normal'],
        tooltip: 'Vertical align',
        exec: (editor, image, { control }) => {
            if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(image, 'img')) {
                return;
            }
            const command = control.args && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .K)(control.args[0])
                ? control.args[0].toLowerCase()
                : '';
            if (!command) {
                return false;
            }
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_3__/* .css */ .A)(image, 'vertical-align', command === 'normal' ? '' : command);
            editor.e.fire('recalcPositionPopup');
        }
    },
    align
]);


/***/ }),

/***/ 26538:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: function() { return /* binding */ Uploader; }
/* harmony export */ });
/* harmony import */ var jodit_core_component___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36115);
/* harmony import */ var jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(74340);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(77334);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







class Uploader extends jodit_core_component___WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    get j() {
        return this.jodit;
    }
    /** @override */
    className() {
        return 'Uploader';
    }
    get o() {
        return this.options;
    }
    /**
     * It sets the path for uploading files
     */
    setPath(path) {
        this.path = path;
        return this;
    }
    /**
     * It sets the source for connector
     */
    setSource(source) {
        this.source = source;
        return this;
    }
    /**
     * Set the handlers Drag and Drop to `$form`
     *
     * @param form - Form or any Node on which you can drag and drop the file. In addition will be processed
     * <code>&lt;input type="file" &gt;</code>
     * @param handlerSuccess - The function be called when a successful uploading files
     * to the server
     * @param handlerError - The function that will be called during a failed download files a server
     * @example
     * ```javascript
     * var $form = jQuery('<form><input type="text" typpe="file"></form>');
     * jQuery('body').append($form);
     * Jodit.editors.someidfoeditor.uploader.bind($form[0], function (files) {
     *     var i;
     *     for (i = 0; i < data.files.length; i += 1) {
     *         parent.s.insertImage(data.files[i])
     *     }
     * });
     * ```
     */
    bind(form, handlerSuccess, handlerError) {
        const onFinally = () => {
            form.classList.remove('jodit_drag_hover');
        };
        const self = this, onPaste = (e) => {
            let i, file, extension;
            const cData = e.clipboardData;
            const processData = (formdata) => {
                if (file) {
                    formdata.append('extension', extension);
                    formdata.append('mimetype', file.type);
                }
            };
            // send data on server
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_IE && (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasFiles */ .YQ)(cData)) {
                (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .sendFiles */ ._9)(self, cData.files, handlerSuccess, handlerError).finally(onFinally);
                return false;
            }
            if (jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_IE && !jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_ES_NEXT) {
                return (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .processOldBrowserDrag */ .dT)(self, cData, handlerSuccess, handlerError, onFinally);
            }
            if ((0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasItems */ .Pb)(cData)) {
                const { items } = cData;
                for (i = 0; i < items.length; i += 1) {
                    if (items[i].kind === 'file' &&
                        items[i].type === 'image/png') {
                        file = items[i].getAsFile();
                        if (file) {
                            const mime = file.type.match(/\/([a-z0-9]+)/i);
                            extension = mime[1]
                                ? mime[1].toLowerCase()
                                : '';
                            (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .sendFiles */ ._9)(self, [file], handlerSuccess, handlerError, processData).finally(onFinally);
                        }
                        e.preventDefault();
                        break;
                    }
                }
            }
        };
        if (self.j && self.j.editor !== form) {
            self.j.e.on(form, 'paste', onPaste);
        }
        else {
            self.j.e.on('beforePaste', onPaste);
        }
        this.attachEvents(form, handlerSuccess, handlerError, onFinally);
    }
    attachEvents(form, handlerSuccess, handlerError, onFinally) {
        const self = this;
        self.j.e
            .on(form, 'dragend dragover dragenter dragleave drop', (e) => {
            e.preventDefault();
        })
            .on(form, 'dragover', (event) => {
            if ((0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasFiles */ .YQ)(event.dataTransfer) ||
                (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasItems */ .Pb)(event.dataTransfer)) {
                form.classList.add('jodit_drag_hover');
                event.preventDefault();
            }
        })
            .on(form, 'dragend dragleave', (event) => {
            form.classList.remove('jodit_drag_hover');
            if ((0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasFiles */ .YQ)(event.dataTransfer)) {
                event.preventDefault();
            }
        })
            .on(form, 'drop', (event) => {
            form.classList.remove('jodit_drag_hover');
            if ((0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .hasFiles */ .YQ)(event.dataTransfer)) {
                event.preventDefault();
                event.stopImmediatePropagation();
                (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .sendFiles */ ._9)(self, event.dataTransfer.files, handlerSuccess, handlerError).finally(onFinally);
            }
        });
        const inputFile = form.querySelector('input[type=file]');
        if (inputFile) {
            self.j.e.on(inputFile, 'change', () => {
                (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .sendFiles */ ._9)(self, inputFile.files, handlerSuccess, handlerError)
                    .then(() => {
                    inputFile.value = '';
                    if (!/safari/i.test(navigator.userAgent)) {
                        inputFile.type = '';
                        inputFile.type = 'file';
                    }
                })
                    .finally(onFinally);
            });
        }
    }
    /**
     * Upload images to a server by its URL, making it through the connector server.
     */
    uploadRemoteImage(url, handlerSuccess, handlerError) {
        const uploader = this, { o } = uploader;
        const handlerE = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isFunction)(handlerError)
            ? handlerError
            : o.defaultHandlerError;
        (0,jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .send */ .tN)(uploader, {
            action: 'fileUploadRemote',
            url
        })
            .then(resp => {
            if (o.isSuccess.call(uploader, resp)) {
                const handler = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isFunction)(handlerSuccess)
                    ? handlerSuccess
                    : o.defaultHandlerSuccess;
                handler.call(uploader, o.process.call(uploader, resp));
                return;
            }
            handlerE.call(uploader, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.error)(o.getMessage.call(uploader, resp)));
        })
            .catch(e => handlerE.call(uploader, e));
    }
    constructor(editor, options) {
        super(editor);
        this.path = '';
        this.source = 'default';
        this.options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.ConfigProto)(options || {}, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.ConfigProto)(jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.defaultOptions.uploader, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isJoditObject)(editor) ? editor.o.uploader : {}));
    }
    destruct() {
        this.setStatus(jodit_core_component___WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.beforeDestruct);
        const instances = jodit_modules_uploader_helpers__WEBPACK_IMPORTED_MODULE_4__/* .ajaxInstances */ .$j.get(this);
        if (instances) {
            instances.forEach(ajax => {
                try {
                    ajax.destruct();
                }
                catch (_a) { }
            });
            instances.clear();
        }
        super.destruct();
    }
}


/***/ }),

/***/ 27301:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EW: function() { return /* binding */ alreadyLoadedList; },
/* harmony export */   Qt: function() { return /* binding */ loadNext; },
/* harmony export */   S5: function() { return /* binding */ appendStyleAsync; },
/* harmony export */   w4: function() { return /* binding */ appendScriptAsync; },
/* harmony export */   x_: function() { return /* binding */ loadNextStyle; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98253);
/* harmony import */ var _complete_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(60346);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


const alreadyLoadedList = new Map();
const cacheLoaders = (loader) => {
    return (jodit, url) => {
        if (alreadyLoadedList.has(url)) {
            return alreadyLoadedList.get(url);
        }
        const promise = loader(jodit, url);
        alreadyLoadedList.set(url, promise);
        return promise;
    };
};
/**
 * Load script and return promise
 */
const appendScriptAsync = cacheLoaders((jodit, url) => {
    return jodit.async.promise((resolve, reject) => {
        if (jodit.isInDestruct) {
            return reject();
        }
        const script = jodit.c.element('script', {
            type: 'text/javascript',
            crossorigin: 'anonymous',
            referrerpolicy: 'no-referrer',
            async: true,
            src: (0,_complete_url__WEBPACK_IMPORTED_MODULE_0__/* .completeUrl */ .X)(url)
        });
        jodit.e.one(script, 'error', reject).one(script, 'load', resolve);
        jodit.od.body.appendChild(script);
    });
});
/**
 * Download CSS style script
 */
const appendStyleAsync = cacheLoaders((jodit, url) => {
    return jodit.async.promise((resolve, reject) => {
        if (jodit.isInDestruct) {
            return reject();
        }
        const link = jodit.c.element('link');
        link.rel = 'stylesheet';
        link.media = 'all';
        link.crossOrigin = 'anonymous';
        const callback = () => resolve(link);
        !jodit.isInDestruct &&
            jodit.e.on(link, 'load', callback).on(link, 'error', reject);
        link.href = (0,_complete_url__WEBPACK_IMPORTED_MODULE_0__/* .completeUrl */ .X)(url);
        if (jodit.o.shadowRoot) {
            jodit.o.shadowRoot.appendChild(link);
        }
        else {
            jodit.od.body.appendChild(link);
        }
    });
});
function loadNext(jodit, urls, i = 0) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__/* .isString */ .K)(urls[i])) {
        return Promise.resolve();
    }
    return appendScriptAsync(jodit, urls[i]).then(() => loadNext(jodit, urls, i + 1));
}
function loadNextStyle(jodit, urls, i = 0) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_1__/* .isString */ .K)(urls[i])) {
        return Promise.resolve();
    }
    return appendStyleAsync(jodit, urls[i]).then(() => loadNextStyle(jodit, urls, i + 1));
}


/***/ }),

/***/ 27337:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.defaultAjaxOptions = {
    successStatuses: [200, 201, 202],
    method: 'GET',
    url: '',
    data: null,
    contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
    headers: {
        'X-REQUESTED-WITH': 'XMLHttpRequest' // compatible with jQuery
    },
    withCredentials: false,
    xhr() {
        return new XMLHttpRequest();
    }
};


/***/ }),

/***/ 27594:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   G: function() { return /* binding */ position; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83044);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Calculate screen element position
 */
function position(elm, jodit, recurse = false) {
    var _a, _b;
    const rect = elm.getBoundingClientRect();
    let xPos = rect.left, yPos = rect.top;
    if ((0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_0__/* .isJoditObject */ .y)(jodit) &&
        jodit.iframe &&
        jodit.ed.body.contains(elm) &&
        !recurse) {
        const { left, top } = position(jodit.iframe, jodit, true);
        xPos += left;
        yPos += top;
    }
    return {
        left: Math.round(xPos),
        top: Math.round(yPos),
        width: Math.round((_a = elm.offsetWidth) !== null && _a !== void 0 ? _a : rect.width),
        height: Math.round((_b = elm.offsetHeight) !== null && _b !== void 0 ? _b : rect.height)
    };
}


/***/ }),

/***/ 27912:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ ajaxInstances; },
/* harmony export */   t: function() { return /* binding */ send; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_request__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53883);
/* harmony import */ var jodit_modules_uploader_helpers_build_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(89929);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



const ajaxInstances = new WeakMap();
function send(uploader, data) {
    const requestData = (0,jodit_modules_uploader_helpers_build_data__WEBPACK_IMPORTED_MODULE_2__/* .buildData */ .$)(uploader, data);
    const sendData = (request) => {
        const ajax = new jodit_core_request__WEBPACK_IMPORTED_MODULE_1__/* .Ajax */ .d({
            xhr: () => {
                const xhr = new XMLHttpRequest();
                if (uploader.j.ow.FormData !== undefined &&
                    xhr.upload) {
                    uploader.j.progressbar.show().progress(10);
                    xhr.upload.addEventListener('progress', evt => {
                        if (evt.lengthComputable) {
                            let percentComplete = evt.loaded / evt.total;
                            percentComplete *= 100;
                            uploader.j.progressbar
                                .show()
                                .progress(percentComplete);
                            if (percentComplete >= 100) {
                                uploader.j.progressbar.hide();
                            }
                        }
                    }, false);
                }
                else {
                    uploader.j.progressbar.hide();
                }
                return xhr;
            },
            method: uploader.o.method || 'POST',
            data: request,
            url: (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isFunction)(uploader.o.url)
                ? uploader.o.url(request)
                : uploader.o.url,
            headers: uploader.o.headers,
            queryBuild: uploader.o.queryBuild,
            contentType: uploader.o.contentType.call(uploader, request),
            withCredentials: uploader.o.withCredentials || false
        });
        let instances = ajaxInstances.get(uploader);
        if (!instances) {
            instances = new Set();
            ajaxInstances.set(uploader, instances);
        }
        instances.add(ajax);
        uploader.j.e.one('beforeDestruct', ajax.destruct);
        return ajax
            .send()
            .then(resp => resp.json())
            .catch(error => {
            return {
                success: false,
                data: {
                    messages: [error]
                }
            };
        })
            .finally(() => {
            ajax.destruct();
            instances === null || instances === void 0 ? void 0 : instances.delete(ajax);
        });
    };
    if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isPromise)(requestData)) {
        return requestData.then(sendData).catch(error => {
            uploader.o.error.call(uploader, error);
        });
    }
    return sendData(requestData);
}


/***/ }),

/***/ 28616:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: function() { return /* binding */ stringify; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Safe stringify circular object
 */
function stringify(value, options = {}) {
    if (typeof value !== 'object') {
        return String(value);
    }
    const excludeKeys = new Set(options.excludeKeys);
    const map = new WeakMap();
    const r = (k, v) => {
        if (excludeKeys.has(k)) {
            return;
        }
        if (typeof v === 'object' && v != null) {
            if (map.get(v)) {
                return '[refObject]';
            }
            map.set(v, true);
        }
        return v;
    };
    return JSON.stringify(value, r, options.prettify);
}


/***/ }),

/***/ 28709:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ UIForm; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37474);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69198);
/* harmony import */ var jodit_core_ui_form_inputs_select_select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1540);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6455);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







let UIForm = class UIForm extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_4__/* .UIGroup */ .U {
    /** @override */
    className() {
        return 'UIForm';
    }
    submit() {
        this.j.e.fire(this.container, 'submit');
    }
    validate() {
        const inputs = this.allChildren.filter(elm => jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(elm, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .t));
        for (const input of inputs) {
            if (!input.validate()) {
                return false;
            }
        }
        const selects = this.allChildren.filter(elm => jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(elm, jodit_core_ui_form_inputs_select_select__WEBPACK_IMPORTED_MODULE_3__/* .UISelect */ .$));
        for (const select of selects) {
            if (!select.validate()) {
                return false;
            }
        }
        return true;
    }
    onSubmit(handler) {
        this.j.e.on(this.container, 'submit', () => {
            const inputs = this.allChildren.filter(elm => jodit_core_component_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .u.isInstanceOf(elm, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .t));
            if (!this.validate()) {
                return false;
            }
            handler(inputs.reduce((res, item) => {
                res[item.state.name] = item.value;
                return res;
            }, {}));
            return false;
        });
        return this;
    }
    /** @override */
    createContainer() {
        const form = this.j.c.element('form');
        form.classList.add(this.componentName);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(form, 'dir', this.j.o.direction || 'auto');
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(form, 'novalidate', '');
        return form;
    }
    constructor(...args) {
        var _a, _b;
        super(...args);
        if ((_a = this.options) === null || _a === void 0 ? void 0 : _a.className) {
            this.container.classList.add((_b = this.options) === null || _b === void 0 ? void 0 : _b.className);
        }
    }
};
UIForm = (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_6__/* .component */ .s
], UIForm);



/***/ }),

/***/ 28712:
/***/ (function(module) {

"use strict";
module.exports = {assert(){}};;

/***/ }),

/***/ 28776:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'символ'
};


/***/ }),

/***/ 29012:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CP: function() { return /* reexport safe */ _separator__WEBPACK_IMPORTED_MODULE_2__.C; },
/* harmony export */   Ue: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_0__.U; },
/* harmony export */   bk: function() { return /* reexport safe */ _spacer__WEBPACK_IMPORTED_MODULE_3__.b; },
/* harmony export */   z4: function() { return /* reexport safe */ _list__WEBPACK_IMPORTED_MODULE_1__.z; }
/* harmony export */ });
/* harmony import */ var _group__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6455);
/* harmony import */ var _list__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94070);
/* harmony import */ var _separator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86283);
/* harmony import */ var _spacer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13642);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module ui/group
 */






/***/ }),

/***/ 29348:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"><path d=\"M1534 189v73q0 29-18.5 61t-42.5 32q-50 0-54 1-26 6-32 31-3 11-3 64v1152q0 25-18 43t-43 18h-108q-25 0-43-18t-18-43v-1218h-143v1218q0 25-17.5 43t-43.5 18h-108q-26 0-43.5-18t-17.5-43v-496q-147-12-245-59-126-58-192-179-64-117-64-259 0-166 88-286 88-118 209-159 111-37 417-37h479q25 0 43 18t18 43z\"/></svg>"

/***/ }),

/***/ 29581:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/select-cells
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.tableAllowCellSelection = true;


/***/ }),

/***/ 29780:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D: function() { return /* binding */ UIElement; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_decorators_derive_derive__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1963);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87906);
/* harmony import */ var jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(75758);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(931);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var UIElement_1;








let UIElement = UIElement_1 = class UIElement extends jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    get parentElement() {
        return this.__parentElement;
    }
    set parentElement(parentElement) {
        this.__parentElement = parentElement;
        if (parentElement) {
            parentElement.hookStatus('beforeDestruct', () => this.destruct());
        }
        this.updateParentElement(this);
    }
    bubble(callback) {
        let parent = this.parentElement;
        while (parent) {
            callback(parent);
            parent = parent.parentElement;
        }
        return this;
    }
    updateParentElement(target) {
        var _a;
        (_a = this.__parentElement) === null || _a === void 0 ? void 0 : _a.updateParentElement(target);
        return this;
    }
    /** @override */
    get(chain, obj) {
        return super.get(chain, obj) || this.getElm(chain);
    }
    /**
     * Find match parent
     */
    closest(type) {
        const c = typeof type === 'object'
            ? (pe) => pe === type
            : (pe) => jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .uA.isInstanceOf(pe, type);
        let pe = this.__parentElement;
        while (pe) {
            if (c(pe)) {
                return pe;
            }
            if (!pe.parentElement && pe.container.parentElement) {
                pe = UIElement_1.closestElement(pe.container.parentElement, UIElement_1);
            }
            else {
                pe = pe.parentElement;
            }
        }
        return null;
    }
    /**
     * Find closest UIElement in DOM
     */
    static closestElement(node, type) {
        const elm = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.up(node, elm => {
            if (elm) {
                const { component } = elm;
                return component && jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .Component */ .uA.isInstanceOf(component, type);
            }
            return false;
        });
        return elm ? elm === null || elm === void 0 ? void 0 : elm.component : null;
    }
    /**
     * Update UI from state
     */
    update() {
        // empty
    }
    /**
     * Append container to element
     */
    appendTo(element) {
        element.appendChild(this.container);
        return this;
    }
    /**
     * Valid name only with valid chars
     */
    clearName(name) {
        return name.replace(/[^a-zA-Z0-9]/g, '_');
    }
    /**
     * Method create only box
     */
    render(options) {
        return this.j.c.div(this.componentName);
    }
    /**
     * Create main HTML container
     */
    createContainer(options) {
        const result = this.render(options);
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(result)) {
            const elm = this.parseTemplate(result);
            elm.classList.add(this.componentName);
            return elm;
        }
        return result;
    }
    parseTemplate(result) {
        return this.j.c.fromHTML(result
            .replace(/\*([^*]+?)\*/g, (_, name) => jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__/* .Icon */ .I.get(name) || '')
            .replace(/&_/g, this.componentName + '_')
            .replace(/~([^~]+?)~/g, (_, s) => this.i18n(s)));
    }
    /** @override */
    constructor(jodit, options) {
        super(jodit);
        this.name = '';
        this.__parentElement = null;
        this.mods = {};
        this.container = this.createContainer(options);
        Object.defineProperty(this.container, 'component', {
            value: this,
            configurable: true
        });
    }
    /** @override */
    destruct() {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(this.container);
        this.parentElement = null;
        return super.destruct();
    }
};
UIElement = UIElement_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_derive_derive__WEBPACK_IMPORTED_MODULE_6__/* .derive */ .C)(jodit_core_traits_mods__WEBPACK_IMPORTED_MODULE_7__/* .Mods */ .K, jodit_core_traits_elms__WEBPACK_IMPORTED_MODULE_2__/* .Elms */ .O)
], UIElement);



/***/ }),

/***/ 29822:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* binding */ checkRemoveContentNotEditable; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_selection_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(46602);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Checks if a non-editable element can be deleted
 * @private
 */
function checkRemoveContentNotEditable(jodit, fakeNode, backspace) {
    let neighbor = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.findSibling(fakeNode, backspace);
    if (!neighbor &&
        fakeNode.parentElement &&
        fakeNode.parentElement !== jodit.editor) {
        neighbor = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.findSibling(fakeNode.parentElement, backspace);
    }
    if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(neighbor) &&
        !jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isContentEditable(neighbor, jodit.editor)) {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.call)(backspace ? jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.before : jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.after, neighbor, fakeNode);
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(neighbor);
        (0,jodit_core_selection_helpers__WEBPACK_IMPORTED_MODULE_2__/* .moveNodeInsideStart */ .W8)(jodit, fakeNode, backspace);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.call)(backspace ? jodit.s.setCursorBefore : jodit.s.setCursorAfter, fakeNode);
        return true;
    }
    return false;
}


/***/ }),

/***/ 29866:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ Plugin; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83044);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




class Plugin extends jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    /** @override */
    className() {
        return 'Plugin';
    }
    constructor(jodit) {
        super(jodit);
        /** @override */
        this.buttons = [];
        /**
         * Plugin have CSS style and it should be loaded
         */
        this.hasStyle = false;
        this.__inited = false;
        jodit.e
            .on('afterPluginSystemInit', this.__afterPluginSystemInit)
            .on('afterInit', this.__afterInit)
            .on('beforeDestruct', this.__beforeDestruct);
    }
    __afterPluginSystemInit() {
        const { j, buttons } = this;
        if (buttons && (0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_2__/* .isJoditObject */ .y)(j)) {
            buttons.forEach(btn => {
                j.registerButton(btn);
            });
        }
    }
    __afterInit() {
        this.__inited = true;
        this.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready);
        this.afterInit(this.jodit);
    }
    init(jodit) {
        if (this.jodit.isReady) {
            this.afterInit(this.jodit);
            this.__afterPluginSystemInit();
            this.jodit.e.fire('rebuildToolbar');
        }
    }
    __beforeDestruct() {
        var _a;
        if (this.isInDestruct) {
            return;
        }
        const { j } = this;
        j.e
            .off('afterPluginSystemInit', this.__afterPluginSystemInit)
            .off('afterInit', this.__afterInit)
            .off('beforeDestruct', this.destruct);
        this.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.beforeDestruct);
        if (!this.__inited) {
            return super.destruct();
        }
        if ((0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_2__/* .isJoditObject */ .y)(j)) {
            (_a = this.buttons) === null || _a === void 0 ? void 0 : _a.forEach(btn => {
                j === null || j === void 0 ? void 0 : j.unregisterButton(btn);
            });
        }
        this.beforeDestruct(this.j);
        super.destruct();
    }
}
Plugin.requires = [];
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Plugin.prototype, "__afterPluginSystemInit", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Plugin.prototype, "__afterInit", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Plugin.prototype, "__beforeDestruct", null);


/***/ }),

/***/ 30393:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   j: function() { return /* binding */ applyValuesToImage; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var _link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(88269);
/* harmony import */ var _margin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(78139);
/* harmony import */ var _size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(58972);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Apply form's values to image
 * @private
 */
function applyValuesToImage(j, state, image) {
    const { style, imageSrc, borderRadius, imageTitle, imageAlt, imageLink, imageWidth, imageHeight, marginTop, marginRight, marginBottom, marginLeft, imageLinkOpenInNewTab, align, classes, id } = state.values;
    const opt = j.o;
    // styles
    if (opt.image.editStyle) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'style', style || null);
    }
    // Src
    if (imageSrc) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'src', imageSrc);
    }
    else {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(image);
        return;
    }
    // Border radius
    image.style.borderRadius = borderRadius ? borderRadius + 'px' : '';
    // Title
    (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'title', imageTitle || null);
    // Alt
    (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'alt', imageAlt || null);
    // Link
    (0,_link__WEBPACK_IMPORTED_MODULE_2__/* .applyLink */ .j)(j, image, imageLink, imageLinkOpenInNewTab);
    // Size
    (0,_size__WEBPACK_IMPORTED_MODULE_4__/* .applySize */ .q)(image, imageWidth, imageHeight, state.sizeIsLocked);
    // Margin
    if (j.o.image.editMargins) {
        (0,_margin__WEBPACK_IMPORTED_MODULE_3__/* .applyMargin */ .N)(j, marginTop, marginRight, marginBottom, marginLeft, image, state.marginIsLocked);
    }
    if (opt.image.editClass) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'class', classes || null);
    }
    if (opt.image.editId) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(image, 'id', id || null);
    }
    if (opt.image.editAlign) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.hAlignElement)(image, align);
    }
}


/***/ }),

/***/ 30405:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export hotkeys */
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71005);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(81522);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Allow set hotkey for command or button
 */
class hotkeys extends jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__/* .Plugin */ .k {
    constructor() {
        super(...arguments);
        this.onKeyPress = (event) => {
            const special = this.specialKeys[event.which];
            const character = (event.key || String.fromCharCode(event.which)).toLowerCase();
            const modif = [special || character];
            ['alt', 'ctrl', 'shift', 'meta'].forEach(specialKey => {
                if (event[specialKey + 'Key'] && special !== specialKey) {
                    modif.push(specialKey);
                }
            });
            return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.normalizeKeyAliases)(modif.join('+'));
        };
        this.specialKeys = {
            8: 'backspace',
            9: 'tab',
            10: 'return',
            13: 'return',
            16: 'shift',
            17: 'ctrl',
            18: 'alt',
            19: 'pause',
            20: 'capslock',
            27: 'esc',
            32: 'space',
            33: 'pageup',
            34: 'pagedown',
            35: 'end',
            36: 'home',
            37: 'left',
            38: 'up',
            39: 'right',
            40: 'down',
            45: 'insert',
            46: 'del',
            59: ';',
            61: '=',
            91: 'meta',
            96: '0',
            97: '1',
            98: '2',
            99: '3',
            100: '4',
            101: '5',
            102: '6',
            103: '7',
            104: '8',
            105: '9',
            106: '*',
            107: '+',
            109: '-',
            110: '.',
            111: '/',
            112: 'f1',
            113: 'f2',
            114: 'f3',
            115: 'f4',
            116: 'f5',
            117: 'f6',
            118: 'f7',
            119: 'f8',
            120: 'f9',
            121: 'f10',
            122: 'f11',
            123: 'f12',
            144: 'numlock',
            145: 'scroll',
            173: '-',
            186: ';',
            187: '=',
            188: ',',
            189: '-',
            190: '.',
            191: '/',
            192: '`',
            219: '[',
            220: '\\',
            221: ']',
            222: "'"
        };
    }
    /** @override */
    afterInit(editor) {
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.keys)(editor.o.commandToHotkeys, false).forEach((commandName) => {
            const shortcuts = editor.o.commandToHotkeys[commandName];
            if (shortcuts && ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isArray)(shortcuts) || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isString)(shortcuts))) {
                editor.registerHotkeyToCommand(shortcuts, commandName);
            }
        });
        let itIsHotkey = false;
        editor.e
            .off('.hotkeys')
            .on([editor.ow, editor.ew], 'keydown.hotkeys', (e) => {
            if (e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_ESC) {
                return this.j.e.fire('escape', e);
            }
        })
            .on('keydown.hotkeys', (event) => {
            const shortcut = this.onKeyPress(event);
            const stop = {
                shouldStop: true
            };
            const resultOfFire = this.j.e.fire(shortcut + '.hotkey', event.type, stop);
            if (resultOfFire === false) {
                if (stop.shouldStop) {
                    itIsHotkey = true;
                    editor.e.stopPropagation('keydown');
                    return false;
                }
                else {
                    event.preventDefault();
                }
            }
        }, { top: true })
            .on('keyup.hotkeys', () => {
            if (itIsHotkey) {
                itIsHotkey = false;
                editor.e.stopPropagation('keyup');
                return false;
            }
        }, { top: true });
    }
    /** @override */
    beforeDestruct(jodit) {
        if (jodit.events) {
            jodit.e.off('.hotkeys');
        }
    }
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('hotkeys', hotkeys);


/***/ }),

/***/ 30495:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   R: function() { return /* binding */ ConnectionError; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */
class ConnectionError extends Error {
    constructor(m) {
        super(m);
        Object.setPrototypeOf(this, ConnectionError.prototype);
    }
}


/***/ }),

/***/ 30526:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D: function() { return /* binding */ isInlineBlock; },
/* harmony export */   w: function() { return /* binding */ removeFormatForCollapsedSelection; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * For collapsed selection move cursor outside or split inline block
 * @private
 */
function removeFormatForCollapsedSelection(jodit, fake) {
    const { s } = jodit;
    let fakeNode = fake;
    if (!fakeNode) {
        fakeNode = jodit.createInside.fake();
        const { range } = s;
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeInsertNode(range, fakeNode);
        range.collapse();
    }
    const mainInline = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.furthest(fakeNode, isInlineBlock, jodit.editor);
    if (mainInline) {
        if (s.cursorOnTheLeft(mainInline)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(mainInline, fakeNode);
        }
        else if (s.cursorOnTheRight(mainInline)) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.after(mainInline, fakeNode);
        }
        else {
            const leftHand = s.splitSelection(mainInline);
            leftHand && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.after(leftHand, fakeNode);
        }
    }
    if (!fake) {
        s.setCursorBefore(fakeNode);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(fakeNode);
    }
}
/**
 * Element has inline display mode
 * @private
 */
function isInlineBlock(node) {
    return jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isInlineBlock(node) && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(node, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS);
}


/***/ }),

/***/ 30687:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ processEmptyLILeaf; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58720);
/* harmony import */ var _insert_paragraph__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(41159);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Handles pressing the Enter key inside an empty LI inside a list
 * @private
 */
function processEmptyLILeaf(fake, jodit, li) {
    const list = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(li, ['ol', 'ul'], jodit.editor);
    if (!list) {
        return;
    }
    const parentLi = list.parentElement, listInsideLeaf = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isLeaf(parentLi);
    const container = listInsideLeaf ? parentLi : list;
    // Empty element in the middle of the list
    const leftRange = jodit.s.createRange();
    leftRange.setStartAfter(li);
    leftRange.setEndAfter(list);
    const rightPart = leftRange.extractContents();
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.after(container, fake);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(li);
    if (!(0,jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_1__.$$)('li', list).length) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(list);
    }
    const newLi = (0,_insert_paragraph__WEBPACK_IMPORTED_MODULE_2__/* .insertParagraph */ .y)(fake, jodit, listInsideLeaf ? 'li' : jodit.o.enter);
    if (!rightPart.querySelector('li')) {
        return;
    }
    if (listInsideLeaf) {
        newLi.appendChild(rightPart);
    }
    else {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.after(newLi, rightPart);
    }
}


/***/ }),

/***/ 31138:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   f: function() { return /* binding */ normalizeLicense; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */
const normalizeLicense = (license, count = 8) => {
    const parts = [];
    while (license.length) {
        parts.push(license.substr(0, count));
        license = license.substr(count);
    }
    parts[1] = parts[1].replace(/./g, '*');
    parts[2] = parts[2].replace(/./g, '*');
    return parts.join('-');
};


/***/ }),

/***/ 31202:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   s: function() { return /* binding */ UIButtonGroup; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(92032);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6455);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






let UIButtonGroup = class UIButtonGroup extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_2__/* .UIGroup */ .U {
    /** @override */
    className() {
        return 'UIButtonGroup';
    }
    /** @override */
    render(options) {
        return `<div>
			<div class="&__label">~${options.label}~</div>
			<div class="&__options"></div>
		</div>`;
    }
    /** @override */
    appendChildToContainer(childContainer) {
        const options = this.getElm('options');
        void 0;
        options.appendChild(childContainer);
    }
    constructor(jodit, options = {
        radio: true
    }) {
        var _a, _b;
        super(jodit, (_a = options.options) === null || _a === void 0 ? void 0 : _a.map(opt => {
            const btn = new jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_1__/* .UIButton */ .lD(jodit, {
                text: opt.text,
                value: opt.value,
                variant: 'primary'
            });
            btn.onAction(() => {
                this.select(opt.value);
            });
            return btn;
        }), options);
        this.options = options;
        this.select((_b = options.value) !== null && _b !== void 0 ? _b : 0);
    }
    select(indexOrValue) {
        var _a, _b;
        this.elements.forEach((elm, index) => {
            if (index === indexOrValue || elm.state.value === indexOrValue) {
                elm.state.activated = true;
            }
            else if (this.options.radio) {
                elm.state.activated = false;
            }
        });
        const result = this.elements
            .filter(elm => elm.state.activated)
            .map(elm => ({
            text: elm.state.text,
            value: elm.state.value
        }));
        this.jodit.e.fire(this, 'select', result);
        (_b = (_a = this.options).onChange) === null || _b === void 0 ? void 0 : _b.call(_a, result);
    }
};
UIButtonGroup = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__/* .component */ .s
], UIButtonGroup);



/***/ }),

/***/ 31230:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 24 24\"> <g transform=\"translate(-251.000000, -443.000000)\"> <g transform=\"translate(215.000000, 119.000000)\"/> <path d=\"M252,448 L256,448 L256,444 L252,444 L252,448 Z M257,448 L269,448 L269,446 L257,446 L257,448 Z M257,464 L269,464 L269,462 L257,462 L257,464 Z M270,444 L270,448 L274,448 L274,444 L270,444 Z M252,462 L252,466 L256,466 L256,462 L252,462 Z M270,462 L270,466 L274,466 L274,462 L270,462 Z M254,461 L256,461 L256,449 L254,449 L254,461 Z M270,461 L272,461 L272,449 L270,449 L270,461 Z\"/> </g> </svg>"

/***/ }),

/***/ 31365:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 32 32\"> <path d=\"M27 4l-15 15-7-7-5 5 12 12 20-20z\"/> </svg>"

/***/ }),

/***/ 31635:
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cg: function() { return /* binding */ __decorate; },
/* harmony export */   sH: function() { return /* binding */ __awaiter; }
/* harmony export */ });
/* unused harmony exports __extends, __assign, __rest, __param, __esDecorate, __runInitializers, __propKey, __setFunctionName, __metadata, __generator, __createBinding, __exportStar, __values, __read, __spread, __spreadArrays, __spreadArray, __await, __asyncGenerator, __asyncDelegator, __asyncValues, __makeTemplateObject, __importStar, __importDefault, __classPrivateFieldGet, __classPrivateFieldSet, __classPrivateFieldIn, __addDisposableResource, __disposeResources, __rewriteRelativeImportExtension */
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol, Iterator */

var extendStatics = function(d, b) {
  extendStatics = Object.setPrototypeOf ||
      ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
      function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
  return extendStatics(d, b);
};

function __extends(d, b) {
  if (typeof b !== "function" && b !== null)
      throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
  extendStatics(d, b);
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
  __assign = Object.assign || function __assign(t) {
      for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
      }
      return t;
  }
  return __assign.apply(this, arguments);
}

function __rest(s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
      t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
          if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
              t[p[i]] = s[p[i]];
      }
  return t;
}

function __decorate(decorators, target, key, desc) {
  var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
  if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
  else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
  return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
      var context = {};
      for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
      for (var p in contextIn.access) context.access[p] = contextIn.access[p];
      context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
      var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
      if (kind === "accessor") {
          if (result === void 0) continue;
          if (result === null || typeof result !== "object") throw new TypeError("Object expected");
          if (_ = accept(result.get)) descriptor.get = _;
          if (_ = accept(result.set)) descriptor.set = _;
          if (_ = accept(result.init)) initializers.unshift(_);
      }
      else if (_ = accept(result)) {
          if (kind === "field") initializers.unshift(_);
          else descriptor[key] = _;
      }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};

function __runInitializers(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
      value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};

function __propKey(x) {
  return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
  if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
  return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
  if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
  function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
  return new (P || (P = Promise))(function (resolve, reject) {
      function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
      function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
      function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}

function __generator(thisArg, body) {
  var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
  return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
  function verb(n) { return function (v) { return step([n, v]); }; }
  function step(op) {
      if (f) throw new TypeError("Generator is already executing.");
      while (g && (g = 0, op[0] && (_ = 0)), _) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
              case 0: case 1: t = op; break;
              case 4: _.label++; return { value: op[1], done: false };
              case 5: _.label++; y = op[1]; op = [0]; continue;
              case 7: op = _.ops.pop(); _.trys.pop(); continue;
              default:
                  if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                  if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                  if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                  if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                  if (t[2]) _.ops.pop();
                  _.trys.pop(); continue;
          }
          op = body.call(thisArg, _);
      } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
      if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
  }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
  }
  Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});

function __exportStar(m, o) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
  var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
  if (m) return m.call(o);
  if (o && typeof o.length === "number") return {
      next: function () {
          if (o && i >= o.length) o = void 0;
          return { value: o && o[i++], done: !o };
      }
  };
  throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
  var m = typeof Symbol === "function" && o[Symbol.iterator];
  if (!m) return o;
  var i = m.call(o), r, ar = [], e;
  try {
      while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
  }
  catch (error) { e = { error: error }; }
  finally {
      try {
          if (r && !r.done && (m = i["return"])) m.call(i);
      }
      finally { if (e) throw e.error; }
  }
  return ar;
}

/** @deprecated */
function __spread() {
  for (var ar = [], i = 0; i < arguments.length; i++)
      ar = ar.concat(__read(arguments[i]));
  return ar;
}

/** @deprecated */
function __spreadArrays() {
  for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
  for (var r = Array(s), k = 0, i = 0; i < il; i++)
      for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
          r[k] = a[j];
  return r;
}

function __spreadArray(to, from, pack) {
  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
      if (ar || !(i in from)) {
          if (!ar) ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
      }
  }
  return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
  return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var g = generator.apply(thisArg, _arguments || []), i, q = [];
  return i = Object.create((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
  function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
  function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
  function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
  function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
  function fulfill(value) { resume("next", value); }
  function reject(value) { resume("throw", value); }
  function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
  var i, p;
  return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
  function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator], i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
  function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
  function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
  if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
  return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
  Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
  o["default"] = v;
};

var ownKeys = function(o) {
  ownKeys = Object.getOwnPropertyNames || function (o) {
    var ar = [];
    for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
    return ar;
  };
  return ownKeys(o);
};

function __importStar(mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
  __setModuleDefault(result, mod);
  return result;
}

function __importDefault(mod) {
  return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
  if (kind === "m") throw new TypeError("Private method is not writable");
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
  return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
  if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
  return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
  if (value !== null && value !== void 0) {
    if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
    var dispose, inner;
    if (async) {
      if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
      dispose = value[Symbol.asyncDispose];
    }
    if (dispose === void 0) {
      if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
      dispose = value[Symbol.dispose];
      if (async) inner = dispose;
    }
    if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
    if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
    env.stack.push({ value: value, dispose: dispose, async: async });
  }
  else if (async) {
    env.stack.push({ async: true });
  }
  return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
  var e = new Error(message);
  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
  function fail(e) {
    env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
    env.hasError = true;
  }
  var r, s = 0;
  function next() {
    while (r = env.stack.pop()) {
      try {
        if (!r.async && s === 1) return s = 0, env.stack.push(r), Promise.resolve().then(next);
        if (r.dispose) {
          var result = r.dispose.call(r.value);
          if (r.async) return s |= 2, Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
        }
        else s |= 1;
      }
      catch (e) {
        fail(e);
      }
    }
    if (s === 1) return env.hasError ? Promise.reject(env.error) : Promise.resolve();
    if (env.hasError) throw env.error;
  }
  return next();
}

function __rewriteRelativeImportExtension(path, preserveJsx) {
  if (typeof path === "string" && /^\.\.?\//.test(path)) {
      return path.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i, function (m, tsx, d, ext, cm) {
          return tsx ? preserveJsx ? ".jsx" : ".js" : d && (!ext || !cm) ? m : (d + ext + "." + cm.toLowerCase() + "js");
      });
  }
  return path;
}

/* unused harmony default export */ var __WEBPACK_DEFAULT_EXPORT__ = ({
  __extends,
  __assign,
  __rest,
  __decorate,
  __param,
  __esDecorate,
  __runInitializers,
  __propKey,
  __setFunctionName,
  __metadata,
  __awaiter,
  __generator,
  __createBinding,
  __exportStar,
  __values,
  __read,
  __spread,
  __spreadArrays,
  __spreadArray,
  __await,
  __asyncGenerator,
  __asyncDelegator,
  __asyncValues,
  __makeTemplateObject,
  __importStar,
  __importDefault,
  __classPrivateFieldGet,
  __classPrivateFieldSet,
  __classPrivateFieldIn,
  __addDisposableResource,
  __disposeResources,
  __rewriteRelativeImportExtension,
});


/***/ }),

/***/ 31686:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(35265);
/* harmony import */ var jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20703);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(36115);
/* harmony import */ var jodit_modules_widget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(16116);
/* harmony import */ var _video_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(36339);
/* harmony import */ var _video_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_video_svg__WEBPACK_IMPORTED_MODULE_6__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







jodit_config__WEBPACK_IMPORTED_MODULE_4__/* .Config */ .T.prototype.video = {
    parseUrlToVideoEmbed: jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.convertMediaUrlToVideoEmbed,
    defaultWidth: 400,
    defaultHeight: 345
};
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__/* .Icon */ .I.set('video', (_video_svg__WEBPACK_IMPORTED_MODULE_6___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_4__/* .Config */ .T.prototype.controls.video = {
    popup: (jodit, current, close) => {
        const formLink = new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIForm */ .XV(jodit, [
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIBlock */ .Yh(jodit, [
                new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIInput */ .tS(jodit, {
                    name: 'url',
                    required: true,
                    label: 'URL',
                    placeholder: 'https://',
                    validators: ['url']
                })
            ]),
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIBlock */ .Yh(jodit, [
                (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_1__/* .Button */ .$n)(jodit, '', 'Insert', 'primary').onAction(() => formLink.submit())
            ])
        ]), formCode = new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIForm */ .XV(jodit, [
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIBlock */ .Yh(jodit, [
                new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UITextArea */ .F0(jodit, {
                    name: 'code',
                    required: true,
                    label: 'Embed code'
                })
            ]),
            new jodit_core_ui_form__WEBPACK_IMPORTED_MODULE_2__/* .UIBlock */ .Yh(jodit, [
                (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_1__/* .Button */ .$n)(jodit, '', 'Insert', 'primary').onAction(() => formCode.submit())
            ])
        ]), tabs = [], insertCode = (code) => {
            jodit.s.restore();
            jodit.s.insertHTML(code);
            close();
        };
        jodit.s.save();
        tabs.push({
            icon: 'link',
            name: 'Link',
            content: formLink.container
        }, {
            icon: 'source',
            name: 'Code',
            content: formCode.container
        });
        formLink.onSubmit(data => {
            var _a, _b, _c, _d;
            insertCode((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.call)((_b = (_a = jodit.o.video) === null || _a === void 0 ? void 0 : _a.parseUrlToVideoEmbed) !== null && _b !== void 0 ? _b : jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.convertMediaUrlToVideoEmbed, data.url, {
                width: (_c = jodit.o.video) === null || _c === void 0 ? void 0 : _c.defaultWidth,
                height: (_d = jodit.o.video) === null || _d === void 0 ? void 0 : _d.defaultHeight
            }));
        });
        formCode.onSubmit(data => {
            insertCode(data.code);
        });
        return (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_5__/* .TabsWidget */ .Zg)(jodit, tabs);
    },
    tags: ['iframe'],
    tooltip: 'Insert youtube/vimeo video'
};


/***/ }),

/***/ 31859:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   r: function() { return /* binding */ loadTree; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9979);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Loads a list of directories
 * @private
 */
function loadTree(fb) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_1__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
        fb.tree.setMod('active', true);
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.detach(fb.tree.container);
        const items = (0,jodit_modules_file_browser_fetch_load_items__WEBPACK_IMPORTED_MODULE_2__/* .loadItems */ .f)(fb);
        if (fb.o.showFoldersPanel) {
            fb.tree.setMod('loading', true);
            const tree = fb.dataProvider
                .tree(fb.state.currentPath, fb.state.currentSource)
                .then(resp => {
                fb.state.sources = resp;
            })
                .catch(fb.status)
                .finally(() => fb.tree.setMod('loading', false));
            return Promise.all([tree, items]);
        }
        fb.tree.setMod('active', false);
        return items;
    });
}


/***/ }),

/***/ 31927:
/***/ (function(module) {

module.exports["default"] = ["Scrivi qualcosa...","A proposito di Jodit","Jodit Editor","Guida utente di Jodit","contiene una guida dettagliata per l'uso.","Per informazioni sulla licenza, si prega di visitare il nostro sito web:","Acquista la versione completa","Copyright © XDSoft.net - Chupurnov Valeriy. Tutti i diritti riservati.","Link","Apri in una nuova scheda","Apri l'editor a schermo intero","Pulisci Formattazione","Colore di sfondo o del testo","Ripristina","Annulla","Grassetto","Corsivo","Inserisci lista non ordinata","Inserisci lista ordinata","Allinea al centro","Allineamento Giustificato","Allinea a Sinistra","Allinea a Destra","Inserisci una linea orizzontale","Inserisci immagine","Inserisci un file","Inserisci video Youtube/Vimeo","Inserisci link","Dimensione carattere","Tipo di font","Inserisci blocco","Normale","Intestazione 1","Intestazione 2","Intestazione 3","Intestazione 4","Citazione","Codice","Inserisci","Inserisci tabella","Riduci il rientro","Aumenta il rientro","Seleziona un carattere speciale","Inserisci un carattere speciale","Copia formato","Cambia modalita'","Margini","su","destra","giù","sinistra","Stili CSS","Classi CSS","Allinea","Destra","Centro","Sinistra","--Non Impostato--","Fonte","Titolo","Testo Alternativo","Link","Apri il link in una nuova scheda","Immagine","Archivio","Avanzato","Proprietà dell'immagine","Annulla","Accetta","Cerca file","Errore durante il caricamento dell'elenco","Errore durante il caricamento delle cartelle","Sei sicuro?","Inserisci il nome della cartella","Crea cartella","Digita il nome","Cancella immagine","Cancella file","o clicca","Testo alternativo","Carica","Sfoglia","Sfondo","Testo","Su","Centro","Sotto","Inserisci la colonna prima","Inserisci la colonna dopo","Inserisci la riga sopra","Inserisci la riga sotto","Elimina tabella","Elimina riga","Elimina colonna","Cella vuota","Caratteri: %d","Parole: %d","Barrato","Sottolineato","indice","pedice","Taglia selezione","Seleziona tutto","Pausa","Cerca per","Sostituisci con","Sostituisci","Incolla","Seleziona il contenuto da incollare","risorsa","Grassetto","Corsivo","Pennello","Link","Annulla","Ripristina","Tabella","Immagine","Gomma","Paragrafo","Dimensione del carattere","Video","Font","Approposito di","Stampa","Sottolineato","Barrato","aumenta rientro","riduci rientro","espandi","comprimi","linea orizzontale","lista non ordinata","lista ordinata","Taglia","Seleziona tutto","Includi codice","Apri link","Modifica link","Non seguire","Rimuovi link","Aggiorna","Per modificare","Recensione"," URL","Modifica","Allineamento orizzontale","Filtro","Ordina per data di modifica","Ordina per nome","Ordina per dimensione","Aggiungi cartella","Reset","Salva","Salva con nome...","Ridimensiona","Ritaglia","Larghezza","Altezza","Mantieni le proporzioni","Si","No","Rimuovi","Seleziona","Seleziona: %s","Allineamento verticala","Dividi","Fondi","Aggiungi colonna","Aggiungi riga",null,"Cancella","Dividi verticalmente","Dividi orizzontale","Bordo","Il codice è simile all'HTML. Mantieni come HTML?","Incolla come HTML","Mantieni","Inserisci come testo","Inserisci solo il testo","Puoi modificare solo le tue immagini. Vuoi scaricare questa immagine dal server?","L'immagine è stata caricata correttamente sul server!","tavolozza","Non ci sono file in questa directory.","Rinomina","Inserisci un nuovo nome","anteprima","Scarica","Incolla dagli appunti","Il tuo browser non supporta l'accesso diretto agli appunti.","Copia selezione","copia","Border radius","Mostra tutti","Applica","Si prega di compilare questo campo","Si prega di inserire un indirizzo web","Default","Cerchio","Punto","Quadrato","Trova","Trova Precedente","Trova Successivo","Il contenuto incollato proviene da un documento Microsoft Word / Excel. Vuoi mantenere il formato o pulirlo?","Incolla testo da Word rilevato","Pulisci","Inserisci il nome della classe","Premere Alt per il ridimensionamento personalizzato",null,null,null]

/***/ }),

/***/ 31970:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: function() { return /* binding */ UIImagePropertiesForm; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6455);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(931);
/* harmony import */ var jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16116);
/* harmony import */ var _ui_image_main_tab__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33403);
/* harmony import */ var _ui_image_position_tab__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(46681);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










/** @private */
let UIImagePropertiesForm = class UIImagePropertiesForm extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_2__/* .UIGroup */ .U {
    className() {
        return 'UIImagePropertiesForm';
    }
    appendChildToContainer() { }
    getElm(elementName) {
        const selfElm = super.getElm(elementName);
        if (selfElm) {
            return selfElm;
        }
        for (const child of this.elements) {
            const elm = child.getElm(elementName);
            if (elm) {
                return elm;
            }
        }
        return null;
    }
    constructor(jodit, state, activeTabState, handlers) {
        super(jodit);
        this.state = state;
        this.handlers = handlers;
        this.__mainTab = new _ui_image_main_tab__WEBPACK_IMPORTED_MODULE_5__/* .UIImageMainTab */ .k(this.jodit, this.state, this.handlers);
        this.__positionTab = new _ui_image_position_tab__WEBPACK_IMPORTED_MODULE_6__/* .UIImagePositionTab */ ._(this.jodit, this.state, this.handlers);
        this.getElm('tabsBox').appendChild((0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__/* .TabsWidget */ .Zg)(jodit, [
            { name: 'Image', content: this.__mainTab },
            { name: 'Advanced', content: this.__positionTab }
        ], activeTabState));
        this.setMod('lock-size', this.state.sizeIsLocked);
        this.append(this.__mainTab).append(this.__positionTab);
    }
    render() {
        return `<form>
		<div class="jodit-grid jodit-grid_xs-column">
			<div class="jodit_col-lg-2-5 jodit_col-xs-5-5">
				<div class="&__view-box">
					<div class="&__imageView">
						<img class="&__imageViewSrc" src="" alt=""/>
					</div>
					<div class="jodit-form__group &__imageSizes">
						<input type="text" class="jodit-input &__imageWidth"/>
						<a class="&__lockSize">${jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__/* .Icon */ .I.get('lock')}</a>
						<input type="text" class="&__imageHeight jodit-input"/>
					</div>
				</div>
			</div>
			<div class="jodit_col-lg-3-5 jodit_col-xs-5-5 &__tabsBox"></div>
		</div>
	</form>`;
    }
    onChangeSizeIsLocked() {
        const lockSize = this.getElm('lockSize');
        const imageWidth = this.getElm('imageWidth');
        lockSize.innerHTML = jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__/* .Icon */ .I.get(this.state.sizeIsLocked ? 'lock' : 'unlock');
        this.setMod('lock-size', this.state.sizeIsLocked);
        this.j.e.fire(imageWidth, 'change');
    }
    onLockSizeClick() {
        this.state.sizeIsLocked = !this.state.sizeIsLocked;
    }
    onStateValuesSizeChange() {
        const imageWidth = this.getElm('imageWidth');
        const imageHeight = this.getElm('imageHeight');
        if (imageWidth !== this.j.od.activeElement) {
            imageWidth.value = this.state.values.imageWidth.toString();
        }
        if (imageHeight !== this.j.od.activeElement) {
            imageHeight.value = this.state.values.imageHeight.toString();
        }
    }
    onImageWidthChange(e) {
        const imageWidth = this.getElm('imageWidth');
        const imageHeight = this.getElm('imageHeight');
        if (!this.state.sizeIsLocked ||
            !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isNumeric)(imageWidth.value) ||
            !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isNumeric)(imageHeight.value)) {
            this.state.values.imageWidth = imageWidth.value;
            this.state.values.imageHeight = imageHeight.value;
            return;
        }
        const w = parseFloat(imageWidth.value), h = parseFloat(imageHeight.value);
        if (e.target === imageWidth) {
            this.state.values.imageWidth = w;
            this.state.values.imageHeight = Math.round(w / this.state.ratio);
        }
        else {
            this.state.values.imageWidth = Math.round(h * this.state.ratio);
            this.state.values.imageHeight = h;
        }
    }
    onStateValuesImageSrcChange() {
        const { imageSrc } = this.state.values;
        if (!imageSrc) {
            return;
        }
        const imageViewSrc = this.getElm('imageViewSrc');
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.attr)(imageViewSrc, 'src', imageSrc);
        const image = new Image();
        image.src = imageSrc;
        this.state.image = image;
    }
    hideFieldByOptions() {
        const opt = this.j.o.image;
        [
            ['editSize', 'imageSizes'],
            ['showPreview', 'imageView']
        ].forEach(([optKey, elmKey]) => {
            const elm = this.getElm(elmKey);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.css)(elm, 'display', opt[optKey] ? null : 'none');
        });
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready'),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.sizeIsLocked')
], UIImagePropertiesForm.prototype, "onChangeSizeIsLocked", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('lockSize:click')
], UIImagePropertiesForm.prototype, "onLockSizeClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready'),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(['state.values.imageWidth', 'state.values.imageHeight'])
], UIImagePropertiesForm.prototype, "onStateValuesSizeChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([
        'imageWidth:change',
        'imageHeight:change',
        'imageWidth:keydown',
        'imageHeight:keydown',
        'imageWidth:mousedown',
        'imageHeight:mousedown',
        'imageWidth:paste',
        'imageHeight:paste'
    ]),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.debounce)()
], UIImagePropertiesForm.prototype, "onImageWidthChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready'),
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('state.values.imageSrc')
], UIImagePropertiesForm.prototype, "onStateValuesImageSrcChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready')
], UIImagePropertiesForm.prototype, "hideFieldByOptions", null);
UIImagePropertiesForm = (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_8__/* .component */ .s
], UIImagePropertiesForm);



/***/ }),

/***/ 32013:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1472 930v318q0 119-84.5 203.5t-203.5 84.5h-832q-119 0-203.5-84.5t-84.5-203.5v-832q0-119 84.5-203.5t203.5-84.5h832q63 0 117 25 15 7 18 23 3 17-9 29l-49 49q-10 10-23 10-3 0-9-2-23-6-45-6h-832q-66 0-113 47t-47 113v832q0 66 47 113t113 47h832q66 0 113-47t47-113v-254q0-13 9-22l64-64q10-10 23-10 6 0 12 3 20 8 20 29zm231-489l-814 814q-24 24-57 24t-57-24l-430-430q-24-24-24-57t24-57l110-110q24-24 57-24t57 24l263 263 647-647q24-24 57-24t57 24l110 110q24 24 24 57t-24 57z\"/> </svg>"

/***/ }),

/***/ 32014:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ tryRemoveNode; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * @private
 */
function tryRemoveNode(jodit, nodeElm, hadEffect, allowTags, denyTags, currentSelectionNode) {
    if (isRemovableNode(jodit, nodeElm, currentSelectionNode, allowTags, denyTags)) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(nodeElm);
        return true;
    }
    return hadEffect;
}
/**
 * @private
 */
function isRemovableNode(jodit, node, current, allow, deny) {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(node)) {
        if (allow && !allow[node.nodeName]) {
            return true;
        }
        if (!allow && deny && deny[node.nodeName]) {
            return true;
        }
    }
    if (!jodit.o.cleanHTML.removeEmptyElements) {
        return false;
    }
    return (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(node) &&
        node.nodeName.match(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_INLINE) != null &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTemporary(node) &&
        (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__/* .trim */ .Bq)(node.innerHTML).length === 0 &&
        (current == null || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isOrContains(node, current)));
}


/***/ }),

/***/ 32164:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'copy-format': 'Format de copie'
};


/***/ }),

/***/ 32291:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   M: function() { return /* binding */ loadStyle; },
/* harmony export */   o: function() { return /* binding */ loadExtras; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(449);
/* harmony import */ var jodit_core_helpers_utils_append_script__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27301);
/* harmony import */ var jodit_core_plugin_helpers_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(96134);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





const styles = new Set();
/**
 * @private
 */
function loadStyle(jodit, pluginName) {
    return (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
        const url = getFullUrl(jodit, pluginName, false);
        if (styles.has(url)) {
            return;
        }
        styles.add(url);
        return (0,jodit_core_helpers_utils_append_script__WEBPACK_IMPORTED_MODULE_1__/* .appendStyleAsync */ .S5)(jodit, url);
    });
}
/**
 * Call full url to the script or style file
 * @private
 */
function getFullUrl(jodit, name, js) {
    name = (0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_3__/* .kebabCase */ .k)(name);
    const min = jodit.minified ? '.min' : '';
    return (jodit.basePath +
        'plugins/' +
        name +
        '/' +
        name +
        min +
        '.' +
        (js ? 'js' : 'css'));
}
/**
 * @private
 */
function loadExtras(items, jodit, extraList, callback) {
    try {
        const needLoadExtras = extraList.filter(extra => !items.has((0,jodit_core_plugin_helpers_utils__WEBPACK_IMPORTED_MODULE_4__/* .normalizeName */ .P)(extra.name)));
        if (needLoadExtras.length) {
            load(jodit, needLoadExtras, callback);
        }
    }
    catch (e) {
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
            throw e;
        }
    }
}
/**
 * Download plugins
 * @private
 */
function load(jodit, pluginList, callback) {
    pluginList.map(extra => {
        const url = extra.url || getFullUrl(jodit, extra.name, true);
        return (0,jodit_core_helpers_utils_append_script__WEBPACK_IMPORTED_MODULE_1__/* .appendScriptAsync */ .w4)(jodit, url)
            .then(callback)
            .catch(() => null);
    });
}


/***/ }),

/***/ 32332:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   s: function() { return /* binding */ observable; }
/* harmony export */ });
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_checker_is_equal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69810);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(25376);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




const OBSERVABLE_OBJECT = Symbol('observable-object');
function isObservableObject(obj) {
    return obj[OBSERVABLE_OBJECT] !== undefined;
}
/**
 * Makes any object an observable object
 * @example
 * ```js
 * const obj = {
 *   a: 1,
 *   b: {
 *     c: 5
 *   }
 * }
 *
 * const obsObj = Jodit.modules.observable(obj);
 * console.log(obj === obsObj); // true
 * obsObj.on('change', () => {
 *   console.log('Object changed');
 * });
 * obsObj.on('change.a', () => {
 *   console.log('Key a changed');
 * });
 * obsObj.on('change.b.c', () => {
 *   console.log('Key b.c changed');
 * });
 *
 * obj.a = 6;
 * // Object changed
 * // Key a changed
 *
 * obj.b = {c: 6}
 * // Object changed
 *
 * obj.b.c = 8
 * // Object changed
 * // Key b.c changed
 * ```
 */
function observable(obj) {
    if (isObservableObject(obj)) {
        return obj;
    }
    const __lockEvent = {};
    const __onEvents = {};
    const on = (event, callback) => {
        if ((0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .c)(event)) {
            event.map(e => on(e, callback));
            return obj;
        }
        if (!__onEvents[event]) {
            __onEvents[event] = [];
        }
        __onEvents[event].push(callback);
        return obj;
    };
    const fire = (event, ...attr) => {
        if ((0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .c)(event)) {
            event.map(e => fire(e, ...attr));
            return;
        }
        try {
            if (!__lockEvent[event] && __onEvents[event]) {
                __lockEvent[event] = true;
                __onEvents[event].forEach(clb => clb.call(obj, ...attr));
            }
        }
        finally {
            __lockEvent[event] = false;
        }
    };
    const initAccessors = (dict, prefixes = []) => {
        const store = {};
        if (isObservableObject(dict)) {
            return;
        }
        Object.defineProperty(dict, OBSERVABLE_OBJECT, {
            enumerable: false,
            value: true
        });
        Object.keys(dict).forEach(_key => {
            const key = _key;
            const prefix = prefixes.concat(key).filter(a => a.length);
            store[key] = dict[key];
            const descriptor = (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_0__/* .getPropertyDescriptor */ .N)(dict, key);
            Object.defineProperty(dict, key, {
                set: (value) => {
                    const oldValue = store[key];
                    if (!(0,jodit_core_helpers_checker_is_equal__WEBPACK_IMPORTED_MODULE_2__/* .isFastEqual */ .P)(store[key], value)) {
                        fire([
                            'beforeChange',
                            `beforeChange.${prefix.join('.')}`
                        ], key, value);
                        if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_3__/* .isPlainObject */ .Q)(value)) {
                            initAccessors(value, prefix);
                        }
                        if (descriptor && descriptor.set) {
                            descriptor.set.call(obj, value);
                        }
                        else {
                            store[key] = value;
                        }
                        const sum = [];
                        fire([
                            'change',
                            ...prefix.reduce((rs, p) => {
                                sum.push(p);
                                rs.push(`change.${sum.join('.')}`);
                                return rs;
                            }, [])
                        ], prefix.join('.'), oldValue, (value === null || value === void 0 ? void 0 : value.valueOf)
                            ? value.valueOf()
                            : value);
                    }
                },
                get: () => {
                    if (descriptor && descriptor.get) {
                        return descriptor.get.call(obj);
                    }
                    return store[key];
                },
                enumerable: true,
                configurable: true
            });
            if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_3__/* .isPlainObject */ .Q)(store[key])) {
                initAccessors(store[key], prefix);
            }
        });
        Object.defineProperty(obj, 'on', {
            value: on
        });
    };
    initAccessors(obj);
    return obj;
}


/***/ }),

/***/ 32709:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $r: function() { return /* reexport safe */ _to_array__WEBPACK_IMPORTED_MODULE_2__.$; },
/* harmony export */   _j: function() { return /* reexport safe */ _as_array__WEBPACK_IMPORTED_MODULE_0__._; },
/* harmony export */   uM: function() { return /* reexport safe */ _split_array__WEBPACK_IMPORTED_MODULE_1__.u; }
/* harmony export */ });
/* harmony import */ var _as_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82317);
/* harmony import */ var _split_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42589);
/* harmony import */ var _to_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42448);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/array
 */





/***/ }),

/***/ 32782:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   L: function() { return /* binding */ sanitizeAttributes; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * @private
 */
function sanitizeAttributes(jodit, nodeElm, hadEffect) {
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(nodeElm) &&
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.sanitizeHTMLElement)(nodeElm, {
            safeJavaScriptLink: jodit.options.cleanHTML.safeJavaScriptLink,
            removeOnError: jodit.options.cleanHTML.removeOnError
        })) {
        return true;
    }
    return hadEffect;
}


/***/ }),

/***/ 33087:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   y: function() { return /* binding */ persistent; }
/* harmony export */ });
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12041);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


function persistent(target, propertyKey) {
    target.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, (component) => {
        const jodit = (0,jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_1__/* .isViewObject */ .h)(component)
            ? component
            : component.jodit, storageKey = `${jodit.options.namespace}${component.componentName}_prop_${propertyKey}`, initialValue = component[propertyKey];
        Object.defineProperty(component, propertyKey, {
            get() {
                var _a;
                return (_a = jodit.storage.get(storageKey)) !== null && _a !== void 0 ? _a : initialValue;
            },
            set(value) {
                jodit.storage.set(storageKey, value);
            }
        });
    });
}


/***/ }),

/***/ 33201:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ readLink; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(26150);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/** @private */
function readLink(state, j, values) {
    const a = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(state.sourceImage, 'a', j.editor);
    if (a) {
        values.imageLink = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .C)(a, 'href') || '';
        values.imageLinkOpenInNewTab = (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_1__/* .attr */ .C)(a, 'target') === '_blank';
    }
    else {
        values.imageLink = '';
        values.imageLinkOpenInNewTab = false;
    }
}


/***/ }),

/***/ 33403:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ UIImageMainTab; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71151);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6455);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/** @private */
let UIImageMainTab = class UIImageMainTab extends jodit_core_ui_group_group__WEBPACK_IMPORTED_MODULE_3__/* .UIGroup */ .U {
    className() {
        return 'UIImageMainTab';
    }
    appendChildToContainer() {
        // Do nothing
    }
    constructor(view, state, handlers) {
        super(view);
        this.state = state;
        this.handlers = handlers;
    }
    render() {
        return `<div class="jodit-form__group &__editSrc">
			<label>~Src~</label>
			<div class="jodit-input_group">
				<input class="jodit-input &__imageSrc" type="text"/>
				<div class="jodit-input_group-buttons &__fixImage">
						<a class="jodit-button &__changeImage">*image*</a>
						<a class="jodit-button &__editImage">*crop*</a>
				</div>
			</div>
		</div>
		<div class="jodit-form__group &__editTitle">
			<label>~Title~</label>
			<input type="text" class="jodit-input &__imageTitle"/>
		</div>
		<div class="jodit-form__group &__editAlt">
			<label>~Alternative~</label>
			<input type="text" class="jodit-input &__imageAlt"/>
		</div>
		<div class="jodit-form__group &__editLink">
			<label>~Link~</label>
			<input type="text" class="jodit-input &__imageLink"/>
		</div>
		<div class="jodit-form__group &__editLinkTarget">
			<label class="jodit_vertical_middle">
				<input type="checkbox" class="jodit-checkbox &__imageLinkOpenInNewTab"/>
				<span>~Open link in new tab~</span>
			</label>
		</div>`;
    }
    onStateImageSrcChange() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
            const imageSrc = this.getElm('imageSrc');
            imageSrc.value = this.state.values.imageSrc;
        });
    }
    onImageSrcChange() {
        this.state.values.imageSrc = this.getElm('imageSrc').value;
    }
    /**
     * Open image editor
     */
    onEditImageClick(e) {
        this.handlers.openImageEditor();
        e.stopPropagation();
    }
    /**
     * Open popup with filebrowser/uploader buttons for image
     */
    onChangeImageClick(e) {
        this.handlers.openImagePopup(this.getElm('changeImage'));
        e.stopPropagation();
    }
    onStateTitleChange() {
        const title = this.getElm('imageTitle');
        title.value = this.state.values.imageTitle;
    }
    onTitleChange() {
        this.state.values.imageTitle = this.getElm('imageTitle').value;
    }
    onStateAltChange() {
        const alt = this.getElm('imageAlt');
        alt.value = this.state.values.imageAlt;
    }
    onAltChange() {
        this.state.values.imageAlt = this.getElm('imageAlt').value;
    }
    onStateImageLinkChange() {
        const imageLink = this.getElm('imageLink');
        imageLink.value = this.state.values.imageLink;
    }
    onImageLinkChange() {
        this.state.values.imageLink = this.getElm('imageLink').value;
    }
    onStateImageLinkOpenInNewTabChange() {
        const imageLinkOpenInNewTab = this.getElm('imageLinkOpenInNewTab');
        imageLinkOpenInNewTab.checked = this.state.values.imageLinkOpenInNewTab;
    }
    onImageLinkOpenInNewTabChange() {
        this.state.values.imageLinkOpenInNewTab = this.getElm('imageLinkOpenInNewTab').checked;
    }
    hideFieldByOptions() {
        const o = this.j.o;
        const opt = o.image;
        [
            ['editSrc', 'editSrc'],
            ['editTitle', 'editTitle'],
            ['editAlt', 'editAlt'],
            ['editLink', 'editLink'],
            ['editLink', 'editLinkTarget'],
            ['useImageEditor', 'editImage']
        ].forEach(([optKey, elmKey]) => {
            const elm = this.getElm(elmKey);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.css)(elm, 'display', opt[optKey] ? null : 'none');
        });
        const changeImage = this.getElm('changeImage');
        const needShowChangeImage = Boolean(o.filebrowser.ajax.url || o.uploader.url);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.css)(changeImage, 'display', needShowChangeImage ? null : 'none');
        const editImage = this.getElm('editImage');
        const needShowEditImage = Boolean(o.filebrowser.ajax.url) && opt.useImageEditor;
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.css)(editImage, 'display', needShowEditImage ? null : 'none');
        const fixImage = this.getElm('fixImage');
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.css)(fixImage, 'display', needShowChangeImage || needShowEditImage ? null : 'none');
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.imageSrc')
], UIImageMainTab.prototype, "onStateImageSrcChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('imageSrc:change')
], UIImageMainTab.prototype, "onImageSrcChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('editImage:click')
], UIImageMainTab.prototype, "onEditImageClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('changeImage:click')
], UIImageMainTab.prototype, "onChangeImageClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.imageTitle')
], UIImageMainTab.prototype, "onStateTitleChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('imageTitle:change')
], UIImageMainTab.prototype, "onTitleChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.imageAlt')
], UIImageMainTab.prototype, "onStateAltChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('imageAlt:change')
], UIImageMainTab.prototype, "onAltChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.imageLink')
], UIImageMainTab.prototype, "onStateImageLinkChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('imageLink:change')
], UIImageMainTab.prototype, "onImageLinkChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.imageLinkOpenInNewTab')
], UIImageMainTab.prototype, "onStateImageLinkOpenInNewTabChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('imageLinkOpenInNewTab:change')
], UIImageMainTab.prototype, "onImageLinkOpenInNewTabChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready')
], UIImageMainTab.prototype, "hideFieldByOptions", null);
UIImageMainTab = (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_5__/* .component */ .s
], UIImageMainTab);



/***/ }),

/***/ 33733:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   q: function() { return /* binding */ openImagePopup; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_size_position__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(27594);
/* harmony import */ var jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(80071);
/* harmony import */ var jodit_modules_widget_file_selector_file_selector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10067);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/** @private */
function openImagePopup(j, dialog, state, button) {
    const popup = new jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_0__/* .Popup */ .z(dialog);
    const closePopup = () => {
        popup.close();
        popup.destruct();
    };
    popup
        .setContent((0,jodit_modules_widget_file_selector_file_selector__WEBPACK_IMPORTED_MODULE_1__/* .FileSelectorWidget */ .k)(j, {
        upload: (data) => {
            if (data.files && data.files.length) {
                state.values.imageSrc =
                    data.baseurl + data.files[0];
            }
            closePopup();
        },
        filebrowser: (data) => (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
            if (data && (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_3__/* .isArray */ .c)(data.files) && data.files.length) {
                state.values.imageSrc = data.files[0];
                closePopup();
            }
        })
    }, state.image, closePopup))
        .open(() => (0,jodit_core_helpers_size_position__WEBPACK_IMPORTED_MODULE_4__/* .position */ .G)(button));
}


/***/ }),

/***/ 34045:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1664 256v448q0 26-19 45t-45 19h-448q-42 0-59-40-17-39 14-69l138-138q-148-137-349-137-104 0-198.5 40.5t-163.5 109.5-109.5 163.5-40.5 198.5 40.5 198.5 109.5 163.5 163.5 109.5 198.5 40.5q119 0 225-52t179-147q7-10 23-12 14 0 25 9l137 138q9 8 9.5 20.5t-7.5 22.5q-109 132-264 204.5t-327 72.5q-156 0-298-61t-245-164-164-245-61-298 61-298 164-245 245-164 298-61q147 0 284.5 55.5t244.5 156.5l130-129q29-31 70-14 39 17 39 59z\"/> </svg>"

/***/ }),

/***/ 34125:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ej: function() { return /* reexport safe */ _object_size__WEBPACK_IMPORTED_MODULE_3__.E; },
/* harmony export */   G1: function() { return /* reexport safe */ _position__WEBPACK_IMPORTED_MODULE_5__.G; },
/* harmony export */   cY: function() { return /* reexport safe */ _offset__WEBPACK_IMPORTED_MODULE_4__.c; },
/* harmony export */   mH: function() { return /* reexport safe */ _get_scroll_parent__WEBPACK_IMPORTED_MODULE_1__.m; },
/* harmony export */   xM: function() { return /* reexport safe */ _inner_width__WEBPACK_IMPORTED_MODULE_2__.x; },
/* harmony export */   y6: function() { return /* reexport safe */ _get_content_width__WEBPACK_IMPORTED_MODULE_0__.y; }
/* harmony export */ });
/* harmony import */ var _get_content_width__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(73780);
/* harmony import */ var _get_scroll_parent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98228);
/* harmony import */ var _inner_width__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(49744);
/* harmony import */ var _object_size__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(95350);
/* harmony import */ var _offset__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(91594);
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27594);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/size
 */








/***/ }),

/***/ 34248:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   t: function() { return /* binding */ ContextMenu; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92032);
/* harmony import */ var jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80071);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Module to generate context menu
 */
let ContextMenu = class ContextMenu extends jodit_core_ui_popup_popup__WEBPACK_IMPORTED_MODULE_1__/* .Popup */ .z {
    /** @override */
    className() {
        return 'ContextMenu';
    }
    /**
     * Generate and show context menu
     *
     * @param x - Global coordinate by X
     * @param y - Global coordinate by Y
     * @param actions - Array with plain objects `{icon: 'bin', title: 'Delete', exec: function () {}}`
     * @example
     * ```javascript
     * parent.show(e.clientX, e.clientY, [{icon: 'bin', title: 'Delete', exec: function () { alert(1) }}]);
     * ```
     */
    show(x, y, actions) {
        const self = this;
        self.clear();
        if (!(0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_2__/* .isArray */ .c)(actions)) {
            return;
        }
        actions.forEach(item => {
            if (!item) {
                return;
            }
            const action = (0,jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__/* .Button */ .$n)(this.jodit, item.icon || 'empty', item.title);
            this.jodit && action.setParentView(this.jodit);
            action.setMod('context', 'menu');
            action.onAction((e) => {
                var _a;
                (_a = item.exec) === null || _a === void 0 ? void 0 : _a.call(self, e);
                self.clear();
                self.close();
                return false;
            });
            this.append(action);
        });
        this.open(() => ({ left: x, top: y, width: 0, height: 0 }), true);
    }
};
ContextMenu = (0,tslib__WEBPACK_IMPORTED_MODULE_3__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_4__/* .component */ .s
], ContextMenu);



/***/ }),

/***/ 34256:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Fc: function() { return /* reexport safe */ _alert__WEBPACK_IMPORTED_MODULE_0__.F; },
/* harmony export */   XG: function() { return /* reexport safe */ _prompt__WEBPACK_IMPORTED_MODULE_3__.X; },
/* harmony export */   lG: function() { return /* reexport safe */ _dialog__WEBPACK_IMPORTED_MODULE_2__.l; },
/* harmony export */   pT: function() { return /* reexport safe */ _confirm__WEBPACK_IMPORTED_MODULE_1__.p; }
/* harmony export */ });
/* harmony import */ var _alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5854);
/* harmony import */ var _confirm__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23132);
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(58006);
/* harmony import */ var _prompt__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(91560);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:modules/dialog/README.md]]
 * @packageDocumentation
 * @module modules/dialog
 */






/***/ }),

/***/ 34446:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* binding */ ctrlKey; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */
/**
 * CTRL pressed
 * @returns true ctrl key was pressed
 */
const ctrlKey = (e) => {
    if (typeof navigator !== 'undefined' &&
        navigator.userAgent.indexOf('Mac OS X') !== -1) {
        if (e.metaKey && !e.altKey) {
            return true;
        }
    }
    else if (e.ctrlKey && !e.altKey) {
        return true;
    }
    return false;
};


/***/ }),

/***/ 34796:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   a: function() { return /* binding */ isNativeFunction; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check if function or method was not replaced on some custom implementation
 */
function isNativeFunction(f) {
    return (Boolean(f) &&
        (typeof f).toLowerCase() === 'function' &&
        (f === Function.prototype ||
            /^\s*function\s*(\b[a-z$_][a-z0-9$_]*\b)*\s*\((|([a-z$_][a-z0-9$_]*)(\s*,[a-z$_][a-z0-9$_]*)*)\)\s*{\s*\[native code]\s*}\s*$/i.test(String(f))));
}


/***/ }),

/***/ 34899:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ OptionsError; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */
class OptionsError extends TypeError {
    constructor(m) {
        super(m);
        Object.setPrototypeOf(this, OptionsError.prototype);
    }
}


/***/ }),

/***/ 35265:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $n: function() { return /* reexport safe */ _button_button__WEBPACK_IMPORTED_MODULE_0__.$n; },
/* harmony export */   SB: function() { return /* reexport safe */ _tooltip_tooltip__WEBPACK_IMPORTED_MODULE_2__.S; },
/* harmony export */   lD: function() { return /* reexport safe */ _button_button__WEBPACK_IMPORTED_MODULE_0__.lD; },
/* harmony export */   ss: function() { return /* reexport safe */ _group_group__WEBPACK_IMPORTED_MODULE_1__.s; },
/* harmony export */   ue: function() { return /* reexport safe */ _button_button__WEBPACK_IMPORTED_MODULE_0__.ue; }
/* harmony export */ });
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92032);
/* harmony import */ var _group_group__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31202);
/* harmony import */ var _tooltip_tooltip__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(36434);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/ui/button/README.md]]
 * @packageDocumentation
 * @module ui/button
 */





/***/ }),

/***/ 35523:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export select */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(83260);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71005);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(53048);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(41133);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */








/**
 * A utility plugin that allows you to subscribe to a click/mousedown/touchstart/mouseup on an element in DOM order
 *
 * @example
 * ```js
 * const editor = Jodit.make('#editor');
 * editor.e.on('clickImg', (img) => {
 *   console.log(img.src);
 * })
 * ```
 */
class select extends jodit_core_plugin__WEBPACK_IMPORTED_MODULE_3__/* .Plugin */ .k {
    constructor() {
        super(...arguments);
        this.proxyEventsList = [
            'click',
            'mousedown',
            'touchstart',
            'mouseup',
            'touchend'
        ];
    }
    afterInit(jodit) {
        this.proxyEventsList.forEach(eventName => {
            jodit.e.on(eventName + '.select', this.onStartSelection);
        });
    }
    beforeDestruct(jodit) {
        this.proxyEventsList.forEach(eventName => {
            jodit.e.on(eventName + '.select', this.onStartSelection);
        });
    }
    onStartSelection(e) {
        const { j } = this;
        let result, target = e.target;
        while (result === undefined && target && target !== j.editor) {
            result = j.e.fire((0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_6__/* .camelCase */ .x)(e.type + '_' + target.nodeName.toLowerCase()), target, e);
            target = target.parentElement;
        }
        if (e.type === 'click' && result === undefined && target === j.editor) {
            j.e.fire(e.type + 'Editor', target, e);
        }
    }
    /**
     * @event outsideClick(e) - when user clicked on the outside of editor
     */
    onOutsideClick(e) {
        const node = e.target;
        if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.up(node, elm => elm === this.j.editor)) {
            return;
        }
        const box = jodit_core_ui__WEBPACK_IMPORTED_MODULE_4__/* .UIElement */ .D$.closestElement(node, jodit_core_ui__WEBPACK_IMPORTED_MODULE_4__/* .Popup */ .zD);
        if (!box) {
            this.j.e.fire('outsideClick', e);
        }
    }
    beforeCommandCut() {
        const { s } = this.j;
        if (!s.isCollapsed()) {
            const current = s.current();
            if (current && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isOrContains(this.j.editor, current)) {
                this.onCopyNormalizeSelectionBound();
            }
        }
    }
    beforeCommandSelectAll() {
        const { s } = this.j;
        s.focus();
        s.select(this.j.editor, true);
        s.expandSelection();
        return false;
    }
    /**
     * Normalize selection after triple click
     */
    onTripleClickNormalizeSelection(e) {
        if (e.detail !== 3 || !this.j.o.select.normalizeTripleClick) {
            return;
        }
        const { s } = this.j;
        const { startContainer, startOffset } = s.range;
        if (startOffset === 0 && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(startContainer)) {
            s.select(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(startContainer, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isBlock, this.j.editor) ||
                startContainer, true);
        }
    }
    onCopyNormalizeSelectionBound(e) {
        const { s, editor, o } = this.j;
        if (!o.select.normalizeSelectionBeforeCutAndCopy || s.isCollapsed()) {
            return;
        }
        if (e &&
            (!e.isTrusted ||
                !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isNode(e.target) ||
                !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isOrContains(editor, e.target))) {
            return;
        }
        this.jodit.s.expandSelection();
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], select.prototype, "onStartSelection", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)('ow:click')
], select.prototype, "onOutsideClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([':beforeCommandCut'])
], select.prototype, "beforeCommandCut", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([':beforeCommandSelectall'])
], select.prototype, "beforeCommandSelectAll", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([':click'])
], select.prototype, "onTripleClickNormalizeSelection", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([':copy', ':cut'])
], select.prototype, "onCopyNormalizeSelectionBound", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('select', select);


/***/ }),

/***/ 35541:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export symbols */
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29866);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(61964);
/* harmony import */ var _langs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(84182);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */








/**
 * The plugin inserts characters that are not part of the standard keyboard.
 */
class symbols extends jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k {
    constructor(jodit) {
        super(jodit);
        this.buttons = [
            {
                name: 'symbols',
                group: 'insert'
            }
        ];
        this.__countInRow = 17;
        (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .extendLang */ .JW)(_langs__WEBPACK_IMPORTED_MODULE_6__);
    }
    afterInit(jodit) {
        jodit.e.on('generateSpecialCharactersTable.symbols', () => {
            const container = jodit.c.fromHTML(`<div class="jodit-symbols__container">
						<div class="jodit-symbols__container_table">
							<table class="jodit-symbols__table"><tbody></tbody></table>
						</div>
						<div class="jodit-symbols__container_preview">
							<div class="jodit-symbols__preview"></div>
						</div>
					</div>`);
            const preview = container.querySelector('.jodit-symbols__preview');
            const table = container.querySelector('table');
            const body = table.tBodies[0];
            const chars = [];
            for (let i = 0; i < jodit.o.specialCharacters.length;) {
                const tr = jodit.c.element('tr');
                for (let j = 0; j < this.__countInRow &&
                    i < jodit.o.specialCharacters.length; j += 1, i += 1) {
                    const td = jodit.c.element('td'), a = jodit.c.fromHTML(`<a
									data-index="${i}"
									data-index-j="${j}"
									role="option"
									tabindex="-1"
							>${jodit.o.specialCharacters[i]}</a>`);
                    chars.push(a);
                    td.appendChild(a);
                    tr.appendChild(td);
                }
                body.appendChild(tr);
            }
            const self = this;
            jodit.e
                .on(chars, 'focus', function () {
                preview.innerHTML = this.innerHTML;
            })
                .on(chars, 'mousedown', function (e) {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(this, 'a')) {
                    jodit.s.focus();
                    jodit.s.insertHTML(this.innerHTML);
                    if (!(e === null || e === void 0 ? void 0 : e.shiftKey)) {
                        jodit.e.fire(this, 'close_dialog');
                    }
                    e && e.preventDefault();
                    e && e.stopImmediatePropagation();
                }
            })
                .on(chars, 'mouseenter', function () {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(this, 'a')) {
                    this.focus();
                }
            })
                .on(chars, 'keydown', (e) => {
                const target = e.target;
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(target, 'a')) {
                    const index = parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(target, '-index') || '0', 10), jIndex = parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(target, 'data-index-j') || '0', 10);
                    let newIndex;
                    switch (e.key) {
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP:
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_DOWN:
                            newIndex =
                                e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP
                                    ? index - self.__countInRow
                                    : index + self.__countInRow;
                            if (chars[newIndex] === undefined) {
                                newIndex =
                                    e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_UP
                                        ? Math.floor(chars.length /
                                            self.__countInRow) *
                                            self.__countInRow +
                                            jIndex
                                        : jIndex;
                                if (newIndex > chars.length - 1) {
                                    newIndex -= self.__countInRow;
                                }
                            }
                            chars[newIndex] && chars[newIndex].focus();
                            break;
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_RIGHT:
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT:
                            newIndex =
                                e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT ? index - 1 : index + 1;
                            if (chars[newIndex] === undefined) {
                                newIndex =
                                    e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_LEFT
                                        ? chars.length - 1
                                        : 0;
                            }
                            chars[newIndex] && chars[newIndex].focus();
                            break;
                        case jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_ENTER:
                            jodit.e.fire(target, 'mousedown');
                            e.stopImmediatePropagation();
                            e.preventDefault();
                            break;
                    }
                }
            });
            return container;
        });
    }
    /** @override */
    beforeDestruct(jodit) {
        jodit.e.off('generateSpecialCharactersTable.symbols');
    }
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('symbols', symbols);


/***/ }),

/***/ 35642:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   R: function() { return /* binding */ isVoid; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check value is undefined or null
 */
function isVoid(value) {
    // eslint-disable-next-line eqeqeq
    return value === undefined || value === null;
}


/***/ }),

/***/ 36001:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/resize-cells
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.tableAllowCellResize = true;


/***/ }),

/***/ 36115:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   T: function() { return /* binding */ Config; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Editor options. These can be configured upon the creation of the editor.
 * ```javascript
 * const editor = Jodit.make('#editor', {
 * 	 toolbar: true,
 * 	 buttons: ['bold', 'italic', 'underline']
 * 	 // other options
 * 	 // ...
 * });
 * ```
 * @packageDocumentation
 * @module config
 */


/**
 * Default Editor's Configuration
 */
class Config {
    constructor() {
        /**
         * Use cache for heavy methods
         */
        this.cache = true;
        /**
         * Timeout of all asynchronous methods
         */
        this.defaultTimeout = 100;
        this.namespace = '';
        /**
         * Editor loads completely without plugins. Useful when debugging your own plugin.
         */
        this.safeMode = false;
        /**
         * Editor's width
         *
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    width: '100%',
         * })
         * ```
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    width: 600, // equivalent for '600px'
         * })
         * ```
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    width: 'auto', // autosize
         * })
         * ```
         */
        this.width = 'auto';
        /**
         * Editor's height
         *
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    height: '100%',
         * })
         * ```
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    height: 600, // equivalent for '600px'
         * })
         * ```
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    height: 'auto', // default - autosize
         * })
         * ```
         */
        this.height = 'auto';
        /**
         * List of plugins that will be initialized in safe mode.
         *
         * ```js
         * Jodit.make('#editor', {
         * 	safeMode: true,
         * 	safePluginsList: ['about'],
         * 	extraPlugins: ['yourPluginDev']
         * });
         * ```
         */
        this.safePluginsList = [
            'about',
            'enter',
            'backspace',
            'size',
            'bold',
            'hotkeys'
        ];
        /**
         * Reserved for the paid version of the editor
         */
        this.license = '';
        /**
         * The name of the preset that will be used to initialize the editor.
         * The list of available presets can be found here Jodit.defaultOptions.presets
         * ```javascript
         * Jodit.make('.editor', {
         * 	preset: 'inline'
         * });
         * ```
         */
        this.preset = 'custom';
        this.presets = {
            inline: {
                inline: true,
                toolbar: false,
                toolbarInline: true,
                toolbarInlineForSelection: true,
                showXPathInStatusbar: false,
                showCharsCounter: false,
                showWordsCounter: false,
                showPlaceholder: false
            }
        };
        this.ownerDocument = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument;
        /**
         * Allows you to specify the window in which the editor will be created. Default - window
         * This is necessary if you are creating the editor inside an iframe but the code is running in the parent window
         */
        this.ownerWindow = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalWindow;
        /**
         * Shadow root if Jodit was created in it
         *
         * ```html
         * <div id="editor"></div>
         * ```
         *
         * ```js
         * const app = document.getElementById('editor');
         * app.attachShadow({ mode: 'open' });
         * const root = app.shadowRoot;
         *
         * root.innerHTML = `
         * <link rel="stylesheet" href="./build/jodit.css"/>
         * <h1>Jodit example in Shadow DOM</h1>
         * <div id="edit"></div>
         * `;
         *
         * const editor = Jodit.make(root.getElementById('edit'), {
         * 	globalFullSize: false,
         * 	shadowRoot: root
         * });
         * editor.value = '<p>start</p>';
         * ```
         */
        this.shadowRoot = null;
        /**
         * z-index For editor
         */
        this.zIndex = 0;
        /**
         * Change the read-only state of the editor
         */
        this.readonly = false;
        /**
         * Change the disabled state of the editor
         */
        this.disabled = false;
        /**
         * In readOnly mode, some buttons can still be useful, for example, the button to view source code or print
         */
        this.activeButtonsInReadOnly = [
            'source',
            'fullsize',
            'print',
            'about',
            'dots',
            'selectall'
        ];
        /**
         * When the editor is in read-only mode, some commands can still be executed:
         * ```javascript
         * const editor = Jodit.make('.editor', {
         * 	 allowCommandsInReadOnly: ['selectall', 'preview', 'print']
         * 	 readonly: true
         * });
         * editor.execCommand('selectall');// will be selected all content
         * editor.execCommand('delete');// but content will not be deleted
         * ```
         */
        this.allowCommandsInReadOnly = ['selectall', 'preview', 'print'];
        /**
         * Size of icons in the toolbar (can be "small", "middle", "large")
         *
         * @example
         * ```javascript
         * const editor = Jodit.make(".dark_editor", {
         *      toolbarButtonSize: "small"
         * });
         * ```
         */
        this.toolbarButtonSize = 'middle';
        /**
         * Allow navigation in the toolbar of the editor by Tab key
         */
        this.allowTabNavigation = false;
        /**
         * Inline editing mode
         */
        this.inline = false;
        /**
         * Theme (can be "dark")
         * @example
         * ```javascript
         * const editor = Jodit.make(".dark_editor", {
         *      theme: "dark"
         * });
         * ```
         */
        this.theme = 'default';
        /**
         * if set true, then the current mode is saved in a cookie, and is restored after a reload of the page
         */
        this.saveModeInStorage = false;
        /**
         * Class name that can be appended to the editable area
         *
         * @see [[Config.iframeCSSLinks]]
         * @see [[Config.iframeStyle]]
         *
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         *    editorClassName: 'some_my_class'
         * });
         * ```
         * ```html
         * <style>
         * .some_my_class p{
         *    line-height: 16px;
         * }
         * </style>
         * ```
         */
        this.editorClassName = false;
        /**
         * Class name that can be appended to the main editor container
         * @example
         * ```javascript
         * const jodit = Jodit.make('#editor', {
         *    className: 'some_my_class'
         * });
         *
         * console.log(jodit.container.classList.contains('some_my_class')); // true
         * ```
         * ```html
         * <style>
         * .some_my_class {
         *    max-width: 600px;
         *    margin: 0 auto;
         * }
         * </style>
         * ```
         */
        this.className = false;
        /**
         * The internal styles of the editable area. They are intended to change
         * not the appearance of the editor, but to change the appearance of the content.
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         * 		style: {
         * 		 font: '12px Arial',
         * 		 color: '#0c0c0c'
         * 		}
         * });
         * ```
         */
        this.style = false;
        /**
         *
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         * 		editorStyle: {
         * 		 font: '12px Arial',
         * 		 color: '#0c0c0c'
         * 		}
         * });
         * ```
         */
        this.containerStyle = false;
        /**
         * Dictionary of variable values in css, a complete list can be found here
         * https://github.com/xdan/jodit/blob/main/src/styles/variables.less#L25
         *
         * @example
         * ```js
         * const editor = Jodit.make('#editor', {
         *   styleValues: {
         *		'color-text': 'red',
         *		colorBorder: 'black',
         *		'color-panel': 'blue'
         *   }
         * });
         * ```
         */
        this.styleValues = {};
        /**
         * After all, changes in editors for textarea will call change trigger
         *
         * @example
         * ```javascript
         * const editor = Jodit.make('#editor');
         * document.getElementById('editor').addEventListener('change', function () {
         *      console.log(this.value);
         * })
         * ```
         */
        this.triggerChangeEvent = true;
        /**
         * The writing direction of the language which is used to create editor content. Allowed values are: ''
         * (an empty string) – Indicates that content direction will be the same as either the editor UI direction or
         * the page element direction. 'ltr' – Indicates a Left-To-Right text direction (like in English).
         * 'rtl' – Indicates a Right-To-Left text direction (like in Arabic).
         *
         * @example
         * ```javascript
         * Jodit.make('.editor', {
         *    direction: 'rtl'
         * })
         * ```
         */
        this.direction = '';
        /**
         * Language by default. if `auto` language set by document.documentElement.lang ||
         * (navigator.language && navigator.language.substr(0, 2)) ||
         * (navigator.browserLanguage && navigator.browserLanguage.substr(0, 2)) || 'en'
         *
         * @example
         * ```html
         * <!-- include in you page lang file -->
         * <script src="jodit/lang/de.js"></script>
         * <script>
         * var editor = Jodit.make('.editor', {
         *    language: 'de'
         * });
         * </script>
         * ```
         */
        this.language = 'auto';
        /**
         * if true all Lang.i18n(key) return `{key}`
         *
         * @example
         * ```html
         * <script>
         * var editor = Jodit.make('.editor', {
         *    debugLanguage: true
         * });
         *
         * console.log(editor.i18n("Test")); // {Test}
         * </script>
         * ```
         */
        this.debugLanguage = false;
        /**
         * Collection of language pack data `{en: {'Type something': 'Type something', ...}}`
         *
         * @example
         * ```javascript
         * const editor = Jodit.make('#editor', {
         *     language: 'ru',
         *     i18n: {
         *         ru: {
         *            'Type something': 'Начните что-либо вводить'
         *         }
         *     }
         * });
         * console.log(editor.i18n('Type something')) //Начните что-либо вводить
         * ```
         */
        this.i18n = false;
        /**
         * The tabindex global attribute is an integer indicating if the element can take
         * input focus (is focusable), if it should participate to sequential keyboard navigation,
         * and if so, at what position. It can take several values
         */
        this.tabIndex = -1;
        /**
         * Boolean, whether the toolbar should be shown.
         * Alternatively, a valid css-selector-string to use an element as toolbar container.
         */
        this.toolbar = true;
        /**
         * Boolean, whether the statusbar should be shown.
         */
        this.statusbar = true;
        /**
         * Show tooltip after mouse enter on the button
         */
        this.showTooltip = true;
        /**
         * Delay before show tooltip
         */
        this.showTooltipDelay = 200;
        /**
         * Instead of create custop tooltip - use native title tooltips
         */
        this.useNativeTooltip = false;
        /**
         * Default insert method
         * @default insert_as_html
         */
        this.defaultActionOnPaste = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSERT_AS_HTML;
        // TODO
        // autosave: false, // false or url
        // autosaveCallback: false, // function
        // interval: 60, // seconds
        // TODO
        /**
         * Element that will be created when you press Enter
         */
        this.enter = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.PARAGRAPH;
        /**
         * When this option is enabled, the editor's content will be placed in an iframe and isolated from the rest of the page.
         *
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         *    iframe: true,
         *    iframeStyle: 'html{margin: 0px;}body{padding:10px;background:transparent;color:#000;position:relative;z-index:2;\
         *    user-select:auto;margin:0px;overflow:hidden;}body:after{content:"";clear:both;display:block}';
         * });
         * ```
         */
        this.iframe = false;
        /**
         * Allow editing the entire HTML document(html, head)
         * \> Works together with the iframe option.
         * @example
         * ```js
         * const editor = Jodit.make('#editor', {
         *   iframe: true,
         *   editHTMLDocumentMode: true
         * });
         * editor.value = '<!DOCTYPE html><html lang="en" style="overflow-y:hidden">' +
         * 	'<head><title>Jodit Editor</title></head>' +
         * 	'<body spellcheck="false"><p>Some text</p><p> a </p></body>' +
         * 	'</html>';
         * ```
         */
        this.editHTMLDocumentMode = false;
        /**
         * Use when you need to insert new block element
         * use enter option if not set
         */
        this.enterBlock = this.enter !== 'br' ? this.enter : jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.PARAGRAPH;
        /**
         * Jodit.MODE_WYSIWYG The HTML editor allows you to write like MSWord,
         * Jodit.MODE_SOURCE syntax highlighting source editor
         * @example
         * ```javascript
         * var editor = Jodit.make('#editor', {
         *     defaultMode: Jodit.MODE_SPLIT
         * });
         * console.log(editor.getRealMode())
         * ```
         */
        this.defaultMode = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        /**
         * Use split mode
         */
        this.useSplitMode = false;
        /**
         * The colors in HEX representation to select a color for the background and for the text in colorpicker
         * @example
         * ```javascript
         *  Jodit.make('#editor', {
         *     colors: ['#ff0000', '#00ff00', '#0000ff']
         * })
         * ```
         */
        this.colors = {
            greyscale: [
                '#000000',
                '#434343',
                '#666666',
                '#999999',
                '#B7B7B7',
                '#CCCCCC',
                '#D9D9D9',
                '#EFEFEF',
                '#F3F3F3',
                '#FFFFFF'
            ],
            palette: [
                '#980000',
                '#FF0000',
                '#FF9900',
                '#FFFF00',
                '#00F0F0',
                '#00FFFF',
                '#4A86E8',
                '#0000FF',
                '#9900FF',
                '#FF00FF'
            ],
            full: [
                '#E6B8AF',
                '#F4CCCC',
                '#FCE5CD',
                '#FFF2CC',
                '#D9EAD3',
                '#D0E0E3',
                '#C9DAF8',
                '#CFE2F3',
                '#D9D2E9',
                '#EAD1DC',
                '#DD7E6B',
                '#EA9999',
                '#F9CB9C',
                '#FFE599',
                '#B6D7A8',
                '#A2C4C9',
                '#A4C2F4',
                '#9FC5E8',
                '#B4A7D6',
                '#D5A6BD',
                '#CC4125',
                '#E06666',
                '#F6B26B',
                '#FFD966',
                '#93C47D',
                '#76A5AF',
                '#6D9EEB',
                '#6FA8DC',
                '#8E7CC3',
                '#C27BA0',
                '#A61C00',
                '#CC0000',
                '#E69138',
                '#F1C232',
                '#6AA84F',
                '#45818E',
                '#3C78D8',
                '#3D85C6',
                '#674EA7',
                '#A64D79',
                '#85200C',
                '#990000',
                '#B45F06',
                '#BF9000',
                '#38761D',
                '#134F5C',
                '#1155CC',
                '#0B5394',
                '#351C75',
                '#733554',
                '#5B0F00',
                '#660000',
                '#783F04',
                '#7F6000',
                '#274E13',
                '#0C343D',
                '#1C4587',
                '#073763',
                '#20124D',
                '#4C1130'
            ]
        };
        /**
         * The default tab color picker
         * @example
         * ```javascript
         * Jodit.make('#editor2', {
         *     colorPickerDefaultTab: 'color'
         * })
         * ```
         */
        this.colorPickerDefaultTab = 'background';
        /**
         * Image size defaults to a larger image
         */
        this.imageDefaultWidth = 300;
        /**
         * Do not display these buttons that are on the list
         * @example
         * ```javascript
         * Jodit.make('#editor2', {
         *     removeButtons: ['hr', 'source']
         * });
         * ```
         */
        this.removeButtons = [];
        /**
         * Do not init these plugins
         * @example
         * ```typescript
         * var editor = Jodit.make('.editor', {
         *    disablePlugins: 'table,iframe'
         * });
         * //or
         * var editor = Jodit.make('.editor', {
         *    disablePlugins: ['table', 'iframe']
         * });
         * ```
         */
        this.disablePlugins = [];
        /**
         * Init and download extra plugins
         * @example
         * ```typescript
         * var editor = Jodit.make('.editor', {
         *    extraPlugins: ['emoji']
         * });
         * ```
         * It will try load %SCRIPT_PATH%/plugins/emoji/emoji.js and after load will try init it
         */
        this.extraPlugins = [];
        /**
         * These buttons list will be added to the option. Buttons
         */
        this.extraButtons = [];
        /**
         * By default, you can only install an icon from the Jodit suite.
         * You can add your icon to the set using the `Jodit.modules.Icon.set (name, svg Code)` method.
         * But for a declarative declaration, you can use this option.
         *
         * @example
         * ```js
         * Jodit.modules.Icon.set('someIcon', '<svg><path.../></svg>');
         * const editor = Jodit.make({
         *   extraButtons: [{
         *     name: 'someButton',
         *     icon: 'someIcon'
         *   }]
         * });
         *
         * @example
         * const editor = Jodit.make({
         *   extraIcons: {
         *     someIcon: '<svg><path.../></svg>'
         *   },
         *   extraButtons: [{
         *     name: 'someButton',
         *     icon: 'someIcon'
         *   }]
         * });
         * ```
         * @example
         * ```js
         * const editor = Jodit.make({
         *   extraButtons: [{
         *     name: 'someButton',
         *     icon: '<svg><path.../></svg>'
         *   }]
         * });
         * ```
         */
        this.extraIcons = {};
        /**
         * Default attributes for created inside editor elements
         * @example
         * ```js
         * const editor2 = Jodit.make('#editor', {
         * 	createAttributes: {
         * 		div: {
         * 			class: 'test'
         * 		},
         * 		ul: function (ul) {
         * 			ul.classList.add('ui-test');
         * 		}
         * 	}
         * });
         *
         * const div2 = editor2.createInside.div();
         * expect(div2.className).equals('test');
         *
         * const ul = editor2.createInside.element('ul');
         * expect(ul.className).equals('ui-test');
         * ```
         * Or JSX in React
         * @example
         * ```jsx
         * import React, {useState, useRef} from 'react';
         * import JoditEditor from "jodit-react";
         *
         * const config = {
         * 	createAttributes: {
         * 		div: {
         * 			class: 'align-center'
         * 		}
         * 	}
         * };
         *
         * <JoditEditor config={config}/>
         * ```
         */
        this.createAttributes = {
            table: {
                style: 'border-collapse:collapse;width: 100%;'
            }
        };
        /**
         * The width of the editor, accepted as the biggest. Used to the responsive version of the editor
         */
        this.sizeLG = 900;
        /**
         * The width of the editor, accepted as the medium. Used to the responsive version of the editor
         */
        this.sizeMD = 700;
        /**
         * The width of the editor, accepted as the small. Used to the responsive version of the editor
         */
        this.sizeSM = 400;
        /**
         * The list of buttons that appear in the editor's toolbar on large places (≥ options.sizeLG).
         * Note - this is not the width of the device, the width of the editor
         * @example
         * ```javascript
         * Jodit.make('#editor', {
         *     buttons: ['bold', 'italic', 'source'],
         *     buttonsMD: ['bold', 'italic'],
         *     buttonsXS: ['bold', 'fullsize'],
         * });
         * ```
         * @example
         * ```javascript
         * Jodit.make('#editor2', {
         *     buttons: [{
         *         name: 'empty',
         *         icon: 'source',
         *         exec: function (editor) {
         *             const dialog = new Jodit.modules.Dialog({}),
         *                 text = editor.c.element('textarea');
         *
         *             dialog.setHeader('Source code');
         *             dialog.setContent(text);
         *             dialog.setSize(400, 300);
         *
         *             Jodit.modules.Helpers.css(elm, {
         *                 width: '100%',
         *                 height: '100%'
         *             })
    
         *             dialog.open();
         *         }
         *     }]
         * });
         * ```
         * @example
         * ```javascript
         * Jodit.make('#editor2', {
         *     buttons: Jodit.defaultOptions.buttons.concat([{
         *        name: 'listsss',
         *        iconURL: 'stuf/dummy.png',
         *        list: {
         *            h1: 'insert Header 1',
         *            h2: 'insert Header 2',
         *            clear: 'Empty editor',
         *        },
         *        exec: ({originalEvent, control, btn}) => {
         *             var key = control.args[0],
         *                value = control.args[1];
         *             if (key === 'clear') {
         *                 this.val('');
         *                 return;
         *             }
         *             this.s.insertNode(this.c.element(key, ''));
         *             this.message.info('Was inserted ' + value);
         *        },
         *        template: function (key, value) {
         *            return '<div>' + value + '</div>';
         *        }
         *  });
         * ```
         */
        this.buttons = [
            {
                group: 'font-style',
                buttons: []
            },
            {
                group: 'list',
                buttons: []
            },
            {
                group: 'font',
                buttons: []
            },
            '---',
            {
                group: 'script',
                buttons: []
            },
            {
                group: 'media',
                buttons: []
            },
            '\n',
            {
                group: 'state',
                buttons: []
            },
            {
                group: 'clipboard',
                buttons: []
            },
            {
                group: 'insert',
                buttons: []
            },
            {
                group: 'indent',
                buttons: []
            },
            {
                group: 'color',
                buttons: []
            },
            {
                group: 'form',
                buttons: []
            },
            '---',
            {
                group: 'history',
                buttons: []
            },
            {
                group: 'search',
                buttons: []
            },
            {
                group: 'source',
                buttons: []
            },
            {
                group: 'other',
                buttons: []
            },
            {
                group: 'info',
                buttons: []
            }
        ];
        /**
         * Some events are called when the editor is initialized, for example, the `afterInit` event.
         * So this code won't work:
         * ```javascript
         * const editor = Jodit.make('#editor');
         * editor.events.on('afterInit', () => console.log('afterInit'));
         * ```
         * You need to do this:
         * ```javascript
         * Jodit.make('#editor', {
         * 		events: {
         * 	  	afterInit: () => console.log('afterInit')
         * 		}
         * });
         * ```
         * The option can use any Jodit events, for example:
         * ```javascript
         * const editor = Jodit.make('#editor', {
         * 		events: {
         * 			hello: (name) => console.log('Hello', name)
         * 		}
         * });
         * editor.e.fire('hello', 'Mike');
         * ```
         */
        this.events = {};
        /**
         * Buttons in toolbat without SVG - only texts
         */
        this.textIcons = false;
        /**
         * Element for dialog container
         */
        this.popupRoot = null;
        /**
         * shows a INPUT[type=color] to open the browser color picker, on the right bottom of widget color picker
         */
        this.showBrowserColorPicker = true;
    }
    static get defaultOptions() {
        if (!Config.__defaultOptions) {
            Config.__defaultOptions = new Config();
        }
        return Config.__defaultOptions;
    }
}
Config.prototype.controls = {};



/***/ }),

/***/ 36291:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D: function() { return /* binding */ getBlockWrapper; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Finds a suitable parent block container
 * @private
 */
function getBlockWrapper(fake, jodit, tagReg = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_BLOCK) {
    let node = fake;
    const root = jodit.editor;
    do {
        if (!node || node === root) {
            break;
        }
        if (tagReg.test(node.nodeName)) {
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isLeaf(node)) {
                return node;
            }
            return (getBlockWrapper(node.parentNode, jodit, /^li$/i) ||
                node);
        }
        node = node.parentNode;
    } while (node && node !== root);
    return null;
}


/***/ }),

/***/ 36293:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export color */
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(39626);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Process commands `background` and `forecolor`
 */
function color(editor) {
    editor.registerButton({
        name: 'brush',
        group: 'color'
    });
    const callback = (command, second, third) => {
        const colorHEX = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.normalizeColor)(third);
        switch (command) {
            case 'background':
                editor.s.commitStyle({
                    attributes: {
                        style: {
                            backgroundColor: !colorHEX
                                ? ''
                                : colorHEX
                        }
                    }
                });
                break;
            case 'forecolor':
                editor.s.commitStyle({
                    attributes: {
                        style: {
                            color: !colorHEX ? '' : colorHEX
                        }
                    }
                });
                break;
        }
        editor.synchronizeValues();
        return false;
    };
    editor
        .registerCommand('forecolor', callback)
        .registerCommand('background', callback);
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_0__/* .pluginSystem */ .fg.add('color', color);


/***/ }),

/***/ 36327:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"><path d=\"M1600 736v192q0 40-28 68t-68 28h-416v416q0 40-28 68t-68 28h-192q-40 0-68-28t-28-68v-416h-416q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h416v-416q0-40 28-68t68-28h192q40 0 68 28t28 68v416h416q40 0 68 28t28 68z\"/></svg>"

/***/ }),

/***/ 36339:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1792 352v1088q0 42-39 59-13 5-25 5-27 0-45-19l-403-403v166q0 119-84.5 203.5t-203.5 84.5h-704q-119 0-203.5-84.5t-84.5-203.5v-704q0-119 84.5-203.5t203.5-84.5h704q119 0 203.5 84.5t84.5 203.5v165l403-402q18-19 45-19 12 0 25 5 39 17 39 59z\"/> </svg>"

/***/ }),

/***/ 36434:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   S: function() { return /* binding */ UITooltip; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_size_position__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(27594);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29780);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var UITooltip_1;









const WINDOW_EVENTS_ON_HIDE = [
    'scroll.tooltip',
    'joditCloseDialog',
    'mouseleave.tooltip'
];
const JODIT_EVENTS_ON_HIDE = [
    'escape.tooltip',
    'change.tooltip',
    'changePlace.tooltip',
    'afterOpenPopup.tooltip',
    'hidePopup.tooltip',
    'beforePopupClose.tooltip',
    'closeAllPopups.tooltip'
];
let UITooltip = UITooltip_1 = class UITooltip extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_5__/* .UIElement */ .D {
    className() {
        return 'UITooltip';
    }
    render() {
        return '<div><div class="&__content"></div></div>';
    }
    constructor(view) {
        super(view);
        this.__isOpened = false;
        this.__attachedContainers = new Set();
        this.__listenClose = false;
        this.__currentTarget = null;
        this.__delayShowTimeout = 0;
        this.__hideTimeout = 0;
        if (!view.o.textIcons &&
            view.o.showTooltip &&
            !view.o.useNativeTooltip) {
            this.j.e.on('getContainer', (box) => {
                this.__onAttach(box);
            });
            view.hookStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, () => {
                this.__onAttach(this.j.container);
            });
        }
    }
    __onAttach(container) {
        // TODO Move it inside __show method. Now it is here because testcase failed with capturing
        (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .getContainer */ .My)(this.j, UITooltip_1).appendChild(this.container);
        this.__attachedContainers.add(container);
        this.__attachedContainers.add(this.j.container);
        this.j.e
            .on(container, 'mouseenter.tooltip', this.__onMouseEnter, {
            capture: true
        })
            .on(container, 'mouseleave.tooltip', this.__onMouseLeave, {
            capture: true
        })
            .on(this.j.container, 'mouseleave.tooltip', this.__onMouseLeave, {
            capture: true
        });
    }
    __addListenersOnEnter() {
        if (this.__listenClose) {
            return;
        }
        this.__listenClose = true;
        const view = this.j;
        view.e
            .on(view.ow, WINDOW_EVENTS_ON_HIDE, this.__hide)
            .on(JODIT_EVENTS_ON_HIDE, this.__hide);
    }
    __removeListenersOnLeave() {
        if (!this.__listenClose) {
            return;
        }
        this.__listenClose = false;
        const view = this.j;
        view.e
            .off(view.ow, WINDOW_EVENTS_ON_HIDE, this.__hide)
            .off(JODIT_EVENTS_ON_HIDE, this.__hide);
    }
    __onMouseLeave(e) {
        if (this.__currentTarget === e.target) {
            this.__hideDelay();
            this.__currentTarget = null;
        }
    }
    __onMouseEnter(e) {
        if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isHTMLElement(e.target)) {
            return;
        }
        const tooltip = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(e.target, 'aria-label');
        if (!tooltip) {
            return;
        }
        const disabled = Boolean((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(e.target, 'disabled'));
        if (disabled) {
            return;
        }
        const isOwn = e.target.className.includes('jodit');
        if (!isOwn) {
            return;
        }
        this.__currentTarget = e.target;
        const target = e.target;
        this.__open(() => {
            const pos = (0,jodit_core_helpers_size_position__WEBPACK_IMPORTED_MODULE_6__/* .position */ .G)(target);
            return {
                x: pos.left + pos.width / 2,
                y: pos.top + pos.height
            };
        }, tooltip);
    }
    __open(getPoint, content) {
        this.__addListenersOnEnter();
        this.__isOpened = true;
        this.j.async.clearTimeout(this.__hideTimeout);
        this.j.async.clearTimeout(this.__delayShowTimeout);
        const to = this.j.o.showTooltipDelay || this.j.defaultTimeout;
        if (!to) {
            this.__show(getPoint, content);
            return;
        }
        this.__delayShowTimeout = this.j.async.setTimeout(() => this.__show(getPoint, content), to);
    }
    __show(getPoint, content) {
        this.setMod('visible', true);
        this.getElm('content').innerHTML = content;
        const point = getPoint();
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.css)(this.container, {
            left: point.x,
            top: point.y
        });
    }
    __hide() {
        this.j.async.clearTimeout(this.__delayShowTimeout);
        this.j.async.clearTimeout(this.__hideTimeout);
        this.__removeListenersOnLeave();
        if (this.__isOpened) {
            this.__isOpened = false;
            this.setMod('visible', false);
            this.getElm('content').innerHTML = '';
            (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.css)(this.container, {
                left: -5000
            });
        }
    }
    __hideDelay() {
        this.j.async.clearTimeout(this.__delayShowTimeout);
        this.j.async.clearTimeout(this.__hideTimeout);
        if (!this.__isOpened) {
            return;
        }
        this.__hideTimeout = this.async.setTimeout(this.__hide, this.j.defaultTimeout);
    }
    destruct() {
        this.__attachedContainers.forEach(container => {
            this.j.e
                .off(container, 'mouseenter.tooltip', this.__onMouseEnter)
                .off(container, 'mouseleave.tooltip', this.__onMouseLeave);
        });
        this.__hide();
        super.destruct();
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], UITooltip.prototype, "__onMouseLeave", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], UITooltip.prototype, "__onMouseEnter", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], UITooltip.prototype, "__hide", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], UITooltip.prototype, "__hideDelay", null);
UITooltip = UITooltip_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
], UITooltip);



/***/ }),

/***/ 36795:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: function() { return /* binding */ required; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Select is required
 */
const required = function (select) {
    if (!(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_0__/* .trim */ .Bq)(select.value).length) {
        select.error = 'Please fill out this field';
        return false;
    }
    return true;
};


/***/ }),

/***/ 37075:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   n: function() { return /* binding */ throttle; },
/* harmony export */   s: function() { return /* binding */ debounce; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(50156);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




function debounce(timeout, firstCallImmediately = false, method = 'debounce') {
    return (target, propertyKey) => {
        const fn = target[propertyKey];
        if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isFunction */ .Tn)(fn)) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_3__/* .error */ .z3)('Handler must be a Function');
        }
        target.hookStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, (component) => {
            const { async } = component;
            void 0;
            const propTimeout = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isFunction */ .Tn)(timeout)
                ? timeout(component)
                : timeout;
            const realTimout = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isNumber */ .Et)(propTimeout) || (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isPlainObject */ .Qd)(propTimeout)
                ? propTimeout
                : component.defaultTimeout;
            Object.defineProperty(component, propertyKey, {
                configurable: true,
                value: async[method](component[propertyKey].bind(component), realTimout, firstCallImmediately)
            });
        });
        return {
            configurable: true,
            get() {
                return fn.bind(this);
            }
        };
    };
}
/**
 * Wrap function in throttle wrapper
 */
function throttle(timeout, firstCallImmediately = false) {
    return debounce(timeout, firstCallImmediately, 'throttle');
}


/***/ }),

/***/ 37107:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'symbol'
};


/***/ }),

/***/ 37424:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Q: function() { return /* binding */ getStrongControlTypes; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97369);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36115);
/* harmony import */ var _get_control_type__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(57023);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * @private
 */
function getStrongControlTypes(items, controls) {
    const elements = (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_3__/* .isArray */ .c)(items)
        ? items
        : (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_0__.keys)(items, false).map(key => {
            const value = items[key] || {};
            return (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_0__.ConfigProto)({ name: key }, value);
        });
    return elements.map(item => (0,_get_control_type__WEBPACK_IMPORTED_MODULE_2__/* .getControlType */ .U)(item, controls || jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.defaultOptions.controls));
}


/***/ }),

/***/ 37435:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ajax: function() { return /* reexport safe */ jodit_core_request__WEBPACK_IMPORTED_MODULE_10__.d; },
/* harmony export */   Alert: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.Fc; },
/* harmony export */   Async: function() { return /* reexport safe */ jodit_core_async__WEBPACK_IMPORTED_MODULE_5__.j; },
/* harmony export */   Button: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.$n; },
/* harmony export */   CommitStyle: function() { return /* reexport safe */ jodit_core_selection__WEBPACK_IMPORTED_MODULE_25__.xk; },
/* harmony export */   Component: function() { return /* reexport safe */ jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.uA; },
/* harmony export */   Confirm: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.pT; },
/* harmony export */   ContextMenu: function() { return /* reexport safe */ _context_menu_context_menu__WEBPACK_IMPORTED_MODULE_2__.t; },
/* harmony export */   Create: function() { return /* reexport safe */ jodit_core_create__WEBPACK_IMPORTED_MODULE_6__.X; },
/* harmony export */   Dialog: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.lG; },
/* harmony export */   Dom: function() { return /* reexport safe */ jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__.J; },
/* harmony export */   EventEmitter: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.bk; },
/* harmony export */   EventHandlersStore: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.d$; },
/* harmony export */   Eventify: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.h5; },
/* harmony export */   FileBrowser: function() { return /* reexport safe */ _file_browser__WEBPACK_IMPORTED_MODULE_4__.V; },
/* harmony export */   Helpers: function() { return /* reexport module object */ jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__; },
/* harmony export */   History: function() { return /* reexport safe */ _history_history__WEBPACK_IMPORTED_MODULE_14__.B; },
/* harmony export */   Icon: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.In; },
/* harmony export */   ImageEditor: function() { return /* reexport safe */ _image_editor_image_editor__WEBPACK_IMPORTED_MODULE_16__.n; },
/* harmony export */   LazyWalker: function() { return /* reexport safe */ jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__.p; },
/* harmony export */   Plugin: function() { return /* reexport safe */ jodit_core_plugin__WEBPACK_IMPORTED_MODULE_9__.k; },
/* harmony export */   PluginSystem: function() { return /* reexport safe */ jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_24__.$; },
/* harmony export */   Popup: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.zD; },
/* harmony export */   ProgressBar: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.z2; },
/* harmony export */   Prompt: function() { return /* reexport safe */ _dialog___WEBPACK_IMPORTED_MODULE_3__.XG; },
/* harmony export */   Response: function() { return /* reexport safe */ jodit_core_request__WEBPACK_IMPORTED_MODULE_10__.Y; },
/* harmony export */   STATUSES: function() { return /* reexport safe */ jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.f; },
/* harmony export */   Selection: function() { return /* reexport safe */ jodit_core_selection__WEBPACK_IMPORTED_MODULE_25__.LN; },
/* harmony export */   Snapshot: function() { return /* reexport safe */ _history_snapshot__WEBPACK_IMPORTED_MODULE_15__.F; },
/* harmony export */   StatusBar: function() { return /* reexport safe */ _status_bar_status_bar__WEBPACK_IMPORTED_MODULE_18__.e; },
/* harmony export */   Table: function() { return /* reexport safe */ _table_table__WEBPACK_IMPORTED_MODULE_19__.X; },
/* harmony export */   ToolbarButton: function() { return /* reexport safe */ _toolbar_button__WEBPACK_IMPORTED_MODULE_20__.IB; },
/* harmony export */   ToolbarCollection: function() { return /* reexport safe */ _toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_21__.Q; },
/* harmony export */   ToolbarContent: function() { return /* reexport safe */ _toolbar_button__WEBPACK_IMPORTED_MODULE_20__.P1; },
/* harmony export */   ToolbarEditorCollection: function() { return /* reexport safe */ _toolbar_collection_editor_collection__WEBPACK_IMPORTED_MODULE_22__.b; },
/* harmony export */   ToolbarSelect: function() { return /* reexport safe */ _toolbar_button__WEBPACK_IMPORTED_MODULE_20__.q4; },
/* harmony export */   UIBlock: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.Yh; },
/* harmony export */   UIButton: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.lD; },
/* harmony export */   UIButtonGroup: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.ss; },
/* harmony export */   UIButtonState: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.ue; },
/* harmony export */   UICheckbox: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.cY; },
/* harmony export */   UIElement: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.D$; },
/* harmony export */   UIFileInput: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.nE; },
/* harmony export */   UIForm: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.XV; },
/* harmony export */   UIGroup: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.Ue; },
/* harmony export */   UIInput: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.tS; },
/* harmony export */   UIList: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.z4; },
/* harmony export */   UIMessages: function() { return /* reexport safe */ _messages_messages__WEBPACK_IMPORTED_MODULE_17__.N; },
/* harmony export */   UISelect: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.$6; },
/* harmony export */   UISeparator: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.CP; },
/* harmony export */   UISpacer: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.bk; },
/* harmony export */   UITextArea: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.F0; },
/* harmony export */   UITooltip: function() { return /* reexport safe */ jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__.SB; },
/* harmony export */   Uploader: function() { return /* reexport safe */ _uploader_uploader__WEBPACK_IMPORTED_MODULE_23__.d; },
/* harmony export */   View: function() { return /* reexport safe */ jodit_core_view_view__WEBPACK_IMPORTED_MODULE_12__.S; },
/* harmony export */   ViewComponent: function() { return /* reexport safe */ jodit_core_component__WEBPACK_IMPORTED_MODULE_0__.vG; },
/* harmony export */   ViewWithToolbar: function() { return /* reexport safe */ jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_13__.T; },
/* harmony export */   defaultNameSpace: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.Xr; },
/* harmony export */   observable: function() { return /* reexport safe */ jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__.sH; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var _context_menu_context_menu__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34248);
/* harmony import */ var _dialog___WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34256);
/* harmony import */ var _file_browser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(19627);
/* harmony import */ var jodit_core_async__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(64890);
/* harmony import */ var jodit_core_create__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(40594);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_event_emitter__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(50025);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(71005);
/* harmony import */ var jodit_core_request__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(53883);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(53048);
/* harmony import */ var jodit_core_view_view__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(77782);
/* harmony import */ var jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(14961);
/* harmony import */ var _history_history__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(69996);
/* harmony import */ var _history_snapshot__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(58770);
/* harmony import */ var _image_editor_image_editor__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(53804);
/* harmony import */ var _messages_messages__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(91902);
/* harmony import */ var _status_bar_status_bar__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(62870);
/* harmony import */ var _table_table__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(11648);
/* harmony import */ var _toolbar_button__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(5832);
/* harmony import */ var _toolbar_collection_collection__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(97394);
/* harmony import */ var _toolbar_collection_editor_collection__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(90428);
/* harmony import */ var _uploader_uploader__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(26538);
/* harmony import */ var jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(77402);
/* harmony import */ var jodit_core_selection__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(87332);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:modules/README.md]]
 * @packageDocumentation
 * @module modules
 */






























/***/ }),

/***/ 37474:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ Component; }
/* harmony export */ });
/* harmony import */ var jodit_core_async__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64890);
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




const StatusListHandlers = new Map();
/**
 * The base class of all Jodit UI components. Provides work with a life cycle.
 */
class Component {
    get componentName() {
        if (!this.__componentName) {
            this.__componentName =
                'jodit-' +
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.kebabCase)(((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(this.className) ? this.className() : '') ||
                        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.getClassName)(this));
        }
        return this.__componentName;
    }
    getFullElName(elementName, mod, modValue) {
        const result = [this.componentName];
        if (elementName) {
            elementName = elementName.replace(/[^a-z0-9-]/gi, '-');
            result.push(`__${elementName}`);
        }
        if (mod) {
            result.push('_', mod);
            result.push('_', (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isVoid)(modValue) ? 'true' : modValue.toString());
        }
        return result.join('');
    }
    /**
     * The document in which jodit was created
     */
    get ownerDocument() {
        return this.ow.document;
    }
    /**
     * Shortcut for `this.ownerDocument`
     */
    get od() {
        return this.ownerDocument;
    }
    get ow() {
        return this.ownerWindow;
    }
    /**
     * Safe get any field
     * @example
     * ```js
     * private a = {
     * 	b: {
     * 		c: {
     * 			e: {
     * 				g: {
     * 					color: 'red'
     * 				}
     * 			}
     * 		}
     * 	}
     * }
     *
     * this.get('a.b.c.e.g.color'); // Safe access to color
     * // instead using optionsl chaining
     * this?.a?.b?.c?.e?.g?.color
     * ```
     *
     * @param chain - the path to be traversed in the obj object
     * @param obj - the object in which the value is searched
     */
    get(chain, obj) {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.get)(chain, obj || this);
    }
    /**
     * Component is ready for work
     */
    get isReady() {
        return this.componentStatus === jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.ready;
    }
    /**
     * Component was destructed
     */
    get isDestructed() {
        return this.componentStatus === jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.destructed;
    }
    /**
     * The component is currently undergoing destructuring or has already been destroyed.
     * Those. you should not the app froze new events on him now or do anything else with him.
     */
    get isInDestruct() {
        return (jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.beforeDestruct === this.componentStatus ||
            jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.destructed === this.componentStatus);
    }
    /**
     * Bind destructor to some View
     */
    bindDestruct(component) {
        component.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.beforeDestruct, () => !this.isInDestruct && this.destruct());
        return this;
    }
    constructor() {
        this.async = new jodit_core_async__WEBPACK_IMPORTED_MODULE_0__/* .Async */ .j();
        /**
         * The window in which jodit was created
         */
        this.ownerWindow = window;
        this.__componentStatus = jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.beforeInit;
        this.uid = 'jodit-uid-' + (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .uniqueUid */ .w9)();
    }
    /**
     * Destruct component method
     */
    destruct() {
        this.setStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f.destructed);
        if (this.async) {
            this.async.destruct();
            // @ts-ignore
            this.async = undefined;
        }
        if (StatusListHandlers.get(this)) {
            StatusListHandlers.delete(this);
        }
        // @ts-ignore
        this.ownerWindow = undefined;
    }
    /**
     * Current component status
     */
    get componentStatus() {
        return this.__componentStatus;
    }
    /**
     * Setter for current component status
     */
    set componentStatus(componentStatus) {
        this.setStatus(componentStatus);
    }
    /**
     * Set component status
     * @param componentStatus - component status
     * @see ComponentStatus
     */
    setStatus(componentStatus) {
        return this.setStatusComponent(componentStatus, this);
    }
    /**
     * Set status recursively on all parents
     */
    setStatusComponent(componentStatus, component) {
        if (componentStatus === this.__componentStatus) {
            return;
        }
        if (component === this) {
            this.__componentStatus = componentStatus;
        }
        const proto = Object.getPrototypeOf(this);
        if (proto && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(proto.setStatusComponent)) {
            proto.setStatusComponent(componentStatus, component);
        }
        const statuses = StatusListHandlers.get(this), list = statuses === null || statuses === void 0 ? void 0 : statuses[componentStatus];
        if (list && list.length) {
            list.forEach(cb => cb(component));
        }
    }
    /**
     * Adds a handler for changing the component's status
     *
     * @param status - the status at which the callback is triggered
     * @param callback - a function that will be called when the status is `status`
     */
    hookStatus(status, callback) {
        let list = StatusListHandlers.get(this);
        if (!list) {
            list = {};
            StatusListHandlers.set(this, list);
        }
        if (!list[status]) {
            list[status] = [];
        }
        list[status].push(callback);
    }
    static isInstanceOf(c, constructorFunc) {
        return c instanceof constructorFunc;
    }
}
Component.STATUSES = jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_1__/* .STATUSES */ .f;


/***/ }),

/***/ 37649:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   g: function() { return /* binding */ transactions; },
/* harmony export */   x: function() { return /* binding */ states; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(87332);
/* harmony import */ var jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97621);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





const states = {
    START: 'START',
    ELEMENT: 'ELEMENT',
    UNWRAP: 'UNWRAP',
    UNWRAP_CHILDREN: 'UNWRAP_CHILDREN',
    CHANGE: 'CHANGE',
    REPLACE_DEFAULT: 'REPLACE_DEFAULT',
    LIST: 'LIST',
    TOGGLE_LIST: 'TOGGLE_LIST',
    WRAP: 'WRAP',
    EXTRACT: 'EXTRACT',
    END: 'END'
};
const transactions = {
    [states.START]: {
        exec(value) {
            const { element, jodit, style, mode, collapsed } = value;
            if ((0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .isInsideInvisibleElement */ .iu)(element, jodit.editor) ||
                (!collapsed && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isEmptyContent(element))) {
                return Object.assign(Object.assign({}, value), { next: states.END });
            }
            const elm = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .getSuitParent */ .AS)(style, element, jodit.editor) ||
                (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .getSuitChild */ .G6)(style, element);
            if (elm) {
                return Object.assign(Object.assign({}, value), { next: states.ELEMENT, element: elm });
            }
            const suit = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .suitableClosest */ .$s)(style, element, jodit.editor);
            if (style.elementIsList && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isList(suit)) {
                return Object.assign(Object.assign({}, value), { next: states.LIST });
            }
            if (suit) {
                return Object.assign(Object.assign({}, value), { next: states.EXTRACT });
            }
            return Object.assign(Object.assign({}, value), { next: mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNWRAP */ .OJ ? states.UNWRAP_CHILDREN : states.END });
        }
    },
    [states.LIST]: {
        exec(value) {
            const { element, jodit, mode } = value;
            if (mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .INITIAL */ .DI && mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNWRAP */ .OJ && mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .REPLACE */ .dj) {
                return Object.assign(Object.assign({}, value), { next: states.END });
            }
            const li = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(element, 'li', jodit.editor);
            if (!li) {
                return Object.assign(Object.assign({}, value), { next: states.END });
            }
            const list = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(element, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS, jodit.editor);
            if (list) {
                return Object.assign(Object.assign({}, value), { element: li, next: states.TOGGLE_LIST });
            }
            return Object.assign(Object.assign({}, value), { next: states.END });
        }
    },
    [states.TOGGLE_LIST]: {
        exec(value) {
            return Object.assign(Object.assign({}, value), { mode: (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .toggleOrderedList */ .ks)(value.style, value.element, value.jodit, value.mode), next: states.END });
        }
    },
    [states.EXTRACT]: {
        exec(value) {
            const { element, jodit, style } = value;
            const suit = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .suitableClosest */ .$s)(style, element, jodit.editor);
            void 0;
            if (!style.elementIsBlock) {
                (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .extractSelectedPart */ .yP)(suit, element, jodit);
            }
            return Object.assign(Object.assign({}, value), { element: suit, next: states.ELEMENT });
        }
    },
    [states.UNWRAP_CHILDREN]: {
        exec(value) {
            const { element, style } = value;
            if (!(0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .unwrapChildren */ .tm)(style, element)) {
                return Object.assign(Object.assign({}, value), { next: states.WRAP });
            }
            return Object.assign(Object.assign({}, value), { mode: jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNWRAP */ .OJ, next: states.END });
        }
    },
    [states.WRAP]: {
        exec(value) {
            const { element, jodit, style } = value;
            const wrapper = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .wrap */ .LV)(style, element, jodit);
            return Object.assign(Object.assign({}, value), { next: style.elementIsList ? states.END : states.CHANGE, mode: jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .WRAP */ .Zk, element: wrapper });
        }
    },
    [states.ELEMENT]: {
        exec(value) {
            const { style, element, jodit } = value;
            if ((0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .toggleAttributes */ .Yx)(style, element, jodit, jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .INITIAL */ .DI, true) !==
                jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .INITIAL */ .DI) {
                return Object.assign(Object.assign({}, value), { next: states.CHANGE });
            }
            // Apply same color for anchor https://github.com/xdan/jodit/issues/936
            if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(element, style.element)) {
                return Object.assign(Object.assign({}, value), { next: states.END });
            }
            return Object.assign(Object.assign({}, value), { next: states.UNWRAP });
        }
    },
    [states.CHANGE]: {
        exec(value) {
            const { style, element, jodit, mode } = value;
            const newMode = (0,jodit_core_selection_style_api__WEBPACK_IMPORTED_MODULE_4__/* .toggleAttributes */ .Yx)(style, element, jodit, value.mode);
            if (mode !== jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .WRAP */ .Zk &&
                newMode === jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNSET */ .Ag &&
                !element.attributes.length &&
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(element, style.element)) {
                return Object.assign(Object.assign({}, value), { next: states.UNWRAP });
            }
            return Object.assign(Object.assign({}, value), { mode: newMode, next: states.END });
        }
    },
    [states.UNWRAP]: {
        exec(value) {
            if (value.element.attributes.length &&
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(value.element, value.style.element)) {
                return Object.assign(Object.assign({}, value), { next: states.REPLACE_DEFAULT });
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.unwrap(value.element);
            return Object.assign(Object.assign({}, value), { mode: jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .UNWRAP */ .OJ, next: states.END });
        }
    },
    [states.REPLACE_DEFAULT]: {
        exec(value) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.replace(value.element, value.style.defaultTag, value.jodit.createInside, true);
            return Object.assign(Object.assign({}, value), { mode: jodit_core_selection__WEBPACK_IMPORTED_MODULE_3__/* .REPLACE */ .dj, next: states.END });
        }
    },
    [states.END]: {
        exec(value) {
            return value;
        }
    }
};


/***/ }),

/***/ 37923:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ isArray; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check if element is array
 */
function isArray(elm) {
    return Array.isArray(elm);
}


/***/ }),

/***/ 38046:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _: function() { return /* binding */ isNormalNode; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Is normal usual element
 * @private
 */
function isNormalNode(elm) {
    return Boolean(elm &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isEmptyTextNode(elm) &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTemporary(elm) &&
        !(0,jodit_core_helpers_checker_is_marker__WEBPACK_IMPORTED_MODULE_1__/* .isMarker */ .r)(elm));
}


/***/ }),

/***/ 38101:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export cleanHtml */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_dom_lazy_walker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8453);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_html_safe_html__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26328);
/* harmony import */ var jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29866);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(74646);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(15396);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









/**
 * Clean HTML after removeFormat and insertHorizontalRule command
 */
class cleanHtml extends jodit_core_plugin_plugin__WEBPACK_IMPORTED_MODULE_5__/* .Plugin */ .k {
    constructor() {
        super(...arguments);
        /** @override */
        this.buttons = [
            {
                name: 'eraser',
                group: 'font-style'
            }
        ];
        this.currentSelectionNode = null;
        this.walker = new jodit_core_dom_lazy_walker__WEBPACK_IMPORTED_MODULE_2__/* .LazyWalker */ .p(this.j.async, {
            timeout: this.j.o.cleanHTML.timeout
        });
    }
    /** @override */
    afterInit(jodit) { }
    get isEditMode() {
        return !(this.j.isInDestruct ||
            !this.j.isEditorMode() ||
            this.j.getReadOnly());
    }
    /**
     * Clean HTML code on every change
     */
    onChangeCleanHTML() {
        if (!this.isEditMode) {
            return;
        }
        const editor = this.j;
        this.walker.setWork(editor.editor);
        this.currentSelectionNode = editor.s.current();
    }
    startWalker() {
        const { jodit } = this;
        const allow = (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .getHash */ .Zd)(this.j.o.cleanHTML.allowTags);
        const deny = (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .getHash */ .Zd)(this.j.o.cleanHTML.denyTags);
        this.walker
            .on('visit', (node) => (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .visitNodeWalker */ .eZ)(jodit, node, allow, deny, this.currentSelectionNode))
            .on('end', (affected) => {
            this.j.e.fire(affected
                ? 'internalChange finishedCleanHTMLWorker'
                : 'finishedCleanHTMLWorker');
        });
    }
    beforeCommand(command) {
        if (command.toLowerCase() === 'removeformat') {
            if (this.j.s.isCollapsed()) {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .removeFormatForCollapsedSelection */ .w5)(this.j);
            }
            else {
                (0,_helpers__WEBPACK_IMPORTED_MODULE_7__/* .removeFormatForSelection */ .hk)(this.j);
            }
            return false;
        }
    }
    /**
     * Event handler when manually assigning a value to the HTML editor.
     */
    onBeforeSetNativeEditorValue(data) {
        const [sandBox, iframe] = this.j.o.cleanHTML.useIframeSandbox
            ? this.j.createInside.sandbox()
            : [this.j.createInside.div()];
        sandBox.innerHTML = data.value;
        this.onSafeHTML(sandBox);
        data.value = sandBox.innerHTML;
        (0,jodit_core_helpers_html_safe_html__WEBPACK_IMPORTED_MODULE_4__/* .safeHTML */ .t)(sandBox, { safeJavaScriptLink: true, removeOnError: true });
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(iframe);
        return false;
    }
    onSafeHTML(sandBox) {
        (0,jodit_core_helpers_html_safe_html__WEBPACK_IMPORTED_MODULE_4__/* .safeHTML */ .t)(sandBox, this.j.o.cleanHTML);
    }
    /** @override */
    beforeDestruct() {
        this.walker.destruct();
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)([':change', ':afterSetMode', ':afterInit', ':mousedown', ':keydown'])
], cleanHtml.prototype, "onChangeCleanHTML", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.hook)('ready')
], cleanHtml.prototype, "startWalker", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(':beforeCommand')
], cleanHtml.prototype, "beforeCommand", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(':beforeSetNativeEditorValue')
], cleanHtml.prototype, "onBeforeSetNativeEditorValue", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(':safeHTML')
], cleanHtml.prototype, "onSafeHTML", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('cleanHtml', cleanHtml);


/***/ }),

/***/ 38271:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Y: function() { return /* binding */ toggleAttributes; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(59678);
/* harmony import */ var jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(95350);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(449);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(38322);
/* harmony import */ var jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(72197);
/* harmony import */ var jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(12043);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */











const tak = 'toggleAttributes';
/**
 * Toggles attributes
 * @private
 */
function toggleAttributes(commitStyle, elm, jodit, mode, dry = false) {
    if (!dry && commitStyle.isApplied(elm, tak)) {
        return mode;
    }
    !dry && commitStyle.setApplied(elm, tak);
    const { attributes } = commitStyle.options;
    if (attributes && (0,jodit_core_helpers_size_object_size__WEBPACK_IMPORTED_MODULE_4__/* .size */ .E)(attributes) > 0) {
        Object.keys(attributes).forEach((key) => {
            const value = attributes[key];
            switch (key) {
                case 'style': {
                    mode = toggleStyle(commitStyle, jodit, value, elm, dry, mode);
                    break;
                }
                case 'className':
                case 'class':
                    mode = toggleClass(jodit, value, elm, mode, dry);
                    break;
                default:
                    mode = toggleAttribute(jodit, value, elm, key, dry, mode);
            }
        });
    }
    return mode;
}
function toggleStyle(commitStyle, jodit, style, elm, dry, mode) {
    void 0;
    Object.keys(style).forEach((rule) => {
        const inlineValue = elm.style.getPropertyValue((0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_7__/* .kebabCase */ .k)(rule));
        const newValue = style[rule];
        if (inlineValue === '' && newValue == null) {
            return;
        }
        if (getNativeCSSValue(jodit, elm, rule) ===
            (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_8__/* .normalizeCssValue */ .iy)(rule, newValue)) {
            if (!inlineValue) {
                return;
            }
            !dry && (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_9__/* .css */ .A)(elm, rule, null);
            mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .UNSET */ .Ag;
            mode = removeExtraStyleAttribute(commitStyle, elm, mode);
            return;
        }
        mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .CHANGE */ .PL;
        if (!dry) {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_9__/* .css */ .A)(elm, rule, newValue);
            mode = removeExtraStyleAttribute(commitStyle, elm, mode);
        }
    });
    return mode;
}
function toggleClass(jodit, value, elm, mode, dry) {
    void 0;
    const hook = jodit.e.fire.bind(jodit.e, `${jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* ._PREFIX */ .ar}AfterToggleAttribute`);
    if (elm.classList.contains(value.toString())) {
        mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .UNSET */ .Ag;
        if (!dry) {
            elm.classList.remove(value);
            if (elm.classList.length === 0) {
                (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.attr)(elm, 'class', null);
                hook(mode, elm, 'class', null);
            }
        }
    }
    else {
        mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .CHANGE */ .PL;
        if (!dry) {
            elm.classList.add(value);
            hook(mode, elm, 'class', value);
        }
    }
    return mode;
}
function toggleAttribute(jodit, value, elm, key, dry, mode) {
    void 0;
    const hook = jodit.e.fire.bind(jodit.e, `${jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* ._PREFIX */ .ar}AfterToggleAttribute`);
    if ((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.attr)(elm, key) === value) {
        !dry && (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.attr)(elm, key, null);
        mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .UNSET */ .Ag;
        !dry && hook(mode, elm, key, value);
        return mode;
    }
    mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .CHANGE */ .PL;
    if (!dry) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.attr)(elm, key, value);
        hook(mode, elm, key, value);
    }
    return mode;
}
/**
 * If the element has an empty style attribute, it removes the attribute,
 * and if it is default, it removes the element itself
 */
function removeExtraStyleAttribute(commitStyle, elm, mode) {
    if (!(0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.attr)(elm, 'style')) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_5__.attr)(elm, 'style', null);
        if (elm.tagName.toLowerCase() === commitStyle.defaultTag) {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.unwrap(elm);
            mode = jodit_core_selection_style_constants__WEBPACK_IMPORTED_MODULE_10__/* .UNWRAP */ .OJ;
        }
    }
    return mode;
}
/**
 * Creates an iframe into which elements will be inserted to test their default styles in the browser
 */
function getShadowRoot(jodit) {
    var _a;
    if ((0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_6__/* .dataBind */ .m)(jodit, 'shadowRoot') !== undefined) {
        return (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_6__/* .dataBind */ .m)(jodit, 'shadowRoot');
    }
    const container = (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .getContainer */ .My)(jodit);
    const iframe = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('iframe');
    (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_9__/* .css */ .A)(iframe, {
        width: 0,
        height: 0,
        position: 'absolute',
        border: 0
    });
    iframe.src = 'about:blank';
    container.appendChild(iframe);
    const doc = (_a = iframe.contentWindow) === null || _a === void 0 ? void 0 : _a.document;
    const shadowRoot = !doc ? jodit.od.body : doc.body;
    (0,jodit_core_helpers_utils_data_bind__WEBPACK_IMPORTED_MODULE_6__/* .dataBind */ .m)(jodit, 'shadowRoot', shadowRoot);
    return shadowRoot;
}
/**
 * `strong -> fontWeight 700`
 */
function getNativeCSSValue(jodit, elm, key) {
    const newElm = jodit.create.element(elm.tagName.toLowerCase());
    newElm.style.cssText = elm.style.cssText;
    const root = getShadowRoot(jodit);
    root.appendChild(newElm);
    const result = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_9__/* .css */ .A)(newElm, key);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(newElm);
    return result;
}


/***/ }),

/***/ 38309:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56298);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31686);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


function video(editor) {
    editor.registerButton({
        name: 'video',
        group: 'media'
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_0__/* .pluginSystem */ .fg.add('video', video);


/***/ }),

/***/ 38322:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: function() { return /* binding */ css; },
/* harmony export */   a: function() { return /* binding */ clearCenterAlign; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9810);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25376);
/* harmony import */ var jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59678);
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83260);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(449);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





/**
 * Get the value of a computed style property for the first element in the set of matched elements or set one or
 * more CSS properties for every matched element
 *
 * @param element - HTML element
 * @param key - An object of property-value pairs to set. A CSS property name.
 * @param value - A value to set for the property.
 * @param onlyStyleMode - Get value from style attribute, without calculating
 */
function css(element, key, value, onlyStyleMode = false) {
    if ((0,jodit_core_helpers_checker_is_boolean__WEBPACK_IMPORTED_MODULE_0__/* .isBoolean */ .L)(value)) {
        onlyStyleMode = value;
        value = undefined;
    }
    if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_1__/* .isPlainObject */ .Q)(key) || value !== undefined) {
        const setValue = (elm, _key, _value) => {
            _value = (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__/* .normalizeCssNumericValue */ .n8)(_key, _value);
            if (_value !== undefined &&
                (_value == null ||
                    css(elm, _key, true) !== (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__/* .normalizeCssValue */ .iy)(_key, _value))) {
                elm.style[_key] = _value;
            }
        };
        if ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_1__/* .isPlainObject */ .Q)(key)) {
            const keys = Object.keys(key);
            for (let j = 0; j < keys.length; j += 1) {
                setValue(element, (0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_3__/* .camelCase */ .x)(keys[j]), key[keys[j]]);
            }
        }
        else {
            setValue(element, (0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_3__/* .camelCase */ .x)(key), value);
        }
        return '';
    }
    const key2 = (0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_4__/* .kebabCase */ .k)(key), doc = element.ownerDocument || document, win = doc ? doc.defaultView || doc.parentWindow : false;
    const currentValue = element.style[key];
    let result = '';
    if (currentValue !== undefined && currentValue !== '') {
        result = currentValue;
    }
    else if (win && !onlyStyleMode) {
        result = win.getComputedStyle(element).getPropertyValue(key2);
    }
    if (jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__/* .NUMBER_FIELDS_REG */ .b$.test(key) &&
        /^[-+]?[0-9.]+px$/.test(result.toString())) {
        result = parseInt(result.toString(), 10);
    }
    return (0,jodit_core_helpers_normalize_normalize_css_value__WEBPACK_IMPORTED_MODULE_2__/* .normalizeCssValue */ .iy)(key, result);
}
/**
 * Clear center align
 */
const clearCenterAlign = (image) => {
    if (css(image, 'display') === 'block') {
        css(image, 'display', '');
    }
    const { style } = image;
    if (style.marginLeft === 'auto' && style.marginRight === 'auto') {
        style.marginLeft = '';
        style.marginRight = '';
    }
};


/***/ }),

/***/ 38373:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export copyFormat */
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(38322);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36115);
/* harmony import */ var _copy_format_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3843);
/* harmony import */ var _copy_format_svg__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_copy_format_svg__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _langs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(94628);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







const pluginKey = 'copy-format';
/**
 * Plug-in copy and paste formatting from one element to another
 */
const copyStyles = [
    'fontWeight',
    'fontStyle',
    'fontSize',
    'color',
    'margin',
    'padding',
    'borderWidth',
    'borderStyle',
    'borderColor',
    'borderRadius',
    'backgroundColor',
    'textDecorationLine',
    'fontFamily'
];
const getStyle = (editor, key, box, defaultStyles) => {
    let result = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_6__/* .css */ .A)(box, key);
    if (result === defaultStyles[key]) {
        if (box.parentNode &&
            box !== editor.editor &&
            box.parentNode !== editor.editor) {
            result = getStyle(editor, key, box.parentNode, defaultStyles);
        }
        else {
            result = undefined;
        }
    }
    return result;
};
const getStyles = (editor, box, defaultStyles) => {
    const result = {};
    if (box) {
        copyStyles.forEach((key) => {
            result[key] = getStyle(editor, key, box, defaultStyles);
            if (key.match(/border(Style|Color)/) && !result.borderWidth) {
                result[key] = undefined;
            }
        });
    }
    return result;
};
jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.prototype.controls.copyformat = {
    exec: (editor, current, { button }) => {
        if (!current) {
            return;
        }
        if (editor.buffer.exists(pluginKey)) {
            editor.buffer.delete(pluginKey);
            editor.e.off(editor.editor, 'mouseup.' + pluginKey);
        }
        else {
            const defaultStyles = {}, box = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.up(current, (elm) => elm && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isText(elm), editor.editor) || editor.editor;
            const ideal = editor.createInside.span();
            editor.editor.appendChild(ideal);
            copyStyles.forEach((key) => {
                defaultStyles[key] = (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_6__/* .css */ .A)(ideal, key);
            });
            if (ideal !== editor.editor) {
                jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(ideal);
            }
            const format = getStyles(editor, box, defaultStyles);
            const onMouseUp = () => {
                editor.buffer.delete(pluginKey);
                const currentNode = editor.s.current();
                if (currentNode) {
                    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(currentNode, 'img')) {
                        (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_6__/* .css */ .A)(currentNode, format);
                    }
                    else {
                        editor.s.commitStyle({
                            attributes: {
                                style: format
                            }
                        });
                    }
                }
                editor.e.off(editor.editor, 'mouseup.' + pluginKey);
            };
            editor.e.on(editor.editor, 'mouseup.' + pluginKey, onMouseUp);
            editor.buffer.set(pluginKey, true);
        }
        button.update();
    },
    isActive: (editor) => editor.buffer.exists(pluginKey),
    tooltip: 'Paint format'
};
function copyFormat(editor) {
    editor.registerButton({
        name: 'copyformat',
        group: 'clipboard'
    });
    (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .extendLang */ .JW)(_langs__WEBPACK_IMPORTED_MODULE_5__);
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('copyformat', copyFormat);
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .I.set('copyformat', (_copy_format_svg__WEBPACK_IMPORTED_MODULE_4___default()));


/***/ }),

/***/ 38681:
/***/ (function(module) {

module.exports = "<svg viewBox=\"0 0 18.151 18.151\" xmlns=\"http://www.w3.org/2000/svg\"> <g> <path stroke-width=\"0\" d=\"M6.237,16.546H3.649V1.604h5.916v5.728c0.474-0.122,0.968-0.194,1.479-0.194 c0.042,0,0.083,0.006,0.125,0.006V0H2.044v18.15h5.934C7.295,17.736,6.704,17.19,6.237,16.546z\"/> <path stroke-width=\"0\" d=\"M11.169,8.275c-2.723,0-4.938,2.215-4.938,4.938s2.215,4.938,4.938,4.938s4.938-2.215,4.938-4.938 S13.892,8.275,11.169,8.275z M11.169,16.81c-1.983,0-3.598-1.612-3.598-3.598c0-1.983,1.614-3.597,3.598-3.597 s3.597,1.613,3.597,3.597C14.766,15.198,13.153,16.81,11.169,16.81z\"/> <polygon stroke-width=\"0\" points=\"11.792,11.073 10.502,11.073 10.502,12.578 9.03,12.578 9.03,13.868 10.502,13.868 10.502,15.352 11.792,15.352 11.792,13.868 13.309,13.868 13.309,12.578 11.792,12.578 \"/> </g> </svg>"

/***/ }),

/***/ 39147:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export resizeCells */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65147);
/* harmony import */ var jodit_modules__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(37435);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(36001);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









const key = 'table_processor_observer-resize';
/**
 * Process tables in editor
 */
class resizeCells extends jodit_modules__WEBPACK_IMPORTED_MODULE_5__.Plugin {
    constructor() {
        super(...arguments);
        this.selectMode = false;
        this.resizeDelta = 0;
        this.createResizeHandle = () => {
            if (!this.resizeHandler) {
                this.resizeHandler = this.j.c.div('jodit-table-resizer');
                this.j.e
                    .on(this.resizeHandler, 'mousedown.table touchstart.table', this.onHandleMouseDown)
                    .on(this.resizeHandler, 'mouseenter.table', () => {
                    this.j.async.clearTimeout(this.hideTimeout);
                });
            }
        };
        this.hideTimeout = 0;
        this.drag = false;
        this.minX = 0;
        this.maxX = 0;
        this.startX = 0;
    }
    /**
     * Shortcut for Table module
     */
    get module() {
        return this.j.getInstance('Table', this.j.o);
    }
    /**
     * Now editor has rtl direction
     */
    get isRTL() {
        return this.j.o.direction === 'rtl';
    }
    showResizeHandle() {
        this.j.async.clearTimeout(this.hideTimeout);
        this.j.workplace.appendChild(this.resizeHandler);
    }
    hideResizeHandle() {
        this.hideTimeout = this.j.async.setTimeout(() => {
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.resizeHandler);
        }, {
            timeout: this.j.defaultTimeout,
            label: 'hideResizer'
        });
    }
    /**
     * Click on resize handle
     */
    onHandleMouseDown(event) {
        if (this.j.isLocked) {
            return;
        }
        this.drag = true;
        this.j.e
            .on(this.j.ow, 'mouseup.resize-cells touchend.resize-cells', this.onMouseUp)
            .on(this.j.ew, 'mousemove.table touchmove.table', this.onMouseMove);
        this.startX = event.clientX;
        this.j.lock(key);
        this.resizeHandler.classList.add('jodit-table-resizer_moved');
        let box, tableBox = this.workTable.getBoundingClientRect();
        this.minX = 0;
        this.maxX = 1000000;
        if (this.wholeTable != null) {
            tableBox = this.workTable.parentNode.getBoundingClientRect();
            this.minX = tableBox.left;
            this.maxX = this.minX + tableBox.width;
        }
        else {
            // find maximum columns
            const coordinate = this.module.formalCoordinate(this.workTable, this.workCell, true);
            this.module.formalMatrix(this.workTable, (td, i, j) => {
                if (coordinate[1] === j) {
                    box = td.getBoundingClientRect();
                    this.minX = Math.max(box.left + jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NEARBY / 2, this.minX);
                }
                if (coordinate[1] + (this.isRTL ? -1 : 1) === j) {
                    box = td.getBoundingClientRect();
                    this.maxX = Math.min(box.left + box.width - jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NEARBY / 2, this.maxX);
                }
            });
        }
        return false;
    }
    /**
     * Mouse move after click on resize handle
     */
    onMouseMove(event) {
        if (!this.drag) {
            return;
        }
        this.j.e.fire('closeAllPopups');
        let x = event.clientX;
        const workplacePosition = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)((this.resizeHandler.parentNode ||
            this.j.od.documentElement), this.j, this.j.od, true);
        if (x < this.minX) {
            x = this.minX;
        }
        if (x > this.maxX) {
            x = this.maxX;
        }
        this.resizeDelta =
            x - this.startX + (!this.j.o.iframe ? 0 : workplacePosition.left);
        this.resizeHandler.style.left =
            x - (this.j.o.iframe ? 0 : workplacePosition.left) + 'px';
        const sel = this.j.s.sel;
        sel && sel.removeAllRanges();
    }
    /**
     * Mouse up every where after move and click
     */
    onMouseUp(e) {
        if (this.selectMode || this.drag) {
            this.selectMode = false;
            this.j.unlock();
        }
        if (!this.resizeHandler || !this.drag) {
            return;
        }
        this.drag = false;
        this.j.e.off(this.j.ew, 'mousemove.table touchmove.table', this.onMouseMove);
        this.resizeHandler.classList.remove('jodit-table-resizer_moved');
        if (this.startX !== e.clientX) {
            // resize column
            if (this.wholeTable == null) {
                this.resizeColumns();
            }
            else {
                this.resizeTable();
            }
        }
        this.j.synchronizeValues();
        this.j.s.focus();
    }
    /**
     * Resize only one column
     */
    resizeColumns() {
        const delta = this.resizeDelta;
        const marked = [];
        const tableModule = this.module;
        tableModule.setColumnWidthByDelta(this.workTable, tableModule.formalCoordinate(this.workTable, this.workCell, true)[1], delta, true, marked);
        const nextTD = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.call)(this.isRTL ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.prev : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.next, this.workCell, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isCell, this.workCell.parentNode);
        tableModule.setColumnWidthByDelta(this.workTable, tableModule.formalCoordinate(this.workTable, nextTD)[1], -delta, false, marked);
    }
    /**
     * Resize whole table
     */
    resizeTable() {
        const delta = this.resizeDelta * (this.isRTL ? -1 : 1);
        const width = this.workTable.offsetWidth, parentWidth = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.getContentWidth)(this.workTable.parentNode, this.j.ew);
        // for RTL use mirror logic
        const rightSide = !this.wholeTable;
        const needChangeWidth = this.isRTL ? !rightSide : rightSide;
        // right side
        if (needChangeWidth) {
            this.workTable.style.width =
                ((width + delta) / parentWidth) * 100 + '%';
        }
        else {
            const side = this.isRTL ? 'marginRight' : 'marginLeft';
            const margin = parseInt(this.j.ew.getComputedStyle(this.workTable)[side] || '0', 10);
            this.workTable.style.width =
                ((width - delta) / parentWidth) * 100 + '%';
            this.workTable.style[side] =
                ((margin + delta) / parentWidth) * 100 + '%';
        }
    }
    /**
     * Memoize current cell
     *
     * @param wholeTable - resize whole table by left side,
     * false - resize whole table by right side, null - resize column
     */
    setWorkCell(cell, wholeTable = null) {
        this.wholeTable = wholeTable;
        this.workCell = cell;
        this.workTable = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.up(cell, (elm) => jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(elm, 'table'), this.j.editor);
    }
    /**
     * Calc helper resize handle position
     */
    calcHandlePosition(table, cell, offsetX = 0, delta = 0) {
        const box = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)(cell, this.j, this.j.ed);
        if (offsetX > jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NEARBY && offsetX < box.width - jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NEARBY) {
            this.hideResizeHandle();
            return;
        }
        const workplacePosition = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)(this.j.workplace, this.j, this.j.od, true), parentBox = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.offset)(table, this.j, this.j.ed);
        this.resizeHandler.style.left =
            (offsetX <= jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NEARBY ? box.left : box.left + box.width) -
                workplacePosition.left +
                delta +
                'px';
        Object.assign(this.resizeHandler.style, {
            height: parentBox.height + 'px',
            top: parentBox.top - workplacePosition.top + 'px'
        });
        this.showResizeHandle();
        if (offsetX <= jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NEARBY) {
            const prevTD = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.call)(this.isRTL ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.next : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.prev, cell, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isCell, cell.parentNode);
            this.setWorkCell(prevTD || cell, prevTD ? null : true);
        }
        else {
            const nextTD = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.call)(!this.isRTL ? jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.next : jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.prev, cell, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isCell, cell.parentNode);
            this.setWorkCell(cell, !nextTD ? false : null);
        }
    }
    /** @override */
    afterInit(editor) {
        if (!editor.o.tableAllowCellResize) {
            return;
        }
        editor.e
            .off(this.j.ow, '.resize-cells')
            .off('.resize-cells')
            .on('change.resize-cells afterCommand.resize-cells afterSetMode.resize-cells', () => {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.$$)('table', editor.editor).forEach(this.observe);
        })
            .on(this.j.ow, 'scroll.resize-cells', () => {
            if (!this.drag) {
                return;
            }
            const parent = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.up(this.workCell, (elm) => jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTag(elm, 'table'), editor.editor);
            if (parent) {
                const parentBox = parent.getBoundingClientRect();
                this.resizeHandler.style.top = parentBox.top + 'px';
            }
        })
            .on('beforeSetMode.resize-cells', () => {
            const tableModule = this.module;
            tableModule.getAllSelectedCells().forEach(td => {
                tableModule.removeSelection(td);
                tableModule.normalizeTable(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(td, 'table', editor.editor));
            });
        });
    }
    /**
     * Add to every Table listeners
     */
    observe(table) {
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.dataBind)(table, key)) {
            return;
        }
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.dataBind)(table, key, true);
        this.j.e
            .on(table, 'mouseleave.resize-cells', (e) => {
            if (this.resizeHandler &&
                this.resizeHandler !== e.relatedTarget) {
                this.hideResizeHandle();
            }
        })
            .on(table, 'mousemove.resize-cells touchmove.resize-cells', this.j.async.throttle((event) => {
            if (this.j.isLocked) {
                return;
            }
            const cell = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.up(event.target, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isCell, table);
            if (!cell) {
                return;
            }
            this.calcHandlePosition(table, cell, event.offsetX);
        }, {
            timeout: this.j.defaultTimeout
        }));
        this.createResizeHandle();
    }
    beforeDestruct(jodit) {
        if (jodit.events) {
            jodit.e.off(this.j.ow, '.resize-cells');
            jodit.e.off('.resize-cells');
        }
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], resizeCells.prototype, "onHandleMouseDown", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], resizeCells.prototype, "onMouseMove", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], resizeCells.prototype, "onMouseUp", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], resizeCells.prototype, "observe", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('resizeCells', resizeCells);


/***/ }),

/***/ 39199:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1664 896q0 156-61 298t-164 245-245 164-298 61q-172 0-327-72.5t-264-204.5q-7-10-6.5-22.5t8.5-20.5l137-138q10-9 25-9 16 2 23 12 73 95 179 147t225 52q104 0 198.5-40.5t163.5-109.5 109.5-163.5 40.5-198.5-40.5-198.5-109.5-163.5-163.5-109.5-198.5-40.5q-98 0-188 35.5t-160 101.5l137 138q31 30 14 69-17 40-59 40h-448q-26 0-45-19t-19-45v-448q0-42 40-59 39-17 69 14l130 129q107-101 244.5-156.5t284.5-55.5q156 0 298 61t245 164 164 245 61 298z\"/> </svg>"

/***/ }),

/***/ 39344:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: function() { return /* binding */ normalizeUrl; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/normalize
 */
const normalizeUrl = (...urls) => {
    return urls
        .filter(url => url.length)
        .map(url => url.replace(/\/$/, ''))
        .join('/')
        .replace(/([^:])[\\/]+/g, '$1/');
};


/***/ }),

/***/ 39386:
/***/ (function(module) {

module.exports["default"] = ["Escriba algo...","Acerca de Jodit","Jodit Editor","Guía de usuario Jodit","contiene ayuda detallada para el uso.","Para información sobre la licencia, por favor visite nuestro sitio:","Compre la versión completa","Copyright © XDSoft.net - Chupurnov Valeriy. Todos los derechos reservados.","Anclar","Abrir en nueva pestaña","Abrir editor en pantalla completa","Limpiar formato","Color de relleno o de letra","Rehacer","Deshacer","Negrita","Cursiva","Insertar lista no ordenada","Insertar lista ordenada","Alinear Centrado","Alinear Justificado","Alinear Izquierda","Alinear Derecha","Insertar línea horizontal","Insertar imagen","Insertar archivo","Insertar video de Youtube/vimeo","Insertar vínculo","Tamaño de letra","Familia de letra","Insertar bloque","Normal","Encabezado 1","Encabezado 2","Encabezado 3","Encabezado 4","Cita","Código","Insertar","Insertar tabla","Disminuir sangría","Aumentar sangría","Seleccionar caracter especial","Insertar caracter especial","Copiar formato","Cambiar modo","Márgenes","arriba","derecha","abajo","izquierda","Estilos CSS","Clases CSS","Alinear","Derecha","Centrado","Izquierda","--No Establecido--","Fuente","Título","Texto Alternativo","Vínculo","Abrir vínculo en nueva pestaña","Imagen","Archivo","Avanzado","Propiedades de imagen","Cancelar","Aceptar","Buscar archivo","Error al cargar la lista","Error al cargar las carpetas","¿Está seguro?","Entre nombre de carpeta","Crear carpeta","Entre el nombre","Soltar imagen","Soltar archivo","o click","Texto alternativo","Subir","Buscar","Fondo","Texto","Arriba","Centro","Abajo","Insertar columna antes","Interar columna después","Insertar fila arriba","Insertar fila debajo","Borrar tabla","Borrar fila","Borrar columna","Vaciar celda","Caracteres: %d","Palabras: %d","Tachado","Subrayado","superíndice","subíndice","Cortar selección","Seleccionar todo","Pausa","Buscar","Reemplazar con","Reemplazar","Pegar","Seleccionar contenido para pegar","HTML","negrita","cursiva","Brocha","Vínculo","deshacer","rehacer","Tabla","Imagen","Borrar","Párrafo","Tamaño de letra","Video","Letra","Acerca de","Imprimir","subrayar","tachar","sangría","quitar sangría","Tamaño completo","encoger","línea horizontal","lista sin ordenar","lista ordenada","Cortar","Seleccionar todo","Incluir código","Abrir vínculo","Editar vínculo","No seguir","Desvincular","Actualizar","Para editar","Ver","URL","Editar","Alineación horizontal","Filtrar","Ordenar por fecha modificación","Ordenar por nombre","Ordenar por tamaño","Agregar carpeta","Resetear","Guardar","Guardar como...","Redimensionar","Recortar","Ancho","Alto","Mantener relación de aspecto","Si","No","Quitar","Seleccionar","Seleccionar: %s","Alineación vertical","Dividir","Mezclar","Agregar columna","Agregar fila",null,"Borrar","Dividir vertical","Dividir horizontal","Borde","El código es similar a HTML. ¿Mantener como HTML?","Pegar como HTML?","Mantener","Insertar como texto","Insertar solo texto","Solo puedes editar tus propias imágenes. ¿Descargar esta imagen en el servidor?","¡La imagen se ha subido correctamente al servidor!","paleta","No hay archivos en este directorio.","renombrar","Ingresa un nuevo nombre","avance","Descargar","Pegar desde el portapapeles","Su navegador no soporta el acceso directo en el portapapeles.","Selección de copia","copia","Radio frontera","Mostrar todos los","Aplicar","Por favor, rellene este campo","Por favor, introduzca una dirección web","Predeterminado","Círculo","Punto","Cuadro","Encontrar","Buscar Anterior","Buscar Siguiente","El contenido pegado proviene de un documento de Microsoft Word/Excel. ¿Desea mantener el formato o limpiarlo?","Pegado desde Word detectado","Limpiar","Insertar nombre de clase","Presione Alt para cambiar el tamaño personalizado",null,null,null]

/***/ }),

/***/ 39611:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   V: function() { return /* binding */ flatButtonsSet; },
/* harmony export */   i: function() { return /* binding */ isButtonGroup; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37923);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @private
 */
const isButtonGroup = (item) => {
    return (0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_0__/* .isArray */ .c)(item.buttons);
};
/**
 * @private
 */
function flatButtonsSet(buttons, jodit) {
    const groups = jodit.getRegisteredButtonGroups();
    return new Set(buttons.reduce((acc, item) => {
        var _a;
        if (isButtonGroup(item)) {
            acc = acc.concat([
                ...item.buttons,
                ...((_a = groups[item.group]) !== null && _a !== void 0 ? _a : [])
            ]);
        }
        else {
            acc.push(item);
        }
        return acc;
    }, []));
}


/***/ }),

/***/ 39626:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36115);
/* harmony import */ var jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(16116);
/* harmony import */ var _brush_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45674);
/* harmony import */ var _brush_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_brush_svg__WEBPACK_IMPORTED_MODULE_5__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .I.set('brush', (_brush_svg__WEBPACK_IMPORTED_MODULE_5___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.prototype.controls.brushCell = {
    isVisible: (editor) => {
        return !editor.o.disablePlugins.includes('color');
    },
    icon: 'brush',
    popup: (editor, _, close) => {
        if (!(0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.isJoditObject)(editor)) {
            return;
        }
        const tableModule = editor.getInstance('Table', editor.o), selected = tableModule.getAllSelectedCells();
        if (!selected.length) {
            return false;
        }
        const makeColorPicker = (key) => (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__/* .ColorPickerWidget */ .Kn)(editor, (value) => {
            selected.forEach(cell => {
                (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(cell, key, value);
            });
            editor.lock();
            editor.synchronizeValues();
            close();
            editor.unlock();
        }, (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(selected[0], key));
        return (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__/* .TabsWidget */ .Zg)(editor, [
            {
                name: 'Background',
                content: makeColorPicker('background-color')
            },
            { name: 'Text', content: makeColorPicker('color') },
            { name: 'Border', content: makeColorPicker('border-color') }
        ]);
    },
    tooltip: 'Background'
};
jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.prototype.controls.brush = {
    isVisible: (editor) => {
        return !editor.o.disablePlugins.includes('color');
    },
    update(editor, button) {
        const color = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color');
        const update = (key, value) => {
            if (value && value !== (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(editor.editor, key).toString()) {
                button.state.icon.fill = value;
                return;
            }
        };
        if (color) {
            const mode = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color');
            update(mode === 'color' ? mode : 'background-color', color);
            return;
        }
        const current = editor.s.current();
        if (current && !button.state.disabled) {
            const currentBpx = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.closest(current, jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement, editor.editor) || editor.editor;
            update('color', (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(currentBpx, 'color').toString());
            update('background-color', (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(currentBpx, 'background-color').toString());
        }
        button.state.icon.fill = '';
        button.state.activated = false;
    },
    popup: (editor, current, close, button) => {
        let colorHEX = '', bg_color = '', tabs = [], currentElement = null;
        if (current && current !== editor.editor && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isNode(current)) {
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(current) &&
                editor.s.isCollapsed() &&
                !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(current, new Set(['br', 'hr']))) {
                currentElement = current;
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.up(current, (node) => {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(node)) {
                    const color = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(node, 'color', true), background = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.css)(node, 'background-color', true);
                    if (color) {
                        colorHEX = color.toString();
                        return true;
                    }
                    if (background) {
                        bg_color = background.toString();
                        return true;
                    }
                }
            }, editor.editor);
        }
        const backgroundTag = (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__/* .ColorPickerWidget */ .Kn)(editor, (value) => {
            if (!currentElement) {
                editor.execCommand('background', false, value);
            }
            else {
                currentElement.style.backgroundColor = value;
            }
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color', value);
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color-mode', 'background');
            close();
        }, bg_color);
        const colorTab = (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__/* .ColorPickerWidget */ .Kn)(editor, (value) => {
            if (!currentElement) {
                editor.execCommand('forecolor', false, value);
            }
            else {
                currentElement.style.color = value;
            }
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color', value);
            (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color-mode', 'color');
            close();
        }, colorHEX);
        tabs = [
            {
                name: 'Background',
                content: backgroundTag
            },
            {
                name: 'Text',
                content: colorTab
            }
        ];
        if (editor.o.colorPickerDefaultTab !== 'background') {
            tabs = tabs.reverse();
        }
        return (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_4__/* .TabsWidget */ .Zg)(editor, tabs, currentElement);
    },
    exec(jodit, current, { button }) {
        const mode = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color-mode'), color = (0,jodit_core_helpers___WEBPACK_IMPORTED_MODULE_1__.dataBind)(button, 'color');
        if (!mode) {
            return false;
        }
        if (current &&
            current !== jodit.editor &&
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isNode(current) &&
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(current)) {
            switch (mode) {
                case 'color':
                    current.style.color = color;
                    break;
                case 'background':
                    current.style.backgroundColor = color;
                    break;
            }
        }
        else {
            jodit.execCommand(mode === 'background' ? mode : 'forecolor', false, color);
        }
    },
    tooltip: 'Fill color or set the text color'
};


/***/ }),

/***/ 39858:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M704 1376v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm-544-992h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z\"/> </svg>"

/***/ }),

/***/ 40037:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path stroke-width=\"0\" d=\"M381 1620q0 80-54.5 126t-135.5 46q-106 0-172-66l57-88q49 45 106 45 29 0 50.5-14.5t21.5-42.5q0-64-105-56l-26-56q8-10 32.5-43.5t42.5-54 37-38.5v-1q-16 0-48.5 1t-48.5 1v53h-106v-152h333v88l-95 115q51 12 81 49t30 88zm2-627v159h-362q-6-36-6-54 0-51 23.5-93t56.5-68 66-47.5 56.5-43.5 23.5-45q0-25-14.5-38.5t-39.5-13.5q-46 0-81 58l-85-59q24-51 71.5-79.5t105.5-28.5q73 0 123 41.5t50 112.5q0 50-34 91.5t-75 64.5-75.5 50.5-35.5 52.5h127v-60h105zm1409 319v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-14 9-23t23-9h1216q13 0 22.5 9.5t9.5 22.5zm-1408-899v99h-335v-99h107q0-41 .5-122t.5-121v-12h-2q-8 17-50 54l-71-76 136-127h106v404h108zm1408 387v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-14 9-23t23-9h1216q13 0 22.5 9.5t9.5 22.5zm0-512v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1216q13 0 22.5 9.5t9.5 22.5z\"/> </svg>"

/***/ }),

/***/ 40080:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Mr: function() { return /* binding */ hAlignElement; },
/* harmony export */   Op: function() { return /* binding */ alignElement; },
/* harmony export */   Xm: function() { return /* binding */ clearAlign; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38322);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Align image
 */
function hAlignElement(image, align) {
    if (align && align !== 'normal') {
        if (align !== 'center') {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, 'float', align);
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .clearCenterAlign */ .a)(image);
        }
        else {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, {
                float: '',
                display: 'block',
                marginLeft: 'auto',
                marginRight: 'auto'
            });
        }
    }
    else {
        if ((0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, 'float') &&
            ['right', 'left'].indexOf((0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, 'float').toString().toLowerCase()) !== -1) {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .css */ .A)(image, 'float', '');
        }
        (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_1__/* .clearCenterAlign */ .a)(image);
    }
}
/**
 * Remove text-align style for all selected children
 */
function clearAlign(node) {
    jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.each(node, elm => {
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(elm)) {
            if (elm.style.textAlign) {
                elm.style.textAlign = '';
                if (!elm.style.cssText.trim().length) {
                    elm.removeAttribute('style');
                }
            }
        }
    });
}
/**
 * Apply align for element
 */
function alignElement(command, box) {
    if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isNode(box) && jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isElement(box)) {
        clearAlign(box);
        switch (command.toLowerCase()) {
            case 'justifyfull':
                box.style.textAlign = 'justify';
                break;
            case 'justifyright':
                box.style.textAlign = 'right';
                break;
            case 'justifyleft':
                box.style.textAlign = 'left';
                break;
            case 'justifycenter':
                box.style.textAlign = 'center';
                break;
        }
    }
}


/***/ }),

/***/ 40594:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   X: function() { return /* reexport safe */ _create__WEBPACK_IMPORTED_MODULE_0__.X; }
/* harmony export */ });
/* harmony import */ var _create__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92852);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module create
 */



/***/ }),

/***/ 40677:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ set; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12461);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(25376);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Safe access in tree object
 *
 * @example
 * ```js
 * const a = {}, b = {};
 * Jodit.modules.Helpers.set('a.b.c.d.e', 1, a);
 * console.log(a);// {a: {b: {c: {d: {e: 1}}}}}
 *
 * Jodit.modules.Helpers.set('a.0.e', 1, b);
 * console.log(b);// {a: [{e: 1}]}
 * ```
 */
function set(chain, value, obj) {
    if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(chain) || !chain.length) {
        return;
    }
    const parts = chain.split('.');
    let result = obj, key = parts[0];
    for (let i = 0; i < parts.length - 1; i += 1) {
        key = parts[i];
        if (!(0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_1__/* .isArray */ .c)(result[key]) && !(0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_2__/* .isPlainObject */ .Q)(result[key])) {
            result[key] = (0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_3__/* .isNumeric */ .k)(parts[i + 1]) ? [] : {};
        }
        result = result[key];
    }
    if (result) {
        result[parts[parts.length - 1]] = value;
    }
}


/***/ }),

/***/ 41111:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M384 1662l17-85q6-2 81.5-21.5t111.5-37.5q28-35 41-101 1-7 62-289t114-543.5 52-296.5v-25q-24-13-54.5-18.5t-69.5-8-58-5.5l19-103q33 2 120 6.5t149.5 7 120.5 2.5q48 0 98.5-2.5t121-7 98.5-6.5q-5 39-19 89-30 10-101.5 28.5t-108.5 33.5q-8 19-14 42.5t-9 40-7.5 45.5-6.5 42q-27 148-87.5 419.5t-77.5 355.5q-2 9-13 58t-20 90-16 83.5-6 57.5l1 18q17 4 185 31-3 44-16 99-11 0-32.5 1.5t-32.5 1.5q-29 0-87-10t-86-10q-138-2-206-2-51 0-143 9t-121 11z\"/> </svg>"

/***/ }),

/***/ 41133:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/select
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.select = {
    normalizeSelectionBeforeCutAndCopy: false,
    normalizeTripleClick: true
};


/***/ }),

/***/ 41159:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   y: function() { return /* binding */ insertParagraph; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils_scroll_into_view__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(641);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Insert default paragraph
 * @private
 */
function insertParagraph(fake, editor, wrapperTag, style) {
    const isBR = wrapperTag.toLowerCase() === 'br', { createInside } = editor, p = createInside.element(wrapperTag), br = createInside.element('br');
    if (!isBR) {
        p.appendChild(br);
    }
    if (style && style.cssText) {
        p.setAttribute('style', style.cssText);
    }
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.after(fake, p);
    jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.before(isBR ? p : br, fake);
    (0,jodit_core_helpers_utils_scroll_into_view__WEBPACK_IMPORTED_MODULE_1__/* .scrollIntoViewIfNeeded */ .$)(p, editor.editor, editor.ed);
    return p;
}


/***/ }),

/***/ 41324:
/***/ (function(module) {

"use strict";
module.exports = __WEBPACK_EXTERNAL_MODULE__41324__;

/***/ }),

/***/ 42448:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: function() { return /* binding */ toArray; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_native_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34796);
/* harmony import */ var jodit_core_helpers_utils_reset__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44210);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/array
 */


/**
 * Always return Array. It's a safe polyfill for [Array.from](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/from) method
 * In certain scenarios (such as with Joomla Mootools), Array.from may be substituted with a less optimal implementation
 * ```javascript
 * Jodit.modules.Helpers.toArray('123') // ['1', '2', '3']
 * Jodit.modules.Helpers.toArray(['test']) // ['test']
 * Jodit.modules.Helpers.toArray(1) // []
 * ```
 */
const toArray = function toArray(...args) {
    var _a;
    const func = (0,jodit_core_helpers_checker_is_native_function__WEBPACK_IMPORTED_MODULE_1__/* .isNativeFunction */ .a)(Array.from)
        ? Array.from
        : ((_a = (0,jodit_core_helpers_utils_reset__WEBPACK_IMPORTED_MODULE_0__/* .reset */ .c)('Array.from')) !== null && _a !== void 0 ? _a : Array.from);
    return func.apply(Array, args);
};


/***/ }),

/***/ 42589:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ splitArray; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Return an array from string or array
 * ```javascript
 * Jodit.modules.Helpers.splitArray('1,2,3') // ['1', '2', '3']
 * Jodit.modules.Helpers.splitArray(['1', '2', '3']) // ['1', '2', '3']
 * ```
 */
function splitArray(a) {
    return Array.isArray(a) ? a : a.split(/[,\s]+/);
}


/***/ }),

/***/ 42898:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: function() { return /* binding */ checkRemoveEmptyParent; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var _check_join_two_lists__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(72874);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Check if the current empty item can be removed
 *
 * @example
 * ```html
 * <p>first stop</p><p>|<br></p>
 * ```
 * result
 * ```html
 * <p>first stop|</p>
 * ```
 *
 * @private
 */
function checkRemoveEmptyParent(jodit, fakeNode, backspace) {
    let found = false;
    const { setCursorBefore, setCursorIn } = jodit.s;
    let prn = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(fakeNode, jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement, jodit.editor);
    if (!prn || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isEmpty(prn)) {
        return false;
    }
    const neighbor = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findNotEmptyNeighbor(fakeNode, backspace, jodit.editor);
    do {
        if (prn && jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isEmpty(prn) && !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isCell(prn)) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.after(prn, fakeNode);
            const tmp = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(prn, n => jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(n) && n !== prn, jodit.editor);
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(prn);
            found = true;
            prn = tmp;
        }
        else {
            break;
        }
    } while (prn);
    if (found && (0,_check_join_two_lists__WEBPACK_IMPORTED_MODULE_2__/* .checkJoinTwoLists */ .a)(jodit, fakeNode, backspace)) {
        return true;
    }
    if (neighbor &&
        !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(neighbor) &&
        !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(neighbor, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS)) {
        setCursorIn(neighbor, !backspace);
    }
    else {
        setCursorBefore(fakeNode);
    }
    return found;
}


/***/ }),

/***/ 43218:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M512 1248v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm-640-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm-640-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68z\"/> </svg>"

/***/ }),

/***/ 43327:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E: function() { return /* binding */ checkJoinNeighbors; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_plugins_backspace_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81779);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Check if two separate elements can be connected
 * @private
 */
function checkJoinNeighbors(jodit, fakeNode, backspace) {
    let nextBox = fakeNode, mainClosestBox = nextBox;
    // Find the main big closest element
    while (nextBox &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findNotEmptySibling(nextBox, backspace) &&
        nextBox.parentElement !== jodit.editor) {
        nextBox = nextBox.parentElement;
        mainClosestBox = nextBox;
    }
    if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(mainClosestBox) &&
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isContentEditable(mainClosestBox, jodit.editor)) {
        const sibling = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.findNotEmptySibling(mainClosestBox, backspace);
        if (sibling &&
            (checkMoveListContent(jodit, mainClosestBox, sibling, backspace) ||
                moveContentAndRemoveEmpty(jodit, mainClosestBox, sibling, backspace))) {
            jodit.s.setCursorBefore(fakeNode);
            return true;
        }
    }
    return false;
}
function checkMoveListContent(jodit, mainClosestBox, sibling, backspace) {
    // Process UL/LI/OL cases
    const siblingIsList = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(sibling, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS);
    const boxIsList = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(mainClosestBox, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS);
    const elementChild = (elm, side) => side ? elm.firstElementChild : elm.lastElementChild;
    if (boxIsList) {
        sibling = jodit.createInside.element(jodit.o.enterBlock);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.before(mainClosestBox, sibling);
        return moveContentAndRemoveEmpty(jodit, elementChild(mainClosestBox, backspace), sibling, backspace);
    }
    if (sibling && siblingIsList && !boxIsList) {
        return moveContentAndRemoveEmpty(jodit, mainClosestBox, elementChild(sibling, !backspace), backspace);
    }
    return false;
}
function moveContentAndRemoveEmpty(jodit, mainClosestBox, sibling, backspace) {
    // Move content and remove empty nodes
    if (mainClosestBox && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(sibling)) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.moveContent(mainClosestBox, sibling, !backspace, (0,jodit_plugins_backspace_helpers__WEBPACK_IMPORTED_MODULE_2__/* .getMoveFilter */ .g)(jodit));
        let remove = mainClosestBox;
        while (remove && remove !== jodit.editor && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isEmpty(remove)) {
            const parent = remove.parentElement;
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(remove);
            remove = parent;
        }
        return true;
    }
    return false;
}


/***/ }),

/***/ 43431:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   h: function() { return /* binding */ Eventify; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * Class for adding event handling capability
 *
 * ```ts
 * class SomeClass extends Eventify<{ start: (node: Node) => boolean; }> {
 * 	constructor() {
 * 		super();
 * 		setTimeout(() => {
 * 			if (this.emit('start', document.body)) {
 * 				console.log('yes');
 * 			};
 * 		}, 100);
 * 	}
 * }
 *
 * const sm = new SomeClass();
 * sm.on('start', (node) => {
 * 	console.log(node);
 * 	return true;
 * })
 * ```
 */
class Eventify {
    constructor() {
        this.__map = new Map();
    }
    on(name, func) {
        var _a;
        if (!this.__map.has(name)) {
            this.__map.set(name, new Set());
        }
        (_a = this.__map.get(name)) === null || _a === void 0 ? void 0 : _a.add(func);
        return this;
    }
    off(name, func) {
        var _a;
        if (this.__map.has(name)) {
            (_a = this.__map.get(name)) === null || _a === void 0 ? void 0 : _a.delete(func);
        }
        return this;
    }
    destruct() {
        this.__map.clear();
    }
    emit(name, ...args) {
        var _a;
        let result;
        if (this.__map.has(name)) {
            (_a = this.__map.get(name)) === null || _a === void 0 ? void 0 : _a.forEach(cb => {
                result = cb(...args);
            });
        }
        return result;
    }
}


/***/ }),

/***/ 44210:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: function() { return /* binding */ reset; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69052);
/* harmony import */ var _get__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16841);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



const map = {};
/**
 * Reset Vanilla JS native function
 * @example
 * ```js
 * reset('Array.from')(Set([1,2,3])) // [1, 2, 3]
 * ```
 * You must use the function derived from the method immediately as its iframe is being removed
 */
function reset(key) {
    var _a, _b;
    if (!(key in map)) {
        const iframe = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('iframe');
        try {
            iframe.src = 'about:blank';
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.body.appendChild(iframe);
            if (!iframe.contentWindow) {
                return null;
            }
            const func = (0,_get__WEBPACK_IMPORTED_MODULE_1__/* .get */ .J)(key, iframe.contentWindow), bind = (0,_get__WEBPACK_IMPORTED_MODULE_1__/* .get */ .J)(key.split('.').slice(0, -1).join('.'), iframe.contentWindow);
            if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(func)) {
                map[key] = func.bind(bind);
            }
        }
        catch (e) {
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                throw e;
            }
        }
        finally {
            (_a = iframe.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(iframe);
        }
    }
    return (_b = map[key]) !== null && _b !== void 0 ? _b : null;
}


/***/ }),

/***/ 44636:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"><path d=\"M491 1536l91-91-235-235-91 91v107h128v128h107zm523-928q0-22-22-22-10 0-17 7l-542 542q-7 7-7 17 0 22 22 22 10 0 17-7l542-542q7-7 7-17zm-54-192l416 416-832 832h-416v-416zm683 96q0 53-37 90l-166 166-416-416 166-165q36-38 90-38 53 0 91 38l235 234q37 39 37 91z\"/></svg>"

/***/ }),

/***/ 44906:
/***/ (function(module) {

module.exports["default"] = ["輸入一些內容","關於Jodit","Jodit Editor","開發者指南","使用幫助","相關授權條款資訊，請造訪我們的網站：","購買完整版本","Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.","錨點","在新分頁開啟","全螢幕編輯","清除樣式","顏色","取消復原","復原","粗體","斜體","項目符號清單","編號清單","置中","文字對齊","靠左","靠右","分割線","圖片","檔案","插入 youtube/vimeo 影片","插入連結","文字大小","字型","格式化區塊","內文","標題1","標題2","標題3","標題4","引文","程式碼","插入","表格","減少縮排","增加縮排","選擇特殊符號","特殊符號","格式複製","檢視原始碼","邊距","上","右","下","左","樣式","Classes","對齊方式","靠右","置中","靠左","無","Src","Title","替代","Link","在新分頁開啟連結","圖片","檔案","進階","圖片屬性","取消","確定","檔案瀏覽","清單載入錯誤","資料夾載入錯誤","您確定嗎？","輸入路徑","創建路徑","type name","拖曳圖片至此","拖曳檔案至此","或點擊","替代文字","上傳","瀏覽","背景色","文字","頂部","中間","底部","插入左方欄","插入右方欄","插入上方列","插入下方列","刪除表格","刪除整列","刪除整欄","清除內容","字元數: %d","單字數: %d","刪除線","底線","上標","下標","剪下","全選","斷行","尋找","取代為","取代","貼上","選擇內容並貼上","原始碼","粗體","斜體","顏色","連結","復原","取消復原","表格","圖片","橡皮擦","段落","文字大小","影片","字型","關於","列印","底線","刪除線","增加縮排","減少縮排","全螢幕","縮減","分隔線","項目符號清單","編號清單","剪下","全選","嵌入程式碼","打開連結","編輯連結","No follow","取消連結","更新","鉛筆","查看","URL",null,"水平對齊","篩選","修改時間排序","名稱排序","大小排序","新增資料夾","重設","儲存","另存為...","調整大小","裁切","寬","高","維持長寬比","是","否","移除","選擇","選擇: %s","垂直對齊","分割","合併","新增欄","新增列",null,"刪除","垂直分割","水平分割","邊框","您的程式碼與 HTML 類似，是否貼上 HTML 格式？","貼上 HTML","保留原始格式","以純文字貼上","僅貼上內文","您只能編輯您自己的圖片。是否下載此圖片?","圖片上傳成功","調色盤","沒有檔案","重新命名","輸入新名稱","預覽","下載","從剪貼簿貼上","瀏覽器無法存取剪貼簿。","複製已選取項目","複製","邊框圓角","顯示全部","應用","請輸入此欄位","請輸入網址","預設","圓圈","點","方形","尋找","尋找上一個","尋找下一個","正在貼上 Word/Excel 文件的內容，是否保留原始格式？","貼上 Word 格式","清除格式","插入 class 名稱","按住 Alt 以調整自訂大小",null,null,null]

/***/ }),

/***/ 45062:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1025 1369v167h-248l-159-252-24-42q-8-9-11-21h-3l-9 21q-10 20-25 44l-155 250h-258v-167h128l197-291-185-272h-137v-168h276l139 228q2 4 23 42 8 9 11 21h3q3-9 11-21l25-42 140-228h257v168h-125l-184 267 204 296h109zm639 217v206h-514l-4-27q-3-45-3-46 0-64 26-117t65-86.5 84-65 84-54.5 65-54 26-64q0-38-29.5-62.5t-70.5-24.5q-51 0-97 39-14 11-36 38l-105-92q26-37 63-66 80-65 188-65 110 0 178 59.5t68 158.5q0 66-34.5 118.5t-84 86-99.5 62.5-87 63-41 73h232v-80h126z\"/> </svg>"

/***/ }),

/***/ 45244:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1639 1056q0 5-1 7-64 268-268 434.5t-478 166.5q-146 0-282.5-55t-243.5-157l-129 129q-19 19-45 19t-45-19-19-45v-448q0-26 19-45t45-19h448q26 0 45 19t19 45-19 45l-137 137q71 66 161 102t187 36q134 0 250-65t186-179q11-17 53-117 8-23 30-23h192q13 0 22.5 9.5t9.5 22.5zm25-800v448q0 26-19 45t-45 19h-448q-26 0-45-19t-19-45 19-45l138-138q-148-137-349-137-134 0-250 65t-186 179q-11 17-53 117-8 23-30 23h-199q-13 0-22.5-9.5t-9.5-22.5v-7q65-268 270-434.5t480-166.5q146 0 284 55.5t245 156.5l130-129q19-19 45-19t45 19 19 45z\"/> </svg>"

/***/ }),

/***/ 45512:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 10 10\"> <path d=\"M.941 4.523a.75.75 0 1 1 1.06-1.06l3.006 3.005 3.005-3.005a.75.75 0 1 1 1.06 1.06l-3.549 3.55a.75.75 0 0 1-1.168-.136L.941 4.523z\"/> </svg>"

/***/ }),

/***/ 45674:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M896 1152q0-36-20-69-1-1-15.5-22.5t-25.5-38-25-44-21-50.5q-4-16-21-16t-21 16q-7 23-21 50.5t-25 44-25.5 38-15.5 22.5q-20 33-20 69 0 53 37.5 90.5t90.5 37.5 90.5-37.5 37.5-90.5zm512-128q0 212-150 362t-362 150-362-150-150-362q0-145 81-275 6-9 62.5-90.5t101-151 99.5-178 83-201.5q9-30 34-47t51-17 51.5 17 33.5 47q28 93 83 201.5t99.5 178 101 151 62.5 90.5q81 127 81 275z\"/> </svg>"

/***/ }),

/***/ 46079:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export indent */
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97369);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97767);
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3392);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






const applyIndentToBox = (processedElements, currentBox, editor, command) => {
    if (!currentBox) {
        return;
    }
    if (processedElements.has(currentBox)) {
        return;
    }
    const key = (0,_helpers__WEBPACK_IMPORTED_MODULE_5__/* .getKey */ .i)(editor.o.direction, currentBox);
    processedElements.add(currentBox);
    let value = currentBox.style[key] ? parseInt(currentBox.style[key], 10) : 0;
    value += editor.o.indentMargin * (command === 'outdent' ? -1 : 1);
    currentBox.style[key] = value > 0 ? value + 'px' : '';
    if (!(0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(currentBox, 'style')) {
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(currentBox, 'style', null);
    }
};
/**
 * Indents the line containing the selection or insertion point.
 */
function indent(editor) {
    editor
        .registerButton({
        name: 'indent',
        group: 'indent'
    })
        .registerButton({
        name: 'outdent',
        group: 'indent'
    });
    const indentCommand = (command) => {
        const processedElements = new Set();
        const { enter, enterBlock } = editor.o;
        const isBrMode = enter.toLowerCase() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.BR;
        const current = editor.s.current();
        if (isBrMode && editor.s.isCollapsed()) {
            if (current) {
                const box = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.wrapNextInline(current, enterBlock, editor);
                applyIndentToBox(processedElements, box, editor, command);
                return false;
            }
        }
        editor.s.eachSelection((current) => {
            editor.s.save();
            let currentBox = current
                ? jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.up(current, jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isBlock, editor.editor)
                : false;
            if (!currentBox && current) {
                currentBox = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.call)(!isBrMode ? jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.wrapInline : jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.wrapNextInline, current, !isBrMode ? enter.toLowerCase() : enterBlock, editor);
            }
            if (!currentBox) {
                editor.s.restore();
                return false;
            }
            applyIndentToBox(processedElements, currentBox, editor, command);
            editor.s.restore();
        });
        editor.synchronizeValues();
        return false;
    };
    editor.registerCommand('indent', {
        exec: indentCommand,
        hotkeys: ['ctrl+]', 'cmd+]']
    });
    editor.registerCommand('outdent', {
        exec: indentCommand,
        hotkeys: ['ctrl+[', 'cmd+[']
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('indent', indent);


/***/ }),

/***/ 46173:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   x: function() { return /* binding */ Jodit; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_request__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(53883);
/* harmony import */ var jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(58597);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(36115);
/* harmony import */ var jodit_modules__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(37435);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var Jodit_1;










const __defaultStyleDisplayKey = 'data-jodit-default-style-display';
const __defaultClassesKey = 'data-jodit-default-classes';
let Jodit = Jodit_1 = class Jodit extends jodit_modules__WEBPACK_IMPORTED_MODULE_7__.ViewWithToolbar {
    /** @override */
    className() {
        return 'Jodit';
    }
    /**
     * Return promise for ready actions
     * @example
     * ```js
     * const jodit = Jodit.make('#editor');
     * await jodit.waitForReady();
     * jodit.e.fire('someAsyncLoadedPluginEvent', (test) => {
     *   alert(test);
     * });
     * ```
     */
    waitForReady() {
        if (this.isReady) {
            return Promise.resolve(this);
        }
        return this.async.promise(resolve => {
            this.hookStatus('ready', () => resolve(this));
        });
    }
    /**
     * @deprecated I don't know why I wrote itp
     */
    static get ready() {
        return new Promise(resolve => {
            jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .eventEmitter */ .RR.on('joditready', resolve);
        });
    }
    /**
     * Plain text editor's value
     */
    get text() {
        if (this.editor) {
            return this.editor.innerText || '';
        }
        const div = this.createInside.div();
        div.innerHTML = this.getElementValue();
        return div.innerText || '';
    }
    /**
     * Return a default timeout period in milliseconds for some debounce or throttle functions.
     * By default, `{history.timeout}` options
     */
    get defaultTimeout() {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isNumber)(this.o.defaultTimeout)
            ? this.o.defaultTimeout
            : jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions.defaultTimeout;
    }
    /**
     * Method wrap usual object in Object helper for prevent deep object merging in options*
     * ```js
     * const editor = Jodit.make('#editor', {
     * 	controls: {
     * 		fontsize: {
     * 			list: Jodit.atom([8, 9, 10])
     * 		}
     * 	}
     * });
     * ```
     * In this case, the array [8, 9, 10] will not be combined with other arrays, but will replace them
     */
    static atom(object) {
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.markAsAtomic)(object);
    }
    /**
     * Factory for creating Jodit instance
     */
    static make(element, options) {
        return new this(element, options);
    }
    /**
     * Checks if the element has already been initialized when for Jodit
     */
    static isJoditAssigned(element) {
        return (element &&
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isJoditObject)(element.component) &&
            !element.component.isInDestruct);
    }
    /**
     * Default settings
     */
    static get defaultOptions() {
        return jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions;
    }
    get createInside() {
        return new jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Create(() => this.ed, this.o.createAttributes);
    }
    __setPlaceField(field, value) {
        if (!this.currentPlace) {
            this.currentPlace = {};
            this.places = [this.currentPlace];
        }
        this.currentPlace[field] = value;
    }
    /**
     * element It contains source element
     */
    get element() {
        return this.currentPlace.element;
    }
    /**
     * editor It contains the root element editor
     */
    get editor() {
        return this.currentPlace.editor;
    }
    set editor(editor) {
        this.__setPlaceField('editor', editor);
    }
    /**
     * Container for all staff
     */
    get container() {
        return this.currentPlace.container;
    }
    set container(container) {
        this.__setPlaceField('container', container);
    }
    /**
     * workplace It contains source and wysiwyg editors
     */
    get workplace() {
        return this.currentPlace.workplace;
    }
    get message() {
        return this.getMessageModule(this.workplace);
    }
    /**
     * Statusbar module
     */
    get statusbar() {
        return this.currentPlace.statusbar;
    }
    /**
     * iframe Iframe for iframe mode
     */
    get iframe() {
        return this.currentPlace.iframe;
    }
    set iframe(iframe) {
        this.__setPlaceField('iframe', iframe);
    }
    get history() {
        return this.currentPlace.history;
    }
    /**
     * In iframe mode editor's window can be different by owner
     */
    get editorWindow() {
        return this.currentPlace.editorWindow;
    }
    set editorWindow(win) {
        this.__setPlaceField('editorWindow', win);
    }
    /**
     * Alias for this.ew
     */
    get ew() {
        return this.editorWindow;
    }
    /**
     * In iframe mode editor's window can be different by owner
     */
    get editorDocument() {
        return this.currentPlace.editorWindow.document;
    }
    /**
     * Alias for this.ew
     */
    get ed() {
        return this.editorDocument;
    }
    /**
     * options All Jodit settings default + second arguments of constructor
     */
    get options() {
        return this.currentPlace.options;
    }
    set options(opt) {
        this.__setPlaceField('options', opt);
    }
    /**
     * Alias for this.selection
     */
    get s() {
        return this.selection;
    }
    get uploader() {
        return this.getInstance('Uploader', this.o.uploader);
    }
    get filebrowser() {
        const jodit = this;
        const options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.ConfigProto)({
            defaultTimeout: jodit.defaultTimeout,
            uploader: jodit.o.uploader,
            language: jodit.o.language,
            license: jodit.o.license,
            theme: jodit.o.theme,
            shadowRoot: jodit.o.shadowRoot,
            defaultCallback(data) {
                if (data.files && data.files.length) {
                    data.files.forEach((file, i) => {
                        const url = data.baseurl + file;
                        const isImage = data.isImages
                            ? data.isImages[i]
                            : false;
                        if (isImage) {
                            jodit.s.insertImage(url, null, jodit.o.imageDefaultWidth);
                        }
                        else {
                            jodit.s.insertNode(jodit.createInside.fromHTML(`<a href='${url}' title='${url}'>${url}</a>`));
                        }
                    });
                }
            }
        }, this.o.filebrowser);
        return jodit.getInstance('FileBrowser', options);
    }
    /**
     * Editor's mode
     */
    get mode() {
        return this.__mode;
    }
    set mode(mode) {
        this.setMode(mode);
    }
    /**
     * Return real HTML value from WYSIWYG editor.
     * @internal
     */
    getNativeEditorValue() {
        const value = this.e.fire('beforeGetNativeEditorValue');
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value)) {
            return value;
        }
        if (this.editor) {
            return this.editor.innerHTML;
        }
        return this.getElementValue();
    }
    /**
     * Set value to native editor
     */
    setNativeEditorValue(value) {
        const data = {
            value
        };
        if (this.e.fire('beforeSetNativeEditorValue', data)) {
            return;
        }
        if (this.editor) {
            this.editor.innerHTML = data.value;
        }
    }
    /**
     * HTML value
     */
    get value() {
        return this.getEditorValue();
    }
    set value(html) {
        this.setEditorValue(html);
        // @ts-ignore Internal method
        this.history.__processChanges();
    }
    synchronizeValues() {
        this.__imdSynchronizeValues();
    }
    /**
     * This is an internal method, do not use it in your applications.
     * @private
     * @internal
     */
    __imdSynchronizeValues() {
        this.setEditorValue();
    }
    /**
     * Return editor value
     */
    getEditorValue(removeSelectionMarkers = true, consumer) {
        /**
         * Triggered before getEditorValue executed.
         * If returned not undefined, getEditorValue will return this value
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('beforeGetValueFromEditor', function () {
         *     return editor.editor.innerHTML.replace(/a/g, 'b');
         * });
         * ```
         */
        let value;
        value = this.e.fire('beforeGetValueFromEditor', consumer);
        if (value !== undefined) {
            return value;
        }
        value = this.getNativeEditorValue().replace(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP(), '');
        if (removeSelectionMarkers) {
            value = value.replace(/<span[^>]+id="jodit-selection_marker_[^>]+><\/span>/g, '');
        }
        if (value === '<br>') {
            value = '';
        }
        /**
         * Triggered after getEditorValue got value from wysiwyg.
         * It can change new_value.value
         *
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('afterGetValueFromEditor', function (new_value) {
         *     new_value.value = new_value.value.replace('a', 'b');
         * });
         * ```
         */
        const new_value = { value };
        this.e.fire('afterGetValueFromEditor', new_value, consumer);
        return new_value.value;
    }
    /**
     * Set editor html value and if set sync fill source element value
     * When method was called without arguments - it is a simple way to synchronize editor to element
     */
    setEditorValue(value) {
        /**
         * Triggered before getEditorValue set value to wysiwyg.
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('beforeSetValueToEditor', function (old_value) {
         *     return old_value.value.replace('a', 'b');
         * });
         * editor.e.on('beforeSetValueToEditor', function () {
         *     return false; // disable setEditorValue method
         * });
         * ```
         */
        const newValue = this.e.fire('beforeSetValueToEditor', value);
        if (newValue === false) {
            return;
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(newValue)) {
            value = newValue;
        }
        if (!this.editor) {
            if (value !== undefined) {
                this.__setElementValue(value);
            }
            return; // try change value before init or after destruct
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value) && !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isVoid)(value)) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.error)('value must be string');
        }
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isVoid)(value) && this.getNativeEditorValue() !== value) {
            this.setNativeEditorValue(value);
        }
        this.e.fire('postProcessSetEditorValue');
        const old_value = this.getElementValue(), new_value = this.getEditorValue();
        if (!this.__isSilentChange &&
            old_value !== new_value &&
            this.__callChangeCount < jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.SAFE_COUNT_CHANGE_CALL) {
            this.__setElementValue(new_value);
            this.__callChangeCount += 1;
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && this.__callChangeCount > 4) {
                console.warn('Too many recursive changes', new_value, old_value);
            }
            try {
                // @ts-ignore Internal method
                this.history.__upTick();
                this.e.fire('change', new_value, old_value);
                this.e.fire(this.history, 'change', new_value, old_value);
            }
            finally {
                this.__callChangeCount = 0;
            }
        }
    }
    /**
     * If some plugin changes the DOM directly, then you need to update the content of the original element
     */
    updateElementValue() {
        this.__setElementValue(this.getEditorValue());
    }
    /**
     * Return source element value
     */
    getElementValue() {
        return this.element.value !== undefined
            ? this.element.value
            : this.element.innerHTML;
    }
    __setElementValue(value) {
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(value)) {
            throw (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.error)('value must be string');
        }
        if (this.element !== this.container &&
            value !== this.getElementValue()) {
            const data = { value };
            const res = this.e.fire('beforeSetElementValue', data);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(res, () => {
                if (this.element.value !== undefined) {
                    this.element.value = data.value;
                }
                else {
                    this.element.innerHTML = data.value;
                }
                this.e.fire('afterSetElementValue', data);
            });
        }
    }
    /**
     * Register custom handler for command
     *
     * @example
     * ```javascript
     * var jodit = Jodit.make('#editor);
     *
     * jodit.setEditorValue('test test test');
     *
     * jodit.registerCommand('replaceString', function (command, needle, replace) {
     *      var value = this.getEditorValue();
     *      this.setEditorValue(value.replace(needle, replace));
     *      return false; // stop execute native command
     * });
     *
     * jodit.execCommand('replaceString', 'test', 'stop');
     *
     * console.log(jodit.value); // stop test
     *
     * // and you can add hotkeys for command
     * jodit.registerCommand('replaceString', {
     *    hotkeys: 'ctrl+r',
     *    exec: function (command, needle, replace) {
     *     var value = this.getEditorValue();
     *     this.setEditorValue(value.replace(needle, replace));
     *    }
     * });
     *
     * ```
     */
    registerCommand(commandNameOriginal, command, options) {
        const commandName = commandNameOriginal.toLowerCase();
        let commands = this.commands.get(commandName);
        if (commands === undefined) {
            commands = [];
            this.commands.set(commandName, commands);
        }
        commands.push(command);
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(command)) {
            const hotkeys = this.o.commandToHotkeys[commandName] ||
                this.o.commandToHotkeys[commandNameOriginal] ||
                command.hotkeys;
            if (hotkeys) {
                this.registerHotkeyToCommand(hotkeys, commandName, options === null || options === void 0 ? void 0 : options.stopPropagation);
            }
        }
        return this;
    }
    /**
     * Register hotkey for command
     */
    registerHotkeyToCommand(hotkeys, commandName, shouldStop = true) {
        const shortcuts = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.asArray)(hotkeys)
            .map(jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.normalizeKeyAliases)
            .map(hotkey => hotkey + '.hotkey')
            .join(' ');
        this.e
            .off(shortcuts)
            .on(shortcuts, (type, stop) => {
            if (stop) {
                stop.shouldStop = shouldStop !== null && shouldStop !== void 0 ? shouldStop : true;
            }
            return this.execCommand(commandName); // because need `beforeCommand`
        });
    }
    /**
     * Execute command editor
     *
     * @param command - command. It supports all the
     * @see https://developer.mozilla.org/ru/docs/Web/API/Document/execCommand#commands and a number of its own
     * for example applyStyleProperty. Comand fontSize receives the second parameter px,
     * formatBlock and can take several options
     * @example
     * ```javascript
     * this.execCommand('fontSize', 12); // sets the size of 12 px
     * this.execCommand('underline');
     * this.execCommand('formatBlock', 'p'); // will be inserted paragraph
     * ```
     */
    execCommand(command, showUI, value, ...args) {
        if (!this.s.isFocused()) {
            this.s.focus();
        }
        if (this.o.readonly &&
            !this.o.allowCommandsInReadOnly.includes(command)) {
            return;
        }
        let result;
        command = command.toLowerCase();
        /**
         * Called before any command
         * @param command - Command name in lowercase
         * @param second - The second parameter for the command
         * @param third - The third option is for the team
         * @example
         * ```javascript
         * parent.e.on('beforeCommand', function (command) {
         *  if (command === 'justifyCenter') {
         *      var p = parent.c.element('p')
         *      parent.s.insertNode(p)
         *      parent.s.setCursorIn(p);
         *      p.style.textAlign = 'justyfy';
         *      return false; // break executes native command
         *  }
         * })
         * ```
         */
        result = this.e.fire(`beforeCommand${(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.ucfirst)(command)}`, showUI, value, ...args);
        if (result !== false) {
            result = this.e.fire('beforeCommand', command, showUI, value, ...args);
        }
        if (result !== false) {
            result = this.__execCustomCommands(command, showUI, value, ...args);
        }
        if (result !== false) {
            this.s.focus();
            try {
                result = this.nativeExecCommand(command, showUI, value);
            }
            catch (e) {
                if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                    throw e;
                }
            }
        }
        /**
         * It called after any command
         * @param command - name command
         * @param second - The second parameter for the command
         * @param third - The third option is for the team
         */
        this.e.fire('afterCommand', command, showUI, value);
        this.__imdSynchronizeValues(); // synchrony
        return result;
    }
    /**
     * Exec native command
     */
    nativeExecCommand(command, showUI, value) {
        this.__isSilentChange = true;
        try {
            return this.ed.execCommand(command, showUI, value);
        }
        finally {
            this.__isSilentChange = false;
        }
    }
    __execCustomCommands(commandName, second, third, ...args) {
        commandName = commandName.toLowerCase();
        const commands = this.commands.get(commandName);
        if (commands !== undefined) {
            let result;
            commands.forEach((command) => {
                let callback;
                if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isFunction)(command)) {
                    callback = command;
                }
                else {
                    callback = command.exec;
                }
                const resultCurrent = callback.call(this, commandName, second, third, ...args);
                if (resultCurrent !== undefined) {
                    result = resultCurrent;
                }
            });
            return result;
        }
    }
    /**
     * Disable selecting
     */
    lock(name = 'any') {
        if (super.lock(name)) {
            this.__selectionLocked = this.s.save();
            this.s.clear();
            this.editor.classList.add('jodit_lock');
            this.e.fire('lock', true);
            return true;
        }
        return false;
    }
    /**
     * Enable selecting
     */
    unlock() {
        if (super.unlock()) {
            this.editor.classList.remove('jodit_lock');
            if (this.__selectionLocked) {
                this.s.restore();
            }
            this.e.fire('lock', false);
            return true;
        }
        return false;
    }
    /**
     * Return current editor mode: Jodit.MODE_WYSIWYG, Jodit.MODE_SOURCE or Jodit.MODE_SPLIT
     */
    getMode() {
        return this.mode;
    }
    isEditorMode() {
        return this.getRealMode() === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
    }
    /**
     * Return current real work mode. When editor in MODE_SOURCE or MODE_WYSIWYG it will
     * return them, but then editor in MODE_SPLIT it will return MODE_SOURCE if
     * Textarea(CodeMirror) focused or MODE_WYSIWYG otherwise
     *
     * @example
     * ```javascript
     * var editor = Jodit.make('#editor');
     * console.log(editor.getRealMode());
     * ```
     */
    getRealMode() {
        if (this.getMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SPLIT) {
            return this.getMode();
        }
        const active = this.od.activeElement;
        if (active &&
            (active === this.iframe ||
                jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.isOrContains(this.editor, active) ||
                jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.isOrContains(this.toolbar.container, active))) {
            return jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        }
        return jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE;
    }
    /**
     * Set current mode
     */
    setMode(mode) {
        const oldMode = this.getMode();
        const data = {
            mode: parseInt(mode.toString(), 10)
        }, modeClasses = [
            'jodit-wysiwyg_mode',
            'jodit-source__mode',
            'jodit_split_mode'
        ];
        /**
         * Triggered before setMode executed. If returned false method stopped
         * @param data - PlainObject `{mode: {string}}` In handler you can change data.mode
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('beforeSetMode', function (data) {
         *     data.mode = Jodit.MODE_SOURCE; // not respond to the mode change. Always make the source code mode
         * });
         * ```
         */
        if (this.e.fire('beforeSetMode', data) === false) {
            return;
        }
        this.__mode = [
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE,
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG,
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SPLIT
        ].includes(data.mode)
            ? data.mode
            : jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        if (this.o.saveModeInStorage) {
            this.storage.set('jodit_default_mode', this.mode);
        }
        modeClasses.forEach(className => {
            this.container.classList.remove(className);
        });
        this.container.classList.add(modeClasses[this.mode - 1]);
        /**
         * Triggered after setMode executed
         * @example
         * ```javascript
         * var editor = Jodit.make("#redactor");
         * editor.e.on('afterSetMode', function () {
         *     editor.setEditorValue(''); // clear editor's value after change mode
         * });
         * ```
         */
        if (oldMode !== this.getMode()) {
            this.e.fire('afterSetMode');
        }
    }
    /**
     * Toggle editor mode WYSIWYG to TEXTAREA(CodeMirror) to SPLIT(WYSIWYG and TEXTAREA) to again WYSIWYG
     *
     * @example
     * ```javascript
     * var editor = Jodit.make('#editor');
     * editor.toggleMode();
     * ```
     */
    toggleMode() {
        let mode = this.getMode();
        if ([
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE,
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG,
            this.o.useSplitMode ? jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SPLIT : 9
        ].includes(mode + 1)) {
            mode += 1;
        }
        else {
            mode = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        }
        this.setMode(mode);
    }
    /**
     * Switch on/off the editor into the disabled state.
     * When disabled, the user is not able to change the editor content
     * This function firing the `disabled` event.
     */
    setDisabled(isDisabled) {
        this.o.disabled = isDisabled;
        const readOnly = this.__wasReadOnly;
        this.setReadOnly(isDisabled || readOnly);
        this.__wasReadOnly = readOnly;
        if (this.editor) {
            this.editor.setAttribute('aria-disabled', isDisabled.toString());
            this.container.classList.toggle('jodit_disabled', isDisabled);
            this.e.fire('disabled', isDisabled);
        }
    }
    /**
     * Return true if editor in disabled mode
     */
    getDisabled() {
        return this.o.disabled;
    }
    /**
     * Switch on/off the editor into the read-only state.
     * When in readonly, the user is not able to change the editor content, but can still
     * use some editor functions (show source code, print content, or seach).
     * This function firing the `readonly` event.
     */
    setReadOnly(isReadOnly) {
        if (this.__wasReadOnly === isReadOnly) {
            return;
        }
        this.__wasReadOnly = isReadOnly;
        this.o.readonly = isReadOnly;
        if (isReadOnly) {
            this.editor && this.editor.removeAttribute('contenteditable');
        }
        else {
            this.editor && this.editor.setAttribute('contenteditable', 'true');
        }
        this.e && this.e.fire('readonly', isReadOnly);
    }
    /**
     * Return true if editor in read-only mode
     */
    getReadOnly() {
        return this.o.readonly;
    }
    focus() {
        if (this.getMode() !== jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_SOURCE) {
            this.s.focus();
        }
    }
    get isFocused() {
        return this.s.isFocused();
    }
    /**
     * Hook before init
     */
    beforeInitHook() {
        // do nothing
    }
    /**
     * Hook after init
     */
    afterInitHook() {
        // do nothing
    }
    /** @override **/
    initOptions(options) {
        this.options = ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions));
    }
    /** @override **/
    initOwners() {
        // in iframe, it can be changed
        this.editorWindow = this.o.ownerWindow;
        this.ownerWindow = this.o.ownerWindow;
    }
    /**
     * Create instance of Jodit
     *
     * @param element - Selector or HTMLElement
     * @param options - Editor's options
     */
    constructor(element, options) {
        super(options, true);
        /**
         * Define if object is Jodit
         */
        this.isJodit = true;
        this.commands = new Map();
        this.__selectionLocked = null;
        this.__wasReadOnly = false;
        /**
         * Editor has focus in this time
         */
        this.editorIsActive = false;
        this.__mode = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG;
        this.__callChangeCount = 0;
        /**
         * Don't raise a change event
         */
        this.__isSilentChange = false;
        this.__elementToPlace = new Map();
        try {
            const elementSource = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.resolveElement)(element, this.o.shadowRoot || this.od);
            if (Jodit_1.isJoditAssigned(elementSource)) {
                // @ts-ignore
                return elementSource.component;
            }
        }
        catch (e) {
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                throw e;
            }
            this.destruct();
            throw e;
        }
        this.setStatus(jodit_modules__WEBPACK_IMPORTED_MODULE_7__.STATUSES.beforeInit);
        this.id =
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.resolveElement)(element, this.o.shadowRoot || this.od), 'id') ||
                new Date().getTime().toString();
        jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .instances */ .VF[this.id] = this;
        this.attachEvents(options);
        this.e.on(this.ow, 'resize', () => {
            if (this.e) {
                this.e.fire('resize');
            }
        });
        this.e.on('prepareWYSIWYGEditor', this.__prepareWYSIWYGEditor);
        this.selection = new jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Selection(this);
        const beforeInitHookResult = this.beforeInitHook();
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(beforeInitHookResult, () => {
            if (this.isInDestruct) {
                return;
            }
            this.e.fire('beforeInit', this);
            jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.__init(this);
            this.e.fire('afterPluginSystemInit', this);
            this.e.on('changePlace', () => {
                this.setReadOnly(this.o.readonly);
                this.setDisabled(this.o.disabled);
            });
            this.places.length = 0;
            const addPlaceResult = this.addPlace(element, options);
            jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .instances */ .VF[this.id] = this;
            const init = () => {
                if (this.isInDestruct) {
                    return;
                }
                if (this.e) {
                    this.e.fire('afterInit', this);
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(this.afterInitHook());
                this.setStatus(jodit_modules__WEBPACK_IMPORTED_MODULE_7__.STATUSES.ready);
                this.e.fire('afterConstructor', this);
            };
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(addPlaceResult, init);
        });
    }
    /**
     * Create and init current editable place
     */
    addPlace(source, options) {
        const element = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.resolveElement)(source, this.o.shadowRoot || this.od);
        this.attachEvents(options);
        if (element.attributes) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.toArray)(element.attributes).forEach((attr) => {
                const name = attr.name;
                let value = attr.value;
                if (jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions[name] !== undefined &&
                    (!options || options[name] === undefined)) {
                    if (['readonly', 'disabled'].indexOf(name) !== -1) {
                        value = value === '' || value === 'true';
                    }
                    if (/^[0-9]+(\.)?([0-9]+)?$/.test(value.toString())) {
                        value = Number(value);
                    }
                    this.options[name] = value;
                }
            });
        }
        let container = this.c.div('jodit-container');
        container.classList.add('jodit');
        container.classList.add('jodit-container');
        container.classList.add(`jodit_theme_${this.o.theme || 'default'}`);
        addClassNames(this.o.className, container);
        if (this.o.containerStyle) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(container, this.o.containerStyle);
        }
        const { styleValues } = this.o;
        Object.keys(styleValues).forEach(key => {
            const property = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.kebabCase)(key);
            container.style.setProperty(`--jd-${property}`, styleValues[key]);
        });
        container.setAttribute('contenteditable', 'false');
        let buffer = null;
        if (this.o.inline) {
            if (['TEXTAREA', 'INPUT'].indexOf(element.nodeName) === -1) {
                container = element;
                element.setAttribute(__defaultClassesKey, element.className.toString());
                buffer = container.innerHTML;
                container.innerHTML = '';
            }
            container.classList.add('jodit_inline');
            container.classList.add('jodit-container');
        }
        // actual for inline mode
        if (element !== container) {
            // hide source element
            if (element.style.display) {
                element.setAttribute(__defaultStyleDisplayKey, element.style.display);
            }
            element.style.display = 'none';
        }
        const workplace = this.c.div('jodit-workplace', {
            contenteditable: false
        });
        container.appendChild(workplace);
        if (element.parentNode && element !== container) {
            element.parentNode.insertBefore(container, element);
        }
        Object.defineProperty(element, 'component', {
            enumerable: false,
            configurable: true,
            value: this
        });
        const editor = this.c.div('jodit-wysiwyg', {
            contenteditable: true,
            'aria-disabled': false,
            tabindex: this.o.tabIndex
        });
        workplace.appendChild(editor);
        const currentPlace = {
            editor,
            element,
            container,
            workplace,
            statusbar: new jodit_modules__WEBPACK_IMPORTED_MODULE_7__.StatusBar(this, container),
            options: this.isReady
                ? (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.ConfigProto)(options || {}, jodit_config__WEBPACK_IMPORTED_MODULE_6__/* .Config */ .T.defaultOptions)
                : this.options,
            history: new jodit_modules__WEBPACK_IMPORTED_MODULE_7__.History(this),
            editorWindow: this.ow
        };
        this.__elementToPlace.set(editor, currentPlace);
        this.setCurrentPlace(currentPlace);
        this.places.push(currentPlace);
        this.setNativeEditorValue(this.getElementValue()); // Init value
        const initResult = this.__initEditor(buffer);
        const opt = this.options;
        const init = () => {
            if (opt.enableDragAndDropFileToEditor &&
                opt.uploader &&
                (opt.uploader.url || opt.uploader.insertImageAsBase64URI)) {
                this.uploader.bind(this.editor);
            }
            // in initEditor - the editor could change
            if (!this.__elementToPlace.get(this.editor)) {
                this.__elementToPlace.set(this.editor, currentPlace);
            }
            this.e.fire('afterAddPlace', currentPlace);
        };
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(initResult, init);
    }
    addDisclaimer(elm) {
        this.workplace.appendChild(elm);
    }
    /**
     * Set current place object
     */
    setCurrentPlace(place) {
        if (this.currentPlace === place) {
            return;
        }
        if (!this.isEditorMode()) {
            this.setMode(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.MODE_WYSIWYG);
        }
        this.currentPlace = place;
        this.buildToolbar();
        if (this.isReady) {
            this.e.fire('changePlace', place);
        }
    }
    __initEditor(buffer) {
        const result = this.__createEditor();
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(result, () => {
            if (this.isInDestruct) {
                return;
            }
            // syncro
            if (this.element !== this.container) {
                const value = this.getElementValue();
                if (value !== this.getEditorValue()) {
                    this.setEditorValue(value);
                }
            }
            else {
                buffer != null && this.setEditorValue(buffer); // inline mode
            }
            let mode = this.o.defaultMode;
            if (this.o.saveModeInStorage) {
                const localMode = this.storage.get('jodit_default_mode');
                if (typeof localMode === 'string') {
                    mode = parseInt(localMode, 10);
                }
            }
            this.setMode(mode);
            if (this.o.readonly) {
                this.__wasReadOnly = false;
                this.setReadOnly(true);
            }
            if (this.o.disabled) {
                this.setDisabled(true);
            }
            // if enter plugin isn't installed
            try {
                this.ed.execCommand('defaultParagraphSeparator', false, this.o.enter.toLowerCase());
            }
            catch (_a) { }
        });
    }
    /**
     * Create main DIV element and replace source textarea
     */
    __createEditor() {
        const defaultEditorArea = this.editor;
        const stayDefault = this.e.fire('createEditor', this);
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.callPromise)(stayDefault, () => {
            if (this.isInDestruct) {
                return;
            }
            if (stayDefault === false || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isPromise)(stayDefault)) {
                jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(defaultEditorArea);
            }
            addClassNames(this.o.editorClassName, this.editor);
            if (this.o.style) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.editor, this.o.style);
            }
            this.e
                .on('synchro', () => {
                this.setEditorValue();
            })
                .on('focus', () => {
                this.editorIsActive = true;
            })
                .on('blur', () => (this.editorIsActive = false));
            this.__prepareWYSIWYGEditor();
            if (this.o.triggerChangeEvent) {
                this.e.on('change', this.async.debounce(() => {
                    this.e && this.e.fire(this.element, 'change');
                }, this.defaultTimeout));
            }
        });
    }
    /**
     * Attach some native event listeners
     */
    __prepareWYSIWYGEditor() {
        const { editor } = this;
        // direction
        if (this.o.direction) {
            const direction = this.o.direction.toLowerCase() === 'rtl' ? 'rtl' : 'ltr';
            this.editor.style.direction = direction;
            this.editor.setAttribute('dir', direction);
            this.container.style.direction = direction;
            this.container.setAttribute('dir', direction);
            this.toolbar.setDirection(direction);
        }
        // proxy events
        this.e
            .on(editor, 'mousedown touchstart focus', () => {
            const place = this.__elementToPlace.get(editor);
            if (place) {
                this.setCurrentPlace(place);
            }
        })
            .on(editor, 'compositionend', this.synchronizeValues)
            .on(editor, 'selectionchange selectionstart keydown keyup input keypress dblclick mousedown mouseup ' +
            'click copy cut dragstart drop dragover paste resize touchstart touchend focus blur', (event) => {
            if (this.o.readonly || this.__isSilentChange) {
                return;
            }
            const w = this.ew;
            if (event instanceof w.KeyboardEvent &&
                event.isComposing) {
                return;
            }
            if (this.e && this.e.fire) {
                if (this.e.fire(event.type, event) === false) {
                    return false;
                }
                this.synchronizeValues();
            }
        });
    }
    fetch(url, options) {
        const ajax = new jodit_core_request__WEBPACK_IMPORTED_MODULE_4__/* .Ajax */ .d(Object.assign({ url }, options), this.o.defaultAjaxOptions);
        const destroy = () => {
            this.e.off('beforeDestruct', destroy);
            this.progressbar.progress(100).hide();
            ajax.destruct();
        };
        this.e.one('beforeDestruct', destroy);
        this.progressbar.show().progress(30);
        const promise = ajax.send();
        promise.finally(destroy).catch(() => null);
        return promise;
    }
    /**
     * Jodit's Destructor. Remove editor, and return source input
     */
    destruct() {
        var _a, _b;
        if (this.isInDestruct) {
            return;
        }
        this.setStatus(jodit_modules__WEBPACK_IMPORTED_MODULE_7__.STATUSES.beforeDestruct);
        this.__elementToPlace.clear();
        (_a = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cached)(this, 'storage')) === null || _a === void 0 ? void 0 : _a.clear();
        (_b = (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cached)(this, 'buffer')) === null || _b === void 0 ? void 0 : _b.clear();
        this.commands.clear();
        this.__selectionLocked = null;
        this.e.off(this.ow, 'resize');
        this.e.off(this.ow);
        this.e.off(this.od);
        this.e.off(this.od.body);
        const tmpValue = this.editor ? this.getEditorValue() : '';
        this.places.forEach(({ container, workplace, statusbar, element, iframe, editor, history }) => {
            if (!element) {
                return;
            }
            if (element !== container) {
                if (element.hasAttribute(__defaultStyleDisplayKey)) {
                    const display = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(element, __defaultStyleDisplayKey);
                    if (display) {
                        element.style.display = display;
                        element.removeAttribute(__defaultStyleDisplayKey);
                    }
                }
                else {
                    element.style.display = '';
                }
            }
            else {
                if (element.hasAttribute(__defaultClassesKey)) {
                    element.className =
                        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(element, __defaultClassesKey) || '';
                    element.removeAttribute(__defaultClassesKey);
                }
            }
            if (element.hasAttribute('style') && !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(element, 'style')) {
                element.removeAttribute('style');
            }
            statusbar.destruct();
            this.e.off(container);
            this.e.off(element);
            this.e.off(editor);
            jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(workplace);
            jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(editor);
            if (container !== element) {
                jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(container);
            }
            Object.defineProperty(element, 'component', {
                enumerable: false,
                configurable: true,
                value: null
            });
            jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Dom.safeRemove(iframe);
            // inline mode
            if (container === element) {
                element.innerHTML = tmpValue;
            }
            history.destruct();
        });
        this.places.length = 0;
        this.currentPlace = {};
        delete jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .instances */ .VF[this.id];
        super.destruct();
    }
};
Jodit.fatMode = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.FAT_MODE;
Jodit.plugins = jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg;
Jodit.modules = jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .modules */ .av;
Jodit.ns = jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .modules */ .av;
Jodit.decorators = {};
Jodit.constants = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__;
Jodit.instances = jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .instances */ .VF;
Jodit.lang = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.lang;
Jodit.core = {
    Plugin: jodit_modules__WEBPACK_IMPORTED_MODULE_7__.Plugin
};
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
], Jodit.prototype, "createInside", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
], Jodit.prototype, "message", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
], Jodit.prototype, "s", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
], Jodit.prototype, "uploader", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.cache
], Jodit.prototype, "filebrowser", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.throttle)()
], Jodit.prototype, "synchronizeValues", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':internalChange')
], Jodit.prototype, "updateElementValue", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], Jodit.prototype, "__prepareWYSIWYGEditor", null);
Jodit = Jodit_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.derive)(jodit_core_traits_dlgs__WEBPACK_IMPORTED_MODULE_5__/* .Dlgs */ .z)
], Jodit);

function addClassNames(className, elm) {
    if (className) {
        className.split(/\s+/).forEach(cn => elm.classList.add(cn));
    }
}


/***/ }),

/***/ 46602:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Qe: function() { return /* binding */ cursorInTheEdgeOfString; },
/* harmony export */   W8: function() { return /* reexport safe */ _move_node_inside_start__WEBPACK_IMPORTED_MODULE_2__.W; },
/* harmony export */   dY: function() { return /* binding */ findCorrectCurrentNode; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var _move_node_inside_start__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5298);
/* harmony import */ var _move_the_node_along_the_edge_outward__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83541);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module selection
 */




/**
 * Check if the cursor is at the edge of the string
 * @private
 */
function cursorInTheEdgeOfString(container, offset, start, end) {
    var _a;
    const text = ((_a = container.nodeValue) === null || _a === void 0 ? void 0 : _a.length) ? container.nodeValue : '';
    if (end && text.replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_END)(), '').length > offset) {
        return true;
    }
    const inv = (0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_START)().exec(text);
    return start && ((inv && inv[0].length < offset) || (!inv && offset > 0));
}
function findCorrectCurrentNode(node, range, rightMode, isCollapsed, checkChild, child) {
    node = range.startContainer.childNodes[range.startOffset];
    if (!node) {
        node = range.startContainer.childNodes[range.startOffset - 1];
        rightMode = true;
    }
    if (node && isCollapsed && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(node)) {
        // test Current method - Cursor in the left of some SPAN
        if (!rightMode && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(node.previousSibling)) {
            node = node.previousSibling;
        }
        else if (checkChild) {
            let current = child(node);
            while (current) {
                if (current && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(current)) {
                    node = current;
                    break;
                }
                current = child(current);
            }
        }
    }
    if (node && !isCollapsed && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(node)) {
        let leftChild = node, rightChild = node;
        do {
            leftChild = leftChild.firstChild;
            rightChild = rightChild.lastChild;
        } while (leftChild && rightChild && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(leftChild));
        if (leftChild === rightChild && leftChild && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isText(leftChild)) {
            node = leftChild;
        }
    }
    return { node, rightMode };
}


/***/ }),

/***/ 46681:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   _: function() { return /* binding */ UIImagePositionTab; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71151);
/* harmony import */ var jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(66927);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29780);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(931);
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9645);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










/** @private */
let UIImagePositionTab = class UIImagePositionTab extends jodit_core_ui_element__WEBPACK_IMPORTED_MODULE_4__/* .UIElement */ .D {
    className() {
        return 'UIImagePositionTab';
    }
    constructor(jodit, state, handlers) {
        super(jodit, {
            availableClasses: jodit.o.image.availableClasses
        });
        this.state = state;
        this.handlers = handlers;
    }
    render({ availableClasses }) {
        return `<div class="jodit-form__group &__editMargins">
			<label>~Margins~</label>
			<div class="jodit-grid jodit_vertical_middle">
				<input class="jodit_col-lg-1-5 jodit-input &__marginTop" type="text" placeholder="~top~"/>
				<a style="text-align: center;" class="jodit-properties__lock jodit_col-lg-1-5 &__lockMargin">*lock*</a>
				<input disabled="disabled" class="jodit_col-lg-1-5 jodit-input &__marginRight" type="text" placeholder="~right~"/>
				<input disabled="disabled" class="jodit_col-lg-1-5 jodit-input &__marginBottom" type="text" placeholder="~bottom~"/>
				<input disabled="disabled" class="jodit_col-lg-1-5 jodit-input &__marginLeft" type="text" placeholder="~left~"/>
			</div>
		</div>
		<div class="jodit-form__group &__editAlign">
			<label>~Align~</label>
			<select class="jodit-select &__align">
				<option value="">~--Not Set--~</option>
				<option value="left">~Left~</option>
				<option value="center">~Center~</option>
				<option value="right">~Right~</option>
			</select>
		</div>
		<div class="jodit-form__group &__editStyle">
			<label>~Styles~</label>
			<input type="text" class="jodit-input &__style"/>
		</div>
		<div class="jodit-form__group &__editClass">
			<label>~Classes~</label>
			${(() => {
            const classInput = [];
            if (availableClasses && availableClasses.length > 0) {
                classInput.push('<select class="jodit-input jodit-select &__classes">');
                availableClasses.forEach(item => {
                    if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_7__/* .isString */ .K)(item)) {
                        classInput.push(`<option value="${item}">${item}</option>`);
                    }
                    else {
                        classInput.push(`<option value="${item[0]}">${item[1]}</option>`);
                    }
                });
                classInput.push('</select>');
            }
            else {
                classInput.push('<input type="text" class="jodit-input &__classes"/>');
            }
            return classInput.join('');
        })()}
		</div>
		<div class="jodit-form__group &__editId">
			<label>Id</label>
			<input type="text" class="jodit-input &__id"/>
		</div>
		<div
			class="jodit-form__group &__editBorderRadius"
		>
			<label>~Border radius~</label>
			<input type="number" class="jodit-input &__borderRadius"/>
		</div>`;
    }
    onStateAlignChange() {
        const align = this.getElm('align');
        align.value = this.state.values.align;
    }
    onChangeAlign() {
        const align = this.getElm('align');
        this.state.values.align = align.value;
    }
    onStateValuesBorderRadiusChange() {
        const borderRadius = this.getElm('borderRadius');
        borderRadius.value = this.state.values.borderRadius.toString();
    }
    onChangeBorderRadius() {
        const borderRadius = this.getElm('borderRadius');
        this.state.values.borderRadius = parseFloat(borderRadius.value);
    }
    onStateValuesIdChange() {
        const id = this.getElm('id');
        id.value = this.state.values.id;
    }
    onChangeId() {
        const id = this.getElm('id');
        this.state.values.id = id.value;
    }
    onStateValuesStyleChange() {
        const style = this.getElm('style');
        style.value = this.state.values.style;
    }
    onChangeStyle() {
        const style = this.getElm('style');
        this.state.values.style = style.value;
    }
    onStateValuesClassesChange() {
        const classes = this.getElm('classes');
        classes.value = this.state.values.classes;
    }
    onChangClasses() {
        const classes = this.getElm('classes');
        this.state.values.classes = classes.value;
    }
    onLockMarginClick(e) {
        this.state.marginIsLocked = !this.state.marginIsLocked;
        e.preventDefault();
    }
    onChangeMarginIsLocked() {
        const marginBottom = this.getElm('marginBottom');
        const marginRight = this.getElm('marginRight');
        const marginLeft = this.getElm('marginLeft');
        const lockMargin = this.getElm('lockMargin');
        [marginRight, marginBottom, marginLeft].forEach(elm => {
            (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_3__/* .attr */ .C)(elm, 'disabled', this.state.marginIsLocked || null);
        });
        lockMargin.innerHTML = jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_5__/* .Icon */ .I.get(this.state.marginIsLocked ? 'lock' : 'unlock');
        if (this.state.marginIsLocked) {
            const marginTop = this.state.values.marginTop;
            this.state.values.marginRight = marginTop;
            this.state.values.marginBottom = marginTop;
            this.state.values.marginLeft = marginTop;
        }
    }
    onStateValuesMarginChange() {
        const marginTop = this.getElm('marginTop');
        const marginRight = this.getElm('marginRight');
        const marginBottom = this.getElm('marginBottom');
        const marginLeft = this.getElm('marginLeft');
        marginTop.value = this.state.values.marginTop.toString();
        marginRight.value = this.state.values.marginRight.toString();
        marginBottom.value = this.state.values.marginBottom.toString();
        marginLeft.value = this.state.values.marginLeft.toString();
    }
    onChangeMargin() {
        const marginTop = this.getElm('marginTop');
        const marginRight = this.getElm('marginRight');
        const marginBottom = this.getElm('marginBottom');
        const marginLeft = this.getElm('marginLeft');
        this.state.values.marginTop = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_6__/* .normalSizeFromString */ .G)(marginTop.value);
        if (this.state.marginIsLocked) {
            this.state.values.marginRight = this.state.values.marginTop;
            this.state.values.marginBottom = this.state.values.marginTop;
            this.state.values.marginLeft = this.state.values.marginTop;
        }
        else {
            this.state.values.marginRight = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_6__/* .normalSizeFromString */ .G)(marginRight.value);
            this.state.values.marginBottom = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_6__/* .normalSizeFromString */ .G)(marginBottom.value);
            this.state.values.marginLeft = (0,_utils_utils__WEBPACK_IMPORTED_MODULE_6__/* .normalSizeFromString */ .G)(marginLeft.value);
        }
    }
    hideFieldByOptions() {
        const opt = this.j.o.image;
        [
            ['editMargins', 'editMargins'],
            ['editAlign', 'editAlign'],
            ['editStyle', 'editStyle'],
            ['editClass', 'editClass'],
            ['editId', 'editId'],
            ['editBorderRadius', 'editBorderRadius']
        ].forEach(([optKey, elmKey]) => {
            const elm = this.getElm(elmKey);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.css)(elm, 'display', opt[optKey] ? null : 'none');
        });
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.align')
], UIImagePositionTab.prototype, "onStateAlignChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('align:change')
], UIImagePositionTab.prototype, "onChangeAlign", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.borderRadius')
], UIImagePositionTab.prototype, "onStateValuesBorderRadiusChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('borderRadius:change')
], UIImagePositionTab.prototype, "onChangeBorderRadius", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.id')
], UIImagePositionTab.prototype, "onStateValuesIdChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('id:change')
], UIImagePositionTab.prototype, "onChangeId", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.style')
], UIImagePositionTab.prototype, "onStateValuesStyleChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('style:change')
], UIImagePositionTab.prototype, "onChangeStyle", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.values.classes')
], UIImagePositionTab.prototype, "onStateValuesClassesChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('classes:change')
], UIImagePositionTab.prototype, "onChangClasses", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('lockMargin:click')
], UIImagePositionTab.prototype, "onLockMarginClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)('state.marginIsLocked')
], UIImagePositionTab.prototype, "onChangeMarginIsLocked", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready'),
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)([
        'state.values.marginTop',
        'state.values.marginRight',
        'state.values.marginBottom',
        'state.values.marginLeft'
    ])
], UIImagePositionTab.prototype, "onStateValuesMarginChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_watch_watch__WEBPACK_IMPORTED_MODULE_1__/* .watch */ .w)([
        'marginTop:change',
        'marginRight:change',
        'marginBottom:change',
        'marginLeft:change'
    ])
], UIImagePositionTab.prototype, "onChangeMargin", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators_hook_hook__WEBPACK_IMPORTED_MODULE_0__/* .hook */ .A)('ready')
], UIImagePositionTab.prototype, "hideFieldByOptions", null);
UIImagePositionTab = (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_9__/* .component */ .s
], UIImagePositionTab);



/***/ }),

/***/ 46939:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export selectCells */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(71005);
/* harmony import */ var jodit_modules_table_table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11648);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(29581);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









const key = 'table_processor_observer';
const MOUSE_MOVE_LABEL = 'onMoveTableSelectCell';
class selectCells extends jodit_core_plugin__WEBPACK_IMPORTED_MODULE_5__/* .Plugin */ .k {
    constructor() {
        super(...arguments);
        /**
         * First selected cell
         */
        this.__selectedCell = null;
        /**
         * User is selecting cells now
         */
        this.__isSelectionMode = false;
    }
    /**
     * Shortcut for Jodit.modules.Table
     */
    get __tableModule() {
        return this.j.getInstance(jodit_modules_table_table__WEBPACK_IMPORTED_MODULE_6__/* .Table */ .X, this.j.o);
    }
    afterInit(jodit) {
        if (!jodit.o.tableAllowCellSelection) {
            return;
        }
        jodit.e
            .on('keydown.select-cells', (event) => {
            if (event.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.KEY_TAB) {
                this.unselectCells();
            }
        })
            .on('beforeCommand.select-cells', this.onExecCommand)
            .on('afterCommand.select-cells', this.onAfterCommand)
            // see `plugins/select.ts`
            .on([
            'clickEditor',
            'mousedownTd',
            'mousedownTh',
            'touchstartTd',
            'touchstartTh'
        ]
            .map(e => e + '.select-cells')
            .join(' '), this.onStartSelection)
            // For `clickEditor` correct working. Because `mousedown` on first cell
            // and mouseup on another cell call `click` only for `TR` element.
            .on('clickTr clickTbody', () => {
            var _a;
            const cellsCount = this.__tableModule.getAllSelectedCells().length;
            if (cellsCount) {
                if (cellsCount > 1) {
                    (_a = this.j.s.sel) === null || _a === void 0 ? void 0 : _a.removeAllRanges();
                }
                return false;
            }
        });
    }
    /**
     * Mouse click inside the table
     */
    onStartSelection(cell) {
        if (this.j.o.readonly) {
            return;
        }
        this.unselectCells();
        if (cell === this.j.editor) {
            return;
        }
        const table = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(cell, 'table', this.j.editor);
        if (!cell || !table) {
            return;
        }
        if (!cell.firstChild) {
            cell.appendChild(this.j.createInside.element('br'));
        }
        this.__isSelectionMode = true;
        this.__selectedCell = cell;
        this.__tableModule.addSelection(cell);
        this.j.e
            .on(table, 'mousemove.select-cells touchmove.select-cells', 
        // Don't use decorator because need clear label on mouseup
        this.j.async.throttle(this.__onMove.bind(this, table), {
            label: MOUSE_MOVE_LABEL,
            timeout: this.j.defaultTimeout / 2
        }))
            .on(table, 'mouseup.select-cells touchend.select-cells', this.__onStopSelection.bind(this, table));
        return false;
    }
    onOutsideClick() {
        this.__selectedCell = null;
        this.__onRemoveSelection();
    }
    onChange() {
        if (!this.j.isLocked && !this.__isSelectionMode) {
            this.__onRemoveSelection();
        }
    }
    /**
     * Mouse move inside the table
     */
    __onMove(table, e) {
        var _a;
        if (this.j.o.readonly && !this.j.isLocked) {
            return;
        }
        if (this.j.isLockedNotBy(key)) {
            return;
        }
        const node = this.j.ed.elementFromPoint(e.clientX, e.clientY);
        if (!node) {
            return;
        }
        const cell = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(node, ['td', 'th'], table);
        if (!cell || !this.__selectedCell) {
            return;
        }
        if (cell !== this.__selectedCell) {
            this.j.lock(key);
        }
        this.unselectCells();
        const bound = this.__tableModule.getSelectedBound(table, [
            cell,
            this.__selectedCell
        ]), box = this.__tableModule.formalMatrix(table);
        for (let i = bound[0][0]; i <= bound[1][0]; i += 1) {
            for (let j = bound[0][1]; j <= bound[1][1]; j += 1) {
                this.__tableModule.addSelection(box[i][j]);
            }
        }
        const cellsCount = this.__tableModule.getAllSelectedCells().length;
        if (cellsCount > 1) {
            (_a = this.j.s.sel) === null || _a === void 0 ? void 0 : _a.removeAllRanges();
        }
        this.j.e.fire('hidePopup');
        e.stopPropagation();
        // Hack for FireFox for force redraw selection
        (() => {
            const n = this.j.createInside.fromHTML('<div style="color:rgba(0,0,0,0.01);width:0;height:0">&nbsp;</div>');
            cell.appendChild(n);
            this.j.async.setTimeout(() => {
                var _a;
                (_a = n.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(n);
            }, this.j.defaultTimeout / 5);
        })();
    }
    /**
     * On click in outside - remove selection
     */
    __onRemoveSelection(e) {
        var _a;
        if (!((_a = e === null || e === void 0 ? void 0 : e.buffer) === null || _a === void 0 ? void 0 : _a.actionTrigger) &&
            !this.__selectedCell &&
            this.__tableModule.getAllSelectedCells().length) {
            this.j.unlock();
            this.unselectCells();
            this.j.e.fire('hidePopup', 'cells');
            return;
        }
        this.__isSelectionMode = false;
        this.__selectedCell = null;
    }
    /**
     * Stop a selection process
     */
    __onStopSelection(table, e) {
        if (!this.__selectedCell) {
            return;
        }
        this.__isSelectionMode = false;
        this.j.unlock();
        const node = this.j.ed.elementFromPoint(e.clientX, e.clientY);
        if (!node) {
            return;
        }
        const cell = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(node, ['td', 'th'], table);
        if (!cell) {
            return;
        }
        const ownTable = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(cell, 'table', table);
        if (ownTable && ownTable !== table) {
            return; // Nested tables
        }
        const bound = this.__tableModule.getSelectedBound(table, [
            cell,
            this.__selectedCell
        ]), box = this.__tableModule.formalMatrix(table);
        const max = box[bound[1][0]][bound[1][1]], min = box[bound[0][0]][bound[0][1]];
        this.j.e.fire('showPopup', table, () => {
            const minOffset = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.position)(min, this.j), maxOffset = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.position)(max, this.j);
            return {
                left: minOffset.left,
                top: minOffset.top,
                width: maxOffset.left - minOffset.left + maxOffset.width,
                height: maxOffset.top - minOffset.top + maxOffset.height
            };
        }, 'cells');
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.$$)('table', this.j.editor).forEach(table => {
            this.j.e.off(table, 'mousemove.select-cells touchmove.select-cells mouseup.select-cells touchend.select-cells');
        });
        this.j.async.clearTimeout(MOUSE_MOVE_LABEL);
    }
    /**
     * Remove selection for all cells
     */
    unselectCells(currentCell) {
        const module = this.__tableModule;
        const cells = module.getAllSelectedCells();
        if (cells.length) {
            cells.forEach(cell => {
                if (!currentCell || currentCell !== cell) {
                    module.removeSelection(cell);
                }
            });
        }
    }
    /**
     * Execute custom commands for table
     */
    onExecCommand(command) {
        if (/table(splitv|splitg|merge|empty|bin|binrow|bincolumn|addcolumn|addrow)/.test(command)) {
            command = command.replace('table', '');
            const cells = this.__tableModule.getAllSelectedCells();
            if (cells.length) {
                const [cell] = cells;
                if (!cell) {
                    return;
                }
                const table = jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.closest(cell, 'table', this.j.editor);
                if (!table) {
                    return;
                }
                switch (command) {
                    case 'splitv':
                        this.__tableModule.splitVertical(table);
                        break;
                    case 'splitg':
                        this.__tableModule.splitHorizontal(table);
                        break;
                    case 'merge':
                        this.__tableModule.mergeSelected(table);
                        break;
                    case 'empty':
                        cells.forEach(td => jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.detach(td));
                        break;
                    case 'bin':
                        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(table);
                        break;
                    case 'binrow':
                        new Set(cells.map(td => td.parentNode)).forEach(row => {
                            this.__tableModule.removeRow(table, row.rowIndex);
                        });
                        break;
                    case 'bincolumn':
                        {
                            const columnsSet = new Set(), columns = cells.reduce((acc, td) => {
                                if (!columnsSet.has(td.cellIndex)) {
                                    acc.push(td);
                                    columnsSet.add(td.cellIndex);
                                }
                                return acc;
                            }, []);
                            columns.forEach(td => {
                                this.__tableModule.removeColumn(table, td.cellIndex);
                            });
                        }
                        break;
                    case 'addcolumnafter':
                    case 'addcolumnbefore':
                        this.__tableModule.appendColumn(table, cell, command === 'addcolumnafter');
                        break;
                    case 'addrowafter':
                    case 'addrowbefore':
                        this.__tableModule.appendRow(table, cell.parentNode, command === 'addrowafter');
                        break;
                }
            }
            return false;
        }
    }
    /**
     * Add some align after native command
     */
    onAfterCommand(command) {
        if (/^justify/.test(command)) {
            this.__tableModule
                .getAllSelectedCells()
                .forEach(elm => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_4__.alignElement)(command, elm));
        }
    }
    /** @override */
    beforeDestruct(jodit) {
        this.__onRemoveSelection();
        jodit.e.off('.select-cells');
    }
}
selectCells.requires = ['select'];
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], selectCells.prototype, "onStartSelection", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':outsideClick')
], selectCells.prototype, "onOutsideClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.watch)(':change')
], selectCells.prototype, "onChange", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], selectCells.prototype, "__onRemoveSelection", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], selectCells.prototype, "__onStopSelection", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], selectCells.prototype, "onExecCommand", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], selectCells.prototype, "onAfterCommand", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_3__/* .pluginSystem */ .fg.add('selectCells', selectCells);


/***/ }),

/***/ 47165:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $6: function() { return /* reexport safe */ _select_select__WEBPACK_IMPORTED_MODULE_4__.$; },
/* harmony export */   F0: function() { return /* reexport safe */ _area_area__WEBPACK_IMPORTED_MODULE_0__.F; },
/* harmony export */   cY: function() { return /* reexport safe */ _checkbox_checkbox__WEBPACK_IMPORTED_MODULE_1__.c; },
/* harmony export */   nE: function() { return /* reexport safe */ _file_file__WEBPACK_IMPORTED_MODULE_2__.n; },
/* harmony export */   tS: function() { return /* reexport safe */ _input_input__WEBPACK_IMPORTED_MODULE_3__.t; }
/* harmony export */ });
/* harmony import */ var _area_area__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5454);
/* harmony import */ var _checkbox_checkbox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3006);
/* harmony import */ var _file_file__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47964);
/* harmony import */ var _input_input__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(69198);
/* harmony import */ var _select_select__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1540);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module ui/form
 */







/***/ }),

/***/ 47238:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: '符号'
};


/***/ }),

/***/ 47317:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   b: function() { return /* binding */ checkUnsplittableBox; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * Inside quote/tables cell, etc. you can't split so just add br
 * @private
 */
function checkUnsplittableBox(fake, jodit, currentBox) {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.canSplitBlock(currentBox)) {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.before(fake, jodit.createInside.element('br'));
        return false;
    }
    return true;
}


/***/ }),

/***/ 47321:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'Símbolo'
};


/***/ }),

/***/ 47791:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export link */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71005);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(64953);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







/**
 * Process link. Insert, dblclick or remove format
 */
class link extends jodit_core_plugin__WEBPACK_IMPORTED_MODULE_4__/* .Plugin */ .k {
    constructor() {
        super(...arguments);
        /** @override */
        this.buttons = [
            {
                name: 'link',
                group: 'insert'
            }
        ];
    }
    /** @override */
    afterInit(jodit) {
        if (jodit.o.link.followOnDblClick) {
            jodit.e.on('dblclick.link', this.__onDblClickOnLink);
        }
        jodit.e.on(jodit.editor, 'click.link', this.__onClickReadOnlyLink);
        if (jodit.o.link.processPastedLink) {
            jodit.e.on('processPaste.link', this.onProcessPasteLink);
        }
        jodit.e.on('generateLinkForm.link', this.__generateForm);
        jodit.registerCommand('openLinkDialog', {
            exec: () => {
                const dialog = jodit.dlg({
                    resizable: false
                });
                const htmlForm = this.__generateForm(jodit.s.current(), () => {
                    dialog.close();
                });
                htmlForm.container.classList.add('jodit-dialog_alert');
                dialog.setContent(htmlForm);
                dialog.open();
                jodit.async.requestIdleCallback(() => {
                    const { url_input } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(htmlForm.container);
                    url_input === null || url_input === void 0 ? void 0 : url_input.focus();
                });
            },
            hotkeys: jodit.o.link.hotkeys
        });
    }
    __onDblClickOnLink(e) {
        if (!jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(e.target, 'a')) {
            return;
        }
        const href = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(e.target, 'href');
        if (href) {
            location.href = href;
            e.preventDefault();
        }
    }
    onProcessPasteLink(ignore, html) {
        var _a, _b, _c, _d;
        const { jodit } = this;
        if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isURL)(html) || !jodit.o.link.processPastedLink) {
            return;
        }
        jodit.e.stopPropagation('processPaste');
        if (jodit.o.link.processVideoLink) {
            const embed = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)((_b = (_a = jodit.o.video) === null || _a === void 0 ? void 0 : _a.parseUrlToVideoEmbed) !== null && _b !== void 0 ? _b : jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.convertMediaUrlToVideoEmbed, html, {
                width: (_c = jodit.o.video) === null || _c === void 0 ? void 0 : _c.defaultWidth,
                height: (_d = jodit.o.video) === null || _d === void 0 ? void 0 : _d.defaultHeight
            });
            if (embed !== html) {
                return jodit.createInside.fromHTML(embed);
            }
        }
        if (jodit.s.isCollapsed()) {
            const a = jodit.createInside.element('a');
            a.setAttribute('href', html);
            a.textContent = html;
            jodit.e.fire('applyLink', jodit, a, null);
            return a;
        }
        jodit.s.commitStyle({
            element: 'a',
            attributes: {
                href: html
            }
        });
        return true;
    }
    __generateForm(current, close) {
        const { jodit } = this;
        const i18n = jodit.i18n.bind(jodit), { openInNewTabCheckbox, noFollowCheckbox, formTemplate, formClassName, modeClassName } = jodit.o.link;
        const html = formTemplate(jodit);
        const form = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.isString)(html)
            ? jodit.c.fromHTML(html, {
                target_checkbox_box: openInNewTabCheckbox,
                nofollow_checkbox_box: noFollowCheckbox
            })
            : html;
        const htmlForm = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(form) ? form : form.container;
        const elements = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(htmlForm);
        const { insert, unlink, content_input_box } = elements;
        const { target_checkbox, nofollow_checkbox, url_input } = elements;
        const currentElement = current;
        const isImageContent = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isImage(currentElement);
        let { content_input } = elements;
        const { className_input } = elements, { className_select } = elements;
        if (!content_input) {
            content_input = jodit.c.element('input', {
                type: 'hidden',
                ref: 'content_input'
            });
        }
        if (formClassName) {
            htmlForm.classList.add(formClassName);
        }
        if (isImageContent) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.hide(content_input_box);
        }
        let link;
        const getSelectionText = () => link
            ? link.innerText
            : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.stripTags)(jodit.s.range.cloneContents(), jodit.ed);
        if (current && jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(current, 'a', jodit.editor)) {
            link = jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.closest(current, 'a', jodit.editor);
        }
        else {
            link = false;
        }
        if (!isImageContent && current) {
            content_input.value = getSelectionText();
        }
        if (link) {
            url_input.value = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(link, 'href') || '';
            if (modeClassName) {
                readClassnames(modeClassName, className_input, link, className_select);
            }
            if (openInNewTabCheckbox && target_checkbox) {
                target_checkbox.checked = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(link, 'target') === '_blank';
            }
            if (noFollowCheckbox && nofollow_checkbox) {
                nofollow_checkbox.checked = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(link, 'rel') === 'nofollow';
            }
            insert.textContent = i18n('Update');
        }
        else {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.hide(unlink);
        }
        jodit.editor.normalize();
        const snapshot = jodit.history.snapshot.make();
        if (unlink) {
            jodit.e.on(unlink, 'click', (e) => {
                jodit.s.restore();
                jodit.history.snapshot.restore(snapshot);
                if (link) {
                    jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.unwrap(link);
                }
                jodit.synchronizeValues();
                close();
                e.preventDefault();
            });
        }
        const onSubmit = () => {
            if (!url_input.value.trim().length) {
                url_input.focus();
                url_input.classList.add('jodit_error');
                return false;
            }
            let links;
            jodit.s.restore();
            jodit.s.removeMarkers();
            jodit.editor.normalize();
            jodit.history.snapshot.restore(snapshot);
            const textWasChanged = getSelectionText() !== content_input.value.trim();
            const ci = jodit.createInside;
            if (!link || !jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isOrContains(jodit.editor, link)) {
                if (!jodit.s.isCollapsed()) {
                    const node = jodit.s.current();
                    if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(node, 'img')) {
                        links = [jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.wrap(node, 'a', ci)];
                    }
                    else {
                        links = jodit.s.wrapInTag('a');
                    }
                }
                else {
                    const a = ci.element('a');
                    jodit.s.insertNode(a, false, false);
                    links = [a];
                }
                links.forEach(link => jodit.s.select(link));
            }
            else {
                links = [link];
            }
            links.forEach(a => {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(a, 'href', url_input.value);
                writeClasses(modeClassName, className_input, className_select, a);
                if (!isImageContent) {
                    writeImage(a, content_input, textWasChanged, url_input);
                }
                if (openInNewTabCheckbox && target_checkbox) {
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(a, 'target', target_checkbox.checked ? '_blank' : null);
                }
                if (noFollowCheckbox && nofollow_checkbox) {
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(a, 'rel', nofollow_checkbox.checked ? 'nofollow' : null);
                }
                jodit.e.fire('applyLink', jodit, a, form);
            });
            jodit.synchronizeValues();
            close();
            return false;
        };
        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(form)) {
            jodit.e.on(form, 'submit', (event) => {
                event.preventDefault();
                event.stopImmediatePropagation();
                onSubmit();
                return false;
            });
        }
        else {
            form.onSubmit(onSubmit);
        }
        return form;
    }
    /** @override */
    beforeDestruct(jodit) {
        jodit.e
            .off('generateLinkForm.link', this.__generateForm)
            .off('dblclick.link', this.__onDblClickOnLink)
            .off(jodit.editor, 'click.link', this.__onClickReadOnlyLink)
            .off('processPaste.link', this.onProcessPasteLink);
    }
    __onClickReadOnlyLink(e) {
        const { jodit } = this;
        if (jodit.o.readonly &&
            jodit.o.link.preventReadOnlyNavigation &&
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isTag(e.target, 'a')) {
            e.preventDefault();
        }
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], link.prototype, "__onDblClickOnLink", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], link.prototype, "onProcessPasteLink", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], link.prototype, "__generateForm", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], link.prototype, "__onClickReadOnlyLink", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_2__/* .pluginSystem */ .fg.add('link', link);
function writeClasses(modeClassName, className_input, className_select, a) {
    var _a;
    if (modeClassName && (className_input !== null && className_input !== void 0 ? className_input : className_select)) {
        if (modeClassName === 'input') {
            if (className_input.value === '' && a.hasAttribute('class')) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(a, 'class', null);
            }
            if (className_input.value !== '') {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(a, 'class', className_input.value);
            }
        }
        else if (modeClassName === 'select') {
            if (a.hasAttribute('class')) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(a, 'class', null);
            }
            for (let i = 0; i < className_select.selectedOptions.length; i++) {
                const className = (_a = className_select.selectedOptions.item(i)) === null || _a === void 0 ? void 0 : _a.value;
                if (className) {
                    a.classList.add(className);
                }
            }
        }
    }
}
function readClassnames(modeClassName, className_input, link, className_select) {
    switch (modeClassName) {
        case 'input':
            if (className_input) {
                className_input.value = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(link, 'class') || '';
            }
            break;
        case 'select':
            if (className_select) {
                for (let i = 0; i < className_select.selectedOptions.length; i++) {
                    const option = className_select.options.item(i);
                    if (option) {
                        option.selected = false;
                    }
                }
                const classNames = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(link, 'class') || '';
                classNames.split(' ').forEach(className => {
                    if (className) {
                        for (let i = 0; i < className_select.options.length; i++) {
                            const option = className_select.options.item(i);
                            if ((option === null || option === void 0 ? void 0 : option.value) && option.value === className) {
                                option.selected = true;
                            }
                        }
                    }
                });
            }
            break;
    }
}
function writeImage(a, content_input, textWasChanged, url_input) {
    let newContent = a.textContent;
    if (content_input.value.trim().length) {
        if (textWasChanged) {
            newContent = content_input.value;
        }
    }
    else {
        newContent = url_input.value;
    }
    const content = a.textContent;
    if (newContent !== content) {
        a.textContent = newContent;
    }
}


/***/ }),

/***/ 47964:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   n: function() { return /* binding */ UIFileInput; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24767);
/* harmony import */ var jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92032);
/* harmony import */ var jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69198);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */





let UIFileInput = class UIFileInput extends jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t {
    /** @override */
    className() {
        return 'UIFileInput';
    }
    createContainer(options) {
        this.button = new jodit_core_ui_button_button_button__WEBPACK_IMPORTED_MODULE_0__/* .UIButton */ .lD(this.j, {
            tooltip: options.tooltip,
            icon: {
                name: 'plus'
            }
        });
        const { container } = this.button;
        if (!this.nativeInput) {
            this.nativeInput = this.createNativeInput(options);
        }
        const { nativeInput } = this;
        nativeInput.classList.add(this.getFullElName('input'));
        container.classList.add(this.componentName);
        container.appendChild(nativeInput);
        return container;
    }
    createNativeInput(options) {
        return this.j.create.fromHTML(`<input
			type="file"
			accept="${options.onlyImages ? 'image/*' : '*'}"
			tabindex="-1"
			dir="auto"
			multiple=""
		/>`);
    }
    constructor(jodit, options) {
        super(jodit, Object.assign({ type: 'file' }, options));
        this.state = Object.assign(Object.assign({}, jodit_core_ui_form_inputs_input_input__WEBPACK_IMPORTED_MODULE_1__/* .UIInput */ .t.defaultState), { type: 'file', onlyImages: true });
    }
};
UIFileInput = (0,tslib__WEBPACK_IMPORTED_MODULE_2__/* .__decorate */ .Cg)([
    jodit_core_decorators_component_component__WEBPACK_IMPORTED_MODULE_3__/* .component */ .s
], UIFileInput);



/***/ }),

/***/ 48007:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M512 1248v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm1280 512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h960q40 0 68 28t28 68zm-1280-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm1280 512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h960q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h960q40 0 68 28t28 68z\"/> </svg>"

/***/ }),

/***/ 48053:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   q: function() { return /* binding */ ToolbarSelect; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(25376);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98253);
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3258);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






let ToolbarSelect = class ToolbarSelect extends _button__WEBPACK_IMPORTED_MODULE_1__/* .ToolbarButton */ .I {
    className() {
        return 'ToolbarSelect';
    }
    update() {
        var _a, _b, _c;
        super.update();
        this.state.icon.name = '';
        const { list, data } = this.control;
        if (list) {
            let key = this.state.value ||
                (data && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .K)(data.currentValue)
                    ? data.currentValue
                    : undefined);
            if (!key) {
                const keys = Object.keys(list);
                key = keys[0];
            }
            const text = ((0,jodit_core_helpers_checker_is_plain_object__WEBPACK_IMPORTED_MODULE_3__/* .isPlainObject */ .Q)(list) ? list[key.toString()] || key : key).toString();
            this.state.text =
                (_c = (_b = (_a = this.control).textTemplate) === null || _b === void 0 ? void 0 : _b.call(_a, this.jodit, text)) !== null && _c !== void 0 ? _c : text;
        }
    }
};
ToolbarSelect = (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.component
], ToolbarSelect);



/***/ }),

/***/ 48647:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ wait; }
/* harmony export */ });
/* harmony import */ var jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64567);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(50156);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



function wait(condition) {
    return (target, propertyKey) => {
        const fn = target[propertyKey];
        if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .T)(fn)) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Handler must be a Function');
        }
        target.hookStatus(jodit_core_component_statuses__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.ready, (component) => {
            const { async } = component;
            const realMethod = component[propertyKey];
            let timeout = 0;
            Object.defineProperty(component, propertyKey, {
                configurable: true,
                value: function callProxy(...args) {
                    async.clearTimeout(timeout);
                    if (condition(component)) {
                        realMethod.apply(component, args);
                    }
                    else {
                        timeout = async.setTimeout(() => callProxy(...args), 10);
                    }
                }
            });
        });
    };
}


/***/ }),

/***/ 48791:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   m: function() { return /* binding */ nonenumerable; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/decorators/nonenumerable/README.md]]
 * @packageDocumentation
 * @module decorators/nonenumerable
 */
const nonenumerable = (target, propertyKey) => {
    const descriptor = Object.getOwnPropertyDescriptor(target, propertyKey) || {};
    if (descriptor.enumerable !== false) {
        Object.defineProperty(target, propertyKey, {
            enumerable: false,
            set(value) {
                Object.defineProperty(this, propertyKey, {
                    enumerable: false,
                    writable: true,
                    value
                });
            }
        });
    }
};


/***/ }),

/***/ 48840:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   O: function() { return /* reexport safe */ _on_tab_inside_li__WEBPACK_IMPORTED_MODULE_0__.O; }
/* harmony export */ });
/* harmony import */ var _on_tab_inside_li__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(86572);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/tab
 */



/***/ }),

/***/ 48842:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M789 559l-170 450q33 0 136.5 2t160.5 2q19 0 57-2-87-253-184-452zm-725 1105l2-79q23-7 56-12.5t57-10.5 49.5-14.5 44.5-29 31-50.5l237-616 280-724h128q8 14 11 21l205 480q33 78 106 257.5t114 274.5q15 34 58 144.5t72 168.5q20 45 35 57 19 15 88 29.5t84 20.5q6 38 6 57 0 4-.5 13t-.5 13q-63 0-190-8t-191-8q-76 0-215 7t-178 8q0-43 4-78l131-28q1 0 12.5-2.5t15.5-3.5 14.5-4.5 15-6.5 11-8 9-11 2.5-14q0-16-31-96.5t-72-177.5-42-100l-450-2q-26 58-76.5 195.5t-50.5 162.5q0 22 14 37.5t43.5 24.5 48.5 13.5 57 8.5 41 4q1 19 1 58 0 9-2 27-58 0-174.5-10t-174.5-10q-8 0-26.5 4t-21.5 4q-80 14-188 14z\"/> </svg>"

/***/ }),

/***/ 49289:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export bold */
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36115);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(73124);
/* harmony import */ var _icons_bold_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(52450);
/* harmony import */ var _icons_bold_svg__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_icons_bold_svg__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _icons_italic_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(41111);
/* harmony import */ var _icons_italic_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_icons_italic_svg__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _icons_strikethrough_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(49972);
/* harmony import */ var _icons_strikethrough_svg__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_icons_strikethrough_svg__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _icons_subscript_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(45062);
/* harmony import */ var _icons_subscript_svg__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_icons_subscript_svg__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _icons_superscript_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(18605);
/* harmony import */ var _icons_superscript_svg__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_icons_superscript_svg__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _icons_underline_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(83389);
/* harmony import */ var _icons_underline_svg__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_icons_underline_svg__WEBPACK_IMPORTED_MODULE_10__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */












/**
 * Adds `bold`,` strikethrough`, `underline` and` italic` buttons to Jodit
 */
function bold(editor) {
    const callBack = (command) => {
        const control = jodit_config__WEBPACK_IMPORTED_MODULE_3__/* .Config */ .T.defaultOptions.controls[command], cssOptions = Object.assign({}, control.css);
        let cssRules;
        Object.keys(cssOptions).forEach((key) => {
            if (!cssRules) {
                cssRules = {};
            }
            cssRules[key] = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_1__.isArray)(cssOptions[key])
                ? cssOptions[key][0]
                : cssOptions[key];
        });
        editor.s.commitStyle({
            element: control.tags ? control.tags[0] : undefined
        });
        editor.synchronizeValues();
        return false;
    };
    ['bold', 'italic', 'underline', 'strikethrough'].forEach(name => {
        editor.registerButton({
            name,
            group: 'font-style'
        });
    });
    ['superscript', 'subscript'].forEach(name => {
        editor.registerButton({
            name,
            group: 'script'
        });
    });
    editor
        .registerCommand('bold', {
        exec: callBack,
        hotkeys: ['ctrl+b', 'cmd+b']
    })
        .registerCommand('italic', {
        exec: callBack,
        hotkeys: ['ctrl+i', 'cmd+i']
    })
        .registerCommand('underline', {
        exec: callBack,
        hotkeys: ['ctrl+u', 'cmd+u']
    })
        .registerCommand('strikethrough', {
        exec: callBack
    })
        .registerCommand('subscript', {
        exec: callBack
    })
        .registerCommand('superscript', {
        exec: callBack
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_0__/* .pluginSystem */ .fg.add('bold', bold);
jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .I.set('bold', (_icons_bold_svg__WEBPACK_IMPORTED_MODULE_5___default()))
    .set('italic', (_icons_italic_svg__WEBPACK_IMPORTED_MODULE_6___default()))
    .set('strikethrough', (_icons_strikethrough_svg__WEBPACK_IMPORTED_MODULE_7___default()))
    .set('subscript', (_icons_subscript_svg__WEBPACK_IMPORTED_MODULE_8___default()))
    .set('superscript', (_icons_superscript_svg__WEBPACK_IMPORTED_MODULE_9___default()))
    .set('underline', (_icons_underline_svg__WEBPACK_IMPORTED_MODULE_10___default()));


/***/ }),

/***/ 49405:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   P: function() { return /* binding */ ToolbarContent; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35265);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






let ToolbarContent = class ToolbarContent extends jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_3__/* .UIButton */ .lD {
    /** @override */
    className() {
        return 'ToolbarContent';
    }
    /** @override */
    update() {
        const content = this.control.getContent(this.j, this);
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isString)(content) || content.parentNode !== this.container) {
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.detach(this.container);
            this.container.appendChild((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isString)(content) ? this.j.create.fromHTML(content) : content);
        }
        super.update();
    }
    /** @override */
    createContainer() {
        return this.j.c.span(this.componentName);
    }
    constructor(jodit, control, target = null) {
        super(jodit);
        this.control = control;
        this.target = target;
        this.container.classList.add(`${this.componentName}_${this.clearName(control.name)}`);
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.attr)(this.container, 'role', 'content');
    }
};
ToolbarContent = (0,tslib__WEBPACK_IMPORTED_MODULE_4__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.component
], ToolbarContent);



/***/ }),

/***/ 49429:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Hp: function() { return /* binding */ markAsAtomic; },
/* harmony export */   mA: function() { return /* binding */ isAtom; },
/* harmony export */   y6: function() { return /* binding */ fastClone; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_string_stringify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28616);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */

function isAtom(obj) {
    return obj && obj.isAtom;
}
function markAsAtomic(obj) {
    Object.defineProperty(obj, 'isAtom', {
        enumerable: false,
        value: true,
        configurable: false
    });
    return obj;
}
function fastClone(object) {
    return JSON.parse((0,jodit_core_helpers_string_stringify__WEBPACK_IMPORTED_MODULE_0__/* .stringify */ .A)(object));
}


/***/ }),

/***/ 49744:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   x: function() { return /* binding */ innerWidth; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/size
 */
const innerWidth = (element, win) => {
    const computedStyle = win.getComputedStyle(element);
    let elementWidth = element.clientWidth; // width with padding
    elementWidth -=
        parseFloat(computedStyle.paddingLeft || '0') +
            parseFloat(computedStyle.paddingRight || '0');
    return elementWidth;
};


/***/ }),

/***/ 49777:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export image */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(931);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(36115);
/* harmony import */ var jodit_modules_widget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(16116);
/* harmony import */ var _image_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(64831);
/* harmony import */ var _image_svg__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_image_svg__WEBPACK_IMPORTED_MODULE_6__);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */








jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_3__/* .Icon */ .I.set('image', (_image_svg__WEBPACK_IMPORTED_MODULE_6___default()));
jodit_config__WEBPACK_IMPORTED_MODULE_4__/* .Config */ .T.prototype.controls.image = {
    popup: (editor, current, close) => {
        let sourceImage = null;
        if (current &&
            !jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isText(current) &&
            jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(current) &&
            (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(current, 'img') || (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.$$)('img', current).length)) {
            sourceImage = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isTag(current, 'img')
                ? current
                : (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.$$)('img', current)[0];
        }
        editor.s.save();
        return (0,jodit_modules_widget__WEBPACK_IMPORTED_MODULE_5__/* .FileSelectorWidget */ .kG)(editor, {
            filebrowser: (data) => {
                editor.s.restore();
                data.files &&
                    data.files.forEach(file => editor.s.insertImage(data.baseurl + file, null, editor.o.imageDefaultWidth));
                close();
            },
            upload: true,
            url: (url, text) => (0,tslib__WEBPACK_IMPORTED_MODULE_7__/* .__awaiter */ .sH)(void 0, void 0, void 0, function* () {
                editor.s.restore();
                if (/^[a-z\d_-]+(\.[a-z\d_-]+)+/i.test(url)) {
                    url = '//' + url;
                }
                const image = sourceImage || editor.createInside.element('img');
                image.setAttribute('src', url);
                image.setAttribute('alt', text);
                if (!sourceImage) {
                    yield editor.s.insertImage(image, null, editor.o.imageDefaultWidth);
                }
                close();
            })
        }, sourceImage, close);
    },
    tags: ['img'],
    tooltip: 'Insert Image'
};
function image(editor) {
    editor.registerButton({
        name: 'image',
        group: 'media'
    });
}
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('image', image);


/***/ }),

/***/ 49853:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: function() { return /* binding */ Ajax; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_async__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64890);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(52201);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(50156);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(36115);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27337);
/* harmony import */ var _response__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(91672);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */









class Ajax {
    className() {
        return 'Ajax';
    }
    constructor(options, defaultAjaxOptions = jodit_config__WEBPACK_IMPORTED_MODULE_4__/* .Config */ .T.prototype.defaultAjaxOptions) {
        this.__async = new jodit_core_async__WEBPACK_IMPORTED_MODULE_0__/* .Async */ .j();
        this.__isFulfilled = false;
        this.__activated = false;
        this.__isDestructed = false;
        this.options = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.ConfigProto)(options || {}, defaultAjaxOptions);
        this.xhr = this.o.xhr ? this.o.xhr() : new XMLHttpRequest();
    }
    __buildParams(obj, prefix) {
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isPlainObject)(obj) &&
            this.options.contentType &&
            this.options.contentType.includes('application/json')) {
            return JSON.stringify(obj);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isFunction)(this.o.queryBuild)) {
            return this.o.queryBuild.call(this, obj, prefix);
        }
        if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isString)(obj) ||
            obj instanceof jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.globalWindow.FormData ||
            (typeof obj === 'object' && obj != null && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isFunction)(obj.append))) {
            return obj;
        }
        return (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.buildQuery)(obj);
    }
    get o() {
        return this.options;
    }
    abort() {
        if (this.__isFulfilled) {
            return this;
        }
        try {
            this.__isFulfilled = true;
            this.xhr.abort();
        }
        catch (_a) { }
        return this;
    }
    send() {
        this.__activated = true;
        const { xhr, o } = this;
        const request = this.prepareRequest();
        return this.__async.promise((resolve, reject) => (0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__awaiter */ .sH)(this, void 0, void 0, function* () {
            var _a;
            const onReject = () => {
                this.__isFulfilled = true;
                reject(jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_3__/* .connection */ .FI('Connection error'));
            };
            const onResolve = () => {
                this.__isFulfilled = true;
                resolve(new _response__WEBPACK_IMPORTED_MODULE_7__/* .Response */ .Y(request, xhr.status, xhr.statusText, !xhr.responseType ? xhr.responseText : xhr.response));
            };
            xhr.onload = onResolve;
            xhr.onabort = () => {
                this.__isFulfilled = true;
                reject(jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_3__/* .abort */ .h2('Abort connection'));
            };
            xhr.onerror = onReject;
            xhr.ontimeout = onReject;
            if (o.responseType) {
                xhr.responseType = o.responseType;
            }
            xhr.onprogress = (e) => {
                var _a, _b;
                let percentComplete = 0;
                if (e.lengthComputable) {
                    percentComplete = (e.loaded / e.total) * 100;
                }
                (_b = (_a = this.options).onProgress) === null || _b === void 0 ? void 0 : _b.call(_a, percentComplete);
            };
            xhr.onreadystatechange = () => {
                var _a, _b;
                (_b = (_a = this.options).onProgress) === null || _b === void 0 ? void 0 : _b.call(_a, 10);
                if (xhr.readyState === XMLHttpRequest.DONE) {
                    if (o.successStatuses.includes(xhr.status)) {
                        onResolve();
                    }
                    else if (xhr.statusText) {
                        this.__isFulfilled = true;
                        reject(jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_3__/* .connection */ .FI(xhr.statusText));
                    }
                }
            };
            xhr.withCredentials = (_a = o.withCredentials) !== null && _a !== void 0 ? _a : false;
            const { url, data, method } = request;
            xhr.open(method, url, true);
            if (o.contentType && xhr.setRequestHeader) {
                xhr.setRequestHeader('Content-type', o.contentType);
            }
            let { headers } = o;
            if ((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isFunction)(headers)) {
                headers = yield headers.call(this);
            }
            if (headers && xhr.setRequestHeader) {
                Object.keys(headers).forEach(key => {
                    xhr.setRequestHeader(key, headers[key]);
                });
            }
            // IE
            this.__async.setTimeout(() => {
                xhr.send(data ? this.__buildParams(data) : undefined);
            }, 0);
        }));
    }
    prepareRequest() {
        if (!this.o.url) {
            throw jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_3__/* .error */ .z3('Need URL for AJAX request');
        }
        let url = this.o.url;
        const data = this.o.data;
        const method = (this.o.method || 'get').toLowerCase();
        if (method === 'get' && data && (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.isPlainObject)(data)) {
            const qIndex = url.indexOf('?');
            if (qIndex !== -1) {
                const urlData = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.parseQuery)(url);
                url =
                    url.substring(0, qIndex) +
                        '?' +
                        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.buildQuery)(Object.assign(Object.assign({}, urlData), data));
            }
            else {
                url += '?' + (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.buildQuery)(this.o.data);
            }
        }
        const request = {
            url,
            method,
            data
        };
        Ajax.log.splice(100);
        Ajax.log.push(request);
        return request;
    }
    destruct() {
        if (!this.__isDestructed) {
            this.__isDestructed = true;
            if (this.__activated && !this.__isFulfilled) {
                this.abort();
                this.__isFulfilled = true;
            }
            this.__async.destruct();
        }
    }
}
Ajax.log = [];
(0,tslib__WEBPACK_IMPORTED_MODULE_6__/* .__decorate */ .Cg)([
    jodit_core_decorators_autobind_autobind__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Ay
], Ajax.prototype, "destruct", null);


/***/ }),

/***/ 49931:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(931);
/* harmony import */ var jodit_modules_file_browser_builders_elements_map__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(77112);
/* harmony import */ var jodit_modules_file_browser_factories__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(83797);
/* harmony import */ var jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(97324);
/* harmony import */ var jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31859);
/* harmony import */ var jodit_modules_file_browser_listeners_native_listeners__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(62994);
/* harmony import */ var jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(53804);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










const CLASS_PREVIEW = 'jodit-file-browser-preview', preview_tpl_next = (next = 'next', right = 'right') => `<div class="${CLASS_PREVIEW}__navigation ${CLASS_PREVIEW}__navigation_arrow_${next}">` +
    '' +
    jodit_core_ui_icon__WEBPACK_IMPORTED_MODULE_2__/* .Icon */ .I.get('angle-' + right) +
    '</a>';
/* harmony default export */ __webpack_exports__.A = ((self) => {
    if (!self.o.contextMenu) {
        return () => { };
    }
    const contextmenu = (0,jodit_modules_file_browser_factories__WEBPACK_IMPORTED_MODULE_4__/* .makeContextMenu */ .V)(self);
    return (e) => {
        const a = (0,jodit_modules_file_browser_listeners_native_listeners__WEBPACK_IMPORTED_MODULE_6__/* .getItem */ .Gq)(e.target, self.container);
        if (!a) {
            return;
        }
        let item = a;
        const opt = self.options, ga = (key) => (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.attr)(item, key) || '';
        self.async.setTimeout(() => {
            const selectedItem = (0,jodit_modules_file_browser_listeners_native_listeners__WEBPACK_IMPORTED_MODULE_6__/* .elementToItem */ .PZ)(a, (0,jodit_modules_file_browser_builders_elements_map__WEBPACK_IMPORTED_MODULE_3__/* .elementsMap */ .a)(self));
            if (!selectedItem) {
                return;
            }
            self.state.activeElements = [selectedItem];
            contextmenu.show(e.clientX, e.clientY, [
                ga('data-is-file') !== '1' &&
                    opt.editImage &&
                    (self.dataProvider.canI('ImageResize') ||
                        self.dataProvider.canI('ImageCrop'))
                    ? {
                        icon: 'pencil',
                        title: 'Edit',
                        exec: () => jodit_modules_image_editor_image_editor__WEBPACK_IMPORTED_MODULE_7__/* .openImageEditor */ .B.call(self, ga('href'), ga('data-name'), ga('data-path'), ga('data-source'))
                    }
                    : false,
                self.dataProvider.canI('FileRename')
                    ? {
                        icon: 'italic',
                        title: 'Rename',
                        exec: () => {
                            self.e.fire('fileRename.filebrowser', ga('data-name'), ga('data-path'), ga('data-source'));
                        }
                    }
                    : false,
                self.dataProvider.canI('FileRemove')
                    ? {
                        icon: 'bin',
                        title: 'Delete',
                        exec: () => (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__awaiter */ .sH)(void 0, void 0, void 0, function* () {
                            try {
                                yield (0,jodit_modules_file_browser_fetch_delete_file__WEBPACK_IMPORTED_MODULE_9__/* .deleteFile */ .W)(self, ga('data-name'), ga('data-source'));
                            }
                            catch (e) {
                                return self.status(e);
                            }
                            self.state.activeElements = [];
                            return (0,jodit_modules_file_browser_fetch_load_tree__WEBPACK_IMPORTED_MODULE_5__/* .loadTree */ .r)(self).catch(self.status);
                        })
                    }
                    : false,
                opt.preview
                    ? {
                        icon: 'eye',
                        title: 'Preview',
                        exec: () => {
                            const preview = self.dlg({
                                buttons: ['fullsize', 'dialog.close']
                            }), temp_content = self.c.div(CLASS_PREVIEW, '<div class="jodit-icon_loader"></div>'), preview_box = self.c.div(CLASS_PREVIEW + '__box'), next = self.c.fromHTML(preview_tpl_next()), prev = self.c.fromHTML(preview_tpl_next('prev', 'left')), addLoadHandler = (src) => {
                                const image = self.c.element('img');
                                image.setAttribute('src', src);
                                const onload = () => {
                                    var _a;
                                    if (self.isInDestruct) {
                                        return;
                                    }
                                    self.e.off(image, 'load');
                                    jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.detach(temp_content);
                                    if (opt.showPreviewNavigation) {
                                        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.prevWithClass(item, self.files.getFullElName('item'))) {
                                            temp_content.appendChild(prev);
                                        }
                                        if (jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.nextWithClass(item, self.files.getFullElName('item'))) {
                                            temp_content.appendChild(next);
                                        }
                                    }
                                    temp_content.appendChild(preview_box);
                                    preview_box.appendChild(image);
                                    preview.setPosition();
                                    (_a = self === null || self === void 0 ? void 0 : self.events) === null || _a === void 0 ? void 0 : _a.fire('previewOpenedAndLoaded');
                                };
                                self.e.on(image, 'load', onload);
                                if (image.complete) {
                                    onload();
                                }
                            };
                            self.e.on([next, prev], 'click', function () {
                                if (this === next) {
                                    item = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.nextWithClass(item, self.files.getFullElName('item'));
                                }
                                else {
                                    item = jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.prevWithClass(item, self.files.getFullElName('item'));
                                }
                                if (!item) {
                                    throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_1__.error)('Need element');
                                }
                                jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.detach(temp_content);
                                jodit_core_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.detach(preview_box);
                                temp_content.innerHTML =
                                    '<div class="jodit-icon_loader"></div>';
                                addLoadHandler(ga('href'));
                            });
                            self.e.on('beforeDestruct', () => {
                                preview.destruct();
                            });
                            preview.container.classList.add(CLASS_PREVIEW + '__dialog');
                            preview.setContent(temp_content);
                            preview.setPosition();
                            preview.open();
                            addLoadHandler(ga('href'));
                            self.events
                                .on('beforeDestruct', () => {
                                preview.destruct();
                            })
                                .fire('previewOpened');
                        }
                    }
                    : false,
                {
                    icon: 'upload',
                    title: 'Download',
                    exec: () => {
                        const url = ga('href');
                        if (url) {
                            self.ow.open(url);
                        }
                    }
                }
            ]);
        }, self.defaultTimeout);
        self.e
            .on('beforeClose', () => {
            contextmenu.close();
        })
            .on('beforeDestruct', () => contextmenu.destruct());
        e.stopPropagation();
        e.preventDefault();
        return false;
    };
});


/***/ }),

/***/ 49972:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1760 896q14 0 23 9t9 23v64q0 14-9 23t-23 9h-1728q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h1728zm-1277-64q-28-35-51-80-48-97-48-188 0-181 134-309 133-127 393-127 50 0 167 19 66 12 177 48 10 38 21 118 14 123 14 183 0 18-5 45l-12 3-84-6-14-2q-50-149-103-205-88-91-210-91-114 0-182 59-67 58-67 146 0 73 66 140t279 129q69 20 173 66 58 28 95 52h-743zm507 256h411q7 39 7 92 0 111-41 212-23 55-71 104-37 35-109 81-80 48-153 66-80 21-203 21-114 0-195-23l-140-40q-57-16-72-28-8-8-8-22v-13q0-108-2-156-1-30 0-68l2-37v-44l102-2q15 34 30 71t22.5 56 12.5 27q35 57 80 94 43 36 105 57 59 22 132 22 64 0 139-27 77-26 122-86 47-61 47-129 0-84-81-157-34-29-137-71z\"/> </svg>"

/***/ }),

/***/ 49983:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1728 608v704q0 92-66 158t-158 66h-1216q-92 0-158-66t-66-158v-960q0-92 66-158t158-66h320q92 0 158 66t66 158v32h672q92 0 158 66t66 158z\"/> </svg>"

/***/ }),

/***/ 50025:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Xr: function() { return /* reexport safe */ _store__WEBPACK_IMPORTED_MODULE_3__.X; },
/* harmony export */   bk: function() { return /* reexport safe */ _event_emitter__WEBPACK_IMPORTED_MODULE_0__.b; },
/* harmony export */   d$: function() { return /* reexport safe */ _store__WEBPACK_IMPORTED_MODULE_3__.d; },
/* harmony export */   h5: function() { return /* reexport safe */ _eventify__WEBPACK_IMPORTED_MODULE_1__.h; },
/* harmony export */   sH: function() { return /* reexport safe */ _observable__WEBPACK_IMPORTED_MODULE_2__.s; }
/* harmony export */ });
/* harmony import */ var _event_emitter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(50658);
/* harmony import */ var _eventify__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43431);
/* harmony import */ var _observable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32332);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10004);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module event-emitter
 */






/***/ }),

/***/ 50156:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FI: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_0__.FI; },
/* harmony export */   Rc: function() { return /* reexport safe */ _errors___WEBPACK_IMPORTED_MODULE_1__.Rc; },
/* harmony export */   ZW: function() { return /* reexport safe */ _errors___WEBPACK_IMPORTED_MODULE_1__.ZW; },
/* harmony export */   fF: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_0__.fF; },
/* harmony export */   h2: function() { return /* reexport safe */ _errors___WEBPACK_IMPORTED_MODULE_1__.h2; },
/* harmony export */   rV: function() { return /* reexport safe */ _errors___WEBPACK_IMPORTED_MODULE_1__.rV; },
/* harmony export */   z3: function() { return /* reexport safe */ _error__WEBPACK_IMPORTED_MODULE_0__.z3; }
/* harmony export */ });
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(76166);
/* harmony import */ var _errors___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20222);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/utils
 */




/***/ }),

/***/ 50658:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   b: function() { return /* binding */ EventEmitter; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_array_split_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42589);
/* harmony import */ var jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(37923);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(69052);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(50156);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(10004);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







/**
 * The module editor's event manager
 */
class EventEmitter {
    mute(event) {
        this.__mutedEvents.add(event !== null && event !== void 0 ? event : '*');
        return this;
    }
    isMuted(event) {
        if (event && this.__mutedEvents.has(event)) {
            return true;
        }
        return this.__mutedEvents.has('*');
    }
    unmute(event) {
        this.__mutedEvents.delete(event !== null && event !== void 0 ? event : '*');
        return this;
    }
    __eachEvent(events, callback) {
        const eventParts = (0,jodit_core_helpers_array_split_array__WEBPACK_IMPORTED_MODULE_3__/* .splitArray */ .u)(events).map(e => e.trim());
        eventParts.forEach(eventNameSpace => {
            const eventAndNameSpace = eventNameSpace.split('.');
            const namespace = eventAndNameSpace[1] || _store__WEBPACK_IMPORTED_MODULE_2__/* .defaultNameSpace */ .X;
            callback.call(this, eventAndNameSpace[0], namespace);
        });
    }
    __getStore(subject) {
        if (!subject) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Need subject');
        }
        if (subject[this.__key] === undefined) {
            const store = new _store__WEBPACK_IMPORTED_MODULE_2__/* .EventHandlersStore */ .d();
            Object.defineProperty(subject, this.__key, {
                enumerable: false,
                configurable: true,
                writable: true,
                value: store
            });
        }
        return subject[this.__key];
    }
    __removeStoreFromSubject(subject) {
        if (subject[this.__key] !== undefined) {
            Object.defineProperty(subject, this.__key, {
                enumerable: false,
                configurable: true,
                writable: true,
                value: undefined
            });
        }
    }
    __triggerNativeEvent(element, event) {
        const evt = this.__doc.createEvent('HTMLEvents');
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(event)) {
            evt.initEvent(event, true, true);
        }
        else {
            evt.initEvent(event.type, event.bubbles, event.cancelable);
            [
                'screenX',
                'screenY',
                'clientX',
                'clientY',
                'target',
                'srcElement',
                'currentTarget',
                'timeStamp',
                'which',
                'keyCode'
            ].forEach(property => {
                Object.defineProperty(evt, property, {
                    value: event[property],
                    enumerable: true
                });
            });
            Object.defineProperty(evt, 'originalEvent', {
                value: event,
                enumerable: true
            });
        }
        element.dispatchEvent(evt);
    }
    /**
     * Get current event name
     *
     * @example
     * ```javascript
     * parent.e.on('openDialog closeDialog', function () {
     *     if (parent.e.current === 'closeDialog') {
     *         alert('Dialog was closed');
     *     } else {
     *         alert('Dialog was opened');
     *     }
     * });
     * ```
     */
    get current() {
        return this.currents[this.currents.length - 1];
    }
    on(eventsOrSubjects, callbackOrEvents, optionsOrCallback, opts) {
        let subjects;
        let events;
        let callback;
        let options;
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(eventsOrSubjects) || (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isStringArray */ .B)(eventsOrSubjects)) {
            subjects = this;
            events = eventsOrSubjects;
            callback = callbackOrEvents;
            options = optionsOrCallback;
        }
        else {
            subjects = eventsOrSubjects;
            events = callbackOrEvents;
            callback = optionsOrCallback;
            options = opts;
        }
        if (!((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(events) || (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isStringArray */ .B)(events)) ||
            events.length === 0) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Need events names');
        }
        if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_5__/* .isFunction */ .T)(callback)) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Need event handler');
        }
        if ((0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_6__/* .isArray */ .c)(subjects)) {
            subjects.forEach(subj => {
                this.on(subj, events, callback, options);
            });
            return this;
        }
        const subject = subjects;
        const store = this.__getStore(subject);
        const self = this;
        let syntheticCallback = function (event, ...args) {
            if (self.isMuted(event)) {
                return;
            }
            return callback && callback.call(this, ...args);
        };
        if (isDOMElement(subject)) {
            syntheticCallback = function (event) {
                if (self.isMuted(event.type)) {
                    return;
                }
                self.__prepareEvent(event);
                if (callback && callback.call(this, event) === false) {
                    event.preventDefault();
                    event.stopImmediatePropagation();
                    return false;
                }
                return;
            };
        }
        this.__eachEvent(events, (event, namespace) => {
            var _a, _b;
            if (event.length === 0) {
                throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Need event name');
            }
            if (store.indexOf(event, namespace, callback) === false) {
                const block = {
                    event,
                    originalCallback: callback,
                    syntheticCallback
                };
                store.set(event, namespace, block, options === null || options === void 0 ? void 0 : options.top);
                if (isDOMElement(subject)) {
                    const eOpts = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.PASSIVE_EVENTS.has(event)
                        ? {
                            passive: true,
                            capture: (_a = options === null || options === void 0 ? void 0 : options.capture) !== null && _a !== void 0 ? _a : false
                        }
                        : ((_b = options === null || options === void 0 ? void 0 : options.capture) !== null && _b !== void 0 ? _b : false);
                    syntheticCallback.options = eOpts;
                    subject.addEventListener(event, syntheticCallback, eOpts);
                    this.__memoryDOMSubjectToHandler(subject, syntheticCallback);
                }
            }
        });
        return this;
    }
    __memoryDOMSubjectToHandler(subject, syntheticCallback) {
        const callbackStore = this.__domEventsMap.get(subject) || new Set();
        callbackStore.add(syntheticCallback);
        this.__domEventsMap.set(subject, callbackStore);
    }
    __unmemoryDOMSubjectToHandler(subject, syntheticCallback) {
        const m = this.__domEventsMap;
        const callbackStore = m.get(subject) || new Set();
        callbackStore.delete(syntheticCallback);
        if (callbackStore.size) {
            m.set(subject, callbackStore);
        }
        else {
            m.delete(subject);
        }
    }
    one(eventsOrSubjects, callbackOrEvents, optionsOrCallback, opts) {
        let subjects;
        let events;
        let callback;
        let options;
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(eventsOrSubjects) || (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isStringArray */ .B)(eventsOrSubjects)) {
            subjects = this;
            events = eventsOrSubjects;
            callback = callbackOrEvents;
            options = optionsOrCallback;
        }
        else {
            subjects = eventsOrSubjects;
            events = callbackOrEvents;
            callback = optionsOrCallback;
            options = opts;
        }
        const newCallback = (...args) => {
            this.off(subjects, events, newCallback);
            return callback(...args);
        };
        this.on(subjects, events, newCallback, options);
        return this;
    }
    off(eventsOrSubjects, callbackOrEvents, handler) {
        let subjects;
        let events;
        let callback;
        if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(eventsOrSubjects) || (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isStringArray */ .B)(eventsOrSubjects)) {
            subjects = this;
            events = eventsOrSubjects;
            callback = callbackOrEvents;
        }
        else {
            subjects = eventsOrSubjects;
            events = callbackOrEvents;
            callback = handler;
        }
        if ((0,jodit_core_helpers_checker_is_array__WEBPACK_IMPORTED_MODULE_6__/* .isArray */ .c)(subjects)) {
            subjects.forEach(subj => {
                this.off(subj, events, callback);
            });
            return this;
        }
        const subject = subjects;
        const store = this.__getStore(subject);
        if (!((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(events) || (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isStringArray */ .B)(events)) ||
            events.length === 0) {
            store.namespaces().forEach((namespace) => {
                this.off(subject, '.' + namespace);
            });
            this.__removeStoreFromSubject(subject);
            return this;
        }
        const removeEventListener = (block) => {
            var _a;
            if (isDOMElement(subject)) {
                subject.removeEventListener(block.event, block.syntheticCallback, (_a = block.syntheticCallback.options) !== null && _a !== void 0 ? _a : false);
                this.__unmemoryDOMSubjectToHandler(subject, block.syntheticCallback);
            }
        }, removeCallbackFromNameSpace = (event, namespace) => {
            if (event === '') {
                store.events(namespace).forEach((eventName) => {
                    if (eventName !== '') {
                        removeCallbackFromNameSpace(eventName, namespace);
                    }
                });
                return;
            }
            const blocks = store.get(event, namespace);
            if (!blocks || !blocks.length) {
                return;
            }
            if (!(0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_5__/* .isFunction */ .T)(callback)) {
                blocks.forEach(removeEventListener);
                blocks.length = 0;
                store.clearEvents(namespace, event);
            }
            else {
                const index = store.indexOf(event, namespace, callback);
                if (index !== false) {
                    removeEventListener(blocks[index]);
                    blocks.splice(index, 1);
                    if (!blocks.length) {
                        store.clearEvents(namespace, event);
                    }
                }
            }
        };
        this.__eachEvent(events, (event, namespace) => {
            if (namespace === _store__WEBPACK_IMPORTED_MODULE_2__/* .defaultNameSpace */ .X) {
                store.namespaces().forEach(namespace => {
                    removeCallbackFromNameSpace(event, namespace);
                });
            }
            else {
                removeCallbackFromNameSpace(event, namespace);
            }
        });
        if (store.isEmpty()) {
            this.__removeStoreFromSubject(subject);
        }
        return this;
    }
    stopPropagation(subjectOrEvents, eventsList) {
        const subject = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(subjectOrEvents)
            ? this
            : subjectOrEvents;
        const events = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(subjectOrEvents)
            ? subjectOrEvents
            : eventsList;
        if (typeof events !== 'string') {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Need event names');
        }
        const store = this.__getStore(subject);
        this.__eachEvent(events, (event, namespace) => {
            const blocks = store.get(event, namespace);
            if (blocks) {
                this.__stopped.push(blocks);
            }
            if (namespace === _store__WEBPACK_IMPORTED_MODULE_2__/* .defaultNameSpace */ .X) {
                store
                    .namespaces(true)
                    .forEach(ns => this.stopPropagation(subject, event + '.' + ns));
            }
        });
    }
    __removeStop(currentBlocks) {
        if (currentBlocks) {
            const index = this.__stopped.indexOf(currentBlocks);
            index !== -1 && this.__stopped.splice(0, index + 1);
        }
    }
    __isStopped(currentBlocks) {
        return (currentBlocks !== undefined &&
            this.__stopped.indexOf(currentBlocks) !== -1);
    }
    fire(subjectOrEvents, eventsList, ...args) {
        let result, result_value;
        const subject = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(subjectOrEvents)
            ? this
            : subjectOrEvents;
        const events = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(subjectOrEvents)
            ? subjectOrEvents
            : eventsList;
        const argumentsList = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(subjectOrEvents)
            ? [eventsList, ...args]
            : args;
        if (!isDOMElement(subject) && !(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(events)) {
            throw (0,jodit_core_helpers_utils_error__WEBPACK_IMPORTED_MODULE_1__/* .error */ .z3)('Need events names');
        }
        const store = this.__getStore(subject);
        if (!(0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(events) && isDOMElement(subject)) {
            this.__triggerNativeEvent(subject, eventsList);
        }
        else {
            this.__eachEvent(events, (event, namespace) => {
                if (isDOMElement(subject)) {
                    this.__triggerNativeEvent(subject, event);
                }
                else {
                    const blocks = store.get(event, namespace);
                    if (blocks) {
                        try {
                            [...blocks].every((block) => {
                                if (this.__isStopped(blocks)) {
                                    return false;
                                }
                                this.currents.push(event);
                                result_value =
                                    block.syntheticCallback.call(subject, event, ...argumentsList);
                                this.currents.pop();
                                if (result_value !== undefined) {
                                    result = result_value;
                                }
                                return true;
                            });
                        }
                        finally {
                            this.__removeStop(blocks);
                        }
                    }
                    if (namespace === _store__WEBPACK_IMPORTED_MODULE_2__/* .defaultNameSpace */ .X &&
                        !isDOMElement(subject)) {
                        store
                            .namespaces()
                            .filter(ns => ns !== namespace)
                            .forEach((ns) => {
                            const result_second = this.fire.apply(this, [
                                subject,
                                event + '.' + ns,
                                ...argumentsList
                            ]);
                            if (result_second !== undefined) {
                                result = result_second;
                            }
                        });
                    }
                }
            });
        }
        return result;
    }
    constructor(doc) {
        this.__domEventsMap = new Map();
        this.__mutedEvents = new Set();
        this.__key = '__JoditEventEmitterNamespaces';
        this.__doc = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument;
        this.__prepareEvent = (e) => {
            if (e.cancelBubble) {
                return;
            }
            // for Shadow Dom
            if (e.composed && (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_5__/* .isFunction */ .T)(e.composedPath) && e.composedPath()[0]) {
                Object.defineProperty(e, 'target', {
                    value: e.composedPath()[0],
                    configurable: true,
                    enumerable: true
                });
            }
            if (e.type.match(/^touch/) &&
                e.changedTouches &&
                e.changedTouches.length) {
                ['clientX', 'clientY', 'pageX', 'pageY'].forEach((key) => {
                    Object.defineProperty(e, key, {
                        value: e.changedTouches[0][key],
                        configurable: true,
                        enumerable: true
                    });
                });
            }
            if (!e.originalEvent) {
                e.originalEvent = e;
            }
            if (e.type === 'paste' &&
                e.clipboardData === undefined &&
                this.__doc.defaultView.clipboardData) {
                Object.defineProperty(e, 'clipboardData', {
                    get: () => {
                        return this.__doc.defaultView.clipboardData;
                    },
                    configurable: true,
                    enumerable: true
                });
            }
        };
        this.currents = [];
        this.__stopped = [];
        this.__isDestructed = false;
        if (doc) {
            this.__doc = doc;
        }
        this.__key += new Date().getTime();
    }
    destruct() {
        if (this.__isDestructed) {
            return;
        }
        this.__isDestructed = true;
        this.__domEventsMap.forEach((set, elm) => {
            this.off(elm);
        });
        this.__domEventsMap.clear();
        this.__mutedEvents.clear();
        this.currents.length = 0;
        this.__stopped.length = 0;
        this.off(this);
        this.__getStore(this).clear();
        this.__removeStoreFromSubject(this);
    }
}
function isDOMElement(subject) {
    return (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_5__/* .isFunction */ .T)(subject.addEventListener);
}


/***/ }),

/***/ 50974:
/***/ (function(__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/tab
 */

jodit_config__WEBPACK_IMPORTED_MODULE_0__/* .Config */ .T.prototype.tab = {
    tabInsideLiInsertNewList: true
};


/***/ }),

/***/ 51170:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'copy-format': 'opmaak kopiëren'
};


/***/ }),

/***/ 51271:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   required: function() { return /* binding */ required; },
/* harmony export */   url: function() { return /* binding */ url; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_url__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6939);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59101);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Input is required
 */
const required = function (input) {
    if (!(0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__/* .trim */ .Bq)(input.value).length) {
        input.error = 'Please fill out this field';
        return false;
    }
    return true;
};
/**
 * Input value should be valid URL
 */
const url = function (input) {
    if (!(0,jodit_core_helpers_checker_is_url__WEBPACK_IMPORTED_MODULE_0__/* .isURL */ .m)((0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_1__/* .trim */ .Bq)(input.value))) {
        input.error = 'Please enter a web address';
        return false;
    }
    return true;
};


/***/ }),

/***/ 51923:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   z: function() { return /* binding */ dataURItoBlob; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module modules/uploader
 */
/**
 * Convert dataURI to Blob
 */
function dataURItoBlob(dataURI) {
    // convert base64 to raw binary data held in a string
    // doesn't handle URLEncoded DataURIs - see SO answer #6850276 for code that does this
    const byteString = atob(dataURI.split(',')[1]), 
    // separate out the mime component
    mimeString = dataURI.split(',')[0].split(':')[1].split(';')[0], 
    // write the bytes of the string to an ArrayBuffer
    ab = new ArrayBuffer(byteString.length), ia = new Uint8Array(ab);
    for (let i = 0; i < byteString.length; i += 1) {
        ia[i] = byteString.charCodeAt(i);
    }
    return new Blob([ia], { type: mimeString });
}


/***/ }),

/***/ 51957:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 48 48\"> <path d=\"M6 42h4v-4h-4v4zm4-28h-4v4h4v-4zm-4 20h4v-4h-4v4zm8 8h4v-4h-4v4zm-4-36h-4v4h4v-4zm8 0h-4v4h4v-4zm16 0h-4v4h4v-4zm-8 8h-4v4h4v-4zm0-8h-4v4h4v-4zm12 28h4v-4h-4v4zm-16 8h4v-4h-4v4zm-16-16h36v-4h-36v4zm32-20v4h4v-4h-4zm0 12h4v-4h-4v4zm-16 16h4v-4h-4v4zm8 8h4v-4h-4v4zm8 0h4v-4h-4v4z\"/> <path d=\"M0 0h48v48h-48z\" fill=\"none\"/> </svg>"

/***/ }),

/***/ 52052:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: function() { return /* binding */ getSuitParent; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var _is_normal_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38046);
/* harmony import */ var _is_suit_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(95274);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Checks if the parent of an element is suitable for applying styles, if applicable, then returns the parent *
 *
 * @param style - styles to be applied
 * @param node - checked item
 * @param root - editor root
 * @private
 */
function getSuitParent(style, node, root) {
    const { parentNode } = node;
    if (parentNode === root ||
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isHTMLElement(parentNode) ||
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.next(node, _is_normal_node__WEBPACK_IMPORTED_MODULE_1__/* .isNormalNode */ ._, parentNode) ||
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.prev(node, _is_normal_node__WEBPACK_IMPORTED_MODULE_1__/* .isNormalNode */ ._, parentNode)) {
        return null;
    }
    // <h3><span style="color:red">|test|</span></h3> => apply <h2>
    if (style.isElementCommit &&
        style.elementIsBlock &&
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(parentNode)) {
        return getSuitParent(style, parentNode, root);
    }
    if ((0,_is_suit_element__WEBPACK_IMPORTED_MODULE_2__/* .isSuitElement */ .sz)(style, parentNode, false) &&
        (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(parentNode) || style.elementIsBlock)) {
        return parentNode;
    }
    // <strong style="color:red"><em>|test|</em></strong> => apply <strong>
    if (style.isElementCommit && !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.isBlock(parentNode)) {
        return getSuitParent(style, parentNode, root);
    }
    return null;
}


/***/ }),

/***/ 52201:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ay: function() { return /* binding */ autobind; }
/* harmony export */ });
/* unused harmony exports boundMethod, boundClass */
function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
            return typeof obj;
        };
    } else {
        _typeof = function _typeof(obj) {
            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
    }
    return _typeof(obj);
}
/**
 * Return a descriptor removing the value and returning a getter
 * The getter will return a .bind version of the function
 * and memoize the result against a symbol on the instance
 */ function boundMethod(target, key, descriptor) {
    var fn = descriptor.value;
    if (typeof fn !== 'function') {
        throw new TypeError("@boundMethod decorator can only be applied to methods not: ".concat(_typeof(fn)));
    } // In IE11 calling Object.defineProperty has a side-effect of evaluating the
    // getter for the property which is being replaced. This causes infinite
    // recursion and an "Out of stack space" error.
    var definingProperty = false;
    return {
        configurable: true,
        get: function get() {
            // eslint-disable-next-line no-prototype-builtins
            if (definingProperty || this === target.prototype || this.hasOwnProperty(key) || typeof fn !== 'function') {
                return fn;
            }
            var boundFn = fn.bind(this);
            definingProperty = true;
            Object.defineProperty(this, key, {
                configurable: true,
                get: function get() {
                    return boundFn;
                },
                set: function set(value) {
                    fn = value;
                    delete this[key];
                }
            });
            definingProperty = false;
            return boundFn;
        },
        set: function set(value) {
            fn = value;
        }
    };
}
/**
 * Use boundMethod to bind all methods on the target.prototype
 */ function boundClass(target) {
    // (Using reflect to get all keys including symbols)
    var keys; // Use Reflect if exists
    if (typeof Reflect !== 'undefined' && typeof Reflect.ownKeys === 'function') {
        keys = Reflect.ownKeys(target.prototype);
    } else {
        keys = Object.getOwnPropertyNames(target.prototype); // Use symbols if support is provided
        if (typeof Object.getOwnPropertySymbols === 'function') {
            keys = keys.concat(Object.getOwnPropertySymbols(target.prototype));
        }
    }
    keys.forEach(function(key) {
        // Ignore special case target method
        if (key === 'constructor') {
            return;
        }
        var descriptor = Object.getOwnPropertyDescriptor(target.prototype, key); // Only methods need binding
        if (typeof descriptor.value === 'function') {
            Object.defineProperty(target.prototype, key, boundMethod(target, key, descriptor));
        }
    });
    return target;
}
function autobind() {
    if (arguments.length === 1) {
        return boundClass.apply(void 0, arguments);
    }
    return boundMethod.apply(void 0, arguments);
}


/***/ }),

/***/ 52306:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   e: function() { return /* binding */ visitNodeWalker; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var _filters__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3593);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


const keys = Object.keys(_filters__WEBPACK_IMPORTED_MODULE_1__);
/**
 * @private
 */
function visitNodeWalker(jodit, nodeElm, allowTags, denyTags, currentSelectionNode) {
    let hadEffect = false;
    const dcf = jodit.o.cleanHTML.disableCleanFilter;
    for (const key of keys) {
        if (dcf && dcf.has(key)) {
            continue;
        }
        const filter = _filters__WEBPACK_IMPORTED_MODULE_1__[key];
        const tmp = hadEffect;
        hadEffect = filter(jodit, nodeElm, hadEffect, allowTags, denyTags, currentSelectionNode);
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && !tmp && hadEffect) {
            console.warn(`CleanHTML: Effect "${key}"`);
        }
        if (!nodeElm.isConnected) {
            return true;
        }
    }
    return hadEffect;
}


/***/ }),

/***/ 52450:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M747 1521q74 32 140 32 376 0 376-335 0-114-41-180-27-44-61.5-74t-67.5-46.5-80.5-25-84-10.5-94.5-2q-73 0-101 10 0 53-.5 159t-.5 158q0 8-1 67.5t-.5 96.5 4.5 83.5 12 66.5zm-14-746q42 7 109 7 82 0 143-13t110-44.5 74.5-89.5 25.5-142q0-70-29-122.5t-79-82-108-43.5-124-14q-50 0-130 13 0 50 4 151t4 152q0 27-.5 80t-.5 79q0 46 1 69zm-541 889l2-94q15-4 85-16t106-27q7-12 12.5-27t8.5-33.5 5.5-32.5 3-37.5.5-34v-65.5q0-982-22-1025-4-8-22-14.5t-44.5-11-49.5-7-48.5-4.5-30.5-3l-4-83q98-2 340-11.5t373-9.5q23 0 68.5.5t67.5.5q70 0 136.5 13t128.5 42 108 71 74 104.5 28 137.5q0 52-16.5 95.5t-39 72-64.5 57.5-73 45-84 40q154 35 256.5 134t102.5 248q0 100-35 179.5t-93.5 130.5-138 85.5-163.5 48.5-176 14q-44 0-132-3t-132-3q-106 0-307 11t-231 12z\"/> </svg>"

/***/ }),

/***/ 53048:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $6: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.$6; },
/* harmony export */   $n: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.$n; },
/* harmony export */   CP: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_3__.CP; },
/* harmony export */   D$: function() { return /* reexport safe */ _element__WEBPACK_IMPORTED_MODULE_1__.D; },
/* harmony export */   F0: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.F0; },
/* harmony export */   In: function() { return /* reexport safe */ _icon__WEBPACK_IMPORTED_MODULE_4__.I; },
/* harmony export */   SB: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.SB; },
/* harmony export */   Ue: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_3__.Ue; },
/* harmony export */   XV: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.XV; },
/* harmony export */   Yh: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.Yh; },
/* harmony export */   bk: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_3__.bk; },
/* harmony export */   cY: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.cY; },
/* harmony export */   lD: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.lD; },
/* harmony export */   nE: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.nE; },
/* harmony export */   ss: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.ss; },
/* harmony export */   tS: function() { return /* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_2__.tS; },
/* harmony export */   ue: function() { return /* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_0__.ue; },
/* harmony export */   z2: function() { return /* reexport safe */ _progress_bar_progress_bar__WEBPACK_IMPORTED_MODULE_6__.z; },
/* harmony export */   z4: function() { return /* reexport safe */ _group__WEBPACK_IMPORTED_MODULE_3__.z4; },
/* harmony export */   zD: function() { return /* reexport safe */ _popup__WEBPACK_IMPORTED_MODULE_5__.z; }
/* harmony export */ });
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35265);
/* harmony import */ var _element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29780);
/* harmony import */ var _form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20703);
/* harmony import */ var _group__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(29012);
/* harmony import */ var _icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(931);
/* harmony import */ var _popup__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(96369);
/* harmony import */ var _progress_bar_progress_bar__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(92227);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * [[include:core/ui/README.md]]
 * @packageDocumentation
 * @module ui
 */









/***/ }),

/***/ 53328:
/***/ (function(module) {

module.exports = "<svg viewBox=\"0 0 13 13\" xmlns=\"http://www.w3.org/2000/svg\"> <path d=\"M5.9814 11.8049C5.59087 11.4144 5.59087 10.7812 5.9814 10.3907L10.224 6.14806C10.6146 5.75754 11.2477 5.75754 11.6383 6.14806C12.0288 6.53859 12.0288 7.17175 11.6383 7.56228L7.39561 11.8049C7.00509 12.1954 6.37192 12.1954 5.9814 11.8049Z\"/> <path d=\"M0.707107 12.0208C0.316582 11.6303 0.316582 10.9971 0.707107 10.6066L10.6066 0.707121C10.9971 0.316597 11.6303 0.316596 12.0208 0.707121C12.4113 1.09764 12.4113 1.73081 12.0208 2.12133L2.12132 12.0208C1.7308 12.4114 1.09763 12.4114 0.707107 12.0208Z\"/> </svg>"

/***/ }),

/***/ 53380:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F: function() { return /* binding */ SourceEditor; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
class SourceEditor {
    constructor(jodit, container, toWYSIWYG, fromWYSIWYG) {
        this.jodit = jodit;
        this.container = container;
        this.toWYSIWYG = toWYSIWYG;
        this.fromWYSIWYG = fromWYSIWYG;
        this.className = '';
        this.isReady = false;
    }
    /**
     * Short alias for this.jodit
     */
    get j() {
        return this.jodit;
    }
    onReady() {
        this.replaceUndoManager();
        this.isReady = true;
        this.j.e.fire(this, 'ready');
    }
    onReadyAlways(onReady) {
        var _a;
        if (!this.isReady) {
            (_a = this.j.events) === null || _a === void 0 ? void 0 : _a.on(this, 'ready', onReady);
        }
        else {
            onReady();
        }
    }
}


/***/ }),

/***/ 53414:
/***/ (function(module) {

module.exports["default"] = ["Type something","About Jodit","Jodit Editor","Jodit User's Guide","contains detailed help for using","For information about the license, please go to our website:","Buy full version","Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.","Anchor","Open in new tab","Open in fullsize","Clear Formatting","Fill color or set the text color","Redo","Undo","Bold","Italic","Insert Unordered List","Insert Ordered List","Align Center","Align Justify","Align Left","Align Right","Insert Horizontal Line","Insert Image","Insert file","Insert youtube/vimeo video","Insert link","Font size","Font family","Insert format block","Normal","Heading 1","Heading 2","Heading 3","Heading 4","Quote","Code","Insert","Insert table","Decrease Indent","Increase Indent","Select Special Character","Insert Special Character","Paint format","Change mode","Margins","top","right","bottom","left","Styles","Classes","Align","Right","Center","Left","--Not Set--","Src","Title","Alternative","Link","Open link in new tab","Image","file","Advanced","Image properties","Cancel","Ok","File Browser","Error on load list","Error on load folders","Are you sure?","Enter Directory name","Create directory","type name","Drop image","Drop file","or click","Alternative text","Upload","Browse","Background","Text","Top","Middle","Bottom","Insert column before","Insert column after","Insert row above","Insert row below","Delete table","Delete row","Delete column","Empty cell","Chars: %d","Words: %d","Strike through","Underline","superscript","subscript","Cut selection","Select all","Break","Search for","Replace with","Replace","Paste","Choose Content to Paste","source","bold","italic","brush","link","undo","redo","table","image","eraser","paragraph","fontsize","video","font","about","print","underline","strikethrough","indent","outdent","fullsize","shrink","hr","ul","ol","cut","selectall","Embed code","Open link","Edit link","No follow","Unlink","Update","pencil","Eye"," URL","Edit","Horizontal align","Filter","Sort by changed","Sort by name","Sort by size","Add folder","Reset","Save","Save as ...","Resize","Crop","Width","Height","Keep Aspect Ratio","Yes","No","Remove","Select","Select %s","Vertical align","Split","Merge","Add column","Add row","License: %s","Delete","Split vertical","Split horizontal","Border","Your code is similar to HTML. Keep as HTML?","Paste as HTML","Keep","Insert as Text","Insert only Text","You can only edit your own images. Download this image on the host?","The image has been successfully uploaded to the host!","palette","There are no files","Rename","Enter new name","preview","download","Paste from clipboard","Your browser doesn't support direct access to the clipboard.","Copy selection","copy","Border radius","Show all","Apply","Please fill out this field","Please enter a web address","Default","Circle","Dot","Quadrate","Find","Find Previous","Find Next","The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?","Word Paste Detected","Clean","Insert className","Press Alt for custom resizing","Line height","spellcheck","Speech Recognize"]

/***/ }),

/***/ 53470:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   v: function() { return /* binding */ isSet; }
/* harmony export */ });
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(69052);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */

/**
 * Check if element is set
 */
function isSet(elm) {
    return (Boolean(elm) &&
        (0,_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(elm.has) &&
        (0,_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(elm.add) &&
        (0,_is_function__WEBPACK_IMPORTED_MODULE_0__/* .isFunction */ .T)(elm.delete));
}


/***/ }),

/***/ 53701:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: function() { return /* binding */ isHTML; }
/* harmony export */ });
/* harmony import */ var _is_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98253);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */

/**
 * Check if a string is html or not
 */
const isHTML = (str) => (0,_is_string__WEBPACK_IMPORTED_MODULE_0__/* .isString */ .K)(str) &&
    /<([A-Za-z][A-Za-z0-9]*)\b[^>]*>(.*?)<\/\1>/m.test(str.replace(/[\r\n]/g, ''));


/***/ }),

/***/ 53804:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   B: function() { return /* binding */ openImageEditor; },
/* harmony export */   n: function() { return /* binding */ ImageEditor; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71842);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(35265);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(36115);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(93027);
/* harmony import */ var _templates_form__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(24863);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var ImageEditor_1;










const jie = 'jodit-image-editor';
const TABS = {
    resize: 'resize',
    crop: 'crop'
};
/**
 * The module allows you to edit the image: resize or cut any part of it
 *
 */
let ImageEditor = ImageEditor_1 = class ImageEditor extends jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    /** @override */
    className() {
        return 'ImageEditor';
    }
    get o() {
        return this.options;
    }
    /**
     * Hide image editor
     */
    hide() {
        this._dialog.close();
    }
    /**
     * Open image editor
     * @example
     * ```javascript
     * const jodit = Jodit.make('.editor', {
     *		 imageeditor: {
     *				 crop: false,
     *				 closeAfterSave: true,
     *				 width: 500
     *		 }
     * });
     * jodit.imageeditor.open('https://xdsoft.net/jodit/images/test.png', function (name, data, success, failed) {
     *		 var img = jodit.node.c('img');
     *		 img.setAttribute('src', 'https://xdsoft.net/jodit/images/test.png');
     *		 if (box.action !== 'resize') {
     *					return failed('Sorry it is work only in resize mode. For croping use FileBrowser');
     *		 }
     *		 img.style.width = data.w;
     *		 img.style.height = data.h;
     *		 jodit.s.insertNode(img);
     *		 success();
     * });
     * ```
     */
    open(url, save) {
        return this.j.async.promise((resolve) => {
            const timestamp = new Date().getTime();
            this.image = this.j.c.element('img');
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.$$)('img,.jodit-icon_loader', this.resize_box).forEach(jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.$$)('img,.jodit-icon_loader', this.crop_box).forEach(jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.cropHandler, 'background', 'transparent');
            this.onSave = save;
            this.resize_box.appendChild(this.j.c.element('i', { class: 'jodit-icon_loader' }));
            this.crop_box.appendChild(this.j.c.element('i', { class: 'jodit-icon_loader' }));
            if (/\?/.test(url)) {
                url += '&_tst=' + timestamp;
            }
            else {
                url += '?_tst=' + timestamp;
            }
            this.image.setAttribute('src', url);
            this._dialog.open();
            const { widthInput, heightInput } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(this.editor);
            const onload = () => {
                if (this.isDestructed) {
                    return;
                }
                this.image.removeEventListener('load', onload);
                this.naturalWidth = this.image.naturalWidth;
                this.naturalHeight = this.image.naturalHeight;
                widthInput.value = this.naturalWidth.toString();
                heightInput.value = this.naturalHeight.toString();
                this.ratio = this.naturalWidth / this.naturalHeight;
                this.resize_box.appendChild(this.image);
                this.cropImage = this.image.cloneNode(true);
                this.crop_box.appendChild(this.cropImage);
                jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove.apply(null, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.$$)('.jodit-icon_loader', this.editor));
                if (this.activeTab === TABS.crop) {
                    this.showCrop();
                }
                this.j.e.fire(this.resizeHandler, 'updatesize');
                this.j.e.fire(this.cropHandler, 'updatesize');
                this._dialog.setPosition();
                this.j.e.fire('afterImageEditor');
                resolve(this._dialog);
            };
            this.image.addEventListener('load', onload);
            if (this.image.complete) {
                onload();
            }
        });
    }
    onTitleModeClick(e) {
        const self = this, title = e.target;
        const slide = title === null || title === void 0 ? void 0 : title.parentElement;
        if (!slide) {
            return;
        }
        (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.$$)(`.${jie}__slider,.${jie}__area`, self.editor).forEach(elm => elm.classList.remove(`${jie}_active`));
        slide.classList.add(`${jie}_active`);
        this.activeTab = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(slide, '-area') || TABS.resize;
        const tab = self.editor.querySelector(`.${jie}__area.${jie}__area_` + self.activeTab);
        if (tab) {
            tab.classList.add(`${jie}_active`);
        }
        if (self.activeTab === TABS.crop) {
            self.showCrop();
        }
    }
    onChangeSizeInput(e) {
        const self = this, input = e.target, { widthInput, heightInput } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(this.editor), isWidth = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(input, 'data-ref') === 'widthInput', x = parseInt(input.value, 10), minX = isWidth ? self.o.min_width : self.o.min_height, minY = !isWidth ? self.o.min_width : self.o.min_height;
        let y;
        if (x > minX) {
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.image, isWidth ? 'width' : 'height', x);
            if (self.resizeUseRatio) {
                y = isWidth
                    ? Math.round(x / self.ratio)
                    : Math.round(x * self.ratio);
                if (y > minY) {
                    (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.image, !isWidth ? 'width' : 'height', y);
                    if (isWidth) {
                        heightInput.value = y.toString();
                    }
                    else {
                        widthInput.value = y.toString();
                    }
                }
            }
        }
        this.j.e.fire(self.resizeHandler, 'updatesize');
    }
    onResizeHandleMouseDown(e) {
        const self = this;
        self.target = e.target;
        e.preventDefault();
        e.stopImmediatePropagation();
        self.clicked = true;
        self.start_x = e.clientX;
        self.start_y = e.clientY;
        if (self.activeTab === TABS.crop) {
            self.top_x = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, 'left');
            self.top_y = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, 'top');
            self.width = self.cropHandler.offsetWidth;
            self.height = self.cropHandler.offsetHeight;
        }
        else {
            self.width = self.image.offsetWidth;
            self.height = self.image.offsetHeight;
        }
        self.j.e
            .on(this.j.ow, 'mousemove', this.onGlobalMouseMove)
            .one(this.j.ow, 'mouseup', this.onGlobalMouseUp);
    }
    onGlobalMouseUp(e) {
        if (this.clicked) {
            this.clicked = false;
            e.stopImmediatePropagation();
            this.j.e.off(this.j.ow, 'mousemove', this.onGlobalMouseMove);
        }
    }
    onGlobalMouseMove(e) {
        const self = this;
        if (!self.clicked) {
            return;
        }
        const { widthInput, heightInput } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(this.editor);
        self.diff_x = e.clientX - self.start_x;
        self.diff_y = e.clientY - self.start_y;
        if ((self.activeTab === TABS.resize && self.resizeUseRatio) ||
            (self.activeTab === TABS.crop && self.cropUseRatio)) {
            if (self.diff_x) {
                self.new_w = self.width + self.diff_x;
                self.new_h = Math.round(self.new_w / self.ratio);
            }
            else {
                self.new_h = self.height + self.diff_y;
                self.new_w = Math.round(self.new_h * self.ratio);
            }
        }
        else {
            self.new_w = self.width + self.diff_x;
            self.new_h = self.height + self.diff_y;
        }
        if (self.activeTab === TABS.resize) {
            if (self.new_w > self.o.resizeMinWidth) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.image, 'width', self.new_w + 'px');
                widthInput.value = self.new_w.toString();
            }
            if (self.new_h > self.o.resizeMinHeight) {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.image, 'height', self.new_h + 'px');
                heightInput.value = self.new_h.toString();
            }
            this.j.e.fire(self.resizeHandler, 'updatesize');
        }
        else {
            if (self.target !== self.cropHandler) {
                if (self.top_x + self.new_w > self.cropImage.offsetWidth) {
                    self.new_w = self.cropImage.offsetWidth - self.top_x;
                }
                if (self.top_y + self.new_h > self.cropImage.offsetHeight) {
                    self.new_h = self.cropImage.offsetHeight - self.top_y;
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, {
                    width: self.new_w,
                    height: self.new_h
                });
            }
            else {
                if (self.top_x + self.diff_x + self.cropHandler.offsetWidth >
                    self.cropImage.offsetWidth) {
                    self.diff_x =
                        self.cropImage.offsetWidth -
                            self.top_x -
                            self.cropHandler.offsetWidth;
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, 'left', self.top_x + self.diff_x);
                if (self.top_y + self.diff_y + self.cropHandler.offsetHeight >
                    self.cropImage.offsetHeight) {
                    self.diff_y =
                        self.cropImage.offsetHeight -
                            self.top_y -
                            self.cropHandler.offsetHeight;
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, 'top', self.top_y + self.diff_y);
            }
            this.j.e.fire(self.cropHandler, 'updatesize');
        }
    }
    constructor(editor) {
        super(editor);
        this.resizeUseRatio = true;
        this.cropUseRatio = true;
        this.clicked = false;
        this.start_x = 0;
        this.start_y = 0;
        this.top_x = 0;
        this.top_y = 0;
        this.width = 0;
        this.height = 0;
        this.activeTab = TABS.resize;
        this.naturalWidth = 0;
        this.naturalHeight = 0;
        this.ratio = 0;
        this.new_h = 0;
        this.new_w = 0;
        this.diff_x = 0;
        this.diff_y = 0;
        this.cropBox = {
            x: 0,
            y: 0,
            w: 0,
            h: 0
        };
        this.resizeBox = {
            w: 0,
            h: 0
        };
        this.calcCropBox = () => {
            const node = this.crop_box.parentNode, w = node.offsetWidth * 0.8, h = node.offsetHeight * 0.8;
            let wn = w, hn = h;
            const { naturalWidth: nw, naturalHeight: nh } = this;
            if (w > nw && h > nh) {
                wn = nw;
                hn = nh;
            }
            else if (this.ratio > w / h) {
                wn = w;
                hn = nh * (w / nw);
            }
            else {
                wn = nw * (h / nh);
                hn = h;
            }
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.crop_box, {
                width: wn,
                height: hn
            });
        };
        this.showCrop = () => {
            if (!this.cropImage) {
                return;
            }
            this.calcCropBox();
            const w = this.cropImage.offsetWidth ||
                this.image.offsetWidth ||
                this.image.naturalWidth;
            this.new_w = ImageEditor_1.calcValueByPercent(w, this.o.cropDefaultWidth);
            const h = this.cropImage.offsetHeight ||
                this.image.offsetHeight ||
                this.image.naturalHeight;
            if (this.cropUseRatio) {
                this.new_h = this.new_w / this.ratio;
            }
            else {
                this.new_h = ImageEditor_1.calcValueByPercent(h, this.o.cropDefaultHeight);
            }
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.cropHandler, {
                backgroundImage: 'url(' + (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.attr)(this.cropImage, 'src') + ')',
                width: this.new_w,
                height: this.new_h,
                left: w / 2 - this.new_w / 2,
                top: h / 2 - this.new_h / 2
            });
            this.j.e.fire(this.cropHandler, 'updatesize');
        };
        this.updateCropBox = () => {
            if (!this.cropImage) {
                return;
            }
            const ratioX = this.cropImage.offsetWidth / this.naturalWidth, ratioY = this.cropImage.offsetHeight / this.naturalHeight;
            this.cropBox.x = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.cropHandler, 'left') / ratioX;
            this.cropBox.y = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(this.cropHandler, 'top') / ratioY;
            this.cropBox.w = this.cropHandler.offsetWidth / ratioX;
            this.cropBox.h = this.cropHandler.offsetHeight / ratioY;
            this.sizes.textContent =
                this.cropBox.w.toFixed(0) + 'x' + this.cropBox.h.toFixed(0);
        };
        this.updateResizeBox = () => {
            this.resizeBox.w = this.image.offsetWidth || this.naturalWidth;
            this.resizeBox.h = this.image.offsetHeight || this.naturalHeight;
        };
        this.setHandlers = () => {
            const self = this;
            const { widthInput, heightInput } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(this.editor);
            self.j.e
                .on([
                self.editor.querySelector('.jodit_bottomright'),
                self.cropHandler
            ], `mousedown.${jie}`, this.onResizeHandleMouseDown)
                .on(this.j.ow, `resize.${jie}`, () => {
                this.j.e.fire(self.resizeHandler, 'updatesize');
                self.showCrop();
                this.j.e.fire(self.cropHandler, 'updatesize');
            });
            self.j.e
                .on((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.toArray)(this.editor.querySelectorAll(`.${jie}__slider-title`)), 'click', this.onTitleModeClick)
                .on([widthInput, heightInput], 'input', this.onChangeSizeInput);
            const { keepAspectRatioResize, keepAspectRatioCrop } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(this.editor);
            if (keepAspectRatioResize) {
                keepAspectRatioResize.addEventListener('change', () => {
                    this.resizeUseRatio = keepAspectRatioResize.checked;
                });
            }
            if (keepAspectRatioCrop) {
                keepAspectRatioCrop.addEventListener('change', () => {
                    this.cropUseRatio = keepAspectRatioCrop.checked;
                });
            }
            self.j.e
                .on(self.resizeHandler, 'updatesize', () => {
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.resizeHandler, {
                    top: 0,
                    left: 0,
                    width: self.image.offsetWidth || self.naturalWidth,
                    height: self.image.offsetHeight || self.naturalHeight
                });
                this.updateResizeBox();
            })
                .on(self.cropHandler, 'updatesize', () => {
                if (!self.cropImage) {
                    return;
                }
                let new_x = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, 'left'), new_y = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, 'top'), new_width = self.cropHandler.offsetWidth, new_height = self.cropHandler.offsetHeight;
                if (new_x < 0) {
                    new_x = 0;
                }
                if (new_y < 0) {
                    new_y = 0;
                }
                if (new_x + new_width > self.cropImage.offsetWidth) {
                    new_width = self.cropImage.offsetWidth - new_x;
                    if (self.cropUseRatio) {
                        new_height = new_width / self.ratio;
                    }
                }
                if (new_y + new_height > self.cropImage.offsetHeight) {
                    new_height = self.cropImage.offsetHeight - new_y;
                    if (self.cropUseRatio) {
                        new_width = new_height * self.ratio;
                    }
                }
                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.cropHandler, {
                    width: new_width,
                    height: new_height,
                    left: new_x,
                    top: new_y,
                    backgroundPosition: -new_x - 1 + 'px ' + (-new_y - 1) + 'px',
                    backgroundSize: self.cropImage.offsetWidth +
                        'px ' +
                        self.cropImage.offsetHeight +
                        'px'
                });
                self.updateCropBox();
            });
            Object.values(self.buttons).forEach(button => {
                button.onAction(() => {
                    const data = {
                        action: self.activeTab,
                        box: self.activeTab === TABS.resize
                            ? self.resizeBox
                            : self.cropBox
                    };
                    switch (button) {
                        case self.buttons.saveas:
                            self.j.prompt('Enter new name', 'Save in new file', (name) => {
                                if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.trim)(name)) {
                                    self.j.alert('The name should not be empty');
                                    return false;
                                }
                                self.onSave(name, data, self.hide, (e) => {
                                    self.j.alert(e.message);
                                });
                            });
                            break;
                        case self.buttons.save:
                            self.onSave(undefined, data, self.hide, (e) => {
                                self.j.alert(e.message);
                            });
                            break;
                        case self.buttons.reset:
                            if (self.activeTab === TABS.resize) {
                                (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.css)(self.image, {
                                    width: null,
                                    height: null
                                });
                                widthInput.value = self.naturalWidth.toString();
                                heightInput.value = self.naturalHeight.toString();
                                self.j.e.fire(self.resizeHandler, 'updatesize');
                            }
                            else {
                                self.showCrop();
                            }
                            break;
                    }
                });
            });
        };
        this.options =
            editor && editor.o && editor.o.imageeditor
                ? editor.o.imageeditor
                : jodit_config__WEBPACK_IMPORTED_MODULE_5__/* .Config */ .T.defaultOptions.imageeditor;
        const o = this.options;
        this.resizeUseRatio = o.resizeUseRatio;
        this.cropUseRatio = o.cropUseRatio;
        this.buttons = {
            reset: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .Button */ .$n)(this.j, 'update', 'Reset'),
            save: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .Button */ .$n)(this.j, 'save', 'Save'),
            saveas: (0,jodit_core_ui_button__WEBPACK_IMPORTED_MODULE_4__/* .Button */ .$n)(this.j, 'save', 'Save as ...')
        };
        this.activeTab = o.resize ? TABS.resize : TABS.crop;
        this.editor = (0,_templates_form__WEBPACK_IMPORTED_MODULE_7__/* .form */ .Z)(this.j, this.options);
        const { resizeBox, cropBox } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.refs)(this.editor);
        this.resize_box = resizeBox;
        this.crop_box = cropBox;
        this.sizes = this.editor.querySelector(`.${jie}__area.${jie}__area_crop .jodit-image-editor__sizes`);
        this.resizeHandler = this.editor.querySelector(`.${jie}__resizer`);
        this.cropHandler = this.editor.querySelector(`.${jie}__croper`);
        this._dialog = this.j.dlg({
            buttons: ['fullsize', 'dialog.close']
        });
        this._dialog.setContent(this.editor);
        this._dialog.setSize(this.o.width, this.o.height);
        this._dialog.setHeader([
            this.buttons.reset,
            this.buttons.save,
            this.buttons.saveas
        ]);
        this.setHandlers();
    }
    /** @override */
    destruct() {
        if (this.isDestructed) {
            return;
        }
        if (this._dialog && !this._dialog.isInDestruct) {
            this._dialog.destruct();
        }
        jodit_core_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.safeRemove(this.editor);
        if (this.j.e) {
            this.j.e
                .off(this.j.ow, 'mousemove', this.onGlobalMouseMove)
                .off(this.j.ow, 'mouseup', this.onGlobalMouseUp)
                .off(this.ow, `.${jie}`)
                .off(`.${jie}`);
        }
        super.destruct();
    }
};
ImageEditor.calcValueByPercent = (value, percent) => {
    const percentStr = percent.toString();
    const valueNbr = parseFloat(value.toString());
    let match;
    match = /^[-+]?[0-9]+(px)?$/.exec(percentStr);
    if (match) {
        return parseInt(percentStr, 10);
    }
    match = /^([-+]?[0-9.]+)%$/.exec(percentStr);
    if (match) {
        return Math.round(valueNbr * (parseFloat(match[1]) / 100));
    }
    return valueNbr || 0;
};
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ImageEditor.prototype, "hide", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ImageEditor.prototype, "open", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ImageEditor.prototype, "onTitleModeClick", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.debounce)(),
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ImageEditor.prototype, "onChangeSizeInput", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ImageEditor.prototype, "onResizeHandleMouseDown", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.autobind
], ImageEditor.prototype, "onGlobalMouseUp", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.throttle)(10)
], ImageEditor.prototype, "onGlobalMouseMove", null);
ImageEditor = ImageEditor_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_8__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_1__.component
], ImageEditor);

/**
 * Open Image Editor
 */
function openImageEditor(href, name, path, source, onSuccess, onFailed) {
    return this.getInstance('ImageEditor', this.o).open(href, (newname, box, success, failed) => (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_3__.call)(box.action === 'resize'
        ? this.dataProvider.resize
        : this.dataProvider.crop, path, source, name, newname, box.box)
        .then(ok => {
        if (ok) {
            success();
            if (onSuccess) {
                onSuccess();
            }
        }
    })
        .catch(error => {
        failed(error);
        if (onFailed) {
            onFailed(error);
        }
    }));
}


/***/ }),

/***/ 53808:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M512 1536h768v-384h-768v384zm896 0h128v-896q0-14-10-38.5t-20-34.5l-281-281q-10-10-34-20t-39-10v416q0 40-28 68t-68 28h-576q-40 0-68-28t-28-68v-416h-128v1280h128v-416q0-40 28-68t68-28h832q40 0 68 28t28 68v416zm-384-928v-320q0-13-9.5-22.5t-22.5-9.5h-192q-13 0-22.5 9.5t-9.5 22.5v320q0 13 9.5 22.5t22.5 9.5h192q13 0 22.5-9.5t9.5-22.5zm640 32v928q0 40-28 68t-68 28h-1344q-40 0-68-28t-28-68v-1344q0-40 28-68t68-28h928q40 0 88 20t76 48l280 280q28 28 48 76t20 88z\"/> </svg>"

/***/ }),

/***/ 53883:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Y: function() { return /* reexport safe */ _response__WEBPACK_IMPORTED_MODULE_1__.Y; },
/* harmony export */   d: function() { return /* reexport safe */ _ajax__WEBPACK_IMPORTED_MODULE_0__.d; }
/* harmony export */ });
/* harmony import */ var _ajax__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49853);
/* harmony import */ var _response__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91672);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module request
 */




/***/ }),

/***/ 54522:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' x=\"0px\" y=\"0px\" viewBox=\"0 0 459 459\"> <g> <path d=\"M229.5,0C102,0,0,102,0,229.5S102,459,229.5,459c20.4,0,38.25-17.85,38.25-38.25c0-10.2-2.55-17.85-10.2-25.5 c-5.1-7.65-10.2-15.3-10.2-25.5c0-20.4,17.851-38.25,38.25-38.25h45.9c71.4,0,127.5-56.1,127.5-127.5C459,91.8,357,0,229.5,0z M89.25,229.5c-20.4,0-38.25-17.85-38.25-38.25S68.85,153,89.25,153s38.25,17.85,38.25,38.25S109.65,229.5,89.25,229.5z M165.75,127.5c-20.4,0-38.25-17.85-38.25-38.25S145.35,51,165.75,51S204,68.85,204,89.25S186.15,127.5,165.75,127.5z M293.25,127.5c-20.4,0-38.25-17.85-38.25-38.25S272.85,51,293.25,51s38.25,17.85,38.25,38.25S313.65,127.5,293.25,127.5z M369.75,229.5c-20.4,0-38.25-17.85-38.25-38.25S349.35,153,369.75,153S408,170.85,408,191.25S390.15,229.5,369.75,229.5z\" /> </g> </svg>"

/***/ }),

/***/ 55186:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   J: function() { return /* binding */ Dom; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42448);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59101);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97369);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






/**
 * Module for working with DOM
 */
class Dom {
    constructor() {
        throw new Error('Dom is static module');
    }
    /**
     * Remove all content from element
     */
    static detach(node) {
        while (node && node.firstChild) {
            node.removeChild(node.firstChild);
        }
    }
    /**
     * Wrap all inline next siblings
     */
    static wrapNextInline(current, tag, editor) {
        let tmp;
        const first = current;
        let last = current;
        editor.s.save();
        let needFindNext = false;
        do {
            needFindNext = false;
            tmp = last.nextSibling;
            if (tmp && !Dom.isBlock(tmp) && !Dom.isTag(tmp, 'br')) {
                needFindNext = true;
                last = tmp;
            }
        } while (needFindNext);
        return Dom.__wrapElements(tag, editor, first, last);
    }
    static __wrapElements(tag, editor, first, last) {
        const wrapper = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .Kg)(tag) ? editor.createInside.element(tag) : tag;
        if (first.parentNode) {
            first.parentNode.insertBefore(wrapper, first);
        }
        let next = first;
        while (next) {
            next = first.nextSibling;
            wrapper.appendChild(first);
            if (first === last || !next) {
                break;
            }
            first = next;
        }
        editor.s.restore();
        return wrapper;
    }
    /**
     * Wrap all inline siblings
     */
    static wrapInline(current, tag, editor) {
        let tmp;
        let first = current;
        let last = current;
        editor.s.save();
        let needFindNext = false;
        do {
            needFindNext = false;
            tmp = first.previousSibling;
            if (tmp && !Dom.isBlock(tmp)) {
                needFindNext = true;
                first = tmp;
            }
        } while (needFindNext);
        do {
            needFindNext = false;
            tmp = last.nextSibling;
            if (tmp && !Dom.isBlock(tmp)) {
                needFindNext = true;
                last = tmp;
            }
        } while (needFindNext);
        return Dom.__wrapElements(tag, editor, first, last);
    }
    /**
     * Wrap node inside another node
     */
    static wrap(current, tag, create) {
        const wrapper = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .Kg)(tag) ? create.element(tag) : tag;
        if (Dom.isNode(current)) {
            if (!current.parentNode) {
                throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.error)('Element should be in DOM');
            }
            current.parentNode.insertBefore(wrapper, current);
            wrapper.appendChild(current);
        }
        else {
            const fragment = current.extractContents();
            current.insertNode(wrapper);
            wrapper.appendChild(fragment);
        }
        return wrapper;
    }
    /**
     * Remove parent of node and insert this node instead that parent
     */
    static unwrap(node) {
        const parent = node.parentNode;
        if (parent) {
            while (node.firstChild) {
                parent.insertBefore(node.firstChild, node);
            }
            Dom.safeRemove(node);
        }
    }
    /**
     * Call functions for all nodes between `start` and `end`
     */
    static between(start, end, callback) {
        let next = start;
        while (next && next !== end) {
            if (start !== next && callback(next)) {
                break;
            }
            let step = next.firstChild || next.nextSibling;
            if (!step) {
                while (next && !next.nextSibling) {
                    next = next.parentNode;
                }
                step = next === null || next === void 0 ? void 0 : next.nextSibling;
            }
            next = step;
        }
    }
    static replace(elm, newTagName, create, withAttributes = false, notMoveContent = false) {
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isHTML */ .AH)(newTagName)) {
            void 0;
            newTagName = create.fromHTML(newTagName);
        }
        let tag;
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .Kg)(newTagName)) {
            void 0;
            tag = create.element(newTagName);
        }
        else {
            tag = newTagName;
        }
        if (!notMoveContent) {
            while (elm.firstChild) {
                tag.appendChild(elm.firstChild);
            }
        }
        if (withAttributes && Dom.isElement(elm) && Dom.isElement(tag)) {
            (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_1__/* .toArray */ .$)(elm.attributes).forEach(attr => {
                tag.setAttribute(attr.name, attr.value);
            });
        }
        if (elm.parentNode) {
            elm.parentNode.replaceChild(tag, elm);
        }
        return tag;
    }
    /**
     * Checks whether the Node text and blank (in this case it may contain invisible auxiliary characters ,
     * it is also empty )
     *
     * @param node - The element of wood to be checked
     */
    static isEmptyTextNode(node) {
        return (Dom.isText(node) &&
            (!node.nodeValue ||
                node.nodeValue
                    .replace(jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP(), '')
                    .trim().length === 0));
    }
    static isEmptyContent(node) {
        return Dom.each(node, (elm) => Dom.isEmptyTextNode(elm));
    }
    /**
     * The node is editable
     */
    static isContentEditable(node, root) {
        return (Dom.isNode(node) &&
            !Dom.closest(node, elm => Dom.isElement(elm) &&
                elm.getAttribute('contenteditable') === 'false', root));
    }
    static isEmpty(node, condNoEmptyElement = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.NO_EMPTY_TAGS) {
        if (!node) {
            return true;
        }
        let cond;
        if (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .Tn)(condNoEmptyElement)) {
            cond = (elm) => condNoEmptyElement.has(elm.nodeName.toLowerCase());
        }
        else {
            cond = condNoEmptyElement;
        }
        const emptyText = (node) => node.nodeValue == null || (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__/* .trim */ .Bq)(node.nodeValue).length === 0;
        if (Dom.isText(node)) {
            return emptyText(node);
        }
        return (!(Dom.isElement(node) && cond(node)) &&
            Dom.each(node, (elm) => {
                if ((Dom.isText(elm) && !emptyText(elm)) ||
                    (Dom.isElement(elm) && cond(elm))) {
                    return false;
                }
            }));
    }
    /**
     * Returns true if it is a DOM node
     */
    static isNode(object) {
        // Duck-typing
        return Boolean(object &&
            (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isString */ .Kg)(object.nodeName) &&
            typeof object.nodeType === 'number' &&
            object.childNodes &&
            (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .Tn)(object.appendChild));
    }
    /**
     *  Check if element is table cell
     */
    static isCell(elm) {
        return (Dom.isNode(elm) && (elm.nodeName === 'TD' || elm.nodeName === 'TH'));
    }
    /**
     * Check if element is a list	element UL or OL
     */
    static isList(elm) {
        return Dom.isTag(elm, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.LIST_TAGS);
    }
    /**
     * Check if element is a part of list	element LI
     */
    static isLeaf(elm) {
        return Dom.isTag(elm, 'li');
    }
    /**
     * Check is element is Image element
     */
    static isImage(elm) {
        return (Dom.isNode(elm) && /^(img|svg|picture|canvas)$/i.test(elm.nodeName));
    }
    /**
     * Check the `node` is a block element
     * @param node - Object to check
     */
    static isBlock(node) {
        return (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isVoid */ .Rd)(node) &&
            typeof node === 'object' &&
            Dom.isNode(node) &&
            jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_BLOCK.test(node.nodeName));
    }
    /**
     * Check if element is text node
     */
    static isText(node) {
        return Boolean(node && node.nodeType === Node.TEXT_NODE);
    }
    /**
     * Check if element is comment node
     */
    static isComment(node) {
        return Boolean(node && node.nodeType === Node.COMMENT_NODE);
    }
    /**
     * Check if element is element node
     */
    static isElement(node) {
        var _a;
        if (!Dom.isNode(node)) {
            return false;
        }
        const win = (_a = node.ownerDocument) === null || _a === void 0 ? void 0 : _a.defaultView;
        return Boolean(win && node.nodeType === Node.ELEMENT_NODE);
    }
    /**
     * Check if element is document fragment
     */
    static isFragment(node) {
        var _a;
        if (!Dom.isNode(node)) {
            return false;
        }
        const win = (_a = node.ownerDocument) === null || _a === void 0 ? void 0 : _a.defaultView;
        return Boolean(win && node.nodeType === Node.DOCUMENT_FRAGMENT_NODE);
    }
    /**
     * Check if element is HTMLElement node
     */
    static isHTMLElement(node) {
        var _a;
        if (!Dom.isNode(node)) {
            return false;
        }
        const win = (_a = node.ownerDocument) === null || _a === void 0 ? void 0 : _a.defaultView;
        return Boolean(win && node instanceof win.HTMLElement);
    }
    /**
     * Check element is inline block
     */
    static isInlineBlock(node) {
        return (Dom.isElement(node) &&
            !/^(BR|HR)$/i.test(node.tagName) &&
            ['inline', 'inline-block'].indexOf((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.css)(node, 'display').toString()) !== -1);
    }
    /**
     * It's block and it can be split
     */
    static canSplitBlock(node) {
        return (!(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isVoid */ .Rd)(node) &&
            Dom.isHTMLElement(node) &&
            Dom.isBlock(node) &&
            !/^(TD|TH|CAPTION|FORM)$/.test(node.nodeName) &&
            node.style !== undefined &&
            !/^(fixed|absolute)/i.test(node.style.position));
    }
    /**
     * Get last matched node inside root
     */
    static last(root, condition) {
        let last = root === null || root === void 0 ? void 0 : root.lastChild;
        if (!last) {
            return null;
        }
        do {
            if (condition(last)) {
                return last;
            }
            let next = last.lastChild;
            if (!next) {
                next = last.previousSibling;
            }
            if (!next && last.parentNode !== root) {
                do {
                    last = last.parentNode;
                } while (last &&
                    !(last === null || last === void 0 ? void 0 : last.previousSibling) &&
                    last.parentNode !== root);
                next = last === null || last === void 0 ? void 0 : last.previousSibling;
            }
            last = next;
        } while (last);
        return null;
    }
    /**
     * Find previous node
     */
    static prev(node, condition, root, withChild = true) {
        return Dom.find(node, condition, root, false, withChild);
    }
    /**
     * Find next node what `condition(next) === true`
     */
    static next(node, condition, root, withChild = true) {
        return Dom.find(node, condition, root, true, withChild);
    }
    static prevWithClass(node, className) {
        return Dom.prev(node, node => {
            return (Dom.isElement(node) && node.classList.contains(className));
        }, node.parentNode);
    }
    static nextWithClass(node, className) {
        return Dom.next(node, elm => Dom.isElement(elm) && elm.classList.contains(className), node.parentNode);
    }
    /**
     * Find next/prev node what `condition(next) === true`
     */
    static find(node, condition, root, leftToRight = true, withChild = true) {
        const gen = this.nextGen(node, root, leftToRight, withChild);
        let item = gen.next();
        while (!item.done) {
            if (condition(item.value)) {
                return item.value;
            }
            item = gen.next();
        }
        return null;
    }
    /**
     * Find next/prev node what `condition(next) === true`
     */
    static *nextGen(start, root, leftToRight = true, withChild = true) {
        const stack = [];
        let currentNode = start;
        do {
            let next = leftToRight
                ? currentNode.nextSibling
                : currentNode.previousSibling;
            while (next) {
                stack.unshift(next);
                next = leftToRight ? next.nextSibling : next.previousSibling;
            }
            yield* this.runInStack(start, stack, leftToRight, withChild);
            currentNode = currentNode.parentNode;
        } while (currentNode && currentNode !== root);
        return null;
    }
    /**
     * It goes through all the internal elements of the node, causing a callback function
     *
     * @param elm - the element whose children and descendants you want to iterate over
     * @param callback - It called for each item found
     * @example
     * ```javascript
     * Jodit.modules.Dom.each(editor.s.current(), function (node) {
     *  if (node.nodeType === Node.TEXT_NODE) {
     *      node.nodeValue = node.nodeValue.replace(Jodit.INVISIBLE_SPACE_REG_EX, '') // remove all of the text element codes invisible character
     *  }
     * });
     * ```
     */
    static each(elm, callback, leftToRight = true) {
        const gen = this.eachGen(elm, leftToRight);
        let item = gen.next();
        while (!item.done) {
            if (callback(item.value) === false) {
                return false;
            }
            item = gen.next();
        }
        return true;
    }
    static eachGen(root, leftToRight = true) {
        return this.runInStack(root, [root], leftToRight);
    }
    static *runInStack(start, stack, leftToRight, withChild = true) {
        while (stack.length) {
            const item = stack.pop();
            if (withChild) {
                let child = leftToRight ? item.lastChild : item.firstChild;
                while (child) {
                    stack.push(child);
                    child = leftToRight
                        ? child.previousSibling
                        : child.nextSibling;
                }
            }
            if (start !== item) {
                yield item;
            }
        }
    }
    /**
     * Find next/prev node what `condition(next) === true`
     */
    static findWithCurrent(node, condition, root, sibling = 'nextSibling', child = 'firstChild') {
        let next = node;
        do {
            if (condition(next)) {
                return next || null;
            }
            if (child && next && next[child]) {
                const nextOne = Dom.findWithCurrent(next[child], condition, next, sibling, child);
                if (nextOne) {
                    return nextOne;
                }
            }
            while (next && !next[sibling] && next !== root) {
                next = next.parentNode;
            }
            if (next && next[sibling] && next !== root) {
                next = next[sibling];
            }
        } while (next && next !== root);
        return null;
    }
    /**
     * Get not empty sibling
     */
    static findSibling(node, left = true, cond = (n) => !Dom.isEmptyTextNode(n)) {
        let sibling = Dom.sibling(node, left);
        while (sibling && !cond(sibling)) {
            sibling = Dom.sibling(sibling, left);
        }
        return sibling && cond(sibling) ? sibling : null;
    }
    /**
     * Returns the nearest non-empty sibling
     */
    static findNotEmptySibling(node, left) {
        return Dom.findSibling(node, left, n => {
            var _a;
            return (!Dom.isEmptyTextNode(n) &&
                Boolean(!Dom.isText(n) || (((_a = n.nodeValue) === null || _a === void 0 ? void 0 : _a.length) && (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__/* .trim */ .Bq)(n.nodeValue))));
        });
    }
    /**
     * Returns the nearest non-empty neighbor
     */
    static findNotEmptyNeighbor(node, left, root) {
        return (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.call)(left ? Dom.prev : Dom.next, node, n => Boolean(n &&
            (!(Dom.isText(n) || Dom.isComment(n)) ||
                (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_3__/* .trim */ .Bq)((n === null || n === void 0 ? void 0 : n.nodeValue) || '').length)), root);
    }
    static sibling(node, left) {
        return left ? node.previousSibling : node.nextSibling;
    }
    /**
     * It goes through all the elements in ascending order, and checks to see if they meet the predetermined condition
     */
    static up(node, condition, root, checkRoot = false) {
        let start = node;
        if (!start) {
            return null;
        }
        do {
            if (condition(start)) {
                return start;
            }
            if (start === root || !start.parentNode) {
                break;
            }
            start = start.parentNode;
        } while (start && start !== root);
        if (start === root && checkRoot && condition(start)) {
            return start;
        }
        return null;
    }
    static closest(node, tagsOrCondition, root) {
        let condition;
        const lc = (s) => s.toLowerCase();
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isFunction */ .Tn)(tagsOrCondition)) {
            condition = tagsOrCondition;
        }
        else if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isArray */ .cy)(tagsOrCondition) || (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isSet */ .vM)(tagsOrCondition)) {
            const set = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isSet */ .vM)(tagsOrCondition)
                ? tagsOrCondition
                : new Set(tagsOrCondition.map(lc));
            condition = (tag) => Boolean(tag && set.has(lc(tag.nodeName)));
        }
        else {
            condition = (tag) => Boolean(tag && lc(tagsOrCondition) === lc(tag.nodeName));
        }
        return Dom.up(node, condition, root);
    }
    /**
     * Furthest parent node matching condition
     */
    static furthest(node, condition, root) {
        let matchedParent = null, current = node === null || node === void 0 ? void 0 : node.parentElement;
        while (current && current !== root) {
            if (condition(current)) {
                matchedParent = current;
            }
            current = current === null || current === void 0 ? void 0 : current.parentElement;
        }
        return matchedParent;
    }
    /**
     * Append new element in the start of root
     */
    static appendChildFirst(root, newElement) {
        const child = root.firstChild;
        if (child) {
            if (child !== newElement) {
                root.insertBefore(newElement, child);
            }
        }
        else {
            root.appendChild(newElement);
        }
    }
    /**
     * Insert newElement after element
     */
    static after(elm, newElement) {
        const { parentNode } = elm;
        if (!parentNode) {
            return;
        }
        if (parentNode.lastChild === elm) {
            parentNode.appendChild(newElement);
        }
        else {
            parentNode.insertBefore(newElement, elm.nextSibling);
        }
    }
    /**
     * Insert newElement before element
     */
    static before(elm, newElement) {
        const { parentNode } = elm;
        if (!parentNode) {
            return;
        }
        parentNode.insertBefore(newElement, elm);
    }
    /**
     * Insert newElement as first child inside element
     */
    static prepend(root, newElement) {
        root.insertBefore(newElement, root.firstChild);
    }
    static append(root, newElement) {
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isArray */ .cy)(newElement)) {
            newElement.forEach(node => {
                this.append(root, node);
            });
        }
        else {
            root.appendChild(newElement);
        }
    }
    /**
     * Move all content to another element
     */
    static moveContent(from, to, inStart = false, filter = () => true) {
        const fragment = (from.ownerDocument || jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument).createDocumentFragment();
        (0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_1__/* .toArray */ .$)(from.childNodes)
            .filter(elm => {
            if (filter(elm)) {
                return true;
            }
            Dom.safeRemove(elm);
            return false;
        })
            .forEach((node) => {
            fragment.appendChild(node);
        });
        if (!inStart || !to.firstChild) {
            to.appendChild(fragment);
        }
        else {
            to.insertBefore(fragment, to.firstChild);
        }
    }
    /**
     * Check root contains child or equal child
     */
    static isOrContains(root, child, onlyContains = false) {
        if (root === child) {
            return !onlyContains;
        }
        return Boolean(child && root && this.up(child, nd => nd === root, root, true));
    }
    /**
     * Safe remove element from DOM
     */
    static safeRemove(...nodes) {
        nodes.forEach(node => Dom.isNode(node) &&
            node.parentNode &&
            node.parentNode.removeChild(node));
    }
    static safeInsertNode(range, node) {
        range.collapsed || range.deleteContents();
        const child = Dom.isFragment(node) ? node.lastChild : node;
        if (range.startContainer === range.endContainer &&
            range.collapsed &&
            Dom.isTag(range.startContainer, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INSEPARABLE_TAGS)) {
            Dom.after(range.startContainer, node);
        }
        else {
            range.insertNode(node);
            child && range.setStartBefore(child);
        }
        range.collapse(true);
        // https://developer.mozilla.org/en-US/docs/Web/API/Range/insertNode
        // if the new node is to be added to a text Node, that Node is split at the
        // insertion point, and the insertion occurs between the two text nodes.
        [node.nextSibling, node.previousSibling].forEach(n => Dom.isText(n) && !n.nodeValue && Dom.safeRemove(n));
    }
    /**
     * Hide element
     */
    static hide(node) {
        if (!node) {
            return;
        }
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.dataBind)(node, '__old_display', node.style.display);
        node.style.display = 'none';
    }
    /**
     * Show element
     */
    static show(node) {
        if (!node) {
            return;
        }
        const display = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.dataBind)(node, '__old_display');
        if (node.style.display === 'none') {
            node.style.display = display || '';
        }
    }
    static isTag(node, tagNames) {
        if (!this.isElement(node)) {
            return false;
        }
        const nameL = node.tagName.toLowerCase();
        const nameU = node.tagName.toUpperCase();
        if (tagNames instanceof Set) {
            return tagNames.has(nameL) || tagNames.has(nameU);
        }
        if (Array.isArray(tagNames)) {
            throw new TypeError('Dom.isTag does not support array');
        }
        const tags = tagNames;
        if (nameL === tags || nameU === tags) {
            return true;
        }
        return false;
    }
    /**
     * Marks an item as temporary
     */
    static markTemporary(element, attributes) {
        attributes && (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(element, attributes);
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(element, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEMP_ATTR, true);
        return element;
    }
    /**
     * Check if element is temporary
     */
    static isTemporary(element) {
        if (!Dom.isElement(element)) {
            return false;
        }
        return (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isMarker */ .rg)(element) || (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.attr)(element, jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEMP_ATTR) === 'true';
    }
    /**
     * Replace temporary elements from string
     */
    static replaceTemporaryFromString(value) {
        return value.replace(/<([a-z]+)[^>]+data-jodit-temp[^>]+>(.+?)<\/\1>/gi, '$2');
    }
    /**
     * Get temporary list
     */
    static temporaryList(root) {
        return (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_4__.$$)(`[${jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.TEMP_ATTR}]`, root);
    }
}


/***/ }),

/***/ 55265:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   S: function() { return /* binding */ TextAreaEditor; }
/* harmony export */ });
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38322);
/* harmony import */ var jodit_plugins_source_editor_sourceEditor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53380);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



class TextAreaEditor extends jodit_plugins_source_editor_sourceEditor__WEBPACK_IMPORTED_MODULE_1__/* .SourceEditor */ .F {
    constructor() {
        super(...arguments);
        this.autosize = this.j.async.debounce(() => {
            this.instance.style.height = 'auto';
            this.instance.style.height = this.instance.scrollHeight + 'px';
        }, this.j.defaultTimeout);
    }
    init(editor) {
        this.instance = editor.c.element('textarea', {
            class: 'jodit-source__mirror',
            dir: editor.o.direction === 'rtl' ? 'rtl' : undefined
        });
        this.container.appendChild(this.instance);
        editor.e
            .on(this.instance, 'mousedown keydown touchstart input', editor.async.debounce(this.toWYSIWYG, editor.defaultTimeout))
            .on('setMinHeight.source', (minHeightD) => {
            (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(this.instance, 'minHeight', minHeightD);
        })
            .on(this.instance, 'change keydown mousedown touchstart input', this.autosize)
            .on('afterSetMode.source', this.autosize)
            .on(this.instance, 'mousedown focus', (e) => {
            editor.e.fire(e.type, e);
        });
        this.autosize();
        this.onReady();
    }
    destruct() {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_0__/* .Dom */ .J.safeRemove(this.instance);
    }
    getValue() {
        return this.instance.value;
    }
    setValue(raw) {
        this.instance.value = raw;
    }
    insertRaw(raw) {
        const value = this.getValue();
        if (this.getSelectionStart() >= 0) {
            const startPos = this.getSelectionStart(), endPos = this.getSelectionEnd();
            this.setValue(value.substring(0, startPos) +
                raw +
                value.substring(endPos, value.length));
        }
        else {
            this.setValue(value + raw);
        }
    }
    getSelectionStart() {
        return this.instance.selectionStart;
    }
    getSelectionEnd() {
        return this.instance.selectionEnd;
    }
    setSelectionRange(start, end = start) {
        this.instance.setSelectionRange(start, end);
    }
    get isFocused() {
        return this.instance === this.j.od.activeElement;
    }
    focus() {
        this.instance.focus();
    }
    blur() {
        this.instance.blur();
    }
    setPlaceHolder(title) {
        this.instance.setAttribute('placeholder', title);
    }
    setReadOnly(isReadOnly) {
        if (isReadOnly) {
            this.instance.setAttribute('readonly', 'true');
        }
        else {
            this.instance.removeAttribute('readonly');
        }
    }
    selectAll() {
        this.instance.select();
    }
    replaceUndoManager() {
        const { history } = this.jodit;
        this.j.e.on(this.instance, 'keydown', (e) => {
            if ((e.ctrlKey || e.metaKey) && e.key === 'z') {
                if (e.shiftKey) {
                    history.redo();
                }
                else {
                    history.undo();
                }
                this.setSelectionRange(this.getValue().length);
                return false;
            }
        });
    }
}


/***/ }),

/***/ 55989:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export addNewLine */
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65147);
/* harmony import */ var jodit_modules__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37435);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(84018);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */







const ns = 'addnewline';
/**
 * Create helper for adding new paragraph(Jodit.defaultOptions.enter tag) before iframe, table or image
 */
class addNewLine extends jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Plugin {
    constructor() {
        super(...arguments);
        this.__line = this.j.c.fromHTML(`<div role="button" tabindex="-1" title="${this.j.i18n('Break')}" class="jodit-add-new-line"><span>${jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Icon.get('enter')}</span></div>`);
        this.__isMatchedTag = (node) => Boolean(node &&
            this.j.o.addNewLineTagsTriggers.includes(node.nodeName.toLowerCase()));
        this.__isBeforeContent = false;
        this.__lineInFocus = false;
        this.__isShown = false;
        this.__hideForce = () => {
            if (!this.__isShown) {
                return;
            }
            this.__isShown = false;
            this.j.async.clearTimeout(this.__timeout);
            this.__lineInFocus = false;
            jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.safeRemove(this.__line);
            this.__line.style.setProperty('--jd-anl-handle-offset', '0');
        };
        this.__canGetFocus = (elm) => {
            return (elm != null &&
                jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.isBlock(elm) &&
                !/^(img|table|iframe|hr)$/i.test(elm.nodeName));
        };
        this.__onClickLine = (e) => {
            const editor = this.j;
            const p = editor.createInside.element(editor.o.enter);
            if (this.__isBeforeContent &&
                this.__current &&
                this.__current.parentNode) {
                if (this.__current === editor.editor) {
                    jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.prepend(editor.editor, p);
                }
                else {
                    this.__current.parentNode.insertBefore(p, this.__current);
                }
            }
            else {
                editor.editor.appendChild(p);
            }
            editor.s.setCursorIn(p);
            (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.scrollIntoViewIfNeeded)(p, editor.editor, editor.ed);
            editor.synchronizeValues();
            this.__hideForce();
            e.preventDefault();
        };
    }
    __show() {
        if (this.j.o.readonly || this.j.isLocked) {
            return;
        }
        this.j.async.clearTimeout(this.__timeout);
        if (this.__isShown) {
            return;
        }
        this.__isShown = true;
        this.j.container.appendChild(this.__line);
        this.__line.style.width = this.j.container.clientWidth + 'px';
    }
    onLock(isLocked) {
        if (isLocked && this.__isShown) {
            this.__hideForce();
        }
    }
    __hide() {
        if (!this.__isShown || this.__lineInFocus) {
            return;
        }
        this.__timeout = this.j.async.setTimeout(this.__hideForce, {
            timeout: 500,
            label: 'add-new-line-hide'
        });
    }
    afterInit(editor) {
        if (!editor.o.addNewLine) {
            return;
        }
        editor.e
            .on(this.__line, 'mousemove', (e) => {
            e.stopPropagation();
        })
            .on(this.__line, 'mousedown touchstart', this.__onClickLine)
            .on('change', this.__hideForce)
            .on(this.__line, 'mouseenter', () => {
            this.j.async.clearTimeout(this.__timeout);
            this.__lineInFocus = true;
        })
            .on(this.__line, 'mouseleave', () => {
            this.__lineInFocus = false;
        })
            .on('changePlace', this.__addEventListeners.bind(this));
        this.__addEventListeners();
    }
    __addEventListeners() {
        const editor = this.j;
        editor.e
            .off(editor.editor, '.' + ns)
            .off(editor.container, '.' + ns)
            .off('.' + ns)
            .on([editor.ow, editor.ew, editor.editor], 'scroll' + '.' + ns, this.__hideForce)
            .on('finishedCleanHTMLWorker' + '.' + ns, this.__hideForce)
            .on(editor.editor, 'click' + '.' + ns, this.__hide)
            .on(editor.container, 'mouseleave' + '.' + ns, this.__hide)
            .on(editor.editor, 'mousemove' + '.' + ns, this.__onMouseMove);
    }
    onDblClickEditor(e) {
        const editor = this.j;
        if (!editor.o.readonly &&
            editor.o.addNewLineOnDBLClick &&
            e.target === editor.editor &&
            editor.s.isCollapsed()) {
            const editorBound = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.offset)(editor.editor, editor, editor.ed);
            const top = e.pageY - editor.ew.scrollX;
            const p = editor.createInside.element(editor.o.enter);
            if (Math.abs(top - editorBound.top) <
                Math.abs(top - (editorBound.height + editorBound.top)) &&
                editor.editor.firstChild) {
                editor.editor.insertBefore(p, editor.editor.firstChild);
            }
            else {
                editor.editor.appendChild(p);
            }
            editor.s.setCursorIn(p);
            editor.synchronizeValues();
            this.__hideForce();
            e.preventDefault();
        }
    }
    __onMouseMove(e) {
        const editor = this.j;
        let currentElement = editor.ed.elementFromPoint(e.clientX, e.clientY);
        if (!jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.isHTMLElement(currentElement) ||
            !jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.isOrContains(editor.editor, currentElement)) {
            return;
        }
        if (editor.editor !== currentElement &&
            !this.__isMatchedTag(currentElement)) {
            currentElement = jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.closest(currentElement, this.__isMatchedTag, editor.editor);
        }
        if (!currentElement) {
            this.__hide();
            return;
        }
        if (this.__isMatchedTag(currentElement)) {
            const parentBox = jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.up(currentElement, jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.isBlock, editor.editor);
            if (parentBox && parentBox !== editor.editor) {
                currentElement = parentBox;
            }
        }
        const pos = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.position)(currentElement, this.j);
        let top = false;
        let { clientY, clientX } = e;
        if (this.j.iframe) {
            const { top, left } = (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.position)(this.j.iframe, this.j, true);
            clientY += top;
            clientX += left;
        }
        const delta = this.j.o.addNewLineDeltaShow;
        if (Math.abs(clientY - pos.top) <= delta) {
            top = pos.top;
            this.__isBeforeContent = true;
        }
        else if (Math.abs(clientY - (pos.top + pos.height)) <= delta) {
            top = pos.top + pos.height;
            this.__isBeforeContent = false;
        }
        const isEditor = editor.editor === currentElement;
        if (top !== false &&
            ((isEditor && !this.__isBeforeContent) ||
                (!isEditor &&
                    !(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_2__.call)(this.__isBeforeContent ? jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.prev : jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.next, currentElement, this.__canGetFocus, editor.editor)))) {
            this.__line.style.top = top + 'px';
            this.__current = currentElement;
            this.__show();
            this.__line.style.setProperty('--jd-anl-handle-offset', clientX - pos.left - 10 + 'px');
        }
        else {
            this.__current = false;
            this.__hide();
        }
    }
    /** @override */
    beforeDestruct() {
        this.j.async.clearTimeout(this.__timeout);
        this.j.e.off(this.__line).off('changePlace', this.__addEventListeners);
        jodit_modules__WEBPACK_IMPORTED_MODULE_3__.Dom.safeRemove(this.__line);
        this.j.e
            .off([this.j.ow, this.j.ew, this.j.editor], '.' + ns)
            .off(this.j.container, '.' + ns)
            .off('.' + ns);
    }
}
(0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(':lock')
], addNewLine.prototype, "onLock", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.autobind
], addNewLine.prototype, "__hide", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.watch)(':dblclick')
], addNewLine.prototype, "onDblClickEditor", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_5__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_0__.throttle)(ctx => ctx.defaultTimeout)
], addNewLine.prototype, "__onMouseMove", null);
jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .pluginSystem */ .fg.add('addNewLine', addNewLine);


/***/ }),

/***/ 56014:
/***/ (function(module) {

module.exports["default"] = ["Napiš něco","O Jodit","Editor Jodit","Jodit Uživatelská příručka","obsahuje detailní nápovědu","Pro informace o licenci, prosím, přejděte na naši stránku:","Koupit plnou verzi","Copyright © XDSoft.net - Chupurnov Valeriy. Všechna práva vyhrazena.","Anchor","Otevřít v nové záložce","Otevřít v celoobrazovkovém režimu","Vyčistit formátování","Barva výplně a písma","Vpřed","Zpět","Tučné","Kurzíva","Odrážky","Číslovaný seznam","Zarovnat na střed","Zarovnat do bloku","Zarovnat vlevo","Zarovnat vpravo","Vložit horizontální linku","Vložit obrázek","Vložit soubor","Vložit video (YT/Vimeo)","Vložit odkaz","Velikost písma","Typ písma","Formátovat blok","Normální text","Nadpis 1","Nadpis 2","Nadpis 3","Nadpis 4","Citát","Kód","Vložit","Vložit tabulku","Zmenšit odsazení","Zvětšit odsazení","Vybrat speciální symbol","Vložit speciální symbol","Použít formát","Změnit mód","Okraje","horní","pravý","spodní","levý","Styly","Třídy","Zarovnání","Vpravo","Na střed","Vlevo","--nenastaveno--","src","Titulek","Alternativní text (alt)","Link","Otevřít link v nové záložce","Obrázek","soubor","Rozšířené","Vlastnosti obrázku","Zpět","Ok","Prohlížeč souborů","Chyba při načítání seznamu souborů","Chyba při načítání složek","Jste si jistý(á)?","Název složky","Vytvořit složku","název","Přetáhněte sem obrázek","Přetáhněte sem soubor","nebo klikněte","Alternativní text","Nahrát","Server","Pozadí","Text","Nahoru","Na střed","Dolu","Vložit sloupec před","Vložit sloupec za","Vložit řádek nad","Vložit řádek pod","Vymazat tabulku","Vymazat řádku","Vymazat sloupec","Vyčistit buňku","Znaky: %d","Slova: %d","Přeškrtnuto","Podtrženo","Horní index","Dolní index","Vyjmout označené","Označit vše","Zalomení","Najdi","Nahradit za","Vyměňte","Vložit","Vyber obsah pro vložení","HTML","tučně","kurzíva","štětec","odkaz","zpět","vpřed","tabulka","obrázek","guma","odstavec","velikost písma","video","písmo","о editoru","tisk","podtrženo","přeškrtnuto","zvětšit odsazení","zmenšit odsazení","celoobrazovkový režim","smrsknout","Linka","Odrážka","Číslovaný seznam","Vyjmout","Označit vše","Kód","Otevřít odkaz","Upravit odkaz","Atribut no-follow","Odstranit odkaz","Aktualizovat","Chcete-li upravit","Zobrazit","URL","Editovat","Horizontální zarovnání","Filtr","Dle poslední změny","Dle názvu","Dle velikosti","Přidat složku","Reset","Uložit","Uložit jako...","Změnit rozměr","Ořezat","Šířka","Výška","Ponechat poměr","Ano","Ne","Vyjmout","Označit","Označit %s","Vertikální zarovnání","Rozdělit","Spojit","Přidat sloupec","Přidat řádek","Licence: %s","Vymazat","Rozdělit vertikálně","Rozdělit horizontálně","Okraj","Váš text se podobá HTML. Vložit ho jako HTML?","Vložit jako HTML","Ponechat originál","Vložit jako TEXT","Vložit pouze TEXT","Můžete upravovat pouze své obrázky. Načíst obrázek?","Obrázek byl úspěšně nahrán!","paleta","V tomto adresáři nejsou žádné soubory.","přejmenovat","Zadejte nový název","náhled","Stažení","Vložit ze schránky","Váš prohlížeč nepodporuje přímý přístup do schránky.","Kopírovat výběr","kopírování","Border radius","Zobrazit všechny","Platí","Prosím, vyplňte toto pole","Prosím, zadejte webovou adresu","Výchozí","Kruh","Dot","Quadrate","Najít","Najít Předchozí","Najít Další","Obsah, který vkládáte, je pravděpodobně z Microsoft Word / Excel. Chcete ponechat formát nebo vložit pouze text?","Detekován fragment z Wordu nebo Excelu","Vyčistit","Vložte název třídy","Stiskněte Alt pro vlastní změnu velikosti",null,null,null]

/***/ }),

/***/ 56114:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    symbols: 'symbol'
};


/***/ }),

/***/ 56176:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Z: function() { return /* binding */ applyStyles; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59101);
/* harmony import */ var jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(58720);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/html
 */




function normalizeCSS(s) {
    return s
        .replace(/mso-[a-z-]+:[\s]*[^;]+;/gi, '')
        .replace(/mso-[a-z-]+:[\s]*[^";']+$/gi, '')
        .replace(/border[a-z-]*:[\s]*[^;]+;/gi, '')
        .replace(/([0-9.]+)(pt|cm)/gi, (match, units, metrics) => {
        switch (metrics.toLowerCase()) {
            case 'pt':
                return (parseFloat(units) * 1.328).toFixed(0) + 'px';
            case 'cm':
                return (parseFloat(units) * 0.02645833).toFixed(0) + 'px';
        }
        return match;
    });
}
/**
 * If the HTML has CSS rules with selectors,
 * it applies them to the selectors in the HTML itself
 * and then removes the selector styles, leaving only the inline ones.
 */
function applyStyles(html) {
    if (html.indexOf('<html ') === -1) {
        return html;
    }
    html = html.substring(html.indexOf('<html '), html.length);
    html = html.substring(0, html.lastIndexOf('</html>') + '</html>'.length);
    const iframe = jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.createElement('iframe');
    iframe.style.display = 'none';
    jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalDocument.body.appendChild(iframe);
    let convertedString = '', collection = [];
    try {
        const iframeDoc = iframe.contentDocument ||
            (iframe.contentWindow ? iframe.contentWindow.document : null);
        if (iframeDoc) {
            iframeDoc.open();
            iframeDoc.write(html);
            iframeDoc.close();
            try {
                for (let i = 0; i < iframeDoc.styleSheets.length; i += 1) {
                    const rules = iframeDoc.styleSheets[i].cssRules;
                    for (let idx = 0; idx < rules.length; idx += 1) {
                        if (rules[idx].selectorText === '') {
                            continue;
                        }
                        collection = (0,jodit_core_helpers_utils_selector__WEBPACK_IMPORTED_MODULE_3__.$$)(rules[idx].selectorText, iframeDoc.body);
                        collection.forEach((elm) => {
                            elm.style.cssText = normalizeCSS(rules[idx].style.cssText +
                                ';' +
                                elm.style.cssText);
                        });
                    }
                }
            }
            catch (e) {
                if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                    throw e;
                }
            }
            jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.each(iframeDoc.body, node => {
                if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(node)) {
                    const elm = node;
                    const css = elm.getAttribute('style');
                    if (css) {
                        elm.style.cssText = normalizeCSS(css);
                    }
                    if (elm.hasAttribute('style') &&
                        !elm.getAttribute('style')) {
                        elm.removeAttribute('style');
                    }
                }
            });
            convertedString = iframeDoc.firstChild
                ? (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__/* .trim */ .Bq)(iframeDoc.body.innerHTML)
                : '';
        }
    }
    catch (_a) {
    }
    finally {
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.safeRemove(iframe);
    }
    if (convertedString) {
        html = convertedString;
    }
    return (0,jodit_core_helpers_string_trim__WEBPACK_IMPORTED_MODULE_2__/* .trim */ .Bq)(html
        .replace(/<(\/)?(html|colgroup|col|o:p)[^>]*>/g, '')
        .replace(/<!--[^>]*>/g, ''));
}


/***/ }),

/***/ 56298:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   JW: function() { return /* binding */ extendLang; },
/* harmony export */   My: function() { return /* binding */ getContainer; },
/* harmony export */   RR: function() { return /* binding */ eventEmitter; },
/* harmony export */   VF: function() { return /* binding */ instances; },
/* harmony export */   av: function() { return /* binding */ modules; },
/* harmony export */   ef: function() { return /* binding */ getPopupViewRoot; },
/* harmony export */   fg: function() { return /* binding */ pluginSystem; },
/* harmony export */   w9: function() { return /* binding */ uniqueUid; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(83044);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(12041);
/* harmony import */ var jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(449);
/* harmony import */ var jodit_core_helpers_utils_get_class_name__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75766);
/* harmony import */ var jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(77402);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(17352);
/* harmony import */ var _dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(71842);
/* harmony import */ var _event_emitter__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(50025);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */










const instances = {};
let counter = 1;
const uuids = new Set();
/**
 * Generate global unique uid
 */
function uniqueUid() {
    function gen() {
        counter += 10 * (Math.random() + 1);
        return Math.round(counter).toString(16);
    }
    let uid = gen();
    while (uuids.has(uid)) {
        uid = gen();
    }
    uuids.add(uid);
    return uid;
}
const pluginSystem = new jodit_core_plugin_plugin_system__WEBPACK_IMPORTED_MODULE_2__/* .PluginSystem */ .$();
const modules = {};
const extendLang = (langs) => {
    Object.keys(langs).forEach(key => {
        if (_constants__WEBPACK_IMPORTED_MODULE_3__.lang[key]) {
            Object.assign(_constants__WEBPACK_IMPORTED_MODULE_3__.lang[key], langs[key]);
        }
        else {
            _constants__WEBPACK_IMPORTED_MODULE_3__.lang[key] = langs[key];
        }
    });
};
const boxes = new WeakMap();
/**
 * Create unique box(HTMLCotainer) and remove it after destroy
 */
function getContainer(jodit, classFunc, tag = 'div', createInsideEditor = false) {
    const name = (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_6__/* .isString */ .K)(classFunc)
        ? classFunc
        : classFunc
            ? (0,jodit_core_helpers_utils_get_class_name__WEBPACK_IMPORTED_MODULE_1__/* .getClassName */ .u)(classFunc.prototype)
            : 'jodit-utils';
    const data = boxes.get(jodit) || {}, key = name + tag;
    const view = (0,jodit_core_helpers_checker_is_view_object__WEBPACK_IMPORTED_MODULE_7__/* .isViewObject */ .h)(jodit) ? jodit : jodit.j;
    let body = null;
    if (!data[key]) {
        let c = view.c;
        body = getPopupViewRoot(view.o, view.container, jodit.od.body);
        if (createInsideEditor &&
            (0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_8__/* .isJoditObject */ .y)(jodit) &&
            jodit.od !== jodit.ed) {
            c = jodit.createInside;
            const place = tag === 'style' ? jodit.ed.head : jodit.ed.body;
            body =
                (0,jodit_core_helpers_checker_is_jodit_object__WEBPACK_IMPORTED_MODULE_8__/* .isJoditObject */ .y)(jodit) && jodit.o.shadowRoot
                    ? jodit.o.shadowRoot
                    : place;
        }
        const box = c.element(tag, {
            className: `jodit jodit-${(0,jodit_core_helpers_string_kebab_case__WEBPACK_IMPORTED_MODULE_9__/* .kebabCase */ .k)(name)}-container jodit-box`
        });
        box.classList.add(`jodit_theme_${view.o.theme || 'default'}`);
        body.appendChild(box);
        data[key] = box;
        jodit.hookStatus('beforeDestruct', () => {
            view.events.off(box);
            _dom__WEBPACK_IMPORTED_MODULE_4__/* .Dom */ .J.safeRemove(box);
            delete data[key];
            if (Object.keys(data).length) {
                boxes.delete(jodit);
            }
        });
        boxes.set(jodit, data);
        view.events.fire('getContainer', box);
    }
    data[key].classList.remove('jodit_theme_default', 'jodit_theme_dark');
    data[key].classList.add(`jodit_theme_${view.o.theme || 'default'}`);
    return data[key];
}
/**
 * Get root element for view
 * @internal
 */
function getPopupViewRoot(o, container, defaultRoot) {
    var _a, _b, _c;
    return ((_c = (_b = (_a = o.popupRoot) !== null && _a !== void 0 ? _a : o.shadowRoot) !== null && _b !== void 0 ? _b : _dom__WEBPACK_IMPORTED_MODULE_4__/* .Dom */ .J.closest(container, parentElement => _dom__WEBPACK_IMPORTED_MODULE_4__/* .Dom */ .J.isHTMLElement(parentElement) &&
        (_dom__WEBPACK_IMPORTED_MODULE_4__/* .Dom */ .J.isTag(parentElement, 'dialog') ||
            ['fixed', 'absolute'].includes((0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.css)(parentElement, 'position'))), defaultRoot)) !== null && _c !== void 0 ? _c : defaultRoot);
}
/**
 * Global event emitter
 */
const eventEmitter = new _event_emitter__WEBPACK_IMPORTED_MODULE_5__/* .EventEmitter */ .bk();


/***/ }),

/***/ 57023:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   U: function() { return /* binding */ getControlType; },
/* harmony export */   x: function() { return /* binding */ findControlType; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65147);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Get control for button name
 * @private
 */
function getControlType(button, controls) {
    let buttonControl;
    if (!controls) {
        controls = jodit_config__WEBPACK_IMPORTED_MODULE_1__/* .Config */ .T.defaultOptions.controls;
    }
    if (!(0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.isString)(button)) {
        buttonControl = Object.assign({ name: 'empty' }, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.ConfigFlatten)(button));
        if (controls[buttonControl.name] !== undefined) {
            buttonControl = Object.assign(Object.assign({}, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.ConfigFlatten)(controls[buttonControl.name])), (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.ConfigFlatten)(buttonControl));
        }
    }
    else {
        buttonControl = findControlType(button, controls) || {
            name: button,
            command: button,
            tooltip: button
        };
    }
    return buttonControl;
}
/**
 * @private
 */
function findControlType(path, controls) {
    // eslint-disable-next-line prefer-const
    let [namespaceOrKey, key] = path.split(/\./);
    let store = controls;
    if (key != null) {
        if (controls[namespaceOrKey] !== undefined) {
            store = controls[namespaceOrKey];
        }
    }
    else {
        key = namespaceOrKey;
    }
    // const list = store[key]?.list;
    return store[key]
        ? Object.assign({ name: key }, (0,jodit_core_helpers__WEBPACK_IMPORTED_MODULE_0__.ConfigFlatten)(store[key])
        // list: isArray(list)
        // 	? (<Array<string>>list).reduce(
        // 			(
        // 				acc: IDictionary<string | number>,
        // 				k: string | number
        // 			) => {
        // 				acc[String(k)] = k;
        // 				return acc;
        // 			},
        // 			{}
        // 		)
        // 	: list
        ) : undefined;
}


/***/ }),

/***/ 57032:
/***/ (function(module) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
module.exports = {
    'copy-format': 'Copiar formato'
};


/***/ }),

/***/ 57456:
/***/ (function(module) {

module.exports["default"] = ["Напишіть щось","Про Jodit","Редактор Jodit","Jodit інструкція користувача","містить детальну інформацію щодо користування","Щоб дізнатись більше про ліцензію , будь ласка, перейдіть на наш сайт:","Купити повну версію","Авторські права © XDSoft.net - Чупурнов Валерій. Всі права захищені.","Анкор","Відкрити у новій вкладці","Відкрити редактор в повному розмірі","Очистити форматування","Колір заливки або колір текста","Повторити","Відмінити","Жирний","Курсів","Вставити невпорядкований список","Вставити нумерованний список","Вирівняти по центру","Вирівняти по ширині","Вирівняти по лівому краю","Вирівняти по правому краю","Вставити горизонтальну лінію","Вставити зображення","Вставити файл","Вставити відео","Вставити посилання","Розмір шрифту","Шрифт","Вставити блочний елемент","Нормальний текст","Заголовок 1","Заголовок 2","Заголовок 3","Заголовок 4","Цитата","Код","Вставити","Вставити таблицю","Збільшити відступ","Зменшити відступ","Оберіть спеціальный символ","Вставити спеціальный символ","Формат краски","Джерело","Відступи","зверху","справа","знизу","зліва","Стилі","Класи","Вирівнювання","По правому краю","По центру","По лівому краю","--не встановлено--","src","Заголовок","Альтернативний текст (alt)","Посилання","Відкрити посилання в новій вкладці",null,"Файл","Розширені","Властивості зображення","Відміна","Ок","Браузер файлів","Помилка при завантаженні списку зображень","Помилка при завантаженні списку папок","Ви впевнені?","Введіть назву папки","Створити папку","введіть назву","Перетягніть зображення сюди","Перетягніть файл сюди","або клікніть","Альтернативный текст","Завантаження","Сервер","Фон","Текст"," Вгору","По центру","Донизу","Вставити стовпець до","Вставити стовпець після","Вставити рядок вище","Вставити рядок нижче","Видалити таблицю","Видалити рядок","Видалити стовпчик","Очистити кліинку","Символів: %d","Слів: %d","Закреслений","Підкреслений","верхній індекс","індекс","Обрізати вибране","Вибрати все","Межа","Шукати","Замінити на","Замінити","Вставити","Обрати контент для вставки","HTML","жирний","курсів","заливка","посилання","відмінити","повторити","таблиця","зображення","видалення","параграф","розмір шрифту","відео","шрифт","про редактор","друк","підкреслений","закреслений","відступ","заступ","на весь екран","звичайний розмір","лінія","Список","Нумерований список","Вирізати","Виділити все","Код","Відкрити посилання","Редагувати посилання","Атрибут nofollow","Видалити посилання","Оновити","Редагування","Перегляд","URL","Редагувати","Горизонтальне вирівнювання","Фільтр","Сортувати за зміною","Сортувати за ім'ям","Сортувати за розміром","Додати папку","Відновити","Зберегти","Зберегти як","Змінити розмір","Обрізати розмір","Ширина","Висота","Зберегти пропорції","Так","Ні","Видалити","Вибрати","Вибрати: %s","Вертикальне вирівнювання","Розділити","Об'єднати в одну","Додати стовпчик","Додати рядок","Ліцензія: %s","Видалити","Розділити по вертикалі","Розділити по горизонталі","Рамка","Текст, який Ви намагаєтесь вставити схожий на HTML. Вставити його як HTML?","Вставити його як HTML","Зберегти оригінал","Вставити як текст","Вставити тільки текст","Ви можете редагувати лише власні зображення. Завантажити зображення на ваш сервер?","Зображення успішно завантажено на сервер!","палітра","Файли відсутні","Змінити назву","Введіть нове імя'","Попередній перегляд","Завантажити","Вставити з буфера обміну","Ваш браузер не підтримує доступ до буфера обміну.","Копіювати виділене","копія","Радіус рамки","Показати все","Застосувати","Будь ласка, заповніть це поле","Будь ласка, введіть веб-адресу","За замовченням","Коло","Крапка","Квадрат","Знайти","Знайти попередні","Знайти наступні","Ви вставляєте контент з документа Microsoft Word або Excel. Бажаєте зберегти форматування?","Можливо це фрагмент Word або Excel","Почистити","Вставити клас","Натисніть Alt для зміни розміру",null,null,null]

/***/ }),

/***/ 58006:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   l: function() { return /* binding */ Dialog; }
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(31635);
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22664);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(32709);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(97369);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(28712);
/* harmony import */ var jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(jodit_core_helpers_utils_assert__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var jodit_core_ui__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(53048);
/* harmony import */ var jodit_core_view_view__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(77782);
/* harmony import */ var jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(14961);
/* harmony import */ var jodit_config__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(36115);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var Dialog_1;















jodit_config__WEBPACK_IMPORTED_MODULE_12__/* .Config */ .T.prototype.dialog = {
    namespace: '',
    extraButtons: [],
    /**
     * This dialog can resize by trigger
     */
    resizable: true,
    /**
     * This dialog can move by header
     */
    draggable: true,
    buttons: ['dialog.close'],
    removeButtons: [],
    toolbarButtonSize: 'middle',
    zIndex: 'inherit'
};
jodit_config__WEBPACK_IMPORTED_MODULE_12__/* .Config */ .T.prototype.controls.dialog = {
    close: {
        icon: 'cancel',
        exec: dialog => {
            dialog.close();
        }
    }
};
/**
 * Module to generate dialog windows
 */
let Dialog = Dialog_1 = class Dialog extends jodit_core_view_view_with_toolbar__WEBPACK_IMPORTED_MODULE_11__/* .ViewWithToolbar */ .T {
    /** @override */
    className() {
        return 'Dialog';
    }
    get destination() {
        const { popupRoot, shadowRoot } = this.o;
        if (popupRoot) {
            return popupRoot;
        }
        if (shadowRoot) {
            return shadowRoot;
        }
        return this.od.body;
    }
    setElements(root, elements) {
        const elements_list = [];
        (0,jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_5__/* .asArray */ ._j)(elements).forEach((elm) => {
            if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isArray */ .cy)(elm)) {
                const div = this.c.div(this.getFullElName('column'));
                elements_list.push(div);
                root.appendChild(div);
                return this.setElements(div, elm);
            }
            let element;
            if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isString */ .Kg)(elm)) {
                element = this.c.fromHTML(elm);
            }
            else {
                element = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .hasContainer */ .kO)(elm) ? elm.container : elm;
            }
            elements_list.push(element);
            if (element.parentNode !== root) {
                root.appendChild(element);
            }
        });
        (0,jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_5__/* .toArray */ .$r)(root.childNodes).forEach((elm) => {
            if (elements_list.indexOf(elm) === -1) {
                root.removeChild(elm);
            }
        });
    }
    __onMouseUp() {
        if (this.draggable || this.resizable) {
            this.__removeGlobalResizeListeners();
            this.draggable = false;
            this.resizable = false;
            this.unlockSelect();
            if (this.e) {
                this.__removeGlobalResizeListeners();
                /**
                 * Fired when the dialog box is finished to resizing
                 */
                this.e.fire(this, 'endResize endMove');
            }
        }
    }
    /**
     *
     */
    __onHeaderMouseDown(e) {
        const target = e.target;
        if (!this.o.draggable ||
            (target && target.nodeName.match(/^(INPUT|SELECT)$/))) {
            return;
        }
        this.draggable = true;
        this.startX = e.clientX;
        this.startY = e.clientY;
        this.startPoint.x = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(this.dialog, 'left');
        this.startPoint.y = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(this.dialog, 'top');
        this.setMaxZIndex();
        if (e.cancelable) {
            e.preventDefault();
        }
        this.lockSelect();
        this.__addGlobalResizeListeners();
        if (this.e) {
            /**
             * Fired when dialog box is started moving
             */
            this.e.fire(this, 'startMove');
            this.e.fire('closeAllPopups');
        }
    }
    __onMouseMove(e) {
        if (this.draggable && this.o.draggable) {
            this.setPosition(this.startPoint.x + e.clientX - this.startX, this.startPoint.y + e.clientY - this.startY);
            if (this.e) {
                /**
                 * Fired when dialog box is moved
                 */
                this.e.fire(this, 'move', e.clientX - this.startX, e.clientY - this.startY);
            }
            e.stopImmediatePropagation();
        }
        if (this.resizable && this.o.resizable) {
            this.setSize(this.startPoint.w + e.clientX - this.startX, this.startPoint.h + e.clientY - this.startY);
            if (this.e) {
                /**
                 * Fired when dialog box is resized
                 */
                this.e.fire(this, 'resizeDialog', e.clientX - this.startX, e.clientY - this.startY);
            }
        }
    }
    __onEsc(e) {
        if (!this.o.closeOnEsc) {
            return;
        }
        if (this.isOpened &&
            e.key === jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.KEY_ESC &&
            this.getMod('static') !== true) {
            const me = this.getMaxZIndexDialog();
            if (me) {
                me.close();
            }
            else {
                this.close();
            }
            e.stopImmediatePropagation();
        }
    }
    __onResizerMouseDown(e) {
        this.resizable = true;
        this.startX = e.clientX;
        this.startY = e.clientY;
        this.startPoint.w = this.dialog.offsetWidth;
        this.startPoint.h = this.dialog.offsetHeight;
        this.lockSelect();
        this.__addGlobalResizeListeners();
        if (this.e) {
            /**
             * Fired when dialog box is started resizing
             */
            this.e.fire(this, 'startResize');
        }
    }
    __addGlobalResizeListeners() {
        const self = this;
        self.e
            .on(self.ow, 'pointermove touchmove', self.__onMouseMove)
            .on(self.ow, 'pointerup touchend', self.__onMouseUp);
    }
    __removeGlobalResizeListeners() {
        const self = this;
        self.e
            .off(self.ow, 'mousemove pointermove', self.__onMouseMove)
            .off(self.ow, 'mouseup pointerup', self.__onMouseUp);
    }
    /**
     * Specifies the size of the window
     *
     * @param w - The width of the window
     * @param h - The height of the window
     */
    setSize(w, h) {
        if (w == null) {
            w = this.dialog.offsetWidth;
        }
        if (h == null) {
            h = this.dialog.offsetHeight;
        }
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(this.dialog, {
            width: w,
            height: h
        });
        return this;
    }
    /**
     * Recalculate auto sizes
     */
    calcAutoSize() {
        this.setSize('auto', 'auto');
        this.setSize();
        return this;
    }
    /**
     * Specifies the position of the upper left corner of the window . If x and y are specified,
     * the window is centered on the center of the screen
     *
     * @param x - Position px Horizontal
     * @param y - Position px Vertical
     */
    setPosition(x, y) {
        const w = this.ow.innerWidth, h = this.ow.innerHeight;
        let left = w / 2 - this.dialog.offsetWidth / 2, top = h / 2 - this.dialog.offsetHeight / 2;
        if (left < 0) {
            left = 0;
        }
        if (top < 0) {
            top = 0;
        }
        if (x !== undefined && y !== undefined) {
            this.offsetX = x;
            this.offsetY = y;
            this.moved = Math.abs(x - left) > 100 || Math.abs(y - top) > 100;
        }
        this.dialog.style.left = (x || left) + 'px';
        this.dialog.style.top = (y || top) + 'px';
        return this;
    }
    /**
     * Specifies the dialog box title . It can take a string and an array of objects
     *
     * @param content - A string or an HTML element ,
     * or an array of strings and elements
     * @example
     * ```javascript
     * var dialog = new Jodi.modules.Dialog(parent);
     * dialog.setHeader('Hello world');
     * dialog.setHeader(['Hello world', '<button>OK</button>', $('<div>some</div>')]);
     * dialog.open();
     * ```
     */
    setHeader(content) {
        this.setElements(this.dialogbox_header, content);
        return this;
    }
    /**
     * It specifies the contents of the dialog box. It can take a string and an array of objects
     *
     * @param content - A string or an HTML element ,
     * or an array of strings and elements
     * @example
     * ```javascript
     * var dialog = new Jodi.modules.Dialog(parent);
     * dialog.setHeader('Hello world');
     * dialog.setContent('<form onsubmit="alert(1);"><input type="text" /></form>');
     * dialog.open();
     * ```
     */
    setContent(content) {
        this.setElements(this.dialogbox_content, content);
        return this;
    }
    /**
     * Sets the bottom of the dialog. It can take a string and an array of objects
     *
     * @param content - A string or an HTML element ,
     * or an array of strings and elements
     * @example
     * ```javascript
     * var dialog = new Jodi.modules.Dialog(parent);
     * dialog.setHeader('Hello world');
     * dialog.setContent('<form><input id="someText" type="text" /></form>');
     * dialog.setFooter([
     *  $('<a class="jodit-button">OK</a>').click(function () {
     *      alert($('someText').val())
     *      dialog.close();
     *  })
     * ]);
     * dialog.open();
     * ```
     */
    setFooter(content) {
        this.setElements(this.dialogbox_footer, content);
        this.setMod('footer', Boolean(content));
        return this;
    }
    /**
     * Get zIndex from dialog
     */
    getZIndex() {
        return parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(this.container, 'zIndex'), 10) || 0;
    }
    /**
     * Get dialog instance with maximum z-index displaying it on top of all the dialog boxes
     */
    getMaxZIndexDialog() {
        let maxZi = 0, dlg, zIndex, res = this;
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.$$)('.jodit-dialog', this.destination).forEach((dialog) => {
            dlg = dialog.component;
            zIndex = parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(dialog, 'zIndex'), 10);
            if (dlg.isOpened && !isNaN(zIndex) && zIndex > maxZi) {
                res = dlg;
                maxZi = zIndex;
            }
        });
        return res;
    }
    /**
     * Sets the maximum z-index dialog box, displaying it on top of all the dialog boxes
     */
    setMaxZIndex() {
        if (this.getMod('static'))
            return;
        let maxZIndex = 20000004, zIndex = 0;
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.$$)('.jodit-dialog', this.destination).forEach(dialog => {
            zIndex = parseInt((0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(dialog, 'zIndex'), 10);
            maxZIndex = Math.max(isNaN(zIndex) ? 0 : zIndex, maxZIndex);
        });
        this.container.style.zIndex = (maxZIndex + 1).toString();
    }
    /**
     * Expands the dialog on full browser window
     */
    toggleFullSize(isFullSize) {
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isVoid */ .Rd)(isFullSize)) {
            isFullSize = !this.getMod('fullsize');
        }
        this.setMod('fullsize', isFullSize);
        super.toggleFullSize(isFullSize);
    }
    /**
     * It opens a dialog box to center it, and causes the two event.
     *
     * @param contentOrClose - specifies the contents of the dialog box.
     * Can be false or undefined. see [[Dialog.setContent]]
     * @param title - specifies the title of the dialog box, @see setHeader
     * @param destroyAfterClose - true - After closing the window , the destructor will be called.
     * @param modal - true window will be opened in modal mode
     */
    open(contentOrClose, titleOrModal, destroyAfterClose, modal) {
        jodit_core_global__WEBPACK_IMPORTED_MODULE_4__/* .eventEmitter */ .RR.fire('closeAllPopups hideHelpers');
        /**
         * Called before the opening of the dialog box
         */
        if (this.e.fire(this, 'beforeOpen') === false) {
            return this;
        }
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isBoolean */ .Lm)(contentOrClose)) {
            destroyAfterClose = contentOrClose;
        }
        if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isBoolean */ .Lm)(titleOrModal)) {
            modal = titleOrModal;
        }
        this.destroyAfterClose = destroyAfterClose === true;
        const content = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isBoolean */ .Lm)(contentOrClose) ? undefined : contentOrClose;
        const title = (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isBoolean */ .Lm)(titleOrModal) ? undefined : titleOrModal;
        if (title !== undefined) {
            this.setHeader(title);
        }
        if (content) {
            this.setContent(content);
        }
        this.setMod('active', true);
        this.isOpened = true;
        this.setModal(modal);
        this.destination.appendChild(this.container);
        if (this.getMod('static') !== true) {
            this.setPosition(this.offsetX, this.offsetY);
            this.setMaxZIndex();
        }
        else {
            this.container.style.removeProperty('z-index');
        }
        if (this.o.fullsize) {
            this.toggleFullSize(true);
        }
        /**
         * Called after the opening of the dialog box
         */
        this.e.fire('afterOpen', this);
        return this;
    }
    /**
     * Set modal mode
     */
    setModal(modal) {
        this.isModal = Boolean(modal);
        this.setMod('modal', this.isModal);
        return this;
    }
    /****
     * Closes the dialog box , if you want to call the method `destruct`
     *
     * @see destroy
     * @example
     * ```javascript
     * //You can close dialog two ways
     * var dialog = new Jodit.modules.Dialog();
     * dialog.open('Hello world!', 'Title');
     * var $close = dialog.create.fromHTML('<a href="#" style="float:left;" class="jodit-button">
     *     <i class="icon icon-check"></i>&nbsp;' + Jodit.prototype.i18n('Ok') + '</a>');
     * $close.addEventListener('click', function () {
     *     dialog.close();
     * });
     * dialog.setFooter($close);
     * // and second way, you can close dialog from content
     * dialog.open('<a onclick="var event = doc.createEvent('HTMLEvents'); event.initEvent('close_dialog', true, true);
     * this.dispatchEvent(event)">Close</a>', 'Title');
     * ```
     */
    close() {
        if (this.isDestructed ||
            !this.isOpened ||
            this.getMod('static') === true) {
            return this;
        }
        const { e } = this;
        /**
         * Called up to close the window
         */
        if (e.fire(this, 'beforeClose') === false ||
            e.fire('beforeClose', this) === false) {
            return this;
        }
        this.setMod('active', false);
        this.isOpened = false;
        if (this.isFullSize) {
            this.toggleFullSize(false);
        }
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(this.container);
        this.__removeGlobalResizeListeners();
        /**
         * It called after the window is closed
         */
        e.fire(this, 'afterClose');
        e.fire(this.ow, 'joditCloseDialog');
        if (this.destroyAfterClose) {
            this.destruct();
        }
        return this;
    }
    constructor(options = {}) {
        super(options);
        this.destroyAfterClose = false;
        this.moved = false;
        this.resizable = false;
        this.draggable = false;
        this.startX = 0;
        this.startY = 0;
        this.startPoint = { x: 0, y: 0, w: 0, h: 0 };
        this.lockSelect = () => {
            this.setMod('moved', true);
        };
        this.unlockSelect = () => {
            this.setMod('moved', false);
        };
        this.__onResize = () => {
            if (this.options &&
                this.o.resizable &&
                !this.moved &&
                this.isOpened &&
                !this.offsetX &&
                !this.offsetY) {
                this.setPosition();
            }
        };
        this.isModal = false;
        /**
         * True, if dialog was opened
         */
        this.isOpened = false;
        const self = this;
        self.options = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.ConfigProto)(options, (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.ConfigProto)(jodit_config__WEBPACK_IMPORTED_MODULE_12__/* .Config */ .T.prototype.dialog, Dialog_1.defaultOptions));
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_3__/* .Dom */ .J.safeRemove(self.container);
        const n = this.getFullElName.bind(this);
        self.container = this.c.fromHTML(`<div class="jodit jodit-dialog ${this.componentName}">
				<div class="${n('overlay')}"></div>
				<div class="${this.getFullElName('panel')}">
					<div class="${n('header')}">
						<div class="${n('header-title')}"></div>
						<div class="${n('header-toolbar')}"></div>
					</div>
					<div class="${n('content')}"></div>
					<div class="${n('footer')}"></div>
					<div class="${n('resizer')}">${jodit_core_ui__WEBPACK_IMPORTED_MODULE_9__/* .Icon */ .In.get('resize_handler')}</div>
				</div>
			</div>`);
        if (self.options.direction === 'rtl') {
            self.container.style.direction = 'rtl';
            self.container.setAttribute('dir', 'rtl');
        }
        if (this.o.zIndex) {
            this.container.style.zIndex = this.o.zIndex.toString();
        }
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.attr)(self.container, 'role', 'dialog');
        Object.defineProperty(self.container, 'component', {
            value: this
        });
        self.setMod('theme', self.o.theme || 'default').setMod('resizable', Boolean(self.o.resizable));
        const dialog = self.getElm('panel');
        void 0;
        const resizer = self.getElm('resizer');
        void 0;
        const dialogbox_header = self.getElm('header-title');
        void 0;
        const dialogbox_content = self.getElm('content');
        void 0;
        const dialogbox_footer = self.getElm('footer');
        void 0;
        const dialogbox_toolbar = self.getElm('header-toolbar');
        void 0;
        this.dialog = dialog;
        this.resizer = resizer;
        this.dialogbox_header = dialogbox_header;
        this.dialogbox_content = dialogbox_content;
        this.dialogbox_footer = dialogbox_footer;
        this.dialogbox_toolbar = dialogbox_toolbar;
        (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_7__.css)(self.dialog, {
            maxWidth: self.options.maxWidth,
            minHeight: self.options.minHeight,
            minWidth: self.options.minWidth
        });
        const headerBox = self.getElm('header');
        headerBox &&
            self.e.on(headerBox, 'pointerdown touchstart', self.__onHeaderMouseDown);
        self.e.on(self.resizer, 'mousedown touchstart', self.__onResizerMouseDown);
        const fullSize = jodit_core_global__WEBPACK_IMPORTED_MODULE_4__/* .pluginSystem */ .fg.get('fullsize');
        (0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_6__/* .isFunction */ .Tn)(fullSize) && fullSize(self);
        this.e
            .on(self.container, 'close_dialog', self.close)
            .on(this.ow, 'keydown', this.__onEsc)
            .on(this.ow, 'resize', this.__onResize);
        if (this.o.closeOnClickOverlay) {
            const overlay = self.getElm('overlay');
            void 0;
            this.e.on(overlay, 'click', self.close);
        }
    }
    /**
     * Build toolbar after ready
     */
    buildToolbar() {
        this.o.buttons &&
            this.toolbar
                .build((0,jodit_core_helpers_array__WEBPACK_IMPORTED_MODULE_5__/* .splitArray */ .uM)(this.o.buttons))
                .setMod('mode', 'header')
                .appendTo(this.dialogbox_toolbar);
    }
    /**
     * It destroys all objects created for the windows and also includes all the handlers for the window object
     */
    destruct() {
        if (this.isInDestruct) {
            return;
        }
        this.setStatus(jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .STATUSES */ .f.beforeDestruct);
        if (this.isOpened) {
            this.close();
        }
        if (this.events) {
            this.__removeGlobalResizeListeners();
            this.events
                .off(this.container, 'close_dialog', self.close)
                .off(this.ow, 'keydown', this.__onEsc)
                .off(this.ow, 'resize', this.__onResize);
        }
        super.destruct();
    }
};
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], Dialog.prototype, "__onMouseUp", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], Dialog.prototype, "__onHeaderMouseDown", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], Dialog.prototype, "__onMouseMove", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], Dialog.prototype, "__onEsc", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], Dialog.prototype, "__onResizerMouseDown", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.autobind
], Dialog.prototype, "close", null);
(0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    (0,jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.hook)('ready')
], Dialog.prototype, "buildToolbar", null);
Dialog = Dialog_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_13__/* .__decorate */ .Cg)([
    jodit_core_decorators__WEBPACK_IMPORTED_MODULE_2__.component
], Dialog);

Dialog.defaultOptions = Object.assign(Object.assign({}, jodit_core_view_view__WEBPACK_IMPORTED_MODULE_10__/* .View */ .S.defaultOptions), { closeOnClickOverlay: false, closeOnEsc: true });


/***/ }),

/***/ 58157:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   k: function() { return /* binding */ makeInstance; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69052);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */


/**
 * Create instance of plugin
 * @private
 */
function makeInstance(jodit, plugin) {
    try {
        try {
            // @ts-ignore
            return (0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__/* .isFunction */ .T)(plugin) ? new plugin(jodit) : plugin;
        }
        catch (e) {
            if ((0,jodit_core_helpers_checker_is_function__WEBPACK_IMPORTED_MODULE_1__/* .isFunction */ .T)(plugin) && !plugin.prototype) {
                return plugin(jodit);
            }
        }
    }
    catch (e) {
        console.error(e);
        if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
            throw e;
        }
    }
    return null;
}


/***/ }),

/***/ 58269:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   T: function() { return /* binding */ init; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9823);
/* harmony import */ var _load__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(32291);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




/**
 * Init plugin if it has no dependencies, in another case wait requires plugins will be init
 * @private
 */
function init(jodit, pluginName, plugin, instance, doneList, waitingList) {
    if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_2__/* .isInitable */ .Gp)(instance)) {
        try {
            instance.init(jodit);
        }
        catch (e) {
            console.error(e);
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD) {
                throw e;
            }
        }
    }
    doneList.set(pluginName, instance);
    waitingList.delete(pluginName);
    if (instance.hasStyle) {
        (0,_load__WEBPACK_IMPORTED_MODULE_3__/* .loadStyle */ .M)(jodit, pluginName).catch(e => {
            !jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_PROD && console.error(e);
        });
    }
    if (instance.styles) {
        const style = (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_1__/* .getContainer */ .My)(jodit, pluginName, 'style');
        style.innerHTML = instance.styles;
    }
}


/***/ }),

/***/ 58446:
/***/ (function(module) {

module.exports = "<svg xmlns='http://www.w3.org/2000/svg' viewBox=\"0 0 1792 1792\"> <path d=\"M1395 1184q0 13-10 23l-50 50q-10 10-23 10t-23-10l-393-393-393 393q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l466-466q10-10 23-10t23 10l466 466q10 10 10 23z\"/> </svg>"

/***/ }),

/***/ 58540:
/***/ (function(__unused_webpack_module, __webpack_exports__) {

"use strict";
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/inline-popup
 */
/* harmony default export */ __webpack_exports__.A = ([
    'bold',
    'italic',
    '|',
    'ul',
    'ol',
    'eraser',
    '|',
    'fontsize',
    'brush',
    'paragraph',
    '---',
    'image',
    'table',
    '\n',
    'link',
    '|',
    'align',
    '|',
    'undo',
    'redo',
    '|',
    'copyformat',
    'fullsize',
    '---',
    'dots'
]);


/***/ }),

/***/ 58597:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   z: function() { return /* binding */ Dlgs; }
/* harmony export */ });
/* harmony import */ var jodit_core_global__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56298);
/* harmony import */ var jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9823);
/* harmony import */ var jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(84976);
/* harmony import */ var jodit_modules_dialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34256);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */




class Dlgs {
    dlg(options) {
        const popupRoot = (0,jodit_core_global__WEBPACK_IMPORTED_MODULE_0__/* .getPopupViewRoot */ .ef)(this.o, this.container, this.od.body);
        const dialog = new jodit_modules_dialog__WEBPACK_IMPORTED_MODULE_3__/* .Dialog */ .lG(Object.assign({ language: this.o.language, shadowRoot: this.o.shadowRoot, popupRoot, ownerWindow: this.o.ownerWindow, defaultTimeout: this.o.defaultTimeout, direction: this.o.direction, theme: this.o.theme, globalFullSize: this.o.globalFullSize }, options));
        (0,jodit_core_helpers_utils_utils__WEBPACK_IMPORTED_MODULE_2__/* .markOwner */ .b_)(this, dialog.container);
        dialog.parent = this;
        return dialog.bindDestruct(this);
    }
    confirm(msg, title, callback) {
        msg = processTitle(msg, this);
        title = processTitle(title, this);
        return jodit_modules_dialog__WEBPACK_IMPORTED_MODULE_3__/* .Confirm */ .pT.call(this.dlg({ closeOnClickOverlay: true }), msg, title, callback);
    }
    prompt(msg, title, callback, placeholder, defaultValue) {
        msg = processTitle(msg, this);
        title = processTitle(title, this);
        placeholder = processTitle(placeholder, this);
        return jodit_modules_dialog__WEBPACK_IMPORTED_MODULE_3__/* .Prompt */ .XG.call(this.dlg({ closeOnClickOverlay: true }), msg, title, callback, placeholder, defaultValue);
    }
    alert(msg, title, callback, className) {
        msg = processTitle(msg, this);
        title = processTitle(title, this);
        return jodit_modules_dialog__WEBPACK_IMPORTED_MODULE_3__/* .Alert */ .Fc.call(this.dlg({ closeOnClickOverlay: true }), msg, title, callback, className);
    }
}
function processTitle(title, self) {
    if ((0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isString */ .Kg)(title) && !(0,jodit_core_helpers_checker__WEBPACK_IMPORTED_MODULE_1__/* .isHTML */ .AH)(title)) {
        title = self.i18n(title);
    }
    return title;
}


/***/ }),

/***/ 58720:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $$: function() { return /* binding */ $$; },
/* harmony export */   DY: function() { return /* binding */ refs; },
/* harmony export */   bE: function() { return /* binding */ cssPath; },
/* harmony export */   fz: function() { return /* binding */ getXPathByElement; },
/* harmony export */   tI: function() { return /* binding */ resolveElement; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55186);
/* harmony import */ var jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42448);
/* harmony import */ var jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(98253);
/* harmony import */ var jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(83260);
/* harmony import */ var jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97369);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */






let temp = 1;
const $$temp = () => {
    temp++;
    return temp;
};
/**
 * @deprecated Do not use it in new code
 */
function $$(selector, root) {
    let result;
    if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_ES_NEXT &&
        /:scope/.test(selector) &&
        jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.IS_IE &&
        !(root && root.nodeType === Node.DOCUMENT_NODE)) {
        const id = root.id, temp_id = id ||
            '_selector_id_' + String(Math.random()).slice(2) + $$temp();
        selector = selector.replace(/:scope/g, '#' + temp_id);
        !id && root.setAttribute('id', temp_id);
        result = root.parentNode.querySelectorAll(selector);
        if (!id) {
            root.removeAttribute('id');
        }
    }
    else {
        result = root.querySelectorAll(selector);
    }
    return [].slice.call(result);
}
/**
 * Calculate XPath selector
 */
const getXPathByElement = (element, root) => {
    if (!element || element.nodeType !== Node.ELEMENT_NODE) {
        return '';
    }
    if (!element.parentNode || root === element) {
        return '';
    }
    if (element.id) {
        return "//*[@id='" + element.id + "']";
    }
    const sames = [].filter.call(element.parentNode.childNodes, (x) => x.nodeName === element.nodeName);
    return (getXPathByElement(element.parentNode, root) +
        '/' +
        element.nodeName.toLowerCase() +
        (sames.length > 1
            ? '[' + ((0,jodit_core_helpers_array_to_array__WEBPACK_IMPORTED_MODULE_2__/* .toArray */ .$)(sames).indexOf(element) + 1) + ']'
            : ''));
};
/**
 * Find all `ref` or `data-ref` elements inside HTMLElement
 */
const refs = (root) => {
    if ('container' in root) {
        root = root.container;
    }
    return $$('[ref],[data-ref]', root).reduce((def, child) => {
        const key = (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.attr)(child, '-ref');
        if (key && (0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(key)) {
            def[(0,jodit_core_helpers_string_camel_case__WEBPACK_IMPORTED_MODULE_5__/* .camelCase */ .x)(key)] = child;
            def[key] = child;
        }
        return def;
    }, {});
};
/**
 * Calculate full CSS selector
 */
const cssPath = (el) => {
    if (!jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(el)) {
        return null;
    }
    const path = [];
    let start = el;
    while (start && start.nodeType === Node.ELEMENT_NODE) {
        let selector = start.nodeName.toLowerCase();
        if (start.id) {
            selector += '#' + start.id;
            path.unshift(selector);
            break;
        }
        else {
            let sib = start, nth = 1;
            do {
                sib = sib.previousElementSibling;
                if (sib && sib.nodeName.toLowerCase() === selector) {
                    nth++;
                }
            } while (sib);
            selector += ':nth-of-type(' + nth + ')';
        }
        path.unshift(selector);
        start = start.parentNode;
    }
    return path.join(' > ');
};
/**
 * Try to find element by selector
 */
function resolveElement(element, od) {
    let resolved = element;
    if ((0,jodit_core_helpers_checker_is_string__WEBPACK_IMPORTED_MODULE_4__/* .isString */ .K)(element)) {
        try {
            resolved = od.querySelector(element);
        }
        catch (_a) {
            throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.error)('String "' + element + '" should be valid HTML selector');
        }
    }
    // Duck checking
    if (!resolved ||
        typeof resolved !== 'object' ||
        !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_1__/* .Dom */ .J.isElement(resolved) ||
        !resolved.cloneNode) {
        throw (0,jodit_core_helpers_utils__WEBPACK_IMPORTED_MODULE_3__.error)('Element "' + element + '" should be string or HTMLElement instance');
    }
    return resolved;
}


/***/ }),

/***/ 58770:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F: function() { return /* binding */ Snapshot; }
/* harmony export */ });
/* harmony import */ var jodit_core_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77753);
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17352);
/* harmony import */ var jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55186);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */



/**
 * Module for creating snapshot of editor which includes html content and the current selection
 */
class Snapshot extends jodit_core_component__WEBPACK_IMPORTED_MODULE_0__/* .ViewComponent */ .vG {
    constructor() {
        super(...arguments);
        this.__isBlocked = false;
        this.__levelOfTransaction = 0;
    }
    /** @override */
    className() {
        return 'Snapshot';
    }
    /**
     * Compare two snapshotes, if and htmls and selections match, then return true
     *
     * @param first - the first snapshote
     * @param second - second shot
     */
    static equal(first, second) {
        return (first.html === second.html &&
            JSON.stringify(first.range) === JSON.stringify(second.range));
    }
    /**
     * Calc count element before some node in parentNode. All text nodes are joined
     */
    static countNodesBeforeInParent(elm) {
        if (!elm.parentNode) {
            return 0;
        }
        const elms = elm.parentNode.childNodes;
        let count = 0, previous = null;
        for (let j = 0; j < elms.length; j += 1) {
            if (previous &&
                !this.isIgnoredNode(elms[j]) &&
                !(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(previous) && jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(elms[j]))) {
                count += 1;
            }
            if (elms[j] === elm) {
                return count;
            }
            previous = elms[j];
        }
        return 0;
    }
    /**
     * Calc normal offset in joined text nodes
     */
    static strokeOffset(elm, offset) {
        while (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(elm)) {
            elm = elm.previousSibling;
            if (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(elm) && elm.nodeValue) {
                offset += elm.nodeValue.length;
            }
        }
        return offset;
    }
    /**
     * Calc whole hierarchy path before some element in editor's tree
     */
    calcHierarchyLadder(elm) {
        const counts = [];
        if (!elm || !elm.parentNode || !jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isOrContains(this.j.editor, elm)) {
            return [];
        }
        while (elm && elm !== this.j.editor) {
            if (elm && !Snapshot.isIgnoredNode(elm)) {
                counts.push(Snapshot.countNodesBeforeInParent(elm));
            }
            elm = elm.parentNode;
        }
        return counts.reverse();
    }
    getElementByLadder(ladder) {
        let n = this.j.editor, i;
        for (i = 0; n && i < ladder.length; i += 1) {
            n = n.childNodes[ladder[i]];
        }
        return n;
    }
    get isBlocked() {
        return this.__isBlocked;
    }
    __block(enable) {
        this.__isBlocked = enable;
    }
    transaction(changes) {
        this.__block(true);
        this.__levelOfTransaction += 1;
        try {
            changes();
        }
        catch (e) {
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD) {
                throw e;
            }
        }
        finally {
            this.__levelOfTransaction -= 1;
            if (this.__levelOfTransaction === 0) {
                this.__block(false);
            }
        }
    }
    /**
     * Creates object a snapshot of editor: html and the current selection. Current selection calculate by
     * offset by start document
     * \{html: string, range: \{startContainer: int, startOffset: int, endContainer: int, endOffset: int\}\} or
     * \{html: string\} without selection
     */
    make() {
        const snapshot = {
            html: '',
            range: {
                startContainer: [],
                startOffset: 0,
                endContainer: [],
                endOffset: 0
            }
        };
        snapshot.html = this.__getCleanedEditorValue(this.j.editor);
        const sel = this.j.s.sel;
        if (sel && sel.rangeCount) {
            const range = sel.getRangeAt(0);
            const startContainer = this.calcHierarchyLadder(range.startContainer);
            const endContainer = this.calcHierarchyLadder(range.endContainer);
            let startOffset = Snapshot.strokeOffset(range.startContainer, range.startOffset), endOffset = Snapshot.strokeOffset(range.endContainer, range.endOffset);
            if (!startContainer.length &&
                range.startContainer !== this.j.editor) {
                startOffset = 0;
            }
            if (!endContainer.length && range.endContainer !== this.j.editor) {
                endOffset = 0;
            }
            snapshot.range = {
                startContainer,
                startOffset,
                endContainer,
                endOffset
            };
        }
        return snapshot;
    }
    /**
     * Restores the state of the editor of the snapshot. Rebounding is not only html but selected text
     *
     * @param snapshot - snapshot of editor resulting from the `[[Snapshot.make]]` method
     * @see make
     */
    restore(snapshot) {
        this.transaction(() => {
            const scroll = this.storeScrollState();
            const html = this.__getCleanedEditorValue(this.j.editor);
            if (html !== snapshot.html) {
                this.j.value = snapshot.html;
            }
            this.restoreOnlySelection(snapshot);
            this.restoreScrollState(scroll);
        });
    }
    storeScrollState() {
        return [this.j.ow.scrollY, this.j.editor.scrollTop];
    }
    restoreScrollState(scrolls) {
        const { j } = this, { ow } = j;
        ow.scrollTo(ow.scrollX, scrolls[0]);
        j.editor.scrollTop = scrolls[1];
    }
    /**
     * Restore selection from snapshot
     *
     * @param snapshot - snapshot of editor resulting from the [[Snapshot.make]] method
     * @see make
     */
    restoreOnlySelection(snapshot) {
        try {
            if (snapshot.range) {
                const range = this.j.ed.createRange();
                range.setStart(this.getElementByLadder(snapshot.range.startContainer), snapshot.range.startOffset);
                range.setEnd(this.getElementByLadder(snapshot.range.endContainer), snapshot.range.endOffset);
                this.j.s.selectRange(range);
            }
        }
        catch (__ignore) {
            this.j.editor.lastChild &&
                this.j.s.setCursorAfter(this.j.editor.lastChild);
            if (!jodit_core_constants__WEBPACK_IMPORTED_MODULE_1__.IS_PROD) {
                // tslint:disable-next-line:no-console
                console.warn('Broken snapshot', __ignore);
            }
        }
    }
    destruct() {
        this.__block(false);
        super.destruct();
    }
    static isIgnoredNode(node) {
        return (jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isText(node) && !node.nodeValue) || jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.isTemporary(node);
    }
    __getCleanedEditorValue(node) {
        const clone = node.cloneNode(true);
        jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.temporaryList(clone).forEach(jodit_core_dom_dom__WEBPACK_IMPORTED_MODULE_2__/* .Dom */ .J.unwrap);
        return clone.innerHTML;
    }
}


/***/ }),

/***/ 58972:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   q: function() { return /* binding */ applySize; }
/* harmony export */ });
/* harmony import */ var jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12461);
/* harmony import */ var jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26150);
/* harmony import */ var jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38322);
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9645);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module plugins/image-properties
 */




/** @private */
function applySize(image, imageWidth, imageHeight, sizeIsLocked) {
    // Size
    if (imageWidth !== image.offsetWidth ||
        imageHeight !== image.offsetHeight) {
        const updatedWidth = imageWidth ? (0,_utils_utils__WEBPACK_IMPORTED_MODULE_1__/* .normalSizeToString */ .n)(imageWidth) : null;
        let updatedHeight = imageHeight
            ? (0,_utils_utils__WEBPACK_IMPORTED_MODULE_1__/* .normalSizeToString */ .n)(imageHeight)
            : null;
        (0,jodit_core_helpers_utils_css__WEBPACK_IMPORTED_MODULE_2__/* .css */ .A)(image, {
            width: updatedWidth,
            height: updatedWidth && sizeIsLocked ? null : updatedHeight
        });
        (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'width', updatedWidth && (0,jodit_core_helpers_checker_is_numeric__WEBPACK_IMPORTED_MODULE_3__/* .isNumeric */ .k)(imageWidth) && (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'width')
            ? updatedWidth
            : null);
        if (!(0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'width') || sizeIsLocked) {
            updatedHeight = null;
        }
        (0,jodit_core_helpers_utils_attr__WEBPACK_IMPORTED_MODULE_0__/* .attr */ .C)(image, 'height', updatedHeight);
    }
}


/***/ }),

/***/ 59082:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   u: function() { return /* binding */ isValidName; }
/* harmony export */ });
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/checker
 */
/**
 * Check if name has a normal format
 */
function isValidName(name) {
    if (!name.length) {
        return false;
    }
    return !/[^0-9A-Za-zа-яА-ЯЁё\w\-_. ]/.test(name) && name.trim().length > 0;
}


/***/ }),

/***/ 59101:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Bq: function() { return /* binding */ trim; },
/* harmony export */   Gd: function() { return /* binding */ trimChars; },
/* harmony export */   gj: function() { return /* binding */ trimInv; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/string
 */

/**
 * It clears the line of all auxiliary invisible characters , from the spaces and line breaks , tabs
 * from the beginning and end of the line
 */
function trim(value) {
    return value
        .replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.SPACE_REG_EXP_END)(), '')
        .replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.SPACE_REG_EXP_START)(), '');
}
function trimChars(value, chars) {
    return value
        .replace(RegExp(`[${chars}]+$`), '')
        .replace(RegExp(`^[${chars}]+`), '');
}
/**
 * Trim only invisible chars
 */
function trimInv(value) {
    return value
        .replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_END)(), '')
        .replace((0,jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.INVISIBLE_SPACE_REG_EXP_START)(), '');
}


/***/ }),

/***/ 59146:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   D: function() { return /* binding */ clearTimeout; },
/* harmony export */   w: function() { return /* binding */ setTimeout; }
/* harmony export */ });
/* harmony import */ var jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17352);
/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
/**
 * @module helpers/async
 */

/**
 * Create async callback if set timeout value - else call function immediately
 */
function setTimeout(callback, timeout, ...args) {
    if (!timeout) {
        callback.call(null, ...args);
    }
    else {
        return jodit_core_constants__WEBPACK_IMPORTED_MODULE_0__.globalWindow.setTimeout(callback, timeout, ...args);
    }
    return 0;
}
/**
 * Clear timeout
 */
function clearTimeout(timer) {
    jodit_core_constants__WEBPACK_IMPORTED_M