/* Generated by re2c 2.0.3 */
/*
 * phpdbg_lexer.l
 */

#include "phpdbg.h"
#include "phpdbg_cmd.h"

#include "phpdbg_parser.h"

#define LEX(v) (PHPDBG_G(lexer).v)

#define YYCTYPE unsigned char
#define YYSETCONDITION(x) LEX(state) = x;
#define YYGETCONDITION() LEX(state)
#define YYCURSOR LEX(cursor)
#define YYMARKER LEX(marker)
#define YYCTXMARKER LEX(ctxmarker)
#define yyleng LEX(len)
#define yytext ((char*) LEX(text))
#undef YYDEBUG
#define YYDEBUG(a, b)
#define YYFILL(n)

#define NORMAL 0
#define PRE_RAW 1
#define RAW 2
#define INITIAL 3

ZEND_EXTERN_MODULE_GLOBALS(phpdbg)

void phpdbg_init_lexer (phpdbg_param_t *stack, char *input) {
	PHPDBG_G(parser_stack) = stack;

	YYSETCONDITION(INITIAL);

	LEX(text) = YYCURSOR = (unsigned char *) input;
	LEX(len) = strlen(input);
}

static int unescape_string(char *s) {
	switch (*s) {
		case '\'':
		case '\"': {
			char start = *s;
			size_t off = 1;
			do {
				if (s[off] == '\\') {
					off++;
				}
				*s = s[off];
			} while ((++s)[off] != start);
			return off + 1;
		}
	}

	return 0;
}

int phpdbg_lex (phpdbg_param_t* yylval) {

restart:
	LEX(text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 2) {
		if (YYGETCONDITION() < 1) {
			goto yyc_NORMAL;
		} else {
			goto yyc_PRE_RAW;
		}
	} else {
		if (YYGETCONDITION() < 3) {
			goto yyc_RAW;
		} else {
			goto yyc_INITIAL;
		}
	}
/* *********************************** */
yyc_NORMAL:
	{
		static const unsigned char yybm[] = {
			/* table 1 .. 8: 0 */
			  0,  62,  62,  62,  62,  62,  62,  62, 
			 62,  40,   0,  62,  62,  40,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 40,  62,  50,  40,  62,  62,  62,  14, 
			 62,  62,  62,  62,  62,  62,  63,  62, 
			127, 127, 127, 127, 127, 127, 127, 127, 
			127, 127,  40,  62,  62,  62,  62,  62, 
			 62, 254, 254, 254, 254, 254, 254, 190, 
			190, 190, 190, 190, 190, 190, 190, 190, 
			190, 190, 190, 190, 190, 190, 190, 190, 
			190, 190, 190,  62,   2,  62,  62, 190, 
			 62, 254, 254, 254, 254, 254, 254, 190, 
			190, 190, 190, 190, 190, 190, 190, 190, 
			190, 190, 190, 190, 190, 190, 190, 190, 
			190, 190, 190,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			 62,  62,  62,  62,  62,  62,  62,  62, 
			/* table 9 .. 10: 256 */
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64, 128,   0,  64,  64, 128,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			128,  64,   0,   0,  64,  64,  64,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(0, *YYCURSOR);
		YYFILL(11);
		yych = *YYCURSOR;
		if (yybm[256+yych] & 128) {
			goto yy7;
		}
		switch (yych) {
		case 0x00:
		case '\t':
		case '\n':	goto yy2;
		case '"':	goto yy10;
		case '#':	goto yy12;
		case '\'':	goto yy14;
		case '-':	goto yy15;
		case '.':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy16;
		case '0':	goto yy19;
		case ':':	goto yy20;
		case 'D':
		case 'd':	goto yy21;
		case 'E':
		case 'e':	goto yy22;
		case 'F':
		case 'f':	goto yy23;
		case 'I':
		case 'i':	goto yy24;
		case 'N':
		case 'n':	goto yy25;
		case 'O':
		case 'o':	goto yy26;
		case 'T':
		case 't':	goto yy27;
		case 'Y':
		case 'y':	goto yy28;
		case 'Z':	goto yy29;
		case 'z':	goto yy30;
		default:	goto yy4;
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(3, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return 0;
}
yy4:
		YYDEBUG(4, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy5:
		YYDEBUG(5, *YYCURSOR);
		if (yybm[256+yych] & 64) {
			goto yy4;
		}
		if (yych <= ' ') goto yy6;
		if (yych == '#') goto yy6;
		if (yych <= '\'') goto yy31;
		goto yy33;
yy6:
		YYDEBUG(6, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrndup(yytext, yyleng - unescape_string(yytext));
	yylval->len = yyleng;
	return T_ID;
}
yy7:
		YYDEBUG(7, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(8, *YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy7;
		}
		YYDEBUG(9, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	/* ignore whitespace */

	goto restart;
}
yy10:
		YYDEBUG(10, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy31;
		goto yy35;
yy11:
		YYDEBUG(11, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy6;
				} else {
					goto yy13;
				}
			} else {
				if (yyaccept == 2) {
					goto yy18;
				} else {
					goto yy82;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy85;
				} else {
					goto yy101;
				}
			} else {
				goto yy118;
			}
		}
yy12:
		YYDEBUG(12, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '.') {
			if (yych <= ',') goto yy13;
			if (yych <= '-') {
				YYCTXMARKER = YYCURSOR;
				goto yy40;
			}
			YYCTXMARKER = YYCURSOR;
			goto yy41;
		} else {
			if (yych <= '/') goto yy13;
			if (yych <= '9') {
				YYCTXMARKER = YYCURSOR;
				goto yy41;
			}
		}
yy13:
		YYDEBUG(13, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(INITIAL);
	return T_SEPARATOR;
}
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy31;
		goto yy45;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy16;
		}
		if (yych == 'r') goto yy50;
		goto yy5;
yy16:
		YYDEBUG(16, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(17, *YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy16;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy18;
				if (yych <= 0x08) goto yy4;
			} else {
				if (yych == '\r') goto yy18;
				if (yych <= 0x1F) goto yy4;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy4;
				if (yych <= '"') goto yy31;
				if (yych >= '$') goto yy4;
			} else {
				if (yych <= '\'') goto yy31;
				if (yych <= '/') goto yy4;
				if (yych <= ':') goto yy33;
				goto yy4;
			}
		}
yy18:
		YYDEBUG(18, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = atoi(yytext);
	return T_DIGITS;
}
yy19:
		YYDEBUG(19, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy16;
		}
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy18;
				if (yych <= 0x08) goto yy5;
				goto yy18;
			} else {
				if (yych == '\r') goto yy18;
				goto yy5;
			}
		} else {
			if (yych <= '#') {
				if (yych <= ' ') goto yy18;
				if (yych <= '"') goto yy5;
				goto yy18;
			} else {
				if (yych == 'x') goto yy51;
				goto yy5;
			}
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy54;
		if (yych == '\\') goto yy56;
		goto yy52;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy58;
		if (yych == 'i') goto yy58;
		goto yy5;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy59;
		if (yych == 'n') goto yy59;
		goto yy5;
yy23:
		YYDEBUG(23, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy60;
		if (yych == 'a') goto yy60;
		goto yy5;
yy24:
		YYDEBUG(24, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy61;
		if (yych == 'f') goto yy61;
		goto yy5;
yy25:
		YYDEBUG(25, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy62;
		if (yych == 'o') goto yy62;
		goto yy5;
yy26:
		YYDEBUG(26, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych == 'F') goto yy63;
			if (yych <= 'M') goto yy5;
			goto yy64;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy5;
				goto yy63;
			} else {
				if (yych == 'n') goto yy64;
				goto yy5;
			}
		}
yy27:
		YYDEBUG(27, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy65;
		if (yych == 'r') goto yy65;
		goto yy5;
yy28:
		YYDEBUG(28, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy66;
		if (yych == 'e') goto yy66;
		goto yy5;
yy29:
		YYDEBUG(29, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy67;
		goto yy5;
yy30:
		YYDEBUG(30, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'e') goto yy68;
		goto yy5;
yy31:
		YYDEBUG(31, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy32:
		YYDEBUG(32, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy31;
		}
		if (yych <= '#') goto yy11;
		goto yy69;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy70;
		if (yych == '\\') goto yy56;
		goto yy11;
yy34:
		YYDEBUG(34, *YYCURSOR);
		++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
yy35:
		YYDEBUG(35, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy34;
		}
		if (yych <= ' ') {
			if (yych <= 0x00) goto yy11;
			if (yych == '\n') goto yy11;
		} else {
			if (yych <= '"') goto yy71;
			if (yych <= '#') goto yy36;
			if (yych <= ':') goto yy38;
			goto yy39;
		}
yy36:
		YYDEBUG(36, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy37:
		YYDEBUG(37, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy36;
		}
		if (yych <= '\n') goto yy11;
		if (yych <= '"') goto yy72;
		goto yy73;
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy74;
		goto yy37;
yy39:
		YYDEBUG(39, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy11;
				if (yych <= 0x08) goto yy31;
				goto yy11;
			} else {
				if (yych == '\r') goto yy11;
				if (yych <= 0x1F) goto yy31;
				goto yy11;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '!') goto yy31;
				if (yych <= '"') goto yy34;
				if (yych <= '#') goto yy11;
				goto yy31;
			} else {
				if (yych <= ':') goto yy69;
				if (yych == '\\') goto yy34;
				goto yy31;
			}
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy41;
		if (yych <= '/') goto yy11;
		if (yych >= ':') goto yy11;
yy41:
		YYDEBUG(41, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(42, *YYCURSOR);
		if (yych == '.') goto yy41;
		if (yych <= '/') goto yy43;
		if (yych <= '9') goto yy41;
yy43:
		YYDEBUG(43, *YYCURSOR);
		YYCURSOR = YYCTXMARKER;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return T_POUND;
}
yy44:
		YYDEBUG(44, *YYCURSOR);
		++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
yy45:
		YYDEBUG(45, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy44;
		}
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy11;
			if (yych >= '\n') goto yy11;
		} else {
			if (yych <= '#') goto yy46;
			if (yych <= '\'') goto yy71;
			if (yych <= ':') goto yy48;
			goto yy49;
		}
yy46:
		YYDEBUG(46, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy47:
		YYDEBUG(47, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy46;
		}
		if (yych <= '\n') goto yy11;
		if (yych <= '\'') goto yy72;
		goto yy75;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy76;
		goto yy47;
yy49:
		YYDEBUG(49, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy11;
				if (yych <= 0x08) goto yy31;
				if (yych <= '\n') goto yy11;
				goto yy31;
			} else {
				if (yych <= '\r') goto yy11;
				if (yych == ' ') goto yy11;
				goto yy31;
			}
		} else {
			if (yych <= '9') {
				if (yych <= '#') goto yy11;
				if (yych == '\'') goto yy44;
				goto yy31;
			} else {
				if (yych <= ':') goto yy69;
				if (yych == '\\') goto yy44;
				goto yy31;
			}
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\f') {
				if (yych == '\t') goto yy77;
				goto yy5;
			} else {
				if (yych <= '\r') goto yy77;
				if (yych <= 0x1F) goto yy5;
				goto yy77;
			}
		} else {
			if (yych <= '.') {
				if (yych <= ',') goto yy5;
				if (yych <= '-') goto yy79;
				goto yy80;
			} else {
				if (yych <= '/') goto yy5;
				if (yych <= '9') goto yy80;
				goto yy5;
			}
		}
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy83;
		}
		goto yy5;
yy52:
		YYDEBUG(52, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(53, *YYCURSOR);
		YYCURSOR -= 1;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return T_COLON;
}
yy54:
		YYDEBUG(54, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(55, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return T_DCOLON;
}
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(57, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy6;
				if (yych <= 0x08) goto yy56;
				goto yy6;
			} else {
				if (yych == '\r') goto yy6;
				if (yych <= 0x1F) goto yy56;
				goto yy6;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy56;
				if (yych <= '#') goto yy6;
				goto yy56;
			} else {
				if (yych <= '\'') goto yy6;
				if (yych == ':') goto yy86;
				goto yy56;
			}
		}
yy58:
		YYDEBUG(58, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy87;
		if (yych == 's') goto yy87;
		goto yy5;
yy59:
		YYDEBUG(59, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy88;
		if (yych == 'a') goto yy88;
		goto yy5;
yy60:
		YYDEBUG(60, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy89;
		if (yych == 'l') goto yy89;
		goto yy5;
yy61:
		YYDEBUG(61, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy90;
			goto yy5;
		} else {
			if (yych <= '\r') goto yy90;
			if (yych == ' ') goto yy90;
			goto yy5;
		}
yy62:
		YYDEBUG(62, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy93;
			if (yych <= 0x08) goto yy5;
			if (yych <= '\n') goto yy93;
			goto yy5;
		} else {
			if (yych <= '\r') goto yy93;
			if (yych == ' ') goto yy93;
			goto yy5;
		}
yy63:
		YYDEBUG(63, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy62;
		if (yych == 'f') goto yy62;
		goto yy5;
yy64:
		YYDEBUG(64, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy95;
			if (yych <= 0x08) goto yy5;
			if (yych <= '\n') goto yy95;
			goto yy5;
		} else {
			if (yych <= '\r') goto yy95;
			if (yych == ' ') goto yy95;
			goto yy5;
		}
yy65:
		YYDEBUG(65, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy97;
		if (yych == 'u') goto yy97;
		goto yy5;
yy66:
		YYDEBUG(66, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy64;
		if (yych == 's') goto yy64;
		goto yy5;
yy67:
		YYDEBUG(67, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy98;
		goto yy5;
yy68:
		YYDEBUG(68, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'n') goto yy99;
		goto yy5;
yy69:
		YYDEBUG(69, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '/') goto yy11;
yy70:
		YYDEBUG(70, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy100;
		goto yy11;
yy71:
		YYDEBUG(71, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy6;
				goto yy32;
			} else {
				if (yych <= '\n') goto yy6;
				if (yych <= '\f') goto yy32;
				goto yy6;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy32;
				goto yy6;
			} else {
				if (yych == '#') goto yy6;
				goto yy32;
			}
		}
yy72:
		YYDEBUG(72, *YYCURSOR);
		++YYCURSOR;
		goto yy6;
yy73:
		YYDEBUG(73, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '"') goto yy36;
		if (yych == '\\') goto yy36;
		goto yy11;
yy74:
		YYDEBUG(74, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy102;
		goto yy37;
yy75:
		YYDEBUG(75, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\'') goto yy46;
		if (yych == '\\') goto yy46;
		goto yy11;
yy76:
		YYDEBUG(76, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '/') goto yy103;
		goto yy47;
yy77:
		YYDEBUG(77, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(78, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\f') {
				if (yych == '\t') goto yy77;
				goto yy11;
			} else {
				if (yych <= '\r') goto yy77;
				if (yych <= 0x1F) goto yy11;
				goto yy77;
			}
		} else {
			if (yych <= '.') {
				if (yych <= ',') goto yy11;
				if (yych <= '-') goto yy104;
				goto yy105;
			} else {
				if (yych <= '/') goto yy11;
				if (yych <= '9') goto yy105;
				goto yy11;
			}
		}
yy79:
		YYDEBUG(79, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '.') goto yy80;
		if (yych <= '/') goto yy5;
		if (yych >= ':') goto yy5;
yy80:
		YYDEBUG(80, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy82;
				if (yych <= 0x08) goto yy4;
				if (yych >= '\v') goto yy4;
			} else {
				if (yych <= 0x1F) {
					if (yych >= 0x0E) goto yy4;
				} else {
					if (yych <= ' ') goto yy82;
					if (yych <= '!') goto yy4;
					goto yy31;
				}
			}
		} else {
			if (yych <= '-') {
				if (yych <= '#') goto yy82;
				if (yych == '\'') goto yy31;
				goto yy4;
			} else {
				if (yych <= '/') {
					if (yych <= '.') goto yy80;
					goto yy4;
				} else {
					if (yych <= '9') goto yy80;
					if (yych <= ':') goto yy33;
					goto yy4;
				}
			}
		}
yy82:
		YYDEBUG(82, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	char *text = yytext + 2;
	while (*++text < '0');
	yylval->num = atoi(text);
	return T_REQ_ID;
}
yy83:
		YYDEBUG(83, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy83;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy85;
				if (yych <= 0x08) goto yy4;
			} else {
				if (yych == '\r') goto yy85;
				if (yych <= 0x1F) goto yy4;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy4;
				if (yych <= '"') goto yy31;
				if (yych >= '$') goto yy4;
			} else {
				if (yych <= '\'') goto yy31;
				if (yych <= '/') goto yy4;
				if (yych <= ':') goto yy33;
				goto yy4;
			}
		}
yy85:
		YYDEBUG(85, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, ADDR_PARAM);
	yylval->addr = strtoul(yytext, 0, 16);
	return T_ADDR;
}
yy86:
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '\\') goto yy56;
		goto yy11;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy107;
		if (yych == 'a') goto yy107;
		goto yy5;
yy88:
		YYDEBUG(88, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy108;
		if (yych == 'b') goto yy108;
		goto yy5;
yy89:
		YYDEBUG(89, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy109;
		if (yych == 's') goto yy109;
		goto yy5;
yy90:
		YYDEBUG(90, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(91, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy90;
		} else {
			if (yych <= '\r') goto yy90;
			if (yych == ' ') goto yy90;
		}
		YYDEBUG(92, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_IF;
}
yy93:
		YYDEBUG(93, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(94, *YYCURSOR);
		YYCURSOR -= 1;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = 0;
	return T_FALSY;
}
yy95:
		YYDEBUG(95, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(96, *YYCURSOR);
		YYCURSOR -= 1;
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, NUMERIC_PARAM);
	yylval->num = 1;
	return T_TRUTHY;
}
yy97:
		YYDEBUG(97, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy64;
		if (yych == 'e') goto yy64;
		goto yy5;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy110;
		goto yy5;
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'd') goto yy110;
		goto yy5;
yy100:
		YYDEBUG(100, *YYCURSOR);
		++YYCURSOR;
yy101:
		YYDEBUG(101, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrndup(yytext, yyleng);
	yylval->len = yyleng;
	return T_PROTO;
}
yy102:
		YYDEBUG(102, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x00) goto yy101;
		if (yych == '\n') goto yy101;
		goto yy37;
yy103:
		YYDEBUG(103, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x00) goto yy101;
		if (yych == '\n') goto yy101;
		goto yy47;
yy104:
		YYDEBUG(104, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy105;
		if (yych <= '/') goto yy11;
		if (yych >= ':') goto yy11;
yy105:
		YYDEBUG(105, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(106, *YYCURSOR);
		if (yych == '.') goto yy105;
		if (yych <= '/') goto yy82;
		if (yych <= '9') goto yy105;
		goto yy82;
yy107:
		YYDEBUG(107, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy111;
		if (yych == 'b') goto yy111;
		goto yy5;
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy112;
		if (yych == 'l') goto yy112;
		goto yy5;
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy62;
		if (yych == 'e') goto yy62;
		goto yy5;
yy110:
		YYDEBUG(110, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy113;
		goto yy5;
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy114;
		if (yych == 'l') goto yy114;
		goto yy5;
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy115;
		if (yych == 'e') goto yy115;
		goto yy5;
yy113:
		YYDEBUG(113, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy116;
		}
		goto yy5;
yy114:
		YYDEBUG(114, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy119;
		if (yych == 'e') goto yy119;
		goto yy5;
yy115:
		YYDEBUG(115, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy64;
		if (yych == 'd') goto yy64;
		goto yy5;
yy116:
		YYDEBUG(116, *YYCURSOR);
		yyaccept = 6;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(117, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy116;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy118;
				if (yych <= 0x08) goto yy4;
			} else {
				if (yych == '\r') goto yy118;
				if (yych <= 0x1F) goto yy4;
			}
		} else {
			if (yych <= '&') {
				if (yych <= '!') goto yy4;
				if (yych <= '"') goto yy31;
				if (yych >= '$') goto yy4;
			} else {
				if (yych <= '\'') goto yy31;
				if (yych == ':') goto yy33;
				goto yy4;
			}
		}
yy118:
		YYDEBUG(118, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, OP_PARAM);
	yylval->str = estrndup(yytext, yyleng);
	yylval->len = yyleng;
	return T_OPCODE;
}
yy119:
		YYDEBUG(119, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy62;
		if (yych == 'd') goto yy62;
		goto yy5;
	}
/* *********************************** */
yyc_PRE_RAW:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,   0,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0, 128,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(120, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych == '\t') goto yy124;
			if (yych >= '\r') goto yy124;
		} else {
			if (yych <= ' ') {
				if (yych >= ' ') goto yy125;
			} else {
				if (yych == '-') goto yy128;
			}
		}
		YYDEBUG(122, *YYCURSOR);
		++YYCURSOR;
yy123:
		YYDEBUG(123, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(RAW);

	YYCURSOR = LEX(text);
	goto restart;
}
yy124:
		YYDEBUG(124, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy125;
		}
		goto yy123;
yy125:
		YYDEBUG(125, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(126, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy125;
		}
		YYDEBUG(127, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	/* ignore whitespace */

	goto restart;
}
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != 'r') goto yy123;
yy129:
		YYDEBUG(129, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(130, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy133;
		}
		if (yych <= '\r') {
			if (yych == '\t') goto yy129;
			if (yych >= '\r') goto yy129;
		} else {
			if (yych <= ' ') {
				if (yych >= ' ') goto yy129;
			} else {
				if (yych == '-') goto yy132;
			}
		}
yy131:
		YYDEBUG(131, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy123;
yy132:
		YYDEBUG(132, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy133;
		}
		goto yy131;
yy133:
		YYDEBUG(133, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(134, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy133;
		}
		YYDEBUG(135, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	char *text = yytext + 2;
	while (*++text < '0');
	yylval->num = atoi(text);
	return T_REQ_ID;
}
	}
/* *********************************** */
yyc_RAW:
	{
		static const unsigned char yybm[] = {
			  0, 232, 232, 232, 232, 232, 232, 232, 
			232, 232,   0, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232,  64, 224, 232, 232, 232,  32, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232,  16, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
			232, 232, 232, 232, 232, 232, 232, 232, 
		};
		YYDEBUG(136, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy140;
		}
		if (yych <= '\n') goto yy138;
		if (yych <= '"') goto yy143;
		if (yych <= '#') goto yy145;
		if (yych <= '\'') goto yy147;
		goto yy148;
yy138:
		YYDEBUG(138, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(139, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	return 0;
}
yy140:
		YYDEBUG(140, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(141, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy140;
		}
		if (yych <= '\n') goto yy142;
		if (yych <= '"') goto yy143;
		if (yych <= '#') goto yy142;
		if (yych <= '\'') goto yy147;
		goto yy148;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	phpdbg_init_param(yylval, STR_PARAM);
	yylval->str = estrdup(yytext);
	yylval->len = yyleng;
	return T_INPUT;
}
yy143:
		YYDEBUG(143, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy150;
		}
		if (yych >= '#') goto yy152;
yy144:
		YYDEBUG(144, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy142;
yy145:
		YYDEBUG(145, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(146, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(INITIAL);
	return T_SEPARATOR;
}
yy147:
		YYDEBUG(147, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy154;
		}
		if (yych <= '\'') goto yy144;
		goto yy156;
yy148:
		YYDEBUG(148, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(149, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy148;
		}
		if (yych <= '!') {
			if (yych <= 0x00) goto yy142;
			if (yych == '\n') goto yy142;
			goto yy140;
		} else {
			if (yych <= '"') goto yy158;
			if (yych == '\'') goto yy159;
			goto yy140;
		}
yy150:
		YYDEBUG(150, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(151, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy150;
		}
		if (yych <= '\n') goto yy144;
		if (yych <= '"') goto yy140;
yy152:
		YYDEBUG(152, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(153, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy150;
		}
		if (yych <= '\n') goto yy144;
		if (yych <= '"') goto yy160;
		goto yy152;
yy154:
		YYDEBUG(154, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(155, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy154;
		}
		if (yych <= '\n') goto yy144;
		if (yych <= '\'') goto yy140;
yy156:
		YYDEBUG(156, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(157, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy154;
		}
		if (yych <= '\n') goto yy144;
		if (yych <= '\'') goto yy162;
		goto yy156;
yy158:
		YYDEBUG(158, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy142;
				goto yy160;
			} else {
				if (yych <= '\n') goto yy142;
				if (yych <= '!') goto yy160;
				goto yy143;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy150;
				if (yych <= '&') goto yy160;
				goto yy164;
			} else {
				if (yych == '\\') goto yy165;
				goto yy160;
			}
		}
yy159:
		YYDEBUG(159, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy142;
				goto yy162;
			} else {
				if (yych <= '\n') goto yy142;
				if (yych <= '!') goto yy162;
				goto yy167;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy154;
				if (yych <= '&') goto yy162;
				goto yy147;
			} else {
				if (yych == '\\') goto yy168;
				goto yy162;
			}
		}
yy160:
		YYDEBUG(160, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(161, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy142;
				goto yy160;
			} else {
				if (yych <= '\n') goto yy142;
				if (yych <= '!') goto yy160;
				goto yy158;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy150;
				if (yych <= '&') goto yy160;
				goto yy164;
			} else {
				if (yych == '\\') goto yy165;
				goto yy160;
			}
		}
yy162:
		YYDEBUG(162, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(163, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy142;
				goto yy162;
			} else {
				if (yych <= '\n') goto yy142;
				if (yych <= '!') goto yy162;
				goto yy167;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy154;
				if (yych <= '&') goto yy162;
				goto yy159;
			} else {
				if (yych == '\\') goto yy168;
				goto yy162;
			}
		}
yy164:
		YYDEBUG(164, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy170;
		}
		if (yych <= '\n') goto yy144;
		if (yych <= '"') goto yy162;
		if (yych <= '\'') goto yy150;
		goto yy172;
yy165:
		YYDEBUG(165, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(166, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x00) goto yy142;
			if (yych == '\n') goto yy142;
			goto yy160;
		} else {
			if (yych <= '\'') goto yy174;
			if (yych == '\\') goto yy165;
			goto yy160;
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy170;
		}
		if (yych <= '\n') goto yy144;
		if (yych <= '"') goto yy154;
		if (yych <= '\'') goto yy160;
		goto yy172;
yy168:
		YYDEBUG(168, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(169, *YYCURSOR);
		if (yych <= '!') {
			if (yych <= 0x00) goto yy142;
			if (yych == '\n') goto yy142;
			goto yy162;
		} else {
			if (yych <= '"') goto yy175;
			if (yych == '\\') goto yy168;
			goto yy162;
		}
yy170:
		YYDEBUG(170, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(171, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy170;
		}
		if (yych <= '\n') goto yy144;
		if (yych <= '"') goto yy162;
		if (yych <= '\'') goto yy160;
yy172:
		YYDEBUG(172, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(173, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy170;
		}
		if (yych <= '\n') goto yy144;
		if (yych <= '\'') goto yy176;
		goto yy172;
yy174:
		YYDEBUG(174, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy142;
				goto yy176;
			} else {
				if (yych <= '\n') goto yy142;
				if (yych <= '!') goto yy176;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy170;
				if (yych <= '&') goto yy176;
				goto yy164;
			} else {
				if (yych == '\\') goto yy178;
				goto yy176;
			}
		}
yy175:
		YYDEBUG(175, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy142;
			} else {
				if (yych <= '\n') goto yy142;
				if (yych >= '"') goto yy167;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy170;
				if (yych >= '\'') goto yy174;
			} else {
				if (yych == '\\') goto yy178;
			}
		}
yy176:
		YYDEBUG(176, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(177, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy142;
				goto yy176;
			} else {
				if (yych <= '\n') goto yy142;
				if (yych <= '!') goto yy176;
				goto yy175;
			}
		} else {
			if (yych <= '\'') {
				if (yych <= '#') goto yy170;
				if (yych <= '&') goto yy176;
				goto yy174;
			} else {
				if (yych != '\\') goto yy176;
			}
		}
yy178:
		YYDEBUG(178, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(179, *YYCURSOR);
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy142;
			if (yych <= '\t') goto yy176;
			goto yy142;
		} else {
			if (yych == '\\') goto yy178;
			goto yy176;
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(180, *YYCURSOR);
		YYFILL(4);
		yych = *YYCURSOR;
		if (yych <= 'E') {
			if (yych <= '\r') {
				if (yych == '\t') goto yy184;
				if (yych >= '\r') goto yy184;
			} else {
				if (yych == ' ') goto yy185;
				if (yych >= 'E') goto yy188;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'Q') goto yy182;
				if (yych <= 'R') goto yy189;
				if (yych <= 'S') goto yy190;
			} else {
				if (yych <= 'q') {
					if (yych <= 'e') goto yy188;
				} else {
					if (yych <= 'r') goto yy191;
					if (yych <= 's') goto yy190;
				}
			}
		}
yy182:
		YYDEBUG(182, *YYCURSOR);
		++YYCURSOR;
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(NORMAL);

	YYCURSOR = LEX(text);
	goto restart;
}
yy184:
		YYDEBUG(184, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy185;
		}
		goto yy183;
yy185:
		YYDEBUG(185, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(186, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy185;
		}
		YYDEBUG(187, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	/* ignore whitespace */

	goto restart;
}
yy188:
		YYDEBUG(188, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'V') goto yy192;
		if (yych == 'v') goto yy192;
		goto yy183;
yy189:
		YYDEBUG(189, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy194;
		if (yych == 'u') goto yy194;
		goto yy183;
yy190:
		YYDEBUG(190, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy195;
		if (yych == 'h') goto yy195;
		goto yy183;
yy191:
		YYDEBUG(191, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy183;
				goto yy196;
			} else {
				if (yych == '\r') goto yy196;
				goto yy183;
			}
		} else {
			if (yych <= 'U') {
				if (yych <= ' ') goto yy196;
				if (yych <= 'T') goto yy183;
				goto yy194;
			} else {
				if (yych == 'u') goto yy194;
				goto yy183;
			}
		}
yy192:
		YYDEBUG(192, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\t') goto yy199;
		} else {
			if (yych <= '\r') goto yy199;
			if (yych == ' ') goto yy199;
		}
yy193:
		YYDEBUG(193, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy183;
yy194:
		YYDEBUG(194, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy202;
		if (yych == 'n') goto yy202;
		goto yy193;
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\t') goto yy203;
			goto yy193;
		} else {
			if (yych <= '\r') goto yy203;
			if (yych == ' ') goto yy203;
			goto yy193;
		}
yy196:
		YYDEBUG(196, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(197, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy196;
		} else {
			if (yych <= '\r') goto yy196;
			if (yych == ' ') goto yy196;
		}
		YYDEBUG(198, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_RUN;
}
yy199:
		YYDEBUG(199, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(200, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy199;
		} else {
			if (yych <= '\r') goto yy199;
			if (yych == ' ') goto yy199;
		}
		YYDEBUG(201, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_EVAL;
}
yy202:
		YYDEBUG(202, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\t') goto yy196;
			goto yy193;
		} else {
			if (yych <= '\r') goto yy196;
			if (yych == ' ') goto yy196;
			goto yy193;
		}
yy203:
		YYDEBUG(203, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(204, *YYCURSOR);
		if (yych <= '\f') {
			if (yych == '\t') goto yy203;
		} else {
			if (yych <= '\r') goto yy203;
			if (yych == ' ') goto yy203;
		}
		YYDEBUG(205, *YYCURSOR);
		yyleng = (size_t) YYCURSOR - (size_t) yytext;
		{
	YYSETCONDITION(PRE_RAW);
	phpdbg_init_param(yylval, EMPTY_PARAM);
	return T_SHELL;
}
	}
}

}
