/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import scouter.lang.Counter;
import scouter.util.StringKeyLinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Family {
    private String name;
    private String master;
    private StringKeyLinkedMap<String> attrMap = new StringKeyLinkedMap();
    private StringKeyLinkedMap<Counter> counterMap = new StringKeyLinkedMap();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMaster() {
        return this.master;
    }

    public void setMaster(String master) {
        this.master = master;
    }

    public String setAttribute(String key, String value) {
        return this.attrMap.put(key, value);
    }

    public String getAttribute(String key) {
        return this.attrMap.get(key);
    }

    public boolean isTrueAttribute(String key) {
        String value = this.attrMap.get(key);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public Counter addCounter(Counter counter) {
        return this.counterMap.put(counter.getName(), counter);
    }

    protected Counter getCounter(String counter) {
        return this.counterMap.get(counter);
    }

    public List<Counter> listCounters() {
        ArrayList<Counter> list = new ArrayList<Counter>(this.counterMap.size());
        Enumeration<Counter> en = this.counterMap.values();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        return list;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Family other = (Family)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

