/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang;

import java.util.Enumeration;
import java.util.List;
import scouter.lang.Counter;
import scouter.lang.Family;
import scouter.util.StringKeyLinkedMap;

public class ObjectType {
    private String name;
    private String displayName;
    private Family family;
    private String icon;
    private boolean subObject;
    private StringKeyLinkedMap<Counter> counterMap = new StringKeyLinkedMap();
    private StringKeyLinkedMap<String> attrMap = new StringKeyLinkedMap();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Family getFamily() {
        return this.family;
    }

    public void setFamily(Family family) {
        this.family = family;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isSubObject() {
        return this.subObject;
    }

    public void setSubObject(boolean isSubObject) {
        this.subObject = isSubObject;
    }

    public String setAttribute(String key, String value) {
        return this.attrMap.put(key, value);
    }

    public String getAttribute(String key) {
        return this.attrMap.get(key);
    }

    public boolean isTrueAttribute(String key) {
        String value = this.attrMap.get(key);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public Counter[] listCounters() {
        List<Counter> list = this.family.listCounters();
        Enumeration<Counter> en = this.counterMap.values();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        return list.toArray(new Counter[list.size()]);
    }

    public Counter[] listObjectTypeCounters() {
        Counter[] counters = new Counter[this.counterMap.size()];
        Enumeration<Counter> en = this.counterMap.values();
        int i = 0;
        while (en.hasMoreElements()) {
            counters[i] = en.nextElement();
            ++i;
        }
        return counters;
    }

    public Counter getCounter(String name) {
        Counter c = this.counterMap.get(name);
        if (c == null) {
            c = this.family.getCounter(name);
        }
        return c;
    }

    public void addCounter(Counter c) {
        this.counterMap.put(c.getName(), c);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectType other = (ObjectType)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

