/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.util.ArrayUtil;
import scouter.util.CompressUtil;
import scouter.util.DateUtil;
import scouter.util.Hexa32;

public class StackPack
implements Pack {
    public long time;
    public int objHash;
    public byte[] data;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Stack ");
        sb.append(DateUtil.timestamp(this.time));
        sb.append(" objHash=").append(Hexa32.toString32(this.objHash));
        sb.append(" stack=").append(ArrayUtil.len(this.data) + "bytes");
        return sb.toString();
    }

    public byte getPackType() {
        return 62;
    }

    public void write(DataOutputX out) throws IOException {
        out.writeDecimal(this.time);
        out.writeDecimal(this.objHash);
        out.writeBlob(this.data);
    }

    public Pack read(DataInputX in) throws IOException {
        this.time = in.readDecimal();
        this.objHash = (int)in.readDecimal();
        this.data = in.readBlob();
        return this;
    }

    public void setStack(String stack) {
        if (stack == null) {
            this.data = null;
            return;
        }
        try {
            this.data = CompressUtil.doZip(stack.getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getStack() {
        if (ArrayUtil.isEmpty(this.data)) {
            return "";
        }
        try {
            return new String(CompressUtil.unZip(this.data));
        }
        catch (Exception e) {
            return "";
        }
    }
}

