/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.step;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.step.Step;
import scouter.lang.step.StepSingle;
import scouter.util.BitUtil;
import scouter.util.HashUtil;
import scouter.util.IPUtil;

public class SocketStep
extends StepSingle {
    public byte[] ipaddr;
    public int port;
    public int elapsed;
    public int error;

    public SocketStep() {
    }

    public SocketStep(byte[] ipaddr, int port) {
        this.ipaddr = ipaddr;
        this.port = port;
    }

    public byte getStepType() {
        return 5;
    }

    public String toString() {
        return IPUtil.toString(this.ipaddr) + ":" + this.port;
    }

    public void write(DataOutputX out) throws IOException {
        super.write(out);
        out.writeBlob(this.ipaddr);
        out.writeDecimal(this.port);
        out.writeDecimal(this.elapsed);
        out.writeDecimal(this.error);
    }

    public Step read(DataInputX in) throws IOException {
        super.read(in);
        this.ipaddr = in.readBlob();
        this.port = (int)in.readDecimal();
        this.elapsed = (int)in.readDecimal();
        this.error = (int)in.readDecimal();
        return this;
    }

    public long getSocketId() {
        return BitUtil.composite(HashUtil.hash(this.ipaddr), this.port);
    }
}

