/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.step;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.step.Step;
import scouter.lang.step.StepSummary;

public class SocketSum
extends StepSummary {
    public byte[] ipaddr;
    public int port;
    public int count;
    public long elapsed;
    public int error;

    public SocketSum() {
    }

    public SocketSum(byte[] ipaddr, int port) {
        this.ipaddr = ipaddr;
        this.port = port;
    }

    public void add(int elapsed, boolean error) {
        ++this.count;
        this.elapsed += (long)elapsed;
        if (error) {
            ++this.error;
        }
    }

    public byte getStepType() {
        return 42;
    }

    public void write(DataOutputX out) throws IOException {
        out.writeBlob(this.ipaddr);
        out.writeDecimal(this.port);
        out.writeDecimal(this.count);
        out.writeDecimal(this.elapsed);
        out.writeDecimal(this.error);
    }

    public Step read(DataInputX in) throws IOException {
        this.ipaddr = in.readBlob();
        this.port = (int)in.readDecimal();
        this.count = (int)in.readDecimal();
        this.elapsed = in.readDecimal();
        this.error = (int)in.readDecimal();
        return this;
    }
}

