/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.step;

import java.io.IOException;
import scouter.lang.step.ApiCallStep;
import scouter.lang.step.ApiCallSum;
import scouter.lang.step.HashedMessageStep;
import scouter.lang.step.MessageStep;
import scouter.lang.step.MessageSum;
import scouter.lang.step.MethodStep;
import scouter.lang.step.MethodStep2;
import scouter.lang.step.MethodSum;
import scouter.lang.step.SocketStep;
import scouter.lang.step.SocketSum;
import scouter.lang.step.SqlStep;
import scouter.lang.step.SqlStep2;
import scouter.lang.step.SqlStep3;
import scouter.lang.step.SqlSum;
import scouter.lang.step.Step;
import scouter.lang.step.StepControl;
import scouter.lang.step.ThreadSubmitStep;

public class StepEnum {
    public static final byte METHOD = 1;
    public static final byte METHOD2 = 10;
    public static final byte SQL = 2;
    public static final byte SQL2 = 8;
    public static final byte SQL3 = 16;
    public static final byte MESSAGE = 3;
    public static final byte SOCKET = 5;
    public static final byte APICALL = 6;
    public static final byte THREAD_SUBMIT = 7;
    public static final byte HASHED_MESSAGE = 9;
    public static final byte METHOD_SUM = 11;
    public static final byte SQL_SUM = 21;
    public static final byte MESSAGE_SUM = 31;
    public static final byte SOCKET_SUM = 42;
    public static final byte APICALL_SUM = 43;
    public static final byte CONTROL = 99;

    public static Step create(byte type) throws IOException {
        switch (type) {
            case 3: {
                return new MessageStep();
            }
            case 1: {
                return new MethodStep();
            }
            case 10: {
                return new MethodStep2();
            }
            case 2: {
                return new SqlStep();
            }
            case 8: {
                return new SqlStep2();
            }
            case 16: {
                return new SqlStep3();
            }
            case 5: {
                return new SocketStep();
            }
            case 6: {
                return new ApiCallStep();
            }
            case 7: {
                return new ThreadSubmitStep();
            }
            case 9: {
                return new HashedMessageStep();
            }
            case 31: {
                return new MessageSum();
            }
            case 11: {
                return new MethodSum();
            }
            case 21: {
                return new SqlSum();
            }
            case 42: {
                return new SocketSum();
            }
            case 43: {
                return new ApiCallSum();
            }
            case 99: {
                return new StepControl();
            }
        }
        throw new RuntimeException("unknown profile type=" + type);
    }

    public static void main(String[] args) {
        System.out.println(2);
    }
}

