/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.value;

import java.io.IOException;
import java.text.DecimalFormat;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.value.SummaryValue;
import scouter.lang.value.Value;

public class DoubleSummary
extends SummaryValue
implements Value {
    public double sum;
    public int count;
    public double min;
    public double max;

    public byte getValueType() {
        return 45;
    }

    public void write(DataOutputX out) throws IOException {
        out.writeDouble(this.sum);
        out.writeInt(this.count);
        out.writeDouble(this.min);
        out.writeDouble(this.max);
    }

    public Value read(DataInputX in) throws IOException {
        this.sum = in.readDouble();
        this.count = in.readInt();
        this.min = in.readDouble();
        this.max = in.readDouble();
        return this;
    }

    public String toString() {
        DecimalFormat fmt = new DecimalFormat("#0.0#################");
        StringBuffer sb = new StringBuffer();
        sb.append("[sum=").append(fmt.format(new Double(this.sum)));
        sb.append(",count=").append(this.count);
        sb.append(",min=").append(fmt.format(new Double(this.min)));
        sb.append(",max=").append(fmt.format(new Double(this.max)));
        sb.append("]");
        return sb.toString();
    }

    public Object toJavaObject() {
        return this;
    }

    public void addcount() {
        ++this.count;
    }

    public SummaryValue add(Number value) {
        if (value == null) {
            return this;
        }
        if (this.count == 0) {
            this.sum = value.doubleValue();
            this.count = 1;
            this.max = value.doubleValue();
            this.min = value.doubleValue();
        } else {
            this.sum += value.doubleValue();
            ++this.count;
            this.max = Math.max(this.max, value.doubleValue());
            this.min = Math.min(this.min, value.doubleValue());
        }
        return this;
    }

    public SummaryValue add(SummaryValue other) {
        if (other == null || other.getCount() == 0) {
            return this;
        }
        this.count += other.getCount();
        this.sum += other.doubleSum();
        this.min = Math.min(this.min, other.doubleMin());
        this.max = Math.max(this.max, other.doubleMax());
        return this;
    }

    public long longSum() {
        return (long)this.sum;
    }

    public long longMin() {
        return (long)this.min;
    }

    public long longMax() {
        return (long)this.max;
    }

    public long longAvg() {
        return (long)(this.count == 0 ? 0.0 : this.sum / (double)this.count);
    }

    public double doubleSum() {
        return this.sum;
    }

    public double doubleMin() {
        return this.min;
    }

    public double doubleMax() {
        return this.max;
    }

    public double doubleAvg() {
        return this.count == 0 ? 0.0 : this.sum / (double)this.count;
    }

    public int getCount() {
        return this.count;
    }
}

