/*
 * Decompiled with CFR 0.152.
 */
package scouter.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import scouter.lang.conf.ConfigDesc;
import scouter.lang.conf.ConfigValueUtil;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.server.ConfObserver;
import scouter.util.FileUtil;
import scouter.util.StringEnumer;
import scouter.util.StringKeyLinkedMap;
import scouter.util.StringLinkedSet;
import scouter.util.StringSet;
import scouter.util.StringUtil;
import scouter.util.SysJMX;
import scouter.util.SystemUtil;
import scouter.util.ThreadUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configure
extends Thread {
    private static Configure instance = null;
    public static final String CONF_DIR = "./conf/";
    @ConfigDesc(value="Server ID")
    public String server_id = SysJMX.getHostName();
    @ConfigDesc(value="Logging TCP connection related event")
    public boolean log_tcp_action_enabled = false;
    @ConfigDesc(value="Logging incoming MultiPacket")
    public boolean log_udp_multipacket = false;
    @ConfigDesc(value="Logging expired MultiPacket")
    public boolean log_expired_multipacket = true;
    @ConfigDesc(value="Logging all incoming packs")
    public boolean log_udp_packet = false;
    @ConfigDesc(value="Logging incoming CounterPack")
    public boolean log_udp_counter = false;
    @ConfigDesc(value="Logging incoming XLogPack")
    public boolean log_udp_xlog = false;
    @ConfigDesc(value="Logging incoming ProfilePack")
    public boolean log_udp_profile = false;
    @ConfigDesc(value="Logging incoming TextPack")
    public boolean log_udp_text = false;
    @ConfigDesc(value="Logging incoming AlertPack")
    public boolean log_udp_alert = false;
    @ConfigDesc(value="Logging incoming ObjectPack")
    public boolean log_udp_object = false;
    @ConfigDesc(value="Logging incoming StatusPack")
    public boolean log_udp_status = false;
    @ConfigDesc(value="Logging incoming StackPack")
    public boolean log_udp_stack = false;
    @ConfigDesc(value="Logging incoming SummaryPack")
    public boolean log_udp_summary = false;
    @ConfigDesc(value="Logging incoming BatchPack")
    public boolean log_udp_batch = false;
    @ConfigDesc(value="Logging all request handlers in starting")
    public boolean log_service_handler_list = false;
    @ConfigDesc(value="Retaining log according to date")
    public boolean log_rotation_enabled = true;
    @ConfigDesc(value="Keeping period of log")
    public int log_keep_days = 31;
    @ConfigDesc(value="Logging sql failed to parse")
    public boolean log_sql_parsing_fail_enabled = false;
    @ConfigDesc(value="")
    public boolean _trace = false;
    @ConfigDesc(value="UDP Host")
    public String net_udp_listen_ip = "0.0.0.0";
    @ConfigDesc(value="UDP Port")
    public int net_udp_listen_port = 6100;
    @ConfigDesc(value="TCP Host")
    public String net_tcp_listen_ip = "0.0.0.0";
    @ConfigDesc(value="TCP Port")
    public int net_tcp_listen_port = 6100;
    @ConfigDesc(value="Client Socket Timeout(ms)")
    public int net_tcp_client_so_timeout_ms = 8000;
    @ConfigDesc(value="Agent Socket Timeout(ms)")
    public int net_tcp_agent_so_timeout_ms = 60000;
    @ConfigDesc(value="Transfer period(ms) of KEEP_ALIVE")
    public int net_tcp_agent_keepalive_interval_ms = 5000;
    @ConfigDesc(value="Waiting time(ms) for agent session")
    public int net_tcp_get_agent_connection_wait_ms = 1000;
    @ConfigDesc(value="UDP Packet Buffer Size")
    public int net_udp_packet_buffer_size = 65535;
    @ConfigDesc(value="UDP Receiver Buffer Size")
    public int net_udp_so_rcvbuf_size = 0x400000;
    @ConfigDesc(value="")
    public int _net_udp_worker_thread_count = 3;
    @ConfigDesc(value="TCP Thread Pool Size")
    public int net_tcp_service_pool_size = 100;
    @ConfigDesc(value="Activating Http Server")
    public boolean net_http_server_enabled = false;
    @ConfigDesc(value="Http Port")
    public int net_http_port = 6180;
    @ConfigDesc(value="Store directory of database")
    public String db_dir = "./database";
    @ConfigDesc(value="Path to log directory")
    public String log_dir = "./logs";
    @ConfigDesc(value="Path to plugin directory")
    public String plugin_dir = "./plugin";
    @ConfigDesc(value="Path to client related directory")
    public String client_dir = "./client";
    @ConfigDesc(value="Waiting time(ms) until stopped heartbeat of object is determined to be inactive")
    public int object_deadtime_ms = 8000;
    @ConfigDesc(value="Activating XLog data in zip file")
    public boolean compress_xlog_enabled = false;
    @ConfigDesc(value="Activating profile data in zip file")
    public boolean compress_profile_enabled = false;
    @ConfigDesc(value="")
    public int _compress_write_buffer_block_count = 3;
    @ConfigDesc(value="")
    public int _compress_read_cache_block_count = 3;
    @ConfigDesc(value="")
    public long _compress_read_cache_expired_ms = 60000L;
    @ConfigDesc(value="")
    public int _compress_dailycount_header_cache_size = 3;
    @ConfigDesc(value="")
    public int _compress_write_thread = 2;
    @ConfigDesc(value="")
    public boolean _auto_5m_sampling = true;
    @ConfigDesc(value="Activating automatic deletion function in the database")
    public boolean mgr_purge_enabled = true;
    @ConfigDesc(value="Automatic deletion only for XLog data")
    public boolean mgr_purge_only_xlog_enabled = false;
    @ConfigDesc(value="Condition of disc usage for automatic deletion")
    public int mgr_purge_disk_usage_pct = 80;
    @ConfigDesc(value="Retaining date for automatic deletion")
    public int mgr_purge_keep_days = 0;
    @ConfigDesc(value="Ignored log ID set")
    public StringSet mgr_log_ignore_ids = new StringSet();
    @ConfigDesc(value="XLog Writer Queue Size")
    public int xlog_queue_size = 10000;
    @ConfigDesc(value="Ignored time(ms) in retrieving XLog in real time")
    public int xlog_realtime_lower_bound_ms = 0;
    @ConfigDesc(value="Ignored time(ms) in retrieving previous XLog")
    public int xlog_pasttime_lower_bound_ms = 0;
    @ConfigDesc(value="Profile Writer Queue Size")
    public int profile_queue_size = 1000;
    @ConfigDesc(value="Activating IP-based city/country extraction")
    public boolean geoip_enabled = true;
    @ConfigDesc(value="Path to GeoIP data file")
    public String geoip_data_city_file = "./conf/GeoLiteCity.dat";
    @ConfigDesc(value="Activating table-based SQL compression")
    public boolean sql_table_parsing_enabled = true;
    @ConfigDesc(value="Activating TagCount function")
    public boolean tagcnt_enabled = false;
    public boolean visitor_hourly_count_enabled = true;
    private long last_load_time = -1L;
    public Properties property = new Properties();
    private boolean running = true;
    private File propertyFile;
    long last_check = 0L;
    public static boolean WORKABLE = true;
    private static HashSet<String> ignoreSet = new HashSet();

    public static final synchronized Configure getInstance() {
        if (instance == null) {
            instance = new Configure();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    private Configure() {
        this.reload(false);
    }

    private Configure(boolean b) {
    }

    @Override
    public void run() {
        while (this.running) {
            this.reload(false);
            ThreadUtil.sleep(3000L);
        }
    }

    public File getPropertyFile() {
        if (this.propertyFile != null) {
            return this.propertyFile;
        }
        String s = System.getProperty("scouter.config", "./conf/scouter.conf");
        this.propertyFile = new File(s.trim());
        return this.propertyFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean reload(boolean force) {
        long now = System.currentTimeMillis();
        if (!force && now < this.last_check + 3000L) {
            return false;
        }
        this.last_check = now;
        File file = this.getPropertyFile();
        if (file.lastModified() == this.last_load_time) {
            return false;
        }
        this.last_load_time = file.lastModified();
        Properties temp = new Properties();
        if (file.canRead()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                temp.load(in);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtil.close(in);
                    throw throwable;
                }
                FileUtil.close(in);
            }
            FileUtil.close(in);
        }
        this.property = ConfigValueUtil.replaceSysProp(temp);
        this.apply();
        return true;
    }

    private void apply() {
        this.xlog_queue_size = this.getInt("xlog_queue_size", 10000);
        this.profile_queue_size = this.getInt("profile_queue_size", 1000);
        this.log_tcp_action_enabled = this.getBoolean("log_tcp_action_enabled", false);
        this.net_udp_listen_ip = this.getValue("net_udp_listen_ip", "0.0.0.0");
        this.net_udp_listen_port = this.getInt("net_udp_listen_port", 6100);
        this.net_tcp_listen_ip = this.getValue("net_tcp_listen_ip", "0.0.0.0");
        this.net_tcp_listen_port = this.getInt("net_tcp_listen_port", 6100);
        this.net_tcp_client_so_timeout_ms = this.getInt("net_tcp_client_so_timeout_ms", 8000);
        this.net_tcp_agent_so_timeout_ms = this.getInt("net_tcp_agent_so_timeout_ms", 60000);
        this.net_tcp_agent_keepalive_interval_ms = this.getInt("net_tcp_agent_keepalive_interval_ms", 5000);
        this.net_tcp_get_agent_connection_wait_ms = this.getInt("net_tcp_get_agent_connection_wait_ms", 1000);
        this.net_http_server_enabled = this.getBoolean("net_http_server_enabled", false);
        this.net_http_port = this.getInt("net_http_port", 6180);
        this.server_id = this.getValue("server_id", SysJMX.getHostName());
        this.db_dir = this.getValue("db_dir", "./database");
        this.log_dir = this.getValue("log_dir", "./logs");
        this.plugin_dir = this.getValue("plugin_dir", "./plugin");
        this.client_dir = this.getValue("client_dir", "./client");
        this.object_deadtime_ms = this.getInt("object_deadtime_ms", 8000);
        this.compress_xlog_enabled = this.getBoolean("compress_xlog_enabled", false);
        this.compress_profile_enabled = this.getBoolean("compress_profile_enabled", false);
        this._compress_write_buffer_block_count = this.getInt("_compress_write_buffer_block_count", 3);
        this._compress_dailycount_header_cache_size = this.getInt("_compress_dailycount_header_cache_size", 3);
        this._compress_read_cache_block_count = this.getInt("_compress_read_cache_block_count", 3);
        this._compress_read_cache_expired_ms = this.getLong("_compress_read_cache_expired_ms", 60000L);
        this._compress_write_thread = this.getInt("_compress_write_thread", 2);
        this.net_udp_packet_buffer_size = this.getInt("net_udp_packet_buffer_size", 65535);
        int default_so_rcvbuf = 0x400000;
        if (SystemUtil.IS_AIX || SystemUtil.IS_HP_UX) {
            default_so_rcvbuf = 0;
        }
        this.net_udp_so_rcvbuf_size = this.getInt("net_udp_so_rcvbuf_size", default_so_rcvbuf);
        this.log_expired_multipacket = this.getBoolean("log_expired_multipacket", true);
        this.log_udp_multipacket = this.getBoolean("log_udp_multipacket", false);
        this.log_udp_packet = this.getBoolean("log_udp_packet", false);
        this.log_udp_counter = this.getBoolean("log_udp_counter", false);
        this.log_udp_xlog = this.getBoolean("log_udp_xlog", false);
        this.log_udp_profile = this.getBoolean("log_udp_profile", false);
        this.log_udp_text = this.getBoolean("log_udp_text", false);
        this.log_udp_alert = this.getBoolean("log_udp_alert", false);
        this.log_udp_object = this.getBoolean("log_udp_object", false);
        this.log_udp_status = this.getBoolean("log_udp_status", false);
        this.log_udp_stack = this.getBoolean("log_udp_stack", false);
        this.log_udp_summary = this.getBoolean("log_udp_summary", false);
        this.log_udp_batch = this.getBoolean("log_udp_batch", false);
        this.log_service_handler_list = this.getBoolean("log_service_handler_list", false);
        this.log_rotation_enabled = this.getBoolean("log_rotation_enabled", true);
        this.log_keep_days = this.getInt("log_keep_days", 31);
        this.log_sql_parsing_fail_enabled = this.getBoolean("log_sql_parsing_fail_enabled", false);
        this._trace = this.getBoolean("_trace", false);
        this._auto_5m_sampling = this.getBoolean("_auto_5m_sampling", true);
        this.xlog_realtime_lower_bound_ms = this.getInt("xlog_realtime_lower_bound_ms", 0);
        this.xlog_pasttime_lower_bound_ms = this.getInt("xlog_pasttime_lower_bound_ms", 0);
        this.mgr_purge_enabled = this.getBoolean("mgr_purge_enabled", true);
        this.mgr_purge_only_xlog_enabled = this.getBoolean("mgr_purge_only_xlog_enabled", false);
        this.mgr_purge_disk_usage_pct = this.getInt("mgr_purge_disk_usage_pct", 80);
        this.mgr_purge_keep_days = this.getInt("mgr_purge_keep_days", 0);
        this._net_udp_worker_thread_count = this.getInt("_net_udp_worker_thread_count", 3);
        this.geoip_data_city_file = this.getValue("geoip_data_city_file", "./conf/GeoLiteCity.dat");
        this.geoip_enabled = this.getBoolean("geoip_enabled", true);
        this.sql_table_parsing_enabled = this.getBoolean("sql_table_parsing_enabled", true);
        this.mgr_log_ignore_ids = this.getStringSet("mgr_log_ignore_ids", ",");
        this.tagcnt_enabled = this.getBoolean("tagcnt_enabled", false);
        this.visitor_hourly_count_enabled = this.getBoolean("visitor_hourly_count_enabled", true);
        this.net_tcp_service_pool_size = this.getInt("net_tcp_service_pool_size", 100);
        ConfObserver.exec();
    }

    private StringSet getStringSet(String key, String deli) {
        StringSet set = new StringSet();
        String v = this.getValue(key);
        if (v != null) {
            String[] vv;
            for (String x : vv = StringUtil.split(v, deli)) {
                if ((x = StringUtil.trimToEmpty(x)).length() <= 0) continue;
                set.put(x);
            }
        }
        return set;
    }

    public String getValue(String key) {
        return StringUtil.trim(this.property.getProperty(key));
    }

    public String getValue(String key, String def) {
        return StringUtil.trim(this.property.getProperty(key, def));
    }

    public int getInt(String key, int def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Integer.parseInt(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public long getLong(String key, long def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Long.parseLong(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Boolean.parseBoolean(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String loadText() {
        String string;
        File file = this.getPropertyFile();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            byte[] buff = FileUtil.readAll(fin);
            string = new String(buff);
        }
        catch (Exception exception) {
            FileUtil.close(fin);
            return null;
        }
        catch (Throwable throwable) {
            FileUtil.close(fin);
            throw throwable;
        }
        FileUtil.close(fin);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveText(String text) {
        block6: {
            boolean bl;
            File file = this.getPropertyFile();
            FileOutputStream out = null;
            try {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                out = new FileOutputStream(file);
                ((OutputStream)out).write(text.getBytes());
                bl = true;
                FileUtil.close(out);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                FileUtil.close(out);
            }
            return bl;
        }
        return false;
    }

    public static void main(String[] args) {
        Configure o = new Configure(true);
        StringKeyLinkedMap<Object> defMap = ConfigValueUtil.getConfigDefault(o);
        StringKeyLinkedMap<String> descMap = ConfigValueUtil.getConfigDescMap(o);
        StringEnumer enu = defMap.keys();
        while (enu.hasMoreElements()) {
            String key = enu.nextString();
            if (ignoreSet.contains(key)) continue;
            System.out.println(key + " : " + ConfigValueUtil.toValue(defMap.get(key) + (descMap.containsKey(key) ? " (" + descMap.get(key) + ")" : "")));
        }
    }

    public MapValue getKeyValueInfo() {
        StringKeyLinkedMap<Object> defMap = ConfigValueUtil.getConfigDefault(new Configure(true));
        StringKeyLinkedMap<Object> curMap = ConfigValueUtil.getConfigDefault(this);
        MapValue m = new MapValue();
        ListValue nameList = m.newList("key");
        ListValue valueList = m.newList("value");
        ListValue defList = m.newList("default");
        StringEnumer enu = defMap.keys();
        while (enu.hasMoreElements()) {
            String key = enu.nextString();
            if (ignoreSet.contains(key)) continue;
            nameList.add(key);
            valueList.add(ConfigValueUtil.toValue(curMap.get(key)));
            defList.add(ConfigValueUtil.toValue(defMap.get(key)));
        }
        return m;
    }

    public StringKeyLinkedMap<String> getConfigureDesc() {
        return ConfigValueUtil.getConfigDescMap(this);
    }

    public static StringLinkedSet toOrderSet(String values, String deli) {
        StringLinkedSet set = new StringLinkedSet();
        StringTokenizer nizer = new StringTokenizer(values, deli);
        while (nizer.hasMoreTokens()) {
            String s = StringUtil.trimToEmpty(nizer.nextToken());
            if (s.length() <= 0) continue;
            set.put(s);
        }
        return set;
    }

    static {
        ignoreSet.add("property");
    }
}

