/*
 * Decompiled with CFR 0.152.
 */
package scouter.server;

import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import scouter.lang.Counter;
import scouter.lang.Family;
import scouter.lang.ObjectType;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.util.XmlUtil;
import scouter.util.FileUtil;

public class CounterManager {
    private static final String CUSTOM_FILENAME = "counters.site.xml";
    private static volatile CounterManager instance;
    CounterEngine engine = new CounterEngine();
    File customFile;
    byte[] xmlContent;
    byte[] xmlCustomContent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CounterManager getInstance() {
        if (instance != null) return instance;
        Class<CounterManager> clazz = CounterManager.class;
        synchronized (CounterManager.class) {
            if (instance != null) return instance;
            instance = new CounterManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CounterManager() {
        this.init();
    }

    private void init() {
        this.readAndParseXml("/scouter/lang/counters/counters.xml");
        this.customFile = new File("./conf/counters.site.xml");
        if (this.customFile.canRead()) {
            this.xmlCustomContent = FileUtil.readAll(this.customFile);
            this.engine.parse(this.xmlCustomContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndParseXml(String path) {
        InputStream in = CounterEngine.class.getResourceAsStream(path);
        try {
            this.xmlContent = FileUtil.readAll(in);
            this.engine.parse(this.xmlContent);
        }
        catch (Exception e) {
            Logger.println("Failed read " + path);
        }
        finally {
            FileUtil.close(in);
        }
    }

    public CounterEngine getCounterEngine() {
        return this.engine;
    }

    public byte[] getXmlContent() {
        return this.xmlContent;
    }

    public byte[] getXmlCustomContent() {
        return this.xmlCustomContent;
    }

    public synchronized boolean addFamily(Family family) {
        Document doc = this.appendFamily(family, this.getCustomDocument());
        if (doc != null) {
            XmlUtil.writeXmlFileWithIndent(doc, this.customFile, 2);
            this.xmlCustomContent = FileUtil.readAll(this.customFile);
            this.reloadEngine();
            return true;
        }
        return false;
    }

    public synchronized boolean addFamilyAndObjectType(Family family, ObjectType objectType) {
        Document doc = this.appendFamily(family, this.getCustomDocument());
        if (doc != null && (doc = this.appendObjectType(objectType, doc)) != null) {
            XmlUtil.writeXmlFileWithIndent(doc, this.customFile, 2);
            this.xmlCustomContent = FileUtil.readAll(this.customFile);
            this.reloadEngine();
            return true;
        }
        return false;
    }

    public boolean addObjectType(MapPack param) {
        String name = param.getText("name");
        if (this.engine.getObjectType(name) != null) {
            return false;
        }
        String displayName = param.getText("disp");
        String family = param.getText("family");
        String icon = param.getText("icon");
        boolean subobject = param.getBoolean("sub-object");
        ObjectType objType2 = new ObjectType();
        objType2.setName(name);
        objType2.setDisplayName(displayName);
        objType2.setIcon(icon);
        objType2.setFamily(this.engine.getFamily(family));
        objType2.setSubObject(subobject);
        return this.addObjectType(objType2);
    }

    public synchronized boolean addObjectType(ObjectType objType2) {
        Document doc = this.appendObjectType(objType2, this.getCustomDocument());
        if (doc != null) {
            XmlUtil.writeXmlFileWithIndent(doc, this.customFile, 2);
            this.xmlCustomContent = FileUtil.readAll(this.customFile);
            this.reloadEngine();
            return true;
        }
        return false;
    }

    public boolean editObjectType(MapPack param) {
        String name = param.getText("name");
        String displayName = param.getText("disp");
        String family = param.getText("family");
        String icon = param.getText("icon");
        boolean subobject = param.getBoolean("sub-object");
        ObjectType objType2 = new ObjectType();
        objType2.setName(name);
        objType2.setDisplayName(displayName);
        objType2.setIcon(icon);
        objType2.setFamily(this.engine.getFamily(family));
        objType2.setSubObject(subobject);
        return this.editObjectType(objType2);
    }

    public synchronized boolean editObjectType(ObjectType objType2) {
        Document doc = this.editOrAppendObjectType(objType2, this.getCustomDocument());
        if (doc != null) {
            XmlUtil.writeXmlFileWithIndent(doc, this.customFile, 2);
            this.xmlCustomContent = FileUtil.readAll(this.customFile);
            this.reloadEngine();
            return true;
        }
        return false;
    }

    private Document appendObjectType(ObjectType objType2, Document doc) {
        try {
            Element rootElement = (Element)doc.getElementsByTagName("Counters").item(0);
            Element typesElements = (Element)doc.getElementsByTagName("Types").item(0);
            if (rootElement == null) {
                rootElement = doc.createElement("Counters");
                doc.appendChild(rootElement);
            }
            if (typesElements == null) {
                typesElements = doc.createElement("Types");
                rootElement.appendChild(typesElements);
            }
            Element objElement = doc.createElement("ObjectType");
            CounterManager.setObjectTypeAttribute(doc, objElement, objType2);
            typesElements.appendChild(objElement);
        }
        catch (Exception e) {
            Logger.printStackTrace(e);
            return null;
        }
        return doc;
    }

    private Document editOrAppendObjectType(ObjectType objType2, Document doc) {
        try {
            NodeList list;
            Element rootElement = (Element)doc.getElementsByTagName("Counters").item(0);
            Element typesElements = (Element)doc.getElementsByTagName("Types").item(0);
            boolean found = false;
            if (rootElement == null) {
                rootElement = doc.createElement("Counters");
                doc.appendChild(rootElement);
            }
            if (typesElements == null) {
                typesElements = doc.createElement("Types");
                rootElement.appendChild(typesElements);
            }
            if ((list = doc.getElementsByTagName("ObjectType")) == null || list.getLength() < 1) {
                Element objElement = doc.createElement("ObjectType");
                CounterManager.setObjectTypeAttribute(doc, objElement, objType2);
                typesElements.appendChild(objElement);
                found = true;
            } else {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element objElement = (Element)node;
                    String name = objElement.getAttribute("name");
                    if (!objType2.getName().equals(name)) continue;
                    CounterManager.setObjectTypeAttribute(doc, objElement, objType2);
                    found = true;
                    break;
                }
                if (!found) {
                    Element objElement = doc.createElement("ObjectType");
                    CounterManager.setObjectTypeAttribute(doc, objElement, objType2);
                    typesElements.appendChild(objElement);
                    found = true;
                }
            }
            if (found) {
                return doc;
            }
        }
        catch (Exception e) {
            Logger.printStackTrace(e);
            return null;
        }
        return null;
    }

    private static void setObjectTypeAttribute(Document doc, Element objElement, ObjectType objType2) {
        objElement.setAttribute("name", objType2.getName());
        objElement.setAttribute("disp", objType2.getDisplayName());
        objElement.setAttribute("family", objType2.getFamily().getName());
        objElement.setAttribute("icon", objType2.getIcon());
        objElement.setAttribute("sub-object", objType2.isSubObject() ? "true" : "false");
        for (Counter counter : objType2.listObjectTypeCounters()) {
            Element counterElement = doc.createElement("Counter");
            counterElement.setAttribute("name", counter.getName());
            counterElement.setAttribute("disp", counter.getDisplayName());
            counterElement.setAttribute("unit", counter.getUnit());
            counterElement.setAttribute("icon", counter.getIcon());
            counterElement.setAttribute("all", counter.isAll() ? "true" : "false");
            counterElement.setAttribute("total", counter.isTotal() ? "true" : "false");
            objElement.appendChild(counterElement);
        }
    }

    private Document appendFamily(Family family, Document doc) {
        try {
            Element rootElement = (Element)doc.getElementsByTagName("Counters").item(0);
            Element familysElement = (Element)doc.getElementsByTagName("Familys").item(0);
            if (rootElement == null) {
                rootElement = doc.createElement("Counters");
                doc.appendChild(rootElement);
            }
            if (familysElement == null) {
                familysElement = doc.createElement("Familys");
                rootElement.appendChild(familysElement);
            }
            Element familyElement = doc.createElement("Family");
            familyElement.setAttribute("name", family.getName());
            familyElement.setAttribute("master", family.getMaster());
            familysElement.appendChild(familyElement);
            for (Counter counter : family.listCounters()) {
                Element counterElement = doc.createElement("Counter");
                counterElement.setAttribute("name", counter.getName());
                counterElement.setAttribute("disp", counter.getDisplayName());
                counterElement.setAttribute("unit", counter.getUnit());
                counterElement.setAttribute("icon", counter.getIcon());
                counterElement.setAttribute("all", counter.isAll() ? "true" : "false");
                counterElement.setAttribute("total", counter.isTotal() ? "true" : "false");
                familyElement.appendChild(counterElement);
            }
        }
        catch (Exception e) {
            Logger.printStackTrace(e);
            return null;
        }
        return doc;
    }

    private Document getCustomDocument() {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            if (this.customFile.canRead()) {
                doc = builder.parse(this.customFile);
                doc.getDocumentElement().normalize();
            } else {
                doc = builder.newDocument();
            }
        }
        catch (Exception e) {
            Logger.printStackTrace(e);
        }
        return doc;
    }

    public static void main(String[] args) {
        File f = Configure.getInstance().getPropertyFile();
        System.out.println(f.getParent());
    }

    private void reloadEngine() {
        this.engine.clear();
        this.engine.parse(this.xmlContent);
        this.engine.parse(this.xmlCustomContent);
    }
}

