/*
 * Decompiled with CFR 0.152.
 */
package scouter.server;

import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scouter.lang.Account;
import scouter.server.LoginUser;
import scouter.server.account.AccountManager$;
import scouter.server.util.EnumerScala$;
import scouter.server.util.ThreadScala$;
import scouter.util.CacheTable;
import scouter.util.KeyGen;
import scouter.util.ThreadUtil;

public final class LoginManager$ {
    public static final LoginManager$ MODULE$;
    private final CacheTable<Object, LoginUser> sessionTable;

    static {
        new LoginManager$();
    }

    public CacheTable<Object, LoginUser> sessionTable() {
        return this.sessionTable;
    }

    public long login(String id, String pwd, String ip) {
        Account account = AccountManager$.MODULE$.authorizeAccount(id, pwd);
        if (account == null) {
            return 0L;
        }
        LoginUser u = new LoginUser();
        u.id_$eq(id);
        u.ip_$eq(ip);
        u.passwd_$eq(pwd);
        u.group_$eq(account.group);
        u.logintime_$eq(System.currentTimeMillis());
        long key = KeyGen.next();
        u.session_$eq(key);
        this.sessionTable().put(BoxesRunTime.boxToLong((long)key), u);
        return key;
    }

    public LoginUser getUser(long session) {
        return this.sessionTable().get(BoxesRunTime.boxToLong((long)session));
    }

    public boolean okSession(long key) {
        return this.sessionTable().getKeepAlive(BoxesRunTime.boxToLong((long)key)) != null;
    }

    public int validSession(long key) {
        LoginUser u = this.sessionTable().getKeepAlive(BoxesRunTime.boxToLong((long)key));
        return u == null ? 0 : 1;
    }

    public LoginUser[] getLoginUserList() {
        LoginUser[] loginUsers = new LoginUser[this.sessionTable().size()];
        IntRef index = new IntRef(0);
        EnumerScala$.MODULE$.foreach(this.sessionTable().keys(), new Serializable(loginUsers, index){
            public static final long serialVersionUID = 0L;
            private final LoginUser[] loginUsers$1;
            private final IntRef index$1;

            public final void apply(long session) {
                this.apply$mcVJ$sp(session);
            }

            public void apply$mcVJ$sp(long session) {
                this.loginUsers$1[this.index$1.elem] = LoginManager$.MODULE$.sessionTable().get(BoxesRunTime.boxToLong((long)session));
                ++this.index$1.elem;
            }
            {
                this.loginUsers$1 = loginUsers$1;
                this.index$1 = index$1;
            }
        });
        return loginUsers;
    }

    private LoginManager$() {
        MODULE$ = this;
        this.sessionTable = new CacheTable().setDefaultKeepTime(10800000L);
        ThreadScala$.MODULE$.startDaemon("scouter.server.LoginManager", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (true) {
                    LoginManager$.MODULE$.sessionTable().clearExpiredItems();
                    ThreadUtil.sleep(5000L);
                }
            }
        });
    }
}

