/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.account;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scouter.lang.Account;
import scouter.lang.pack.MapPack;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.account.AccountFileHandler$;
import scouter.server.account.GroupFileHandler$;
import scouter.server.core.CoreRun$;
import scouter.server.util.ThreadScala$;
import scouter.util.FileUtil;
import scouter.util.StringKeyLinkedMap;

public final class AccountManager$ {
    public static final AccountManager$ MODULE$;
    private final String ACCOUNT_FILENAME;
    private final String GROUP_FILENAME;
    private StringKeyLinkedMap<Account> accountMap;
    private StringKeyLinkedMap<MapValue> groupPolicyMap;
    private final String confPath;
    private Configure conf;
    private final File groupFile;
    private final File accountFile;
    private long lastModifiedAccountFile;
    private long lastModifiedGroupFile;

    static {
        new AccountManager$();
    }

    public String ACCOUNT_FILENAME() {
        return this.ACCOUNT_FILENAME;
    }

    public String GROUP_FILENAME() {
        return this.GROUP_FILENAME;
    }

    public StringKeyLinkedMap<Account> accountMap() {
        return this.accountMap;
    }

    public void accountMap_$eq(StringKeyLinkedMap<Account> x$1) {
        this.accountMap = x$1;
    }

    public StringKeyLinkedMap<MapValue> groupPolicyMap() {
        return this.groupPolicyMap;
    }

    public void groupPolicyMap_$eq(StringKeyLinkedMap<MapValue> x$1) {
        this.groupPolicyMap = x$1;
    }

    public String confPath() {
        return this.confPath;
    }

    public Configure conf() {
        return this.conf;
    }

    public void conf_$eq(Configure x$1) {
        this.conf = x$1;
    }

    public File groupFile() {
        return this.groupFile;
    }

    public File accountFile() {
        return this.accountFile;
    }

    public long lastModifiedAccountFile() {
        return this.lastModifiedAccountFile;
    }

    public void lastModifiedAccountFile_$eq(long x$1) {
        this.lastModifiedAccountFile = x$1;
    }

    public long lastModifiedGroupFile() {
        return this.lastModifiedGroupFile;
    }

    public void lastModifiedGroupFile_$eq(long x$1) {
        this.lastModifiedGroupFile = x$1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void scouter$server$account$AccountManager$$loadGroupFile() {
        try {
            Logger$.MODULE$.println("Load Account Group File");
            if (!this.groupFile().canRead()) {
                InputStream in = null;
                FileOutputStream fos = null;
                boolean copyFailed = true;
                int tryCnt = 0;
                while (copyFailed) {
                    try {
                        ++tryCnt;
                        in = this.getClass().getResourceAsStream(new StringBuilder().append((Object)"/scouter/server/account/").append((Object)this.GROUP_FILENAME()).toString());
                        fos = new FileOutputStream(this.groupFile());
                        fos.write(FileUtil.readAll(in));
                        copyFailed = false;
                    }
                    catch (Throwable throwable) {
                        FileUtil.close(fos);
                        FileUtil.close(in);
                        throw throwable;
                    }
                    FileUtil.close(fos);
                    FileUtil.close(in);
                }
            }
            this.groupPolicyMap_$eq(GroupFileHandler$.MODULE$.parse(this.groupFile()));
            this.lastModifiedGroupFile_$eq(this.groupFile().lastModified());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void scouter$server$account$AccountManager$$loadAccountFile() {
        try {
            Logger$.MODULE$.println("Load Account File");
            if (!this.accountFile().canRead()) {
                InputStream in = null;
                FileOutputStream fos = null;
                boolean copyFailed = true;
                int tryCnt = 0;
                while (copyFailed) {
                    try {
                        ++tryCnt;
                        in = this.getClass().getResourceAsStream(new StringBuilder().append((Object)"/scouter/server/account/").append((Object)this.ACCOUNT_FILENAME()).toString());
                        fos = new FileOutputStream(this.accountFile());
                        fos.write(FileUtil.readAll(in));
                        copyFailed = false;
                    }
                    catch (Throwable throwable) {
                        FileUtil.close(fos);
                        FileUtil.close(in);
                        throw throwable;
                    }
                    FileUtil.close(fos);
                    FileUtil.close(in);
                }
            }
            this.accountMap_$eq(AccountFileHandler$.MODULE$.parse(this.accountFile()));
            this.lastModifiedAccountFile_$eq(this.accountFile().lastModified());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public Account authorizeAccount(String id, String pass) {
        block15: {
            block14: {
                block16: {
                    block17: {
                        if (!this.conf().getBoolean("account_use_ldap", false)) break block16;
                        ctx = null;
                        props = new Properties();
                        props.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                        props.setProperty("java.naming.provider.url", this.conf().getValue("account_ldap_provider_url"));
                        props.setProperty("java.naming.security.authentication", this.conf().getValue("account_ldap_auth=", "simple"));
                        props.setProperty("java.naming.security.principal", new StringBuilder().append((Object)id).append((Object)this.conf().getValue("account_ldap_principal_domain")).toString());
                        props.setProperty("java.naming.security.credentials", pass);
                        ctx = new InitialDirContext(props);
                        cons = new SearchControls();
                        cons.setSearchScope(2);
                        searchFilter = new StringBuilder().append((Object)"(cn=").append((Object)id).append((Object)")").toString();
                        if (this.conf().getBoolean("account_ldap_debug", false)) {
                            Logger$.MODULE$.println(new StringBuilder().append((Object)"ldap id : ").append((Object)id).toString());
                            Logger$.MODULE$.println(new StringBuilder().append((Object)"ldap pass : ").append((Object)pass).toString());
                            Logger$.MODULE$.println(new StringBuilder().append((Object)"ldap properties : ").append((Object)props.toString()).toString());
                        }
                        result = ctx.search(this.conf().getValue("account_ldap_basedn"), searchFilter, cons);
                        nextEntry = null;
                        if (!result.hasMore()) break block17;
                        attrs = result.next().getAttributes();
                        nmEnum = attrs.getIDs();
                        while (nmEnum.hasMore()) {
                            _id = nmEnum.next();
                            if (!id.equals(attrs.get(_id).get().toString())) continue;
                            account = new Account();
                            account.id = id;
                            account.email = attrs.get(this.conf().getValue("account_ldap_email_id", "")).get().toString();
                            account.group = attrs.get(this.conf().getValue("account_ldap_group_id", "")).get().toString();
                            ** GOTO lbl55
                        }
                    }
                    ** if (ctx == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        ctx.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block14;
                    }
                }
                account = this.accountMap().get(id);
                if (account == null) {
                    return null;
                }
                if (account.password.equals(pass)) {
                    return account;
                }
                break block14;
                {
                    catch (NullPointerException var15_14) {
                        try {
                            try {
                                var15_14.printStackTrace();
lbl55:
                                // 2 sources

                                v0 = account;
                                break block15;
                            }
                            catch (Exception var5_15) {
                                Logger$.MODULE$.println(new StringBuilder().append((Object)"Ldap Account Error : ").append((Object)var5_15.toString()).toString());
                                var5_15.printStackTrace();
                            }
                        }
                        catch (Throwable var6_16) {
                            throw var6_16;
                        }
                        finally {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                    }
                }
            }
            return null;
        }
        return v0;
    }

    public List<Account> getAccountList() {
        ArrayList<Account> list = new ArrayList<Account>();
        Enumeration<Account> accEnu = this.accountMap().values();
        while (accEnu.hasMoreElements()) {
            list.add(accEnu.nextElement());
        }
        return list;
    }

    public String[] getGroupList() {
        return this.groupPolicyMap().keyArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean addAccount(Account account) {
        if (this.accountMap().get(account.id) != null) return false;
        try {
            AccountFileHandler$.MODULE$.addAccount(this.accountFile(), account);
            this.accountMap().put(account.id, account);
            this.lastModifiedAccountFile_$eq(this.accountFile().lastModified());
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public synchronized boolean editAccount(Account account) {
        if (this.accountMap().get(account.id) == null) {
            return false;
        }
        try {
            AccountFileHandler$.MODULE$.editAccount(this.accountFile(), account);
            this.accountMap().put(account.id, account);
            this.lastModifiedAccountFile_$eq(this.accountFile().lastModified());
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public synchronized boolean addAccountGroup(MapPack pack) {
        String name = pack.getText("name");
        Value v = pack.get("policy");
        if (name == null || v == null) {
            return false;
        }
        boolean result = GroupFileHandler$.MODULE$.addAccountGroup(this.groupFile(), name, (MapValue)v);
        if (result) {
            this.groupPolicyMap().put(name, (MapValue)v);
            this.lastModifiedGroupFile_$eq(this.groupFile().lastModified());
        }
        return result;
    }

    public synchronized boolean editGroupPolicy(MapPack pack) {
        boolean result = GroupFileHandler$.MODULE$.editGroupPolicy(this.groupFile(), pack);
        if (result) {
            this.scouter$server$account$AccountManager$$loadGroupFile();
        }
        return result;
    }

    public boolean avaliableId(String id) {
        return !this.accountMap().containsKey(id);
    }

    public Account getAccount(String id) {
        return this.accountMap().get(id);
    }

    public MapValue getGroupPolicy(String groupName) {
        return this.groupPolicyMap().get(groupName);
    }

    public byte[] readAccountGroup() {
        return FileUtil.readAll(this.groupFile());
    }

    private AccountManager$() {
        MODULE$ = this;
        this.ACCOUNT_FILENAME = "account.xml";
        this.GROUP_FILENAME = "account_group.xml";
        this.accountMap = new StringKeyLinkedMap();
        this.groupPolicyMap = new StringKeyLinkedMap();
        this.confPath = Configure.CONF_DIR;
        this.conf = Configure.getInstance();
        FileUtil.mkdirs(this.confPath());
        this.groupFile = new File(new StringBuilder().append((Object)this.confPath()).append((Object)this.GROUP_FILENAME()).toString());
        this.accountFile = new File(new StringBuilder().append((Object)this.confPath()).append((Object)this.ACCOUNT_FILENAME()).toString());
        this.scouter$server$account$AccountManager$$loadGroupFile();
        this.scouter$server$account$AccountManager$$loadAccountFile();
        this.lastModifiedAccountFile = 0L;
        this.lastModifiedGroupFile = 0L;
        ThreadScala$.MODULE$.startDaemon("scouter.server.account.AccountManager", (Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return CoreRun$.MODULE$.running();
            }
        }, 5000L, (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (AccountManager$.MODULE$.groupFile().lastModified() != AccountManager$.MODULE$.lastModifiedGroupFile()) {
                    AccountManager$.MODULE$.scouter$server$account$AccountManager$$loadGroupFile();
                }
                if (AccountManager$.MODULE$.accountFile().lastModified() != AccountManager$.MODULE$.lastModifiedAccountFile()) {
                    AccountManager$.MODULE$.scouter$server$account$AccountManager$$loadAccountFile();
                }
            }
        });
    }
}

