/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.lang.ObjectType;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.AlertPack;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.TextPack;
import scouter.lang.value.ListValue;
import scouter.server.Configure;
import scouter.server.CounterManager;
import scouter.server.Logger$;
import scouter.server.core.AlertCore$;
import scouter.server.core.CoreRun$;
import scouter.server.core.ObjectMap;
import scouter.server.core.TextCore$;
import scouter.server.core.cache.AlertCache$;
import scouter.server.core.cache.CommonCache$;
import scouter.server.db.ObjectRD$;
import scouter.server.db.ObjectWR$;
import scouter.server.plugin.PlugInManager;
import scouter.server.util.EnumerScala$;
import scouter.server.util.ThreadScala$;
import scouter.util.CompareUtil;
import scouter.util.DateUtil;
import scouter.util.HashUtil;

public final class AgentManager$ {
    public static final AgentManager$ MODULE$;
    private final CounterEngine scouter$server$core$AgentManager$$counterEngine;
    private int scouter$server$core$AgentManager$$primaryObjCount;
    private final ObjectMap scouter$server$core$AgentManager$$objMap;

    static {
        new AgentManager$();
    }

    public CounterEngine scouter$server$core$AgentManager$$counterEngine() {
        return this.scouter$server$core$AgentManager$$counterEngine;
    }

    private int scouter$server$core$AgentManager$$primaryObjCount() {
        return this.scouter$server$core$AgentManager$$primaryObjCount;
    }

    public void scouter$server$core$AgentManager$$primaryObjCount_$eq(int x$1) {
        this.scouter$server$core$AgentManager$$primaryObjCount = x$1;
    }

    public ObjectMap scouter$server$core$AgentManager$$objMap() {
        return this.scouter$server$core$AgentManager$$objMap;
    }

    private void read() {
        List<ObjectPack> list = ObjectRD$.MODULE$.getObjectList(DateUtil.yyyymmdd());
        this.scouter$server$core$AgentManager$$objMap().putAll(list);
    }

    public boolean isActive(int agentKey) {
        ObjectPack objPack = this.scouter$server$core$AgentManager$$objMap().getObject(agentKey);
        return objPack == null ? false : objPack.alive;
    }

    public void active(ObjectPack p) {
        if (p.objHash == 0) {
            p.objHash = HashUtil.hash(p.objName);
        }
        PlugInManager.active(p);
        ObjectPack objPack = this.scouter$server$core$AgentManager$$objMap().getObject(p.objHash);
        if (objPack == null) {
            objPack = p;
            objPack.wakeup();
            this.scouter$server$core$AgentManager$$objMap().put(objPack);
            this.procObjName(objPack);
            ObjectWR$.MODULE$.add(objPack);
            Logger$.MODULE$.println("S104", new StringBuilder().append((Object)"New ").append((Object)objPack).toString());
        } else {
            boolean save = false;
            if (DateUtil.getDateUnit(objPack.wakeup) != DateUtil.getDateUnit(System.currentTimeMillis())) {
                objPack.updated = 0;
                save = true;
            }
            objPack.wakeup();
            objPack.tags = p.tags;
            if (!CompareUtil.equals(p.address, objPack.address)) {
                save = true;
            }
            if (!CompareUtil.equals(p.objType, objPack.objType)) {
                save = true;
            }
            if (!CompareUtil.equals(p.version, objPack.version)) {
                save = true;
            }
            if (save) {
                ObjectPack objectPack = objPack;
                ++objectPack.updated;
                if (objPack.updated % 20 == 0) {
                    this.alertTooManyChange(objPack);
                }
                p.updated = objPack.updated;
                p.wakeup();
                this.scouter$server$core$AgentManager$$objMap().put(p);
                this.procObjName(p);
                ObjectWR$.MODULE$.add(p);
                Logger$.MODULE$.println("S105", new StringBuilder().append((Object)"Update ").append((Object)p).toString());
            }
        }
    }

    private void alertTooManyChange(ObjectPack objPack) {
        AlertPack p = new AlertPack();
        p.level = 0;
        p.title = "MAYBE_OBJ_DUP";
        p.message = new StringBuilder().append((Object)"Maybe duplicated objNames!! Please check ").append((Object)objPack).toString();
        p.time = System.currentTimeMillis();
        p.objType = "scouter";
        AlertCache$.MODULE$.put(p);
    }

    private void alertInactiveObject(ObjectPack objPack) {
        AlertPack p = new AlertPack();
        p.level = 1;
        p.objHash = objPack.objHash;
        p.title = "INACTIVE_OBJECT";
        p.message = new StringBuilder().append((Object)objPack.objName).append((Object)" is not running. ").append((Object)objPack).toString();
        p.time = System.currentTimeMillis();
        p.objType = "scouter";
        AlertCore$.MODULE$.add(p);
    }

    private void procObjName(ObjectPack objPack) {
        TextPack tp = new TextPack();
        tp.xtype = "object";
        tp.hash = objPack.objHash;
        tp.text = objPack.objName;
        TextCore$.MODULE$.add(tp);
    }

    public String getAgentName(int objHash) {
        ObjectPack objPack = this.scouter$server$core$AgentManager$$objMap().getObject(objHash);
        return objPack == null ? null : objPack.objName;
    }

    public ObjectPack getAgent(int objHash) {
        return this.scouter$server$core$AgentManager$$objMap().getObject(objHash);
    }

    public void inactive(int objHash) {
        ObjectPack objPack = this.scouter$server$core$AgentManager$$objMap().getObject(objHash);
        if (objPack != null && objPack.alive) {
            objPack.alive = false;
            ObjectType obj = this.scouter$server$core$AgentManager$$counterEngine().getObjectType(objPack.objType);
            if (obj != null && !obj.isSubObject()) {
                this.alertInactiveObject(objPack);
            }
        }
    }

    public void clearInactive() {
        ArrayList<ObjectPack> death = new ArrayList<ObjectPack>();
        Enumeration<ObjectPack> itr = this.scouter$server$core$AgentManager$$objMap().objects();
        while (itr.hasMoreElements()) {
            ObjectPack objPack = itr.nextElement();
            Object object = !objPack.alive ? BoxesRunTime.boxToBoolean((boolean)death.add(objPack)) : BoxedUnit.UNIT;
        }
        EnumerScala$.MODULE$.foreach(death.iterator(), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ObjectPack o) {
                AgentManager$.MODULE$.scouter$server$core$AgentManager$$objMap().remove(o.objHash);
            }
        });
    }

    public List<Object> getLiveObjHashList() {
        ArrayList<Object> agents = new ArrayList<Object>();
        try {
            Enumeration<ObjectPack> itr = this.scouter$server$core$AgentManager$$objMap().objects();
            while (itr.hasMoreElements()) {
                ObjectPack a = itr.nextElement();
                Object object = a.alive ? BoxesRunTime.boxToBoolean((boolean)agents.add(BoxesRunTime.boxToInteger((int)a.objHash))) : BoxedUnit.UNIT;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return agents;
    }

    public List<Object> getObjHashList() {
        ArrayList<Object> agents = new ArrayList<Object>();
        Enumeration<ObjectPack> itr = this.scouter$server$core$AgentManager$$objMap().objects();
        while (itr.hasMoreElements()) {
            ObjectPack a = itr.nextElement();
            agents.add(BoxesRunTime.boxToInteger((int)a.objHash));
        }
        return agents;
    }

    public List<Object> getLiveObjHashList(String objType2) {
        ArrayList<Object> agents = new ArrayList<Object>();
        Enumeration<ObjectPack> itr = this.scouter$server$core$AgentManager$$objMap().enumTypeObject(objType2);
        while (itr.hasMoreElements()) {
            ObjectPack a = itr.nextElement();
            Object object = a.alive ? BoxesRunTime.boxToBoolean((boolean)agents.add(BoxesRunTime.boxToInteger((int)a.objHash))) : BoxedUnit.UNIT;
        }
        return agents;
    }

    public List<Object> getObjHashList(String objType2) {
        ArrayList<Object> agents = new ArrayList<Object>();
        Enumeration<ObjectPack> itr = this.scouter$server$core$AgentManager$$objMap().enumTypeObject(objType2);
        while (itr.hasMoreElements()) {
            ObjectPack a = itr.nextElement();
            agents.add(BoxesRunTime.boxToInteger((int)a.objHash));
        }
        return agents;
    }

    public List<ObjectPack> getObjList(String objType2) {
        ArrayList<ObjectPack> agents = new ArrayList<ObjectPack>();
        Enumeration<ObjectPack> itr = this.scouter$server$core$AgentManager$$objMap().enumTypeObject(objType2);
        while (itr.hasMoreElements()) {
            ObjectPack a = itr.nextElement();
            agents.add(a);
        }
        return agents;
    }

    public List<Object> filter(String word) {
        if ("*".equals(word)) {
            return this.getLiveObjHashList();
        }
        if (this.isObjType(word)) {
            return this.getObjHashList(word);
        }
        ArrayList<Object> agents = new ArrayList<Object>();
        Enumeration<ObjectPack> itr = this.scouter$server$core$AgentManager$$objMap().objects();
        while (itr.hasMoreElements()) {
            ObjectPack a = itr.nextElement();
            Object object = a.objName.indexOf(word) >= 0 ? BoxesRunTime.boxToBoolean((boolean)agents.add(BoxesRunTime.boxToInteger((int)a.objHash))) : BoxedUnit.UNIT;
        }
        return agents;
    }

    public boolean isObjType(String word) {
        return this.scouter$server$core$AgentManager$$objMap().getTypeObjects(word) != null;
    }

    public Enumeration<ObjectPack> getObjPacks() {
        return this.scouter$server$core$AgentManager$$objMap().objects();
    }

    public MapPack getCurrentObjects(String objType2) {
        MapPack m = new MapPack();
        ListValue objTypeLv = m.newList("objType");
        ListValue objHashLv = m.newList("objHash");
        Enumeration<ObjectPack> en = this.scouter$server$core$AgentManager$$objMap().enumTypeObject(objType2);
        while (en.hasMoreElements()) {
            ObjectPack obj = en.nextElement();
            objTypeLv.add(obj.objType);
            objHashLv.add(obj.objHash);
        }
        return m;
    }

    public MapPack getDailyObjects(String date, String objType2) {
        String key = new StringBuilder().append((Object)"DailyObjects:").append((Object)date).append((Object)":").append((Object)objType2).toString();
        MapPack m = (MapPack)CommonCache$.MODULE$.get(key);
        if (m == null) {
            List<ObjectPack> list = ObjectRD$.MODULE$.getObjectList(date);
            m = new MapPack();
            ListValue objTypeLv = m.newList("objType");
            ListValue objHashLv = m.newList("objHash");
            for (ObjectPack obj : list) {
                if (!obj.objType.equals(objType2)) continue;
                objTypeLv.add(obj.objType);
                objHashLv.add(obj.objHash);
            }
            CommonCache$.MODULE$.put(key, m, 2000L);
            return m;
        }
        return m;
    }

    public MapPack getPeriodicObjects(String sDate, String eDate, String objType2) {
        String key = new StringBuilder().append((Object)"PeriodicObjects:").append((Object)sDate).append((Object)eDate).append((Object)":").append((Object)objType2).toString();
        MapPack m = (MapPack)CommonCache$.MODULE$.get(key);
        if (m == null) {
            long stime = DateUtil.yyyymmdd(sDate);
            long etime = DateUtil.yyyymmdd(eDate);
            HashSet<ObjectPack> objSet = new HashSet<ObjectPack>();
            for (long date = stime; date <= etime; date += 86400000L) {
                String d = DateUtil.yyyymmdd(date);
                List<ObjectPack> list = ObjectRD$.MODULE$.getObjectList(d);
                objSet.addAll(list);
            }
            m = new MapPack();
            ListValue objTypeLv = m.newList("objType");
            ListValue objHashLv = m.newList("objHash");
            for (ObjectPack obj : objSet) {
                if (!objType2.equals(obj.objType)) continue;
                objTypeLv.add(obj.objType);
                objHashLv.add(obj.objHash);
            }
            CommonCache$.MODULE$.put(key, m, 2000L);
            return m;
        }
        return m;
    }

    public void removeAgents(List<Object> objHashList, boolean permanent) {
        EnumerScala$.MODULE$.foreach(objHashList.iterator(), new Serializable(permanent){
            public static final long serialVersionUID = 0L;
            private final boolean permanent$1;

            public final void apply(int objHash) {
                this.apply$mcVI$sp(objHash);
            }

            public void apply$mcVI$sp(int objHash) {
                AgentManager$.MODULE$.scouter$server$core$AgentManager$$objMap().remove(objHash);
                if (this.permanent$1) {
                    ObjectWR$.MODULE$.remove(objHash);
                }
            }
            {
                this.permanent$1 = permanent$1;
            }
        });
    }

    public int getPrimaryObjCount() {
        return this.scouter$server$core$AgentManager$$primaryObjCount();
    }

    private AgentManager$() {
        MODULE$ = this;
        this.scouter$server$core$AgentManager$$counterEngine = CounterManager.getInstance().getCounterEngine();
        this.scouter$server$core$AgentManager$$primaryObjCount = 0;
        this.scouter$server$core$AgentManager$$objMap = new ObjectMap();
        ThreadScala$.MODULE$.startDaemon("scouter.server.core.AgentManager", (Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return CoreRun$.MODULE$.running();
            }
        }, 1000L, (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long now = System.currentTimeMillis();
                int deadtime = Configure.getInstance().object_deadtime_ms;
                Enumeration<ObjectPack> en = AgentManager$.MODULE$.scouter$server$core$AgentManager$$objMap().objects();
                int primaryObjCount = 0;
                while (en.hasMoreElements()) {
                    ObjectPack objPack = en.nextElement();
                    if ("batch".equals(objPack.objType)) continue;
                    if (now > objPack.wakeup + (long)deadtime) {
                        AgentManager$.MODULE$.inactive(objPack.objHash);
                        continue;
                    }
                    if (!AgentManager$.MODULE$.scouter$server$core$AgentManager$$counterEngine().isPrimaryObject(objPack.objType)) continue;
                    ++primaryObjCount;
                }
                AgentManager$.MODULE$.scouter$server$core$AgentManager$$primaryObjCount_$eq(primaryObjCount);
            }
        });
    }
}

