/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import scouter.server.ConfObserver;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.core.CoreRun;
import scouter.server.db.DBCtr;
import scouter.server.db.XLogWR;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.SystemUtil;
import scouter.util.ThreadUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoDeleteScheduler
extends Thread {
    private static AutoDeleteScheduler instance = null;
    private static final long CHECK_INTERVAL = 60000L;
    Configure conf = Configure.getInstance();
    boolean brun;
    int maxPercent;
    int retainDays;
    boolean delOnlyXLog;
    String lastCheckDate;
    Set<String> deletedDays = new HashSet<String>();
    File dbDir;

    public static final synchronized AutoDeleteScheduler getInstance() {
        if (instance == null) {
            instance = new AutoDeleteScheduler();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    private AutoDeleteScheduler() {
        this.applyConf();
        this.dbDir = new File(DBCtr.getRootPath());
        ConfObserver.put(AutoDeleteScheduler.class.getName(), new Runnable(){

            public void run() {
                if (AutoDeleteScheduler.this.conf.mgr_purge_enabled != AutoDeleteScheduler.this.brun || AutoDeleteScheduler.this.conf.mgr_purge_disk_usage_pct != AutoDeleteScheduler.this.maxPercent || AutoDeleteScheduler.this.conf.mgr_purge_keep_days != AutoDeleteScheduler.this.retainDays || AutoDeleteScheduler.this.conf.mgr_purge_only_xlog_enabled != AutoDeleteScheduler.this.delOnlyXLog) {
                    AutoDeleteScheduler.this.applyConf();
                    AutoDeleteScheduler.this.lastCheckDate = null;
                    AutoDeleteScheduler.this.deletedDays.clear();
                }
            }
        });
    }

    private void applyConf() {
        this.brun = this.conf.mgr_purge_enabled;
        this.maxPercent = this.conf.mgr_purge_disk_usage_pct;
        this.retainDays = this.conf.mgr_purge_keep_days;
        this.delOnlyXLog = this.conf.mgr_purge_only_xlog_enabled;
    }

    @Override
    public void run() {
        while (CoreRun.running()) {
            if (this.conf.mgr_purge_enabled) {
                int retainDays;
                int maxPercent;
                String today = DateUtil.yyyymmdd();
                if (!SystemUtil.IS_JAVA_1_5 && (maxPercent = this.conf.mgr_purge_disk_usage_pct) > 0) {
                    String yyyymmdd;
                    long totalSpace = this.dbDir.getTotalSpace();
                    long usuableSpace = this.dbDir.getUsableSpace();
                    double percent = (double)usuableSpace * 100.0 / (double)totalSpace;
                    while (100.0 - percent > (double)maxPercent && (yyyymmdd = this.getLongAgoDate(this.deletedDays)) != null && !today.equals(yyyymmdd)) {
                        this.deleteData(yyyymmdd);
                        usuableSpace = this.dbDir.getUsableSpace();
                        percent = (double)usuableSpace * 100.0 / (double)totalSpace;
                        this.deletedDays.add(yyyymmdd);
                    }
                }
                if ((retainDays = this.conf.mgr_purge_keep_days) > 0 && !today.equals(this.lastCheckDate)) {
                    String yyyymmdd;
                    this.lastCheckDate = today;
                    int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainDays));
                    while ((yyyymmdd = this.getLongAgoDate(this.deletedDays)) != null && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                        this.deleteData(yyyymmdd);
                        this.deletedDays.add(yyyymmdd);
                    }
                }
            }
            ThreadUtil.sleep(60000L);
        }
    }

    private void deleteData(String yyyymmdd) {
        try {
            File f = null;
            f = this.conf.mgr_purge_only_xlog_enabled ? new File(this.dbDir, yyyymmdd + XLogWR.dir()) : new File(this.dbDir, yyyymmdd);
            this.deleteFiles(f);
            Logger.println("S206", "Auto deletion... " + yyyymmdd);
        }
        catch (Throwable th) {
            Logger.println("S207", "Failed auto deletion... " + yyyymmdd + "  " + th.toString());
        }
    }

    void deleteFiles(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File c : file.listFiles()) {
                this.deleteFiles(c);
            }
        }
        file.delete();
    }

    private String getLongAgoDate(Set<String> exceptDays) {
        File[] dirs = this.dbDir.listFiles();
        if (dirs == null || dirs.length < 1) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < dirs.length; ++i) {
            File f = dirs[i];
            String name = f.getName();
            if (!f.isDirectory() || name.indexOf("0000") != -1 || exceptDays.contains(name)) continue;
            try {
                list.add(Integer.valueOf(f.getName()));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (list.size() == 0) {
            return null;
        }
        Collections.sort(list);
        return String.valueOf(list.get(0));
    }
}

