/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.update.Update;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.core.CoreRun$;
import scouter.server.core.SqlTables;
import scouter.server.core.sqltable.TableFinder;
import scouter.server.db.TextRD$;
import scouter.server.db.TextWR$;
import scouter.server.util.ThreadScala$;
import scouter.util.IntLinkedSet;
import scouter.util.RequestQueue;
import scouter.util.StringKeyLinkedMap;

public final class SqlTables$ {
    public static final SqlTables$ MODULE$;
    private final int MAX_Q1;
    private final int MAX_Q2;
    private final IntLinkedSet failSet;
    private final RequestQueue<SqlTables.Data> queue1;
    private final RequestQueue<SqlTables.Data> queue2;
    private final StringKeyLinkedMap<IntLinkedSet> parsed;

    static {
        new SqlTables$();
    }

    public int MAX_Q1() {
        return this.MAX_Q1;
    }

    public int MAX_Q2() {
        return this.MAX_Q2;
    }

    public IntLinkedSet failSet() {
        return this.failSet;
    }

    public RequestQueue<SqlTables.Data> queue1() {
        return this.queue1;
    }

    public RequestQueue<SqlTables.Data> queue2() {
        return this.queue2;
    }

    public StringKeyLinkedMap<IntLinkedSet> parsed() {
        return this.parsed;
    }

    public void add(String date, int sqlHash, String sqlText) {
        if (!Configure.getInstance().sql_table_parsing_enabled) {
            return;
        }
        SqlTables.Data data = new SqlTables.Data(date, sqlHash, sqlText);
        boolean ok = this.queue1().put(data);
        if (ok) {
            return;
        }
        data.sqlText_$eq(null);
        ok = this.queue2().put(data);
        if (!ok) {
            Logger$.MODULE$.println("S111", 10, "queue exceeded!!");
        }
    }

    public void process(SqlTables.Data data) {
        block8: {
            try {
                Object object;
                IntLinkedSet sqlHashSet = this.parsed().get(data.date());
                if (sqlHashSet == null) {
                    sqlHashSet = new IntLinkedSet().setMax(10000);
                    object = this.parsed().put(data.date(), sqlHashSet);
                } else {
                    object = BoxedUnit.UNIT;
                }
                if (sqlHashSet.contains(data.sqlHash())) {
                    return;
                }
                if (this.failSet().contains(data.sqlHash())) {
                    return;
                }
                if (data.sqlText() == null) {
                    data.sqlText_$eq(TextRD$.MODULE$.getString(data.date(), "sql", data.sqlHash()));
                }
                if (data.sqlText() == null) {
                    return;
                }
                String sbTables = this.parseTable(data.sqlText());
                sqlHashSet.put(data.sqlHash());
                TextWR$.MODULE$.add(data.date(), "table", data.sqlHash(), sbTables.toString());
            }
            catch (Throwable throwable) {
                this.failSet().put(data.sqlHash());
                if (!Configure.getInstance().log_sql_parsing_fail_enabled) break block8;
                Logger$.MODULE$.println("S112", new StringBuilder().append((Object)data.sqlText()).append((Object)"\n").append((Object)throwable).toString());
            }
        }
    }

    public String parseTable(String sqlText) {
        StringBuffer sb;
        block8: {
            Statement statement;
            block10: {
                block9: {
                    block7: {
                        sb = new StringBuffer();
                        statement = new CCJSqlParserManager().parse((Reader)new StringReader(sqlText.replace('@', '0')));
                        if (!(statement instanceof Select)) break block7;
                        Select select = (Select)statement;
                        TableFinder tableFinder = new TableFinder();
                        if (select.getSelectBody() == null) break block8;
                        select.getSelectBody().accept((SelectVisitor)tableFinder);
                        for (String tableName : tableFinder.getTableList()) {
                            Object object = sb.length() > 0 ? sb.append(',') : BoxedUnit.UNIT;
                            sb.append(tableName).append("(S)");
                        }
                        break block8;
                    }
                    if (!(statement instanceof Insert)) break block9;
                    Insert x = (Insert)statement;
                    Table t = x.getTable();
                    sb.append(x.getTable().getName()).append("(I)");
                    if (x.getSelect() == null) break block8;
                    Select selectStatement = x.getSelect();
                    TableFinder tableFinder = new TableFinder();
                    selectStatement.getSelectBody().accept((SelectVisitor)tableFinder);
                    Iterator<String> iter = tableFinder.getTableList().iterator();
                    while (iter.hasNext()) {
                        sb.append(',').append(this.tableName$1(iter)).append("(S)");
                    }
                    break block8;
                }
                if (!(statement instanceof Delete)) break block10;
                Delete x = (Delete)statement;
                Table t = x.getTable();
                sb.append(x.getTable().getName()).append("(D)");
                if (x.getWhere() == null) break block8;
                TableFinder tableFinder = new TableFinder();
                x.getWhere().accept((ExpressionVisitor)tableFinder);
                for (String tableName : tableFinder.getTableList()) {
                    sb.append(',').append(tableName).append("(S)");
                }
                break block8;
            }
            if (statement instanceof Update) {
                Update x = (Update)statement;
                for (Table tableName : x.getTables()) {
                    sb.append(',');
                    sb.append(tableName).append("(U)");
                }
                if (x.getWhere() != null) {
                    TableFinder tableFinder = new TableFinder();
                    x.getWhere().accept((ExpressionVisitor)tableFinder);
                    for (String tableName : tableFinder.getTableList()) {
                        sb.append(',').append(tableName).append("(S)");
                    }
                }
            }
        }
        return sb.toString();
    }

    private final String tableName$1(Iterator iter$1) {
        return (String)iter$1.next();
    }

    private SqlTables$() {
        MODULE$ = this;
        this.MAX_Q1 = 500;
        this.MAX_Q2 = 10000;
        this.failSet = new IntLinkedSet().setMax(10000);
        this.queue1 = new RequestQueue(this.MAX_Q1());
        this.queue2 = new RequestQueue(this.MAX_Q2());
        this.parsed = new StringKeyLinkedMap().setMax(2);
        ThreadScala$.MODULE$.startDaemon("scouter.server.core.SqlTables", (Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return CoreRun$.MODULE$.running();
            }
        }, (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (SqlTables$.MODULE$.queue1().size() > 0) {
                    SqlTables$.MODULE$.process(SqlTables$.MODULE$.queue1().get());
                } else if (SqlTables$.MODULE$.queue2().size() > 0) {
                    SqlTables$.MODULE$.process(SqlTables$.MODULE$.queue2().get());
                } else {
                    SqlTables$.MODULE$.process(SqlTables$.MODULE$.queue1().get());
                }
            }
        });
    }
}

