/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core.cache;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scouter.lang.CounterKey;
import scouter.lang.value.Value;
import scouter.server.core.cache.StatusCache$;
import scouter.server.util.ThreadScala$;
import scouter.util.CacheTable;
import scouter.util.ThreadUtil;

public final class CounterCache$ {
    public static final CounterCache$ MODULE$;
    private final CacheTable<CounterKey, Value> cache;

    static {
        new CounterCache$();
    }

    public CacheTable<CounterKey, Value> cache() {
        return this.cache;
    }

    public void put(CounterKey key, Value value) {
        long keepTime = this.getKeepTime(key.timetype);
        this.cache().put(key, value, keepTime);
    }

    public Value get(CounterKey key) {
        return this.cache().get(key);
    }

    public Map<String, Value> getObjectCounters(int objHash, byte timeType) {
        HashMap<String, Value> map = new HashMap<String, Value>();
        try {
            Enumeration<CounterKey> en = this.cache().keys();
            while (en.hasMoreElements()) {
                Object object;
                CounterKey key = en.nextElement();
                if (key.timetype == timeType && key.objHash == objHash) {
                    Value value = this.cache().get(key);
                    if (value == null) {
                        object = BoxedUnit.UNIT;
                        continue;
                    }
                    object = map.put(key.counter, value);
                    continue;
                }
                object = BoxedUnit.UNIT;
            }
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)throwable);
        }
        return map;
    }

    public long getKeepTime(byte timeType) {
        byte by = timeType;
        switch (by) {
            default: {
                return 300000L;
            }
            case 5: {
                return 3603000L;
            }
            case 4: {
                return 603000L;
            }
            case 3: {
                return 303000L;
            }
            case 2: {
                return 63000L;
            }
            case 1: 
        }
        return 10000L;
    }

    private CounterCache$() {
        MODULE$ = this;
        this.cache = new CacheTable();
        ThreadScala$.MODULE$.startDaemon("scouter.server.core.cache.CounterCache", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (true) {
                    ThreadUtil.sleep(5000L);
                    CounterCache$.MODULE$.cache().clearExpiredItems();
                    StatusCache$.MODULE$.clearDirty();
                }
            }
        });
    }
}

