/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.BatchPack;
import scouter.lang.pack.ObjectPack;
import scouter.server.Logger$;
import scouter.server.core.AgentManager$;
import scouter.server.db.DBCtr$;
import scouter.server.util.BinSearch;
import scouter.server.util.ThreadScala$;
import scouter.util.BitUtil;
import scouter.util.DateUtil;
import scouter.util.LongKeyLinkedMap;
import scouter.util.RequestQueue;

public final class BatchDB$ {
    public static final BatchDB$ MODULE$;
    private final int IDX_LEN;
    private final RequestQueue<BatchPack> queue;
    private final LongKeyLinkedMap<String> dbinfo;

    static {
        new BatchDB$();
    }

    public int IDX_LEN() {
        return this.IDX_LEN;
    }

    public RequestQueue<BatchPack> queue() {
        return this.queue;
    }

    public LongKeyLinkedMap<String> dbinfo() {
        return this.dbinfo;
    }

    public void add(BatchPack data) {
        boolean ok = this.queue().put(data);
        if (!ok) {
            Logger$.MODULE$.println("S000", 10, "queue exceeded!!");
        }
    }

    public void read(String objName, long from, long to, Function2<Object, byte[], Object> handler) {
        String date = DateUtil.yyyymmdd(from);
        String path = this.getDBPath(date, objName);
        File idxFile = new File(new StringBuilder().append((Object)path).append((Object)"/batch.idx").toString());
        if (!idxFile.canRead()) {
            return;
        }
        RandomAccessFile idxRAF = new RandomAccessFile(new StringBuilder().append((Object)path).append((Object)"/batch.idx").toString(), "rw");
        RandomAccessFile dataFile = new RandomAccessFile(new StringBuilder().append((Object)path).append((Object)"/batch.dat").toString(), "rw");
        int len = (int)(idxFile.length() / (long)this.IDX_LEN());
        BinSearch<Long> bs = new BinSearch<Long>(len, (Function1<Object, Long>)new Serializable(idxRAF){
            public static final long serialVersionUID = 0L;
            private final RandomAccessFile idxRAF$1;

            public final long apply(long a) {
                return this.apply$mcJJ$sp(a);
            }

            public long apply$mcJJ$sp(long a) {
                this.idxRAF$1.seek(a * (long)BatchDB$.MODULE$.IDX_LEN());
                return new DataInputX(this.idxRAF$1).readLong();
            }
            {
                this.idxRAF$1 = idxRAF$1;
            }
        }, (Function2<Long, Long, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(long a, long b) {
                return this.apply$mcIJJ$sp(a, b);
            }

            public int apply$mcIJJ$sp(long a, long b) {
                return (int)(b - a);
            }
        });
        int x = (int)bs.searchBE(BoxesRunTime.boxToLong((long)from));
        if (x < 0) {
            return;
        }
        while (x < len) {
            idxRAF.seek(x * this.IDX_LEN());
            long time = new DataInputX(idxRAF).readLong();
            if (time <= to) {
                idxRAF.seek(x * this.IDX_LEN() + 8);
                long dataPos = new DataInputX(idxRAF).readLong5();
                dataFile.seek(dataPos);
                DataInputX dataIn = new DataInputX(dataFile);
                int len2 = DataInputX.toInt(dataIn.read(4), 0);
                byte[] data = dataIn.read(len2);
                handler.apply((Object)BoxesRunTime.boxToLong((long)time), (Object)data);
                ++x;
                continue;
            }
            x = len;
        }
    }

    public void read(String objName, long from, long to, Function1<Object, Object> handler) {
        String date = DateUtil.yyyymmdd(from);
        String path = this.getDBPath(date, objName);
        File idxFile = new File(new StringBuilder().append((Object)path).append((Object)"/batch.idx").toString());
        if (!idxFile.canRead()) {
            return;
        }
        RandomAccessFile idxRAF = new RandomAccessFile(new StringBuilder().append((Object)path).append((Object)"/batch.idx").toString(), "rw");
        RandomAccessFile dataFile = new RandomAccessFile(new StringBuilder().append((Object)path).append((Object)"/batch.dat").toString(), "rw");
        int len = (int)(idxFile.length() / (long)this.IDX_LEN());
        BinSearch<Long> bs = new BinSearch<Long>(len, (Function1<Object, Long>)new Serializable(idxRAF){
            public static final long serialVersionUID = 0L;
            private final RandomAccessFile idxRAF$2;

            public final long apply(long a) {
                return this.apply$mcJJ$sp(a);
            }

            public long apply$mcJJ$sp(long a) {
                this.idxRAF$2.seek(a * (long)BatchDB$.MODULE$.IDX_LEN());
                return new DataInputX(this.idxRAF$2).readLong();
            }
            {
                this.idxRAF$2 = idxRAF$2;
            }
        }, (Function2<Long, Long, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(long a, long b) {
                return this.apply$mcIJJ$sp(a, b);
            }

            public int apply$mcIJJ$sp(long a, long b) {
                return (int)(b - a);
            }
        });
        int x = (int)bs.searchBE(BoxesRunTime.boxToLong((long)from));
        if (x < 0) {
            return;
        }
        while (x < len) {
            idxRAF.seek(x * this.IDX_LEN());
            long time = new DataInputX(idxRAF).readLong();
            if (time <= to) {
                handler.apply((Object)BoxesRunTime.boxToLong((long)time));
                ++x;
                continue;
            }
            x = len;
        }
    }

    public long append(String path, BatchPack m) {
        File file = new File(new StringBuilder().append((Object)path).append((Object)"/batch.dat").toString());
        long offset = file.length();
        FileOutputStream out = new FileOutputStream(file, true);
        byte[] data = new DataOutputX().writePack(m).toByteArray();
        out.write(DataOutputX.toBytes(data.length));
        out.write(data);
        out.close();
        return offset;
    }

    public void appendX(String path, long time, long pos) {
        File file = new File(new StringBuilder().append((Object)path).append((Object)"/batch.idx").toString());
        long offset = file.length();
        FileOutputStream out = new FileOutputStream(file, true);
        out.write(new DataOutputX().writeLong(time).writeLong5(pos).toByteArray());
        out.close();
    }

    public String open(BatchPack m) {
        long key = BitUtil.setHigh(DateUtil.getDateUnit(m.startTime), m.objHash);
        String opath = this.dbinfo().get(key);
        if (opath == null) {
            String objName = this.getObjName(m);
            if (objName == null) {
                return null;
            }
            String date = DateUtil.yyyymmdd(m.startTime);
            String path = this.getDBPath(date, objName);
            File f = new File(path);
            Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
            Object object2 = f.exists() ? this.dbinfo().put(key, path) : BoxedUnit.UNIT;
            return path;
        }
        return opath;
    }

    public String getDBPath(String date, String objName) {
        StringBuffer sb = new StringBuffer();
        sb.append(DBCtr$.MODULE$.getRootPath());
        sb.append("/").append(date).append(objName);
        return sb.toString();
    }

    public String getObjName(BatchPack m) {
        ObjectPack objInfo = AgentManager$.MODULE$.getAgent(m.objHash);
        if (objInfo == null) {
            ObjectPack objInfoNew = new ObjectPack();
            objInfoNew.objHash = m.objHash;
            objInfoNew.objName = m.objName;
            objInfoNew.objType = m.objType;
            AgentManager$.MODULE$.active(objInfoNew);
            return objInfoNew.objName;
        }
        return objInfo.objName;
    }

    private BatchDB$() {
        MODULE$ = this;
        this.IDX_LEN = 13;
        this.queue = new RequestQueue(DBCtr$.MODULE$.MAX_QUE_SIZE());
        this.dbinfo = new LongKeyLinkedMap().setMax(1000);
        ThreadScala$.MODULE$.startDaemon("scouter.server.db.BatchDB", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (DBCtr$.MODULE$.running()) {
                    BatchPack m = BatchDB$.MODULE$.queue().get();
                    String path = BatchDB$.MODULE$.open(m);
                    if (path == null) continue;
                    long pos = BatchDB$.MODULE$.append(path, m);
                    BatchDB$.MODULE$.appendX(path, m.startTime, pos);
                }
            }
        });
    }
}

