/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scouter.io.DataInputX;
import scouter.lang.value.MapValue;
import scouter.server.db.counter.RealtimeCounterDBHelper;
import scouter.server.db.counter.RealtimeCounterDBHelper$;
import scouter.server.db.counter.RealtimeCounterData;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.HashUtil;
import scouter.util.IntKeyMap;
import scouter.util.StringEnumer;

public final class RealtimeCounterRD$ {
    public static final RealtimeCounterRD$ MODULE$;

    static {
        new RealtimeCounterRD$();
    }

    public void read(String objName, String date, Function2<Object, MapValue, Object> handler) {
        long stime = DateUtil.yyyymmdd(date);
        long etime = stime + 86400000L;
        this.read(objName, date, stime, etime, handler);
    }

    public void read(String objName, String date, long stime, long etime, Function2<Object, MapValue, Object> handler) {
        block7: {
            RealtimeCounterDBHelper perfdb;
            block6: {
                if (objName == null) {
                    return;
                }
                perfdb = null;
                perfdb = new RealtimeCounterDBHelper().open(date, true);
                if (perfdb != null) break block6;
                FileUtil.close(perfdb);
                return;
            }
            try {
                RealtimeCounterData realtimeCounterData = perfdb.counterData();
                perfdb.counterIndex().read(HashUtil.hash(objName), stime, etime, handler, perfdb.counterDbHeader().getTagIntStr(), (Function1<Object, byte[]>)new Serializable(realtimeCounterData){
                    public static final long serialVersionUID = 0L;
                    private final RealtimeCounterData eta$0$1$1;

                    public final byte[] apply(long pos) {
                        return this.eta$0$1$1.read(pos);
                    }
                    {
                        this.eta$0$1$1 = eta$0$1$1;
                    }
                });
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtil.close(perfdb);
                    throw throwable;
                }
            }
            FileUtil.close(perfdb);
            break block7;
            FileUtil.close(perfdb);
        }
    }

    public void readBulk(String date, long _stime, long etime, Function1<MapValue, Object> handler) {
        block7: {
            RealtimeCounterDBHelper perfdb;
            block6: {
                perfdb = null;
                perfdb = new RealtimeCounterDBHelper().open(date, true);
                if (perfdb != null) break block6;
                FileUtil.close(perfdb);
                return;
            }
            try {
                int unit = 60000;
                for (long stime = _stime; stime <= etime; stime += (long)unit) {
                    Tuple2<byte[], byte[]> pos = perfdb.counterIndex().getStartEndDataPos(stime, package$.MODULE$.min(stime + (long)unit - 1L, etime));
                    if (pos._1() == null || pos._2() == null) continue;
                    long posStart = DataInputX.toLong5((byte[])pos._1(), 0);
                    long posEnd = DataInputX.toLong5((byte[])pos._2(), 0);
                    if (posStart <= 0L || posEnd <= 0L) continue;
                    byte[] buffer = perfdb.counterData().readBulk(posStart, posEnd);
                    IntKeyMap<String> keyMap = perfdb.counterDbHeader().getTagIntStr();
                    ArrayBuffer<MapValue> items = RealtimeCounterDBHelper$.MODULE$.setTagBytesMulti(keyMap, buffer);
                    items.foreach((Function1)new Serializable(handler){
                        public static final long serialVersionUID = 0L;
                        private final Function1 handler$1;

                        public final Object apply(MapValue mapValue) {
                            return this.handler$1.apply((Object)mapValue);
                        }
                        {
                            this.handler$1 = handler$1;
                        }
                    });
                }
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtil.close(perfdb);
                    throw throwable;
                }
            }
            FileUtil.close(perfdb);
            break block7;
            FileUtil.close(perfdb);
        }
    }

    public StringEnumer getCounterSet(String date) {
        StringEnumer stringEnumer;
        RealtimeCounterDBHelper logdb;
        block5: {
            logdb = null;
            logdb = new RealtimeCounterDBHelper().open(date, true);
            if (logdb != null) break block5;
            FileUtil.close(logdb);
            return null;
        }
        try {
            stringEnumer = logdb.counterDbHeader().getTagStrInt().keys();
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.close(logdb);
                throw throwable;
            }
        }
        FileUtil.close(logdb);
        return stringEnumer;
        FileUtil.close(logdb);
        return null;
    }

    public void readFromEnd(String objName, String date, Function2<Object, MapValue, Object> handler) {
        long stime = DateUtil.yyyymmdd(date);
        long etime = stime + 86400000L;
        this.readFromEnd(objName, date, stime, etime, handler);
    }

    public void readFromEnd(String objName, String date, long stime, long etime, Function2<Object, MapValue, Object> handler) {
        block6: {
            RealtimeCounterDBHelper logdb;
            block5: {
                logdb = null;
                logdb = new RealtimeCounterDBHelper().open(date, true);
                if (logdb != null) break block5;
                FileUtil.close(logdb);
                return;
            }
            try {
                RealtimeCounterData realtimeCounterData = logdb.counterData();
                logdb.counterIndex().readFromEnd(HashUtil.hash(objName), stime, etime, handler, logdb.counterDbHeader().getTagIntStr(), (Function1<Object, byte[]>)new Serializable(realtimeCounterData){
                    public static final long serialVersionUID = 0L;
                    private final RealtimeCounterData eta$0$2$1;

                    public final byte[] apply(long pos) {
                        return this.eta$0$2$1.read(pos);
                    }
                    {
                        this.eta$0$2$1 = eta$0$2$1;
                    }
                });
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtil.close(logdb);
                    throw throwable;
                }
            }
            FileUtil.close(logdb);
            break block6;
            FileUtil.close(logdb);
        }
    }

    public StringEnumer getDataNames(String objName, String date) {
        StringEnumer stringEnumer;
        RealtimeCounterDBHelper logdb;
        block5: {
            logdb = null;
            logdb = new RealtimeCounterDBHelper().open(date, true);
            if (logdb != null) break block5;
            FileUtil.close(logdb);
            return null;
        }
        try {
            stringEnumer = logdb.counterDbHeader().getTagStrInt().keys();
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.close(logdb);
                throw throwable;
            }
        }
        FileUtil.close(logdb);
        return stringEnumer;
        FileUtil.close(logdb);
        return null;
    }

    private RealtimeCounterRD$() {
        MODULE$ = this;
    }
}

