/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import java.io.File;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scouter.io.DataOutputX;
import scouter.lang.pack.SummaryPack;
import scouter.server.Logger$;
import scouter.server.core.ServerStat;
import scouter.server.db.DBCtr$;
import scouter.server.db.summary.SummaryIndex;
import scouter.server.db.summary.SummaryIndex$;
import scouter.server.db.summary.SummaryWriter;
import scouter.server.db.summary.SummaryWriter$;
import scouter.server.util.OftenAction$;
import scouter.server.util.ThreadScala$;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.RequestQueue;

public final class SummaryWR$ {
    public static final SummaryWR$ MODULE$;
    private final String root;
    private final RequestQueue<SummaryPack> queue;
    private SummaryIndex iapp;
    private SummaryIndex isql;
    private SummaryIndex ienduser;
    private SummaryIndex iothers;
    private SummaryWriter writer;

    static {
        new SummaryWR$();
    }

    public String root() {
        return this.root;
    }

    public RequestQueue<SummaryPack> queue() {
        return this.queue;
    }

    public void add(SummaryPack p) {
        boolean ok = this.queue().put(p);
        if (!ok) {
            Logger$.MODULE$.println("S211", 10, "queue exceeded!!");
        }
    }

    public SummaryIndex iapp() {
        return this.iapp;
    }

    public void iapp_$eq(SummaryIndex x$1) {
        this.iapp = x$1;
    }

    public SummaryIndex isql() {
        return this.isql;
    }

    public void isql_$eq(SummaryIndex x$1) {
        this.isql = x$1;
    }

    public SummaryIndex ienduser() {
        return this.ienduser;
    }

    public void ienduser_$eq(SummaryIndex x$1) {
        this.ienduser = x$1;
    }

    public SummaryIndex iothers() {
        return this.iothers;
    }

    public void iothers_$eq(SummaryIndex x$1) {
        this.iothers = x$1;
    }

    public SummaryWriter writer() {
        return this.writer;
    }

    public void writer_$eq(SummaryWriter x$1) {
        this.writer = x$1;
    }

    public void close() {
        FileUtil.close(this.iapp());
        FileUtil.close(this.isql());
        FileUtil.close(this.ienduser());
        FileUtil.close(this.iothers());
        FileUtil.close(this.writer());
        this.iapp_$eq(null);
        this.isql_$eq(null);
        this.iothers_$eq(null);
        this.writer_$eq(null);
    }

    public void open(String date) {
        try {
            String path = this.getDBPath(date);
            File f = new File(path);
            Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
            String file = new StringBuilder().append((Object)path).append((Object)"/").append((Object)this.root()).toString();
            this.iapp_$eq(SummaryIndex$.MODULE$.open(new StringBuilder().append((Object)file).append((Object)"_app").toString()));
            this.isql_$eq(SummaryIndex$.MODULE$.open(new StringBuilder().append((Object)file).append((Object)"_sql").toString()));
            this.ienduser_$eq(SummaryIndex$.MODULE$.open(new StringBuilder().append((Object)file).append((Object)"_enduser").toString()));
            this.iothers_$eq(SummaryIndex$.MODULE$.open(new StringBuilder().append((Object)file).append((Object)"_other").toString()));
            this.writer_$eq(SummaryWriter$.MODULE$.open(file));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.close();
        }
    }

    public String getDBPath(String date) {
        StringBuffer sb = new StringBuffer();
        sb.append(DBCtr$.MODULE$.getRootPath());
        sb.append("/").append(date).append("/").append(this.root());
        return sb.toString();
    }

    private SummaryWR$() {
        MODULE$ = this;
        this.root = "sum";
        this.queue = new RequestQueue(DBCtr$.MODULE$.MAX_QUE_SIZE());
        ThreadScala$.MODULE$.start("scouter.server.db.SummaryWR", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                LongRef currentDateUnit = new LongRef(0L);
                block7: while (true) {
                    if (!DBCtr$.MODULE$.running()) {
                        SummaryWR$.MODULE$.close();
                        return;
                    }
                    SummaryPack p = SummaryWR$.MODULE$.queue().get();
                    ServerStat.put("summary.db.queue", SummaryWR$.MODULE$.queue().size());
                    {
                        if (currentDateUnit.elem != DateUtil.getDateUnit(p.time)) {
                            currentDateUnit.elem = DateUtil.getDateUnit(p.time);
                            SummaryWR$.MODULE$.close();
                            SummaryWR$.MODULE$.open(DateUtil.yyyymmdd(p.time));
                        }
                        if (SummaryWR$.MODULE$.iapp() == null) {
                            OftenAction$.MODULE$.act("SummaryWR", 10, (Function0<BoxedUnit>)new Serializable(this, currentDateUnit){
                                public static final long serialVersionUID = 0L;
                                private final LongRef currentDateUnit$1;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    SummaryWR$.MODULE$.queue().clear();
                                    this.currentDateUnit$1.elem = 0L;
                                }
                                {
                                    this.currentDateUnit$1 = currentDateUnit$1;
                                }
                            });
                            Logger$.MODULE$.println("S210", 10, "can't open db");
                            continue;
                        }
                        byte[] b = new DataOutputX().writePack(p).toByteArray();
                        long location = SummaryWR$.MODULE$.writer().write(b);
                        byte by = p.stype;
                        switch (by) {
                            default: {
                                SummaryWR$.MODULE$.iothers().add(p.time, location);
                                continue block7;
                            }
                            case 10: 
                            case 11: 
                            case 12: {
                                SummaryWR$.MODULE$.ienduser().add(p.time, location);
                                continue block7;
                            }
                            case 2: {
                                SummaryWR$.MODULE$.isql().add(p.time, location);
                                continue block7;
                            }
                            case 1: 
                        }
                        SummaryWR$.MODULE$.iapp().add(p.time, location);
                        continue;
                    }
                    break;
                }
            }
        });
        this.iapp = null;
        this.isql = null;
        this.ienduser = null;
        this.iothers = null;
        this.writer = null;
    }
}

