/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import java.io.File;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.core.ServerStat;
import scouter.server.db.DBCtr$;
import scouter.server.db.XLogWR;
import scouter.server.db.xlog.XLogDataWriter;
import scouter.server.db.xlog.XLogDataWriter$;
import scouter.server.db.xlog.XLogIndex;
import scouter.server.db.xlog.XLogIndex$;
import scouter.server.util.OftenAction$;
import scouter.server.util.ThreadScala$;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.RequestQueue;

public final class XLogWR$ {
    public static final XLogWR$ MODULE$;
    private final String dir;
    private final String prefix;
    private final RequestQueue<XLogWR.Data> queue;
    private long currentDateUnit;
    private XLogIndex index;
    private XLogDataWriter writer;

    static {
        new XLogWR$();
    }

    public String dir() {
        return this.dir;
    }

    public String prefix() {
        return this.prefix;
    }

    public RequestQueue<XLogWR.Data> queue() {
        return this.queue;
    }

    public long currentDateUnit() {
        return this.currentDateUnit;
    }

    public void currentDateUnit_$eq(long x$1) {
        this.currentDateUnit = x$1;
    }

    public XLogIndex index() {
        return this.index;
    }

    public void index_$eq(XLogIndex x$1) {
        this.index = x$1;
    }

    public XLogDataWriter writer() {
        return this.writer;
    }

    public void writer_$eq(XLogDataWriter x$1) {
        this.writer = x$1;
    }

    public void add(long time, long tid, long gid, int elapsed, byte[] data) {
        boolean ok = this.queue().put(new XLogWR.Data(time, tid, gid, elapsed, data));
        if (!ok) {
            Logger$.MODULE$.println("S144", 10, "queue exceeded!!");
        }
    }

    public void close() {
        FileUtil.close(this.index());
        FileUtil.close(this.writer());
        this.index_$eq(null);
        this.writer_$eq(null);
    }

    public void open(String date) {
        try {
            String path = this.getDBPath(date);
            File f = new File(path);
            Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
            String file = new StringBuilder().append((Object)path).append((Object)"/").append((Object)this.prefix()).toString();
            this.index_$eq(XLogIndex$.MODULE$.open(file));
            this.writer_$eq(XLogDataWriter$.MODULE$.open(date, file));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.close();
        }
    }

    public String getDBPath(String date) {
        StringBuffer sb = new StringBuffer();
        sb.append(DBCtr$.MODULE$.getRootPath());
        sb.append("/").append(date).append(this.dir());
        return sb.toString();
    }

    private XLogWR$() {
        MODULE$ = this;
        this.dir = "/xlog";
        this.prefix = "xlog";
        this.queue = new RequestQueue(Configure.getInstance().xlog_queue_size);
        this.currentDateUnit = 0L;
        this.index = null;
        this.writer = null;
        ThreadScala$.MODULE$.start("scouter.server.db.XLogWR", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                while (true) {
                    XLogWR.Data m;
                    block6: {
                        if (!DBCtr$.MODULE$.running()) {
                            XLogWR$.MODULE$.close();
                            return;
                        }
                        m = XLogWR$.MODULE$.queue().get();
                        ServerStat.put("xlog.db.queue", XLogWR$.MODULE$.queue().size());
                        try {
                            if (XLogWR$.MODULE$.currentDateUnit() != DateUtil.getDateUnit(m.time())) {
                                XLogWR$.MODULE$.currentDateUnit_$eq(DateUtil.getDateUnit(m.time()));
                                XLogWR$.MODULE$.close();
                                XLogWR$.MODULE$.open(DateUtil.yyyymmdd(m.time()));
                            }
                            if (XLogWR$.MODULE$.index() == null) {
                                OftenAction$.MODULE$.act("XLoWR", 10, (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        XLogWR$.MODULE$.queue().clear();
                                        XLogWR$.MODULE$.currentDateUnit_$eq(0L);
                                    }
                                });
                                Logger$.MODULE$.println("S143", 10, "can't open ");
                            }
                            break block6;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        continue;
                    }
                    long location = XLogWR$.MODULE$.writer().write(m.data());
                    XLogWR$.MODULE$.index().setByTime(m.time(), location);
                    XLogWR$.MODULE$.index().setByTxid(m.txid(), location);
                    XLogWR$.MODULE$.index().setByGxid(m.gxid(), location);
                }
            }
        });
    }
}

