/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scouter.io.DataInputX;
import scouter.server.Logger$;
import scouter.server.db.io.ITEM;
import scouter.server.db.io.IndexKeyFile$;
import scouter.server.db.io.MemHashBlock;
import scouter.server.db.io.RealKeyFile;
import scouter.util.CompareUtil;
import scouter.util.HashUtil;
import scouter.util.IClose;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001-\u0011A\"\u00138eKb\\U-\u001f$jY\u0016T!a\u0001\u0003\u0002\u0005%|'BA\u0003\u0007\u0003\t!'M\u0003\u0002\b\u0011\u000511/\u001a:wKJT\u0011!C\u0001\bg\u000e|W\u000f^3s\u0007\u0001\u00192\u0001\u0001\u0007\u0015!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0019\u001b\u00051\"BA\f\t\u0003\u0011)H/\u001b7\n\u0005e1\"AB%DY>\u001cX\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u0015y\u0006/\u0019;i!\ti2E\u0004\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011s$\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0015\u0012aa\u0015;sS:<'B\u0001\u0012 \u0011!9\u0003A!A!\u0002\u0013A\u0013\u0001\u00035bg\"\u001c\u0016N_3\u0011\u0005yI\u0013B\u0001\u0016 \u0005\rIe\u000e\u001e\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079\u0002\u0014\u0007\u0005\u00020\u00015\t!\u0001C\u0003\u001cW\u0001\u0007A\u0004C\u0004(WA\u0005\t\u0019\u0001\u0015\t\u000fM\u0002!\u0019!C\u0001i\u0005\u0011QJQ\u000b\u0002Q!1a\u0007\u0001Q\u0001\n!\n1!\u0014\"!\u0011\u001dA\u0004A1A\u0005\u0002e\nA\u0001]1uQV\tA\u0004\u0003\u0004<\u0001\u0001\u0006I\u0001H\u0001\u0006a\u0006$\b\u000e\t\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0003%A\u0017m\u001d5CY>\u001c7.F\u0001@!\ty\u0003)\u0003\u0002B\u0005\taQ*Z7ICND'\t\\8dW\"11\t\u0001Q\u0001\n}\n!\u0002[1tQ\ncwnY6!\u0011\u001d)\u0005A1A\u0005\u0002\u0019\u000bqa[3z\r&dW-F\u0001H!\ty\u0003*\u0003\u0002J\u0005\tY!+Z1m\u0017\u0016Lh)\u001b7f\u0011\u0019Y\u0005\u0001)A\u0005\u000f\u0006A1.Z=GS2,\u0007\u0005C\u0003N\u0001\u0011\u0005a*\u0001\u0004qkR\fE\u000e\u001c\u000b\u0003Q=CQ\u0001\u0015'A\u00029\nQ\u0001^1cY\u0016DQA\u0015\u0001\u0005\u0002M\u000b1\u0001];u)\r!vk\u0018\t\u0003=UK!AV\u0010\u0003\u000f\t{w\u000e\\3b]\")\u0001,\u0015a\u00013\u0006\u00191.Z=\u0011\u0007yQF,\u0003\u0002\\?\t)\u0011I\u001d:bsB\u0011a$X\u0005\u0003=~\u0011AAQ=uK\")\u0001-\u0015a\u00013\u0006QA-\u0019;b\u001f\u001a47/\u001a;\t\u000b\t\u0004A\u0011A2\u0002\rU\u0004H-\u0019;f)\r!F-\u001a\u0005\u00061\u0006\u0004\r!\u0017\u0005\u0006M\u0006\u0004\r!W\u0001\u0006m\u0006dW/\u001a\u0005\u0006Q\u0002!\t![\u0001\u0004O\u0016$HCA-k\u0011\u0015Av\r1\u0001Z\u0011\u0015a\u0007\u0001\"\u0001n\u0003\u0019A\u0017m]&fsR\u0011AK\u001c\u0005\u00061.\u0004\r!\u0017\u0005\u0006a\u0002!\t!]\u0001\u0007O\u0016$\u0018\t\u001c7\u0015\u0005I<\bcA:v36\tAO\u0003\u0002\u0018!%\u0011a\u000f\u001e\u0002\u0005\u0019&\u001cH\u000fC\u0003Y_\u0002\u0007\u0011\fC\u0003z\u0001\u0011\u0005!0\u0001\u0004eK2,G/\u001a\u000b\u0003QmDQ\u0001\u0017=A\u0002eCQ! \u0001\u0005\u0002y\fAA]3bIR\u0019q0!\u0002\u0011\u0007y\t\t!C\u0002\u0002\u0004}\u0011A!\u00168ji\"9\u0011q\u0001?A\u0002\u0005%\u0011a\u00025b]\u0012dWM\u001d\t\b=\u0005-\u0011,WA\b\u0013\r\tia\b\u0002\n\rVt7\r^5p]J\u00022AHA\t\u0013\r\t\u0019b\b\u0002\u0004\u0003:L\bBB?\u0001\t\u0003\t9\u0002F\u0003\u0000\u00033\tY\u0002\u0003\u0005\u0002\b\u0005U\u0001\u0019AA\u0005\u0011!\ti\"!\u0006A\u0002\u0005}\u0011A\u0002:fC\u0012,'\u000f\u0005\u0004\u001f\u0003C\t)#W\u0005\u0004\u0003Gy\"!\u0003$v]\u000e$\u0018n\u001c82!\rq\u0012qE\u0005\u0004\u0003Sy\"\u0001\u0002'p]\u001eDq!!\f\u0001\t\u0003\ty#A\u0004hKR\u001cF/\u0019;\u0015\u0005\u0005E\u0002CB:\u00024q\t9$C\u0002\u00026Q\u00141!T1q!\ri\u0011\u0011H\u0005\u0004\u0003wq!A\u0002(v[\n,'\u000fC\u0004\u0002@\u0001!\t%!\u0011\u0002\u000b\rdwn]3\u0015\u0003}<\u0011\"!\u0012\u0003\u0003\u0003E\t!a\u0012\u0002\u0019%sG-\u001a=LKf4\u0015\u000e\\3\u0011\u0007=\nIE\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA&'\u0011\tI%!\u0014\u0011\u0007y\ty%C\u0002\u0002R}\u0011a!\u00118z%\u00164\u0007b\u0002\u0017\u0002J\u0011\u0005\u0011Q\u000b\u000b\u0003\u0003\u000fB!\"!\u0017\u0002JE\u0005I\u0011AA.\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\f\u0016\u0004Q\u0005}3FAA1!\u0011\t\u0019'!\u001c\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-t$\u0001\u0006b]:|G/\u0019;j_:LA!a\u001c\u0002f\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class IndexKeyFile
implements IClose {
    private final int MB;
    private final String path;
    private final MemHashBlock hashBlock;
    private final RealKeyFile keyFile;

    public static int $lessinit$greater$default$2() {
        return IndexKeyFile$.MODULE$.$lessinit$greater$default$2();
    }

    public int MB() {
        return this.MB;
    }

    public String path() {
        return this.path;
    }

    public MemHashBlock hashBlock() {
        return this.hashBlock;
    }

    public RealKeyFile keyFile() {
        return this.keyFile;
    }

    public int putAll(IndexKeyFile table) {
        IntRef count = new IntRef(0);
        table.read((Function2<byte[], byte[], Object>)new Serializable(this, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexKeyFile $outer;
            private final IntRef count$1;

            public final Object apply(byte[] key, byte[] data) {
                BoxedUnit boxedUnit;
                try {
                    this.$outer.put(key, data);
                    ++this.count$1.elem;
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Exception exception) {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.count$1 = count$1;
            }
        });
        return count.elem;
    }

    public boolean put(byte[] key, byte[] dataOffset) {
        block3: {
            block2: {
                if (key == null) break block2;
                if (dataOffset != null) break block3;
            }
            throw new IOException("invalid key/value");
        }
        int keyHash = HashUtil.hash(key);
        long prevKeyPos = this.hashBlock().get(keyHash);
        long newKeyPos = this.keyFile().append(prevKeyPos, key, dataOffset);
        this.hashBlock().put(keyHash, newKeyPos);
        return true;
    }

    public boolean update(byte[] key, byte[] value) {
        block3: {
            block2: {
                if (key == null) break block2;
                if (value != null) break block3;
            }
            throw new IOException("invalid key/value");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashBlock().get(keyHash);
        return this.keyFile().update(pos, key, value);
    }

    public byte[] get(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long realKeyPos = this.hashBlock().get(keyHash);
        try {
            while (realKeyPos > 0L) {
                byte[] oKey;
                if (!this.keyFile().isDeleted(realKeyPos) && CompareUtil.equals(oKey = this.keyFile().getTimeKey(realKeyPos), key)) {
                    return this.keyFile().getDataPos(realKeyPos);
                }
                realKeyPos = this.keyFile().getPrevPos(realKeyPos);
            }
        }
        catch (IOException iOException) {
            Logger$.MODULE$.println("S124", new StringBuilder().append((Object)"pos=").append((Object)BoxesRunTime.boxToLong((long)realKeyPos)).append((Object)" keyFile.lengrh=").append((Object)BoxesRunTime.boxToLong((long)this.keyFile().getLength())).toString());
            throw iOException;
        }
        return null;
    }

    public boolean hasKey(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashBlock().get(keyHash);
        while (pos > 0L) {
            byte[] okey;
            if (!this.keyFile().isDeleted(pos) && CompareUtil.equals(okey = this.keyFile().getTimeKey(pos), key)) {
                return true;
            }
            pos = this.keyFile().getPrevPos(pos);
        }
        return false;
    }

    public List<byte[]> getAll(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        ArrayList<byte[]> out = new ArrayList<byte[]>();
        int keyHash = HashUtil.hash(key);
        long pos = this.hashBlock().get(keyHash);
        while (pos > 0L) {
            byte[] okey;
            Object object = !this.keyFile().isDeleted(pos) ? (CompareUtil.equals(okey = this.keyFile().getTimeKey(pos), key) ? BoxesRunTime.boxToBoolean((boolean)out.add(this.keyFile().getDataPos(pos))) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
            pos = this.keyFile().getPrevPos(pos);
        }
        return out;
    }

    public int delete(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashBlock().get(keyHash);
        int deleted = 0;
        while (pos > 0L) {
            byte[] okey;
            if (!this.keyFile().isDeleted(pos) && CompareUtil.equals(okey = this.keyFile().getTimeKey(pos), key)) {
                this.keyFile().setDelete(pos, true);
                ++deleted;
            }
            pos = this.keyFile().getPrevPos(pos);
        }
        return deleted;
    }

    public void read(Function2<byte[], byte[], Object> handler) {
        if (this.keyFile() == null) {
            return;
        }
        long pos = this.keyFile().getFirstPos();
        long length = this.keyFile().getLength();
        int done = 0;
        try {
            while (pos < length && pos > 0L) {
                ITEM r = this.keyFile().getRecord(pos);
                Object object = !r.deleted() ? handler.apply((Object)r.timeKey(), (Object)r.dataPos()) : BoxedUnit.UNIT;
                ++done;
                pos = r.offset();
            }
        }
        catch (Throwable throwable) {
            Logger$.MODULE$.println("S125", new StringBuilder().append((Object)this.keyFile().path()).append((Object)" : read=").append((Object)BoxesRunTime.boxToInteger((int)done)).append((Object)" pos=").append((Object)BoxesRunTime.boxToLong((long)pos)).append((Object)" file-len=").append((Object)BoxesRunTime.boxToLong((long)length)).append((Object)" ").append((Object)throwable).toString());
        }
    }

    public void read(Function2<byte[], byte[], Object> handler, Function1<Object, byte[]> reader) {
        if (this.keyFile() == null) {
            return;
        }
        long pos = this.keyFile().getFirstPos();
        long length = this.keyFile().getLength();
        int done = 0;
        try {
            while (pos < length && pos > 0L) {
                ITEM r = this.keyFile().getRecord(pos);
                Object object = !r.deleted() ? handler.apply((Object)r.timeKey(), reader.apply((Object)BoxesRunTime.boxToLong((long)DataInputX.toLong5(r.dataPos(), 0)))) : BoxedUnit.UNIT;
                ++done;
                pos = r.offset();
            }
        }
        catch (Throwable throwable) {
            Logger$.MODULE$.println("S126", new StringBuilder().append((Object)this.keyFile().path()).append((Object)" : read=").append((Object)BoxesRunTime.boxToInteger((int)done)).append((Object)" pos=").append((Object)BoxesRunTime.boxToLong((long)pos)).append((Object)" file-len=").append((Object)BoxesRunTime.boxToLong((long)length)).append((Object)" ").append((Object)throwable).toString());
        }
    }

    public Map<String, Number> getStat() {
        int deleted = 0;
        int count = 0;
        long pos = this.keyFile().getFirstPos();
        long length = this.keyFile().getLength();
        while (pos < length && pos > 0L) {
            ITEM r = this.keyFile().getRecord(pos);
            if (r.deleted()) {
                ++deleted;
            } else {
                ++count;
            }
            pos = r.offset();
        }
        int scatter = this.hashBlock().getCount();
        HashMap<String, Number> out = new HashMap<String, Number>();
        out.put("count", Predef$.MODULE$.int2Integer(count));
        out.put("scatter", Predef$.MODULE$.int2Integer(scatter));
        out.put("deleted", Predef$.MODULE$.int2Integer(deleted));
        out.put("scan", Predef$.MODULE$.float2Float((float)(count + deleted) / (float)scatter));
        return out;
    }

    @Override
    public void close() {
        this.hashBlock().close();
        this.keyFile().close();
    }

    public IndexKeyFile(String _path, int hashSize) {
        this.MB = 0x100000;
        this.path = _path;
        this.hashBlock = new MemHashBlock(this.path(), hashSize * this.MB());
        this.keyFile = new RealKeyFile(this.path());
    }
}

