/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.io.zip;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import scouter.server.db.io.zip.GZipCtr;
import scouter.util.FileUtil;
import scouter.util.IClose;

public class CountBoard
implements IClose {
    private RandomAccessFile raf = null;
    public long counts;
    protected File file;

    public CountBoard(String date) throws IOException {
        String filename = GZipCtr.createPath(date) + "/count.dat";
        this.file = new File(filename);
        this.raf = new RandomAccessFile(this.file, "rw");
        if (this.raf.length() >= 8L) {
            try {
                this.load();
            }
            catch (IOException e) {
                this.counts = 0L;
                e.printStackTrace();
            }
        } else {
            this.counts = 0L;
        }
    }

    public long add(long cnt) {
        return this.set(this.counts + cnt);
    }

    public long set(long cnt) {
        this.counts = cnt;
        try {
            this.raf.seek(0L);
            this.raf.writeLong(this.counts);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.counts;
    }

    private void load() throws IOException {
        this.raf.seek(0L);
        this.counts = this.raf.readLong();
    }

    public long getCount() {
        return this.counts;
    }

    public void close() {
        FileUtil.close(this.raf);
        this.raf = null;
    }
}

