/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.io.zip;

import java.io.IOException;
import java.util.Enumeration;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.ShutdownManager;
import scouter.server.db.io.zip.Block;
import scouter.server.db.io.zip.IOChannel;
import scouter.util.IClose;
import scouter.util.IShutdown;
import scouter.util.LinkedMap;
import scouter.util.ThreadUtil;

public class GZipStore
extends Thread
implements IClose,
IShutdown {
    private static GZipStore instance = null;
    LinkedMap<String, Block> writingBlockTable = new LinkedMap();
    private boolean brun = true;
    private Configure conf = Configure.getInstance();

    public static final synchronized GZipStore getInstance() {
        if (instance == null) {
            instance = new GZipStore();
            ShutdownManager.add(instance);
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    public GZipStore() {
        Logger.println("S128", "COMPRESS MODE ENABLED");
    }

    public void run() {
        while (this.brun) {
            long now = System.currentTimeMillis();
            Enumeration<String> en = this.writingBlockTable.keys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                Block bk = this.writingBlockTable.get(key);
                if (bk == null || now <= bk.lastAccessTime + 10000L || !bk.dirty) continue;
                IOChannel.getInstance().store(bk);
                bk.lastAccessTime = System.currentTimeMillis();
            }
            for (int i = 0; i < 100 && this.brun; ++i) {
                ThreadUtil.sleep(100L);
            }
        }
    }

    public synchronized long write(String date, byte[] data) throws IOException {
        return this.write(date, data, 0L);
    }

    public synchronized long write(String date, byte[] data, long next) throws IOException {
        DataOutputX dout = new DataOutputX();
        dout.writeLong5(next);
        dout.writeInt3(data.length);
        dout.write(data);
        byte[] saveData = dout.toByteArray();
        Block bk = this.writingBlockTable.get(date);
        if (bk == null) {
            bk = IOChannel.getInstance().getLastWriteBlock(date);
            if (bk != null) {
                while (this.writingBlockTable.size() >= this.conf._compress_write_buffer_block_count) {
                    Block bb = this.writingBlockTable.removeFirst();
                    IOChannel.getInstance().store(bb);
                }
                this.writingBlockTable.put(date, bk);
            } else {
                Logger.println("ERROR -1 : write main data");
                return -1L;
            }
        }
        bk.lastAccessTime = System.currentTimeMillis();
        try {
            long pos = bk.getOffset();
            boolean ok = bk.write(saveData);
            if (ok) {
                return pos;
            }
            IOChannel.getInstance().store(bk);
            bk = bk.createNextBlock();
            this.writingBlockTable.put(date, bk);
            pos = bk.getOffset();
            ok = bk.write(saveData);
            return ok ? pos : -1L;
        }
        catch (Throwable ee) {
            Logger.println("S201", 5, ee.toString() + " => " + bk, ee);
            return -1L;
        }
    }

    private Block getWritingBlock(String date, int blockNum, long pos) {
        Block b = this.writingBlockTable.get(date);
        if (b == null) {
            return null;
        }
        if (b.blockNum == blockNum && b.readable(pos)) {
            return b;
        }
        return null;
    }

    public byte[] read(String date, long pos) {
        if (pos < 0L) {
            return null;
        }
        DataOutputX out = new DataOutputX();
        while (true) {
            int blockNum;
            Block bk;
            if ((bk = this.getWritingBlock(date, blockNum = (int)(pos / 0x2000000L), pos)) == null) {
                bk = IOChannel.getInstance().getReadBlock(date, blockNum);
            }
            if (bk == null) {
                return out.toByteArray();
            }
            try {
                long next = DataInputX.toLong5(bk.read(pos, 5), 0);
                int len = DataInputX.toInt3(bk.read(pos + 5L, 3), 0);
                byte[] record = bk.read(pos + 8L, len);
                out.write(record);
                if (next <= 0L) {
                    return out.toByteArray();
                }
                pos = next;
            }
            catch (NullPointerException ne) {
                return out.toByteArray();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return out.toByteArray();
            }
        }
    }

    public void flush() {
        if (this.writingBlockTable.size() == 0) {
            return;
        }
        LinkedMap<String, Block> blocks = this.writingBlockTable;
        this.writingBlockTable = new LinkedMap();
        while (blocks.size() > 0) {
            Block bk = blocks.removeFirst();
            IOChannel.getInstance().store(bk);
        }
    }

    public void shutdown() {
        this.brun = false;
        this.close();
    }

    public void close() {
        this.flush();
    }

    public void close(String date) {
        Block bb = this.writingBlockTable.remove(date);
        IOChannel.getInstance().store(bb);
        IOChannel.getInstance().close(date);
    }

    public static void main(String[] args) {
        LinkedMap<String, String> m = new LinkedMap<String, String>();
        m.put("a", "a");
        m.put("b", "b");
        m.put("c", "c");
        Enumeration en = m.keys();
        while (en.hasMoreElements()) {
            String n = (String)en.nextElement();
            if (n.equals("b")) {
                m.remove(n);
            }
            System.out.println(m);
        }
    }

    public static class Key {
        public String date;
        public int unitNum;

        public Key(String date, int unitNum) {
            this.date = date;
            this.unitNum = unitNum;
        }

        public int hashCode() {
            return this.unitNum ^ this.date.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key o = (Key)obj;
                return this.unitNum == o.unitNum && this.date.equals(o.date);
            }
            return false;
        }
    }
}

