/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.io.zip;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import scouter.server.ConfObserver;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.db.io.zip.BKey;
import scouter.server.db.io.zip.Block;
import scouter.server.db.io.zip.CountBoard;
import scouter.server.db.io.zip.GZipCtr;
import scouter.util.CacheTable;
import scouter.util.CompressUtil;
import scouter.util.FileUtil;
import scouter.util.IShutdown;
import scouter.util.LinkedMap;
import scouter.util.StopWatch;

public class IOChannel
implements IShutdown {
    private static IOChannel instance = null;
    private Configure conf = Configure.getInstance();
    private LinkedMap<String, CountBoard> headers = new LinkedMap();
    private static ExecutorService exec = Executors.newFixedThreadPool(Configure.getInstance()._compress_write_thread);
    static int old_block_thread = Configure.getInstance()._compress_write_thread;
    private CacheTable<BKey, Block> readCache;

    public static final synchronized IOChannel getInstance() {
        if (instance == null) {
            instance = new IOChannel();
        }
        return instance;
    }

    public IOChannel() {
        this.readCache = new CacheTable().setMaxRow(this.conf._compress_read_cache_block_count);
        ConfObserver.put(IOChannel.class.getName(), new Runnable(){

            public void run() {
                IOChannel.this.readCache.setMaxRow(((IOChannel)IOChannel.this).conf._compress_read_cache_block_count);
            }
        });
    }

    public Block getLastWriteBlock(String date) throws IOException {
        CountBoard uc = this.headers.get(date);
        if (uc == null) {
            this.check();
            uc = new CountBoard(date);
            this.headers.put(date, uc);
        }
        long n = uc.getCount();
        int start = (int)(n % 0x2000000L);
        Block bk = new Block(date, new byte[128], start, start, 0x2000000);
        bk.blockNum = (int)(n / 0x2000000L);
        return bk;
    }

    private void check() {
        while (this.headers.size() >= this.conf._compress_dailycount_header_cache_size - 1) {
            try {
                this.headers.removeFirst().close();
            }
            catch (Exception exception) {}
        }
    }

    public CountBoard getCountBoard(String date) {
        CountBoard uc = this.headers.get(date);
        if (uc == null) {
            this.check();
            try {
                uc = new CountBoard(date);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.headers.put(date, uc);
        }
        return uc;
    }

    public synchronized void store(Block bk) {
        if (!bk.dirty) {
            return;
        }
        bk.dirty = false;
        int mgtime = 0;
        StopWatch w = new StopWatch();
        if (bk.START > 0) {
            StopWatch w2 = new StopWatch();
            w2.start();
            Block old = this.getReadBlock(bk.date, bk.blockNum);
            if (old != null) {
                bk = bk.merge(old);
                this.readCache.put(new BKey(bk.date, bk.blockNum), bk, this.conf._compress_read_cache_expired_ms);
            }
            mgtime = (int)w2.getTime();
        }
        this.getCountBoard(bk.date).set(bk.getOffset());
        try {
            byte[] org = bk.getBlockBytes();
            String date = bk.date;
            int blockNum = bk.blockNum;
            IOChannel.saveBlockBytes(this.getFile(date, blockNum), org);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long tm = w.getTime();
        if (tm > 1000L) {
            Logger.println("S130", "Store " + tm + " ms " + (mgtime > 0 ? " old-load=" + mgtime + "ms" : ""));
        }
    }

    protected static void saveBlockBytes(final File file, final byte[] block) {
        exec.execute(new Runnable(){

            public void run() {
                try {
                    byte[] out = CompressUtil.doZip(block);
                    FileUtil.save(file, out);
                }
                catch (Exception e) {
                    Logger.println("S209", e.getMessage());
                }
            }
        });
    }

    private File getFile(String date, int blockNum) {
        String filename = GZipCtr.createPath(date) + "/xlog." + blockNum;
        return new File(filename);
    }

    public Block getReadBlock(String date, int blockNum) {
        Block b = this.readCache.get(new BKey(date, blockNum));
        if (b != null) {
            return b;
        }
        File f = this.getFile(date, blockNum);
        if (!f.exists()) {
            return null;
        }
        try {
            byte[] gz = FileUtil.readAll(f);
            gz = CompressUtil.unZip(gz);
            Block bk = new Block(date, gz, 0, gz.length, 0x2000000);
            bk.blockNum = blockNum;
            this.readCache.put(new BKey(date, blockNum), bk, this.conf._compress_read_cache_expired_ms);
            return bk;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public void shutdown() {
    }

    public void close(String date) {
        try {
            Enumeration<BKey> en = this.readCache.keys();
            while (en.hasMoreElements()) {
                BKey k = en.nextElement();
                if (!date.equals(k.date)) continue;
                this.readCache.remove(k);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        ConfObserver.put("_compress_write_thread", new Runnable(){

            public void run() {
                if (Configure.getInstance()._compress_write_thread != old_block_thread) {
                    ExecutorService oldExec = exec;
                    exec = Executors.newFixedThreadPool(Configure.getInstance()._compress_write_thread);
                    old_block_thread = Configure.getInstance()._compress_write_thread;
                    oldExec.shutdown();
                }
            }
        });
    }
}

