/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.xlog;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Properties;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.server.Configure;
import scouter.server.db.io.zip.GZipStore;
import scouter.server.db.xlog.XLogDataReader$;
import scouter.util.FileUtil;
import scouter.util.IClose;

@ScalaSignature(bytes="\u0006\u0001\u0005Mr!B\u0001\u0003\u0011\u0003Y\u0011A\u0004-M_\u001e$\u0015\r^1SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\tA\u0001\u001f7pO*\u0011QAB\u0001\u0003I\nT!a\u0002\u0005\u0002\rM,'O^3s\u0015\u0005I\u0011aB:d_V$XM]\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u00059AFj\\4ECR\f'+Z1eKJ\u001c\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0004\u001b\u001b\t\u0007I\u0011A\u000e\u0002\u000bQ\f'\r\\3\u0016\u0003q\u0001B!\b\u0012%W5\taD\u0003\u0002 A\u0005!Q\u000f^5m\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\u0013!\u000b7\u000f\u001b;bE2,\u0007CA\u0013)\u001d\t\tb%\u0003\u0002(%\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9#\u0003\u0005\u0002\rY\u0019!aB\u0001\u0001.'\rac\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0001\nA\u0001\\1oO&\u00111\u0007\r\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005U:T\"\u0001\u001c\u000b\u0005}A\u0011B\u0001\u001d7\u0005\u0019I5\t\\8tK\"A!\b\fB\u0001B\u0003%A%\u0001\u0003eCR,\u0007\u0002\u0003\u001f-\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\t\u0019LG.\u001a\u0005\u0006/1\"\tA\u0010\u000b\u0004W}\u0002\u0005\"\u0002\u001e>\u0001\u0004!\u0003\"\u0002\u001f>\u0001\u0004!\u0003b\u0002\"-\u0001\u0004%\taQ\u0001\te\u00164'/\u001a8dKV\tA\t\u0005\u0002\u0012\u000b&\u0011aI\u0005\u0002\u0004\u0013:$\bb\u0002%-\u0001\u0004%\t!S\u0001\re\u00164'/\u001a8dK~#S-\u001d\u000b\u0003\u00156\u0003\"!E&\n\u00051\u0013\"\u0001B+oSRDqAT$\u0002\u0002\u0003\u0007A)A\u0002yIEBa\u0001\u0015\u0017!B\u0013!\u0015!\u0003:fMJ,gnY3!\u0011\u001d\u0011FF1A\u0005\u0002M\u000bAaY8oMV\tA\u000b\u0005\u0002V-6\ta!\u0003\u0002X\r\tI1i\u001c8gS\u001e,(/\u001a\u0005\u000732\u0002\u000b\u0011\u0002+\u0002\u000b\r|gN\u001a\u0011\t\u000fmc\u0003\u0019!C\u00019\u0006I\u0001o\\5oi\u001aKG.Z\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001\rI\u0001\u0003S>L!AY0\u0003!I\u000bg\u000eZ8n\u0003\u000e\u001cWm]:GS2,\u0007b\u00023-\u0001\u0004%\t!Z\u0001\u000ea>Lg\u000e\u001e$jY\u0016|F%Z9\u0015\u0005)3\u0007b\u0002(d\u0003\u0003\u0005\r!\u0018\u0005\u0007Q2\u0002\u000b\u0015B/\u0002\u0015A|\u0017N\u001c;GS2,\u0007\u0005C\u0004kY\u0001\u0007I\u0011A6\u0002\t\u001dT\u0018\u000e]\u000b\u0002YB\u0011\u0011#\\\u0005\u0003]J\u0011qAQ8pY\u0016\fg\u000eC\u0004qY\u0001\u0007I\u0011A9\u0002\u0011\u001dT\u0018\u000e]0%KF$\"A\u0013:\t\u000f9{\u0017\u0011!a\u0001Y\"1A\u000f\fQ!\n1\fQa\u001a>ja\u0002BqA\u001e\u0017C\u0002\u0013\u0005q/\u0001\u0005d_:4g)\u001b7f+\u0005A\bC\u00010z\u0013\tQxL\u0001\u0003GS2,\u0007B\u0002?-A\u0003%\u00010A\u0005d_:4g)\u001b7fA!9a\u0010\fb\u0001\n\u00039\u0018\u0001\u0003=m_\u001e4\u0015\u000e\\3\t\u000f\u0005\u0005A\u0006)A\u0005q\u0006I\u0001\u0010\\8h\r&dW\r\t\u0005\b\u0003\u000baC\u0011AA\u0004\u0003\u0011\u0011X-\u00193\u0015\t\u0005%\u0011Q\u0003\t\u0006#\u0005-\u0011qB\u0005\u0004\u0003\u001b\u0011\"!B!se\u0006L\bcA\t\u0002\u0012%\u0019\u00111\u0003\n\u0003\t\tKH/\u001a\u0005\t\u0003/\t\u0019\u00011\u0001\u0002\u001a\u0005)\u0001o\\5oiB\u0019\u0011#a\u0007\n\u0007\u0005u!C\u0001\u0003M_:<\u0007bBA\u0011Y\u0011\u0005\u00131E\u0001\u0006G2|7/\u001a\u000b\u0002\u0015\"9\u0011qE\u0007!\u0002\u0013a\u0012A\u0002;bE2,\u0007\u0005C\u0004\u0002,5!\t!!\f\u0002\t=\u0004XM\u001c\u000b\u0006W\u0005=\u0012\u0011\u0007\u0005\u0007u\u0005%\u0002\u0019\u0001\u0013\t\rq\nI\u00031\u0001%\u0001")
public class XLogDataReader
implements IClose {
    private final String date;
    private final String file;
    private int refrence;
    private final Configure conf;
    private RandomAccessFile pointFile;
    private boolean gzip;
    private final File confFile;
    private final File xlogFile;

    public static XLogDataReader open(String string, String string2) {
        return XLogDataReader$.MODULE$.open(string, string2);
    }

    public static Hashtable<String, XLogDataReader> table() {
        return XLogDataReader$.MODULE$.table();
    }

    public int refrence() {
        return this.refrence;
    }

    public void refrence_$eq(int x$1) {
        this.refrence = x$1;
    }

    public Configure conf() {
        return this.conf;
    }

    public RandomAccessFile pointFile() {
        return this.pointFile;
    }

    public void pointFile_$eq(RandomAccessFile x$1) {
        this.pointFile = x$1;
    }

    public boolean gzip() {
        return this.gzip;
    }

    public void gzip_$eq(boolean x$1) {
        this.gzip = x$1;
    }

    public File confFile() {
        return this.confFile;
    }

    public File xlogFile() {
        return this.xlogFile;
    }

    public byte[] read(long point) {
        if (this.gzip()) {
            return GZipStore.getInstance().read(this.date, point);
        }
        if (this.pointFile() == null) {
            return null;
        }
        try {
            XLogDataReader xLogDataReader = this;
            synchronized (xLogDataReader) {
                this.pointFile().seek(point);
                short len = this.pointFile().readShort();
                byte[] buffer = new byte[len];
                this.pointFile().read(buffer);
                return buffer;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void close() {
        Hashtable<String, XLogDataReader> hashtable = XLogDataReader$.MODULE$.table();
        synchronized (hashtable) {
            BoxedUnit boxedUnit;
            if (this.refrence() == 0) {
                XLogDataReader$.MODULE$.table().remove(this.file);
                this.pointFile_$eq(FileUtil.close(this.pointFile()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.refrence_$eq(this.refrence() - 1);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public XLogDataReader(String date, String file) {
        this.date = date;
        this.file = file;
        this.refrence = 0;
        this.conf = Configure.getInstance();
        this.pointFile = null;
        this.gzip = this.conf().compress_xlog_enabled;
        this.confFile = new File(new StringBuilder().append((Object)file).append((Object)".service.conf").toString());
        if (this.confFile().exists()) {
            Properties properties = FileUtil.readProperties(this.confFile());
            this.gzip_$eq("true".equalsIgnoreCase(properties.getProperty("compress_xlog_enabled", String.valueOf(BoxesRunTime.boxToBoolean((boolean)this.conf().compress_xlog_enabled))).trim()));
        }
        this.xlogFile = new File(new StringBuilder().append((Object)file).append((Object)".service").toString());
        if (this.xlogFile().canRead()) {
            this.pointFile_$eq(new RandomAccessFile(this.xlogFile(), "r"));
        }
    }
}

