/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.xlog;

import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.server.Configure;
import scouter.server.db.io.RealDataFile;
import scouter.server.db.io.zip.GZipStore;
import scouter.server.db.xlog.XLogDataWriter$;
import scouter.util.FileUtil;
import scouter.util.IClose;

@ScalaSignature(bytes="\u0006\u0001\u0005]r!B\u0001\u0003\u0011\u0003Y\u0011A\u0004-M_\u001e$\u0015\r^1Xe&$XM\u001d\u0006\u0003\u0007\u0011\tA\u0001\u001f7pO*\u0011QAB\u0001\u0003I\nT!a\u0002\u0005\u0002\rM,'O^3s\u0015\u0005I\u0011aB:d_V$XM]\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u00059AFj\\4ECR\fwK]5uKJ\u001c\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0004\u001b\u001b\t\u0007I\u0011A\u000e\u0002\u000bQ\f'\r\\3\u0016\u0003q\u0001B!\b\u0012%W5\taD\u0003\u0002 A\u0005!Q\u000f^5m\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\u0013!\u000b7\u000f\u001b;bE2,\u0007CA\u0013)\u001d\t\tb%\u0003\u0002(%\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9#\u0003\u0005\u0002\rY\u0019!aB\u0001\u0001.'\rac\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0001\nA\u0001\\1oO&\u00111\u0007\r\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005U:T\"\u0001\u001c\u000b\u0005}A\u0011B\u0001\u001d7\u0005\u0019I5\t\\8tK\"A!\b\fB\u0001B\u0003%A%\u0001\u0003eCR,\u0007\u0002\u0003\u001f-\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\t\u0019LG.\u001a\u0005\u0006/1\"\tA\u0010\u000b\u0004W}\u0002\u0005\"\u0002\u001e>\u0001\u0004!\u0003\"\u0002\u001f>\u0001\u0004!\u0003b\u0002\"-\u0001\u0004%\taQ\u0001\te\u00164'/\u001a8dKV\tA\t\u0005\u0002\u0012\u000b&\u0011aI\u0005\u0002\u0004\u0013:$\bb\u0002%-\u0001\u0004%\t!S\u0001\re\u00164'/\u001a8dK~#S-\u001d\u000b\u0003\u00156\u0003\"!E&\n\u00051\u0013\"\u0001B+oSRDqAT$\u0002\u0002\u0003\u0007A)A\u0002yIEBa\u0001\u0015\u0017!B\u0013!\u0015!\u0003:fMJ,gnY3!\u0011\u001d\u0011FF1A\u0005\u0002M\u000bAaY8oMV\tA\u000b\u0005\u0002V-6\ta!\u0003\u0002X\r\tI1i\u001c8gS\u001e,(/\u001a\u0005\u000732\u0002\u000b\u0011\u0002+\u0002\u000b\r|gN\u001a\u0011\t\u000fmc\u0003\u0019!C\u00019\u0006!qM_5q+\u0005i\u0006CA\t_\u0013\ty&CA\u0004C_>dW-\u00198\t\u000f\u0005d\u0003\u0019!C\u0001E\u0006AqM_5q?\u0012*\u0017\u000f\u0006\u0002KG\"9a\nYA\u0001\u0002\u0004i\u0006BB3-A\u0003&Q,A\u0003hu&\u0004\b\u0005C\u0004hY\u0001\u0007I\u0011\u00015\u0002\u0003\u0019,\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u0002\n!![8\n\u00059\\'\u0001\u0002$jY\u0016Dq\u0001\u001d\u0017A\u0002\u0013\u0005\u0011/A\u0003g?\u0012*\u0017\u000f\u0006\u0002Ke\"9aj\\A\u0001\u0002\u0004I\u0007B\u0002;-A\u0003&\u0011.\u0001\u0002gA!9a\u000f\fa\u0001\n\u00039\u0018aA8viV\t\u0001\u0010\u0005\u0002zw6\t!P\u0003\u0002m\t%\u0011AP\u001f\u0002\r%\u0016\fG\u000eR1uC\u001aKG.\u001a\u0005\b}2\u0002\r\u0011\"\u0001\u0000\u0003\u001dyW\u000f^0%KF$2ASA\u0001\u0011\u001dqU0!AA\u0002aDq!!\u0002-A\u0003&\u00010\u0001\u0003pkR\u0004\u0003bBA\u0005Y\u0011\u0005\u00111B\u0001\u0006oJLG/\u001a\u000b\u0005\u0003\u001b\t\u0019\u0002E\u0002\u0012\u0003\u001fI1!!\u0005\u0013\u0005\u0011auN\\4\t\u0011\u0005U\u0011q\u0001a\u0001\u0003/\tQAY=uKN\u0004R!EA\r\u0003;I1!a\u0007\u0013\u0005\u0015\t%O]1z!\r\t\u0012qD\u0005\u0004\u0003C\u0011\"\u0001\u0002\"zi\u0016Dq!!\n-\t\u0003\n9#A\u0003dY>\u001cX\rF\u0001K\u0011\u001d\tY#\u0004Q\u0001\nq\ta\u0001^1cY\u0016\u0004\u0003bBA\u0018\u001b\u0011\u0005\u0011\u0011G\u0001\u0005_B,g\u000eF\u0003,\u0003g\t)\u0004\u0003\u0004;\u0003[\u0001\r\u0001\n\u0005\u0007y\u00055\u0002\u0019\u0001\u0013")
public class XLogDataWriter
implements IClose {
    private final String date;
    private final String file;
    private int refrence;
    private final Configure conf;
    private boolean gzip;
    private File f;
    private RealDataFile out;

    public static XLogDataWriter open(String string, String string2) {
        return XLogDataWriter$.MODULE$.open(string, string2);
    }

    public static Hashtable<String, XLogDataWriter> table() {
        return XLogDataWriter$.MODULE$.table();
    }

    public int refrence() {
        return this.refrence;
    }

    public void refrence_$eq(int x$1) {
        this.refrence = x$1;
    }

    public Configure conf() {
        return this.conf;
    }

    public boolean gzip() {
        return this.gzip;
    }

    public void gzip_$eq(boolean x$1) {
        this.gzip = x$1;
    }

    public File f() {
        return this.f;
    }

    public void f_$eq(File x$1) {
        this.f = x$1;
    }

    public RealDataFile out() {
        return this.out;
    }

    public void out_$eq(RealDataFile x$1) {
        this.out = x$1;
    }

    public long write(byte[] bytes) {
        if (this.gzip()) {
            return GZipStore.getInstance().write(this.date, bytes);
        }
        XLogDataWriter xLogDataWriter = this;
        synchronized (xLogDataWriter) {
            long point = this.out().getOffset();
            this.out().writeShort((short)bytes.length);
            this.out().write(bytes);
            this.out().flush();
            return point;
        }
    }

    @Override
    public void close() {
        Hashtable<String, XLogDataWriter> hashtable = XLogDataWriter$.MODULE$.table();
        synchronized (hashtable) {
            Object object;
            if (this.refrence() == 0) {
                XLogDataWriter$.MODULE$.table().remove(this.file);
                object = FileUtil.close(this.out());
            } else {
                this.refrence_$eq(this.refrence() - 1);
                object = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public XLogDataWriter(String date, String file) {
        this.date = date;
        this.file = file;
        this.refrence = 0;
        this.conf = Configure.getInstance();
        this.gzip = this.conf().compress_xlog_enabled;
        this.f = new File(new StringBuilder().append((Object)file).append((Object)".service.conf").toString());
        if (this.f().exists()) {
            Properties properties = FileUtil.readProperties(this.f());
            this.gzip_$eq("true".equalsIgnoreCase(properties.getProperty("compress_xlog_enabled", String.valueOf(BoxesRunTime.boxToBoolean((boolean)this.conf().compress_xlog_enabled))).trim()));
        } else {
            this.gzip_$eq(this.conf().compress_xlog_enabled);
            Properties properties = new Properties();
            properties.put("compress_xlog_enabled", String.valueOf(BoxesRunTime.boxToBoolean((boolean)this.conf().compress_xlog_enabled)));
            FileUtil.writeProperties(this.f(), properties);
        }
        this.out = null;
        if (!this.gzip()) {
            this.out_$eq(new RealDataFile(new StringBuilder().append((Object)file).append((Object)".service").toString()));
        }
    }
}

