/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.geoip;

import com.maxmind.geoip.Location;
import java.net.InetAddress;
import scouter.io.DataInputX;
import scouter.lang.pack.XLogPack;
import scouter.server.db.TextPermWR$;
import scouter.server.geoip.GISDataUtil$;
import scouter.util.HashUtil;
import scouter.util.IntKeyLinkedMap;
import scouter.util.IntLinkedSet;
import scouter.util.StringUtil;

public final class GeoIpUtil$ {
    public static final GeoIpUtil$ MODULE$;
    private final IntLinkedSet citySet;
    private final IntKeyLinkedMap<Location> locationCache;

    static {
        new GeoIpUtil$();
    }

    private IntLinkedSet citySet() {
        return this.citySet;
    }

    private IntKeyLinkedMap<Location> locationCache() {
        return this.locationCache;
    }

    public void setNationAndCity(XLogPack p) {
        if (p.ipaddr == null || p.ipaddr.length != 4) {
            return;
        }
        if (!GISDataUtil$.MODULE$.isOk()) {
            return;
        }
        if (!StringUtil.isEmpty(p.countryCode)) {
            return;
        }
        if (this.isPrivateIp(p.ipaddr)) {
            return;
        }
        int ipInt = DataInputX.toInt(p.ipaddr, 0);
        if (ipInt == 0) {
            return;
        }
        Location loc = this.locationCache().get(ipInt);
        if (loc == null) {
            loc = GISDataUtil$.MODULE$.getGeoIPInfos(InetAddress.getByAddress(p.ipaddr));
            if (loc == null) {
                return;
            }
            if (StringUtil.isEmpty(loc.city)) {
                loc.city = "unknown";
            }
            this.locationCache().put(ipInt, loc);
            int cityHash = HashUtil.hash(loc.city);
            if (!this.citySet().contains(cityHash)) {
                this.citySet().put(cityHash);
                TextPermWR$.MODULE$.add("city", cityHash, loc.city);
            }
        }
        p.countryCode = loc.countryCode;
        p.city = HashUtil.hash(loc.city);
    }

    private boolean isPrivateIp(byte[] ip) {
        int n = ip[0] & 0xFF;
        switch (n) {
            default: {
                return false;
            }
            case 192: {
                return ip[1] == 168;
            }
            case 172: {
                return ip[1] >= 16 && ip[1] <= 31;
            }
            case 10: 
            case 127: 
        }
        return true;
    }

    private GeoIpUtil$() {
        MODULE$ = this;
        this.citySet = new IntLinkedSet().setMax(10000);
        this.locationCache = new IntKeyLinkedMap().setMax(10000);
    }
}

