/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.http;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.http.servlet.CounterServlet;
import scouter.server.http.servlet.RegisterServlet;
import scouter.util.ThreadUtil;

public class HttpServer
extends Thread {
    private static volatile HttpServer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpServer load() {
        if (instance != null) return instance;
        Class<HttpServer> clazz = HttpServer.class;
        synchronized (HttpServer.class) {
            if (instance != null) return instance;
            instance = new HttpServer();
            instance.setName(ThreadUtil.getName(HttpServer.class));
            instance.setDaemon(true);
            instance.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void run() {
        Configure conf = Configure.getInstance();
        if (conf.net_http_server_enabled) {
            Server server = new Server(conf.net_http_port);
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            server.setHandler((Handler)context);
            context.addServlet(new ServletHolder(CounterServlet.class), "/counter/*");
            context.addServlet(new ServletHolder(RegisterServlet.class), "/register/*");
            try {
                server.start();
                server.join();
            }
            catch (Exception e) {
                Logger.println("HTTP", 10, "Failed to start http server", e);
            }
        }
    }
}

