/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.http.handler;

import java.io.Reader;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import scouter.lang.Counter;
import scouter.lang.Family;
import scouter.lang.ObjectType;
import scouter.lang.pack.MapPack;
import scouter.server.CounterManager;
import scouter.server.Logger;
import scouter.server.LoginManager;
import scouter.server.LoginUser;
import scouter.server.management.RemoteControl;
import scouter.server.management.RemoteControlManager;
import scouter.server.util.AsyncRun;

public class RegisterHandler {
    static CounterManager counterManager = CounterManager.getInstance();

    public static boolean process(Reader in) {
        JSONParser parser = new JSONParser();
        try {
            JSONObject json = (JSONObject)parser.parse(in);
            JSONObject objectInfo = (JSONObject)json.get((Object)"object");
            JSONArray countersArray = (JSONArray)json.get((Object)"counters");
            String objType2 = (String)objectInfo.get((Object)"type");
            ObjectType objectType = counterManager.getCounterEngine().getObjectType(objType2);
            if (objectType == null) {
                objectType = new ObjectType();
                objectType.setName(objType2);
                if (objectInfo.containsKey((Object)"display")) {
                    objectType.setDisplayName((String)objectInfo.get((Object)"display"));
                } else {
                    objectType.setDisplayName(objType2);
                }
                objectType.setIcon("");
                Family family = new Family();
                objectType.setFamily(family);
                if (counterManager.getCounterEngine().getFamily(objType2) == null) {
                    family.setName(objType2);
                } else {
                    family.setName(objType2 + "." + Math.random() * 100.0);
                }
                int counterSize = countersArray.size();
                for (int i = 0; i < counterSize; ++i) {
                    JSONObject counterInfo = (JSONObject)countersArray.get(i);
                    String name = (String)counterInfo.get((Object)"name");
                    String unit = (String)counterInfo.get((Object)"unit");
                    String display = name;
                    if (counterInfo.containsKey((Object)"display")) {
                        display = (String)counterInfo.get((Object)"display");
                    }
                    boolean total = true;
                    if (counterInfo.containsKey((Object)"total")) {
                        total = (Boolean)counterInfo.get((Object)"total");
                    }
                    boolean all = true;
                    if (counterInfo.containsKey((Object)"all")) {
                        all = (Boolean)counterInfo.get((Object)"all");
                    }
                    Counter counter = new Counter();
                    counter.setName(name);
                    counter.setUnit(unit);
                    counter.setDisplayName(display);
                    counter.setIcon("");
                    counter.setTotal(total);
                    counter.setAll(all);
                    family.addCounter(counter);
                    if (i != 0) continue;
                    family.setMaster(name);
                }
                boolean result = counterManager.addFamilyAndObjectType(family, objectType);
                if (result) {
                    RegisterHandler.notifyAllClients();
                    return true;
                }
            } else {
                ObjectType addObjectType = new ObjectType();
                addObjectType.setName(objType2);
                addObjectType.setFamily(objectType.getFamily());
                addObjectType.setIcon(objectType.getIcon());
                addObjectType.setSubObject(objectType.isSubObject());
                if (objectInfo.containsKey((Object)"display")) {
                    addObjectType.setDisplayName((String)objectInfo.get((Object)"display"));
                } else {
                    addObjectType.setDisplayName(objectType.getDisplayName());
                }
                int counterSize = countersArray.size();
                for (int i = 0; i < counterSize; ++i) {
                    JSONObject counterInfo = (JSONObject)countersArray.get(i);
                    String name = (String)counterInfo.get((Object)"name");
                    if (objectType.getCounter(name) != null) continue;
                    String unit = (String)counterInfo.get((Object)"unit");
                    String display = name;
                    if (counterInfo.containsKey((Object)"display")) {
                        display = (String)counterInfo.get((Object)"display");
                    }
                    boolean total = true;
                    if (counterInfo.containsKey((Object)"total")) {
                        total = (Boolean)counterInfo.get((Object)"total");
                    }
                    boolean all = true;
                    if (counterInfo.containsKey((Object)"all")) {
                        all = (Boolean)counterInfo.get((Object)"all");
                    }
                    Counter counter = new Counter();
                    counter.setName(name);
                    counter.setUnit(unit);
                    counter.setDisplayName(display);
                    counter.setIcon("");
                    counter.setTotal(total);
                    counter.setAll(all);
                    addObjectType.addCounter(counter);
                }
                boolean result = counterManager.editObjectType(addObjectType);
                if (result) {
                    RegisterHandler.notifyAllClients();
                    return true;
                }
            }
        }
        catch (Throwable th) {
            Logger.println("SC-8001", 30, "Http body parsing error", th);
            return false;
        }
        return false;
    }

    private static void notifyAllClients() {
        AsyncRun.getInstance().add(new Runnable(){

            public void run() {
                int len;
                RemoteControl control = new RemoteControl("REFETCH_COUNTER_XML", System.currentTimeMillis(), new MapPack(), 0L);
                LoginUser[] users = LoginManager.getLoginUserList();
                int n = len = users != null ? users.length : 0;
                for (int i = 0; i < len; ++i) {
                    long session = users[i].session();
                    RemoteControlManager.add(session, control);
                }
            }
        });
    }
}

