/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.data;

import java.net.InetAddress;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scouter.io.DataInputX;
import scouter.lang.pack.AlertPack;
import scouter.lang.pack.BatchPack;
import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.PerfCounterPack;
import scouter.lang.pack.StackPack;
import scouter.lang.pack.StatusPack;
import scouter.lang.pack.SummaryPack;
import scouter.lang.pack.TextPack;
import scouter.lang.pack.XLogPack;
import scouter.lang.pack.XLogProfilePack;
import scouter.lang.value.DecimalValue;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.core.AgentManager$;
import scouter.server.core.AlertCore$;
import scouter.server.core.BatchCore$;
import scouter.server.core.PerfCountCore$;
import scouter.server.core.ProfileCore$;
import scouter.server.core.StackAnalyzerCore$;
import scouter.server.core.StatusCore$;
import scouter.server.core.SummaryCore$;
import scouter.server.core.TextCore$;
import scouter.server.core.XLogCore$;
import scouter.server.core.cache.TextCache$;
import scouter.server.netio.data.MultiPacketProcessor$;
import scouter.server.netio.data.NetDataProcessor;
import scouter.server.netio.data.PackExtProcessChain$;
import scouter.server.util.ThreadScala$;
import scouter.util.BytesUtil;
import scouter.util.HashUtil;
import scouter.util.RequestQueue;
import scouter.util.StringUtil;

public final class NetDataProcessor$ {
    public static final NetDataProcessor$ MODULE$;
    private boolean working;
    private final int num;
    private final RequestQueue<NetDataProcessor.NetData> queue;
    private final Configure conf;

    static {
        new NetDataProcessor$();
    }

    public boolean working() {
        return this.working;
    }

    public void working_$eq(boolean x$1) {
        this.working = x$1;
    }

    public int num() {
        return this.num;
    }

    public RequestQueue<NetDataProcessor.NetData> queue() {
        return this.queue;
    }

    public Configure conf() {
        return this.conf;
    }

    public void add(byte[] data, InetAddress addr) {
        boolean ok = this.queue().putNotifySingle(new NetDataProcessor.NetData(data, addr));
        if (!ok) {
            Logger$.MODULE$.println("S158", 10, "overflow recv queue!!");
        }
    }

    public void process(NetDataProcessor.NetData p) {
        try {
            int cafe;
            DataInputX in = new DataInputX(p.data());
            int n = cafe = in.readInt();
            switch (n) {
                default: {
                    System.out.println(new StringBuilder().append((Object)"Receive unknown data, length=").append((Object)BoxesRunTime.boxToInteger((int)BytesUtil.getLength(p.data()))).append((Object)" from ").append((Object)p.addr()).toString());
                    break;
                }
                case 1246581845: {
                    this.processCafeMTU(in, p.addr());
                    break;
                }
                case 1245795918: {
                    this.processCafeN(in, p.addr());
                    break;
                }
                case 1245795905: {
                    this.processCafe(in, p.addr());
                    break;
                }
                case 1128351309: {
                    this.processCafeMTU(in, p.addr());
                    break;
                }
                case 1128351310: {
                    this.processCafeN(in, p.addr());
                    break;
                }
                case 1128351301: {
                    this.processCafe(in, p.addr());
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Logger$.MODULE$.println("S159", 10, "invalid data ", throwable);
            throwable.printStackTrace();
        }
    }

    private void processCafeMTU(DataInputX in, InetAddress addr) {
        int objHash = in.readInt();
        long pkid = in.readLong();
        short total = in.readShort();
        short num = in.readShort();
        byte[] data = in.readBlob();
        byte[] done = MultiPacketProcessor$.MODULE$.add(pkid, total, num, data, objHash, addr);
        if (done != null) {
            Pack p = new DataInputX(done).readPack();
            this.process(p, addr);
            if (this.conf().log_udp_multipacket) {
                String objName = TextCache$.MODULE$.get("object", objHash);
                StringBuffer sb = new StringBuffer();
                sb.append("recv ").append(p.getClass().getName());
                sb.append(" total=").append(total);
                sb.append(" object=(").append(objHash).append(")").append(objName);
                sb.append(" ").append(addr);
                Logger$.MODULE$.println("S160", sb.toString());
            }
        }
    }

    private void processCafe(DataInputX in, InetAddress addr) {
        Pack p = in.readPack();
        this.process(p, addr);
    }

    private void processCafeN(DataInputX in, InetAddress addr) {
        short n = in.readShort();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), (int)n).foreach$mVc$sp((Function1)new Serializable(in, addr){
            public static final long serialVersionUID = 0L;
            private final DataInputX in$1;
            private final InetAddress addr$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Pack p = this.in$1.readPack();
                NetDataProcessor$.MODULE$.process(p, this.addr$1);
            }
            {
                this.in$1 = in$1;
                this.addr$1 = addr$1;
            }
        });
    }

    public void process(Pack p, InetAddress addr) {
        if (p == null) {
            return;
        }
        if (this.conf().log_udp_packet) {
            System.out.println(p);
        }
        byte by = p.getPackType();
        switch (by) {
            default: {
                PackExtProcessChain$.MODULE$.doChain(p);
                break;
            }
            case 64: {
                BatchCore$.MODULE$.add((BatchPack)p);
                if (!this.conf().log_udp_batch) break;
                System.out.println(new StringBuilder().append((Object)"DEBUG UDP Batch: ").append((Object)p).toString());
                break;
            }
            case 63: {
                SummaryCore$.MODULE$.add((SummaryPack)p);
                if (!this.conf().log_udp_summary) break;
                System.out.println(new StringBuilder().append((Object)"DEBUG UDP SUMMARY: ").append((Object)p).toString());
                break;
            }
            case 62: {
                StackAnalyzerCore$.MODULE$.add((StackPack)p);
                if (!this.conf().log_udp_stack) break;
                System.out.println(new StringBuilder().append((Object)"DEBUG UDP STACK: ").append((Object)p).toString());
                break;
            }
            case 61: {
                StatusCore$.MODULE$.add((StatusPack)p);
                if (!this.conf().log_udp_status) break;
                System.out.println(new StringBuilder().append((Object)"DEBUG UDP STATUS: ").append((Object)p).toString());
                break;
            }
            case 80: {
                ObjectPack h = (ObjectPack)p;
                if (StringUtil.isEmpty(h.address)) {
                    h.address = addr.getHostAddress();
                }
                AgentManager$.MODULE$.active(h);
                if (!this.conf().log_udp_object) break;
                System.out.println(new StringBuilder().append((Object)"DEBUG UDP OBJECT: ").append((Object)p).toString());
                break;
            }
            case 70: {
                AlertCore$.MODULE$.add((AlertPack)p);
                if (!this.conf().log_udp_alert) break;
                System.out.println(new StringBuilder().append((Object)"DEBUG UDP ALERT: ").append((Object)p).toString());
                break;
            }
            case 50: {
                TextCore$.MODULE$.add((TextPack)p);
                if (!this.conf().log_udp_text) break;
                System.out.println(new StringBuilder().append((Object)"DEBUG UDP TEXT: ").append((Object)p).toString());
                break;
            }
            case 26: {
                ProfileCore$.MODULE$.add((XLogProfilePack)p);
                if (!this.conf().log_udp_profile) break;
                System.out.println(new StringBuilder().append((Object)"DEBUG UDP PROFILE: ").append((Object)p).toString());
                break;
            }
            case 21: {
                XLogCore$.MODULE$.add((XLogPack)p);
                if (!this.conf().log_udp_xlog) break;
                System.out.println(new StringBuilder().append((Object)"DEBUG UDP XLOG: ").append((Object)p).toString());
                break;
            }
            case 60: {
                PerfCounterPack counterPack = (PerfCounterPack)p;
                int objHash = HashUtil.hash(counterPack.objName);
                if (counterPack.time == 0L) {
                    counterPack.time = System.currentTimeMillis();
                }
                if (counterPack.timetype == 0) {
                    counterPack.timetype = 1;
                }
                counterPack.data.put("objHash", new DecimalValue(objHash));
                counterPack.data.put("time", new DecimalValue(counterPack.time));
                PerfCountCore$.MODULE$.add(counterPack);
                if (!this.conf().log_udp_counter) break;
                System.out.println(new StringBuilder().append((Object)"DEBUG UDP COUNTER: ").append((Object)p).toString());
            }
        }
    }

    private NetDataProcessor$() {
        MODULE$ = this;
        this.working = true;
        this.num = Configure.getInstance()._net_udp_worker_thread_count;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.num() - 1).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Thread apply(int x) {
                return ThreadScala$.MODULE$.startDaemon("scouter.server.netio.data.NetDataProcessor", (Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void apply$mcV$sp() {
                        while (NetDataProcessor$.MODULE$.working()) {
                            try {
                                NetDataProcessor.NetData data = NetDataProcessor$.MODULE$.queue().get();
                                NetDataProcessor$.MODULE$.process(data);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                continue;
                            }
                            break;
                        }
                        return;
                    }
                });
            }
        });
        this.queue = new RequestQueue(2048);
        this.conf = Configure.getInstance();
    }
}

