/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.service.handle;

import java.util.HashMap;
import java.util.Set;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.AlertLevel;
import scouter.lang.pack.AlertPack;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.SummaryPack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.server.core.cache.AlertCache$;
import scouter.server.core.cache.CacheOut;
import scouter.server.db.AlertRD$;
import scouter.server.db.ObjectRD$;
import scouter.server.db.SummaryRD$;
import scouter.server.netio.service.anotation.ServiceHandler;
import scouter.server.netio.service.handle.AlertService$;
import scouter.server.util.EnumerScala$;
import scouter.util.DateUtil;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u001b\ta\u0011\t\\3siN+'O^5dK*\u00111\u0001B\u0001\u0007Q\u0006tG\r\\3\u000b\u0005\u00151\u0011aB:feZL7-\u001a\u0006\u0003\u000f!\tQA\\3uS>T!!\u0003\u0006\u0002\rM,'O^3s\u0015\u0005Y\u0011aB:d_V$XM]\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAQA\u0007\u0001\u0005\u0002m\t1bZ3u%\u0016\fG\u000e^5nKR!AdH\u0014-!\tyQ$\u0003\u0002\u001f!\t!QK\\5u\u0011\u0015\u0001\u0013\u00041\u0001\"\u0003\r!\u0017N\u001c\t\u0003E\u0015j\u0011a\t\u0006\u0003I)\t!![8\n\u0005\u0019\u001a#A\u0003#bi\u0006Le\u000e];u1\")\u0001&\u0007a\u0001S\u0005!Am\\;u!\t\u0011#&\u0003\u0002,G\tYA)\u0019;b\u001fV$\b/\u001e;Y\u0011\u0015i\u0013\u00041\u0001/\u0003\u0015awnZ5o!\tyq&\u0003\u00021!\t9!i\\8mK\u0006t\u0007\u0006B\r3qe\u0002\"a\r\u001c\u000e\u0003QR!!\u000e\u0003\u0002\u0013\u0005tw\u000e^1uS>t\u0017BA\u001c5\u00059\u0019VM\u001d<jG\u0016D\u0015M\u001c3mKJ\fQA^1mk\u0016\f\u0013AO\u0001\u0010\u00032+%\u000bV0S\u000b\u0006cu\fV%N\u000b\")A\b\u0001C\u0001{\u0005yq-\u001a;BY\u0016\u0014H\u000fS5ti>\u0014\u0018\u0010\u0006\u0003\u001d}}\u0002\u0005\"\u0002\u0011<\u0001\u0004\t\u0003\"\u0002\u0015<\u0001\u0004I\u0003\"B\u0017<\u0001\u0004q\u0003\u0006B\u001e3q\t\u000b\u0013aQ\u0001\u0010\u00032+%\u000bV0M\u001f\u0006#u\fV%N\u000b\")Q\t\u0001C\u0005\r\u0006)1\r[3dWRAaf\u0012)S)Z[6\u000eC\u0003I\t\u0002\u0007\u0011*\u0001\u0003eCR,\u0007C\u0001&N\u001d\ty1*\u0003\u0002M!\u00051\u0001K]3eK\u001aL!AT(\u0003\rM#(/\u001b8h\u0015\ta\u0005\u0003C\u0003R\t\u0002\u0007\u0011*A\u0003mKZ,G\u000eC\u0003T\t\u0002\u0007\u0011*A\u0002pE*DQ!\u0016#A\u0002%\u000b1a[3z\u0011\u00159F\t1\u0001Y\u0003%aWM^3m\u0007>$W\r\u0005\u0002\u00103&\u0011!\f\u0005\u0002\u0005\u0005f$X\rC\u0003]\t\u0002\u0007Q,\u0001\buK6\u0004xJ\u00196OC6,W*\u00199\u0011\ty\u001bW-S\u0007\u0002?*\u0011\u0001-Y\u0001\u0005kRLGNC\u0001c\u0003\u0011Q\u0017M^1\n\u0005\u0011|&a\u0002%bg\"l\u0015\r\u001d\t\u0003M&l\u0011a\u001a\u0006\u0003Q\u0006\fA\u0001\\1oO&\u0011!n\u001a\u0002\b\u0013:$XmZ3s\u0011\u0015aG\t1\u0001n\u0003\u0011!\u0017\r^1\u0011\u0007=q\u0007,\u0003\u0002p!\t)\u0011I\u001d:bs\")\u0011\u000f\u0001C\u0001e\u0006yA/\u001b;mK\u0006cWM\u001d;D_VtG\u000f\u0006\u0003\u001dgR,\b\"\u0002\u0011q\u0001\u0004\t\u0003\"\u0002\u0015q\u0001\u0004I\u0003\"B\u0017q\u0001\u0004q\u0003\u0006\u000293q]\f\u0013\u0001_\u0001\u0012\u00032+%\u000bV0U\u0013RcUiX\"P+:#\u0006")
public class AlertService {
    @ServiceHandler(value="ALERT_REAL_TIME")
    public void getRealtime(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        int index = param.getInt("index");
        long loop = param.getLong("loop");
        String objType2 = param.getText("objType");
        boolean first = param.getBoolean("first");
        CacheOut<AlertPack> d = AlertCache$.MODULE$.get(objType2, loop, index);
        if (d == null) {
            return;
        }
        MapPack outparam = new MapPack();
        outparam.put("loop", new DecimalValue(d.loop()));
        outparam.put("index", new DecimalValue(d.index()));
        dout.writeByte(3);
        dout.writePack(outparam);
        if (first) {
            return;
        }
        EnumerScala$.MODULE$.forward(d.data(), new Serializable(this, dout){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$1;

            public final DataOutputX apply(AlertPack pack) {
                this.dout$1.writeByte(3);
                return this.dout$1.write(new DataOutputX().writePack(pack).toByteArray());
            }
            {
                this.dout$1 = dout$1;
            }
        });
    }

    @ServiceHandler(value="ALERT_LOAD_TIME")
    public void getAlertHistory(DataInputX din, DataOutputX dout, boolean login) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                MapPack param = (MapPack)din.readPack();
                String date = param.getText("date");
                long stime = param.getLong("stime");
                long etime = param.getLong("etime");
                int max = param.getInt("count");
                String level = param.getText("level");
                String obj = param.getText("object");
                String key = param.getText("key");
                byte levelCode = AlertLevel.getValue(level);
                int ccount = max < 1 || max > 1000 ? 500 : max;
                IntRef srchCnt = new IntRef(0);
                HashMap tempObjNameMap = new HashMap();
                Serializable handler = new Serializable(this, dout, date, level, obj, key, levelCode, ccount, srchCnt, tempObjNameMap, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AlertService $outer;
                    private final DataOutputX dout$2;
                    private final String date$1;
                    private final String level$1;
                    private final String obj$1;
                    private final String key$1;
                    private final byte levelCode$1;
                    private final int ccount$1;
                    private final IntRef srchCnt$1;
                    private final HashMap tempObjNameMap$1;
                    private final Object nonLocalReturnKey1$1;

                    public final Object apply(long time, byte[] data) {
                        Object object;
                        if (this.srchCnt$1.elem > this.ccount$1) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        boolean ok = this.$outer.scouter$server$netio$service$handle$AlertService$$check(this.date$1, this.level$1, this.obj$1, this.key$1, this.levelCode$1, this.tempObjNameMap$1, data);
                        if (ok) {
                            ++this.srchCnt$1.elem;
                            this.dout$2.writeByte(3);
                            object = this.dout$2.write(data);
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.dout$2 = dout$2;
                        this.date$1 = date$1;
                        this.level$1 = level$1;
                        this.obj$1 = obj$1;
                        this.key$1 = key$1;
                        this.levelCode$1 = levelCode$1;
                        this.ccount$1 = ccount$1;
                        this.srchCnt$1 = srchCnt$1;
                        this.tempObjNameMap$1 = tempObjNameMap$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                };
                AlertRD$.MODULE$.readByTime(date, stime, etime, (Function2<Object, byte[], Object>)handler);
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public boolean scouter$server$netio$service$handle$AlertService$$check(String date, String level, String obj, String key, byte levelCode, HashMap<Integer, String> tempObjNameMap, byte[] data) {
        AlertPack pack = (AlertPack)new DataInputX(data).readPack();
        if (level != null && levelCode != pack.level) {
            return false;
        }
        if (obj != null) {
            Object object;
            String objName = tempObjNameMap.get(BoxesRunTime.boxToInteger((int)pack.objHash));
            if (objName == null) {
                ObjectPack objPack = ObjectRD$.MODULE$.getObjectPack(date, pack.objHash);
                if (objPack == null) {
                    return false;
                }
                objName = objPack.objName;
                object = tempObjNameMap.put(Predef$.MODULE$.int2Integer(pack.objHash), objName);
            } else {
                object = BoxedUnit.UNIT;
            }
            if (!objName.contains(obj)) {
                return false;
            }
        }
        return key == null || pack.title.contains(key) || pack.message.contains(key);
    }

    @ServiceHandler(value="ALERT_TITLE_COUNT")
    public void titleAlertCount(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        String date = param.getText("date");
        long stime = param.getLong("stime");
        long etime = param.getLong("etime");
        HashMap valueMap = new HashMap();
        Serializable handler = new Serializable(this, valueMap){
            public static final long serialVersionUID = 0L;
            public final HashMap valueMap$1;

            public final void apply(long time, byte[] b) {
                SummaryPack data = (SummaryPack)new DataInputX(b).readPack();
                if (data.stype == 3) {
                    String hhmm = DateUtil.hhmm(time);
                    ListValue titleLv = data.table.getList("title");
                    ListValue levelLv = data.table.getList("level");
                    ListValue countLv = data.table.getList("count");
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), titleLv.size() - 1).foreach((Function1)new Serializable(this, hhmm, titleLv, levelLv, countLv){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$2 $outer;
                        private final String hhmm$1;
                        private final ListValue titleLv$1;
                        private final ListValue levelLv$1;
                        private final ListValue countLv$1;

                        public final Value apply(int i) {
                            Object object;
                            String title = this.titleLv$1.getString(i);
                            byte level = (byte)this.levelLv$1.getLong(i);
                            int count = this.countLv$1.getInt(i);
                            MapPack pack = (MapPack)this.$outer.valueMap$1.get(title);
                            if (pack == null) {
                                pack = new MapPack();
                                pack.put("title", title);
                                pack.put("level", level);
                                pack.put("count", new MapValue());
                                object = this.$outer.valueMap$1.put(title, pack);
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                            MapValue mv = (MapValue)pack.get("count");
                            return mv.put(this.hhmm$1, count);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.hhmm$1 = hhmm$1;
                            this.titleLv$1 = titleLv$1;
                            this.levelLv$1 = levelLv$1;
                            this.countLv$1 = countLv$1;
                        }
                    });
                }
            }
            {
                this.valueMap$1 = valueMap$1;
            }
        };
        SummaryRD$.MODULE$.readByTime((byte)3, date, stime, etime, (Function2<Object, byte[], Object>)handler);
        Set keySet = valueMap.keySet();
        JavaConversions$.MODULE$.asScalaSet(keySet).foreach((Function1)new Serializable(this, dout, valueMap){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$3;
            private final HashMap valueMap$1;

            public final DataOutputX apply(String title) {
                this.dout$3.writeByte(3);
                return this.dout$3.writePack((Pack)this.valueMap$1.get(title));
            }
            {
                this.dout$3 = dout$3;
                this.valueMap$1 = valueMap$1;
            }
        });
    }
}

