/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.service.handle;

import java.util.List;
import java.util.Map;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.CounterKey;
import scouter.lang.pack.MapPack;
import scouter.lang.value.DoubleValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.server.core.AgentManager$;
import scouter.server.core.cache.CounterCache$;
import scouter.server.db.ObjectRD$;
import scouter.server.db.RealtimeCounterRD$;
import scouter.server.netio.service.anotation.ServiceHandler;
import scouter.server.netio.service.handle.CounterService$;
import scouter.server.util.TimedSeries;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.IntKeyMap;
import scouter.util.StringUtil;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u00015\u0011abQ8v]R,'oU3sm&\u001cWM\u0003\u0002\u0004\t\u00051\u0001.\u00198eY\u0016T!!\u0002\u0004\u0002\u000fM,'O^5dK*\u0011q\u0001C\u0001\u0006]\u0016$\u0018n\u001c\u0006\u0003\u0013)\taa]3sm\u0016\u0014(\"A\u0006\u0002\u000fM\u001cw.\u001e;fe\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\u00065\u0001!\taG\u0001\fO\u0016$(+Z1m)&lW\r\u0006\u0003\u001d?\u001db\u0003CA\b\u001e\u0013\tq\u0002C\u0001\u0003V]&$\b\"\u0002\u0011\u001a\u0001\u0004\t\u0013a\u00013j]B\u0011!%J\u0007\u0002G)\u0011AEC\u0001\u0003S>L!AJ\u0012\u0003\u0015\u0011\u000bG/Y%oaV$\b\fC\u0003)3\u0001\u0007\u0011&\u0001\u0003e_V$\bC\u0001\u0012+\u0013\tY3EA\u0006ECR\fw*\u001e;qkRD\u0006\"B\u0017\u001a\u0001\u0004q\u0013!\u00027pO&t\u0007CA\b0\u0013\t\u0001\u0004CA\u0004C_>dW-\u00198)\te\u0011\u0004(\u000f\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0011\t\u0011\"\u00198pi\u0006$\u0018n\u001c8\n\u0005]\"$AD*feZL7-\u001a%b]\u0012dWM]\u0001\u0006m\u0006dW/Z\u0011\u0002u\u0005\t2iT+O)\u0016\u0013vLU#B\u0019~#\u0016*T#\t\u000bq\u0002A\u0011A\u001f\u0002\u001d\u001d,GOU3bYRKW.Z!mYR!ADP A\u0011\u0015\u00013\b1\u0001\"\u0011\u0015A3\b1\u0001*\u0011\u0015i3\b1\u0001/Q\u0011Y$\u0007\u000f\"\"\u0003\r\u000bQcQ(V\u001dR+%k\u0018*F\u00032{F+S'F?\u0006cE\nC\u0003F\u0001\u0011\u0005a)\u0001\thKR\u0014V-\u00197US6,W*\u001e7uSR!Ad\u0012%J\u0011\u0015\u0001C\t1\u0001\"\u0011\u0015AC\t1\u0001*\u0011\u0015iC\t1\u0001/Q\u0011!%\u0007O&\"\u00031\u000bqcQ(V\u001dR+%k\u0018*F\u00032{F+S'F?6+F\nV%\t\u000b9\u0003A\u0011A(\u0002)\u001d,GOU3bYRKW.Z(cU\u0016\u001cG/\u00117m)\u0011a\u0002+\u0015*\t\u000b\u0001j\u0005\u0019A\u0011\t\u000b!j\u0005\u0019A\u0015\t\u000b5j\u0005\u0019\u0001\u0018)\t5\u0013\u0004\bV\u0011\u0002+\u0006a2iT+O)\u0016\u0013vLU#B\u0019~#\u0016*T#`\u001f\nSUi\u0011+`\u00032c\u0005\"B,\u0001\t\u0003A\u0016\u0001G4fiJ+\u0017\r\u001c+j[\u0016|%M[3diRK\b/Z!mYR!A$\u0017.\\\u0011\u0015\u0001c\u000b1\u0001\"\u0011\u0015Ac\u000b1\u0001*\u0011\u0015ic\u000b1\u0001/Q\u00111&\u0007O/\"\u0003y\u000b\u0011eQ(V\u001dR+%k\u0018*F\u00032{F+S'F?>\u0013%*R\"U?RK\u0006+R0B\u00192CQ\u0001\u0019\u0001\u0005\u0002\u0005\f1cZ3u%\u0016\fG\u000eV5nK\u0006cG.T;mi&$B\u0001\b2dI\")\u0001e\u0018a\u0001C!)\u0001f\u0018a\u0001S!)Qf\u0018a\u0001]!\"qL\r\u001dgC\u00059\u0017aG\"P+:#VIU0S\u000b\u0006cu\fV%N\u000b~\u000bE\nT0N+2#\u0016\nC\u0003j\u0001\u0011\u0005!.\u0001\thKR\u0014V-\u00197US6,Gk\u001c;bYR!Ad\u001b7n\u0011\u0015\u0001\u0003\u000e1\u0001\"\u0011\u0015A\u0003\u000e1\u0001*\u0011\u0015i\u0003\u000e1\u0001/Q\u0011A'\u0007O8\"\u0003A\fQcQ(V\u001dR+%k\u0018*F\u00032{F+S'F?R{E\u000bC\u0003s\u0001\u0011\u00051/A\u0006hKR\u0004\u0016m\u001d;US6,G\u0003\u0002\u000fukZDQ\u0001I9A\u0002\u0005BQ\u0001K9A\u0002%BQ!L9A\u00029BC!\u001d\u001a9q\u0006\n\u00110A\tD\u001fVsE+\u0012*`!\u0006\u001bFk\u0018+J\u001b\u0016CQa\u001f\u0001\u0005\u0002q\fabZ3u!\u0006\u001cH\u000fV5nK\u0006cG\u000e\u0006\u0003\u001d{z|\b\"\u0002\u0011{\u0001\u0004\t\u0003\"\u0002\u0015{\u0001\u0004I\u0003\"B\u0017{\u0001\u0004q\u0003&\u0002>3q\u0005\r\u0011EAA\u0003\u0003U\u0019u*\u0016(U\u000bJ{\u0006+Q*U?RKU*R0B\u00192Cq!!\u0003\u0001\t\u0003\tY!\u0001\u0006hKR|%M\u001b(b[\u0016$b!!\u0004\u0002\u001c\u0005}\u0001\u0003BA\b\u0003+q1aDA\t\u0013\r\t\u0019\u0002E\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0011\u0011\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005M\u0001\u0003\u0003\u0005\u0002\u001e\u0005\u001d\u0001\u0019AA\u0007\u0003\u0011!\u0017\r^3\t\u0011\u0005\u0005\u0012q\u0001a\u0001\u0003G\tqa\u001c2k\u0011\u0006\u001c\b\u000eE\u0002\u0010\u0003KI1!a\n\u0011\u0005\rIe\u000e\u001e\u0005\b\u0003W\u0001A\u0011AA\u0017\u0003A9W\r\u001e)bgR$\u0016.\\3U_R\fG\u000eF\u0004\u001d\u0003_\t\t$a\r\t\r\u0001\nI\u00031\u0001\"\u0011\u0019A\u0013\u0011\u0006a\u0001S!1Q&!\u000bA\u00029Bc!!\u000b3q\u0005]\u0012EAA\u001d\u0003U\u0019u*\u0016(U\u000bJ{\u0006+Q*U?RKU*R0U\u001fRCq!!\u0010\u0001\t\u0003\ty$A\nhKR\u0004\u0016m\u001d;US6,wI]8va\u0006cG\u000eF\u0004\u001d\u0003\u0003\n\u0019%!\u0012\t\r\u0001\nY\u00041\u0001\"\u0011\u0019A\u00131\ba\u0001S!1Q&a\u000fA\u00029Bc!a\u000f3q\u0005%\u0013EAA&\u0003]\u0019u*\u0016(U\u000bJ{\u0006+Q*U?RKU*R0H%>+\u0006\u000bC\u0004\u0002P\u0001!\t!!\u0015\u0002'\u001d,GOU3bYRKW.Z$s_V\u0004\u0018\t\u001c7\u0015\u000fq\t\u0019&!\u0016\u0002X!1\u0001%!\u0014A\u0002\u0005Ba\u0001KA'\u0001\u0004I\u0003BB\u0017\u0002N\u0001\u0007a\u0006\u000b\u0004\u0002NIB\u00141L\u0011\u0003\u0003;\nqcQ(V\u001dR+%k\u0018*F\u00032{F+S'F?\u001e\u0013v*\u0016)")
public class CounterService {
    @ServiceHandler(value="COUNTER_REAL_TIME")
    public void getRealTime(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        CounterKey key = CounterKey.toCounterKey(param);
        Value v = CounterCache$.MODULE$.get(key);
        if (v != null) {
            dout.writeByte(3);
            dout.writeValue(v);
        }
    }

    @ServiceHandler(value="COUNTER_REAL_TIME_ALL")
    public void getRealTimeAll(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        String counter = param.getText("counter");
        String objType2 = param.getText("objType");
        if (StringUtil.isEmpty(objType2)) {
            System.out.println("please check.. COUNTER_REAL_TIME_ALL objType is null");
            return;
        }
        List<Object> insts = AgentManager$.MODULE$.getLiveObjHashList(objType2);
        MapPack mpack = new MapPack();
        ListValue instList = mpack.newList("objHash");
        ListValue values = mpack.newList("value");
        JavaConversions$.MODULE$.asScalaBuffer(insts).foreach((Function1)new Serializable(this, counter, instList, values){
            public static final long serialVersionUID = 0L;
            private final String counter$1;
            private final ListValue instList$1;
            private final ListValue values$1;

            public final Object apply(int objHash) {
                Object object;
                CounterKey key = new CounterKey(Predef$.MODULE$.int2Integer(objHash), this.counter$1, 1);
                Value v = CounterCache$.MODULE$.get(key);
                if (v == null) {
                    object = BoxedUnit.UNIT;
                } else {
                    this.instList$1.add(Predef$.MODULE$.int2Integer(objHash).intValue());
                    object = this.values$1.add(v);
                }
                return object;
            }
            {
                this.counter$1 = counter$1;
                this.instList$1 = instList$1;
                this.values$1 = values$1;
            }
        });
        dout.writeByte(3);
        dout.writePack(mpack);
    }

    @ServiceHandler(value="COUNTER_REAL_TIME_MULTI")
    public void getRealTimeMulti(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        int objHash = param.getInt("objHash");
        ListValue counterLv = param.getList("counter");
        MapPack out = new MapPack();
        ListValue counterOut = out.newList("counter");
        ListValue valueOut = out.newList("value");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), counterLv.size() - 1).foreach((Function1)new Serializable(this, objHash, counterLv, counterOut, valueOut){
            public static final long serialVersionUID = 0L;
            private final int objHash$1;
            private final ListValue counterLv$1;
            private final ListValue counterOut$1;
            private final ListValue valueOut$1;

            public final Object apply(int i) {
                Object object;
                CounterKey key = new CounterKey(this.objHash$1, this.counterLv$1.getString(i), 1);
                Value v = CounterCache$.MODULE$.get(key);
                if (v == null) {
                    object = BoxedUnit.UNIT;
                } else {
                    this.counterOut$1.add(this.counterLv$1.get(i));
                    object = this.valueOut$1.add(v);
                }
                return object;
            }
            {
                this.objHash$1 = objHash$1;
                this.counterLv$1 = counterLv$1;
                this.counterOut$1 = counterOut$1;
                this.valueOut$1 = valueOut$1;
            }
        });
        dout.writeByte(3);
        dout.writePack(out);
    }

    @ServiceHandler(value="COUNTER_REAL_TIME_OBJECT_ALL")
    public void getRealTimeObjectAll(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        int objHash = param.getInt("objHash");
        Map<String, Value> cntMap = CounterCache$.MODULE$.getObjectCounters(objHash, (byte)1);
        MapPack mpack = new MapPack();
        ListValue counters = mpack.newList("counter");
        ListValue values = mpack.newList("value");
        JavaConversions$.MODULE$.asScalaSet(cntMap.keySet()).foreach((Function1)new Serializable(this, cntMap, counters, values){
            public static final long serialVersionUID = 0L;
            private final Map cntMap$1;
            private final ListValue counters$1;
            private final ListValue values$2;

            public final ListValue apply(String counter) {
                Value value = (Value)this.cntMap$1.get(counter);
                this.counters$1.add(counter);
                return this.values$2.add(value);
            }
            {
                this.cntMap$1 = cntMap$1;
                this.counters$1 = counters$1;
                this.values$2 = values$2;
            }
        });
        dout.writeByte(3);
        dout.writePack(mpack);
    }

    @ServiceHandler(value="COUNTER_REAL_TIME_OBJECT_TYPE_ALL")
    public void getRealTimeObjectTypeAll(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        String objType2 = param.getText("objType");
        List<Object> liveObjectList = AgentManager$.MODULE$.getLiveObjHashList(objType2);
        MapPack mpack = new MapPack();
        JavaConversions$.MODULE$.asScalaBuffer(liveObjectList).foreach((Function1)new Serializable(this, mpack){
            public static final long serialVersionUID = 0L;
            public final MapPack mpack$1;

            public final void apply(int objHash) {
                this.apply$mcVI$sp(objHash);
            }

            public void apply$mcVI$sp(int objHash) {
                MapValue mapValue = new MapValue();
                Map<String, Value> cntMap = CounterCache$.MODULE$.getObjectCounters(Predef$.MODULE$.int2Integer(objHash), (byte)1);
                JavaConversions$.MODULE$.asScalaSet(cntMap.keySet()).foreach((Function1)new Serializable(this, mapValue, cntMap, objHash){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getRealTimeObjectTypeAll$1 $outer;
                    private final MapValue mapValue$1;
                    private final Map cntMap$2;
                    private final int objHash$3;

                    public final Value apply(String counter) {
                        Value value = (Value)this.cntMap$2.get(counter);
                        this.mapValue$1.put(counter, value);
                        return this.$outer.mpack$1.put(AgentManager$.MODULE$.getAgentName(Predef$.MODULE$.int2Integer(this.objHash$3)), this.mapValue$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.mapValue$1 = mapValue$1;
                        this.cntMap$2 = cntMap$2;
                        this.objHash$3 = objHash$3;
                    }
                });
            }
            {
                this.mpack$1 = mpack$1;
            }
        });
        dout.writeByte(3);
        dout.writePack(mpack);
    }

    @ServiceHandler(value="COUNTER_REAL_TIME_ALL_MULTI")
    public void getRealTimeAllMulti(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        ListValue counters = param.getList("counter");
        String objType2 = param.getText("objType");
        if (StringUtil.isEmpty(objType2)) {
            System.out.println("please check.. COUNTER_REAL_TIME_ALL objType is null");
            return;
        }
        List<Object> insts = AgentManager$.MODULE$.getLiveObjHashList(objType2);
        MapPack mpack = new MapPack();
        ListValue instList = mpack.newList("objHash");
        ListValue counterList2 = mpack.newList("counter");
        ListValue valueList = mpack.newList("value");
        JavaConversions$.MODULE$.asScalaBuffer(insts).foreach((Function1)new Serializable(this, counters, instList, counterList2, valueList){
            public static final long serialVersionUID = 0L;
            public final ListValue counters$2;
            public final ListValue instList$2;
            public final ListValue counterList$1;
            public final ListValue valueList$1;

            public final void apply(int objHash) {
                this.apply$mcVI$sp(objHash);
            }

            public void apply$mcVI$sp(int objHash) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.counters$2.size() - 1).foreach((Function1)new Serializable(this, objHash){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getRealTimeAllMulti$1 $outer;
                    private final int objHash$4;

                    public final Object apply(int i) {
                        Object object;
                        CounterKey key = new CounterKey(this.objHash$4, this.$outer.counters$2.getString(i), 1);
                        Value value = CounterCache$.MODULE$.get(key);
                        if (value == null) {
                            object = BoxedUnit.UNIT;
                        } else {
                            this.$outer.instList$2.add(this.objHash$4);
                            this.$outer.counterList$1.add(this.$outer.counters$2.get(i));
                            object = this.$outer.valueList$1.add(value);
                        }
                        return object;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.objHash$4 = objHash$4;
                    }
                });
            }
            {
                this.counters$2 = counters$2;
                this.instList$2 = instList$2;
                this.counterList$1 = counterList$1;
                this.valueList$1 = valueList$1;
            }
        });
        dout.writeByte(3);
        dout.writePack(mpack);
    }

    @ServiceHandler(value="COUNTER_REAL_TIME_TOT")
    public void getRealTimeTotal(DataInputX din, DataOutputX dout, boolean login) {
        MapPack inout = (MapPack)din.readPack();
        String objType2 = inout.getText("objType");
        if (StringUtil.isEmpty(objType2)) {
            System.out.println("please check.. COUNTER_REAL_TIME_TOT objType is null");
            return;
        }
        String counter = inout.getText("counter");
        String mode = inout.getText("mode");
        DoubleRef vvv = new DoubleRef(0.0);
        IntRef cnt = new IntRef(0);
        List<Object> insList = AgentManager$.MODULE$.getLiveObjHashList(objType2);
        JavaConversions$.MODULE$.asScalaBuffer(insList).foreach((Function1)new Serializable(this, counter, vvv, cnt){
            public static final long serialVersionUID = 0L;
            private final String counter$2;
            private final DoubleRef vvv$1;
            private final IntRef cnt$1;

            public final void apply(int objHash) {
                this.apply$mcVI$sp(objHash);
            }

            public void apply$mcVI$sp(int objHash) {
                CounterKey key = new CounterKey(objHash, this.counter$2, 1);
                Value v = CounterCache$.MODULE$.get(key);
                if (v != null) {
                    this.vvv$1.elem += CastUtil.cdouble(v);
                    ++this.cnt$1.elem;
                }
            }
            {
                this.counter$2 = counter$2;
                this.vvv$1 = vvv$1;
                this.cnt$1 = cnt$1;
            }
        });
        if (cnt.elem > 0 && "avg".equalsIgnoreCase(mode)) {
            vvv.elem /= (double)cnt.elem;
        }
        dout.writeByte(3);
        dout.writeValue(new DoubleValue(vvv.elem));
    }

    @ServiceHandler(value="COUNTER_PAST_TIME")
    public void getPastTime(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        int objHash = param.getInt("objHash");
        String counter = param.getText("counter");
        long stime = param.getLong("stime");
        long etime = param.getLong("etime");
        MapPack mpack = new MapPack();
        ListValue timeLv = mpack.newList("time");
        ListValue valueLv = mpack.newList("value");
        String date = DateUtil.yyyymmdd(stime);
        String objName = this.getObjName(date, objHash);
        Serializable handler = new Serializable(this, counter, timeLv, valueLv){
            public static final long serialVersionUID = 0L;
            private final String counter$3;
            private final ListValue timeLv$1;
            private final ListValue valueLv$1;

            public final Object apply(long time, MapValue data) {
                Object object;
                Value value = data.get(this.counter$3);
                if (value == null) {
                    object = BoxedUnit.UNIT;
                } else {
                    this.timeLv$1.add(time);
                    object = this.valueLv$1.add(value);
                }
                return object;
            }
            {
                this.counter$3 = counter$3;
                this.timeLv$1 = timeLv$1;
                this.valueLv$1 = valueLv$1;
            }
        };
        RealtimeCounterRD$.MODULE$.read(objName, date, stime, etime, (Function2<Object, MapValue, Object>)handler);
        dout.writeByte(3);
        dout.writePack(mpack);
    }

    @ServiceHandler(value="COUNTER_PAST_TIME_ALL")
    public void getPastTimeAll(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        long stime = param.getLong("stime");
        long etime = param.getLong("etime");
        String counter = param.getText("counter");
        String objType2 = param.getText("objType");
        if (StringUtil.isEmpty(objType2)) {
            System.out.println("please check.. COUNTER_LOAD_TIME_ALL objType is null");
            return;
        }
        String date = DateUtil.yyyymmdd(stime);
        MapPack agentGrp = AgentManager$.MODULE$.getDailyObjects(date, objType2);
        ListValue objHashLv = agentGrp.getList("objHash");
        IntKeyMap mapPackMap = new IntKeyMap();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), objHashLv.size() - 1).foreach((Function1)new Serializable(this, objHashLv, mapPackMap){
            public static final long serialVersionUID = 0L;
            private final ListValue objHashLv$1;
            private final IntKeyMap mapPackMap$1;

            public final MapPack apply(int i) {
                int objHash = this.objHashLv$1.getInt(i);
                MapPack mapPack = new MapPack();
                mapPack.put("objHash", objHash);
                ListValue timeLv = mapPack.newList("time");
                ListValue valueLv = mapPack.newList("value");
                return this.mapPackMap$1.put(objHash, mapPack);
            }
            {
                this.objHashLv$1 = objHashLv$1;
                this.mapPackMap$1 = mapPackMap$1;
            }
        });
        Serializable handler = new Serializable(this, counter, mapPackMap){
            public static final long serialVersionUID = 0L;
            private final String counter$4;
            private final IntKeyMap mapPackMap$1;

            public final Object apply(MapValue mapValue) {
                Object object;
                if (mapValue == null) {
                    object = BoxedUnit.UNIT;
                } else {
                    int objHash = mapValue.getInt("objHash");
                    long time = mapValue.getLong("time");
                    Value value = mapValue.get(this.counter$4);
                    if (value == null) {
                        object = BoxedUnit.UNIT;
                    } else {
                        MapPack curMapPack = (MapPack)this.mapPackMap$1.get(objHash);
                        if (curMapPack == null) {
                            object = BoxedUnit.UNIT;
                        } else {
                            curMapPack.getList("time").add(time);
                            object = curMapPack.getList("value").add(value);
                        }
                    }
                }
                return object;
            }
            {
                this.counter$4 = counter$4;
                this.mapPackMap$1 = mapPackMap$1;
            }
        };
        RealtimeCounterRD$.MODULE$.readBulk(date, stime, etime, (Function1<MapValue, Object>)handler);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), objHashLv.size() - 1).foreach$mVc$sp((Function1)new Serializable(this, dout, objHashLv, mapPackMap){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$1;
            private final ListValue objHashLv$1;
            private final IntKeyMap mapPackMap$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.dout$1.writeByte(3);
                MapPack mpack = (MapPack)this.mapPackMap$1.get(this.objHashLv$1.getInt(i));
                this.dout$1.writePack(mpack);
                this.dout$1.flush();
            }
            {
                this.dout$1 = dout$1;
                this.objHashLv$1 = objHashLv$1;
                this.mapPackMap$1 = mapPackMap$1;
            }
        });
    }

    public String getObjName(String date, int objHash) {
        return ObjectRD$.MODULE$.getObjName(date, objHash);
    }

    @ServiceHandler(value="COUNTER_PAST_TIME_TOT")
    public void getPastTimeTotal(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        long stime = param.getLong("stime");
        long etime = param.getLong("etime");
        String counter = param.getText("counter");
        String objType2 = param.getText("objType");
        if (StringUtil.isEmpty(objType2)) {
            System.out.println("please check.. COUNTER_PAST_TIME_TOT objType is null");
            return;
        }
        String mode = param.getText("mode");
        String date = DateUtil.yyyymmdd(stime);
        MapPack agentGrp = AgentManager$.MODULE$.getDailyObjects(date, objType2);
        ListValue objHashLv = agentGrp.getList("objHash");
        TimedSeries series = new TimedSeries();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), objHashLv.size() - 1).foreach$mVc$sp((Function1)new Serializable(this, stime, etime, counter, date, objHashLv, series){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CounterService $outer;
            private final long stime$1;
            private final long etime$1;
            public final String counter$5;
            private final String date$1;
            private final ListValue objHashLv$2;
            public final TimedSeries series$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int objHash = this.objHashLv$2.getInt(i);
                String objName = this.$outer.getObjName(this.date$1, objHash);
                Serializable handler = new Serializable(this, objHash){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getPastTimeTotal$1 $outer;
                    private final int objHash$2;

                    public final boolean apply(long time, MapValue data) {
                        Value value = data.get(this.$outer.counter$5);
                        if (value != null) {
                            this.$outer.series$1.add(Predef$.MODULE$.int2Integer(this.objHash$2), time, BoxesRunTime.boxToDouble((double)CastUtil.cdouble(value)));
                        }
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.objHash$2 = objHash$2;
                    }
                };
                RealtimeCounterRD$.MODULE$.read(objName, this.date$1, this.stime$1, this.etime$1, (Function2<Object, MapValue, Object>)handler);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.stime$1 = stime$1;
                this.etime$1 = etime$1;
                this.counter$5 = counter$5;
                this.date$1 = date$1;
                this.objHashLv$2 = objHashLv$2;
                this.series$1 = series$1;
            }
        });
        series.addEnd();
        MapPack mpack = new MapPack();
        ListValue timeLv = mpack.newList("time");
        ListValue valueLv = mpack.newList("value");
        long maxTime = series.getMaxTime();
        for (long minTime = series.getMinTime(); minTime <= maxTime; minTime += 2000L) {
            DoubleRef sum = new DoubleRef(0.0);
            List list = series.getInTimeList(minTime, 10000L);
            JavaConversions$.MODULE$.asScalaBuffer(list).foreach((Function1)new Serializable(this, sum){
                public static final long serialVersionUID = 0L;
                private final DoubleRef sum$1;

                public final void apply(double i) {
                    this.apply$mcVD$sp(i);
                }

                public void apply$mcVD$sp(double i) {
                    this.sum$1.elem += i;
                }
                {
                    this.sum$1 = sum$1;
                }
            });
            timeLv.add(minTime);
            if ("avg".equals(mode)) {
                if (list.size() > 0) {
                    valueLv.add(sum.elem / (double)list.size());
                    continue;
                }
                valueLv.add(0L);
                continue;
            }
            valueLv.add(sum.elem);
        }
        dout.writeByte(3);
        dout.writePack(mpack);
        dout.flush();
    }

    @ServiceHandler(value="COUNTER_PAST_TIME_GROUP")
    public void getPastTimeGroupAll(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        ListValue objHashLv = param.getList("objHash");
        String counter = param.getText("counter");
        long stime = param.getLong("stime");
        long etime = param.getLong("etime");
        String date = DateUtil.yyyymmdd(stime);
        IntKeyMap mapPackMap = new IntKeyMap();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), objHashLv.size() - 1).foreach((Function1)new Serializable(this, objHashLv, mapPackMap){
            public static final long serialVersionUID = 0L;
            private final ListValue objHashLv$3;
            private final IntKeyMap mapPackMap$2;

            public final MapPack apply(int i) {
                int objHash = this.objHashLv$3.getInt(i);
                MapPack mapPack = new MapPack();
                mapPack.put("objHash", objHash);
                ListValue timeLv = mapPack.newList("time");
                ListValue valueLv = mapPack.newList("value");
                return this.mapPackMap$2.put(objHash, mapPack);
            }
            {
                this.objHashLv$3 = objHashLv$3;
                this.mapPackMap$2 = mapPackMap$2;
            }
        });
        Serializable handler = new Serializable(this, counter, mapPackMap){
            public static final long serialVersionUID = 0L;
            private final String counter$6;
            private final IntKeyMap mapPackMap$2;

            public final Object apply(MapValue mapValue) {
                Object object;
                if (mapValue == null) {
                    object = BoxedUnit.UNIT;
                } else {
                    int objHash = mapValue.getInt("objHash");
                    long time = mapValue.getLong("time");
                    Value value = mapValue.get(this.counter$6);
                    if (value == null) {
                        object = BoxedUnit.UNIT;
                    } else {
                        MapPack curMapPack = (MapPack)this.mapPackMap$2.get(objHash);
                        if (curMapPack == null) {
                            object = BoxedUnit.UNIT;
                        } else {
                            curMapPack.getList("time").add(time);
                            object = curMapPack.getList("value").add(value);
                        }
                    }
                }
                return object;
            }
            {
                this.counter$6 = counter$6;
                this.mapPackMap$2 = mapPackMap$2;
            }
        };
        RealtimeCounterRD$.MODULE$.readBulk(date, stime, etime, (Function1<MapValue, Object>)handler);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), objHashLv.size() - 1).foreach$mVc$sp((Function1)new Serializable(this, dout, objHashLv, mapPackMap){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$2;
            private final ListValue objHashLv$3;
            private final IntKeyMap mapPackMap$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.dout$2.writeByte(3);
                MapPack mpack = (MapPack)this.mapPackMap$2.get(this.objHashLv$3.getInt(i));
                this.dout$2.writePack(mpack);
                this.dout$2.flush();
            }
            {
                this.dout$2 = dout$2;
                this.objHashLv$3 = objHashLv$3;
                this.mapPackMap$2 = mapPackMap$2;
            }
        });
    }

    @ServiceHandler(value="COUNTER_REAL_TIME_GROUP")
    public void getRealTimeGroupAll(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = (MapPack)din.readPack();
        String counter = param.getText("counter");
        ListValue objHashLv = param.getList("objHash");
        MapPack mpack = new MapPack();
        ListValue instList = mpack.newList("objHash");
        ListValue values = mpack.newList("value");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), objHashLv.size() - 1).foreach((Function1)new Serializable(this, counter, objHashLv, instList, values){
            public static final long serialVersionUID = 0L;
            private final String counter$7;
            private final ListValue objHashLv$4;
            private final ListValue instList$3;
            private final ListValue values$3;

            public final Object apply(int i) {
                Object object;
                CounterKey key = new CounterKey(this.objHashLv$4.getInt(i), this.counter$7, 1);
                Value v = CounterCache$.MODULE$.get(key);
                if (v == null) {
                    object = BoxedUnit.UNIT;
                } else {
                    this.instList$3.add(this.objHashLv$4.get(i));
                    object = this.values$3.add(v);
                }
                return object;
            }
            {
                this.counter$7 = counter$7;
                this.objHashLv$4 = objHashLv$4;
                this.instList$3 = instList$3;
                this.values$3 = values$3;
            }
        });
        dout.writeByte(3);
        dout.writePack(mpack);
    }
}

