/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.service.handle;

import java.util.TimeZone;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scouter.Version;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.Account;
import scouter.lang.pack.MapPack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.Value;
import scouter.server.Configure;
import scouter.server.LoginManager$;
import scouter.server.LoginUser;
import scouter.server.account.AccountManager$;
import scouter.server.netio.service.anotation.ServiceHandler;
import scouter.util.ArrayUtil;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001\u001b\taAj\\4j]N+'O^5dK*\u00111\u0001B\u0001\u0007Q\u0006tG\r\\3\u000b\u0005\u00151\u0011aB:feZL7-\u001a\u0006\u0003\u000f!\tQA\\3uS>T!!\u0003\u0006\u0002\rM,'O^3s\u0015\u0005Y\u0011aB:d_V$XM]\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAQA\u0007\u0001\u0005\u0002m\tQ\u0001\\8hS:$B\u0001H\u0010(YA\u0011q\"H\u0005\u0003=A\u0011A!\u00168ji\")\u0001%\u0007a\u0001C\u0005\u0019A-\u001b8\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011R\u0011AA5p\u0013\t13E\u0001\u0006ECR\f\u0017J\u001c9vibCQ\u0001K\rA\u0002%\nA\u0001Z8viB\u0011!EK\u0005\u0003W\r\u00121\u0002R1uC>+H\u000f];u1\")!$\u0007a\u0001[A\u0011qBL\u0005\u0003_A\u0011qAQ8pY\u0016\fg\u000e\u000b\u0003\u001ac]B\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0005\u0003%\tgn\u001c;bi&|g.\u0003\u00027g\tq1+\u001a:wS\u000e,\u0007*\u00198eY\u0016\u0014\u0018!\u0002<bYV,\u0017%A\u001d\u0002\u000b1{u)\u0013(\t\u000bm\u0002A\u0011\u0001\u001f\u0002\u0019\u001d,G\u000fT8hS:d\u0015n\u001d;\u0015\tqidh\u0010\u0005\u0006Ai\u0002\r!\t\u0005\u0006Qi\u0002\r!\u000b\u0005\u00065i\u0002\r!\f\u0015\u0005uE:\u0014)I\u0001C\u000399U\tV0M\u001f\u001eKej\u0018'J'RCQ\u0001\u0012\u0001\u0005\u0002\u0015\u000bqbZ3u'\u0016\u001c8/[8o\u0007\",7m\u001b\u000b\u00059\u0019;\u0005\nC\u0003!\u0007\u0002\u0007\u0011\u0005C\u0003)\u0007\u0002\u0007\u0011\u0006C\u0003\u001b\u0007\u0002\u0007Q\u0006\u000b\u0003Dc]R\u0015%A&\u0002\u001b\rCUiQ&`'\u0016\u001b6+S(O\u0011\u0015i\u0005\u0001\"\u0001O\u0003-9W\r^*feZ,'/\u00133\u0015\u0003=\u0003\"\u0001U*\u000f\u0005=\t\u0016B\u0001*\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\u0003\u0002")
public class LoginService {
    @ServiceHandler(value="LOGIN")
    public void login(DataInputX din, DataOutputX dout, boolean login) {
        Value value;
        MapPack m = din.readMapPack();
        String id = m.getText("id");
        String passwd = m.getText("pass");
        String ip = m.getText("ip");
        String name = m.getText("hostname");
        String clientVer = m.getText("version");
        long session = LoginManager$.MODULE$.login(id, passwd, ip);
        m.put("session", session);
        if (session == 0L) {
            value = m.put("error", "login fail");
        } else {
            LoginUser user = LoginManager$.MODULE$.getUser(session);
            user.hostname_$eq(name);
            user.version_$eq(clientVer);
            m.put("time", System.currentTimeMillis());
            m.put("server_id", this.getServerId());
            m.put("type", user.group());
            m.put("version", Version.getServerFullVersion());
            Account acc = AccountManager$.MODULE$.getAccount(id);
            Object object = acc == null ? BoxedUnit.UNIT : m.put("email", acc.email);
            m.put("timezone", TimeZone.getDefault().getDisplayName());
            MapValue mv = AccountManager$.MODULE$.getGroupPolicy(user.group());
            Object object2 = mv == null ? BoxedUnit.UNIT : m.put("policy", mv);
            MapValue menuMv = new MapValue();
            m.put("menu", menuMv);
            menuMv.put("tag_count", new BooleanValue(Configure.getInstance().tagcnt_enabled));
            value = m.put("so_time_out", Configure.getInstance().net_tcp_client_so_timeout_ms);
        }
        dout.writeByte(3);
        dout.writePack(m);
    }

    @ServiceHandler(value="GET_LOGIN_LIST")
    public void getLoginList(DataInputX din, DataOutputX dout, boolean login) {
        LoginUser[] users = LoginManager$.MODULE$.getLoginUserList();
        if (ArrayUtil.len((Object)users) > 0) {
            MapPack result = new MapPack();
            ListValue sessionLv = result.newList("session");
            ListValue userLv = result.newList("user");
            ListValue ipLv = result.newList("ip");
            ListValue loginTimeLv = result.newList("logintime");
            ListValue versioneLv = result.newList("ver");
            ListValue hostnameLv = result.newList("host");
            Predef$.MODULE$.refArrayOps((Object[])users).foreach((Function1)new Serializable(this, sessionLv, userLv, ipLv, loginTimeLv, versioneLv, hostnameLv){
                public static final long serialVersionUID = 0L;
                private final ListValue sessionLv$1;
                private final ListValue userLv$1;
                private final ListValue ipLv$1;
                private final ListValue loginTimeLv$1;
                private final ListValue versioneLv$1;
                private final ListValue hostnameLv$1;

                public final void apply(LoginUser usr) {
                    this.sessionLv$1.add(usr.session());
                    this.userLv$1.add(usr.id());
                    this.ipLv$1.add(usr.ip());
                    this.loginTimeLv$1.add((System.currentTimeMillis() - usr.logintime()) / 1000L);
                    this.versioneLv$1.add(usr.version());
                    this.hostnameLv$1.add(usr.hostname());
                }
                {
                    this.sessionLv$1 = sessionLv$1;
                    this.userLv$1 = userLv$1;
                    this.ipLv$1 = ipLv$1;
                    this.loginTimeLv$1 = loginTimeLv$1;
                    this.versioneLv$1 = versioneLv$1;
                    this.hostnameLv$1 = hostnameLv$1;
                }
            });
            dout.writeByte(3);
            dout.writePack(result);
        }
    }

    @ServiceHandler(value="CHECK_SESSION")
    public void getSessionCheck(DataInputX din, DataOutputX dout, boolean login) {
        MapPack m = din.readMapPack();
        long session = m.getLong("session");
        int validSession = LoginManager$.MODULE$.validSession(session);
        m.put("validSession", validSession);
        Object object = validSession == 0 ? m.put("error", "login fail") : BoxedUnit.UNIT;
        dout.writeByte(3);
        dout.writePack(m);
    }

    public String getServerId() {
        return Configure.getInstance().server_id;
    }
}

