/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.service.handle;

import java.util.Vector;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.XLogPack;
import scouter.lang.pack.XLogProfilePack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.server.Configure;
import scouter.server.core.cache.CacheOut;
import scouter.server.core.cache.XLogCache$;
import scouter.server.db.TextRD$;
import scouter.server.db.XLogProfileRD$;
import scouter.server.db.XLogRD$;
import scouter.server.netio.service.anotation.ServiceHandler;
import scouter.server.util.EnumerScala$;
import scouter.util.DateUtil;
import scouter.util.IPUtil;
import scouter.util.IntSet;
import scouter.util.StrMatch;
import scouter.util.StringUtil;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u00015\u00111\u0002\u0017'pON+'O^5dK*\u00111\u0001B\u0001\u0007Q\u0006tG\r\\3\u000b\u0005\u00151\u0011aB:feZL7-\u001a\u0006\u0003\u000f!\tQA\\3uS>T!!\u0003\u0006\u0002\rM,'O^3s\u0015\u0005Y\u0011aB:d_V$XM]\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAQA\u0007\u0001\u0005\u0002m\t!bZ3u!J|g-\u001b7f)\u0011ard\n\u0017\u0011\u0005=i\u0012B\u0001\u0010\u0011\u0005\u0011)f.\u001b;\t\u000b\u0001J\u0002\u0019A\u0011\u0002\u0007\u0011Lg\u000e\u0005\u0002#K5\t1E\u0003\u0002%\u0015\u0005\u0011\u0011n\\\u0005\u0003M\r\u0012!\u0002R1uC&s\u0007/\u001e;Y\u0011\u0015A\u0013\u00041\u0001*\u0003\u0011!w.\u001e;\u0011\u0005\tR\u0013BA\u0016$\u0005-!\u0015\r^1PkR\u0004X\u000f\u001e-\t\u000b5J\u0002\u0019\u0001\u0018\u0002\u000b1|w-\u001b8\u0011\u0005=y\u0013B\u0001\u0019\u0011\u0005\u001d\u0011un\u001c7fC:DC!\u0007\u001a9sA\u00111GN\u0007\u0002i)\u0011Q\u0007B\u0001\nC:|G/\u0019;j_:L!a\u000e\u001b\u0003\u001dM+'O^5dK\"\u000bg\u000e\u001a7fe\u0006)a/\u00197vK\u0006\n!(A\u0007U%\u0006s\u0005l\u0018)S\u001f\u001aKE*\u0012\u0005\u0006y\u0001!\t!P\u0001\u000fO\u0016$h)\u001e7m!J|g-\u001b7f)\u0011abh\u0010!\t\u000b\u0001Z\u0004\u0019A\u0011\t\u000b!Z\u0004\u0019A\u0015\t\u000b5Z\u0004\u0019\u0001\u0018)\tm\u0012\u0004HQ\u0011\u0002\u0007\u0006\u0011BKU!O1~\u0003&k\u0014$J\u0019\u0016{f)\u0016'M\u0011\u0015)\u0005\u0001\"\u0001G\u0003Q9W\r\u001e*fC2$\u0018.\\3QKJ4wI]8vaR!Ad\u0012%J\u0011\u0015\u0001C\t1\u0001\"\u0011\u0015AC\t1\u0001*\u0011\u0015iC\t1\u0001/Q\u0011!%\u0007O&\"\u00031\u000bQ\u0003\u0016*B\u001db{&+R!M?RKU*R0H%>+\u0006\u000bC\u0003O\u0001\u0011\u0005q*A\u0010hKR\u0014V-\u00197uS6,\u0007+\u001a:g\u000fJ|W\u000f\u001d'bi\u0016\u001cHoQ8v]R$B\u0001\b)R%\")\u0001%\u0014a\u0001C!)\u0001&\u0014a\u0001S!)Q&\u0014a\u0001]!\"QJ\r\u001dUC\u0005)\u0016\u0001\b+S\u0003:CvLU#B\u0019~#\u0016*T#`\u000fJ{U\u000bU0M\u0003R+5\u000b\u0016\u0005\u0006/\u0002!\t\u0001W\u0001\u0014O\u0016$\b*[:u_JL\b+\u001a:g\u000fJ|W\u000f\u001d\u000b\u00059eS6\fC\u0003!-\u0002\u0007\u0011\u0005C\u0003)-\u0002\u0007\u0011\u0006C\u0003.-\u0002\u0007a\u0006\u000b\u0003Weaj\u0016%\u00010\u0002+Q\u0013\u0016I\u0014-`\u0019>\u000bEi\u0018+J\u001b\u0016{vIU(V!\")\u0001\r\u0001C\u0001C\u0006Q!/Z1e\u0005f<\u00050\u00133\u0015\tq\u00117\r\u001a\u0005\u0006A}\u0003\r!\t\u0005\u0006Q}\u0003\r!\u000b\u0005\u0006[}\u0003\rA\f\u0015\u0005?JBd-I\u0001h\u0003EAFjT$`%\u0016\u000bEi\u0018\"Z?\u001eC\u0016\n\u0012\u0005\u0006S\u0002!\tA[\u0001\u000be\u0016\fGMQ=Uq&#G\u0003\u0002\u000flY6DQ\u0001\t5A\u0002\u0005BQ\u0001\u000b5A\u0002%BQ!\f5A\u00029BC\u0001\u001b\u001a9_\u0006\n\u0001/A\tY\u0019>;uLU#B\t~\u0013\u0015l\u0018+Y\u0013\u0012CQA\u001d\u0001\u0005\u0002M\f!\u0002\\8bI\nKx\t_%e)\u0011aB/\u001e<\t\u000b\u0001\n\b\u0019A\u0011\t\u000b!\n\b\u0019A\u0015\t\u000b5\n\b\u0019\u0001\u0018)\tE\u0014\u0004\b_\u0011\u0002s\u0006\t\u0002\fT(H?2{\u0015\tR0C3~;\u0005,\u0013#\t\u000bm\u0004A\u0011\u0001?\u0002'E,\u0018nY6TK\u0006\u00148\r\u001b-m_\u001ed\u0015n\u001d;\u0015\tqihp \u0005\u0006Ai\u0004\r!\t\u0005\u0006Qi\u0004\r!\u000b\u0005\u0006[i\u0004\rA\f\u0015\u0006uJB\u00141A\u0011\u0003\u0003\u000b\tQ#U+J\u0007.\u001bV)\u0011*D\u0011~CFjT$`\u0019&\u001bF\u000bC\u0004\u0002\n\u0001!\t!a\u0003\u0002\u001dM,\u0017M]2i12|w\rT5tiR9A$!\u0004\u0002\u0010\u0005E\u0001B\u0002\u0011\u0002\b\u0001\u0007\u0011\u0005\u0003\u0004)\u0003\u000f\u0001\r!\u000b\u0005\u0007[\u0005\u001d\u0001\u0019\u0001\u0018)\r\u0005\u001d!\u0007OA\u000bC\t\t9\"\u0001\tT\u000b\u0006\u00136\tS0Y\u0019>;u\fT%T)\u0002")
public class XLogService {
    @ServiceHandler(value="TRANX_PROFILE")
    public void getProfile(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String date = param.getText("date");
        long txid = param.getLong("txid");
        int max = param.getInt("max");
        if (StringUtil.isEmpty(date)) {
            date = DateUtil.yyyymmdd(System.currentTimeMillis());
        }
        try {
            byte[] profilePacket = XLogProfileRD$.MODULE$.getProfile(date, txid, max);
            if (profilePacket != null) {
                dout.writeByte(3);
                XLogProfilePack p = new XLogProfilePack();
                p.profile = profilePacket;
                dout.writePack(p);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @ServiceHandler(value="TRANX_PROFILE_FULL")
    public void getFullProfile(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String date = param.getText("date");
        long txid = param.getLong("txid");
        int max = -1;
        if (StringUtil.isEmpty(date)) {
            date = DateUtil.yyyymmdd();
        }
        XLogProfileRD$.MODULE$.getFullProfile(date, txid, max, (Function1<byte[], Object>)new Serializable(this, dout){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$1;

            public final DataOutputX apply(byte[] data) {
                this.dout$1.writeByte(3);
                return this.dout$1.writeBlob(data);
            }
            {
                this.dout$1 = dout$1;
            }
        });
    }

    @ServiceHandler(value="TRANX_REAL_TIME_GROUP")
    public void getRealtimePerfGroup(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        int index = param.getInt("index");
        long loop = param.getLong("loop");
        int limit = param.getInt("limit");
        limit = Math.max(Configure.getInstance().xlog_realtime_lower_bound_ms, limit);
        ListValue objHashLv = param.getList("objHash");
        if (objHashLv == null || objHashLv.size() < 1) {
            return;
        }
        IntSet intSet = new IntSet(objHashLv.size(), 1.0f);
        EnumerScala$.MODULE$.foreach(objHashLv, new Serializable(this, intSet){
            public static final long serialVersionUID = 0L;
            private final IntSet intSet$1;

            public final boolean apply(DecimalValue obj) {
                return this.intSet$1.add(obj.intValue());
            }
            {
                this.intSet$1 = intSet$1;
            }
        });
        CacheOut<byte[]> d = XLogCache$.MODULE$.get(intSet, loop, index, limit);
        if (d == null) {
            return;
        }
        MapPack outparam = new MapPack();
        outparam.put("loop", new DecimalValue(d.loop()));
        outparam.put("index", new DecimalValue(d.index()));
        dout.writeByte(3);
        dout.writePack(outparam);
        EnumerScala$.MODULE$.forward(d.data(), new Serializable(this, dout){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$2;

            public final DataOutputX apply(byte[] p) {
                this.dout$2.writeByte(3);
                return this.dout$2.write(p);
            }
            {
                this.dout$2 = dout$2;
            }
        });
    }

    @ServiceHandler(value="TRANX_REAL_TIME_GROUP_LATEST")
    public void getRealtimePerfGroupLatestCount(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        int index = param.getInt("index");
        long loop = param.getLong("loop");
        int count = param.getInt("count");
        ListValue objHashLv = param.getList("objHash");
        if (objHashLv == null || objHashLv.size() < 1) {
            return;
        }
        IntSet objHashSet = new IntSet(objHashLv.size(), 1.0f);
        EnumerScala$.MODULE$.foreach(objHashLv, new Serializable(this, objHashSet){
            public static final long serialVersionUID = 0L;
            private final IntSet objHashSet$1;

            public final boolean apply(DecimalValue obj) {
                return this.objHashSet$1.add(obj.intValue());
            }
            {
                this.objHashSet$1 = objHashSet$1;
            }
        });
        CacheOut<byte[]> d = XLogCache$.MODULE$.getWithinCount(objHashSet, loop, index, count);
        if (d == null) {
            return;
        }
        MapPack outparam = new MapPack();
        outparam.put("loop", new DecimalValue(d.loop()));
        outparam.put("index", new DecimalValue(d.index()));
        dout.writeByte(3);
        dout.writePack(outparam);
        EnumerScala$.MODULE$.forward(d.data(), new Serializable(this, dout){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$3;

            public final DataOutputX apply(byte[] p) {
                this.dout$3.writeByte(3);
                return this.dout$3.write(p);
            }
            {
                this.dout$3 = dout$3;
            }
        });
    }

    @ServiceHandler(value="TRANX_LOAD_TIME_GROUP")
    public void getHistoryPerfGroup(DataInputX din, DataOutputX dout, boolean login) {
        NonLocalReturnControl nonLocalReturnControl2;
        block5: {
            Object object = new Object();
            try {
                MapPack param = din.readMapPack();
                String date = param.getText("date");
                long stime = param.getLong("stime");
                long etime = param.getLong("etime");
                int limitTime = param.getInt("limit");
                int limit = Math.max(Configure.getInstance().xlog_pasttime_lower_bound_ms, limitTime);
                int max = param.getInt("max");
                boolean rev = param.getBoolean("reverse");
                ListValue objHashLv = param.getList("objHash");
                if (objHashLv == null || objHashLv.size() < 1) {
                    return;
                }
                IntSet objHashSet = new IntSet();
                EnumerScala$.MODULE$.foreach(objHashLv, new Serializable(this, objHashSet){
                    public static final long serialVersionUID = 0L;
                    private final IntSet objHashSet$2;

                    public final boolean apply(DecimalValue obj) {
                        return this.objHashSet$2.add(obj.intValue());
                    }
                    {
                        this.objHashSet$2 = objHashSet$2;
                    }
                });
                IntRef cnt = new IntRef(0);
                Serializable handler = new Serializable(this, dout, limit, max, objHashSet, cnt, object){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputX dout$4;
                    private final int limit$1;
                    private final int max$1;
                    private final IntSet objHashSet$2;
                    private final IntRef cnt$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(long time, byte[] data) {
                        XLogPack x = (XLogPack)new DataInputX(data).readPack();
                        if (this.objHashSet$2.contains(x.objHash) && x.elapsed > this.limit$1) {
                            this.dout$4.writeByte(3);
                            this.dout$4.write(data);
                            this.dout$4.flush();
                            ++this.cnt$1.elem;
                        }
                        if (this.max$1 > 0 && this.cnt$1.elem >= this.max$1) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                    }
                    {
                        this.dout$4 = dout$4;
                        this.limit$1 = limit$1;
                        this.max$1 = max$1;
                        this.objHashSet$2 = objHashSet$2;
                        this.cnt$1 = cnt$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                };
                if (rev) {
                    XLogRD$.MODULE$.readFromEndTime(date, stime, etime, (Function2<Object, byte[], Object>)handler);
                } else {
                    XLogRD$.MODULE$.readByTime(date, stime, etime, (Function2<Object, byte[], Object>)handler);
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block5;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    @ServiceHandler(value="XLOG_READ_BY_GXID")
    public void readByGxId(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String date = param.getText("date");
        long gxid = param.getLong("gxid");
        try {
            Vector<byte[]> list = XLogRD$.MODULE$.getByGxid(date, gxid);
            EnumerScala$.MODULE$.forward(list, new Serializable(this, dout){
                public static final long serialVersionUID = 0L;
                private final DataOutputX dout$5;

                public final void apply(byte[] xlog) {
                    this.dout$5.writeByte(3);
                    this.dout$5.write(xlog);
                    this.dout$5.flush();
                }
                {
                    this.dout$5 = dout$5;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ServiceHandler(value="XLOG_READ_BY_TXID")
    public void readByTxId(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String date = param.getText("date");
        long txid = param.getLong("txid");
        try {
            byte[] xbytes = XLogRD$.MODULE$.getByTxid(date, txid);
            if (xbytes != null) {
                dout.writeByte(3);
                dout.write(xbytes);
                dout.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ServiceHandler(value="XLOG_LOAD_BY_GXID")
    public void loadByGxId(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        long stime = param.getLong("stime");
        long etime = param.getLong("etime");
        long gxid = param.getLong("gxid");
        String date = DateUtil.yyyymmdd(stime);
        String date2 = DateUtil.yyyymmdd(etime);
        try {
            Vector<byte[]> list = XLogRD$.MODULE$.getByGxid(date, gxid);
            EnumerScala$.MODULE$.forward(list, new Serializable(this, dout){
                public static final long serialVersionUID = 0L;
                private final DataOutputX dout$6;

                public final void apply(byte[] xlog) {
                    this.dout$6.writeByte(3);
                    this.dout$6.write(xlog);
                    this.dout$6.flush();
                }
                {
                    this.dout$6 = dout$6;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!date.equals(date2)) {
            try {
                Vector<byte[]> list = XLogRD$.MODULE$.getByGxid(date2, gxid);
                EnumerScala$.MODULE$.forward(list, new Serializable(this, dout){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputX dout$6;

                    public final void apply(byte[] xlog) {
                        this.dout$6.writeByte(3);
                        this.dout$6.write(xlog);
                        this.dout$6.flush();
                    }
                    {
                        this.dout$6 = dout$6;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @ServiceHandler(value="QUICKSEARCH_XLOG_LIST")
    public void quickSearchXlogList(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String date = param.getText("date");
        long txid = param.getLong("txid");
        long gxid = param.getLong("gxid");
        if (txid != 0L) {
            try {
                byte[] xbytes = XLogRD$.MODULE$.getByTxid(date, txid);
                if (xbytes != null) {
                    dout.writeByte(3);
                    dout.write(xbytes);
                    dout.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (gxid != 0L) {
            try {
                Vector<byte[]> list = XLogRD$.MODULE$.getByGxid(date, gxid);
                if (list == null) {
                    return;
                }
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), list.size() - 1).foreach$mVc$sp((Function1)new Serializable(this, dout, list){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputX dout$7;
                    private final Vector list$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        byte[] xlog = (byte[])this.list$1.get(i);
                        this.dout$7.writeByte(3);
                        this.dout$7.write(xlog);
                        this.dout$7.flush();
                    }
                    {
                        this.dout$7 = dout$7;
                        this.list$1 = list$1;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @ServiceHandler(value="SEARCH_XLOG_LIST")
    public void searchXlogList(DataInputX din, DataOutputX dout, boolean login) {
        NonLocalReturnControl nonLocalReturnControl2;
        block5: {
            Object object = new Object();
            try {
                StrMatch serverMatch;
                MapPack param = din.readMapPack();
                long stime = param.getLong("stime");
                long etime = param.getLong("etime");
                String service = param.getText("service");
                int objHash = param.getInt("objHash");
                String ip = param.getText("ip");
                StrMatch strMatch = service == null ? null : (serverMatch = new StrMatch(service));
                StrMatch ipMatch = ip == null ? null : new StrMatch(ip);
                String date = DateUtil.yyyymmdd(stime);
                String date2 = DateUtil.yyyymmdd(etime);
                long mtime = 0L;
                boolean twoDays = false;
                IntRef loadCount = new IntRef(0);
                if (!date.equals(date2)) {
                    mtime = DateUtil.yyyymmdd(date2);
                    twoDays = true;
                }
                Serializable handler = new Serializable(this, dout, objHash, serverMatch, ipMatch, loadCount, object){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputX dout$8;
                    private final int objHash$1;
                    private final StrMatch serverMatch$1;
                    private final StrMatch ipMatch$1;
                    private final IntRef loadCount$1;
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(long time, byte[] data) {
                        String serviceName;
                        if (this.loadCount$1.elem >= 500) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey2$1, BoxedUnit.UNIT);
                        }
                        XLogPack x = (XLogPack)new DataInputX(data).readPack();
                        boolean ok = true;
                        if (this.ipMatch$1 != null) {
                            if (x.ipaddr == null) {
                                ok = false;
                            }
                            if (!this.ipMatch$1.include(IPUtil.toString(x.ipaddr))) {
                                ok = false;
                            }
                        }
                        if (this.objHash$1 != 0 && x.objHash != this.objHash$1) {
                            ok = false;
                        }
                        if (this.serverMatch$1 != null && !this.serverMatch$1.include(serviceName = TextRD$.MODULE$.getString(DateUtil.yyyymmdd(time), "service", x.service))) {
                            ok = false;
                        }
                        if (ok) {
                            this.dout$8.writeByte(3);
                            this.dout$8.write(data);
                            this.dout$8.flush();
                            ++this.loadCount$1.elem;
                        }
                    }
                    {
                        this.dout$8 = dout$8;
                        this.objHash$1 = objHash$1;
                        this.serverMatch$1 = serverMatch$1;
                        this.ipMatch$1 = ipMatch$1;
                        this.loadCount$1 = loadCount$1;
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                };
                if (twoDays) {
                    XLogRD$.MODULE$.readByTime(date, stime, mtime - 1L, (Function2<Object, byte[], Object>)handler);
                    XLogRD$.MODULE$.readByTime(date2, mtime, etime, (Function2<Object, byte[], Object>)handler);
                } else {
                    XLogRD$.MODULE$.readByTime(date, stime, etime, (Function2<Object, byte[], Object>)handler);
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block5;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }
}

