/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.plugin;

import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.XLogPack;
import scouter.server.Configure;
import scouter.server.core.AgentManager;
import scouter.server.core.app.XLogGroupUtil;
import scouter.server.db.TextPermRD;
import scouter.server.db.TextPermWR;
import scouter.server.db.TextRD;
import scouter.server.geoip.GeoIpUtil;
import scouter.server.plugin.IPlugIn;
import scouter.util.DateUtil;
import scouter.util.HashUtil;
import scouter.util.IntLinkedSet;

public class IXLog
extends IPlugIn {
    private static IntLinkedSet saved = new IntLinkedSet().setMax(1000);

    public void process(XLogPack p) {
    }

    public void setAutoGroup(XLogPack p) {
        XLogGroupUtil.process(p);
    }

    public void setLocation(XLogPack p) {
        if (Configure.getInstance().geoip_enabled) {
            GeoIpUtil.setNationAndCity(p);
        }
    }

    public String objName(XLogPack p) {
        return AgentManager.getAgentName(p.objHash);
    }

    public String objType(XLogPack p) {
        ObjectPack a = AgentManager.getAgent(p.objHash);
        if (a != null) {
            return a.objType;
        }
        return null;
    }

    public String service(XLogPack p) {
        return TextRD.getString(DateUtil.yyyymmdd(p.endTime), "service", p.service);
    }

    public String error(XLogPack p) {
        return TextRD.getString(DateUtil.yyyymmdd(p.endTime), "error", p.error);
    }

    public String userAgent(XLogPack p) {
        return TextPermRD.getString("ua", p.userAgent);
    }

    public String desc(XLogPack p) {
        return TextPermRD.getString("desc", p.desc);
    }

    public String referer(XLogPack p) {
        return TextPermRD.getString("referer", p.desc);
    }

    public String login(XLogPack p) {
        return TextPermRD.getString("login", p.login);
    }

    public String group(XLogPack p) {
        return TextPermRD.getString("group", p.group);
    }

    public int addGroup(String groupName) {
        int grpHash = HashUtil.hash(groupName);
        if (!saved.contains(grpHash)) {
            TextPermWR.add("group", grpHash, groupName);
        }
        return grpHash;
    }
}

