/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.plugin;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import scouter.lang.pack.AlertPack;
import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.PerfCounterPack;
import scouter.lang.pack.SummaryPack;
import scouter.lang.pack.XLogPack;
import scouter.lang.pack.XLogProfilePack;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.plugin.IAlert;
import scouter.server.plugin.ICounter;
import scouter.server.plugin.IObject;
import scouter.server.plugin.IPlugIn;
import scouter.server.plugin.ISummary;
import scouter.server.plugin.IXLog;
import scouter.server.plugin.IXLogProfile;
import scouter.server.plugin.PlugInManager;
import scouter.util.BitUtil;
import scouter.util.CastUtil;
import scouter.util.FileUtil;
import scouter.util.HashUtil;
import scouter.util.Hexa32;
import scouter.util.LongSet;
import scouter.util.StringUtil;
import scouter.util.ThreadUtil;

public class PlugInLoader
extends Thread {
    private static PlugInLoader instance;
    private LongSet compileErrorFiles = new LongSet();

    public static synchronized PlugInLoader getInstance() {
        if (instance == null) {
            instance = new PlugInLoader();
            instance.setDaemon(true);
            instance.setName("PluginLoader");
            instance.start();
        }
        return instance;
    }

    public void run() {
        while (true) {
            ThreadUtil.sleep(5000L);
            try {
                File root = new File(Configure.getInstance().plugin_dir);
                this.reloadIfModified(root);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void reloadIfModified(File root) {
        File scriptFile = new File(root, "alert.plug");
        if (!scriptFile.canRead()) {
            PlugInManager.alerts = null;
        } else if (PlugInManager.alerts == null || PlugInManager.alerts.lastModified != scriptFile.lastModified()) {
            PlugInManager.alerts = (IAlert)this.create(scriptFile, "AlertImpl", IAlert.class, AlertPack.class);
        }
        scriptFile = new File(root, "counter.plug");
        if (!scriptFile.canRead()) {
            PlugInManager.counters = null;
        } else if (PlugInManager.counters == null || PlugInManager.counters.lastModified != scriptFile.lastModified()) {
            PlugInManager.counters = (ICounter)this.create(scriptFile, "CounterImpl", ICounter.class, PerfCounterPack.class);
        }
        scriptFile = new File(root, "object.plug");
        if (!scriptFile.canRead()) {
            PlugInManager.objects = null;
        } else if (PlugInManager.objects == null || PlugInManager.objects.lastModified != scriptFile.lastModified()) {
            PlugInManager.objects = (IObject)this.create(scriptFile, "ObjectImpl", IObject.class, ObjectPack.class);
        }
        scriptFile = new File(root, "xlog.plug");
        if (!scriptFile.canRead()) {
            PlugInManager.xlog = null;
        } else if (PlugInManager.xlog == null || PlugInManager.xlog.lastModified != scriptFile.lastModified()) {
            PlugInManager.xlog = (IXLog)this.create(scriptFile, "XLogImpl", IXLog.class, XLogPack.class);
        }
        scriptFile = new File(root, "xlogdb.plug");
        if (!scriptFile.canRead()) {
            PlugInManager.xlogdb = null;
        } else if (PlugInManager.xlogdb == null || PlugInManager.xlogdb.lastModified != scriptFile.lastModified()) {
            PlugInManager.xlogdb = (IXLog)this.create(scriptFile, "XLogDBImpl", IXLog.class, XLogPack.class);
        }
        scriptFile = new File(root, "xlogprofile.plug");
        if (!scriptFile.canRead()) {
            PlugInManager.xlogProfiles = null;
        } else if (PlugInManager.xlogProfiles == null || PlugInManager.xlogProfiles.lastModified != scriptFile.lastModified()) {
            PlugInManager.xlogProfiles = (IXLogProfile)this.create(scriptFile, "XLogProfileImpl", IXLogProfile.class, XLogProfilePack.class);
        }
        scriptFile = new File(root, "summary.plug");
        if (!scriptFile.canRead()) {
            PlugInManager.summary = null;
        } else if (PlugInManager.summary == null || PlugInManager.summary.lastModified != scriptFile.lastModified()) {
            PlugInManager.summary = (ISummary)this.create(scriptFile, "SummaryImpl", ISummary.class, SummaryPack.class);
        }
    }

    private IPlugIn create(File file, String className, Class superClass, Class paramClass) {
        long fileSignature = this.fileSign(file);
        if (this.compileErrorFiles.contains(fileSignature)) {
            return null;
        }
        try {
            String methodName = "process";
            String superName = superClass.getName();
            String signature = "(" + this.nativeName(paramClass) + ")V";
            String parameter = paramClass.getName();
            String body = new String(FileUtil.readAll(file));
            ClassPool cp = ClassPool.getDefault();
            if (this.getClass().getClassLoader() instanceof URLClassLoader) {
                URLClassLoader u = (URLClassLoader)this.getClass().getClassLoader();
                URL[] urls = u.getURLs();
                for (int i = 0; urls != null && i < urls.length; ++i) {
                    cp.appendClassPath(urls[i].getFile());
                }
            }
            className = "scouter.server.plugin.impl." + className;
            Class c = null;
            CtClass cc = cp.get(superName);
            CtClass impl = null;
            CtMethod method = null;
            try {
                impl = cp.get(className);
                impl.defrost();
                method = impl.getMethod(methodName, signature);
            }
            catch (NotFoundException e) {
                impl = cp.makeClass(className, cc);
                method = CtNewMethod.make((String)("public void " + methodName + "(" + parameter + " p){}"), (CtClass)impl);
                impl.addMethod(method);
            }
            method.setBody("{" + parameter + " $pack=$1;" + body + "\n}");
            c = impl.toClass((ClassLoader)new URLClassLoader(new URL[0], this.getClass().getClassLoader()), null);
            IPlugIn plugin = (IPlugIn)c.newInstance();
            plugin.lastModified = file.lastModified();
            Logger.println("PLUG-IN : " + superClass.getName() + " loaded #" + Hexa32.toString32(plugin.hashCode()));
            return plugin;
        }
        catch (CannotCompileException ee) {
            this.compileErrorFiles.add(fileSignature);
            Logger.println("S215", ee.getMessage());
        }
        catch (Exception e) {
            Logger.println("S216", e);
        }
        return null;
    }

    private long fileSign(File f) {
        if (f == null) {
            return 0L;
        }
        String filename = f.getName();
        long filetime = f.lastModified();
        return BitUtil.setHigh(filetime, HashUtil.hash(filename));
    }

    private String nativeName(Class class1) {
        return "L" + class1.getName().replace('.', '/') + ";";
    }

    protected int getInt(Properties p, String key, int defValue) {
        String value = StringUtil.trimEmpty(p.getProperty(key));
        if (value.length() == 0) {
            return defValue;
        }
        return CastUtil.cint(value);
    }
}

