/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.plugin.alert;

import scouter.lang.CounterKey;
import scouter.lang.value.Value;
import scouter.server.plugin.alert.AlertConf;
import scouter.server.plugin.alert.AlertRule;
import scouter.server.plugin.alert.AlertRuleLoader;
import scouter.server.plugin.alert.RealCounter;
import scouter.util.LinkedMap;

public class AlertEngine {
    static LinkedMap<CounterKey, RealCounter> realTimeMap = new LinkedMap().setMax(3000);

    public static void putRealTime(CounterKey key, Value value) {
        AlertRuleLoader loader = AlertRuleLoader.getInstance();
        AlertRule rule = loader.alertRuleTable.get(key.counter);
        if (rule == null) {
            return;
        }
        RealCounter counter = realTimeMap.get(key);
        if (counter == null) {
            counter = new RealCounter(key);
            AlertConf conf = loader.alertConfTable.get(key.counter);
            if (conf == null) {
                conf = new AlertConf();
            }
            counter.historySize(conf.history_size);
            counter.silentTime(conf.silent_time);
            realTimeMap.put(key, counter);
        }
        counter.value(value);
        rule.process(counter);
        counter.addValueHistory((Number)((Object)value));
    }

    public static void load() {
        AlertRuleLoader.getInstance();
    }
}

