/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.plugin.alert;

import java.util.Map;
import scouter.lang.CounterKey;
import scouter.lang.pack.ObjectPack;
import scouter.lang.value.Value;
import scouter.server.core.AgentManager;
import scouter.server.core.cache.CounterCache;
import scouter.server.plugin.alert.AlertUtil;
import scouter.util.IntLongLinkedMap;
import scouter.util.LongEnumer;
import scouter.util.LongKeyLinkedMap;

public class RealCounter {
    private Value _value;
    private long _time;
    private LongKeyLinkedMap<Number> _history;
    private IntLongLinkedMap _lastAlertTime;
    private String _objType;
    private String _objName;
    private int _silentTime;
    private int _objHash;
    private String _counter;
    private byte _timetype;

    public RealCounter(CounterKey key) {
        this._objHash = key.objHash;
        this._counter = key.counter;
        this._timetype = key.timetype;
    }

    public String counter() {
        return this._counter;
    }

    public int objHash() {
        return this._objHash;
    }

    public String objName() {
        if (this._objName != null) {
            return this._objName;
        }
        ObjectPack a = AgentManager.getAgent(this._objHash);
        if (a != null && a.objName != null) {
            this._objName = a.objName;
        }
        return this._objName;
    }

    public String objType() {
        ObjectPack a = AgentManager.getAgent(this._objHash);
        if (a == null) {
            return this._objType;
        }
        if (a.objType != null) {
            this._objType = a.objType;
        }
        return this._objType;
    }

    public void value(Value v) {
        this._value = v;
        this._time = System.currentTimeMillis();
    }

    public int intValue() {
        if (this._value instanceof Number) {
            return ((Number)((Object)this._value)).intValue();
        }
        return 0;
    }

    public float floatValue() {
        if (this._value instanceof Number) {
            return ((Number)((Object)this._value)).floatValue();
        }
        return 0.0f;
    }

    public int historySize() {
        return this._history == null ? 0 : this._history.size();
    }

    public int overCount(int value, int sec) {
        return this.overCount((float)value, sec);
    }

    public int overCount(float value, int sec) {
        long tm;
        if (this.historySize() == 0) {
            return 0;
        }
        long from = System.currentTimeMillis() - (long)sec * 1000L;
        int cnt = 0;
        LongEnumer en = this._history.keys();
        while (en.hasMoreElements() && (tm = en.nextLong()) >= from) {
            Number val = this._history.get(tm);
            if (!(val.floatValue() >= value)) continue;
            ++cnt;
        }
        return cnt;
    }

    public long historyOldestTime() {
        if (this.historySize() == 0) {
            return 0L;
        }
        long tm = this._history.getLastKey();
        long now = System.currentTimeMillis();
        return (now - tm) / 1000L;
    }

    public int historyCount(int sec) {
        long tm;
        if (this.historySize() == 0) {
            return 0;
        }
        long from = System.currentTimeMillis() - (long)sec * 1000L;
        int cnt = 0;
        LongEnumer en = this._history.keys();
        while (en.hasMoreElements() && (tm = en.nextLong()) >= from) {
            ++cnt;
        }
        return cnt;
    }

    public static void main(String[] args) {
        LongKeyLinkedMap<String> m = new LongKeyLinkedMap<String>();
        m.putLast(10L, "10");
        m.putLast(20L, "20");
    }

    public void setAlertTime(byte level, long time) {
        if (this._lastAlertTime == null) {
            this._lastAlertTime = new IntLongLinkedMap().setMax(10);
        }
        this._lastAlertTime.put(level, time);
    }

    public void historySize(int size) {
        if (size <= 0) {
            this._history = null;
        } else {
            if (this._history == null) {
                this._history = new LongKeyLinkedMap();
            }
            this._history.setMax(size);
        }
    }

    public void addValueHistory(Number value) {
        if (this._history == null) {
            return;
        }
        long time = System.currentTimeMillis();
        this._history.putFirst(time, value);
    }

    public void silentTime(int sec) {
        this._silentTime = sec;
    }

    public int silentTime() {
        return this._silentTime;
    }

    public long lastAlertTime(int level) {
        if (this._lastAlertTime == null) {
            return 0L;
        }
        return this._lastAlertTime.get(level);
    }

    public void info(String title, String message) {
        AlertUtil.alert((byte)0, this, title, message);
    }

    public void warning(String title, String message) {
        AlertUtil.alert((byte)1, this, title, message);
    }

    public void error(String title, String message) {
        AlertUtil.alert((byte)2, this, title, message);
    }

    public void fatal(String title, String message) {
        AlertUtil.alert((byte)3, this, title, message);
    }

    public String counterNames() {
        Map<String, Value> m = CounterCache.getObjectCounters(this._objHash, (byte)1);
        if (m == null) {
            return "[]";
        }
        return m.keySet().toString();
    }

    public float floatValue(String counter) {
        Value v = CounterCache.get(new CounterKey(this._objHash, counter, this._timetype));
        if (v instanceof Number) {
            return ((Number)((Object)v)).floatValue();
        }
        return 0.0f;
    }

    public int intValue(String counter) {
        Value v = CounterCache.get(new CounterKey(this._objHash, counter, this._timetype));
        if (v instanceof Number) {
            return ((Number)((Object)v)).intValue();
        }
        return 0;
    }
}

