/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.tagcnt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;
import scouter.lang.value.Value;
import scouter.server.tagcnt.TagCountConfig;
import scouter.server.tagcnt.core.TagCountUtil$;
import scouter.server.tagcnt.core.Top100FileCache$;
import scouter.server.tagcnt.core.ValueCount;
import scouter.server.tagcnt.core.ValueCountTotal;
import scouter.server.tagcnt.first.FirstTCData;
import scouter.server.tagcnt.first.FirstTagCountDB$;
import scouter.server.tagcnt.next.NextTagCountDB$;
import scouter.server.util.EnumerScala$;
import scouter.util.BitUtil;
import scouter.util.CastUtil;
import scouter.util.HashUtil;
import scouter.util.LongEnumer;
import scouter.util.LongKeyMap;

public final class TagCountProxy$ {
    public static final TagCountProxy$ MODULE$;

    static {
        new TagCountProxy$();
    }

    public ValueCountTotal getTagValueCountWithCache(String date, String objType2, String tagGroup, String tagName, int limit) {
        long tagKey = BitUtil.composite(HashUtil.hash(tagGroup), tagName == null ? 0 : HashUtil.hash(tagName));
        return this.getTagValueCountWithCache(date, objType2, tagKey, limit);
    }

    public ValueCountTotal getTagValueCountWithCache(String date, String objType2, long tagKey, int limit) {
        ValueCountTotal pack = Top100FileCache$.MODULE$.readTop100Cache(date, objType2, tagKey);
        if (pack == null) {
            return this.getTagValueCount(date, objType2, tagKey, limit);
        }
        return pack;
    }

    public ValueCountTotal getTagValueCount(String date, String objType2, String tagGroup, String tagName, int limit) {
        long tagKey = BitUtil.composite(HashUtil.hash(tagGroup), HashUtil.hash(tagName));
        return this.getTagValueCount(date, objType2, tagKey, limit);
    }

    public ValueCountTotal getTagValueCount(String date, String objType2, long tagKey, int limit) {
        HashMap total = new HashMap();
        FloatRef countPerValue = new FloatRef(0.0f);
        ArrayList<ValueCount> list = new ArrayList<ValueCount>();
        LongKeyMap<Set<Value>> tagmap = FirstTagCountDB$.MODULE$.getTagValues(objType2, date);
        Set<Value> out = tagmap.get(tagKey);
        if (out == null) {
            return new ValueCountTotal(0, 0.0f, list);
        }
        ArrayList<Value> outList = new ArrayList<Value>(out);
        EnumerScala$.MODULE$.foreach(outList.iterator(), new Serializable(date, objType2, tagKey, total){
            public static final long serialVersionUID = 0L;
            private final String date$1;
            private final String objType$1;
            private final long tagKey$1;
            private final HashMap total$1;

            public final float apply(Value v) {
                float[] cnt = FirstTagCountDB$.MODULE$.getTagValueCount(this.objType$1, this.date$1, this.tagKey$1, v);
                return BoxesRunTime.unboxToFloat((Object)this.total$1.put(v, BoxesRunTime.boxToFloat((float)(TagCountUtil$.MODULE$.sum(cnt) + CastUtil.cfloat(this.total$1.get(v))))));
            }
            {
                this.date$1 = date$1;
                this.objType$1 = objType$1;
                this.tagKey$1 = tagKey$1;
                this.total$1 = total$1;
            }
        });
        EnumerScala$.MODULE$.foreach(total.entrySet().iterator(), new Serializable(countPerValue, list){
            public static final long serialVersionUID = 0L;
            private final FloatRef countPerValue$1;
            private final ArrayList list$1;

            public final void apply(Map.Entry<Value, Object> e) {
                float cnt = BoxesRunTime.unboxToFloat((Object)e.getValue());
                this.list$1.add(new ValueCount(e.getKey(), cnt));
                this.countPerValue$1.elem += cnt;
            }
            {
                this.countPerValue$1 = countPerValue$1;
                this.list$1 = list$1;
            }
        });
        Collections.sort(list, new Comparator<ValueCount>(){

            public int compare(ValueCount o1, ValueCount o2) {
                return (int)(o2.valueCount - o1.valueCount);
            }
        });
        return new ValueCountTotal(list.size(), countPerValue.elem, limit <= 0 ? list : list.subList(0, Math.min(list.size(), limit)));
    }

    public float[] getTagValueCountData(String date, String objType2, String tagGroup, String tagName, Value value) {
        long tagKey = BitUtil.composite(HashUtil.hash(tagGroup), HashUtil.hash(tagName));
        float[] values = FirstTagCountDB$.MODULE$.getTagValueCount(objType2, date, tagKey, value);
        if (values != null) {
            return values;
        }
        return NextTagCountDB$.MODULE$.getTagValueCount(date, objType2, tagKey, value);
    }

    public LongKeyMap<ValueCountTotal> getEveryTagTop100Value(String objType2, String date, String tagGroup, int limit) {
        LongKeyMap<ValueCountTotal> map2 = new LongKeyMap<ValueCountTotal>();
        int divHash = HashUtil.hash(tagGroup);
        LongKeyMap<Set<Value>> tagmap = FirstTagCountDB$.MODULE$.getTagValues(objType2, date);
        LongEnumer en = tagmap.keys();
        while (en.hasMoreElements()) {
            Object object;
            long tagName = en.nextLong();
            if (BitUtil.getHigh(tagName) == divHash) {
                int count = tagmap.get(tagName).size();
                ValueCountTotal wrap = null;
                wrap = count >= 100 ? this.getTagValueCountWithCache(date, objType2, tagName, limit) : this.getTagValueCount(date, objType2, tagName, limit);
                object = map2.put(tagName, wrap);
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return map2;
    }

    public void add(long time, String objType2, TagCountConfig.Tag tag, Value tagValue, int cnt) {
        FirstTagCountDB$.MODULE$.add(new FirstTCData(objType2, time, tag.key(), tagValue, cnt));
    }

    public void add(long time, String objType2, TagCountConfig.Tag tag, Value tagValue, float cnt) {
        FirstTagCountDB$.MODULE$.add(new FirstTCData(objType2, time, tag.key(), tagValue, cnt));
    }

    public void add(long time, String objType2, long tagKey, Value tagValue, float cnt) {
        FirstTagCountDB$.MODULE$.add(new FirstTCData(objType2, time, tagKey, tagValue, cnt));
    }

    private TagCountProxy$() {
        MODULE$ = this;
    }
}

