/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.tagcnt.first;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import scala.Function2;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.io.DataInputX;
import scouter.lang.value.Value;
import scouter.server.tagcnt.first.IndexFile;
import scouter.server.tagcnt.first.TagValueEntry$;
import scouter.util.CastUtil;
import scouter.util.IClose;
import scouter.util.IntEnumer;
import scouter.util.IntFloatMap;
import scouter.util.LongEnumer;
import scouter.util.LongKeyMap;

@ScalaSignature(bytes="\u0006\u0001\u0005]t!B\u0001\u0003\u0011\u0003Y\u0011!\u0004+bOZ\u000bG.^3F]R\u0014\u0018P\u0003\u0002\u0004\t\u0005)a-\u001b:ti*\u0011QAB\u0001\u0007i\u0006<7M\u001c;\u000b\u0005\u001dA\u0011AB:feZ,'OC\u0001\n\u0003\u001d\u00198m\\;uKJ\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qBA\u0007UC\u001e4\u0016\r\\;f\u000b:$(/_\n\u0003\u001bA\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007\"B\f\u000e\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\f\u0011\u001dQRB1A\u0005\u0002m\tQ\u0001^1cY\u0016,\u0012\u0001\b\t\u0005;\t\"3&D\u0001\u001f\u0015\ty\u0002%\u0001\u0003vi&d'\"A\u0011\u0002\t)\fg/Y\u0005\u0003Gy\u0011\u0011\u0002S1tQR\f'\r\\3\u0011\u0005\u0015BcBA\t'\u0013\t9##\u0001\u0004Qe\u0016$WMZ\u0005\u0003S)\u0012aa\u0015;sS:<'BA\u0014\u0013!\taAF\u0002\u0003\u000f\u0005\u0001i3c\u0001\u0017/iA\u0011qFM\u0007\u0002a)\u0011\u0011\u0007I\u0001\u0005Y\u0006tw-\u0003\u00024a\t1qJ\u00196fGR\u0004\"!N\u001c\u000e\u0003YR!a\b\u0005\n\u0005a2$AB%DY>\u001cX\r\u0003\u0005;Y\t\u0005\t\u0015!\u0003<\u00035\u0019w.\u001e8uS:<G+\u00192mKB\u0011A\u0002P\u0005\u0003{\t\u0011\u0011\"\u00138eKb4\u0015\u000e\\3\t\u000b]aC\u0011A \u0015\u0005-\u0002\u0005\"\u0002\u001e?\u0001\u0004Y\u0004b\u0002\"-\u0001\u0004%\taQ\u0001\te\u00164'/\u001a8dKV\tA\t\u0005\u0002\u0012\u000b&\u0011aI\u0005\u0002\u0004\u0013:$\bb\u0002%-\u0001\u0004%\t!S\u0001\re\u00164'/\u001a8dK~#S-\u001d\u000b\u0003\u00156\u0003\"!E&\n\u00051\u0013\"\u0001B+oSRDqAT$\u0002\u0002\u0003\u0007A)A\u0002yIEBa\u0001\u0015\u0017!B\u0013!\u0015!\u0003:fMJ,gnY3!\u0011\u001d\u0011FF1A\u0005\u0002M\u000bAAZ5mKV\tA\u0005\u0003\u0004VY\u0001\u0006I\u0001J\u0001\u0006M&dW\r\t\u0005\b/2\u0002\r\u0011\"\u0001Y\u0003\u0019!\u0018mZ7baV\t\u0011\fE\u000265rK!a\u0017\u001c\u0003\u00151{gnZ&fs6\u000b\u0007\u000f\u0005\u0003\u001e;~3\u0017B\u00010\u001f\u0005\ri\u0015\r\u001d\t\u0003A\u0012l\u0011!\u0019\u0006\u0003E\u000e\fQA^1mk\u0016T!!\r\u0005\n\u0005\u0015\f'!\u0002,bYV,\u0007CA\u001bh\u0013\tAgGA\u0006J]R4En\\1u\u001b\u0006\u0004\bb\u00026-\u0001\u0004%\ta[\u0001\u000bi\u0006<W.\u00199`I\u0015\fHC\u0001&m\u0011\u001dq\u0015.!AA\u0002eCaA\u001c\u0017!B\u0013I\u0016a\u0002;bO6\f\u0007\u000f\t\u0005\ba2\u0002\r\u0011\"\u0001r\u0003\u0015!\u0017N\u001d;z+\u0005\u0011\bCA\tt\u0013\t!(CA\u0004C_>dW-\u00198\t\u000fYd\u0003\u0019!C\u0001o\u0006IA-\u001b:us~#S-\u001d\u000b\u0003\u0015bDqAT;\u0002\u0002\u0003\u0007!\u000f\u0003\u0004{Y\u0001\u0006KA]\u0001\u0007I&\u0014H/\u001f\u0011\t\u000bqdC\u0011A?\u0002\u0011M,G\u000fR5sif$\u0012A\u0013\u0005\u0007\u007f2\"\t!!\u0001\u0002\u0015\u001d,G\u000fV1h\u0019&\u001cH\u000f\u0006\u0002\u0002\u0004A)\u0011#!\u0002\u0002\n%\u0019\u0011q\u0001\n\u0003\u000b\u0005\u0013(/Y=\u0011\u0007E\tY!C\u0002\u0002\u000eI\u0011A\u0001T8oO\"9\u0011\u0011\u0003\u0017\u0005\u0002\u0005M\u0011AE4fiZ\u000bG.^3MSN$hi\u001c:UC\u001e$B!!\u0006\u0002\u001cA!Q$a\u0006`\u0013\r\tIB\b\u0002\u0005\u0019&\u001cH\u000f\u0003\u0005\u0002\u001e\u0005=\u0001\u0019AA\u0005\u0003\u001d!\u0018m\u001a(b[\u0016Dq!!\t-\t\u0003\t\u0019#\u0001\bhKR$\u0016m\u001a,bYV,7+\u001a;\u0015\u0005\u0005\u0015\u0002\u0003B\u001b[\u0003O\u0001B!HA\u0015?&\u0019\u00111\u0006\u0010\u0003\u0007M+G\u000f\u0003\u0004\u000201\"I!`\u0001\u0005S:LG\u000f\u0003\u0004\u000241\"\t!`\u0001\re\u0016dw.\u00193UC\u001el\u0015\r\u001d\u0005\u0007\u0003oaC\u0011A?\u0002\tM\fg/\u001a\u0005\b\u0003waC\u0011AA\u001f\u0003\r\tG\r\u001a\u000b\ne\u0006}\u0012\u0011IA#\u0003\u0013B\u0001\"!\b\u0002:\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003\u0007\nI\u00041\u0001`\u0003!!\u0018m\u001a,bYV,\u0007bBA$\u0003s\u0001\r\u0001R\u0001\u0005Q\"lW\u000e\u0003\u0005\u0002L\u0005e\u0002\u0019AA'\u0003\r\u0019g\u000e\u001e\t\u0004#\u0005=\u0013bAA)%\t)a\t\\8bi\"9\u0011Q\u000b\u0017\u0005\u0002\u0005]\u0013\u0001\u00029vg\"$RASA-\u00037B\u0001\"!\b\u0002T\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003\u0007\n\u0019\u00061\u0001`\u0011\u0019\ty\u0006\fC\u0001{\u0006)1\r\\8tK\"9\u00111M\u0007!\u0002\u0013a\u0012A\u0002;bE2,\u0007\u0005C\u0004\u0002h5!\t!!\u001b\u0002\t=\u0004XM\u001c\u000b\u0004W\u0005-\u0004bBA7\u0003K\u0002\raO\u0001\u0005i\u0006<g\u000fC\u0004\u0002`5!\t!!\u001d\u0015\u0007)\u000b\u0019\bC\u0004\u0002v\u0005=\u0004\u0019\u0001\u0013\u0002\t\u0011\fG/\u001a")
public class TagValueEntry
implements IClose {
    private final IndexFile countingTable;
    private int refrence;
    private final String file;
    private LongKeyMap<Map<Value, IntFloatMap>> tagmap;
    private boolean dirty;

    public static TagValueEntry open(IndexFile indexFile) {
        return TagValueEntry$.MODULE$.open(indexFile);
    }

    public static Hashtable<String, TagValueEntry> table() {
        return TagValueEntry$.MODULE$.table();
    }

    public int refrence() {
        return this.refrence;
    }

    public void refrence_$eq(int x$1) {
        this.refrence = x$1;
    }

    public String file() {
        return this.file;
    }

    public LongKeyMap<Map<Value, IntFloatMap>> tagmap() {
        return this.tagmap;
    }

    public void tagmap_$eq(LongKeyMap<Map<Value, IntFloatMap>> x$1) {
        this.tagmap = x$1;
    }

    public boolean dirty() {
        return this.dirty;
    }

    public void dirty_$eq(boolean x$1) {
        this.dirty = x$1;
    }

    public void setDirty() {
        this.dirty_$eq(true);
    }

    public long[] getTagList() {
        this.init();
        return this.tagmap().keyArray();
    }

    public List<Value> getValueListForTag(long tagName) {
        this.init();
        Map<Value, IntFloatMap> valueMap = this.tagmap().get(tagName);
        if (valueMap == null) {
            return new ArrayList<Value>();
        }
        return new ArrayList<Value>(valueMap.keySet());
    }

    public LongKeyMap<Set<Value>> getTagValueSet() {
        this.init();
        LongKeyMap<Set<Value>> out = new LongKeyMap<Set<Value>>();
        LongEnumer itr = this.tagmap().keys();
        while (itr.hasMoreElements()) {
            long key = itr.nextLong();
            Set<Value> value = this.tagmap().get(key).keySet();
            out.put(key, value);
        }
        return out;
    }

    private void init() {
        TagValueEntry tagValueEntry = this;
        synchronized (tagValueEntry) {
            Object object;
            if (this.tagmap() == null) {
                this.tagmap_$eq(new LongKeyMap<Map<Value, IntFloatMap>>());
                object = BoxesRunTime.boxToBoolean((boolean)this.countingTable.read((Function2<byte[], int[], Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ TagValueEntry $outer;

                    public final void apply(byte[] key, int[] data) {
                        DataInputX in = new DataInputX(key);
                        long tagkey = in.readLong();
                        Value tagValue = in.readValue();
                        this.$outer.push(tagkey, tagValue);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            } else {
                object = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public synchronized void reloadTagMap() {
        this.save();
        this.tagmap_$eq(null);
        this.init();
    }

    public synchronized void save() {
        if (this.tagmap() == null) {
            return;
        }
        if (!this.dirty()) {
            return;
        }
        this.dirty_$eq(false);
        long[] keys = this.tagmap().keyArray();
        for (int inx = 0; inx < keys.length; ++inx) {
            long tagkey = keys[inx];
            Map<Value, IntFloatMap> valueMap = this.tagmap().get(tagkey);
            if (valueMap == null) continue;
            for (Value tagValue : valueMap.keySet()) {
                IntFloatMap hmCnt = valueMap.get(tagValue);
                IntEnumer hmItr = hmCnt.keys();
                while (hmItr.hasMoreElements()) {
                    int hhmm = hmItr.nextInt();
                    float count = hmCnt.get(hhmm);
                    this.countingTable.add(tagkey, tagValue, hhmm, count);
                }
                hmCnt.clear();
            }
        }
    }

    public boolean add(long tagName, Value tagValue, int hhmm, float cnt) {
        Object object;
        Object object2;
        this.setDirty();
        this.init();
        Map<Value, IntFloatMap> valueCountMap = this.tagmap().get(tagName);
        if (valueCountMap == null) {
            valueCountMap = new HashMap<Value, IntFloatMap>();
            object2 = this.tagmap().put(tagName, valueCountMap);
        } else {
            object2 = BoxedUnit.UNIT;
        }
        IntFloatMap hmCnt = valueCountMap.get(tagValue);
        if (hmCnt == null) {
            if (valueCountMap.size() >= 100) {
                return false;
            }
            hmCnt = new IntFloatMap();
            object = valueCountMap.put(tagValue, hmCnt);
        } else {
            object = BoxedUnit.UNIT;
        }
        hmCnt.put(hhmm, CastUtil.cfloat(BoxesRunTime.boxToFloat((float)hmCnt.get(hhmm))) + cnt);
        return true;
    }

    public void push(long tagName, Value tagValue) {
        Map<Value, IntFloatMap> valueCntMap = this.tagmap().get(tagName);
        if (valueCntMap == null) {
            valueCntMap = new HashMap<Value, IntFloatMap>();
            this.tagmap().put(tagName, valueCntMap);
            valueCntMap.put(tagValue, new IntFloatMap());
            return;
        }
        if (!valueCntMap.containsKey(tagValue)) {
            valueCntMap.put(tagValue, new IntFloatMap());
        }
    }

    @Override
    public void close() {
        Hashtable<String, TagValueEntry> hashtable = TagValueEntry$.MODULE$.table();
        synchronized (hashtable) {
            TagValueEntry tagValueEntry;
            if (this.refrence() == 0) {
                this.save();
                tagValueEntry = TagValueEntry$.MODULE$.table().remove(this.file());
            } else {
                this.refrence_$eq(this.refrence() - 1);
                tagValueEntry = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public TagValueEntry(IndexFile countingTable) {
        this.countingTable = countingTable;
        this.refrence = 0;
        this.file = countingTable.path();
        this.tagmap = null;
        this.dirty = false;
    }
}

