/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.test;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import scouter.util.FileUtil;

public class LoadTest {
    private static Random rand = new Random();
    private static List<String> cookies = new ArrayList<String>();

    public static void main(String[] args) throws Throwable {
        ExecutorService ex = Executors.newCachedThreadPool();
        final String url = args.length == 0 ? "http://127.0.0.1:8080" : args[0];
        Runnable r = new Runnable(){

            public void run() {
                try {
                    LoadTest.process(url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        while (true) {
            ex.execute(r);
            r.run();
        }
    }

    private static void process(String arg) throws Exception {
        long stime = System.currentTimeMillis();
        try {
            URL u = new URL(arg);
            URLConnection uc = u.openConnection();
            String uu = LoadTest.setUser(uc);
            uc.connect();
            InputStream o = uc.getInputStream();
            FileUtil.readAll(o);
            Map<String, List<String>> heads = uc.getHeaderFields();
            List<String> cookie = heads.get("Set-Cookie");
            LoadTest.keepCookie("" + cookie);
            o.close();
            long dur = System.currentTimeMillis() - stime;
            System.out.println(arg + " " + dur + " ms " + uu);
        }
        catch (Exception e) {
            long dur = System.currentTimeMillis() - stime;
            System.out.println(arg + " " + dur + " ms - ERROR");
        }
    }

    private static String setUser(URLConnection uc) {
        if (cookies.size() == 0) {
            return "none";
        }
        if (Math.abs(rand.nextInt()) % 2 == 0) {
            return "none";
        }
        int x = Math.abs(rand.nextInt()) % cookies.size();
        uc.addRequestProperty("Cookie", "SCOUTER=" + cookies.get(x));
        return "SCOUTER=" + cookies.get(x);
    }

    private static void keepCookie(String cookie) {
        if (cookie == null) {
            return;
        }
        int x1 = cookie.indexOf("SCOUTER");
        if (x1 >= 0) {
            String value = null;
            int x2 = cookie.indexOf(59, x1);
            value = x2 > 0 ? cookie.substring(x1 + "SCOUTER".length() + 1, x2) : cookie.substring(x1 + "SCOUTER".length() + 1);
            cookies.add(value);
            System.out.println("SCOUTER=" + value);
        }
        if (cookies.size() > 1000000) {
            cookies.clear();
        }
    }
}

