/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.util;

import scala.Function1;
import scala.Function2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scouter.server.util.BinSearch$;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u0013\tI!)\u001b8TK\u0006\u00148\r\u001b\u0006\u0003\u0007\u0011\tA!\u001e;jY*\u0011QAB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u001d\tqa]2pkR,'o\u0001\u0001\u0016\u0005)i2C\u0001\u0001\f!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fM\"A!\u0003\u0001B\u0001B\u0003%1#\u0001\u0004mK:<G\u000f\u001b\t\u0003\u0019QI!!F\u0007\u0003\t1{gn\u001a\u0005\t/\u0001\u0011\t\u0011)A\u00051\u0005!A-\u0019;b!\u0011a\u0011dE\u000e\n\u0005ii!!\u0003$v]\u000e$\u0018n\u001c82!\taR\u0004\u0004\u0001\u0005\u000by\u0001!\u0019A\u0010\u0003\u0003Q\u000b\"\u0001I\u0012\u0011\u00051\t\u0013B\u0001\u0012\u000e\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u0004\u0013\n\u0005\u0015j!aA!os\"Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\u0003d_6\u0004\b#\u0002\u0007*7mY\u0013B\u0001\u0016\u000e\u0005%1UO\\2uS>t'\u0007\u0005\u0002\rY%\u0011Q&\u0004\u0002\u0004\u0013:$\b\"B\u0018\u0001\t\u0003\u0001\u0014A\u0002\u001fj]&$h\b\u0006\u00032gQ*\u0004c\u0001\u001a\u000175\t!\u0001C\u0003\u0013]\u0001\u00071\u0003C\u0003\u0018]\u0001\u0007\u0001\u0004C\u0003(]\u0001\u0007\u0001\u0006C\u00048\u0001\t\u0007I\u0011\u0002\u001d\u0002\t9{e*R\u000b\u0002W!1!\b\u0001Q\u0001\n-\nQAT(O\u000b\u0002Bq\u0001\u0010\u0001C\u0002\u0013%\u0001(\u0001\u0002M\u000b\"1a\b\u0001Q\u0001\n-\n1\u0001T#!\u0011\u001d\u0001\u0005A1A\u0005\na\n!!R)\t\r\t\u0003\u0001\u0015!\u0003,\u0003\r)\u0015\u000b\t\u0005\b\t\u0002\u0011\r\u0011\"\u00039\u0003\t\u0011U\t\u0003\u0004G\u0001\u0001\u0006IaK\u0001\u0004\u0005\u0016\u0003\u0003\"\u0002%\u0001\t\u0003I\u0015AB:fCJ\u001c\u0007\u000e\u0006\u0002\u0014\u0015\")1j\u0012a\u00017\u00051A/\u0019:hKRDQ!\u0014\u0001\u0005\u00029\u000b\u0001b]3be\u000eDG*\u0012\u000b\u0003'=CQa\u0013'A\u0002mAQ!\u0015\u0001\u0005\u0002I\u000b\u0001b]3be\u000eD')\u0012\u000b\u0003'MCQa\u0013)A\u0002mAQ\u0001\u0013\u0001\u0005\nU#2a\u0005,X\u0011\u0015YE\u000b1\u0001\u001c\u0011\u0015AF\u000b1\u0001,\u0003\u0011iw\u000eZ3\b\u000bi\u0013\u0001\u0012A.\u0002\u0013\tKgnU3be\u000eD\u0007C\u0001\u001a]\r\u0015\t!\u0001#\u0001^'\ta6\u0002C\u000309\u0012\u0005q\fF\u0001\\\u0011\u0015\tG\f\"\u0001c\u0003\u0011i\u0017-\u001b8\u0015\u0005\r4\u0007C\u0001\u0007e\u0013\t)WB\u0001\u0003V]&$\b\"B4a\u0001\u0004A\u0017\u0001B1sON\u00042\u0001D5l\u0013\tQWBA\u0003BeJ\f\u0017\u0010\u0005\u0002m_:\u0011A\"\\\u0005\u0003]6\ta\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\u0019\u0019FO]5oO*\u0011a.\u0004\u0005\u0006gr#I\u0001^\u0001\u0004aJ$HcA2vq\")aO\u001da\u0001o\u0006\t!\rE\u00023\u0001-BQ!\u001f:A\u0002-\n\u0011!\u0019")
public class BinSearch<T> {
    private final long length;
    private final Function1<Object, T> data;
    private final Function2<T, T, Object> comp;
    private final int NONE;
    private final int LE;
    private final int EQ;
    private final int BE;

    public static void main(String[] stringArray) {
        BinSearch$.MODULE$.main(stringArray);
    }

    private int NONE() {
        return this.NONE;
    }

    private int LE() {
        return this.LE;
    }

    private int EQ() {
        return this.EQ;
    }

    private int BE() {
        return this.BE;
    }

    public long search(T target) {
        return this.search(target, this.EQ());
    }

    public long searchLE(T target) {
        return this.search(target, this.LE());
    }

    public long searchBE(T target) {
        return this.search(target, this.BE());
    }

    private long search(T target, int mode) {
        long low = 0L;
        long high = this.length - 1L;
        while (high >= low) {
            long mid = (low + high) / 2L;
            Object midData = this.data.apply((Object)BoxesRunTime.boxToLong((long)mid));
            if (BoxesRunTime.unboxToInt((Object)this.comp.apply(midData, target)) < 0) {
                high = mid - 1L;
                continue;
            }
            if (BoxesRunTime.unboxToInt((Object)this.comp.apply(midData, target)) > 0) {
                low = mid + 1L;
                continue;
            }
            return mid;
        }
        int n = mode;
        switch (n) {
            default: {
                return this.NONE();
            }
            case 1: {
                if (low >= this.length) break;
                return low;
            }
            case -1: {
                if (high < 0L) break;
                return high;
            }
        }
        return this.NONE();
    }

    public BinSearch(long length, Function1<Object, T> data, Function2<T, T, Object> comp) {
        this.length = length;
        this.data = data;
        this.comp = comp;
        this.NONE = -1;
        this.LE = -1;
        this.EQ = 0;
        this.BE = 1;
    }
}

