/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.IntEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntIntLinkedMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private IntIntLinkedEntry[] table;
    private IntIntLinkedEntry header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int NONE = 0;
    private int max;

    public IntIntLinkedMap setNullValue(int none) {
        this.NONE = none;
        return this;
    }

    public IntIntLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new IntIntLinkedEntry[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new IntIntLinkedEntry(0, 0, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public IntIntLinkedMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public int[] keyArray() {
        int[] _keys = new int[this.size()];
        IntEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextInt();
        }
        return _keys;
    }

    public synchronized IntEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized IntEnumer values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<IntIntLinkedEntry> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(int value) {
        IntIntLinkedEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            IntIntLinkedEntry e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.hash_next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int key) {
        IntIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.hash_next;
        }
        return false;
    }

    public synchronized int get(int key) {
        IntIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.hash_next;
        }
        return this.NONE;
    }

    public synchronized int getFirstKey() {
        return this.header.link_next.key;
    }

    public synchronized int getLastKey() {
        return this.header.link_prev.key;
    }

    public synchronized int getFirstValue() {
        return this.header.link_next.value;
    }

    public synchronized int getLastValue() {
        return this.header.link_prev.value;
    }

    private int hash(int key) {
        return key & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntIntLinkedEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntIntLinkedEntry[] newMap = new IntIntLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            IntIntLinkedEntry old = oldMap[i];
            while (old != null) {
                IntIntLinkedEntry e = old;
                old = old.hash_next;
                int key = e.key;
                int index = this.hash(key) % newCapacity;
                e.hash_next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public IntIntLinkedMap setMax(int max) {
        this.max = max;
        return this;
    }

    public int put(int key, int value) {
        return this._put(key, value, MODE.LAST);
    }

    public int putLast(int key, int value) {
        return this._put(key, value, MODE.FORCE_LAST);
    }

    public int putFirst(int key, int value) {
        return this._put(key, value, MODE.FORCE_FIRST);
    }

    public int add(int key, int value) {
        return this._add(key, value, MODE.LAST);
    }

    public int addLast(int key, int value) {
        return this._add(key, value, MODE.FORCE_LAST);
    }

    public int addFirst(int key, int value) {
        return this._add(key, value, MODE.FORCE_FIRST);
    }

    private synchronized int _put(int key, int value, MODE m) {
        IntIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                int old = e.value;
                e.value = value;
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.hash_next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    while (this.count >= this.max) {
                        int k = this.header.link_prev.key;
                        int v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    while (this.count >= this.max) {
                        int k = this.header.link_next.key;
                        int v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new IntIntLinkedEntry(key, value, tab[index]);
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    protected void overflowed(int key, int value) {
    }

    private synchronized int _add(int key, int value, MODE m) {
        IntIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                e.value += value;
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return e.value;
            }
            e = e.hash_next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    while (this.count >= this.max) {
                        int k = this.header.link_prev.key;
                        int v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    while (this.count >= this.max) {
                        int k = this.header.link_next.key;
                        int v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new IntIntLinkedEntry(key, value, tab[index]);
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return value;
    }

    public synchronized int remove(int key) {
        IntIntLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntLinkedEntry e = tab[index];
        IntIntLinkedEntry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.hash_next = e.hash_next;
                } else {
                    tab[index] = e.hash_next;
                }
                --this.count;
                int oldValue = e.value;
                e.value = this.NONE;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.hash_next;
        }
        return this.NONE;
    }

    public synchronized int removeFirst() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized int removeLast() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        IntIntLinkedEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_next = this.header;
        this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntIntLinkedEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            IntIntLinkedEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntIntLinkedEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            IntIntLinkedEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(IntIntLinkedEntry link_prev, IntIntLinkedEntry link_next, IntIntLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(IntIntLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public synchronized void sort(Comparator<IntIntLinkedEntry> c) {
        ArrayList<IntIntLinkedEntry> list = new ArrayList<IntIntLinkedEntry>(this.size());
        Enumeration<IntIntLinkedEntry> en = this.entries();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        Collections.sort(list, c);
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            IntIntLinkedEntry e = (IntIntLinkedEntry)list.get(i);
            this.put(e.getKey(), e.getValue());
        }
    }

    public static class IntIntLinkedEntry {
        int key;
        int value;
        IntIntLinkedEntry hash_next;
        IntIntLinkedEntry link_next;
        IntIntLinkedEntry link_prev;

        protected IntIntLinkedEntry(int key, int value, IntIntLinkedEntry next) {
            this.key = key;
            this.value = value;
            this.hash_next = next;
        }

        protected Object clone() {
            return new IntIntLinkedEntry(this.key, this.value, this.hash_next == null ? null : (IntIntLinkedEntry)this.hash_next.clone());
        }

        public int getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public int setValue(int value) {
            int oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntIntLinkedEntry)) {
                return false;
            }
            IntIntLinkedEntry e = (IntIntLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumer<V>
    implements Enumeration,
    IntEnumer {
        TYPE type;
        IntIntLinkedEntry entry;

        Enumer(TYPE type) {
            this.entry = ((IntIntLinkedMap)IntIntLinkedMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return this.entry != null && IntIntLinkedMap.this.header != this.entry;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                IntIntLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public int nextInt() {
            if (this.hasMoreElements()) {
                IntIntLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
            }
            throw new NoSuchElementException("no more next");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

