/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.IntEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntIntMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private IntIntEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    private int NONE = 0;

    public IntIntMap setNullValue(int none) {
        this.NONE = none;
        return this;
    }

    public IntIntMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new IntIntEntry[initCapacity];
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public IntIntMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public synchronized IntEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized IntEnumer values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<IntIntEntry> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(int value) {
        IntIntEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            IntIntEntry e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int key) {
        IntIntEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    private int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        h = h ^ h >>> 7 ^ h >>> 4;
        return h & Integer.MAX_VALUE;
    }

    public synchronized int get(int key) {
        IntIntEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return this.NONE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntIntEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntIntEntry[] newMap = new IntIntEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            IntIntEntry old = oldMap[i];
            while (old != null) {
                IntIntEntry e = old;
                old = old.next;
                int index = this.hash(e.key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized int[] keyArray() {
        int[] _keys = new int[this.size()];
        IntEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextInt();
        }
        return _keys;
    }

    public synchronized int[] valueArray() {
        int[] _values = new int[this.size()];
        IntEnumer en = this.values();
        for (int i = 0; i < _values.length; ++i) {
            _values[i] = en.nextInt();
        }
        return _values;
    }

    public synchronized int put(int key, int value) {
        IntIntEntry[] tab = this.table;
        int _hash = this.hash(key);
        int index = _hash % tab.length;
        IntIntEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                int old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = _hash % tab.length;
        }
        tab[index] = e = new IntIntEntry(key, value, tab[index]);
        ++this.count;
        return this.NONE;
    }

    public synchronized int add(int key, int value) {
        IntIntEntry[] tab = this.table;
        int _hash = this.hash(key);
        int index = _hash % tab.length;
        IntIntEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                int old = e.value;
                e.value += value;
                return e.value;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = _hash % tab.length;
        }
        tab[index] = e = new IntIntEntry(key, value, tab[index]);
        ++this.count;
        return value;
    }

    public synchronized int remove(int key) {
        IntIntEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntIntEntry e = tab[index];
        IntIntEntry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                int oldValue = e.value;
                e.value = this.NONE;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized void clear() {
        IntIntEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntIntEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            IntIntEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntIntEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            IntIntEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    public void putAll(IntIntMap other) {
        Enumeration<IntIntEntry> it = other.entries();
        int max = other.size();
        for (int i = 0; i <= max; ++i) {
            IntIntEntry e = it.nextElement();
            this.put(e.getKey(), e.getValue());
        }
    }

    public static class IntIntEntry {
        int key;
        int value;
        IntIntEntry next;

        protected IntIntEntry(int key, int value, IntIntEntry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new IntIntEntry(this.key, this.value, this.next == null ? null : (IntIntEntry)this.next.clone());
        }

        public int getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public int setValue(int value) {
            int oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntIntEntry)) {
                return false;
            }
            IntIntEntry e = (IntIntEntry)o;
            return this.key == e.getKey() && this.value == e.getValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class Enumer
    implements Enumeration,
    IntEnumer {
        IntIntEntry[] table;
        int index;
        IntIntEntry entry;
        IntIntEntry lastReturned;
        TYPE type;

        Enumer(TYPE type) {
            this.table = IntIntMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.type = type;
        }

        public boolean hasMoreElements() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        public Object nextElement() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                IntIntEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        public int nextInt() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                IntIntEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return IntIntMap.this.NONE;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }
}

