/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.IntEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntKeyLinkedMap<V> {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private IntKeyLinkedEntry<V>[] table;
    private IntKeyLinkedEntry<V> header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int max;

    public IntKeyLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new IntKeyLinkedEntry[initCapacity];
        this.header = new IntKeyLinkedEntry<Object>(0, null, null);
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public IntKeyLinkedMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public int[] keyArray() {
        int[] _keys = new int[this.size()];
        IntEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextInt();
        }
        return _keys;
    }

    public synchronized IntEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized Enumeration<V> values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<IntKeyLinkedEntry<V>> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        IntKeyLinkedEntry<V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            IntKeyLinkedEntry<V> e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int key) {
        IntKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized V get(int key) {
        IntKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public synchronized int getFirstKey() {
        return this.header.link_next.key;
    }

    public synchronized int getLastKey() {
        return this.header.link_prev.key;
    }

    public synchronized V getFirstValue() {
        return this.header.link_next.value;
    }

    public synchronized V getLastValue() {
        return this.header.link_prev.value;
    }

    protected void overflowed(int key, V value) {
    }

    protected V create(int key) {
        throw new RuntimeException("not implemented create()");
    }

    public V intern(int key) {
        return this._intern(key, MODE.LAST);
    }

    private synchronized V _intern(int key, MODE m) {
        IntKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        V value = this.create(key);
        if (value == null) {
            return null;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    int k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    int k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        IntKeyLinkedEntry<V> e2 = new IntKeyLinkedEntry<V>(key, value, tab[index]);
        tab[index] = e2;
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e2);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e2);
            }
        }
        ++this.count;
        return value;
    }

    private int hash(int key) {
        return key & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntKeyLinkedEntry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntKeyLinkedEntry[] newMap = new IntKeyLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            IntKeyLinkedEntry<V> old = oldMap[i];
            while (old != null) {
                IntKeyLinkedEntry<V> e = old;
                old = old.next;
                int key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public IntKeyLinkedMap<V> setMax(int max) {
        this.max = max;
        return this;
    }

    public V put(int key, V value) {
        return this._put(key, value, MODE.LAST);
    }

    public V putLast(int key, V value) {
        return this._put(key, value, MODE.FORCE_LAST);
    }

    public V putFirst(int key, V value) {
        return this._put(key, value, MODE.FORCE_FIRST);
    }

    private synchronized V _put(int key, V value, MODE m) {
        IntKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                Object old = e.value;
                e.value = value;
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    while (this.count >= this.max) {
                        int k = this.header.link_prev.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    while (this.count >= this.max) {
                        int k = this.header.link_next.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new IntKeyLinkedEntry<V>(key, value, tab[index]);
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return null;
    }

    public synchronized V remove(int key) {
        IntKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntKeyLinkedEntry<V> e = tab[index];
        IntKeyLinkedEntry<V> prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized V removeFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized V removeLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        IntKeyLinkedEntry<V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntKeyLinkedEntry<V>> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            IntKeyLinkedEntry<V> e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntKeyLinkedEntry<V>> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            IntKeyLinkedEntry<V> e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(IntKeyLinkedEntry link_prev, IntKeyLinkedEntry link_next, IntKeyLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(IntKeyLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public synchronized void sort(Comparator<IntKeyLinkedEntry<V>> c) {
        ArrayList<IntKeyLinkedEntry<V>> list = new ArrayList<IntKeyLinkedEntry<V>>(this.size());
        Enumeration<IntKeyLinkedEntry<V>> en = this.entries();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        Collections.sort(list, c);
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            IntKeyLinkedEntry e = (IntKeyLinkedEntry)list.get(i);
            this.put(e.getKey(), e.getValue());
        }
    }

    public static void main(String[] args) {
        IntKeyLinkedMap<Integer> m = new IntKeyLinkedMap<Integer>();
        for (int i = 0; i < 10; ++i) {
            m.put(i, i);
        }
        System.out.println(m);
        m.sort(new Comparator<IntKeyLinkedEntry<Integer>>(){

            @Override
            public int compare(IntKeyLinkedEntry<Integer> o1, IntKeyLinkedEntry<Integer> o2) {
                return CompareUtil.compareTo(Integer.valueOf(o2.getKey()), Integer.valueOf(o1.getKey()));
            }
        });
        System.out.println(m);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntKeyLinkedEntry<V> {
        int key;
        V value;
        IntKeyLinkedEntry<V> next;
        IntKeyLinkedEntry<V> link_next;
        IntKeyLinkedEntry<V> link_prev;

        protected IntKeyLinkedEntry(int key, V value, IntKeyLinkedEntry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new IntKeyLinkedEntry<V>(this.key, this.value, this.next == null ? null : (IntKeyLinkedEntry)this.next.clone());
        }

        public int getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntKeyLinkedEntry)) {
                return false;
            }
            IntKeyLinkedEntry e = (IntKeyLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumer<V>
    implements Enumeration,
    IntEnumer {
        TYPE type;
        IntKeyLinkedEntry entry;

        Enumer(TYPE type) {
            this.entry = ((IntKeyLinkedMap)IntKeyLinkedMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return IntKeyLinkedMap.this.header != this.entry && this.entry != null;
        }

        public V nextElement() {
            if (this.hasMoreElements()) {
                IntKeyLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case KEYS: {
                        return (V)new Long(e.key);
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return (V)e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public int nextInt() {
            if (this.hasMoreElements()) {
                IntKeyLinkedEntry e = this.entry;
                this.entry = e.link_next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

