/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.IntEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntKeyMap<V> {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private IntKeyEntry<V>[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public IntKeyMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new IntKeyEntry[initCapacity];
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public IntKeyMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public synchronized IntEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized Enumeration<V> values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<IntKeyEntry<V>> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(V value) {
        if (value == null) {
            return false;
        }
        IntKeyEntry<V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            IntKeyEntry<V> e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int key) {
        IntKeyEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntKeyEntry<V> e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    private int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        h = h ^ h >>> 7 ^ h >>> 4;
        return h & Integer.MAX_VALUE;
    }

    public synchronized V get(int key) {
        IntKeyEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntKeyEntry<V> e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntKeyEntry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntKeyEntry[] newMap = new IntKeyEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            IntKeyEntry<V> old = oldMap[i];
            while (old != null) {
                IntKeyEntry<V> e = old;
                old = old.next;
                int index = this.hash(e.key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized int[] keyArray() {
        int[] _keys = new int[this.size()];
        IntEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextInt();
        }
        return _keys;
    }

    public synchronized V put(int key, V value) {
        IntKeyEntry<V>[] tab = this.table;
        int _hash = this.hash(key);
        int index = _hash % tab.length;
        IntKeyEntry<V> e = tab[index];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = _hash % tab.length;
        }
        tab[index] = e = new IntKeyEntry<V>(key, value, tab[index]);
        ++this.count;
        return null;
    }

    public synchronized V remove(int key) {
        IntKeyEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntKeyEntry<V> e = tab[index];
        IntKeyEntry<V> prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void clear() {
        IntKeyEntry<V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntKeyEntry<V>> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            IntKeyEntry<V> e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntKeyEntry<V>> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            IntKeyEntry<V> e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    public void putAll(IntKeyMap<V> other) {
        Enumeration<IntKeyEntry<V>> it = other.entries();
        int max = other.size();
        for (int i = 0; i <= max; ++i) {
            IntKeyEntry<V> e = it.nextElement();
            this.put(e.getKey(), e.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntKeyEntry<V> {
        int key;
        V value;
        IntKeyEntry<V> next;

        protected IntKeyEntry(int key, V value, IntKeyEntry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new IntKeyEntry<V>(this.key, this.value, this.next == null ? null : (IntKeyEntry)this.next.clone());
        }

        public int getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntKeyEntry)) {
                return false;
            }
            IntKeyEntry e = (IntKeyEntry)o;
            return this.key == e.getKey() && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value.toString();
        }
    }

    private class Enumer
    implements Enumeration,
    IntEnumer {
        IntKeyEntry[] table;
        int index;
        IntKeyEntry entry;
        IntKeyEntry lastReturned;
        TYPE type;

        Enumer(TYPE type) {
            this.table = IntKeyMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.type = type;
        }

        public boolean hasMoreElements() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        public Object nextElement() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                IntKeyEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        public int nextInt() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                IntKeyEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }
}

