/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.IntEnumer;

public class IntLinkedSet {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private IntLinkedSetry[] table;
    private IntLinkedSetry header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int NONE = 0;
    private int max;

    public IntLinkedSet(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new IntLinkedSetry[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new IntLinkedSetry(0, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public IntLinkedSet() {
        this(101, 0.75f);
    }

    public IntLinkedSet setNullValue(int none) {
        this.NONE = none;
        return this;
    }

    public int size() {
        return this.count;
    }

    public int[] getArray() {
        int[] _keys = new int[this.size()];
        IntEnumer en = this.elements();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextInt();
        }
        return _keys;
    }

    public synchronized IntEnumer elements() {
        return new Enumer();
    }

    public synchronized boolean contains(int key) {
        IntLinkedSetry[] buk = this.table;
        int index = this.hash(key) % buk.length;
        IntLinkedSetry e = buk[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized int getFirst() {
        return this.header.link_next.key;
    }

    public synchronized int getLast() {
        return this.header.link_prev.key;
    }

    private int hash(int key) {
        return key & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntLinkedSetry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntLinkedSetry[] newMap = new IntLinkedSetry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            IntLinkedSetry old = oldMap[i];
            while (old != null) {
                IntLinkedSetry e = old;
                old = old.next;
                int key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public IntLinkedSet setMax(int max) {
        this.max = max;
        return this;
    }

    public int put(int key) {
        return this._put(key, MODE.LAST);
    }

    public int putLast(int key) {
        return this._put(key, MODE.FORCE_LAST);
    }

    public int putFirst(int key) {
        return this._put(key, MODE.FORCE_FIRST);
    }

    private synchronized int _put(int key, MODE m) {
        IntLinkedSetry[] buk = this.table;
        int index = this.hash(key) % buk.length;
        IntLinkedSetry e = buk[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return key;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    while (this.count >= this.max) {
                        int v = this.header.link_prev.key;
                        this.remove(v);
                        this.overflowed(v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    while (this.count >= this.max) {
                        int v = this.header.link_next.key;
                        this.remove(v);
                        this.overflowed(v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            buk = this.table;
            index = this.hash(key) % buk.length;
        }
        buk[index] = e = new IntLinkedSetry(key, buk[index]);
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    protected void overflowed(int value) {
    }

    public synchronized int remove(int key) {
        IntLinkedSetry[] buk = this.table;
        int index = this.hash(key) % buk.length;
        IntLinkedSetry e = buk[index];
        IntLinkedSetry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    buk[index] = e.next;
                }
                --this.count;
                this.unchain(e);
                return key;
            }
            prev = e;
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized int removeFirst() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized int removeLast() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        IntLinkedSetry[] buk = this.table;
        int index = buk.length;
        while (--index >= 0) {
            buk[index] = null;
        }
        this.header.link_next = this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        IntEnumer it = this.elements();
        buf.append("{");
        while (it.hasMoreElements()) {
            if (buf.length() > 1) {
                buf.append(",");
            }
            buf.append(it.nextInt());
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(IntLinkedSetry link_prev, IntLinkedSetry link_next, IntLinkedSetry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(IntLinkedSetry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public synchronized void sort(boolean asc) {
        if (this.size() <= 1) {
            return;
        }
        int[] list = new int[this.size()];
        IntEnumer en = this.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            list[i] = en.nextInt();
            ++i;
        }
        Arrays.sort(list);
        this.clear();
        if (asc) {
            for (int n : list) {
                this.put(n);
            }
        } else {
            for (i = list.length - 1; i >= 0; --i) {
                this.put(list[i]);
            }
        }
    }

    public static void main(String[] args) {
        IntLinkedSet s = new IntLinkedSet();
        s.put(10);
        s.put(20);
        System.out.println(s);
        s.sort(false);
        System.out.println(s);
    }

    public static class IntLinkedSetry {
        int key;
        IntLinkedSetry next;
        IntLinkedSetry link_next;
        IntLinkedSetry link_prev;

        protected IntLinkedSetry(int key, IntLinkedSetry next) {
            this.key = key;
            this.next = next;
        }

        protected Object clone() {
            return new IntLinkedSetry(this.key, this.next == null ? null : (IntLinkedSetry)this.next.clone());
        }

        public int getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntLinkedSetry)) {
                return false;
            }
            IntLinkedSetry e = (IntLinkedSetry)o;
            return CompareUtil.equals(e.key, this.key);
        }

        public int hashCode() {
            return this.key;
        }

        public String toString() {
            return Integer.toString(this.key);
        }
    }

    private class Enumer
    implements IntEnumer {
        IntLinkedSetry entry;

        private Enumer() {
            this.entry = ((IntLinkedSet)IntLinkedSet.this).header.link_next;
        }

        public boolean hasMoreElements() {
            return IntLinkedSet.this.header != this.entry && this.entry != null;
        }

        public int nextInt() {
            if (this.hasMoreElements()) {
                IntLinkedSetry e = this.entry;
                this.entry = e.link_next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

